<?php
final class OfferOutlineDao extends Dao {
  private static $ALL = <<<'SQL'
select offer_code,
       occupation_id,
       category_id,
       content_id
  from offer_outline
 order by offer_code
SQL;
  private static $PK = <<<'SQL'
select offer_code,
       occupation_id,
       category_id,
       content_id
  from offer_outline
 where offer_code = '%s'
   and occupation_id = %s
   and category_id = %s
   and content_id = %s
SQL;
  private static $OFFER_CODE = <<<'SQL'
select oo.offer_code,
       oo.occupation_id,
       oo.category_id,
       oo.content_id,
       (select oc.occupation_name
          from occupation oc
         where oc.occupation_id = oo.occupation_id) as occupation_name,
       (select ca.category_name
          from category ca
         where ca.occupation_id = oo.occupation_id
           and ca.category_id = oo.category_id) as category_name,
       (select co.content_name
          from content co
         where co.occupation_id = oo.occupation_id
           and co.category_id = oo.category_id
           and co.content_id = oo.content_id) as content_name
  from offer_outline oo
 where oo.offer_code = '%s'
SQL;
  private static $DELETE = <<<'SQL'
delete from offer_outline
 where offer_code = '%s'
SQL;
  private static $INSERT = <<<'SQL'
insert into offer_outline
            (offer_code,
             occupation_id,
             category_id,
             content_id)
     values ('%s',
             %s,
             %s,
             %s)
SQL;
  public function getAll() {
    return $this->execute(self::$ALL);
  }
  public function getByPk($pk) {
    return $this->execute(self::$PK, $pk);
  }
  public function getByOfferCode($offerCode) {
    return $this->execute(self::$OFFER_CODE, $offerCode);
  }
  public function delete($offerCode) {
    return $this->execute(self::$DELETE, $offerCode);
  }
  public function insert($offerCode, $occupationId, $categoryId, $contentId) {
    return $this->execute(self::$INSERT, array($offerCode, $occupationId, $categoryId, $contentId));
  }
}
// EOF.
