<?php
final class OfferHoursDao extends Dao {
  private static $ALL = <<<'SQL'
select offer_code,
       start_time,
       start_min,
       end_time,
       end_min
  from offer_hours
 order by offer_code,
       start_time,
       start_min,
       end_time,
       end_min
SQL;
  private static $PK = <<<'SQL'
select offer_code,
       start_time,
       start_min,
       end_time,
       end_min
  from offer_hours
 where offer_code = '%s'
   and start_time = '%s'
   and start_min = '%s'
   and end_time = '%s'
   and end_min = '%s'
SQL;
  private static $OFFER_CODE = <<<'SQL'
select offer_code,
       start_time,
       start_min,
       end_time,
       end_min
  from offer_hours
 where offer_code = '%s'
 order by start_time,
       start_min,
       end_time,
       end_min
SQL;
  private static $DELETE = <<<'SQL'
delete from offer_hours
 where offer_code = '%s'
SQL;
  private static $INSERT = <<<'SQL'
replace into offer_hours
             (offer_code,
              start_time,
              start_min,
              end_time,
              end_min)
      values ('%s',
              '%s',
              '%s',
              '%s',
              '%s')
SQL;
  public function getAll() {
    return $this->execute(self::$ALL);
  }
  public function getByPk($pk) {
    return $this->execute(self::$PK, $pk);
  }
  public function getByOfferCode($offerCode) {
    return $this->execute(self::$OFFER_CODE, $offerCode);
  }
  public function delete($offerCode) {
    return $this->execute(self::$DELETE, $offerCode);
  }
  public function insert($offerCode, $startTime, $startMin, $endTime, $endMin) {
    return $this->execute(self::$INSERT, array($offerCode, $startTime, $startMin, $endTime, $endMin));
  }
}
// EOF.
