<?php
final class OfferCompensationDao extends Dao {
  private static $ALL = <<<'SQL'
select offer_code,
       compensation_id
  from offer_compensation
 order by offer_code,
       compensation_id
SQL;
  private static $PK = <<<'SQL'
select offer_code,
       compensation_id
  from offer_compensation
 where offer_code = '%s'
   and compensation_id = %s
SQL;
  private static $OFFER_CODE = <<<'SQL'
select oc.offer_code,
       oc.compensation_id,
       (select co.compensation_name
          from compensation co
         where co.compensation_id = oc.compensation_id) as compensation_name
  from offer_compensation oc
 where oc.offer_code = '%s'
 order by oc.compensation_id
SQL;
  private static $DELETE = <<<'SQL'
delete from offer_compensation
 where offer_code = '%s'
SQL;
  private static $INSERT = <<<'SQL'
insert into offer_compensation
            (offer_code,
             compensation_id)
     values ('%s',
             %s)
SQL;
  public function getAll() {
    return $this->execute(self::$ALL);
  }
  public function getByPk($pk) {
    return $this->execute(self::$PK, $pk);
  }
  public function getByOfferCode($offerCode) {
    return $this->execute(self::$OFFER_CODE, $offerCode);
  }
  public function delete($offerCode) {
    return $this->execute(self::$DELETE, $offerCode);
  }
  public function insert($offerCode, $compensationId) {
    return $this->execute(self::$INSERT, array($offerCode, $compensationId));
  }
}
// EOF.
