$(function() {
  window.setTimeout(function() {
    $("#shop_name").focus();
  }, 50);
  $("#prefecture").change(function() {
    if ($(this).val() == $(this).children("option:last-child").val()) {
      $("#area").val("");
    } else {
      $("#area").val($.trim($(this).children(":selected").text()));
    }
    $("#city").empty();
    $("#ward").empty();
    $.ajax({
      type : "post",
      cache : false,
      url : "/back/area/city",
      dataType : "json",
      data : {
        "prefectureId" : $(this).val()
      }
    }).done(function(data) {
      $("#city").append($("<option>").val("9"));
      $("#ward").append($("<option>").val("99"));
      $.each(data, function(key, val) {
        $("#city").append($("<option>").val(key).text(val));
      });
    });
  });
  $("#city").change(function() {
    if ($(this).val() == $(this).children("option:last-child").val()) {
      $("#area").val($.trim($("#prefecture").children(":selected").text()));
    } else {
      $("#area").val($.trim($("#prefecture").children(":selected").text()) + $.trim($(this).children(":selected").text()));
    }
    $("#ward").empty();
    $.ajax({
      type : "post",
      cache : false,
      url : "/back/area/ward",
      dataType : "json",
      data : {
        "prefectureId" : $("#prefecture").val(),
        "cityId" : $(this).val()
      }
    }).done(function(data) {
      $("#ward").append($("<option>").val("99"));
      $.each(data, function(key, val) {
        $("#ward").append($("<option>").val(key).text(val));
      });
    });
  });
  $("#ward").change(function() {
    $("#area").val($.trim($("#prefecture").children(":selected").text()) + $.trim($("#city").children(":selected").text()) + $.trim($(this).children(":selected").text()));
  });
  $("#open_map").click(function() {
    if ($("#lat").val().length == 0 || $("#lng").val().length == 0) {
      if (($("#area").val() + $("#address").val()).length == 0) {
        $("#error1").html("住所を入力してください");
        return;
      } else {
        $("#error1").html("");
        new google.maps.Geocoder().geocode({
          "address" : $("#area").val() + $("#address").val()
        }, function(result, status) {
          if (status == google.maps.GeocoderStatus.OK) {
            $("#lat").val(result[0].geometry.location.lat());
            $("#lng").val(result[0].geometry.location.lng());
          } else {
            $("#error1").html("マーカーを取得できませんでした");
            return;
          }
        });
      }
    }
    $(this).colorbox({
      inline : true,
      width : "80%",
      height : "80%",
      href : "#map",
      onComplete : function() {
        var latLng = new google.maps.LatLng($("#lat").val(), $("#lng").val());
        var map = new google.maps.Map(document.getElementById("map"), {
          zoom : 15,
          center : latLng,
          mapTypeId : google.maps.MapTypeId.ROADMAP
        });
        marker = new google.maps.Marker({
          position : latLng,
          map : map,
          title : "ココ",
          draggable : true
        });
        google.maps.event.addListener(marker, "dragend", function(ev) {
          $("#lat").val(ev.latLng.lat());
          $("#lng").val(ev.latLng.lng());
        });
      }
    });
  });
  var photoVal = 1;
  $(".upload_phot").click(function() {
    photoVal = $(this).val();
    $(this).colorbox({
      iframe : true,
      width : "30%",
      height : "90%",
      href : "/back/image?currPhoto=" + $("#curr_photo_" + photoVal).val() + "&photoId=" + photoVal
    });
  });
  $(".del_photo").click(function() {
    photoVal = $(this).val();
    $.ajax({
      type : "post",
      cache : false,
      url : "/back/image/remove",
      dataType : "json",
      data : {
        "currPhoto" : $("#curr_photo_" + photoVal).val(),
        "photoId" : photoVal
      }
    }).done(function(data) {
      $("#photo_view_" + photoVal).css("display", "none");
    });
  });
  $(".show_photo").click(function() {
    $(this).colorbox({
      inline : true,
      maxWidth : "80%",
      maxHeight : "80%",
      href : "#view_photo_" + $(this).val()
    });
  });
  $("#occupation").change(function() {
    $("#show_outline").html($.trim($(this).children(":selected").text()));
    $("#category").empty();
    $("#content").empty();
    $.ajax({
      type : "post",
      cache : false,
      url : "/back/outline/category",
      dataType : "json",
      data : {
        "occupationId" : $(this).val()
      }
    }).done(function(data) {
      $("#category").append($("<option>"));
      $.each(data, function(key, val) {
        $("#category").append($("<option>").val(key).text(val));
      });
    });
  });
  $("#category").change(function() {
    $("#show_outline").html($.trim($("#occupation").children(":selected").text()) + "<br>" + $.trim($(this).children(":selected").text()));
    $("#content").empty();
    $.ajax({
      type : "post",
      cache : false,
      url : "/back/outline/content",
      dataType : "json",
      data : {
        "occupationId" : $("#occupation").val(),
        "categoryId" : $(this).val()
      }
    }).done(function(data) {
      $("#content").append($("<option>"));
      $.each(data, function(key, val) {
        $("#content").append($("<option>").val(key).text(val));
      });
    });
  });
  $("#content").change(function() {
    $("#show_outline").html($.trim($("#occupation").children(":selected").text()) + "<br>" + $.trim($("#category").children(":selected").text()) + "<br>" + $.trim($(this).children(":selected").text()));
  });
  var outlineVal = 0;
  $("#tbl_outline").on("click", ".edt_outline", function() {
    outlineVal = $(this).val();
    $(this).colorbox({
      inline : true,
      width : "350px",
      height : "450px",
      href : "#outline"
    });
  });
  $("#ok_outline").click(function() {
    if ($("#occupation").val().length == 0 || $("#category").val().length == 0 || $("#content").val().length == 0) {
      $("#error_outline").html("選択してください。");
      return;
    }
    var isExists = false;
    $.each($("input[name='outline[]']"), function() {
      if ($(this).val() == ($("#occupation").val() + "," + $("#category").val() + "," + $("#content").val())) {
        isExists = true;
        return false;
      }
    });
    if (isExists) {
      $("#error3").html("すでに選択済みです。");
    } else {
      $("#outline_name_" + outlineVal).html($.trim($("#occupation").children(":selected").text()) + "/" + $.trim($("#category").children(":selected").text()) + "/" + $.trim($("#content").children(":selected").text()));
      $("#outline_value_" + outlineVal).val($("#occupation").val() + "," + $("#category").val() + "," + $("#content").val());
      $("#error3").html("");
    }
    $.colorbox.close();
  });
  var timeVal = 0;
  $("#tbl_time").on("click", ".edt_time", function() {
    timeVal = $(this).val();
    var times = $("#time_value_" + timeVal).val().split(",");
    $("#start_time").val(times[0]);
    $("#start_min").val(times[1]);
    $("#end_time").val(times[2]);
    $("#end_min").val(times[3]);
    $(this).colorbox({
      inline : true,
      width : "350px",
      height : "250px",
      href : "#time"
    });
  });
  $("#ok_time").click(function() {
    var isExists = false;
    $.each($("input[name='time[]']"), function() {
      if ($(this).val() == ($("#start_time").val() + "," + $("#start_min").val() + "," + $("#end_time").val() + "," + $("#end_min").val())) {
        isExists = true;
        return false;
      }
    });
    if (isExists) {
      $("#error4").html("すでに選択済みです。");
    } else {
      $("#time_name_" + timeVal).html($("#start_time").val() + "：" + $("#start_min").val() + "～" + $("#end_time").val() + "：" + $("#end_min").val());
      $("#time_value_" + timeVal).val($("#start_time").val() + "," + $("#start_min").val() + "," + $("#end_time").val() + "," + $("#end_min").val());
      $("#error4").html("");
    }
    $.colorbox.close();
  });
  var conditionVal = 0;
  $("#tbl_condition").on("click", ".edt_condition", function() {
    conditionVal = $(this).val();
    $("#condition_list").val($("#condition_value_" + conditionVal).val());
    $(this).colorbox({
      inline : true,
      width : "350px",
      height : "250px",
      href : "#condition"
    });
  });
  $("#ok_condition").click(function() {
    var isExists = false;
    $.each($("input[name='condition[]']"), function() {
      if ($(this).val() == $("#condition_list").val()) {
        isExists = true;
        return false;
      }
    });
    if (isExists) {
      $("#error5").html("すでに選択済みです。");
    } else {
      $("#condition_name_" + conditionVal).html($.trim($("#condition_list").children(":selected").text()));
      $("#condition_value_" + conditionVal).val($("#condition_list").val());
      $("#error5").html("");
    }
    $.colorbox.close();
  });
  var compensationVal = 0;
  $("#tbl_compensation").on("click", ".edt_compensation", function() {
    compensationVal = $(this).val();
    $("#compensation_list").val($("#compensation_value_" + compensationVal).val());
    $(this).colorbox({
      inline : true,
      width : "350px",
      height : "250px",
      href : "#compensation"
    });
  });
  $("#ok_compensation").click(function() {
    var isExists = false;
    $.each($("input[name='compensation[]']"), function() {
      if ($(this).val() == $("#compensation_list").val()) {
        isExists = true;
        return false;
      }
    });
    if (isExists) {
      $("#error6").html("すでに選択済みです。");
    } else {
      $("#compensation_name_" + compensationVal).html($.trim($("#compensation_list").children(":selected").text()));
      $("#compensation_value_" + compensationVal).val($("#compensation_list").val());
      $("#error6").html("");
    }
    $.colorbox.close();
  });
  $("#restore").click(function() {
    $.ajax({
      type : "post",
      cache : false,
      url : "/back/offer/restore",
      dataType : "json",
      data : {
        "offerCode" : $(this).val()
      }
    }).done(function(data) {
      $("#restore").css("display", "none");
      $("#break").css("display", "");
      $("#do_post").css("display", "");
    });
  });
  $("#preview").click(function() {
    $(this).colorbox({
      iframe : true,
      width : "90%",
      height : "90%",
      onComplete : function() {
        $("#frm").attr("target", document.getElementsByTagName("iframe")[0].name).attr("action", "/back/preview").submit();
      }
    });
  });
});
