/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd.sets;

import jdd.bdd.BDD;
import jdd.bdd.BDDUtil;
import jdd.bdd.sets.BDDSet;
import jdd.bdd.sets.SubDomain;
import jdd.util.Array;
import jdd.util.JDDConsole;
import jdd.util.Test;
import jdd.util.sets.Set;
import jdd.util.sets.Universe;

public class BDDUniverse
extends BDD
implements Universe {
    private int[] int_subdomains;
    private int[] int_bits;
    private double domainsize;
    private int num_subdomains;
    private int all;
    private int bits;
    private SubDomain[] subdomains;
    private int[] sat_vec = null;
    private int sat_curr;
    private int sat_level;
    private int sat_next;
    private int sat_index;
    private int sat_bit;
    static int[] dum = new int[]{3, 4, 5, 1};

    public BDDUniverse(int[] nArray) {
        super(1000, 1000);
        int n;
        this.num_subdomains = nArray.length;
        this.int_subdomains = Array.clone(nArray);
        this.int_bits = new int[this.num_subdomains];
        this.subdomains = new SubDomain[this.num_subdomains];
        this.domainsize = 1.0;
        this.bits = 0;
        for (n = 0; n < this.num_subdomains; ++n) {
            this.subdomains[n] = new SubDomain(this, this.int_subdomains[n]);
            this.domainsize *= (double)this.int_subdomains[n];
            this.int_bits[n] = this.subdomains[n].bits;
            this.bits += this.subdomains[n].bits;
        }
        this.all = 1;
        for (n = 0; n < this.num_subdomains; ++n) {
            int n2 = this.ref(this.and(this.all, this.subdomains[n].all));
            this.deref(this.all);
            this.all = n2;
        }
    }

    @Override
    public void free() {
        this.cleanup();
        this.subdomains = null;
    }

    int vectorToBDD(int[] nArray) {
        int n = 1;
        for (int i = 0; i < this.num_subdomains; ++i) {
            if (nArray[i] == -1) continue;
            int n2 = this.ref(this.and(n, this.subdomains[i].numbers[nArray[i]]));
            this.deref(n);
            n = n2;
        }
        return n;
    }

    void vectorToMinterm(int[] nArray, boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < this.num_subdomains; ++i) {
            if (nArray[i] == -1) continue;
            BDDUtil.numberToMinterm(nArray[i], this.int_bits[i], n, blArray);
            n += this.int_bits[i];
        }
    }

    public int cardinality(int[] nArray) {
        int n = 1;
        for (int i = 0; i < this.num_subdomains; ++i) {
            if (nArray[i] != -1) continue;
            n *= this.subdomains[i].getSize();
        }
        return n;
    }

    @Override
    public Set createEmptySet() {
        return new BDDSet(this, 0);
    }

    @Override
    public Set createFullSet() {
        return new BDDSet(this, this.all);
    }

    public Set simplify(Set set, Set set2) {
        int n = this.restrict(((BDDSet)set).bdd, ((BDDSet)set2).bdd);
        return new BDDSet(this, n);
    }

    @Override
    public double domainSize() {
        return this.domainsize;
    }

    @Override
    public int subdomainCount() {
        return this.num_subdomains;
    }

    public int numberOfBits() {
        return this.bits;
    }

    int removeDontCares(int n) {
        return this.and(n, this.all);
    }

    public void print(int[] nArray) {
        JDDConsole.out.print("<");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                JDDConsole.out.print(", ");
            }
            if (nArray[i] == -1) {
                JDDConsole.out.print("-");
                continue;
            }
            JDDConsole.out.print("" + nArray[i]);
        }
        JDDConsole.out.print(">");
    }

    public void randomMember(int[] nArray) {
        for (int i = 0; i < this.num_subdomains; ++i) {
            nArray[i] = (int)(Math.random() * (double)this.int_subdomains[i]);
        }
    }

    public void satOneVector(int n, int[] nArray) {
        this.sat_vec = nArray;
        this.sat_bit = 0;
        this.sat_index = 0;
        this.sat_level = 0;
        this.sat_curr = 0;
        this.sat_next = this.subdomains[0].bits;
        this.satOneVector_rec(n);
        while (this.sat_index < this.num_subdomains) {
            this.satOneVector_insert(false);
        }
        this.sat_vec = null;
    }

    private void satOneVector_insert(boolean bl) {
        if (bl) {
            this.sat_curr |= 1 << this.sat_bit;
        }
        if (++this.sat_level == this.sat_next) {
            this.sat_vec[this.sat_index++] = this.sat_curr;
            this.sat_curr = 0;
            this.sat_bit = 0;
            if (this.sat_index < this.num_subdomains) {
                this.sat_next += this.subdomains[this.sat_index].bits;
            }
        } else {
            ++this.sat_bit;
        }
    }

    private void satOneVector_rec(int n) {
        if (n < 2) {
            return;
        }
        while (this.getVar(n) > this.sat_level) {
            this.satOneVector_insert(false);
        }
        if (this.getLow(n) == 0) {
            this.satOneVector_insert(true);
            this.satOneVector_rec(this.getHigh(n));
        } else {
            this.satOneVector_insert(false);
            this.satOneVector_rec(this.getLow(n));
        }
    }

    public static void internal_test() {
        Test.start("BDDUniverse");
        BDDUniverse bDDUniverse = new BDDUniverse(dum);
        Set set = bDDUniverse.createEmptySet();
        Set set2 = bDDUniverse.createFullSet();
        Test.checkEquality(set.cardinality(), 0.0, "Empty set has zero cardinality");
        Test.checkEquality(set2.cardinality(), bDDUniverse.domainSize(), "Full set as large as the universe");
        Test.checkEquality(bDDUniverse.cardinality(dum), 1, "Single cardinality");
        BDDUniverse.dum[0] = -1;
        Test.checkEquality(bDDUniverse.cardinality(dum), 3, "DC leads to higher cardinality");
        set.free();
        set2.free();
        Test.end();
    }
}

