#!/bin/sh
###############################################################################
#
# FSWiki꡼ѥץ
#
###############################################################################
if [ $# -lt 1 ]; then
  echo "./release.sh version"
  exit 1
fi

#==============================================================================
# С
#==============================================================================
VERSION=$1

#==============================================================================
# ƥݥǥ쥯ȥ̾zipե̾
#==============================================================================
DIR_NAME="wiki$VERSION"

#==============================================================================
# ǥ쥯ȥ꤬Ϻ
#==============================================================================
if [ -e $DIR_NAME ]; then
  echo "delete temp directory..."
  rm -rf $DIR_NAME
fi

#==============================================================================
# zipե뤬Ϻ
#==============================================================================
if [ -e $DIR_NAME.zip ]; then
  echo "delete zip file..."
  rm $DIR_NAME.zip
fi

#==============================================================================
# ȥǥ쥯ȥ
#==============================================================================
echo "create temp directory..."
mkdir $DIR_NAME

#==============================================================================
# ƤΥեƥݥǥ쥯ȥ˥ԡ
#==============================================================================
echo "copy to temp directory..."
cp ./wiki.cgi $DIR_NAME
cp ./setup.dat $DIR_NAME
cp ./setup.sh $DIR_NAME
cp -r ./config $DIR_NAME
cp -r ./data $DIR_NAME
cp -r ./docs $DIR_NAME
cp -r ./lib $DIR_NAME
cp -r ./plugin $DIR_NAME
cp -r ./theme $DIR_NAME
cp -r ./tmpl $DIR_NAME

#==============================================================================
# zipե˰
#==============================================================================
echo "create zip file..."
find ./$DIR_NAME/docs    \! -path '*/.svn*' -exec zip $DIR_NAME.zip {} \;
find ./$DIR_NAME/lib     \! -path '*/.svn*' -exec zip $DIR_NAME.zip {} \;
find ./$DIR_NAME/plugin  \! -path '*/.svn*' -exec zip $DIR_NAME.zip {} \;
find ./$DIR_NAME/theme   \! -path '*/.svn*' -exec zip $DIR_NAME.zip {} \;
find ./$DIR_NAME/tmpl    \! -path '*/.svn*' -exec zip $DIR_NAME.zip {} \;

zip $DIR_NAME.zip ./$DIR_NAME/config/config.dat
zip $DIR_NAME.zip ./$DIR_NAME/config/farmconf.dat
zip $DIR_NAME.zip ./$DIR_NAME/config/mime.dat
zip $DIR_NAME.zip ./$DIR_NAME/config/plugin.dat
zip $DIR_NAME.zip ./$DIR_NAME/config/user.dat
zip $DIR_NAME.zip ./$DIR_NAME/config/usercss.dat

zip $DIR_NAME.zip ./$DIR_NAME/data/FrontPage.wiki
zip $DIR_NAME.zip ./$DIR_NAME/data/Help.wiki
zip $DIR_NAME.zip ./$DIR_NAME/data/Help%2FFSWiki.wiki
zip $DIR_NAME.zip ./$DIR_NAME/data/Help%2FHiki.wiki
zip $DIR_NAME.zip ./$DIR_NAME/data/Help%2FWalWiki.wiki
zip $DIR_NAME.zip ./$DIR_NAME/data/Help%2FYukiWiki.wiki
zip $DIR_NAME.zip ./$DIR_NAME/data/PluginHelp.wiki

zip $DIR_NAME.zip ./$DIR_NAME/setup.sh
zip $DIR_NAME.zip ./$DIR_NAME/setup.dat
zip $DIR_NAME.zip ./$DIR_NAME/wiki.cgi

#==============================================================================
# ȥǥ쥯ȥ
#==============================================================================
echo "deletie temp directory..."
rm -rf $DIR_NAME

echo "complete."
