/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package seisekilist;

import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;

/**
 *
 * @author ishin
 */
public class Histogram extends JDialog {

    private final static String TITLE = "ヒストグラム";
    private final static int WIN_WIDTH = 400;
    private final static int WIN_HEIGHT = 480;
    private List<ScoreData> csvData;

    public Histogram(JFrame ga, List<ScoreData> csvData) {
        super(ga);

        this.csvData = csvData;
        initComponent(ga);

        HistogramDataset data = createData();

        ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
        JFreeChart chart = ChartFactory.createHistogram("成績分布", "得点", "人数",
                data,
                PlotOrientation.VERTICAL,
                true,
                false,
                false);
        ChartPanel cpanel = new ChartPanel(chart);
        add(cpanel);

    }

    /**
     * 画面の初期化
     *
     */
    private void initComponent(JFrame ga) {
        setModal(true);
        setResizable(false);
        setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        setTitle(TITLE);
        setSize(WIN_WIDTH, WIN_HEIGHT);
        setLocationRelativeTo(ga);
    }

    private HistogramDataset createData() {
        HistogramDataset data = new HistogramDataset();

        int mt = csvData.size();
        double[] values = new double[mt];
        
        double dat;
        for (int n = 0; n < csvData.size(); n++) {
            dat = (double) csvData.get(n).getAverage();
            values[n] = dat;
        }
        data.addSeries("平均", values, 10);

        return data;
    }

}
