#include "stdafx.h"

#include "button.h"

namespace MG {

Button::Button(size_t nMaxEvents)
	:
	Element(nMaxEvents),
	pBGPressed_(0)
{
	needsToDraw_ = true;
}

void Button::Draw(int16_t offsetX, int16_t offsetY, IRenderer& renderer)
{
	if (isPressed_) {
		IBackground* backup = pBG_;
		pBG_ = pBGPressed_;
		__super::Draw(offsetX, offsetY, renderer);
		pBG_ = backup;
	}else {
		__super::Draw(offsetX, offsetY, renderer);
	}
}

bool Button::HitTest(int16_t x, int16_t y) const
{
	return __super::HitTest(x, y);
}

void Button::OnMouseDown(int16_t x, int16_t y)
{
	needsToDraw_ = true;
	isPressed_ = true;
	s_pCapture_ = this;
	__super::OnMouseDown(x, y);
}

void Button::OnMouseUp(int16_t x, int16_t y)
{
	__super::OnMouseUp(x, y);
	if (isPressed_) {
		needsToDraw_ = true;
		isPressed_ = false;
		s_pCapture_ = 0;
		if (HitTest(x, y)) {
			OnClick(x, y);
		}
	}
}

void Button::OnClick(int16_t x, int16_t y)
{
	Event e;
	e.target = this;
	e.type = EventType_Click;
	e.x = x;
	e.y = y;
	fireEventListener(e);
}

} // anonymous MG

