/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

import net.morilib.math.stochastic.GenerateRandomSequence;
import net.morilib.math.stochastic.StochasticProcess;
import junit.framework.TestCase;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/16
 */
public class NinaMarkovTest extends TestCase {

	public void test0010() {
		String s =
				"#machine MarkovChainBuilder\n" +
				"#type double\n" +
				" =======              *******       @***\n" +
				" =a    >-----'1'------>[A-Z]>-'0.2'->  *\n" +
				" ==^====              **v****       ****\n" +
				"   \\--------'0.8'-------/   \n" +
				"";
		StochasticProcess p;

		p = Nina.compile(s);
		System.out.println(GenerateRandomSequence.generate(p, ""));
		System.out.println(GenerateRandomSequence.generate(p, ""));
		System.out.println(GenerateRandomSequence.generate(p, ""));
		System.out.println(GenerateRandomSequence.generate(p, ""));
		System.out.println(GenerateRandomSequence.generate(p, ""));
	}

}
