cat > /output/${FILENAME}.h << EOF
/* Translated by Nina */
/* This source code is under public domain */

#ifndef DEFINED_${FILENAME}
#define DEFINED_${FILENAME}
#include <stdio.h>
#define ENDMARKER ((void *)1)

typedef struct ${FILENAME}_tag {
	int state;
	int unread;
	void *iseof;
	char buf[${BUFSIZE}];
} ${FILENAME};

extern int ${FILENAME}_matches(char *s);
extern int ${FILENAME}_lookingAt(${FILENAME} *b, char *s);
extern int ${FILENAME}_find(${FILENAME} *b, char *s);
extern int ${FILENAME}_parse(${FILENAME} *s, FILE *f);
#endif
EOF

echo '/* Translated by Nina */'
echo '/* This source code is under public domain */'

cat << EOF
#include <stdio.h>
#include <string.h>
#include "${FILENAME}.h"

EOF
cat fragment
cat << EOF

static int ${FILENAME}__read(${FILENAME} *b, FILE* f) {
	int c;

	if(b->unread >= 0) {
		c = b->unread;
		b->unread = -1;
	} else if((c = fgetc(f)) < 0) {
		b->iseof = ENDMARKER;
	}
	return c;
}

int ${FILENAME}__step(${FILENAME} *b, int c) {
	switch(b->state) {
EOF

print_states
cat << EOF
	}
	return 0;
}

static int ${FILENAME}__accepted(${FILENAME} *b) {
EOF

print_accepts
echo '}'
echo
echo "void ${FILENAME}__execaction(${FILENAME} *b, int __c__) {"
echo '	switch(b->state) {'

print_actions
cat << EOF
	}
}

int ${FILENAME}_matches(char *s) {
	${FILENAME} b;
	char *n;

	memset(&b, 0, sizeof(b));
	for(n = s; *n != 0; n++) {
		if(!${FILENAME}__step(&b, *n)) {
			return 0;
		}
	}
	return ${FILENAME}__accepted(&b);
}

int ${FILENAME}_lookingAt(${FILENAME} *b, char *s) {
	char *n, *p, *q;

	p = b->buf;  q = NULL;
	memset(b->buf, 0, sizeof(b->buf));
	for(n = s; *n != 0; *(p++) = *(n++)) {
		if(${FILENAME}__accepted(b)) {
			q = p;
		}

		if(p - b->buf >= sizeof(b->buf) - 1 ||
				!${FILENAME}__step(b, *n)) {
			if(q != NULL) {
				*q = 0;
				return 1;
			} else {
				return 0;
			}
		}
	}

	if(${FILENAME}__accepted(b)) {
		*p = 0;
		return 1;
	} else if(q != NULL) {
		*q = 0;
		return 1;
	} else {
		return 0;
	}
}

int ${FILENAME}_find(${FILENAME} *b, char *s) {
	char *n, *k, *p, *q;
	int x = 0;

	p = b->buf;  q = NULL;
	memset(b->buf, 0, sizeof(b->buf));
	for(k = s; *k != 0; k++) {
		for(n = k; *n != 0; *(p++) = *(n++)) {
			if(${FILENAME}__accepted(b)) {
				q = p;
			}

			if(p - b->buf >= sizeof(b->buf) - 1) {
				if(q != NULL) {
					*q = 0;
					return 1;
				} else {
					return 0;
				}
			} else if(!${FILENAME}__step(b, *n)) {
				if(q != NULL) {
					*q = 0;
					return 1;
				} else {
					b->state = 0;
					p = b->buf;  *p = 0;
					break;
				}
			}
		}

		if(${FILENAME}__accepted(b)) {
			*p = 0;
			return 1;
		} else if(q != NULL) {
			*q = 0;
			return 1;
		}
	}
	return 0;
}

int ${FILENAME}_parse(${FILENAME} *b, FILE *f) {
	int p, c;

	for(p = -2; (c = ${FILENAME}__read(b, f)) >= 0; p = c) {
		${FILENAME}__execaction(b, p);
		if(!${FILENAME}__step(b, c)) {
			b->state = 0;
		}
	}
	${FILENAME}__execaction(b, p);
	return ${FILENAME}__accepted(b);
}
EOF
