<?php

class Content extends Zend_Db_Table_Abstract {
  protected $_name = 'necosuke_lpo_mast_content';
  protected $_rowClass = 'ContentRow';
  protected $_dependentTables = array('Log');
  protected $_referenceMap = array(
    'Condition' => array(
      'columns'       => 'condition_id',
      'refTableClass' => 'Condition',
      'refColumns'    => 'id',
      #'onDelete'      => self::CASCADE,
    ),
  );

  public function insert($data) {
    $data['created']  = new Zend_Db_Expr('now()');
    $data['updated']  = new Zend_Db_Expr('now()');

    return parent::insert($data);
  }

  public function update($data, $where) {
    $data['updated']  = new Zend_Db_Expr('now()');

    return parent::update($data, $where);
  }
}

class ContentRow extends Zend_Db_Table_Row_Abstract {
  public function del() {
    $this->status = 'deleted';
  }
}
