<?php

class Necosuke_Mail extends Zend_Mail {
  protected function _encodeHeader($value)
  {
    return sprintf(
      "=?%s?B?%s?=",
      $this->getCharset(),
      base64_encode(mb_convert_encoding($value, $this->getCharset()))
    );
  }

  public function __construct($charset='ISO-2022-JP') {
    parent::__construct($charset);
  }

  public function setBodyText($txt, $charset=null, $encoding=Zend_Mime::ENCODING_7BIT) {
    if(!$charset) {
      $charset = $this->getCharset();
    }

    parent::setBodyText(
      mb_convert_encoding($txt, $charset),
      $charset,
      $encoding
    );
  }
}
