<?php

define('BASE_DIR', dirname(__FILE__).'/');
define('LIB_DIR', BASE_DIR.'../lib');
define('ZEND_DIR', BASE_DIR.'../lib/ZFlib');
define('MODEL_DIR', BASE_DIR.'../application/models');
define('CONFIG_INI', BASE_DIR.'../config.ini');

ini_set(
  'include_path',
  ini_get('include_path').
  PATH_SEPARATOR.
  LIB_DIR.
  PATH_SEPARATOR.
  ZEND_DIR.
  PATH_SEPARATOR.
  MODEL_DIR
);

function _dump($v) {
  echo '<pre style="text-align:left">';
  var_dump($v);
  echo '</pre>';
}

require_once 'Zend/Loader.php';
Zend_Loader::registerAutoload();

function main() {
  mb_internal_encoding('UTF-8');
  mb_language('Japanese');

  #Zend_Session::regenerateId();

  $config = new Zend_Config_Ini(CONFIG_INI, 'production');

  ini_set('session.gc_maxlifetime', $config->login->rememberme);

  $db = Zend_Db::factory($config->db->adapter, $config->db->config->toArray());
  $db->query('SET NAMES UTF8');
  Zend_Db_Table_Abstract::setDefaultAdapter($db);

  $translate = new Zend_Translate('array', array(
    'isEmpty' => '※この項目は入力必須項目です。',
    'emailAddressInvalid' => '※ %value% は正しいメールアドレスの形式ではありません。',
    'emailAddressInvalidHostname' => '※ %hostname% は正しいドメイン名ではありません。',

    /*
    'emailAddressInvalidMxRecord' => '',
    'emailAddressDotAtom' => '',
    'emailAddressQuotedString' => '',
    'emailAddressInvalidLocalPart' => '%localPart% は',
    */

    /*
    'hostnameIpAddressNotAllowed' => '',
    'hostnameUnknownTld' => '',
    'hostnameDashCharacter' => '',
    'hostnameInvalidHostnameSchema' => '',
    'hostnameUndecipherableTld' => '',
    'hostnameInvalidHostname' => '',
    'hostnameInvalidLocalName' => '',
    'hostnameLocalNameNotAllowed' => '',
    */

  ), 'ja');
  Zend_Form::setDefaultTranslator($translate);

  Zend_Layout::startMvc();

  $view = Zend_Layout::getMvcInstance()->getView();
  $view->headTitle('ねこすけ LPO');
  $view->headLink()
    ->appendStylesheet("/pub/yui/build/reset-fonts-grids/reset-fonts-grids.css")
    ->appendStylesheet("/pub/main.css");
  $view->headScript()
    ->appendFile("/pub/jquery.js")
    ->appendFile("/pub/main.js");

  Zend_Controller_Front::getInstance()->setParam('config', $config);
  Zend_Controller_Front::run('../application/controllers');
}

main();
