<?php

class LpoController extends Zend_Controller_Action {
  public function beaconAction() {
    $this->_helper->layout->disableLayout();

    $this->getResponse()->setHeader(
      'content-type',
      'application/x-javascript; charset=utf-8'
    );
    $this->getResponse()->setHeader('P3P', "CP='UNI CUR OUR'");

    $acct_t = new Account();
    $acct = $acct_t->getAccountByHash($this->getRequest()->getParam('id'));

    $config = Zend_Controller_Front::getInstance()->getParam('config');

    $limit = $config->db->table->user->log_limit;
    $this->view->base_url = $config->base_url;

    $log_t = new Log($acct->id);
    if($log_t->getUsage() >= $limit) {
      $this->view->acct = null;
    } else {
      $this->view->acct = $acct;
    }
  }

  public function contentAction() {
    $this->_helper->layout->disableLayout();

    $this->getResponse()->setHeader(
      'content-type',
      'application/json; charset=utf-8'
    );
    $this->getResponse()->setHeader('P3P', "CP='UNI CUR OUR'");

    $data = array();
    $content_t = new Content();
    if(
      $content = $content_t->find(
        $this->getRequest()->getParam('id')
      )->current()
    ) {
      if($condition = $content->findParentRow(new Condition())) {
        if($lpo = $condition->findParentRow(new Lpo())) {
          $data[] = array(
            'selector' => $lpo->selector,
            'content'  => $content->content
          );
        }
      }
    }

    $this->view->callback = $this->getRequest()->getParam('callback');
    $this->view->data     = Zend_Json::encode($data);
  }

  public function logAction() {
    $this->_helper->layout->disableLayout();

    $this->getResponse()->setHeader(
      'content-type',
      'application/json; charset=utf-8'
    );
    $this->getResponse()->setHeader('P3P', "CP='UNI CUR OUR'");

    $key = $this->getRequest()->getParam('id');
    $url = $this->getRequest()->getParam('url');
    $ref = $this->getRequest()->getParam('ref');

    $this->view->callback = $this->getRequest()->getParam('callback');
    $this->view->data     = Zend_Json::encode(array());

    $acct_t = new Account();
    $acct = $acct_t->getAccountByHash($key);

    if(!$acct) return;

    $session = new Zend_Session_Namespace('lpo');

    /* conversion */
    if(!empty($session->landing)) {
      $db = Zend_Db_Table_Abstract::getDefaultAdapter();
      $lpo_t = new Lpo();
      foreach(
        $acct->findDependentRowset(
          'Lpo',
          null,
          $lpo_t->select()
            ->where('status = ?', 'active')
            ->where(
              sprintf(
                'conversion_url = %s OR conversion_url = %s',
                $db->quote($url),
                $db->quote(array_shift(explode('?', $url)))
              )
            )
        ) as $val
      ) {
        if(array_key_exists($val->id, $session->landing)) {
          $log_t = new Log($acct->id);
          $log = $log_t->createRow();
          $log->log          = 'conversion';
          $log->lpo_id       = $val->id;
          $log->condition_id = $session->landing[$val->id]['condition_id'];
          $log->content_id   = $session->landing[$val->id]['content_id'];
          $log->save();
        }
      }
    }

    /* landing */
    $session->landing = array();
    $data = array();
    foreach($acct->getContentRows($url, $ref) as $val) {
      list($lpo, $condition, $content) = $val;

      $data[] = array(
        'selector' => $lpo->selector,
        'content'  => $content->content
      );

      $session->landing[$lpo->id] = array(
        'condition_id' => $condition->id,
        'content_id'   => $content->id
      );

      $log_t = new Log($acct->id);
      $log = $log_t->createRow();
      $log->log          = 'landing';
      $log->lpo_id       = $lpo->id;
      $log->condition_id = $condition->id;
      $log->content_id   = $content->id;
      $log->save();
    }
    $this->view->data = Zend_Json::encode($data);
  }
}
