/*
 * mkstemp program copyright (C) 2009 H.Niwa
 */


/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>


#ifdef __MINGW32__

#include<windows.h>

#define MAXPATHLEN	MAX_PATH

static char temppath[MAXPATHLEN];

FILE* MksTemp(char* templ)
{
	if(GetTempPath(MAXPATHLEN, temppath)!=0){
//printf("temppath %s\n", temppath);
		if(GetTempFileName(temppath, "dtm", 0, templ) != 0){
		FILE* fd;

		fd = fopen(templ, "w+b");
		if(fd != NULL)
			return fd;
		}
	}
	return NULL;
}
#else 
FILE* MksTemp(char* templ)
{
	int f = mkstemp(templ);
	FILE* fd = fdopen(f, "w+");
	return fd;
}
#endif

