/*
 * built-in program copyright (C) 2009 H.Niwa
 */


/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include <string>

#include "syserr.h"

#include "bin_node.h"
#include "gc.h"
#include "var.h"
#include "pred.h"
#include "context.h"
#include "unify.h"
#include "builtin.h"
#include "sysmodule.h"

int HelpPrint(std::string s);
int HelpBuiltinCmd();
int HelpSysCmd();
int HelpBuiltin(char* name);
int HelpSys(char* name);

int Help(Context* cx, Node* goalscar)
{
	int ll = ListLength(goalscar->Cdr());

	if (ll == 0) {
		printf("\n");
		HelpBuiltinCmd();
		HelpSysCmd();
		printf(
			 "Details will be displayed when \"HELP item\" is inputted. \n" \
			  "Or please input \"help builtin\" , \"help sys\". \n");
		return 1;
	} else if (ll == 1) {

		if (goalscar->Cdr()->Car()->Eq(mka("builtin"))) {
			HelpBuiltin("");
			return 1;
		} else if (goalscar->Cdr()->Car()->Eq(mka("sys"))) {
			HelpSys("");
			return 1;
		}

		std::string s;
		if (goalscar->Cdr()->Car()->kind() == ATOM) {
			((Atom*)(goalscar->Cdr()->Car()))->toString(s);
			HelpPrint(s);
			return 1;
		}
	}
	return 0;
}

/**********************************************************************/
int HelpPrint(std::string s)
{
	if ((s == "alt") ) { 
		printf("<alt PRED...>\n");
		printf("\n");
		printf("	Alternative predicate execution is shown.\n");
		printf("	Even if the results of Argument PRED are true, false,\n");
		printf("	and unknown, it is certainly set to true.\n");
		printf("	It expresses [PRED...] as substitution.It uses by syntax\n");
		printf("	analysis as [] of the method of EBNF.\n");
		printf("\n");
	} else if ((s == "assert") || (s == "asserta") || (s == "assertz") ) { 
		printf("<assert CLAUSE>\n");
		printf("<asserta CLAUSE>\n");
		printf("<assertz CLAUSE>\n");
		printf("\n");
		printf("	CLAUSE is added.\n");
		printf("	asserta is added to a head and assertz is added at\n");
		printf("	the end.\n");
		printf("	assert is the same as asserta and is added to a head.\n");
		printf("\n");
	} else if ((s == "cd") ) { 
		printf("<cd PATH>\n");
		printf("\n");
		printf("	A current directory is moved to the PATH specified\n");
		printf("	by the argument.\n");
		printf("\n");
	} else if ((s == "edit") ) { 
		printf("<edit FILE-NAME>\n");
		printf("\n");
		printf("	A FILE-NAME is edited using the editor set as the \n");
		printf("	environment variables DEDITORPATH and EDITOR.\n");
		printf("\n");
	} else if ((s == "dir") || (s == "ls") ) { 
		printf("<dir>\n");
		printf("<ls>\n");
		printf("\n");
		printf("	A current directory is displayed.\n");
		printf("\n");
	} else if ((s == "compare") || (s == "comparef") ) { 
		printf("<compare EXPRESSION>\n");
		printf("<comparef EXPRESSION>\n");
		printf("\n");
		printf("	EXPRESSION is evaluated.\n");
		printf("	compare is an integer and comparef is comparison of\n");
		printf("	a float number.\n");
		printf("\n");
	} else if ((s == "erase") || (s == "retract") ) { 
		printf("<erase CLAUSE-NAME>\n");
		printf("<retract CLAUSE-NAME>\n");
		printf("\n");
		printf("	All the programs corresponding to CLAUSE-NAME are\n");
		printf("	deleted.\n");
		printf("\n");
	} else if ((s == "retractpred") ) { 
		printf("<retractpred HEAD-NAME>\n");
		printf("\n");
		printf("	All the programs corresponding to HEAD-NAME are\n");
		printf("	deleted.\n");
		printf("\n");
	} else if ((s == "f") || (s == "func") ) { 
		printf("<f VAR PRED...>\n");
		printf("<func VAR PRED...>\n");
		printf("\n");
		printf("	Execution evaluation of the function predicate contained\n");
		printf("	in PRED-LIST is carried out. A value is replaced.\n");
		printf("	After performing all, a result is set to a variable.\n");
		printf("\n");
	} else if ((s == "findall") ) { 
		printf("<findall PRED...>\n");
		printf("\n");
		printf("	PRED is performed and all the solutions are calculated.\n");
		printf("\n");
	} else if ((s == "for") || (s == "for") ) { 
		printf("<for (VAR lastvalue) PRED...>\n");
		printf("<for (VAR initialvalue lastvalue) PRED...>\n");
		printf("\n");
		printf("	The predicate of the specified number of times and an\n");
		printf("	argument is performed.\n");
		printf("	When the initial value is not specified, the value\n");
		printf("	from 0 is set to a VAR.\n");
		printf("\n");
	} else if ((s == "foreach") || (s == "map") ) { 
		printf("<foreach (VAR LIST) PRED...>\n");
		printf("<map (VAR LIST) PRED...>\n");
		printf("\n");
		printf("	PRED of arguments are performed for every element\n");
		printf("	of LIST.\n");
		printf("	The value of a list is set to a variable in order.\n");
		printf("	<include FILENAME>\n");
		printf("	The library of a FILE-NAME is read.\n");
		printf("\n");
	} else if ((s == "let") || (s == "letf") ) { 
		printf("<let EXPRESSION>\n");
		printf("<letf EXPRESSION>\n");
		printf("\n");
		printf("	Expression is calculated.\n");
		printf("	A calculation result is substituted when the left\n");
		printf("	side is a variable.\n");
		printf("	When the left side is a numerical value, it is\n");
		printf("	judged whether it is equal to a calculation result.\n");
		printf("	let calculates an integer and letf is calculation\n");
		printf("	of floating number.\n");
		printf("\n");
	} else if ((s == "list") ) { 
		printf("<list>\n");
		printf("\n");
		printf("	A program list is displayed.\n");
		printf("\n");
	} else if ((s == "load") ) { 
		printf("<load FILE-NAME>\n");
		printf("\n");
		printf("	The program of a FILE-NAME is read.\n");
		printf("\n");
	} else if ((s == "loop") ) { 
		printf("<loop PRED...>\n");
		printf("\n");
		printf("	A repetition of predicate execution is shown.\n");
		printf("	It was called inside. Failure of a predicate\n");
		printf("	will escape from a loop.\n");
		printf("	It is the predicate which is surely successful\n");
		printf("	by true,\n");
		printf("	It expresses {PRED...} as substitution.\n");
		printf("	It uses by syntax analysis as {} of the method\n");
		printf("	of EBNF.\n");
		printf("\n");
	} else if ((s == "module") ) { 
		printf("<module VAR>\n");
		printf("\n");
		printf("	The library module used now is set to a variable.\n");
		printf("\n");
	} else if ((s == "new") ) { 
		printf("<new>\n");
		printf("\n");
		printf("	All log rum is cleared.\n");
		printf("	<not PRED...>\n");
		printf("	false is returned when predicate execution is true.\n");
		printf("	In false, true is returned.\n");
		printf("	In unknown, unknown is returned.\n");
		printf("\n");
	} else if ((s == "obj") || (s == "unify") ) { 
		printf("<obj OBJECTNAME PRED...>\n");
		printf("<unify MODULENAME PRED...>\n");
		printf("\n");
		printf("	A predicate is performed using the specified object\n");
		printf("	or module.\n");
		printf("	A module is the same as an object.\n");
		printf("	It can be described as ::object <PRED...> as an\n");
		printf("	omitted type.\n");
		printf("\n");
	} else if ((s == "or") ) { 
		printf("<or PRED PRED PRED ...>\n");
		printf("\n");
		printf("	In the place which performed the predicate of the\n");
		printf("	argument from the head and was set to true Processing\n");
		printf("	is closed and true is returned.\n");
		printf("	In the place which performed the predicate of the argument\n");
		printf("	from the head and was set to false Processing is closed\n");
		printf("	and false is returned.\n");
		printf("	unknown is returned when all the predicates are unknown.\n");
		printf("	It uses by syntax analysis as | of the method\n");
		printf("	of EBNF.\n");
		printf("\n");
	} else if ((s == "print") ) { 
		printf("<print LIST>\n");
		printf("\n");
		printf("	fter outputting a list, a new line is started.\n");
		printf("	<writenl LIST> is the same as <print LIST>.\n");
		printf("\n");
	} else if ((s == "pwd") ) { 
		printf("<pwd VAR>\n");
		printf("\n");
		printf("	The current directory is set to VAR.\n");
		printf("\n");
	} else if ((s == "quit") ) { 
		printf("<quit>\n");
		printf("\n");
		printf("	Execution of a program is stopped and it ends.\n");
		printf("\n");
	} else if ((s == "quote") ) { 
		printf("<quote PRED>\n");
		printf("\n");
		printf("	Evaluation of the function predicate of an argument\n");
		printf("	is deterred.\n");
		printf("\n");
	} else if ((s == "rpn") || (s == "rpnf") ) { 
		printf("<rpn VAR RPNEXPRESSION>\n");
		printf("<rpnf VAR RPNEXPRESSION>\n");
		printf("\n");
		printf("	A reverse Poland style is calculated and a result\n");
		printf("	is set to a variable.\n");
		printf("	rpn calculates an integer and rpnf calculates floating\n");
		printf("	number.\n");
		printf("\n");
	} else if ((s == "save") ) { 
		printf("<save FILE-NAME>\n");
		printf("\n");
		printf("	The program of a FILE-NAME is written in.\n");
		printf("\n");
	} else if ((s == "timeout") ) { 
		printf("<timeout limittime PRED>\n");
		printf("\n");
		printf("	Within the set-up time, when execution of a predicate\n");
		printf("	is not completed, processing is closed, and unknown is\n");
		printf("	returned. A set period is a micro second bit.\n");
		printf("\n");
	} else if ((s == "troff") ) { 
		printf("<troff>\n");
		printf("\n");
		printf("	Debugging trace is turned OFF.\n");
		printf("\n");
	} else if ((s == "tron") ) { 
		printf("<tron>\n");
		printf("\n");
		printf("	Debugging trace is turned ON.\n");
		printf("\n");
	} else if ((s == "true") || (s == "false") || (s == "unknown") ) { 
		printf("<true>\n");
		printf("<false>\n");
		printf("<unknown>\n");
		printf("\n");
		printf("	return true, false, unknown\n");
		printf("\n");
	} else if ((s == "!") ) { 
		printf("<!>\n");
		printf("	cut operator\n");
		printf("\n");
		printf("EBNF Syntax analysis\n");
		printf("\n");
	} else if ((s == "TOKEN") ) { 
		printf("<TOKEN VAR PRED...>\n");
		printf("\n");
		printf("	After syntax-analysis PRED execution of an input, \n");
		printf("	obtained token is set as VAR.\n");
		printf("\n");
	} else if ((s == "SKIPSPACE") ) { 
		printf("<SKIPSPACE>\n");
		printf("\n");
		printf("	The space of an input is skipped.\n");
		printf("\n");
	} else if ((s == "C") ) { 
		printf("<C [VAR]>\n");
		printf("\n");
		printf("	An input is set as one-character VAR.\n");
		printf("\n");
	} else if ((s == "N") ) { 
		printf("<N [VAR]>\n");
		printf("\n");
		printf("	When an input is a number, it is set as VAR. \n");
		printf("	unknown is returned when different.\n");
		printf("\n");
		printf("\n");
	} else if ((s == "A") ) { 
		printf("<A [VAR]>\n");
		printf("\n");
		printf("	When an input is the ASCII character, it is set as VAR. \n");
		printf("	unknown is returned when different.\n");
		printf("\n");
	} else if ((s == "AN") ) { 
		printf("<AN [VAR]>\n");
		printf("\n");
		printf("	When an input is the ASCII character or a number, \n");
		printf("	it is set as VAR. unknown is returned when different.\n");
		printf("\n");
	} else if ((s == "^") ) { 
		printf("<^>\n");
		printf("	The head of a line is matched.\n");
		printf("\n");
	} else if ((s == "$") ) { 
		printf("<$>\n");
		printf("	The last of a line is matched.\n");
		printf("\n");
	} else if ((s == "*") ) { 
		printf("<* [VAR]>\n");
		printf("	Arbitrary character strings are matched.\n");
		printf("\n");
	} else if ((s == "CR") ) { 
		printf("<CR>\n");
		printf("\n");
		printf("	true is returned when an input is a CR. \n");
		printf("	unknown is returned when different.\n");
		printf("\n");
	} else if ((s == "CNTL") ) { 
		printf("<CNTL [VAR]>\n");
		printf("\n");
		printf("	When an input is the CNTL character, it is set as VAR. \n");
		printf("	unknown is returned when different.\n");
		printf("\n");
	} else if ((s == "EOF") ) { 
		printf("<EOF>\n");
		printf("\n");
		printf("	true is returned when an input is a EOF(End Of FIle). \n");
		printf("	unknown is returned when different.\n");
		printf("\n");
	} else if ((s == "SPACE") ) { 
		printf("<SPACE>\n");
		printf("\n");
		printf("	true is returned when an input is a space. unknown is \n");
		printf("	returned when different.\n");
		printf("\n");
	} else if ((s == "PUNCT") ) { 
		printf("<PUNCT [VAR]>\n");
		printf("\n");
		printf("	true is returned when it is characters other than the \n");
		printf("	alphabet and a number.\n");
		printf("\n");
	} else if ((s == "WORD") ) { 
		printf("<WORD [VAR]>\n");
		printf("\n");
		printf("	In STRINGS(s) other than the alphabet, a number, \n");
		printf("	and _, unknown is returned by arbitrary STRINGS.\n");
		printf("\n");
	} else if ((s == "NUM") ) { 
		printf("<NUM [VAR]>\n");
		printf("\n");
		printf("	The integer of an input is is set as VAR.\n");
		printf("\n");
	} else if ((s == "FNUM") ) { 
		printf("<FNUM [VAR]>\n");
		printf("\n");
		printf("	The floating point number of an input is set as VAR.\n");
		printf("\n");
	} else if ((s == "ID") ) { 
		printf("<ID [VAR]>\n");
		printf("\n");
		printf("	If an input STRINGS (a head is the alphabet and a \n");
		printf("	number is also good except it) and it agrees, it \n");
		printf("	will be set as VAR.\n");
		printf("\n");
	} else if ((s == "RANGE") || (s == "NONRANGE") ) { 
		printf("<RANGE VAR CHAR1 CHAR2>\n");
		printf("<NONRANGE VAR CHAR1 CHAR2>\n");
		printf("\n");
		printf("	It will be set to true if contained in the range of \n");
		printf("	a character 1 and a character 2.\n");
		printf("\n");
	} else if ((s == "GETTOKEN") ) { 
		printf("<GETTOKEN VAR>\n");
		printf("\n");
		printf("	The token which is a result of the last syntax \n");
		printf("	analysis is set as VAR.\n");
		printf("\n");
		printf("\n");
	} else if ((s == "newObj") ) { 
		printf("::sys <newObj NAME>\n");
		printf("\n");
		printf("	create a new NAME object.\n");
		printf("\n");
	} else if ((s == "delObj") ) { 
		printf("::sys <delObj NAME>\n");
		printf("\n");
		printf("	delete NAME objects.\n");
		printf("\n");
	} else if ((s == "args") ) { 
		printf("::sys <args VAR>\n");
		printf("\n");
		printf("	ARG when starting the Descartes language is \n");
		printf("	assigned to VAR.\n");
		printf("\n");
	} else if ((s == "DLIBPATH") ) { 
		printf("::sys <DLIBPATH VAR>\n");
		printf("\n");
		printf("	The path DLIBPATH which the Descartes language \n");
		printf("	uses is displayed on VAR. \n");
		printf("\n");
	} else if ((s == "mkpred") ) { 
		printf("::sys <mkpred ARG>\n");
		printf("\n");
		printf("	ARG is changed into PRED.\n");
		printf("\n");
	} else if ((s == "writenl") ) { 
		printf("::sys <writenl LIST>\n");
		printf("\n");
		printf("	After outputting LIST, a new line is started.\n");
		printf("\n");
	} else if ((s == "write") || (s == "w") ) { 
		printf("::sys <write LIST>\n");
		printf("::sys <w LIST>\n");
		printf("\n");
		printf("	Outputting LIST.\n");
		printf("\n");
	} else if ((s == "wnl") ) { 
		printf("::sys <wnl>\n");
		printf("\n");
		printf("	A new-line is outputted.\n");
		printf("\n");
	} else if ((s == "wo") ) { 
		printf("::sys <wo NUMBER>\n");
		printf("\n");
		printf("	NUMBER is outputted by the octal number.\n");
		printf("\n");
	} else if ((s == "wx") ) { 
		printf("::sys <wx NUMBER>\n");
		printf("\n");
		printf("	NUMBER is outputted by a hexadecimal number.\n");
		printf("\n");
	} else if ((s == "wf") ) { 
		printf("::sys <wf NUMBER>\n");
		printf("\n");
		printf("	NUMBER is outputted as a floating point number.\n");
		printf("\n");
	} else if ((s == "wg") ) { 
		printf("::sys <wg NUMBER>\n");
		printf("\n");
		printf("	NUMBER is outputted in a floating point number \n");
		printf("	and the optimal form.\n");
		printf("\n");
	} else if ((s == "wtab") ) { 
		printf("::sys <wtab>\n");
		printf("\n");
		printf("	A tab is outputted.\n");
		printf("\n");
	} else if ((s == "fr") ) { 
		printf("::sys <fr VAR STRINGS WIDTH>\n");
		printf("\n");
		printf("	The result of having carried out flush right \n");
		printf("	of the STRINGS by width is set as VAR.\n");
		printf("\n");
	} else if ((s == "fl") ) { 
		printf("::sys <fl VAR STRINGS WIDTH>\n");
		printf("\n");
		printf("	The result of having carried out flush left \n");
		printf("	of the STRINGS by width is set as VAR.\n");
		printf("\n");
	} else if ((s == "isNil") || (s == "isAtom") || (s == "isList") || (s == "isPred") || (s == "isVar") || (s == "isUndefVar") || (s == "isFloat") || (s == "isInteger") ) { 
		printf("::sys <isNil ARG>\n");
		printf("::sys <isAtom ARG>\n");
		printf("::sys <isList ARG>\n");
		printf("::sys <isPred ARG>\n");
		printf("::sys <isVar ARG>\n");
		printf("::sys <isUndefVar ARG>\n");
		printf("::sys <isFloat ARG>\n");
		printf("::sys <isInteger ARG>\n");
		printf("\n");
		printf("	true will be returned, if ARG is judged and it \n");
		printf("	corresponds. unknown is returned if it does not \n");
		printf("	correspond.\n");
		printf("\n");
	} else if ((s == "isTrue") || (s == "isFalse") || (s == "isUnknown") ) { 
		printf("::sys <isTrue PRED>\n");
		printf("::sys <isFalse PRED>\n");
		printf("::sys <isUnknown PRED>\n");
		printf("\n");
		printf("	The result of PRED of ARG is judged, and true will \n");
		printf("	be returned if it corresponds. unknown is returned \n");
		printf("	if it does not correspond.\n");
		printf("\n");
	} else if ((s == "max") ) { 
		printf("::sys <max VAR LIST>\n");
		printf("\n");
		printf("	The greatest integer value of the element of a list \n");
		printf("	is set as a variable.\n");
		printf("\n");
	} else if ((s == "min") ) { 
		printf("::sys <min VAR LIST>\n");
		printf("\n");
		printf("	The minimum integer value of the element of a list\n");
		printf("	 is set as a variable.\n");
		printf("\n");
	} else if ((s == "maxf") ) { 
		printf("::sys <maxf VAR LIST>\n");
		printf("\n");
		printf("	The greatest floating point number value of the element of \n");
		printf("	a list is set as a variable.\n");
		printf("\n");
	} else if ((s == "minf") ) { 
		printf("::sys <minf VAR LIST>\n");
		printf("\n");
		printf("	The minimum floating point number value of the element of \n");
		printf("	a list is set as a variable.\n");
		printf("\n");
	} else if ((s == "newobj") ) { 
		printf("::sys <newobj NAME>\n");
		printf("\n");
		printf("	create a new NAME object.\n");
		printf("\n");
	} else if ((s == "delobj") ) { 
		printf("::sys <delobj NAME>\n");
		printf("\n");
		printf("	delete NAME objects.\n");
		printf("\n");
	} else if ((s == "regex") ) { 
		printf("::sys <regex PATTERN STRINGS BEFORE-STRINGS MATCH-STRINGS AFTER-STRINGS>\n");
		printf("\n");
		printf("	The result of having applied the regular expression \n");
		printf("	pattern to STRINGS is set as Match STRINGS, and \n");
		printf("	STRINGS of order is set as front STRINGS and back \n");
		printf("	STRINGS. (It does not operate on Windows.)\n");
		printf("\n");
	} else if ((s == "sub") ) { 
		printf("::sys <sub PATTERN STRINGS CORRESDED-STRINGS AFTER-STRINGS>\n");
		printf("\n");
		printf("	The result of having transposed the portion which \n");
		printf("	corresponded to STRINGS with the application of \n");
		printf("	the regular expression pattern to Substitution \n");
		printf("	STRINGS is set as Output STRINGS. Replacement \n");
		printf("	is performed only once. \n");
		printf("	(It does not operate on Windows.)\n");
		printf("\n");
	} else if ((s == "gsub") ) { 
		printf("::sys <gsub PATTERN STRINGS CORRESDED-STRINGS AFTER-STRINGS>\n");
		printf("\n");
		printf("	The result of having transposed the portion which \n");
		printf("	corresponded to STRINGS with the application of \n");
		printf("	the regular expression pattern to Substitution \n");
		printf("	STRINGS is set as Output STRINGS. Replacement is \n");
		printf("	performed into all the applicable portions of \n");
		printf("	STRINGS. (It does not operate on Windows.)\n");
		printf("\n");
	} else if ((s == "split") ) { 
		printf("::sys <split VAR STRINGS [DELIMITER]>\n");
		printf("\n");
		printf("	What divided STRINGS by the DELIMITER and was \n");
		printf("	set to LIST is set as VAR. When the delimiter \n");
		printf("	is not specified, it is divided with a blank \n");
		printf("	and a tab.\n");
		printf("\n");
	} else if ((s == "toupper") ) { 
		printf("::sys <toupper VAR STRINGS>\n");
		printf("\n");
		printf("	A character string is made into a capital letter.\n");
		printf("\n");
	} else if ((s == "tolower") ) { 
		printf("::sys <tolower VAR STRINGS>\n");
		printf("\n");
		printf("	A character string is made into a small letter.\n");
		printf("\n");
	} else if ((s == "length") ) { 
		printf("::sys <length VAR LIST>\n");
		printf("\n");
		printf("	The length of LIST is set as VAR.\n");
		printf("\n");
	} else if ((s == "random") ) { 
		printf("::sys <random VAR>\n");
		printf("\n");
		printf("	A random number is assigned to VAR.\n");
		printf("\n");
	} else if ((s == "sin") || (s == "cos") || (s == "tan") ) { 
		printf("::sys <sin VAR RADIAN>\n");
		printf("::sys <cos VAR RADIAN>\n");
		printf("::sys <tan VAR RADIAN>\n");
		printf("\n");
		printf("	Trigonometric functions\n");
		printf("\n");
	} else if ((s == "asin") || (s == "acos") || (s == "atan") ) { 
		printf("::sys <asin VAR VAL>\n");
		printf("::sys <acos VAR VAL>\n");
		printf("::sys <atan VAR VAL>\n");
		printf("\n");
		printf("	Inverse trigonometric function\n");
		printf("\n");
	} else if ((s == "sinh") || (s == "cosh") || (s == "tanh") ) { 
		printf("::sys <sinh VAR RADIAN>\n");
		printf("::sys <cosh VAR RADIAN>\n");
		printf("::sys <tanh VAR RADIAN>\n");
		printf("\n");
		printf("	Hyperbolic trigonometric functions\n");
		printf("\n");
	} else if ((s == "asinh") || (s == "acosh") || (s == "atanh") ) { 
		printf("::sys <asinh VAR VAL>\n");
		printf("::sys <acosh VAR VAL>\n");
		printf("::sys <atanh VAR VAL>\n");
		printf("\n");
		printf("	Hyperbolic inverse trigonometric function\n");
		printf("\n");
	} else if ((s == "log") || (s == "log10") || (s == "exp") || (s == "pow") ) { 
		printf("::sys <log VAR VAL>\n");
		printf("::sys <log10 VAR VAL>\n");
		printf("::sys <exp VAR VAL>\n");
		printf("::sys <pow VAR VAL1 VAL2>\n");
		printf("\n");
		printf("	Logarithmic function\n");
		printf("\n");
	} else if ((s == "sqrt") ) { 
		printf("::sys <sqrt VAR VAL>\n");
		printf("\n");
		printf("	Square root\n");
		printf("\n");
	} else if ((s == "abs") ) { 
		printf("::sys <abs VAR VAL>\n");
		printf("\n");
		printf("	Absolute value\n");
		printf("\n");
	} else if ((s == "int") ) { 
		printf("::sys <int VAR VAL>\n");
		printf("\n");
		printf("	Integral value\n");
		printf("\n");
	} else if ((s == "floor") ) { 
		printf("::sys <floor VAR VAL>\n");
		printf("\n");
		printf("	largest integral value not greater than argument\n");
		printf("\n");
	} else if ((s == "car") || (s == "cdr") ) { 
		printf("::sys <car VAR LIST>\n");
		printf("::sys <cdr VAR LIST>\n");
		printf("\n");
		printf("	car, cdr of LIST\n");
		printf("\n");
	} else if ((s == "cons") ) { 
		printf("::sys <cons VAR LIST1 LIST2>\n");
		printf("\n");
		printf("	Connection of LIST\n");
		printf("\n");
	} else if ((s == "code") ) { 
		printf("::sys <code CODE-NAME>\n");
		printf("\n");
		printf("	A setup of a character code. \n");
		printf("	UTF8, EUCJP, and SJIS can be specified.\n");
		printf("\n");
	} else if ((s == "char") ) { 
		printf("::sys <char VAR STRINGS>\n");
		printf("\n");
		printf("	STRINGS is decomposed for every be character, and it \n");
		printf("	is made LIST, and is set as VAR. A multibyte character \n");
		printf("	like a Japanese character is also right, and it is every \n");
		printf("	character. \n");
		printf("\n");
	} else if ((s == "byte") ) { 
		printf("::sys <byte VAR STRINGS>\n");
		printf("\n");
		printf("	STRINGS is decomposed for every character code, \n");
		printf("	and it is made LIST, and is set as VAR.\n");
		printf("\n");
	} else if ((s == "asciichar") || (s == "utf8char") || (s == "eucchar") || (s == "sjischar") ) { 
		printf("::sys <asciichar VAR STRINGS>\n");
		printf("::sys <utf8char VAR STRINGS>\n");
		printf("::sys <eucchar VAR STRINGS>\n");
		printf("::sys <sjischar VAR STRINGS>\n");
		printf("\n");
		printf("	STRINGS is decomposed for every character code, \n");
		printf("	and it is made LIST, and is set as VAR.\n");
		printf("\n");
	} else if ((s == "concat") ) { 
		printf("::sys <concat VAR LIST>\n");
		printf("\n");
		printf("	Strings LIST is made to unite, STRINGS is compounded and \n");
		printf("	it is set as VAR.\n");
		printf("\n");
	} else if ((s == "concatcode") ) { 
		printf("::sys <concatcode VAR LIST>\n");
		printf("\n");
		printf("	Character code LIST is made to unite, STRINGS is compounded and \n");
		printf("	it is set as VAR.\n");
		printf("\n");
	} else if ((s == "bitand") || (s == "bitor") || (s == "bitxor") || (s == "bitnot") ) { 
		printf("::sys <bitand VAR NUMBER1 NUMBER2>\n");
		printf("::sys <bitor VAR NUMBER1 NUMBER2>\n");
		printf("::sys <bitxor VAR NUMBER1 NUMBER2>\n");
		printf("::sys <bitnot VAR NUMBER1>\n");
		printf("\n");
		printf("	bit operation\n");
		printf("\n");
	} else if ((s == "shiftl") || (s == "shiftr") ) { 
		printf("::sys <shiftl VAR NUMBER SHIFT>\n");
		printf("::sys <shiftr VAR NUMBER SHIFT>\n");
		printf("\n");
		printf("	The bit shift of an integral value. shiftl is shifted \n");
		printf("	to the left and shifutr is shifted to the right.\n");
		printf("\n");
	} else if ((s == "eq") || (s == "noteq") || (s == "is") ) { 
		printf("::sys <eq ARG1 ARG2>\n");
		printf("::sys <noteq ARG1 ARG2>\n");
		printf("::sys <is ARG1 ARG2>\n");
		printf("\n");
		printf("	Comparison of ARG1 and ARG2\n");
		printf("\n");
	} else if ((s == "getc") ) { 
		printf("::sys <getc VAR>\n");
		printf("\n");
		printf("	One character is inputted into VAR.\n");
		printf("\n");
	} else if ((s == "putc") ) { 
		printf("::sys <putc CHAR>\n");
		printf("\n");
		printf("	One character is outputted.\n");
		printf("\n");
	} else if ((s == "getline") ) { 
		printf("::sys <getline VAR [PRED...]>\n");
		printf("\n");
		printf("	One line is inputted and it is set as VAR. When \n");
		printf("	PRED is set up, PRED is performed by considering \n");
		printf("	a tmp file as an input.\n");
		printf("\n");
	} else if ((s == "syntax") ) { 
		printf("::sys <syntax STRINGS PRED...>\n");
		printf("\n");
		printf("	A predicate is performed by making a character string \n");
		printf("	into an input file.\n");
		printf("\n");
	} else if ((s == "tmpfile") ) { 
		printf("::sys <tmpfile VAR>\n");
		printf("\n");
		printf("	Temporary FILE NAME is set as VAR\n");
		printf("\n");
		printf("\n");
	} else if ((s == "openr") ) { 
		printf("::sys <openr FILE-NAME PRED...>\n");
		printf("\n");
		printf("	The file of FILE-NAME is opened in postscript \n");
		printf("	reading, and PRED is performed.\n");
		printf("\n");
	} else if ((s == "openw") ) { 
		printf("::sys <openw FILE-NAME PRED...>\n");
		printf("\n");
		printf("	The file of FILE-NAME is opened in postscript \n");
		printf("	writing, and PRED is performed.\n");
		printf("\n");
	} else if ((s == "openwp") ) { 
		printf("::sys <openwp FILE-NAME PRED...>\n");
		printf("\n");
		printf("	The file of FILE-NAME is opened in postscript \n");
		printf("	writing, and PRED is performed.\n");
		printf("\n");
	} else if ((s == "gettime") ) { 
		printf("::sys <gettime VAR>\n");
		printf("\n");
		printf("	The present time is set as a variable by a micro second bit.\n");
		printf("\n");
	} else if ((s == "time") ) { 
		printf("::sys <time VAR>\n");
		printf("\n");
		printf("	List of (the user time, sys time, and elapsed time) \n");
		printf("	of the predicate under execution is set as a variable.\n");
		printf("\n");
	} else if ((s == "date") ) { 
		printf("::sys <date>\n");
		printf("\n");
		printf("	Time is set as a variable.\n");
		printf("\n");
		printf("\n");
		printf("\n");
	} else if ((s == "countnode") ) { 
		printf("::sys <countnode VAR>\n");
		printf("\n");
		printf("	The number of nodes currently used is set as VAR.\n");
		printf("\n");
	} else if ((s == "gc") ) { 
		printf("::sys <gc>\n");
		printf("\n");
		printf("	A garbage collector is started.\n");
		printf("\n");
		printf("\n");
	}

	return 1;
}

int HelpBuiltinCmd()
{
	printf("Builtin predicate: \n");

	printf("alt, ");
	printf("assert, ");
	printf("asserta, ");
	printf("assertz, ");
	printf("cd, ");
	printf("edit, ");
	printf("dir, ");
	printf("ls, ");
	printf("compare, ");
	printf("comparef, ");
	printf("erase, ");
	printf("retract, ");
	printf("retractpred, ");
	printf("f, ");
	printf("func, ");
	printf("findall, ");
	printf("for, ");
	printf("for, ");
	printf("foreach, ");
	printf("map, ");
	printf("let, ");
	printf("letf, ");
	printf("list, ");
	printf("load, ");
	printf("loop, ");
	printf("module, ");
	printf("new, ");
	printf("obj, ");
	printf("unify, ");
	printf("or, ");
	printf("print, ");
	printf("pwd, ");
	printf("quit, ");
	printf("quote, ");
	printf("rpn, ");
	printf("rpnf, ");
	printf("save, ");
	printf("timeout, ");
	printf("troff, ");
	printf("tron, ");
	printf("true, ");
	printf("false, ");
	printf("unknown, ");
	printf("!, ");
	printf("TOKEN, ");
	printf("SKIPSPACE, ");
	printf("C, ");
	printf("N, ");
	printf("A, ");
	printf("AN, ");
	printf("^, ");
	printf("$, ");
	printf("*, ");
	printf("CR, ");
	printf("CNTL, ");
	printf("EOF, ");
	printf("SPACE, ");
	printf("PUNCT, ");
	printf("WORD, ");
	printf("NUM, ");
	printf("FNUM, ");
	printf("ID, ");
	printf("RANGE, ");
	printf("NONRANGE, ");
	printf("GETTOKEN, ");

	printf("\n\n");
	return 1;
}

int HelpSysCmd()
{
	printf("Sys MODULE predicate: \n");

	printf("args, ");
	printf("DLIBPATH, ");
	printf("mkpred, ");
	printf("writenl, ");
	printf("write, ");
	printf("w, ");
	printf("wnl, ");
	printf("wo, ");
	printf("wx, ");
	printf("wf, ");
	printf("wg, ");
	printf("wtab, ");
	printf("fr, ");
	printf("fl, ");
	printf("isNil, ");
	printf("isAtom, ");
	printf("isList, ");
	printf("isPred, ");
	printf("isVar, ");
	printf("isUndefVar, ");
	printf("isFloat, ");
	printf("isInteger, ");
	printf("isTrue, ");
	printf("isFalse, ");
	printf("isUnknown, ");
	printf("max, ");
	printf("min, ");
	printf("maxf, ");
	printf("minf, ");
	printf("newobj, ");
	printf("delobj, ");
	printf("regex, ");
	printf("sub, ");
	printf("gsub, ");
	printf("split, ");
	printf("toupper, ");
	printf("tolower, ");
	printf("length, ");
	printf("setvar, ");
	printf("delvar, ");
	printf("VAR, ");
	printf("setarray, ");
	printf("delarray, ");
	printf("VAR, ");
	printf("VAR, ");
	printf("random, ");
	printf("sin, ");
	printf("cos, ");
	printf("tan, ");
	printf("asin, ");
	printf("acos, ");
	printf("atan, ");
	printf("sinh, ");
	printf("cosh, ");
	printf("tanh, ");
	printf("asinh, ");
	printf("acosh, ");
	printf("atanh, ");
	printf("log, ");
	printf("log10, ");
	printf("exp, ");
	printf("pow, ");
	printf("sqrt, ");
	printf("abs, ");
	printf("int, ");
	printf("floor, ");
	printf("car, ");
	printf("cdr, ");
	printf("cons, ");
	printf("code, ");
	printf("char, ");
	printf("byte, ");
	printf("asciichar, ");
	printf("utf8char, ");
	printf("eucchar, ");
	printf("sjischar, ");
	printf("concat, ");
	printf("concatcode, ");
	printf("bitand, ");
	printf("bitor, ");
	printf("bitxor, ");
	printf("bitnot, ");
	printf("shiftl, ");
	printf("shiftr, ");
	printf("eq, ");
	printf("noteq, ");
	printf("is, ");
	printf("getc, ");
	printf("putc, ");
	printf("getline, ");
	printf("syntax, ");
	printf("tmpfile, ");
	printf("openr, ");
	printf("openw, ");
	printf("openwp, ");
	printf("gettime, ");
	printf("time, ");
	printf("date, ");
	printf("countnode, ");
	printf("gc ");

	printf("\n\n");
	return 1;
}

int HelpBuiltin(char* name)
{
	std::string sname = (const char*)name;

	printf("Builtin PREDICATION\n");
	printf("\n");
	printf("  Unlike a library module, an builtin predicate is called without\n");
	printf("specifying a liblary-module name.\n");
	printf("\n");
	printf("---------------------------------------------------------------\n");
	printf("\n");
	printf("<alt PRED...>\n");
	printf("\n");
	printf("	Alternative predicate execution is shown.\n");
	printf("	Even if the results of Argument PRED are true, false,\n");
	printf("	and unknown, it is certainly set to true.\n");
	printf("	It expresses [PRED...] as substitution.It uses by syntax\n");
	printf("	analysis as [] of the method of EBNF.\n");
	printf("\n");
	printf("<assert CLAUSE>\n");
	printf("<asserta CLAUSE>\n");
	printf("<assertz CLAUSE>\n");
	printf("\n");
	printf("	CLAUSE is added.\n");
	printf("	asserta is added to a head and assertz is added at\n");
	printf("	the end.\n");
	printf("	assert is the same as asserta and is added to a head.\n");
	printf("\n");
	printf("<cd PATH>\n");
	printf("\n");
	printf("	A current directory is moved to the PATH specified\n");
	printf("	by the argument.\n");
	printf("\n");
	printf("<edit FILE-NAME>\n");
	printf("\n");
	printf("	A FILE-NAME is edited using the editor set as the \n");
	printf("	environment variables DEDITORPATH and EDITOR.\n");
	printf("\n");
	printf("<dir>\n");
	printf("<ls>\n");
	printf("\n");
	printf("	A current directory is displayed.\n");
	printf("\n");
	printf("<compare EXPRESSION>\n");
	printf("<comparef EXPRESSION>\n");
	printf("\n");
	printf("	EXPRESSION is evaluated.\n");
	printf("	compare is an integer and comparef is comparison of\n");
	printf("	a float number.\n");
	printf("\n");
	printf("<erase CLAUSE-NAME>\n");
	printf("<retract CLAUSE-NAME>\n");
	printf("\n");
	printf("	All the programs corresponding to CLAUSE-NAME are\n");
	printf("	deleted.\n");
	printf("\n");
	printf("<retractpred HEAD-NAME>\n");
	printf("\n");
	printf("	All the programs corresponding to HEAD-NAME are\n");
	printf("	deleted.\n");
	printf("\n");
	printf("<f VAR PRED...>\n");
	printf("<func VAR PRED...>\n");
	printf("\n");
	printf("	Execution evaluation of the function predicate contained\n");
	printf("	in PRED-LIST is carried out. A value is replaced.\n");
	printf("	After performing all, a result is set to a variable.\n");
	printf("\n");
	printf("<findall PRED...>\n");
	printf("\n");
	printf("	PRED is performed and all the solutions are calculated.\n");
	printf("\n");
	printf("<for (VAR lastvalue) PRED...>\n");
	printf("<for (VAR initialvalue lastvalue) PRED...>\n");
	printf("\n");
	printf("	The predicate of the specified number of times and an\n");
	printf("	argument is performed.\n");
	printf("	When the initial value is not specified, the value\n");
	printf("	from 0 is set to a VAR.\n");
	printf("\n");
	printf("<foreach (VAR LIST) PRED...>\n");
	printf("<map (VAR LIST) PRED...>\n");
	printf("\n");
	printf("	PRED of arguments are performed for every element\n");
	printf("	of LIST.\n");
	printf("	The value of a list is set to a variable in order.\n");
	printf("	<include FILENAME>\n");
	printf("	The library of a FILE-NAME is read.\n");
	printf("\n");
	printf("<let EXPRESSION>\n");
	printf("<letf EXPRESSION>\n");
	printf("\n");
	printf("	Expression is calculated.\n");
	printf("	A calculation result is substituted when the left\n");
	printf("	side is a variable.\n");
	printf("	When the left side is a numerical value, it is\n");
	printf("	judged whether it is equal to a calculation result.\n");
	printf("	let calculates an integer and letf is calculation\n");
	printf("	of floating number.\n");
	printf("\n");
	printf("<list>\n");
	printf("\n");
	printf("	A program list is displayed.\n");
	printf("\n");
	printf("<load FILE-NAME>\n");
	printf("\n");
	printf("	The program of a FILE-NAME is read.\n");
	printf("\n");
	printf("<loop PRED...>\n");
	printf("\n");
	printf("	A repetition of predicate execution is shown.\n");
	printf("	It was called inside. Failure of a predicate\n");
	printf("	will escape from a loop.\n");
	printf("	It is the predicate which is surely successful\n");
	printf("	by true,\n");
	printf("	It expresses {PRED...} as substitution.\n");
	printf("	It uses by syntax analysis as {} of the method\n");
	printf("	of EBNF.\n");
	printf("\n");
	printf("<module VAR>\n");
	printf("\n");
	printf("	The library module used now is set to a variable.\n");
	printf("\n");
	printf("<new>\n");
	printf("\n");
	printf("	All log rum is cleared.\n");
	printf("	<not PRED...>\n");
	printf("	false is returned when predicate execution is true.\n");
	printf("	In false, true is returned.\n");
	printf("	In unknown, unknown is returned.\n");
	printf("\n");
	printf("<obj OBJECTNAME PRED...>\n");
	printf("<unify MODULENAME PRED...>\n");
	printf("\n");
	printf("	A predicate is performed using the specified object\n");
	printf("	or module.\n");
	printf("	A module is the same as an object.\n");
	printf("	It can be described as ::object <PRED...> as an\n");
	printf("	omitted type.\n");
	printf("\n");
	printf("<or PRED PRED PRED ...>\n");
	printf("\n");
	printf("	In the place which performed the predicate of the\n");
	printf("	argument from the head and was set to true Processing\n");
	printf("	is closed and true is returned.\n");
	printf("	In the place which performed the predicate of the argument\n");
	printf("	from the head and was set to false Processing is closed\n");
	printf("	and false is returned.\n");
	printf("	unknown is returned when all the predicates are unknown.\n");
	printf("	It uses by syntax analysis as | of the method\n");
	printf("	of EBNF.\n");
	printf("\n");
	printf("<print LIST>\n");
	printf("\n");
	printf("	fter outputting a list, a new line is started.\n");
	printf("	<writenl LIST> is the same as <print LIST>.\n");
	printf("\n");
	printf("<pwd VAR>\n");
	printf("\n");
	printf("	The current directory is set to VAR.\n");
	printf("\n");
	printf("<quit>\n");
	printf("\n");
	printf("	Execution of a program is stopped and it ends.\n");
	printf("\n");
	printf("<quote PRED>\n");
	printf("\n");
	printf("	Evaluation of the function predicate of an argument\n");
	printf("	is deterred.\n");
	printf("\n");
	printf("<rpn VAR RPNEXPRESSION>\n");
	printf("<rpnf VAR RPNEXPRESSION>\n");
	printf("\n");
	printf("	A reverse Poland style is calculated and a result\n");
	printf("	is set to a variable.\n");
	printf("	rpn calculates an integer and rpnf calculates floating\n");
	printf("	number.\n");
	printf("\n");
	printf("<save FILE-NAME>\n");
	printf("\n");
	printf("	The program of a FILE-NAME is written in.\n");
	printf("\n");
	printf("<timeout limittime PRED>\n");
	printf("\n");
	printf("	Within the set-up time, when execution of a predicate\n");
	printf("	is not completed, processing is closed, and unknown is\n");
	printf("	returned. A set period is a micro second bit.\n");
	printf("\n");
	printf("<troff>\n");
	printf("\n");
	printf("	Debugging trace is turned OFF.\n");
	printf("\n");
	printf("<tron>\n");
	printf("\n");
	printf("	Debugging trace is turned ON.\n");
	printf("\n");
	printf("<true>\n");
	printf("<false>\n");
	printf("<unknown>\n");
	printf("\n");
	printf("	return true, false, unknown\n");
	printf("\n");
	printf("<!>\n");
	printf("	cut operator\n");
	printf("\n");
	printf("EBNF Syntax analysis\n");
	printf("\n");
	printf("<TOKEN VAR PRED...>\n");
	printf("\n");
	printf("	After syntax-analysis PRED execution of an input, \n");
	printf("	obtained token is set as VAR.\n");
	printf("\n");
	printf("<SKIPSPACE>\n");
	printf("\n");
	printf("	The space of an input is skipped.\n");
	printf("\n");
	printf("<C [VAR]>\n");
	printf("\n");
	printf("	An input is set as one-character VAR.\n");
	printf("\n");
	printf("<N [VAR]>\n");
	printf("\n");
	printf("	When an input is a number, it is set as VAR. \n");
	printf("	unknown is returned when different.\n");
	printf("\n");
	printf("\n");
	printf("<A [VAR]>\n");
	printf("\n");
	printf("	When an input is the ASCII character, it is set as VAR. \n");
	printf("	unknown is returned when different.\n");
	printf("\n");
	printf("<AN [VAR]>\n");
	printf("\n");
	printf("	When an input is the ASCII character or a number, \n");
	printf("	it is set as VAR. unknown is returned when different.\n");
	printf("\n");
	printf("<^>\n");
	printf("	The head of a line is matched.\n");
	printf("\n");
	printf("<$>\n");
	printf("	The last of a line is matched.\n");
	printf("\n");
	printf("<* [VAR]>\n");
	printf("	Arbitrary character strings are matched.\n");
	printf("\n");
	printf("<CR>\n");
	printf("\n");
	printf("	true is returned when an input is a CR. \n");
	printf("	unknown is returned when different.\n");
	printf("\n");
	printf("<CNTL [VAR]>\n");
	printf("\n");
	printf("	When an input is the CNTL character, it is set as VAR. \n");
	printf("	unknown is returned when different.\n");
	printf("\n");
	printf("<EOF>\n");
	printf("\n");
	printf("	true is returned when an input is a EOF(End Of FIle). \n");
	printf("	unknown is returned when different.\n");
	printf("\n");
	printf("<SPACE>\n");
	printf("\n");
	printf("	true is returned when an input is a space. unknown is \n");
	printf("	returned when different.\n");
	printf("\n");
	printf("<PUNCT [VAR]>\n");
	printf("\n");
	printf("	true is returned when it is characters other than the \n");
	printf("	alphabet and a number.\n");
	printf("\n");
	printf("<WORD [VAR]>\n");
	printf("\n");
	printf("	In STRINGS(s) other than the alphabet, a number, \n");
	printf("	and _, unknown is returned by arbitrary STRINGS.\n");
	printf("\n");
	printf("<NUM [VAR]>\n");
	printf("\n");
	printf("	The integer of an input is is set as VAR.\n");
	printf("\n");
	printf("<FNUM [VAR]>\n");
	printf("\n");
	printf("	The floating point number of an input is set as VAR.\n");
	printf("\n");
	printf("<ID [VAR]>\n");
	printf("\n");
	printf("	If an input STRINGS (a head is the alphabet and a \n");
	printf("	number is also good except it) and it agrees, it \n");
	printf("	will be set as VAR.\n");
	printf("\n");
	printf("<RANGE VAR CHAR1 CHAR2>\n");
	printf("<NONRANGE VAR CHAR1 CHAR2>\n");
	printf("\n");
	printf("	It will be set to true if contained in the range of \n");
	printf("	a character 1 and a character 2.\n");
	printf("\n");
	printf("<GETTOKEN VAR>\n");
	printf("\n");
	printf("	The token which is a result of the last syntax \n");
	printf("	analysis is set as VAR.\n");
	printf("\n");
	printf("\n");
	printf("::sys <newObj NAME>\n");
	printf("\n");
	printf("	create a new NAME object.\n");
	printf("\n");
	printf("::sys <delObj NAME>\n");
	printf("\n");
	printf("	delete NAME objects.\n");
	printf("\n");
	printf("\n");

	return 1;
}

int HelpSys(char* name)
{

	printf("sys Module PREDICATION\n");
	printf("\n");
	printf("  A sys module is a set of the library module of the \n");
	printf("standard included in the system. When calling, \n");
	printf("it describes after ::sys.\n");
	printf("\n");
	printf("\n");
	printf("-------------------------------------------------------------------\n");
	printf("\n");
	printf("::sys <args VAR>\n");
	printf("\n");
	printf("	ARG when starting the Descartes language is \n");
	printf("	assigned to VAR.\n");
	printf("\n");
	printf("::sys <DLIBPATH VAR>\n");
	printf("\n");
	printf("	The path DLIBPATH which the Descartes language \n");
	printf("	uses is displayed on VAR. \n");
	printf("\n");
	printf("::sys <mkpred ARG>\n");
	printf("\n");
	printf("	ARG is changed into PRED.\n");
	printf("\n");
	printf("::sys <writenl LIST>\n");
	printf("\n");
	printf("	After outputting LIST, a new line is started.\n");
	printf("\n");
	printf("::sys <write LIST>\n");
	printf("::sys <w LIST>\n");
	printf("\n");
	printf("	Outputting LIST.\n");
	printf("\n");
	printf("::sys <wnl>\n");
	printf("\n");
	printf("	A new-line is outputted.\n");
	printf("\n");
	printf("::sys <wo NUMBER>\n");
	printf("\n");
	printf("	NUMBER is outputted by the octal number.\n");
	printf("\n");
	printf("::sys <wx NUMBER>\n");
	printf("\n");
	printf("	NUMBER is outputted by a hexadecimal number.\n");
	printf("\n");
	printf("::sys <wf NUMBER>\n");
	printf("\n");
	printf("	NUMBER is outputted as a floating point number.\n");
	printf("\n");
	printf("::sys <wg NUMBER>\n");
	printf("\n");
	printf("	NUMBER is outputted in a floating point number \n");
	printf("	and the optimal form.\n");
	printf("\n");
	printf("::sys <wtab>\n");
	printf("\n");
	printf("	A tab is outputted.\n");
	printf("\n");
	printf("::sys <fr VAR STRINGS WIDTH>\n");
	printf("\n");
	printf("	The result of having carried out flush right \n");
	printf("	of the STRINGS by width is set as VAR.\n");
	printf("\n");
	printf("::sys <fl VAR STRINGS WIDTH>\n");
	printf("\n");
	printf("	The result of having carried out flush left \n");
	printf("	of the STRINGS by width is set as VAR.\n");
	printf("\n");
	printf("::sys <isNil ARG>\n");
	printf("::sys <isAtom ARG>\n");
	printf("::sys <isList ARG>\n");
	printf("::sys <isPred ARG>\n");
	printf("::sys <isVar ARG>\n");
	printf("::sys <isUndefVar ARG>\n");
	printf("::sys <isFloat ARG>\n");
	printf("::sys <isInteger ARG>\n");
	printf("\n");
	printf("	true will be returned, if ARG is judged and it \n");
	printf("	corresponds. unknown is returned if it does not \n");
	printf("	correspond.\n");
	printf("\n");
	printf("::sys <isTrue PRED>\n");
	printf("::sys <isFalse PRED>\n");
	printf("::sys <isUnknown PRED>\n");
	printf("\n");
	printf("	The result of PRED of ARG is judged, and true will \n");
	printf("	be returned if it corresponds. unknown is returned \n");
	printf("	if it does not correspond.\n");
	printf("\n");
	printf("::sys <max VAR LIST>\n");
	printf("\n");
	printf("	The greatest integer value of the element of a list \n");
	printf("	is set as a variable.\n");
	printf("\n");
	printf("::sys <min VAR LIST>\n");
	printf("\n");
	printf("	The minimum integer value of the element of a list\n");
	printf("	 is set as a variable.\n");
	printf("\n");
	printf("::sys <maxf VAR LIST>\n");
	printf("\n");
	printf("	The greatest floating point number value of the element of \n");
	printf("	a list is set as a variable.\n");
	printf("\n");
	printf("::sys <minf VAR LIST>\n");
	printf("\n");
	printf("	The minimum floating point number value of the element of \n");
	printf("	a list is set as a variable.\n");
	printf("\n");
	printf("::sys <newobj NAME>\n");
	printf("\n");
	printf("	create a new NAME object.\n");
	printf("\n");
	printf("::sys <delobj NAME>\n");
	printf("\n");
	printf("	delete NAME objects.\n");
	printf("\n");
	printf("::sys <method NAME>\n");
	printf("\n");
	printf("	The method of a new name is generated \n");
	printf("\n");
	printf("::sys <methoda NAME>\n");
	printf("\n");
	printf("	The method of a new name is generated from a head.\n");
	printf("\n");
	printf("::sys <methodz NAME>\n");
	printf("\n");
	printf("	The method of a new name is generated at the end.\n");
	printf("\n");
	printf("::sys <delmethod NAME>\n");
	printf("\n");
	printf("	The method of the specified name is deleted.\n");
	printf("\n");
	printf("::sys <delmethoda NAME>\n");
	printf("\n");
	printf("	The method of the specified name is deleted from a head.\n");
	printf("\n");
	printf("::sys <delmethodz NAME>\n");
	printf("\n");
	printf("	The method of the specified name is deleted from an end.\n");
	printf("\n");
	printf("::sys <regex PATTERN STRINGS BEFORE-STRINGS MATCH-STRINGS AFTER-STRINGS>\n");
	printf("\n");
	printf("	The result of having applied the regular expression \n");
	printf("	pattern to STRINGS is set as Match STRINGS, and \n");
	printf("	STRINGS of order is set as front STRINGS and back \n");
	printf("	STRINGS. (It does not operate on Windows.)\n");
	printf("\n");
	printf("::sys <sub PATTERN STRINGS CORRESDED-STRINGS AFTER-STRINGS>\n");
	printf("\n");
	printf("	The result of having transposed the portion which \n");
	printf("	corresponded to STRINGS with the application of \n");
	printf("	the regular expression pattern to Substitution \n");
	printf("	STRINGS is set as Output STRINGS. Replacement \n");
	printf("	is performed only once. \n");
	printf("	(It does not operate on Windows.)\n");
	printf("\n");
	printf("::sys <gsub PATTERN STRINGS CORRESDED-STRINGS AFTER-STRINGS>\n");
	printf("\n");
	printf("	The result of having transposed the portion which \n");
	printf("	corresponded to STRINGS with the application of \n");
	printf("	the regular expression pattern to Substitution \n");
	printf("	STRINGS is set as Output STRINGS. Replacement is \n");
	printf("	performed into all the applicable portions of \n");
	printf("	STRINGS. (It does not operate on Windows.)\n");
	printf("\n");
	printf("::sys <split VAR STRINGS [DELIMITER]>\n");
	printf("\n");
	printf("	What divided STRINGS by the DELIMITER and was \n");
	printf("	set to LIST is set as VAR. When the delimiter \n");
	printf("	is not specified, it is divided with a blank \n");
	printf("	and a tab.\n");
	printf("\n");
	printf("::sys <toupper VAR STRINGS>\n");
	printf("\n");
	printf("	A character string is made into a capital letter.\n");
	printf("\n");
	printf("::sys <tolower VAR STRINGS>\n");
	printf("\n");
	printf("	A character string is made into a small letter.\n");
	printf("\n");
	printf("::sys <length VAR LIST>\n");
	printf("\n");
	printf("	The length of LIST is set as VAR.\n");
	printf("\n");
	printf("::sys <setvar VAR VAL>\n");
	printf("\n");
	printf("	A value is assigned to global VAR. Global VAR \n");
	printf("	is registered in the form of the following as PRED.\n");
	printf("\n");
	printf("::sys <delvar VAR>\n");
	printf("\n");
	printf("	The variable corresponding to a VAR identifier \n");
	printf("	is deleted.\n");
	printf("\n");
	printf("::sys <VAR VAL>;\n");
	printf("::sys <setarray VAR VAL INDEX>\n");
	printf("\n");
	printf("	A value is set as global VAR arrangement. \n");
	printf("	Global VAR is registered in the form of the \n");
	printf("	following as PRED.\n");
	printf("\n");
	printf("::sys <delarray VAR>\n");
	printf("\n");
	printf("	The variable corresponding to a VAR identifier \n");
	printf("	is deleted.\n");
	printf("\n");
	printf("::sys <VAR VAL INDEX>;\n");
	printf("\n");
	printf("	When carrying out specification of the arrangement \n");
	printf("	of many dimensions, an index is specified as LIST.\n");
	printf("\n");
	printf("::sys <VAR VAL (INDEX1 INDEX2 ...)>\n");
	printf("\n");
	printf("	What kind of kind and form are sufficient as an \n");
	printf("	index besides a number.\n");
	printf("\n");
	printf("::sys <random VAR>\n");
	printf("\n");
	printf("	A random number is assigned to VAR.\n");
	printf("\n");
	printf("::sys <sin VAR RADIAN>\n");
	printf("::sys <cos VAR RADIAN>\n");
	printf("::sys <tan VAR RADIAN>\n");
	printf("\n");
	printf("	Trigonometric functions\n");
	printf("\n");
	printf("::sys <asin VAR VAL>\n");
	printf("::sys <acos VAR VAL>\n");
	printf("::sys <atan VAR VAL>\n");
	printf("\n");
	printf("	Inverse trigonometric function\n");
	printf("\n");
	printf("::sys <sinh VAR RADIAN>\n");
	printf("::sys <cosh VAR RADIAN>\n");
	printf("::sys <tanh VAR RADIAN>\n");
	printf("\n");
	printf("	Hyperbolic trigonometric functions\n");
	printf("\n");
	printf("::sys <asinh VAR VAL>\n");
	printf("::sys <acosh VAR VAL>\n");
	printf("::sys <atanh VAR VAL>\n");
	printf("\n");
	printf("	Hyperbolic inverse trigonometric function\n");
	printf("\n");
	printf("::sys <log VAR VAL>\n");
	printf("::sys <log10 VAR VAL>\n");
	printf("::sys <exp VAR VAL>\n");
	printf("::sys <pow VAR VAL1 VAL2>\n");
	printf("\n");
	printf("	Logarithmic function\n");
	printf("\n");
	printf("::sys <sqrt VAR VAL>\n");
	printf("\n");
	printf("	Square root\n");
	printf("\n");
	printf("::sys <abs VAR VAL>\n");
	printf("\n");
	printf("	Absolute value\n");
	printf("\n");
	printf("::sys <int VAR VAL>\n");
	printf("\n");
	printf("	Integral value\n");
	printf("\n");
	printf("::sys <floor VAR VAL>\n");
	printf("\n");
	printf("	largest integral value not greater than argument\n");
	printf("\n");
	printf("::sys <car VAR LIST>\n");
	printf("::sys <cdr VAR LIST>\n");
	printf("\n");
	printf("	car, cdr of LIST\n");
	printf("\n");
	printf("::sys <cons VAR LIST1 LIST2>\n");
	printf("\n");
	printf("	Connection of LIST\n");
	printf("\n");
	printf("::sys <code CODE-NAME>\n");
	printf("\n");
	printf("	A setup of a character code. \n");
	printf("	UTF8, EUCJP, and SJIS can be specified.\n");
	printf("\n");
	printf("::sys <char VAR STRINGS>\n");
	printf("\n");
	printf("	STRINGS is decomposed for every be character, and it \n");
	printf("	is made LIST, and is set as VAR. A multibyte character \n");
	printf("	like a Japanese character is also right, and it is every \n");
	printf("	character. \n");
	printf("\n");
	printf("::sys <byte VAR STRINGS>\n");
	printf("\n");
	printf("	STRINGS is decomposed for every character code, \n");
	printf("	and it is made LIST, and is set as VAR.\n");
	printf("\n");
	printf("::sys <asciichar VAR STRINGS>\n");
	printf("::sys <utf8char VAR STRINGS>\n");
	printf("::sys <eucchar VAR STRINGS>\n");
	printf("::sys <sjischar VAR STRINGS>\n");
	printf("\n");
	printf("	STRINGS is decomposed for every character code, \n");
	printf("	and it is made LIST, and is set as VAR.\n");
	printf("\n");
	printf("::sys <concat VAR LIST>\n");
	printf("\n");
	printf("	Strings LIST is made to unite, STRINGS is compounded and \n");
	printf("	it is set as VAR.\n");
	printf("\n");
	printf("::sys <concatcode VAR LIST>\n");
	printf("\n");
	printf("	Character code LIST is made to unite, STRINGS is compounded and \n");
	printf("	it is set as VAR.\n");
	printf("\n");
	printf("::sys <bitand VAR NUMBER1 NUMBER2>\n");
	printf("::sys <bitor VAR NUMBER1 NUMBER2>\n");
	printf("::sys <bitxor VAR NUMBER1 NUMBER2>\n");
	printf("::sys <bitnot VAR NUMBER1>\n");
	printf("\n");
	printf("	bit operation\n");
	printf("\n");
	printf("::sys <shiftl VAR NUMBER SHIFT>\n");
	printf("::sys <shiftr VAR NUMBER SHIFT>\n");
	printf("\n");
	printf("	The bit shift of an integral value. shiftl is shifted \n");
	printf("	to the left and shifutr is shifted to the right.\n");
	printf("\n");
	printf("::sys <eq ARG1 ARG2>\n");
	printf("::sys <noteq ARG1 ARG2>\n");
	printf("::sys <is ARG1 ARG2>\n");
	printf("\n");
	printf("	Comparison of ARG1 and ARG2\n");
	printf("\n");
	printf("::sys <getc VAR>\n");
	printf("\n");
	printf("	One character is inputted into VAR.\n");
	printf("\n");
	printf("::sys <putc CHAR>\n");
	printf("\n");
	printf("	One character is outputted.\n");
	printf("\n");
	printf("::sys <getline VAR [PRED...]>\n");
	printf("\n");
	printf("	One line is inputted and it is set as VAR. When \n");
	printf("	PRED is set up, PRED is performed by considering \n");
	printf("	a tmp file as an input.\n");
	printf("\n");
	printf("::sys <syntax STRINGS PRED...>\n");
	printf("\n");
	printf("	A predicate is performed by making a character string \n");
	printf("	into an input file.\n");
	printf("\n");
	printf("::sys <tmpfile VAR>\n");
	printf("\n");
	printf("	Temporary FILE NAME is set as VAR\n");
	printf("\n");
	printf("\n");
	printf("::sys <openr FILE-NAME PRED...>\n");
	printf("\n");
	printf("	The file of FILE-NAME is opened in postscript \n");
	printf("	reading, and PRED is performed.\n");
	printf("\n");
	printf("::sys <openw FILE-NAME PRED...>\n");
	printf("\n");
	printf("	The file of FILE-NAME is opened in postscript \n");
	printf("	writing, and PRED is performed.\n");
	printf("\n");
	printf("::sys <openwp FILE-NAME PRED...>\n");
	printf("\n");
	printf("	The file of FILE-NAME is opened in postscript \n");
	printf("	writing, and PRED is performed.\n");
	printf("\n");
	printf("::sys <gettime VAR>\n");
	printf("\n");
	printf("	The present time is set as a variable by a micro second bit.\n");
	printf("\n");
	printf("::sys <time VAR>\n");
	printf("\n");
	printf("	List of (the user time, sys time, and elapsed time) \n");
	printf("	of the predicate under execution is set as a variable.\n");
	printf("\n");
	printf("::sys <date>\n");
	printf("\n");
	printf("	Time is set as a variable.\n");
	printf("\n");
	printf("\n");
	printf("\n");
	printf("::sys <countnode VAR>\n");
	printf("\n");
	printf("	The number of nodes currently used is set as VAR.\n");
	printf("\n");
	printf("::sys <gc>\n");
	printf("\n");
	printf("	A garbage collector is started.\n");
	printf("\n");
	printf("\n");

	return 1;
}


