/*
 * built-in program copyright (C) 2009 H.Niwa
 */


/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include <string>

#include "syserr.h"

#include "bin_node.h"
#include "gc.h"
#include "var.h"
#include "pred.h"
#include "context.h"
#include "unify.h"
#include "builtin.h"
#include "sysmodule.h"

int HelpPrint(char* mod, char* name);
int HelpBuiltin(char* name);
int HelpSys(char* name);

int Help(Context* cx, Node* goalscar)
{
	HelpBuiltin("");
	HelpSys("");
	return 1;
}


int HelpPrint(char* mod, char* name)
{
	std::string smodule = (const char*)mod;
	std::string sname = (const char*)name;

	if ((smodule == "") || (smodule == "builtin")) {
		return HelpBuiltin(name);
	} else if (smodule == "sys") {
		return HelpSys(name);
	}
}

int HelpBuiltin(char* name)
{
	std::string sname = (const char*)name;

	printf("<alt PRED...>\n");
	printf("\n");
	printf("	Alternative predicate execution is shown.\n");
	printf("	Even if the results of Argument PRED are true, false,\n");
	printf("	and unknown, it is certainly set to true.\n");
	printf("	It expresses [PRED...] as substitution.It uses by syntax\n");
	printf("	analysis as [] of the method of EBNF.\n");
	printf("\n");
	printf("<assert CLAUSE>\n");
	printf("<asserta CLAUSE>\n");
	printf("<assertz CLAUSE>\n");
	printf("\n");
	printf("	CLAUSE is added.\n");
	printf("	asserta is added to a head and assertz is added at\n");
	printf("	the end.\n");
	printf("	assert is the same as asserta and is added to a head.\n");
	printf("\n");
	printf("<cd PATH>\n");
	printf("\n");
	printf("	A current directory is moved to the PATH specified\n");
	printf("	by the argument.\n");
	printf("\n");
	printf("<edit FILE-NAME>\n");
	printf("\n");
	printf("	A FILE-NAME is edited using the editor set as the \n");
	printf("	environment variables DEDITORPATH and EDITOR.\n");
	printf("\n");
	printf("<dir>\n");
	printf("<ls>\n");
	printf("\n");
	printf("	A current directory is displayed.\n");
	printf("\n");
	printf("<compare EXPRESSION>\n");
	printf("<comparef EXPRESSION>\n");
	printf("\n");
	printf("	EXPRESSION is evaluated.\n");
	printf("	compare is an integer and comparef is comparison of\n");
	printf("	a float number.\n");
	printf("\n");
	printf("<erase CLAUSE-NAME>\n");
	printf("<retract CLAUSE-NAME>\n");
	printf("\n");
	printf("	All the programs corresponding to CLAUSE-NAME are\n");
	printf("	deleted.\n");
	printf("\n");
	printf("<retractpred HEAD-NAME>\n");
	printf("\n");
	printf("	All the programs corresponding to HEAD-NAME are\n");
	printf("	deleted.\n");
	printf("\n");
	printf("<f VAR PRED...>\n");
	printf("<func VAR PRED...>\n");
	printf("\n");
	printf("	Execution evaluation of the function predicate contained\n");
	printf("	in PRED-LIST is carried out. A value is replaced.\n");
	printf("	After performing all, a result is set to a variable.\n");
	printf("\n");
	printf("<findall PRED...>\n");
	printf("\n");
	printf("	PRED is performed and all the solutions are calculated.\n");
	printf("\n");
	printf("<for (VAR lastvalue) PRED...>\n");
	printf("<for (VAR initialvalue lastvalue) PRED...>\n");
	printf("\n");
	printf("	The predicate of the specified number of times and an\n");
	printf("	argument is performed.\n");
	printf("	When the initial value is not specified, the value\n");
	printf("	from 0 is set to a VAR.\n");
	printf("\n");
	printf("<foreach (VAR LIST) PRED...>\n");
	printf("<map (VAR LIST) PRED...>\n");
	printf("\n");
	printf("	PRED of arguments are performed for every element\n");
	printf("	of LIST.\n");
	printf("	The value of a list is set to a variable in order.\n");
	printf("	<include FILENAME>\n");
	printf("	The library of a FILE-NAME is read.\n");
	printf("\n");
	printf("<let EXPRESSION>\n");
	printf("<letf EXPRESSION>\n");
	printf("\n");
	printf("	Expression is calculated.\n");
	printf("	A calculation result is substituted when the left\n");
	printf("	side is a variable.\n");
	printf("	When the left side is a numerical value, it is\n");
	printf("	judged whether it is equal to a calculation result.\n");
	printf("	let calculates an integer and letf is calculation\n");
	printf("	of floating number.\n");
	printf("\n");
	printf("<list>\n");
	printf("\n");
	printf("	A program list is displayed.\n");
	printf("\n");
	printf("<load FILE-NAME>\n");
	printf("\n");
	printf("	The program of a FILE-NAME is read.\n");
	printf("\n");
	printf("<loop PRED...>\n");
	printf("\n");
	printf("	A repetition of predicate execution is shown.\n");
	printf("	It was called inside. Failure of a predicate\n");
	printf("	will escape from a loop.\n");
	printf("	It is the predicate which is surely successful\n");
	printf("	by true,\n");
	printf("	It expresses {PRED...} as substitution.\n");
	printf("	It uses by syntax analysis as {} of the method\n");
	printf("	of EBNF.\n");
	printf("\n");
	printf("<module VAR>\n");
	printf("\n");
	printf("	The library module used now is set to a variable.\n");
	printf("\n");
	printf("<new>\n");
	printf("\n");
	printf("	All log rum is cleared.\n");
	printf("	<not PRED...>\n");
	printf("	false is returned when predicate execution is true.\n");
	printf("	In false, true is returned.\n");
	printf("	In unknown, unknown is returned.\n");
	printf("\n");
	printf("<obj OBJECTNAME PRED...>\n");
	printf("<unify MODULENAME PRED...>\n");
	printf("\n");
	printf("	A predicate is performed using the specified object\n");
	printf("	or module.\n");
	printf("	A module is the same as an object.\n");
	printf("	It can be described as ::object <PRED...> as an\n");
	printf("	omitted type.\n");
	printf("\n");
	printf("<or PRED PRED PRED ...>\n");
	printf("\n");
	printf("	In the place which performed the predicate of the\n");
	printf("	argument from the head and was set to true Processing\n");
	printf("	is closed and true is returned.\n");
	printf("	In the place which performed the predicate of the argument\n");
	printf("	from the head and was set to false Processing is closed\n");
	printf("	and false is returned.\n");
	printf("	unknown is returned when all the predicates are unknown.\n");
	printf("	It uses by syntax analysis as | of the method\n");
	printf("	of EBNF.\n");
	printf("\n");
	printf("<print LIST>\n");
	printf("\n");
	printf("	fter outputting a list, a new line is started.\n");
	printf("	<writenl LIST> is the same as <print LIST>.\n");
	printf("\n");
	printf("<pwd VAR>\n");
	printf("\n");
	printf("	The current directory is set to VAR.\n");
	printf("\n");
	printf("<quit>\n");
	printf("\n");
	printf("	Execution of a program is stopped and it ends.\n");
	printf("\n");
	printf("<quote PRED>\n");
	printf("\n");
	printf("	Evaluation of the function predicate of an argument\n");
	printf("	is deterred.\n");
	printf("\n");
	printf("<rpn VAR RPNEXPRESSION>\n");
	printf("<rpnf VAR RPNEXPRESSION>\n");
	printf("\n");
	printf("	A reverse Poland style is calculated and a result\n");
	printf("	is set to a variable.\n");
	printf("	rpn calculates an integer and rpnf calculates floating\n");
	printf("	number.\n");
	printf("\n");
	printf("<save FILE-NAME>\n");
	printf("\n");
	printf("	The program of a FILE-NAME is written in.\n");
	printf("\n");
	printf("<timeout limittime PRED>\n");
	printf("\n");
	printf("	Within the set-up time, when execution of a predicate\n");
	printf("	is not completed, processing is closed, and unknown is\n");
	printf("	returned. A set period is a micro second bit.\n");
	printf("\n");
	printf("<troff>\n");
	printf("\n");
	printf("	Debugging trace is turned OFF.\n");
	printf("\n");
	printf("<tron>\n");
	printf("\n");
	printf("	Debugging trace is turned ON.\n");
	printf("\n");
	printf("<true>\n");
	printf("<false>\n");
	printf("<unknown>\n");
	printf("\n");
	printf("	return true, false, unknown\n");
	printf("\n");
	printf("<!>\n");
	printf("	cut operator\n");
	printf("\n");
	printf("EBNF Syntax analysis\n");
	printf("\n");
	printf("<TOKEN VAR PRED...>\n");
	printf("\n");
	printf("	After syntax-analysis PRED execution of an input, \n");
	printf("	obtained token is set as VAR.\n");
	printf("\n");
	printf("<SKIPSPACE>\n");
	printf("\n");
	printf("	The space of an input is skipped.\n");
	printf("\n");
	printf("<C [VAR]>\n");
	printf("\n");
	printf("	An input is set as one-character VAR.\n");
	printf("\n");
	printf("<N [VAR]>\n");
	printf("\n");
	printf("	When an input is a number, it is set as VAR. \n");
	printf("	unknown is returned when different.\n");
	printf("\n");
	printf("\n");
	printf("<A [VAR]>\n");
	printf("\n");
	printf("	When an input is the ASCII character, it is set as VAR. \n");
	printf("	unknown is returned when different.\n");
	printf("\n");
	printf("<AN [VAR]>\n");
	printf("\n");
	printf("	When an input is the ASCII character or a number, \n");
	printf("	it is set as VAR. unknown is returned when different.\n");
	printf("\n");
	printf("<^>\n");
	printf("	The head of a line is matched.\n");
	printf("\n");
	printf("<$>\n");
	printf("	The last of a line is matched.\n");
	printf("\n");
	printf("<* VAR>\n");
	printf("	Arbitrary character strings are matched.\n");
	printf("\n");
	printf("<CR [VAR]>\n");
	printf("\n");
	printf("	When an input is CR new-line, it is set as VAR. \n");
	printf("	unknown is returned when different.\n");
	printf("\n");
	printf("<CNTL [VAR]>\n");
	printf("\n");
	printf("	When an input is the CNTL character, it is set as VAR. \n");
	printf("	unknown is returned when different.\n");
	printf("\n");
	printf("<EOF [VAR]>\n");
	printf("\n");
	printf("	When an input is the EOF character, it is set as VAR. \n");
	printf("	unknown is returned when different.\n");
	printf("\n");
	printf("<SPACE>\n");
	printf("\n");
	printf("	true is returned when an input is a space. unknown is \n");
	printf("	returned when different.\n");
	printf("\n");
	printf("<PUNCT>\n");
	printf("\n");
	printf("	true is returned when it is characters other than the \n");
	printf("	alphabet and a number.\n");
	printf("\n");
	printf("<STRINGS VAR>\n");
	printf("\n");
	printf("	STRINGS of \"...\" or '...' is matched, and it is set \n");
	printf("	as VAR.\n");
	printf("\n");
	printf("<WORD VAR>\n");
	printf("\n");
	printf("	In STRINGS(s) other than the alphabet, a number, \n");
	printf("	and  _ , unknown is returned by arbitrary STRINGS.\n");
	printf("\n");
	printf("<NUM VAR>\n");
	printf("\n");
	printf("	The integer of an input is is set as VAR.\n");
	printf("\n");
	printf("<FNUM VAR>\n");
	printf("\n");
	printf("	The floating point number of an input is set as VAR.\n");
	printf("\n");
	printf("<ID VAR>\n");
	printf("\n");
	printf("	If an input STRINGS (a head is the alphabet and a \n");
	printf("	number is also good except it) and it agrees, it \n");
	printf("	will be set as VAR.\n");
	printf("\n");
	printf("<RANGE VAR CHAR1 CHAR2>\n");
	printf("<NONRANGE VAR CHAR1 CHAR2>\n");
	printf("\n");
	printf("	It will be set to true if contained in the range of \n");
	printf("	a character 1 and a character 2.\n");
	printf("\n");
	printf("<GETTOKEN VAR>\n");
	printf("\n");
	printf("	The token which is a result of the last syntax \n");
	printf("	analysis is set as VAR.\n");
	printf("\n");
	printf("\n");
}

int HelpSys(char* name)
{
	printf("::sys <args VAR>\n");
	printf("\n");
	printf("	ARG when starting the Descartes language is \n");
	printf("	assigned to VAR.\n");
	printf("\n");
	printf("::sys <DLIBPATH VAR>\n");
	printf("\n");
	printf("	The path DLIBPATH which the Descartes language \n");
	printf("	uses is displayed on VAR. \n");
	printf("\n");
	printf("::sys <mkpred ARG>\n");
	printf("\n");
	printf("	ARG is changed into PRED.\n");
	printf("\n");
	printf("::sys <writenl LIST>\n");
	printf("\n");
	printf("	After outputting LIST, a new line is started.\n");
	printf("\n");
	printf("::sys <write LIST>\n");
	printf("::sys <w LIST>\n");
	printf("\n");
	printf("	Outputting LIST.\n");
	printf("\n");
	printf("::sys <wnl>\n");
	printf("\n");
	printf("	A new-line is outputted.\n");
	printf("\n");
	printf("::sys <wo NUMBER>\n");
	printf("\n");
	printf("	NUMBER is outputted by the octal number.\n");
	printf("\n");
	printf("::sys <wx NUMBER>\n");
	printf("\n");
	printf("	NUMBER is outputted by a hexadecimal number.\n");
	printf("\n");
	printf("::sys <wf NUMBER>\n");
	printf("\n");
	printf("	NUMBER is outputted as a floating point number.\n");
	printf("\n");
	printf("::sys <wg NUMBER>\n");
	printf("\n");
	printf("	NUMBER is outputted in a floating point number \n");
	printf("	and the optimal form.\n");
	printf("\n");
	printf("::sys <wtab>\n");
	printf("\n");
	printf("	A tab is outputted.\n");
	printf("\n");
	printf("::sys <fr VAR STRINGS WIDTH>\n");
	printf("\n");
	printf("	The result of having carried out flush right \n");
	printf("	of the STRINGS by width is set as VAR.\n");
	printf("\n");
	printf("::sys <fl VAR STRINGS WIDTH>\n");
	printf("\n");
	printf("	The result of having carried out flush left \n");
	printf("	of the STRINGS by width is set as VAR.\n");
	printf("\n");
	printf("::sys <isNil ARG>\n");
	printf("::sys <isAtom ARG>\n");
	printf("::sys <isList ARG>\n");
	printf("::sys <isPred ARG>\n");
	printf("::sys <isVar ARG>\n");
	printf("::sys <isUndefVar ARG>\n");
	printf("::sys <isFloat ARG>\n");
	printf("::sys <isInteger ARG>\n");
	printf("\n");
	printf("	true will be returned, if ARG is judged and it \n");
	printf("	corresponds. unknown is returned if it does not \n");
	printf("	correspond.\n");
	printf("\n");
	printf("::sys <isTrue PRED>\n");
	printf("::sys <isFalse PRED>\n");
	printf("::sys <isUnknown PRED>\n");
	printf("\n");
	printf("	The result of PRED of ARG is judged, and true will \n");
	printf("	be returned if it corresponds. unknown is returned \n");
	printf("	if it does not correspond.\n");
	printf("\n");
	printf("::sys <regex PATTERN STRINGS BEFORE-STRINGS MATCH-STRINGS AFTER-STRINGS>\n");
	printf("\n");
	printf("	The result of having applied the regular expression \n");
	printf("	pattern to STRINGS is set as Match STRINGS, and \n");
	printf("	STRINGS of order is set as front STRINGS and back \n");
	printf("	STRINGS. (It does not operate on Windows.)\n");
	printf("\n");
	printf("::sys <sub PATTERN STRINGS CORRESDED-STRINGS AFTER-STRINGS>\n");
	printf("\n");
	printf("	The result of having transposed the portion which \n");
	printf("	corresponded to STRINGS with the application of \n");
	printf("	the regular expression pattern to Substitution \n");
	printf("	STRINGS is set as Output STRINGS. Replacement \n");
	printf("	is performed only once. \n");
	printf("	(It does not operate on Windows.)\n");
	printf("\n");
	printf("::sys <gsub PATTERN STRINGS CORRESDED-STRINGS AFTER-STRINGS>\n");
	printf("\n");
	printf("	The result of having transposed the portion which \n");
	printf("	corresponded to STRINGS with the application of \n");
	printf("	the regular expression pattern to Substitution \n");
	printf("	STRINGS is set as Output STRINGS. Replacement is \n");
	printf("	performed into all the applicable portions of \n");
	printf("	STRINGS. (It does not operate on Windows.)\n");
	printf("\n");
	printf("::sys <split VAR STRINGS [DELIMITER]>\n");
	printf("\n");
	printf("	What divided STRINGS by the DELIMITER and was \n");
	printf("	set to LIST is set as VAR. When the delimiter \n");
	printf("	is not specified, it is divided with a blank \n");
	printf("	and a tab.\n");
	printf("\n");
	printf("::sys <length VAR LIST>\n");
	printf("\n");
	printf("	The length of LIST is set as VAR.\n");
	printf("\n");
	printf("::sys <setvar VAR VAL>\n");
	printf("\n");
	printf("	A value is assigned to global VAR. Global VAR \n");
	printf("	is registered in the form of the following as PRED.\n");
	printf("\n");
	printf("::sys <VAR VAL>;\n");
	printf("::sys <setarray VAR VAL INDEX>\n");
	printf("\n");
	printf("	A value is set as global VAR arrangement. \n");
	printf("	Global VAR is registered in the form of the \n");
	printf("	following as PRED.\n");
	printf("\n");
	printf("::sys <VAR VAL INDEX>;\n");
	printf("\n");
	printf("	When carrying out specification of the arrangement \n");
	printf("	of many dimensions, an index is specified as LIST.\n");
	printf("\n");
	printf("::sys <VAR VAL (INDEX1 INDEX2 ...)>\n");
	printf("\n");
	printf("	What kind of kind and form are sufficient as an \n");
	printf("	index besides a number.\n");
	printf("\n");
	printf("::sys <random VAR>\n");
	printf("\n");
	printf("	A random number is assigned to VAR.\n");
	printf("\n");
	printf("::sys <sin VAR RADIAN>\n");
	printf("::sys <cos VAR RADIAN>\n");
	printf("::sys <tan VAR RADIAN>\n");
	printf("\n");
	printf("	Trigonometric functions\n");
	printf("\n");
	printf("::sys <asin VAR VAL>\n");
	printf("::sys <acos VAR VAL>\n");
	printf("::sys <atan VAR VAL>\n");
	printf("\n");
	printf("	Inverse trigonometric function\n");
	printf("\n");
	printf("::sys <log VAR VAL>\n");
	printf("::sys <exp VAR VAL>\n");
	printf("\n");
	printf("	Logarithmic function\n");
	printf("\n");
	printf("::sys <sqrt VAR VAL>\n");
	printf("\n");
	printf("	Square root\n");
	printf("\n");
	printf("::sys <abs VAR VAL>\n");
	printf("\n");
	printf("	Absolute value\n");
	printf("\n");
	printf("::sys <int VAR VAL>\n");
	printf("\n");
	printf("	Integral value\n");
	printf("\n");
	printf("::sys <car VAR LIST>\n");
	printf("::sys <cdr VAR LIST>\n");
	printf("\n");
	printf("	car, cdr of LIST\n");
	printf("\n");
	printf("::sys <cons VAR LIST1 LIST2>\n");
	printf("\n");
	printf("	Connection of LIST\n");
	printf("\n");
	printf("::sys <code CODE-NAME>\n");
	printf("\n");
	printf("	A setup of a character code. \n");
	printf("	UTF8, EUCJP, and SJIS can be specified.\n");
	printf("\n");
	printf("::sys <char VAR STRINGS>\n");
	printf("\n");
	printf("	STRINGS is decomposed for every be character, and it \n");
	printf("	is made LIST, and is set as VAR. A multibyte character \n");
	printf("	like a Japanese character is also right, and it is every \n");
	printf("	character. \n");
	printf("\n");
	printf("::sys <byte VAR STRINGS>\n");
	printf("\n");
	printf("	STRINGS is decomposed for every character code, \n");
	printf("	and it is made LIST, and is set as VAR.\n");
	printf("\n");
	printf("::sys <asciichar VAR STRINGS>\n");
	printf("::sys <utf8char VAR STRINGS>\n");
	printf("::sys <eucchar VAR STRINGS>\n");
	printf("::sys <sjischar VAR STRINGS>\n");
	printf("\n");
	printf("	STRINGS is decomposed for every character code, \n");
	printf("	and it is made LIST, and is set as VAR.\n");
	printf("\n");
	printf("::sys <concat VAR LIST>\n");
	printf("\n");
	printf("	LIST is made to unite, STRINGS is compounded and \n");
	printf("	it is set as VAR.\n");
	printf("\n");
	printf("::sys <bitand VAR NUMBER1 NUMBER2>\n");
	printf("::sys <bitor VAR NUMBER1 NUMBER2>\n");
	printf("::sys <bitxor VAR NUMBER1 NUMBER2>\n");
	printf("::sys <bitnot VAR NUMBER1>\n");
	printf("\n");
	printf("	bit operation\n");
	printf("\n");
	printf("::sys <shiftl VAR NUMBER SHIFT>\n");
	printf("::sys <shiftr VAR NUMBER SHIFT>\n");
	printf("\n");
	printf("	The bit shift of an integral value. shiftl is shifted \n");
	printf("	to the left and shifutr is shifted to the right.\n");
	printf("\n");
	printf("::sys <eq ARG1 ARG2>\n");
	printf("::sys <noteq ARG1 ARG2>\n");
	printf("::sys <is ARG1 ARG2>\n");
	printf("\n");
	printf("	Comparison of ARG1 and ARG2\n");
	printf("\n");
	printf("::sys <getc VAR>\n");
	printf("\n");
	printf("	One character is inputted into VAR.\n");
	printf("\n");
	printf("::sys <putc CHAR>\n");
	printf("\n");
	printf("	One character is outputted.\n");
	printf("\n");
	printf("::sys <getline VAR [PRED...]>\n");
	printf("\n");
	printf("	One line is inputted and it is set as VAR. When \n");
	printf("	PRED is set up, PRED is performed by considering \n");
	printf("	a tmp file as an input.\n");
	printf("\n");
	printf("::sys <syntax STRINGS PRED...>\n");
	printf("\n");
	printf("	A predicate is performed by making a character string \n");
	printf("	into an input file.\n");
	printf("\n");
	printf("::sys <tmpfile VAR>\n");
	printf("\n");
	printf("	Temporary FILE NAME is set as VAR\n");
	printf("\n");
	printf("\n");
	printf("::sys <openr FILE-NAME PRED...>\n");
	printf("\n");
	printf("	The file of FILE-NAME is opened in postscript \n");
	printf("	reading, and PRED is performed.\n");
	printf("\n");
	printf("::sys <openw FILE-NAME PRED...>\n");
	printf("\n");
	printf("	The file of FILE-NAME is opened in postscript \n");
	printf("	writing, and PRED is performed.\n");
	printf("\n");
	printf("::sys <openwp FILE-NAME PRED...>\n");
	printf("\n");
	printf("	The file of FILE-NAME is opened in postscript \n");
	printf("	writing, and PRED is performed.\n");
	printf("\n");
	printf("::sys <gettime VAR>\n");
	printf("\n");
	printf("	The present time is set as a variable by a micro second bit.\n");
	printf("\n");
	printf("::sys <date>\n");
	printf("\n");
	printf("	Time is set as a variable.\n");
	printf("\n");
	printf("\n");
	printf("\n");
	printf("::sys <countnode VAR>\n");
	printf("\n");
	printf("	The number of nodes currently used is set as VAR.\n");
	printf("\n");
	printf("::sys <gc>\n");
	printf("\n");
	printf("	A garbage collector is started.\n");
	printf("\n");
	printf("\n");

}



