/*
 *  htttp client program copyright (C) 2011 - 2012 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef __HTTPCLIENT_H
#define __HTTPCLIENT_H

extern int HttpGet(Context* cx, Node* goalscar, List* module);
extern int HttpHead(Context* cx, Node* goalscar, List* module);
extern int HttpPost(Context* cx, Node* goalscar, List* module);
extern int HtmlTags(Context* cx, Node* goalscar, List* module);
extern int HtmlSection(Context* cx, Node* goalscar, List* module);
extern int HtmlSplit(Context* cx, Node* goalscar, List* module);
extern int HtmlLeft(Context* cx, Node* goalscar, List* module);
extern int HtmlRight(Context* cx, Node* goalscar, List* module);
extern int EraseAllTags(Context* cx, Node* goalscar, List* module);
extern int EraseTags(Context* cx, Node* goalscar, List* module);
extern int EraseCommentTags(Context* cx, Node* goalscar, List* module);
extern int SplitTags(Context* cx, Node* goalscar, List* module);
extern int CRLF2LF(Context* cx, Node* goalscar, List* module);
extern int LF2CRLF(Context* cx, Node* goalscar, List* module);
extern int UrlEncode(Context* cx, Node* goalscar, List* module);
extern int UrlDecode(Context* cx, Node* goalscar, List* module);
extern int HtmlEncode(Context* cx, Node* goalscar, List* module);
extern int HtmlDecode(Context* cx, Node* goalscar, List* module);

#endif /* __HTTPCLIENT_H */
