/*
 *  error operation copyright (C) 2009 - 2011 H.Niwa 
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <stdarg.h>
#include <setjmp.h>

#if HAVE_LIBNCURSES && !defined(__MINGW32__)
#ifdef __CYGWIN__
#include <ncurses/ncurses.h>
#else
#include <ncurses.h>
#endif
#endif

#include <string>
#include <complex>

#include "syserr.h"
#include "bin_node.h"
#include "context.h"
#include "ncurlib.h"

extern jmp_buf program_jb;

Node* ErrGoal = Nil;

void syslist(Node* n)
{
	fprintf(stderr, "error: ");
	n->print(stderr);
	fprintf(stderr, "\n");
}


void syserr(const char* fmt, ...)
{
	extern int LineNumber();

#if HAVE_LIBNCURSES && !defined(__MINGW32__)
	if (ncurlibflag) {
		ncurlibflag = 0;
		endwin();
	}
#endif

	fprintf(stderr, "\n");
	if (ErrGoal != Nil) {
		fprintf(stderr, "==> ");
		ErrGoal->print(stderr);
		fprintf(stderr, "\n");
	}

	va_list	argp;

	va_start(argp, fmt);

	fprintf(stderr, "# %d : error... ", LineNumber());	
	vfprintf(stderr, fmt, argp );
	fprintf(stderr, "\n");
	fflush(stdout);
	fflush(stderr);

	longjmp(program_jb, -1);
}

void sysexit(int r)
{
	longjmp(program_jb, r+2);
}


