/*
 * built-in program copyright (C) 2009 H.Niwa
 */


/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include <string>

#include "syserr.h"

#include "bin_node.h"
#include "gc.h"
#include "var.h"
#include "pred.h"
#include "context.h"
#include "unify.h"
#include "builtin.h"

int HelpPrint(char* mod, char* name);
int HelpBuiltin(char* name);
int HelpSys(char* name);

int Help(Context* cx, Node* goalscar)
{
	HelpBuiltin("");
	HelpSys("");
	return 1;
}


int HelpPrint(char* mod, char* name)
{
	std::string smodule = (const char*)mod;
	std::string sname = (const char*)name;

	if ((smodule == "") || (smodule == "builtin")) {
		return HelpBuiltin(name);
	} else if (smodule == "sys") {
		return HelpSys(name);
	}
}

int HelpBuiltin(char* name)
{
	std::string sname = (const char*)name;
#if 0
	printf("<alt PRED...>\n");
	printf("<assert CLAUSE>\n");
	printf("<asserta CLAUSE>\n");
	printf("<assertz CLAUSE>\n");
	printf("<cd PATH>\n");
	printf("<dir>\n");
	printf("<ls>\n");
	printf("<compare EXPRESSION>\n");
	printf("<comparef EXPRESSION>\n");
	printf("<erase CLAUSE-NAME>\n");
	printf("<retract CLAUSE-NAME>\n");
	printf("<retractpred HEAD-NAME>\n");
	printf("<f VAR PRED...>\n");
	printf("<func VAR PRED...>\n");
	printf("<findall PRED...>\n");
	printf("<for (VAR lastvalue) PRED...>\n");
	printf("<for (VAR initialvalue lastvalue) PRED...>\n");
	printf("<foreach (VAR LIST) PRED...>\n");
	printf("<map  (VAR LIST) PRED...>\n");
	printf("<include FILENAME>\n");
	printf("<let EXPRESSION>\n");
	printf("<letf EXPRESSION>\n");
	printf("<list>\n");
	printf("<load FILENAME>\n");
	printf("<loop PRED...>\n");
	printf("<module VAR>\n");
	printf("<new>\n");
	printf("<not PRED...>\n");
	printf("<obj OBJECTNAME PRED...>\n");
	printf("<unify MODULENAME PRED...>\n");
	printf("<or PRED PRED PRED ...>\n");
	printf("<print LIST>\n");
	printf("<pwd>\n");
	printf("<quit>\n");
	printf("<quote PRED>\n");
	printf("<rpn VAR RPNEXPRESSION>\n");
	printf("<rpnf VAR RPN-EXPRESSION>\n");
	printf("<timeout limittime PRED>\n");
	printf("<troff>\n");
	printf("<tron>\n");
	printf("<true>\n");
	printf("<false>\n");
	printf("<unknown>\n");
	printf("<!>\n");
	printf("\n");
#endif

printf("<alt PRED...>\n");
printf("\n");
printf("	Alternative predicate execution is shown.\n");
printf("	Even if the results of Argument PRED are true, false,\n");
printf("	and unknown, it is certainly set to true.\n");
printf("	It expresses [PRED...] as substitution.It uses by syntax\n");
printf("	analysis as [] of the method of EBNF.\n");
printf("\n");
printf("<assert CLAUSE>\n");
printf("<asserta CLAUSE>\n");
printf("<assertz CLAUSE>\n");
printf("\n");
printf("	CLAUSE is added.\n");
printf("	asserta is added to a head and assertz is added at\n");
printf("	the end.\n");
printf("	assert is the same as asserta and is added to a head.\n");
printf("\n");
printf("<cd PATH>\n");
printf("\n");
printf("	A current directory is moved to the PATH specified\n");
printf("	by the argument.\n");
printf("\n");
printf("<dir>\n");
printf("<ls>\n");
printf("\n");
printf("	A current directory is displayed.\n");
printf("\n");
printf("<compare EXPRESSION>\n");
printf("<comparef EXPRESSION>\n");
printf("\n");
printf("	EXPRESSION is evaluated.\n");
printf("	compare is an integer and comparef is comparison of\n");
printf("	a float number.\n");
printf("\n");
printf("<erase CLAUSE-NAME>\n");
printf("<retract CLAUSE-NAME>\n");
printf("\n");
printf("	All the programs corresponding to CLAUSE-NAME are\n");
printf("	deleted.\n");
printf("\n");
printf("<retractpred HEAD-NAME>\n");
printf("\n");
printf("	All the programs corresponding to HEAD-NAME are\n");
printf("	deleted.\n");
printf("\n");
printf("<f VAR PRED...>\n");
printf("<func VAR PRED...>\n");
printf("\n");
printf("	Execution evaluation of the function predicate contained\n");
printf("	in PRED-LIST is carried out. A value is replaced.\n");
printf("	After performing all, a result is set to a variable.\n");
printf("\n");
printf("<findall PRED...>\n");
printf("\n");
printf("	PRED is performed and all the solutions are calculated.\n");
printf("\n");
printf("<for (VAR lastvalue) PRED...>\n");
printf("<for (VAR initialvalue lastvalue) PRED...>\n");
printf("\n");
printf("	The predicate of the specified number of times and an\n");
printf("	argument is performed.\n");
printf("	When the initial value is not specified, the value\n");
printf("	from 0 is set to a VAR.\n");
printf("\n");
printf("<foreach (VAR LIST) PRED...>\n");
printf("<map (VAR LIST) PRED...>\n");
printf("\n");
printf("	PRED of arguments are performed for every element\n");
printf("	of LIST.\n");
printf("	The value of a list is set to a variable in order.\n");
printf("	<include FILENAME>\n");
printf("	The library of a FILE-NAME is read.\n");
printf("\n");
printf("<let EXPRESSION>\n");
printf("<letf EXPRESSION>\n");
printf("\n");
printf("	Expression is calculated.\n");
printf("	A calculation result is substituted when the left\n");
printf("	side is a variable.\n");
printf("	When the left side is a numerical value, it is\n");
printf("	judged whether it is equal to a calculation result.\n");
printf("	let calculates an integer and letf is calculation\n");
printf("	of floating number.\n");
printf("\n");
printf("<list>\n");
printf("\n");
printf("	A program list is displayed.\n");
printf("\n");
printf("<load FILE-NAME>\n");
printf("\n");
printf("	The program of a FILE-NAME is read.\n");
printf("\n");
printf("<loop PRED...>\n");
printf("\n");
printf("	A repetition of predicate execution is shown.\n");
printf("	It was called inside. Failure of a predicate\n");
printf("	will escape from a loop.\n");
printf("	It is the predicate which is surely successful\n");
printf("	by true,\n");
printf("	It expresses {PRED...} as substitution.\n");
printf("	It uses by syntax analysis as {} of the method\n");
printf("	of EBNF.\n");
printf("\n");
printf("<module VAR>\n");
printf("\n");
printf("	The library module used now is set to a variable.\n");
printf("\n");
printf("<new>\n");
printf("\n");
printf("	All log rum is cleared.\n");
printf("	<not PRED...>\n");
printf("	false is returned when predicate execution is true.\n");
printf("	In false, true is returned.\n");
printf("	In unknown, unknown is returned.\n");
printf("\n");
printf("<obj OBJECTNAME PRED...>\n");
printf("<unify MODULENAME PRED...>\n");
printf("\n");
printf("	A predicate is performed using the specified object\n");
printf("	or module.\n");
printf("	A module is the same as an object.\n");
printf("	It can be described as ::object <PRED...> as an\n");
printf("	omitted type.\n");
printf("\n");
printf("<or PRED PRED PRED ...>\n");
printf("\n");
printf("	In the place which performed the predicate of the\n");
printf("	argument from the head and was set to true Processing\n");
printf("	is closed and true is returned.\n");
printf("	In the place which performed the predicate of the argument\n");
printf("	from the head and was set to false Processing is closed\n");
printf("	and false is returned.\n");
printf("	unknown is returned when all the predicates are unknown.\n");
printf("	It uses by syntax analysis as | of the method\n");
printf("	of EBNF.\n");
printf("\n");
printf("<print LIST>\n");
printf("\n");
printf("	fter outputting a list, a new line is started.\n");
printf("	::sys <writenl LIST> is the same as <print LIST>.\n");
printf("\n");
printf("<pwd VAR>\n");
printf("\n");
printf("	The current directory is set to VAR.\n");
printf("\n");
printf("<quit>\n");
printf("\n");
printf("	Execution of a program is stopped and it ends.\n");
printf("\n");
printf("<quote PRED>\n");
printf("\n");
printf("	Evaluation of the function predicate of an argument\n");
printf("	is deterred.\n");
printf("\n");
printf("<rpn VAR RPNEXPRESSION>\n");
printf("<rpnf VAR RPNEXPRESSION>\n");
printf("\n");
printf("	A reverse Poland style is calculated and a result\n");
printf("	is set to a variable.\n");
printf("	rpn calculates an integer and rpnf calculates floating\n");
printf("	number.\n");
printf("\n");
printf("<timeout limittime PRED>\n");
printf("\n");
printf("	Within the set-up time, when execution of a predicate\n");
printf("	is not completed, processing is closed, and unknown is\n");
printf("	returned. A set period is a micro second bit.\n");
printf("\n");
printf("<troff>\n");
printf("\n");
printf("	Debugging trace is turned OFF.\n");
printf("\n");
printf("<tron>\n");
printf("\n");
printf("	Debugging trace is turned ON.\n");
printf("\n");
printf("<true>\n");
printf("<false>\n");
printf("<unknown>\n");
printf("\n");
printf("	return true, false, unknown\n");
printf("\n");
printf("<!>\n");
printf("	cut operator\n");
printf("\n");
	
}

int HelpSys(char* name)
{
	std::string sname = (const char*)name;
	printf("::sys <args VAR>\n");
	printf("::sys <DLIBPATH VAR>\n");
//	printf("::sys <cutall>\n");
	printf("::sys <mkpred LIST>\n");
	printf("::sys <writenl LIST>\n");
	printf("::sys <write LIST>\n");
	printf("::sys <w LIST>\n");
	printf("::sys <wnl>\n");
	printf("::sys <wo NUMBER>\n");
	printf("::sys <wx NUMBER>\n");
	printf("::sys <wf NUMBER>\n");
	printf("::sys <wg NUMBER>\n");
	printf("::sys <wtab>\n");
	printf("::sys <fr VAR STRINGS WIDTH>\n");
	printf("::sys <fl VAR STRINGS WIDTH>\n");
	printf("::sys <isNil ARG>\n");
	printf("::sys <isAtom ARG>\n");
	printf("::sys <isList ARG>\n");
	printf("::sys <isPred ARG>\n");
	printf("::sys <isVar ARG>\n");
	printf("::sys <isUndefVar ARG>\n");
	printf("::sys <isFloat ARG>\n");
	printf("::sys <isInteger ARG>\n");
	printf("::sys <isTrue PRED>\n");
	printf("::sys <isFalse PRED>\n");
	printf("::sys <isUnknown PRED>\n");
	printf("::sys <regex PATTERN STRINGS PRE-STRINGS MATCH-STRINGS AFTER-STRINGS>\n");
	printf("::sys <sub PATTERN STRINGS PATTERN OUTPUT-STRINGS>\n");
	printf("::sys <gsub PATTERN STRINGS PATTERN OUTPUT-STRINGS>\n");
	printf("::sys <split VAR STRINGS [TERMINATER]>\n");
	printf("::sys <length VAR LIST>\n");
	printf("::sys <setvar VAR VALUE>\n");
	printf("::sys <setarray VAR VALUE INDEX>\n");
	printf("::sys <random VAR>\n");
	printf("::sys <sin VAR RADIAN>\n");
	printf("::sys <cos VAR RADIAN>\n");
	printf("::sys <tan VAR RADIAN>\n");
	printf("::sys <asin VAR VALUE>\n");
	printf("::sys <acos VAR VALUE>\n");
	printf("::sys <atan VAR VALUE>\n");
	printf("::sys <log VAR VALUE>\n");
	printf("::sys <exp VAR VALUE>\n");
	printf("::sys <sqrt VAR VALUE>\n");
	printf("::sys <abs VAR VALUE>\n");
	printf("::sys <int VAR VALUE>\n");
	printf("::sys <car VAR VALUE>\n");
	printf("::sys <cdr VAR VALUE>\n");
	printf("::sys <cons VAR LIST1 LIST2>\n");
	printf("::sys <code CODE>\n");
	printf("::sys <char VAR STRINGS>\n");
	printf("::sys <byte VAR STRINGS>\n");
	printf("::sys <asciichar VAR STRINGS>\n");
	printf("::sys <utf8char VAR STRINGS>\n");
	printf("::sys <eucchar VAR STRINGS>\n");
	printf("::sys <sjischar VAR STRINGS>\n");
	printf("::sys <concat VAR LIST>\n");
	printf("::sys <bitand VAR NUMBER1 NUMBER2> \n");
	printf("::sys <bitor VAR NUMBER1 NUMBER2>\n");
	printf("::sys <bitxor VAR NUMBER1 NUMBER2>\n");
	printf("::sys <bitnot VAR NUMBER1>\n");
	printf("::sys <shiftl VAR NUMBER SHIFT>\n");
	printf("::sys <shiftr VAR NUMBER SHIFT>\n");
	printf("::sys <eq ARG1 ARG2>\n");
	printf("::sys <noteq ARG1 ARG2>\n");
	printf("::sys <is ARG1 ARG2>\n");
	printf("::sys <getc VAR>\n");
	printf("::sys <putc CHAR>\n");
	printf("::sys <getline VAR [PRED...]>\n");
	printf("::sys <tmpfile VAR>\n");
	printf("::sys <TOKEN VAR PRED...>\n");
	printf("::sys <SKIPSPACE>\n");
	printf("::sys <C [VAR]>\n");
	printf("::sys <N [VAR]>\n");
	printf("::sys <A [VAR]>\n");
	printf("::sys <AN [VAR]>\n");
	printf("::sys <CR [VAR]>\n");
	printf("::sys <CNTL [VAR]>\n");
	printf("::sys <EOF [VAR]>\n");
	printf("::sys <SPACE>\n");
	printf("::sys <PUNCT>\n");
	printf("::sys <STRINGS VAR>\n");
	printf("::sys <WORD VAR>\n");
	printf("::sys <NUM VAR>\n");
	printf("::sys <FNUM VAR>\n");
	printf("::sys <ID VAR>\n");
	printf("::sys <RANGE VAR CHAR1 CHAR2>\n");
	printf("::sys <NONRANGE VAR CHAR1 CHAR2>\n");
	printf("::sys <GETTOKEN VAR>\n");
	printf("::sys <openr FILENAME PRED...>\n");
	printf("::sys <openw FILENAME PRED...>\n");
	printf("::sys <openwp FILENAME PRED...>\n");
	printf("::sys <countnode VAR>\n");
	printf("::sys <gc>\n");

}



