</

// lexical analyzer		(C) H.Niwa 1993-2010

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */


#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdarg.h>
#include <sys/time.h>
#include <libgen.h>
#include <setjmp.h>
#include <getopt.h>
#include <signal.h>

#include <complex>

#include "syserr.h"

#include "bin_node.h"
#include "gc.h"
#include "var.h"
#include "pred.h"
#include "module.h"
#include "context.h"
#include "unify.h"
#include "builtin.h"
#include "sysmodule.h"

const char* VERSION = "0.17.0";
void optver()
{
	extern std::string code;
	printf("Descartes %s\t(code:%s) \n", VERSION, code.c_str());
	printf("Copyright (C) 2009 - 2010 Hideyuki Niwa\n\n");
}


extern int pllexSpace(int c);
extern int pllexCkSpace(int c);

char	TOKEN[TOKEN_LEN];
int	tokenPt = 0;
int	Char;

int	ErrorFlg = 0;
FILE	*RdFp,*pr;
const	char	*MESG = NULL;

int	EndFlg = 0;

int	resultflg = 1;

void opthelp()
{
	printf("usage: descartes [OPTION...] [FILE]\n");
	printf("\n");
	printf(" -?, --help\tShow this help message\n");
	printf(" -v, --version\tprint the version of descartes being used\n");
	printf("\n");
	printf(" -u, --utf8\tUTF8 code is used\n");
	printf(" -e, --euc\tEUC code is used\n");
	printf(" -s, --sjis\tSJIS code is used\n");
	printf("\n");
	printf(" -t, --trace\ttrace becomes effective\n");
	printf(" -r, --result\tresult is not displayed\n");
	printf("\n");
}

void sigint_handler_cmdline(int signum)
{
	int i;
	char buf[80];
	int c;

	printf("\nquit ? [y or n] ");
	if (fgets(buf, 80-1, stdin) == NULL) {
		return;
	}

	for (i = 0; i < 80; i++) {
		c = buf[i];
		if (c == ' ') {
			continue;
		} else if ((c == 'y') || (c == 'Y')) {
			exit(0);
		} else {
			break;
		}
	}
}

#ifdef __MINGW32__
void set_sigint_handler_cmdline()
{
	signal(SIGINT, sigint_handler_cmdline);
}

#else
struct sigaction sigint_action;

void set_sigint_handler_cmdline()
{
	sigint_action.sa_handler = sigint_handler_cmdline;
	sigemptyset(&(sigint_action.sa_mask));
	sigint_action.sa_flags = 0;
	sigaction(SIGINT, &sigint_action, NULL);
}

#endif

int 	pargc;
char**	pargv;

int main(int argc, char** argv)
{
	int	c, i;

	extern std::string code;

	extern char *optarg;
	extern int optind, opterr, optopt;

	int optc;
	int digit_optind = 0;

	static struct option long_options[] = {
		{"help", 0, 0, 'h'},
		{"?", 0, 0, 'h'},
		{"version", 0, 0, 'v'},
		{"utf8", 0, 0, 'u'},
		{"euc", 0, 0, 'e'},
		{"sjis", 0, 0, 's'},
		{"trace", 0, 0, 't'},
		{"result", 0, 0, 'r'},
		{0, 0, 0, 0}
	};

#ifdef __CYGWIN__
	code = "SJIS";
#endif

	while (1) {
		int this_option_optind = optind ? optind : 1;
		int option_index = 0;

		optc = getopt_long (argc, argv, "h?vuestr",
                        long_options, &option_index);
		if (optc == -1) {
			break;
		}

		switch (optc) {
		case 'h':
			opthelp();
			exit(0);
			break;
		case 'v':
			optver();
			exit(0);
			break;
		case 'u':
			code = "UTF8";
			break;
		case 'e':
			code = "EUC";
			break;
		case 's':
			code = "SJIS";
			break;
		case 't':
			Tron();
			break;
		case 'r':
			resultflg = 0;
			break;
		default :
			opthelp();
			exit(0);
			break;
		}
	}

#ifdef __CYGWIN__
	char	inputrcpath[MAXPATHLEN+10];

	// set INPUTRC path for readline
	char* homepath = getenv("HOME");
	strncpy(inputrcpath, homepath, MAXPATHLEN);
	strcat(inputrcpath, "/inputrc");
	setenv("INPUTRC", inputrcpath, 0);
//printf("inputrcpath %s \n", inputrcpath);
#endif /* __CYGWIN__ */

#ifdef __MINGW32__
	extern std::string code;

#ifdef MINGW_UTF8
	code = "UTF8";
#else 
	code = "SJIS";
#endif

	struct timeval tv;
	gettimeofday(&tv, NULL);
	srand(tv.tv_usec);
#else
	struct timeval tv;
	gettimeofday(&tv, NULL);
	srandom(tv.tv_usec);
#endif /* __MINGW32__ */

	extern void StackBase();
	StackBase();

	GetLibPath();
	GetTmpPath();
	GetEditorPath();

#if 0
	Context* cx = new Context(Module);
	IncludeSub(cx, Nil, Module, "sys");
	delete cx;
#endif

	if (argc <= optind) {
		DResultFlag = 1;

		optver();

		set_sigint_handler_cmdline();

		GetlineEval();

		exit(0);

	} else {

		char* dargv1 = strdup(argv[optind]);
		char* bargv1 = strdup(argv[optind]);
		char* dname = dirname(dargv1);
		char* bname = basename(bargv1);
		free(dargv1);
		free(bargv1);

//printf("fopen 0 argv[optind] %s dname %s bname %s \n", argv[optind], dname, bname);
		if ((dname[0] == '.') && (dname[1] == 0) 
				&& ((argv[optind])[1] != '/')) {
			Node* nd;
			RdFp = NULL;

//PrintNode("dlibpathnode ", dlibpathnode);
			if (dlibpathnode == Nil) {
//printf("fopen 1 argv[optind] %s \n", argv[optind]);
				RdFp = fopen(argv[optind], "rb");
			} else {			
				for (nd = dlibpathnode; nd != Nil; nd=nd->Cdr()) {
					std::string s = "";

					if (nd->Car()->kind() != ATOM) {
						continue;
					}

					((Atom*)(nd->Car()))->toString(s);
					s = s + "/" + argv[optind];

					RdFp = fopen(s.c_str(), "rb");
					if (RdFp != NULL) {
						break;
					}
				}
			}
		} else {
//printf("fopen 2 argv[optind] %s \n", argv[optind]);
			RdFp = fopen(argv[optind], "rb");
		}

		if (RdFp == NULL) {
			fprintf(stderr,"can not open File : %s \n",argv[optind]);
			return 0;
		}

		pargc = argc-optind+1;
		pargv = &argv[optind-1];

		NwccMain();

		if (RdFp == NULL) {
			fclose(RdFp);
			RdFp = NULL;
		}

//		fflush(stdout); PPmodule();

		exit(0);
	}
}



long FilePointSave()
{
	return ftell(RdFp);
}

void FilePointResume(long tellpt)
{
	fseek(RdFp, tellpt, 0);
}

void SkipComment(int &Char)
{
	int	c;

	if (Char == EOF) {
		return;
	}

	for (;;) {
		if (Char == EOF) {
			break;
		}
		// #! comment
		if (Char == '#') {
			c = fgetc(RdFp);
			if (c == EOF) {
				break;
			}
			if (c == '!') {
				for (;;) {
					c = fgetc(RdFp);
					if (c == EOF) {
						break;
					}
					if (c == '\n') {
						break;
					}
				}
				Char = fgetc(RdFp);
			} else {
				ungetc(c, RdFp);
				return;
			}
		// '//' and '/* */' comment
		} else if (Char == '/') {
			c = fgetc(RdFp);
			if (c == EOF) {
				break;
			}
			if (c == '/') {		// comment
				for (;;) {
					c = fgetc(RdFp);
					if (c == EOF) {
						break;
					}
					if (c == '\n') {
						break;
					}
				}
				Char = fgetc(RdFp);
			} else if (c == '*') {	/* comment */
				for (;;) {
					c = fgetc(RdFp);
					if (c == EOF) {
						break;
					}
					if (c == '*') { /* close comment */
						c = fgetc(RdFp);
						if (c == EOF) {
							break;
						}
						if (c == '/') {
							break;
						} else {
							ungetc(c, RdFp);
						}
					} else if (c == '/') {
						if ((c = fgetc(RdFp)) == '*') {
							ungetc('*', RdFp);
							Char = '/';
							SkipComment(Char);
						}
						if (c == EOF) {
							break;
						}
					}
				}
				Char = fgetc(RdFp);
			} else {
				ungetc(c, RdFp);
				break;
			}
		} else {
			return;
		}
	}
}

int GetChar()
{
	Char = fgetc(RdFp);

	SkipComment(Char);

	return Char;
}

void UnGetChar(int c)
{
	ungetc(c, RdFp);
}

void PutChar(int Char)
{
	if(fputc(Char,pr) == EOF){
		ErrorStop("can't write file ");
	}
}


void SkipSpace()
{
	int c;

	do{
		c = GetChar();
	}while(pllexSpace(c));
	UnGetChar(c);

}

int CHECK(const char* Pt)
{
	long	TelSav;
	int	r;

	TelSav = FilePointSave();
	r = COMP(Pt);
	FilePointResume(TelSav);
	return r;	
}


int NotSkipSpCOMP(const char* Pt)
{
	long	TelSav;
	int	c;

	TelSav = FilePointSave();

	c = GetChar();
	if((char)c != *Pt){
		FilePointResume(TelSav);
		return -1;
	}
	Pt++;
	while(*Pt){
		c = GetChar();
		if((char)Char != *Pt){
			FilePointResume(TelSav);
			return -1;
		}
		Pt++;
	}
	return 0;
}

int COMP(const char* Pt)
{
	long	TelSav;
	int	r, c;

	TelSav = FilePointSave();

	SkipSpace();

	r = NotSkipSpCOMP(Pt);

	if (r != 0) {
		FilePointResume(TelSav);
		return r;
	} else {
		fseek(RdFp, ftell(RdFp)-1, 0); 
		if (!isalpha(GetChar())) {
			return 0;
		}
			
		c = GetChar();
		UnGetChar(c);

		if (isalpha(c) || (c == '_') ) {
			FilePointResume(TelSav);
			return -1;
		}

		return 0;
	}
}

int 	LineNumber()
{
	int	LineNo = 1;
	long	TelSav;
	int	c;

	TelSav = FilePointSave();
	rewind(RdFp);
	while(TelSav != FilePointSave()){
		c = fgetc(RdFp);
		if(c == '\n') {
			LineNo++;
		}
		if (c == EOF) break;
	}
	FilePointResume(TelSav);
	return LineNo;
}

static char errorbuf[1024];
int	ErrorStopFlag = 0;

void ErrorStop(const char* fmt, ...)
{
	va_list	argptr;
	int	LineNo = 1;
	long	TelSav;

	if (ErrorStopFlag) {
		return;
	}

	LineNo = LineNumber();

	errorbuf[0] = '\0';

	va_start(argptr, fmt);
	vsprintf(errorbuf, fmt, argptr);
	va_end(argptr);

	if (strlen(errorbuf) == 0) {
		strncpy(errorbuf, "Syntax Error ", 1023);
	}

	fprintf(stderr, "# %d : error... %s\n",LineNo, errorbuf);

//	fclose(pr);
	ErrorFlg = -1;
	ErrorStopFlag = 1;

	extern jmp_buf program_jb;

	longjmp(program_jb, -1);

	exit(-1);
}

void	UNTIL(const char* s)
{
	const	char	*Pt;
	int	c;
	int	matchFlg = 0;
	long	tellsave;

	while(matchFlg == 0){
		Pt = s;
		while((char)(c = GetChar()) != *Pt) {
			PutChar(c);
		}

		matchFlg = 1;
		Pt++;

		tellsave = FilePointSave() - 1;
		while(*Pt) {
			c = GetChar();
			if((char)c != *Pt) {
				FilePointResume(tellsave);
				c = GetChar();
				PutChar(c);
				matchFlg = 0;
				break;
			}
			Pt++;
		}
	}
}

void	SKIP(const char* s)
{
	const	char	*Pt;
	int	c;
	int	matchFlg = 0;
	
	while(matchFlg == 0){
		Pt = s;
		while((char)(c = GetChar()) != *Pt)
			;

		matchFlg = 1;
		Pt++;
		while(*Pt){
			c = GetChar();
			if((char)c != *Pt){
				matchFlg = 0;
				break;
			}
			Pt++;
		}
	}
}


int	NotSkipSpNOT(const char* s)
{
	long	TelSav;
	int	rc;

	TelSav = FilePointSave();
	rc = !NotSkipSpCOMP(s);
	FilePointResume(TelSav);
	return rc;
}

int	NOT(const char* s)
{
	long	TelSav;
	int	rc;

	TelSav = FilePointSave();
	rc = !COMP(s);
	FilePointResume(TelSav);
	return rc;
}

int C()
{
	Char = GetChar();

	return 0;
}


int	Eof()
{
	int c;

	do{
		c = fgetc(RdFp);
		if (c == EOF) {
			return 0;
		}
	}while(pllexSpace(c));
	ungetc(c, RdFp);

	return -1;
}

int	NotEof()
{
	int c;

	do{
		c = fgetc(RdFp);
		if (c == EOF) {
			return -1;
		}
	}while(pllexSpace(c));
	ungetc(c, RdFp);

	return 0;
}


int N()
{
	C();

	if (!isdigit(Char)) {
		UnGetChar(Char);
		return -1;
	}

	return 0;
}

int A()
{
	C();

	if (!isalpha(Char) && (Char != '_') ) {
		UnGetChar(Char);
		return -1;
	}

	return 0;
}

int AN()
{
	C();

	switch (Char) {
	case '_' :
		return -1;
	}

	if (!isalnum(Char)) {
		return 0;
	}

	UnGetChar(Char);
	return -1;
}

int SPACE()
{
	C();

	if (!pllexSpace(Char)) {
		UnGetChar(Char);
		return -1;
	}

	return 0;
}

void SetToken(int c)
{
	if (tokenPt >= TOKEN_LEN-3) {
		ErrorStop("Too long token ");
	}

	if (c & 0xff00) {
		TOKEN[tokenPt] = (c >> 8);
		tokenPt++;
		TOKEN[tokenPt] = (c & 0xff);
		tokenPt++;
	} else {
		TOKEN[tokenPt] = c;
		tokenPt++;
	}
}




int FNUM()
{
	int	dot = 0;

	SkipSpace();

	tokenPt = 0;

	C();
	if ((!isdigit(Char)) && (Char != '.')) {
		UnGetChar(Char);
		return -1;
	}
	if (Char == '.') {
		dot++;
	}
	SetToken(Char);

	for (;;) {
		C(); 
		if (Char == '.') {
			if (dot) {
				UnGetChar(Char);
				return -1;
			}
			dot++;
			SetToken(Char);
		} else if ((Char == 'e') || (Char == 'E')) {
			SetToken(Char);
			C();
			if ((Char == '+') || (Char == '-')) {
				SetToken(Char);
				for(;;) {
					C();
					if (!isdigit(Char)) {
						UnGetChar(Char);
						SetToken('\0');
						return 0;
					}
					SetToken(Char);
				}
			} else {
				UnGetChar(Char);
				return -1;
			}
		} else if (!isdigit(Char)) {
			UnGetChar(Char);
			SetToken('\0');
			return 0;
		} else {
			SetToken(Char);
		}
	}	

	return 0;
}

int STRINGS()
{
	char	qt;

	SkipSpace();

	tokenPt = 0;

	C();
	if ((Char != '\"') && (Char != '\'')) {
		UnGetChar(Char);
		return -1;
	}
	qt = Char;
//	SetToken(Char);

	for (;;) {
		C(); 
		if (Char == qt) {
//			SetToken(Char);
			SetToken(0);
			return 0;
		} else {
			SetToken(Char);
		}
	}
	
	SetToken(0);
	return -1;
}



/>

// --------------------------------------------------------------


ANY 	= { AN }
	;

WRD =				</ {
				     long tellsave;
				     tokenPt = 0;
				     tellsave=FilePointSave();
				     SkipSpace();
				/>
	AN 			</!  FilePointResume(tellsave); />
				</   SetToken(Char); />
	   { 
		AN 		</   SetToken(Char); />
	   }
				</
				     SetToken('\0');
				   }
				/>
	;

NUM 	= 			</ { />
				</   long tellsave;   />
				</   tokenPt = 0; /> 
				</   tellsave=FilePointSave();  />
				</   SkipSpace();     />
	   N			</!  FilePointResume(tellsave); />
		  		</   SetToken(Char); />
	   { 
		N  		</   SetToken(Char); />
	   }
				</   SetToken('\0');   />
				</ 
				   }
				/>
	;


 
ID 	= 			</ { />
				</   long tellsave;   />
				</   tokenPt = 0; /> 
				</   tellsave=FilePointSave();  />
				</   SkipSpace();     />
	   A			</!  FilePointResume(tellsave); />
	   			</   SetToken(Char); />
	   { 
		AN  		</   SetToken(Char); />
	   }
				</   SetToken('\0');   />
				</ 
				   }
				/>
	;


