</
/*
 * parse program copyright (C) 2009 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "config.h"

#include <sys/time.h>

#ifndef __MINGW32__
#include <sys/times.h>
#endif

#include <setjmp.h>

#include <complex>

#include "syserr.h"
#include "pllex.h"

#include "bin_node.h"
#include "gc.h"
#include "var.h"
#include "pred.h"
#include "module.h"
#include "context.h"
#include "unify.h"
#include "func.h"
#include "sysmodule.h"
#include "builtin.h"

jmp_buf	program_jb;

Node*	r_head= Nil;
Node*	r_literal= Nil;
Node*	r_body= Nil;
Node*	r_clause= Nil;
Node*	r_defobj= Nil;
Node*	r_inherit= Nil;
Node*	r_pred= Nil;
Node*	r_proc= Nil;
Node*	r_node= Nil;
Node*	r_term_node= Nil;
Node*	r_list= Nil;
Node*	r_loop= Nil;
Node*	r_alt= Nil;
Node*	r_var= Nil;
Node*	r_obj= Nil;
Node*	r_class= Nil;
Node*	r_term= Nil;
Node*	r_name= Nil;
Node*	r_expression= Nil;
Node*	r_exp_plsmns= Nil;
Node*	r_exp_muldiv= Nil;
Node*	r_proc_letf= Nil;
Node*	r_proc_leti= Nil;
Node*	r_proc_letc= Nil;
Node*	r_proc_rpnf= Nil;
Node*	r_proc_rpni= Nil;
Node*	r_proc_comparef= Nil;
Node*	r_proc_comparei= Nil;
Node*	r_comparing= Nil;
Node*	r_comp_and= Nil;
Node*	r_comp_not= Nil;
Node*	r_comp_gl= Nil;
Node*	r_proc_format= Nil;

extern int ErrorStopFlag;
extern int BreakFlag;

Node*	varlist = Nil;

void RegisterVar(Var* v)
{
	varlist = Cons(v, varlist);
}

Var* SearchVar(const char* s)
{
	Node* p;
	for (p = varlist; p != Nil; p=p->Cdr()) {
		if (((Var*)(p->Car()))->Name() == s) {
			return ((Var*)p->Car());
		}
	}
	return NULL;
}

Var* GetVar(const char* s)
{
	if (strncmp(s, "_", 1) != 0) {
		Var* v = SearchVar(s);
		if (v != NULL) {
			return v;
		}
	}
	Var* r = new Var(s);
	RegisterVar(r);
	return r;
}

void ClearVar()
{
	varlist = Nil;
}


int CheckSJIS2nd()
{
	extern FILE* RdFp;
	extern int CharSJISLen(unsigned char c);
	int c;
	long tp, i;
	int flg = 0;

	tp = FilePointSave();
	for (i = tp-2; i >= 0; i--) {
		fseek(RdFp, i, 0);
		c = fgetc(RdFp);
		if (c < ' ') {
			break;
		}
	}
	i++;

	flg = 0;
	fseek(RdFp, i, 0);
	for ( ; ; i++) {
		c = fgetc(RdFp);
		if (i > tp-2) {
			break;
		}

		if (flg) {
			flg = 0;
		} else if (CharSJISLen(c) > 1) {
			flg = 1;
		}
	}

	FilePointResume(tp);

	return flg;
}

int NOTSPACE()
{
	extern int Char;
	extern int pllexCkSpace(int c);
	extern std::string code;
	extern int CharSJISLen(unsigned char c);

	C();

	switch (Char) {
	case '\"':
	case '\'':
	case '!':
	case '#':
	case '&':
	case '\%':
	case '(':
	case ')':
	case '*':
	case '+':
	case '-':
	case '/':
	case ':':
	case ';':
	case '<':
	case '=':
	case '>':
	case '?':
	case '[':
	case ']':
	case '{':
	case '}':
	case '|':
		if (code == "SJIS") {
			if (CheckSJIS2nd()) {
				return 0;
			}
		}
		UnGetChar(Char);
		return -1;
	}		


	if (Char <= ' ') {
		UnGetChar(Char);
		return -1;
	}

	if (pllexCkSpace(Char)) {
		UnGetChar(Char);
		return -1;
	}


	return 0;
}

int HEXNUM()
{
	extern int Char;
	extern int C();

	SkipSpace();

	tokenPt = 0;

	C();
	if (Char != '0') {
		UnGetChar(Char);
		return -1;
	}
	SetToken(Char);

	C();
	if (Char != 'x') {
		UnGetChar(Char);
		UnGetChar('0');
		return -1;
	}
	SetToken(Char);

	for (;;) {
		C();
		if (isdigit(Char) 
		    || ((Char >= 'a') && (Char <= 'f'))
		    || ((Char >= 'A') && (Char <= 'F'))){
			SetToken(Char);
		} else {
			UnGetChar(Char);
			SetToken('\0');
			break;
		}
	}
	unsigned long long n = strtoll(TOKEN, (char **)NULL, 16);
	snprintf(TOKEN, TOKEN_LEN, "%lld\0", n);
	return 0;	
}

/>

Suffix pl, c;

Syntax program;

program =			</

				   ErrorStopFlag = 0;
				   BreakFlag = 0;

				   if (setjmp(program_jb) != 0) {
//					CXNode = NULL;
					ErrorStopFlag = 0;
//					printf("# %d : error\n", LineNumber());

					return 0;
				   }

				/>
	{
	  ";"
	| goal
	| declare
	}
	;

goal =	"?"			</
				   Node* l_goalnodes = Nil;
				   int orflag = 0;
				   Node* l_goal = Nil; 
				   int r ;
				   ClearVar(); 
				/>
	node			</ l_goal = MkList(r_node); />
	{ 
	   ( "|"		</
				   orflag++;
				   if (orflag == 1) {
					l_goal = MkPred(MkList(mka("or"), 
								l_goal));

				   }
				   l_goalnodes = Nil;
				/> )
	  |
	  ( node		</
				   if (orflag == 0) {
					l_goal = Append(l_goal, MkList(r_node));
				   } else {
					if (l_goalnodes == Nil) {
						l_goalnodes = MkList(r_node);
						l_goal = Append(l_goal, 
								MkList(l_goalnodes));
					} else {
						l_goalnodes 
							= Append(l_goalnodes,
								MkList(r_node));
					}
				   }
				/> )
	}
	";"			</
				   extern int TraceFlag;
				   extern int incflag;
				   if (TraceFlag) {
					   PrintNode("? ", l_goal);
				   }
				   incflag = 0;

				   Context* cx = new Context(Module);

				   l_goal = l_goal->Val();

			 	   struct timeval tv;
				   gettimeofday (&tv, NULL);
				   progtime.start_time = tv.tv_sec*1000000
								+tv.tv_usec;
#ifndef __MINGW32__
				   struct tms tmsbuf;
				   times(&tmsbuf);
				   progtime.start_utime = tmsbuf.tms_utime;
				   progtime.start_stime = tmsbuf.tms_stime;
				   progtime.start_cutime = tmsbuf.tms_cutime;
				   progtime.start_cstime = tmsbuf.tms_cstime;
#endif
				   cxpush(cx, l_goal);

				   if ((r = setjmp(program_jb)) == 0) {
//					   r = FuncPred(cx, l_goal);
					   r = Unify(cx, l_goal);

				   } else {
					r = r - 2;
//					CXNode = NULL;
//					ErrorStopFlag = 0;
//					printf("# %d : error\n", LineNumber());
//					return 0;
				   }

				   cxpop(cx);

				   if (!incflag) {
//					printf("\n");
//				   	PrintNode("result -- ", l_goal);
					printf("result -- \n");
					PPmoduleBody(1, l_goal);
//					l_goal->print(); printf("\n");
				   	if (r == 1) {
						printf("-- true\n");
				   	} else if (r == 0) {
						printf("-- false\n");
				   	} else { // -1
						printf("-- unknown\n");
					}
				   }
				   ClearVar(); 

				   BreakFlag = 0;

//				   PPmodule(Module); printf("\n");

				   delete cx;

				   GC();
				/>
	;

literal =			</ r_literal = Nil; />
	 pred 			</ r_literal = r_pred; />
	;
	
declare =
				</
				   r_defobj = Nil;
				   r_clause = Nil;
				   r_list = Nil;
				/>
	(
				
	defobj			</ Assert(Module, r_defobj); />
	|
	clause			</ Assert(Module, r_clause); />
	| 
	list			</ Module->SetCar(Append(Module->Car(), 
							r_list->Car())); />
	) 
	;

clause = 			</
				   r_clause = Nil; Node* l_clause = Nil; 
				   ClearVar(); 
				/>
	head 
	body ";" 
				</ 
				   if (r_body == Nil) {
					l_clause = MkList(r_head);
				   } else {
					if (r_body->kind() != LIST) {
						r_body = MkList(r_body);
					}
					l_clause = Cons(r_head, r_body); 
				   }
				   ClearVar(); 
				   r_clause = l_clause;
				/>
	;

head	=			</ r_head = Nil; />
	pred			</ r_head = r_pred; />
	;

body	= 			</
				   Node* r_bodynodes = Nil;
				   int orflag = 0;
				   r_body = Nil; 
				/>
	{ 
	   ( "|"		</
				   orflag++;
				   if (orflag == 1) {
					r_body = MkPred(MkList(mka("or"),
								r_body));
				   }
				   r_bodynodes = Nil;
				/> )
	  |
	   ( node		</ 
				   if (orflag == 0) {
					r_body = Append(r_body, MkList(r_node));
				   } else {
					if (r_bodynodes == Nil) {
						r_bodynodes = MkList(r_node);
						r_body = Append(r_body, 
								MkList(r_bodynodes));
					} else {
						r_bodynodes 
							= Append(r_bodynodes,
								MkList(r_node));
					}
				   }
				/> )
	}
	;

defobj =			</
				   r_defobj = Nil;
				   Node* l_defobj = Nil;
				/>
	"::" "<"
		obj_name	</ l_defobj = MkList(MkPred(r_class)); />
		{
		  clause	</ l_defobj = Append(l_defobj, MkList(r_clause)); />
		  | 
		  inherit	</ l_defobj = Append(l_defobj, MkList(r_inherit)); />
		}
	">" [ ";" ]		</ r_defobj = MkList(MkPred(l_defobj)); />
	;

inherit =			</ r_inherit = Nil; />
	"inherit"
	term
	";"			</ r_inherit = MkList(mka("inherit"), r_term); />
	;


pred	=			</ 
				   Node* l_pred = Nil;
				   int   dotflg = 0; 
				   Node* lastnode = Nil;
				   r_pred = Nil;
				/>
	(
	   (
	    "<"			</ l_pred = Nil; />
	    ( 
	      "!"		</ l_pred = MkList(mka("!")); />
	    | proc_rpnf		</ l_pred = r_proc_rpnf; />
	    | proc_rpni		</ l_pred = r_proc_rpni; />
	    | proc_comparef	</ l_pred = r_proc_comparef; />
	    | proc_comparei	</ l_pred = r_proc_comparei; />
	    | proc_letf		</ l_pred = r_proc_letf; />
	    | proc_leti		</ l_pred = r_proc_leti; />
	    | proc_leti2	</ l_pred = r_proc_leti; />
	    | proc_letc		</ l_pred = r_proc_letc; />
	    | proc_format	</ l_pred = r_proc_format; />
	    | (
		node 		</
				   l_pred = lastnode = MkList(r_node); 
				/>
		[";"]
		{
		  node		</
				   l_pred = Append(l_pred, 
						lastnode = MkList(r_node)); 
				/>
		[";"]
		}
		[ ":" node	</
				   ((List*)lastnode)->SetCdr(r_node); 
				/>
		      [";"]
		]
		
	     )
	    )
	    ">"
	   )
	)			</ r_pred = MkPred(l_pred); />
	;


list	=			</
				   Node* l_listnodes = Nil;
				   int orflag = 0;
				   r_list = Nil;
				   Node* l_list = Nil;
				/>
	  "("
		[
		 {
		    ( "|"	</
				   orflag++;
				   if (orflag == 1) {
					l_list = MkPred(MkList(mka("or"),
								l_list));
				   }
				   l_listnodes = Nil;
				/> )
		    | 
		    ( node	</
				   if (orflag == 0) {
					l_list = Append(l_list, MkList(r_node));
				   } else {
					if (l_listnodes == Nil) {
						l_listnodes = MkList(r_node);
						l_list = Append(l_list, 
								MkList(l_listnodes));
					} else {
						l_listnodes 
							= Append(l_listnodes,
								MkList(r_node));
					}
				   }
				/> )
		 }
		 [( ":"
		  node		
				</ 
				   if (orflag == 0) {
					l_list = Append(l_list, r_node);
				   } else {
					if (l_listnodes == Nil) {
						l_listnodes = MkList(r_node);
						l_list = Append(l_list, 
								l_listnodes);
					} else {
						l_listnodes 
							= Append(l_listnodes,
								r_node);
					}
				   }
				/>
		 )]
		] 
	  ")"			</ r_list = l_list; />
	;

obj	=			</ 
				   r_obj = Nil;
				   Node* l_obj = Nil; 
				/>
	"::"
	obj_name		</ l_obj = MkList(mka("obj"), r_class); />
	pred			</ r_obj = MkPred(Append(l_obj, MkList(r_pred))); />
	;

node	=			</ r_node = Nil; />
	(
	  obj			</ r_node = r_obj; />
	| pred			</ r_node = r_pred; />
	| list 			</ r_node = r_list; />
	| loop			</ r_node = r_loop; />
	| alt			</ r_node = r_alt; />
	| var 			</ r_node = r_var; />
	| "\\" 			</ r_node = mka("\\"); />
	| "*" 			</ r_node = mka("*"); />
	| ("+" 
	     ( HEXNUM		</ r_node = mka(TOKEN); />
	      | FNUM		</ r_node = mka(TOKEN); />
	      | "i"		</ r_node = mka("i"); />
	     )
	  )
	| ("-"
	     ( HEXNUM		</ std::string s = "-";
				   s = s + TOKEN;
				   r_node = mka((char*)s.c_str()); />
	     | FNUM		</ std::string s = "-";
				   s = s + TOKEN;
				   r_node = mka((char*)s.c_str()); />
	     | "i"		</ r_node = mka("-i"); />
	     )
	  )
	| "i"			</ r_node = mka("i"); />
	| HEXNUM		</ r_node = mka(TOKEN); />
	| FNUM			</ r_node = mka(TOKEN); />
	| term			</ r_node = r_term; />
	)
	;

loop	=  			</
				   Node* l_loopnodes = Nil;
				   int orflag = 0;
				   r_loop = Nil;
				   Node* l_loop = Nil;
				/>
	"{"
	    {
		    ( "|"	</
				   orflag++;
				   if (orflag == 1) {
					l_loop = MkPred(MkList(mka("or"),
								l_loop));
				   }
				   l_loopnodes = Nil;
				/> )
		    | 
		    ( node	</
				   if (orflag == 0) {
					l_loop = Append(l_loop, MkList(r_node));
				   } else {
					if (l_loopnodes == Nil) {
						l_loopnodes = MkList(r_node);
						l_loop = Append(l_loop, 
								MkList(l_loopnodes));
					} else {
						l_loopnodes 
							= Append(l_loopnodes,
								MkList(r_node));
					}
				   }
				/> )
	    }
	"}"			</ r_loop = MkPred(Cons(mka("loop"), 
							MkList(l_loop))); />
	;

alt	=   			</
				   Node* l_altnodes = Nil;
				   int orflag = 0;
				   r_alt = Nil;
				   Node* l_alt = Nil;
				/>
	"["
	    {
		    ( "|"	</
				   orflag++;
				   if (orflag == 1) {
					l_alt = MkPred(MkList(mka("or"),
								l_alt));
				   }
				   l_altnodes = Nil;
				/> )
		    | 
		    ( node	</
				   if (orflag == 0) {
					l_alt = Append(l_alt, MkList(r_node));
				   } else {
					if (l_altnodes == Nil) {
						l_altnodes = MkList(r_node);
						l_alt = Append(l_alt, 
								MkList(l_altnodes));
					} else {
						l_altnodes 
							= Append(l_altnodes,
								MkList(r_node));
					}
				   }
				/> )
	    }
	"]"			</ 
				   r_alt = MkPred(Cons(mka("alt"), MkList(l_alt))); 
				/>
	;

var	=			</ r_var = Nil; />
	(("_")			</ r_var = GetVar("_"); />
	|
	 ("#" Word		</
					std::string buf = "#";
					buf = buf + TOKEN;
					r_var = GetVar((char*)buf.c_str());
				/>
	  )
	)
	;

obj_name	=		</ r_class = Nil; />
	Word			</ r_class = mka(TOKEN); />
	;

term	=			</ r_term = Nil; />
	Word			</ r_term = mka(TOKEN); />
	;

name	=			</ r_name = Nil; />
	Word			</ r_name = mka(TOKEN); />
	;

expression =			</
				    r_expression = Nil;
				    Node* l_expression = Nil; 
				/>
	exp_plsmns		</ l_expression = r_exp_plsmns;	/>
	{
	(
	   "+" 			</ l_expression = Append(l_expression,
							MkList(mka("+"))); />
	 | "-" 			</ l_expression = Append(l_expression, 
							MkList(mka("-"))); />
	)
	exp_plsmns		</ l_expression = Append(l_expression, 
							r_exp_plsmns); />
	}
				</ r_expression = l_expression; />
	;

exp_plsmns =			</
				   r_exp_plsmns = Nil;
				   Node* l_exp_plsmns = Nil; 
				/>
	exp_muldiv		</ l_exp_plsmns = r_exp_muldiv; />
	{
	(
	   "*" 			</ l_exp_plsmns = Append(l_exp_plsmns, MkList(mka("*"))); />
	 | "/" 			</ l_exp_plsmns = Append(l_exp_plsmns, MkList(mka("/"))); />
	 | "%" 			</ l_exp_plsmns = Append(l_exp_plsmns, MkList(mka("%"))); />
	)
	exp_muldiv		</ l_exp_plsmns = Append(l_exp_plsmns, r_exp_muldiv); />
	}
				</ r_exp_plsmns = l_exp_plsmns; />
	;		

term_node =			</
				   std::string s; 
				   r_term_node = Nil;
				/>
	[
	 "+"			</ s = "+"; />
	 |
	 "-"			</ s = "-"; />
	]
	(
	  obj			</ if (s == "-") {
					r_term_node = MkList(mka("-1"), 
							     mka("*"),
								r_obj);
							     
				   } else {
					r_term_node = MkList(r_obj);
				   }
				/>
	  |
	  pred			</ if (s == "-") {
					r_term_node = MkList(mka("-1"), 
							     mka("*"),
								r_pred);
							     
				   } else {
					r_term_node = MkList(r_pred);
				   }
				/>
	  | 
	   var			</ if (s == "-") {
					r_term_node = MkList(mka("-1"), 
							     mka("*"),
								r_var);
							     
				   } else {
					r_term_node = MkList(r_var);
				   }
				/>
	 |
	  "i"		</ 
				   s += "i";
				   r_term_node = MkList(mka((char*)s.c_str()));
				/>
	 |
	  HEXNUM		</ 
				   s += TOKEN;
				   r_term_node = MkList(mka((char*)s.c_str()));
				/>
	 |
	  FNUM			</ 
				   s += TOKEN;
				   r_term_node = MkList(mka((char*)s.c_str()));
				/>
	)
	;

exp_muldiv =			</ r_exp_muldiv = Nil; />
	((
	  "("
		expression
	  ")"			</ r_exp_muldiv = MkList(r_expression); />
	 )
	| term_node		</ r_exp_muldiv = r_term_node; />
	)
	;

comparing =			</
				    r_comparing = Nil; 
				    Node* l_comp_or = Nil; 
				/>
	comp_and		</ l_comp_or = r_comp_and; />
	[
	  "or"
	 comp_and		</ l_comp_or = MkList(l_comp_or, mka("or"),
								r_comp_and); />
	]
				</ r_comparing = l_comp_or; />
	;


comp_and =			</
				   r_comp_and = Nil;
				   Node* l_comp_and = Nil; 
				/>
	comp_not		</ l_comp_and = r_comp_not; />
	[
	  "and"
	 comp_not		</ l_comp_and = MkList(l_comp_and, mka("and"),
								r_comp_not); />
	]
				</ r_comp_and = l_comp_and; />
	;

comp_not =			</
				   r_comp_not = Nil;
				   Node* l_comp_not = Nil; 
				/>
	[
	  "not"			</ l_comp_not = (MkList(mka("not"))); />
	]
	comp_gl			</ if (l_comp_not == Nil) {
					l_comp_not = r_comp_gl;
				   } else {
					l_comp_not = Append(l_comp_not, 
							MkList(r_comp_gl));
				   }
				/>
				</ r_comp_not = l_comp_not; />
	;

comp_gl =			</
				   r_comp_gl = Nil;
				   Node* l_comp_gl = Nil; 
				/>
	((
	  "("
		comparing
	  ")"			</ r_comp_gl = r_comparing; />
	 )
	|(
	  expression		</ l_comp_gl = r_expression; />
	  (
	    "=="		</ l_comp_gl = Append(l_comp_gl, MkList(mka("=="))); />
	  | "="			</ l_comp_gl = Append(l_comp_gl, MkList(mka("="))); />
	  | "<>"		</ l_comp_gl = Append(l_comp_gl, MkList(mka("<>"))); />
	  | "!="		</ l_comp_gl = Append(l_comp_gl, MkList(mka("!="))); />
	  | "="			</ l_comp_gl = Append(l_comp_gl, MkList(mka("="))); />
	  | ">="		</ l_comp_gl = Append(l_comp_gl, MkList(mka(">="))); />
	  | ">"			</ l_comp_gl = Append(l_comp_gl, MkList(mka(">"))); />
	  | "<="		</ l_comp_gl = Append(l_comp_gl, MkList(mka("<="))); />
	  | "<"			</ l_comp_gl = Append(l_comp_gl, MkList(mka("<"))); />
	  )
	  expression		</ 
				   l_comp_gl = Append(l_comp_gl, r_expression);
				   r_comp_gl = l_comp_gl; 
				/>
	 )
	)
	;


proc_letf =			</
				   r_proc_letf = Nil;
				   Node* l_proc_letf = Nil; 
				/>
	"letf"
	var
	[ "=" ] 			</ l_proc_letf = MkList(mka("letf"),
							r_var,
							mka("=")); 
				/>
	expression		</ 
				   // r_expression->print(); printf("\n");
				   r_proc_letf = l_proc_letf;
				   r_proc_letf = Append(r_proc_letf, r_expression); 

				/>
	;


proc_leti =			</
				   r_proc_leti = Nil;
				   Node* l_proc_leti = Nil; 
				/>
	"let"
	var
	[ "=" ]			</ l_proc_leti = MkList(mka("let"),
							r_var,
							mka("=")); 
				/>
	expression		</ 
				   // r_expression->print(); printf("\n");
				   r_proc_leti = l_proc_leti;
				   r_proc_leti = Append(r_proc_leti, 
							r_expression); 

				/>
	;


proc_leti2 =			</
				   r_proc_leti = Nil;
				   Node* l_proc_leti = Nil; 
				/>
	var
	[ "=" ] 		</ l_proc_leti = MkList(mka("let"),
							r_var,
							mka("=")); 
				/>
	expression		</ 
				   // r_expression->print(); printf("\n");
				   r_proc_leti = l_proc_leti;
				   r_proc_leti = Append(r_proc_leti, r_expression); 

				/>
	;


proc_letc =			</
				   r_proc_letc = Nil;
				   Node* l_proc_letc = Nil; 
				/>
	"letc"
	var
	[ "=" ] 		</ l_proc_letc = MkList(mka("letc"),
							r_var,
							mka("=")); 
				/>
	expression		</ 
				   // r_expression->print(); printf("\n");
				   r_proc_letc = l_proc_letc;
				   r_proc_letc = Append(r_proc_letc, r_expression); 

				/>
	;

proc_comparef =			</ r_proc_comparef = Nil; />
	"comparef"
	comparing		</ r_proc_comparef = MkList(mka("comparef"));
				   r_proc_comparef = Append(r_proc_comparef,
							r_comparing); 
				/>
	;

proc_comparei =			</ r_proc_comparei = Nil; />
	"compare"
	comparing		</ r_proc_comparei = MkList(mka("compare"));
				   r_proc_comparei = Append(r_proc_comparei, 
							r_comparing); 
				/>
	;

proc_rpnf =			</ r_proc_rpnf = Nil; />
	"rpnf"			</ Node* l_proc_rpnf = MkList(mka("rpnf")); />
	var			</ l_proc_rpnf = Append(l_proc_rpnf, MkList(r_var)); />
	{
	   "+"			</ l_proc_rpnf = Append(l_proc_rpnf, MkList(mka("+"))); />
	 | "-"			</ l_proc_rpnf = Append(l_proc_rpnf, MkList(mka("-"))); />
	 | "*"			</ l_proc_rpnf = Append(l_proc_rpnf, MkList(mka("*"))); />
	 | "/"			</ l_proc_rpnf = Append(l_proc_rpnf, MkList(mka("/"))); />
	 | "%"			</ l_proc_rpnf = Append(l_proc_rpnf, MkList(mka("%"))); />
	 | var			</ l_proc_rpnf = Append(l_proc_rpnf, MkList(r_var)); />
	 | obj			</ l_proc_rpnf = Append(l_proc_rpnf, MkList(r_obj)); />
	 | pred			</ l_proc_rpnf = Append(l_proc_rpnf, MkList(r_pred)); />
	 | term			</ l_proc_rpnf = Append(l_proc_rpnf, MkList(r_term)); />
	}			</ r_proc_rpnf = l_proc_rpnf; />
	;

proc_rpni =			</ r_proc_rpni = Nil; />
	"rpn"			</ Node* l_proc_rpni = MkList(mka("rpn")); />
	var			</ l_proc_rpni = Append(l_proc_rpni, MkList(r_var)); />
	{
	   "+"			</ l_proc_rpni = Append(l_proc_rpni, MkList(mka("+"))); />
	 | "-"			</ l_proc_rpni = Append(l_proc_rpni, MkList(mka("-"))); />
	 | "*"			</ l_proc_rpni = Append(l_proc_rpni, MkList(mka("*"))); />
	 | "/"			</ l_proc_rpni = Append(l_proc_rpni, MkList(mka("/"))); />
	 | "%"			</ l_proc_rpni = Append(l_proc_rpni, MkList(mka("%"))); />
	 | var			</ l_proc_rpni = Append(l_proc_rpni, MkList(r_var)); />
	 | obj			</ l_proc_rpni = Append(l_proc_rpni, MkList(r_obj)); />
	 | pred			</ l_proc_rpni = Append(l_proc_rpni, MkList(r_pred)); />
	 | term			</ l_proc_rpni = Append(l_proc_rpni, MkList(r_term)); />
	}			</ r_proc_rpni = l_proc_rpni; />
	;

Word = 				</
				   std::string s; 
				/>
	("-" NUM		</ s = TOKEN; 
				   snprintf(TOKEN, TOKEN_LEN, "-%s", s.c_str());
				/>
	)
	|
	("+" NUM		</ s = TOKEN;
				   snprintf(TOKEN, TOKEN_LEN, "+%s", s.c_str());
				/>
	)
	|
	STRINGS
	|
	WordBlock
	;

WordBlock =			</ { extern int Char; 
				     long tellsave;
				     tokenPt = 0;
				     tellsave=FilePointSave();
				     SkipSpace();
				/>
	NOTSPACE		</!  FilePointResume(tellsave); />
				</   SetToken(Char); />
	  [ {
		NOTSPACE	</   SetToken(Char); />
	   }
	  ]
				</
				     SetToken('\0');
				   }
				/>
	;

proc_format =			</ r_proc_format = Nil; />
	"%"			</ Node* l_proc_format = MkList(mka("%")); />
	var			</ l_proc_format = Append(l_proc_format, 
							MkList(r_var)); />
	Word			</ l_proc_format = Append(l_proc_format, 
							MkList(mka(TOKEN))); />
	node			</ r_proc_format = Append(l_proc_format, 
							MkList(r_node)); />
	;	
