/*
 *  error operation copyright (C) 2009 H.Niwa 
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <stdarg.h>
#include <setjmp.h>

#include <string>

#include "syserr.h"
#include "bin_node.h"

extern jmp_buf program_jb;

void syslist(Node* n)
{
	fprintf(stderr, "error: ");
	n->print(stderr);
	fprintf(stderr, "\n");
}


void syserr(char* fmt, ...)
{
	extern int LineNumber();
	
	va_list	argp;

	va_start(argp, fmt);

	fprintf(stderr, "# %d : error... ", LineNumber());	
	vfprintf(stderr, fmt, argp );
	fflush(stdout);
	fflush(stderr);

	longjmp(program_jb, -1);
}

