Timeline.Debug=SimileAjax.Debug;var log=SimileAjax.Debug.log;Object.extend=function(a,c){for(var b in c){a[b]=c[b]}return a};Timeplot.create=function(a,b){return new Timeplot._Impl(a,b)};Timeplot.createPlotInfo=function(a){return{id:("id" in a)?a.id:"p"+Math.round(Math.random()*1000000),dataSource:("dataSource" in a)?a.dataSource:null,eventSource:("eventSource" in a)?a.eventSource:null,timeGeometry:("timeGeometry" in a)?a.timeGeometry:new Timeplot.DefaultTimeGeometry(),valueGeometry:("valueGeometry" in a)?a.valueGeometry:new Timeplot.DefaultValueGeometry(),timeZone:("timeZone" in a)?a.timeZone:0,fillColor:("fillColor" in a)?((a.fillColor=="string")?new Timeplot.Color(a.fillColor):a.fillColor):null,lineColor:("lineColor" in a)?((a.lineColor=="string")?new Timeplot.Color(a.lineColor):a.lineColor):new Timeplot.Color("#606060"),lineWidth:("lineWidth" in a)?a.lineWidth:1,dotRadius:("dotRadius" in a)?a.dotRadius:2,dotColor:("dotColor" in a)?a.dotColor:null,eventLineWidth:("eventLineWidth" in a)?a.eventLineWidth:1,showValues:("showValues" in a)?a.showValues:false,roundValues:("roundValues" in a)?a.roundValues:true,valuesOpacity:("valuesOpacity" in a)?a.valuesOpacity:75,bubbleWidth:("bubbleWidth" in a)?a.bubbleWidth:300,bubbleHeight:("bubbleHeight" in a)?a.bubbleHeight:200}};Timeplot._Impl=function(a,b){this._id="t"+Math.round(Math.random()*1000000);this._containerDiv=a;this._plotInfos=b;this._painters={background:[],foreground:[]};this._painter=null;this._active=false;this._initialize()};Timeplot._Impl.prototype={dispose:function(){for(var a=0;a<this._plots.length;a++){this._plots[a].dispose()}this._plots=null;this._plotsInfos=null;this._containerDiv.innerHTML=""},getElement:function(){return this._containerDiv},getDocument:function(){return this._containerDiv.ownerDocument},add:function(a){this._containerDiv.appendChild(a)},remove:function(a){this._containerDiv.removeChild(a)},addPainter:function(b,a){var d=this._painters[b];if(d){for(var c=0;c<d.length;c++){if(d[c].context._id==a.context._id){return}}d.push(a)}},removePainter:function(b,a){var d=this._painters[b];if(d){for(var c=0;c<d.length;c++){if(d[c].context._id==a.context._id){d.splice(c,1);break}}}},getWidth:function(){return this._containerDiv.clientWidth},getHeight:function(){return this._containerDiv.clientHeight},getCanvas:function(){return this._canvas},loadText:function(a,f,d,c){if(this._active){var g=this;var e=function(j,h,i){alert("Failed to load data xml from "+a+"\n"+j);g.hideLoadingMessage()};var b=function(h){try{d.loadText(h.responseText,f,a,c)}catch(i){SimileAjax.Debug.exception(i)}finally{g.hideLoadingMessage()}};this.showLoadingMessage();window.setTimeout(function(){SimileAjax.XmlHttp.get(a,e,b)},0)}},loadXML:function(b,d){if(this._active){var a=this;var e=function(h,f,g){alert("Failed to load data xml from "+b+"\n"+h);a.hideLoadingMessage()};var c=function(g){try{var f=g.responseXML;if(!f.documentElement&&g.responseStream){f.load(g.responseStream)}d.loadXML(f,b)}finally{a.hideLoadingMessage()}};this.showLoadingMessage();window.setTimeout(function(){SimileAjax.XmlHttp.get(b,e,c)},0)}},putText:function(e,c,a,b){var d=this.putDiv(e,"timeplot-div "+a,b);d.innerHTML=c;return d},putDiv:function(f,b,c){var d=this._id+"-"+f;var e=document.getElementById(d);if(!e){var a=this._containerDiv.firstChild;e=document.createElement("div");e.setAttribute("id",d);a.appendChild(e)}e.setAttribute("class","timeplot-div "+b);this.placeDiv(e,c);return e},placeDiv:function(b,a){if(a){for(style in a){if(style=="left"){a[style]+=this._paddingX;a[style]+="px"}else{if(style=="right"){a[style]+=this._paddingX;a[style]+="px"}else{if(style=="top"){a[style]+=this._paddingY;a[style]+="px"}else{if(style=="bottom"){a[style]+=this._paddingY;a[style]+="px"}else{if(style=="width"){if(a[style]<0){a[style]=0}a[style]+="px"}else{if(style=="height"){if(a[style]<0){a[style]=0}a[style]+="px"}}}}}}b.style[style]=a[style]}}},locate:function(a){return{x:a.offsetLeft-this._paddingX,y:a.offsetTop-this._paddingY}},update:function(){if(this._active){for(var b=0;b<this._plots.length;b++){var c=this._plots[b];var d=c.getDataSource();if(d){var a=d.getRange();if(a){c._valueGeometry.setRange(a);c._timeGeometry.setRange(a)}}}this.paint()}},repaint:function(){if(this._active){this._prepareCanvas();for(var a=0;a<this._plots.length;a++){var b=this._plots[a];if(b._timeGeometry){b._timeGeometry.reset()}if(b._valueGeometry){b._valueGeometry.reset()}}this.paint()}},paint:function(){if(this._active&&this._painter==null){var a=this;this._painter=window.setTimeout(function(){a._clearCanvas();var e=function(g,f){try{if(f.setTimeplot){f.setTimeplot(a)}g.apply(f,[])}catch(h){SimileAjax.Debug.exception(h)}};var c=a._painters.background;for(var b=0;b<c.length;b++){e(c[b].action,c[b].context)}var d=a._painters.foreground;for(var b=0;b<d.length;b++){e(d[b].action,d[b].context)}a._painter=null},20)}},_clearCanvas:function(){var b=this.getCanvas();var a=b.getContext("2d");a.clearRect(0,0,b.width,b.height)},_prepareCanvas:function(){var b=this.getCanvas();var c=SimileAjax.DOM.getSize(this._containerDiv);b.width=c.w;b.height=c.h;this._paddingX=(this.getWidth()-b.width)/2;this._paddingY=(this.getHeight()-b.height)/2;var a=b.getContext("2d");a.translate(0,b.height);a.scale(1,-1);a.globalCompositeOperation="source-over"},_isBrowserSupported:function(b){var a=SimileAjax.Platform.browser;if(b.getContext&&window.getComputedStyle){return true}else{return false}},_initialize:function(){SimileAjax.WindowManager.initialize();var h=this._containerDiv;var k=h.ownerDocument;h.className="timeplot-container "+h.className;while(h.firstChild){h.removeChild(h.firstChild)}var b=k.createElement("canvas");if(this._isBrowserSupported(b)){var e=k.createElement("div");h.appendChild(e);this._canvas=b;b.className="timeplot-canvas";this._prepareCanvas();h.appendChild(b);var c=SimileAjax.Graphics.createTranslucentImage(Timeplot.urlPrefix+"images/copyright.png");c.className="timeplot-copyright";c.title="Timeplot (c) SIMILE - http://simile.mit.edu/timeplot/";SimileAjax.DOM.registerEvent(c,"click",function(){window.location="http://simile.mit.edu/timeplot/"});h.appendChild(c);var f=this;var j={onAddMany:function(){f.update()},onClear:function(){f.update()}};this._plots=[];if(this._plotInfos){for(var d=0;d<this._plotInfos.length;d++){var g=new Timeplot.Plot(this,this._plotInfos[d]);var a=g.getDataSource();if(a){a.addListener(j)}this.addPainter("background",{context:g.getTimeGeometry(),action:g.getTimeGeometry().paint});this.addPainter("background",{context:g.getValueGeometry(),action:g.getValueGeometry().paint});this.addPainter("foreground",{context:g,action:g.paint});this._plots.push(g);g.initialize()}}var l=SimileAjax.Graphics.createMessageBubble(k);l.containerDiv.className="timeplot-message-container";h.appendChild(l.containerDiv);l.contentDiv.className="timeplot-message";l.contentDiv.innerHTML="<img src='http://static.simile.mit.edu/timeline/api/images/progress-running.gif' /> Loading...";this.showLoadingMessage=function(){l.containerDiv.style.display="block"};this.hideLoadingMessage=function(){l.containerDiv.style.display="none"};this._active=true}else{this._message=SimileAjax.Graphics.createMessageBubble(k);this._message.containerDiv.className="timeplot-message-container";this._message.containerDiv.style.top="15%";this._message.containerDiv.style.left="20%";this._message.containerDiv.style.right="20%";this._message.containerDiv.style.minWidth="20em";this._message.contentDiv.className="timeplot-message";this._message.contentDiv.innerHTML="We're terribly sorry, but your browser is not currently supported by <a href='http://simile.mit.edu/timeplot/'>Timeplot</a>.<br><br> We are working on supporting it in the near future but, for now, see the <a href='http://simile.mit.edu/wiki/Timeplot_Limitations'>list of currently supported browsers</a>.";this._message.containerDiv.style.display="block";h.appendChild(this._message.containerDiv)}}};Timeplot.Plot=function(a,b){this._timeplot=a;this._canvas=a.getCanvas();this._plotInfo=b;this._id=b.id;this._timeGeometry=b.timeGeometry;this._valueGeometry=b.valueGeometry;this._showValues=b.showValues;this._theme=new Timeline.getDefaultTheme();this._dataSource=b.dataSource;this._eventSource=b.eventSource;this._bubble=null};Timeplot.Plot.prototype={initialize:function(){if(this._showValues&&this._dataSource&&this._dataSource.getValue){this._timeFlag=this._timeplot.putDiv("timeflag","timeplot-timeflag");this._valueFlag=this._timeplot.putDiv(this._id+"valueflag","timeplot-valueflag");this._valueFlagLineLeft=this._timeplot.putDiv(this._id+"valueflagLineLeft","timeplot-valueflag-line");this._valueFlagLineRight=this._timeplot.putDiv(this._id+"valueflagLineRight","timeplot-valueflag-line");if(!this._valueFlagLineLeft.firstChild){this._valueFlagLineLeft.appendChild(SimileAjax.Graphics.createTranslucentImage(Timeplot.urlPrefix+"images/line_left.png"));this._valueFlagLineRight.appendChild(SimileAjax.Graphics.createTranslucentImage(Timeplot.urlPrefix+"images/line_right.png"))}this._valueFlagPole=this._timeplot.putDiv(this._id+"valuepole","timeplot-valueflag-pole");var d=this._plotInfo.valuesOpacity;SimileAjax.Graphics.setOpacity(this._timeFlag,d);SimileAjax.Graphics.setOpacity(this._valueFlag,d);SimileAjax.Graphics.setOpacity(this._valueFlagLineLeft,d);SimileAjax.Graphics.setOpacity(this._valueFlagLineRight,d);SimileAjax.Graphics.setOpacity(this._valueFlagPole,d);var f=this;var g=function(i,h,j){f._valueFlag.style.display="block";a(i,h,j)};var b=24*60*60*1000;var e=30*b;var a=function(j,A,o){if(typeof SimileAjax!="undefined"){var r=f._canvas;var w=Math.round(SimileAjax.DOM.getEventRelativeCoordinates(A,f._canvas).x);if(w>r.width){w=r.width}if(isNaN(w)||w<0){w=0}var B=f._timeGeometry.fromScreen(w);if(B==0){f._valueFlag.style.display="none";return}var z=f._dataSource.getValue(B);if(f._plotInfo.roundValues){z=Math.round(z)}f._valueFlag.innerHTML=new String(z);var q=new Date(B);var i=f._timeGeometry.getPeriod();if(i<b){f._timeFlag.innerHTML=q.toLocaleTimeString()}else{if(i>e){f._timeFlag.innerHTML=q.toLocaleDateString()}else{f._timeFlag.innerHTML=q.toLocaleString()}}var n=f._timeFlag.clientWidth;var h=f._timeFlag.clientHeight;var k=Math.round(n/2);var u=f._valueFlag.clientWidth;var m=f._valueFlag.clientHeight;var s=f._valueGeometry.toScreen(z);if(w+k>r.width){var l=r.width-k}else{if(w-k<0){var l=k}else{var l=w}}if(f._timeGeometry._timeValuePosition=="top"){f._timeplot.placeDiv(f._valueFlagPole,{left:w,top:h-5,height:r.height-s-h+6,display:"block"});f._timeplot.placeDiv(f._timeFlag,{left:l-k,top:-6,display:"block"})}else{f._timeplot.placeDiv(f._valueFlagPole,{left:w,bottom:h-5,height:s-h+6,display:"block"});f._timeplot.placeDiv(f._timeFlag,{left:l-k,bottom:-6,display:"block"})}if(w+u+14>r.width&&s+m+4>r.height){f._valueFlagLineLeft.style.display="none";f._timeplot.placeDiv(f._valueFlagLineRight,{left:w-14,bottom:s-14,display:"block"});f._timeplot.placeDiv(f._valueFlag,{left:w-u-13,bottom:s-m-13,display:"block"})}else{if(w+u+14>r.width&&s+m+4<r.height){f._valueFlagLineRight.style.display="none";f._timeplot.placeDiv(f._valueFlagLineLeft,{left:w-14,bottom:s,display:"block"});f._timeplot.placeDiv(f._valueFlag,{left:w-u-13,bottom:s+13,display:"block"})}else{if(w+u+14<r.width&&s+m+4>r.height){f._valueFlagLineRight.style.display="none";f._timeplot.placeDiv(f._valueFlagLineLeft,{left:w,bottom:s-13,display:"block"});f._timeplot.placeDiv(f._valueFlag,{left:w+13,bottom:s-13,display:"block"})}else{f._valueFlagLineLeft.style.display="none";f._timeplot.placeDiv(f._valueFlagLineRight,{left:w,bottom:s,display:"block"});f._timeplot.placeDiv(f._valueFlag,{left:w+13,bottom:s+13,display:"block"})}}}}};var c=this._timeplot.getElement();SimileAjax.DOM.registerEvent(c,"mouseover",g);SimileAjax.DOM.registerEvent(c,"mousemove",a)}},dispose:function(){if(this._dataSource){this._dataSource.removeListener(this._paintingListener);this._paintingListener=null;this._dataSource.dispose();this._dataSource=null}},getDataSource:function(){return(this._dataSource)?this._dataSource:this._eventSource},getTimeGeometry:function(){return this._timeGeometry},getValueGeometry:function(){return this._valueGeometry},paint:function(){var n=this._canvas.getContext("2d");n.lineWidth=this._plotInfo.lineWidth;n.lineJoin="miter";if(this._dataSource){if(this._plotInfo.fillColor){var a=n.createLinearGradient(0,this._canvas.height,0,0);a.addColorStop(0,this._plotInfo.fillColor.toString());a.addColorStop(0.5,this._plotInfo.fillColor.toString());a.addColorStop(1,"rgba(255,255,255,0)");n.fillStyle=a;n.beginPath();n.moveTo(0,0);this._plot(function(c,i){n.lineTo(c,i)});n.lineTo(this._canvas.width,0);n.fill()}if(this._plotInfo.lineColor){n.strokeStyle=this._plotInfo.lineColor.toString();n.beginPath();this._plot(function(c,i){n.lineTo(c,i)});n.stroke()}if(this._plotInfo.dotColor){n.fillStyle=this._plotInfo.dotColor.toString();var l=this._plotInfo.dotRadius;this._plot(function(c,i){n.beginPath();n.arc(c,i,l,0,2*Math.PI,true);n.fill()})}}if(this._eventSource){var a=n.createLinearGradient(0,0,0,this._canvas.height);a.addColorStop(1,"rgba(255,255,255,0)");n.strokeStyle=a;n.fillStyle=a;n.lineWidth=this._plotInfo.eventLineWidth;n.lineJoin="miter";var s=this._eventSource.getAllEventIterator();while(s.hasNext()){var q=s.next();var o=q.getColor();o=(o)?new Timeplot.Color(o):this._plotInfo.lineColor;var b=q.getStart().getTime();var t=q.getEnd().getTime();if(b==t){var u=o.toString();a.addColorStop(0,u);var f=this._timeGeometry.toScreen(b);f=Math.floor(f)+0.5;var d=f;n.beginPath();n.moveTo(f,0);n.lineTo(f,this._canvas.height);n.stroke();var g=f-4;var j=7}else{var u=o.toString(0.5);a.addColorStop(0,u);var f=this._timeGeometry.toScreen(b);f=Math.floor(f)+0.5;var d=this._timeGeometry.toScreen(t);d=Math.floor(d)+0.5;n.fillRect(f,0,d-f,this._canvas.height);var g=f;var j=d-f-1}var k=this._timeplot.putDiv(q.getID(),"timeplot-event-box",{left:Math.round(g),width:Math.round(j),top:0,height:this._canvas.height-1});var p=this;var h=function(c){return function(v,i,y){var x=p._timeplot.getDocument();p._closeBubble();var w=SimileAjax.DOM.getEventPageCoordinates(i);var r=SimileAjax.DOM.getPageCoordinates(v);p._bubble=SimileAjax.Graphics.createBubbleForPoint(w.x,r.top+p._canvas.height,p._plotInfo.bubbleWidth,p._plotInfo.bubbleHeight,"bottom");c.fillInfoBubble(p._bubble.content,p._theme,p._timeGeometry.getLabeler())}};var e=function(i,c,r){i.oldClass=i.className;i.className=i.className+" timeplot-event-box-highlight"};var m=function(i,c,r){i.className=i.oldClass;i.oldClass=null};if(!k.instrumented){SimileAjax.DOM.registerEvent(k,"click",h(q));SimileAjax.DOM.registerEvent(k,"mouseover",e);SimileAjax.DOM.registerEvent(k,"mouseout",m);k.instrumented=true}}}},_plot:function(g){var e=this._dataSource.getData();if(e){var h=e.times;var b=e.values;var c=h.length;for(var d=0;d<c;d++){var a=this._timeGeometry.toScreen(h[d]);var i=this._valueGeometry.toScreen(b[d]);g(a,i)}}},_closeBubble:function(){if(this._bubble!=null){this._bubble.close();this._bubble=null}}};Timeplot.DefaultEventSource=function(a){Timeline.DefaultEventSource.apply(this,arguments)};Object.extend(Timeplot.DefaultEventSource.prototype,Timeline.DefaultEventSource.prototype);Timeplot.DefaultEventSource.prototype.loadText=function(l,h,a,c){if(l==null){return}this._events.maxValues=new Array();var b=this._getBaseURL(a);var d="iso8601";var g=this._events.getUnit().getParser(d);var f=this._parseText(l,h);var j=false;if(c){f=c(f)}if(f){for(var e=0;e<f.length;e++){var m=f[e];if(m.length>1){var k=new Timeplot.DefaultEventSource.NumericEvent(g(m[0]),m.slice(1));this._events.add(k);j=true}}}if(j){this._fire("onAddMany",[])}};Timeplot.DefaultEventSource.prototype._parseText=function(h,c){h=h.replace(/\r\n?/g,"\n");var f=0;var e=h.length;var i=[];while(f<e){var j=[];if(h.charAt(f)!="#"){while(f<e){if(h.charAt(f)=='"'){var a=h.indexOf('"',f+1);while(a<e&&a>-1){if(h.charAt(a+1)!='"'){break}a=h.indexOf('"',a+2)}if(a<0){}else{if(h.charAt(a+1)==c){var b=h.substr(f+1,a-f-1);b=b.replace(/""/g,'"');j[j.length]=b;f=a+2;continue}else{if(h.charAt(a+1)=="\n"||e==a+1){var b=h.substr(f+1,a-f-1);b=b.replace(/""/g,'"');j[j.length]=b;f=a+2;break}else{}}}}var g=h.indexOf(c,f);var d=h.indexOf("\n",f);if(d<0){d=e}if(g>-1&&g<d){j[j.length]=h.substr(f,g-f);f=g+1}else{j[j.length]=h.substr(f,d-f);f=d+1;break}}}else{var d=h.indexOf("\n",f);f=(d>-1)?d+1:cur}if(j.length>0){i[i.length]=j}}if(i.length<0){return}return i};Timeplot.DefaultEventSource.prototype.getRange=function(){var a=this.getEarliestDate();var b=this.getLatestDate();return{earliestDate:(a)?a:null,latestDate:(b)?b:null,min:0,max:0}};Timeplot.DefaultEventSource.NumericEvent=function(b,a){this._id="e"+Math.round(Math.random()*1000000);this._time=b;this._values=a};Timeplot.DefaultEventSource.NumericEvent.prototype={getID:function(){return this._id},getTime:function(){return this._time},getValues:function(){return this._values},getStart:function(){return this._time},getEnd:function(){return this._time}};Timeplot.DataSource=function(b){this._eventSource=b;var a=this;this._processingListener={onAddMany:function(){a._process()},onClear:function(){a._clear()}};this.addListener(this._processingListener);this._listeners=[];this._data=null;this._range=null};Timeplot.DataSource.prototype={_clear:function(){this._data=null;this._range=null},_process:function(){this._data={times:new Array(),values:new Array()};this._range={earliestDate:null,latestDate:null,min:0,max:0}},getRange:function(){return this._range},getData:function(){return this._data},getValue:function(c){if(this._data){for(var b=0;b<this._data.times.length;b++){var a=this._data.times[b];if(a>c){return this._data.values[b]}}}return 0},addListener:function(a){this._eventSource.addListener(a)},removeListener:function(a){this._eventSource.removeListener(a)},replaceListener:function(a,b){this.removeListener(a);this.addListener(b)}};Timeplot.ColumnSource=function(b,a){Timeplot.DataSource.apply(this,arguments);this._column=a-1};Object.extend(Timeplot.ColumnSource.prototype,Timeplot.DataSource.prototype);Timeplot.ColumnSource.prototype.dispose=function(){this.removeListener(this._processingListener);this._clear()};Timeplot.ColumnSource.prototype._process=function(){var g=this._eventSource.getCount();var a=new Array(g);var k=new Array(g);var d=Number.MAX_VALUE;var h=Number.MIN_VALUE;var e=0;var f=this._eventSource.getAllEventIterator();while(f.hasNext()){var b=f.next();var c=b.getTime();a[e]=c;var j=this._getValue(b);if(!isNaN(j)){if(j<d){d=j}if(j>h){h=j}k[e]=j}e++}this._data={times:a,values:k};this._range={earliestDate:this._eventSource.getEarliestDate(),latestDate:this._eventSource.getLatestDate(),min:d,max:h}};Timeplot.ColumnSource.prototype._getValue=function(a){return parseFloat(a.getValues()[this._column])};Timeplot.ColumnDiffSource=function(c,b,a){Timeplot.ColumnSource.apply(this,arguments);this._column2=a-1};Object.extend(Timeplot.ColumnDiffSource.prototype,Timeplot.ColumnSource.prototype);Timeplot.ColumnDiffSource.prototype._getValue=function(e){var d=parseFloat(e.getValues()[this._column]);var c=parseFloat(e.getValues()[this._column2]);return d-c};Timeplot.DefaultValueGeometry=function(a){if(!a){a={}}this._id=("id" in a)?a.id:"g"+Math.round(Math.random()*1000000);this._axisColor=("axisColor" in a)?((typeof a.axisColor=="string")?new Timeplot.Color(a.axisColor):a.axisColor):new Timeplot.Color("#606060"),this._gridColor=("gridColor" in a)?((typeof a.gridColor=="string")?new Timeplot.Color(a.gridColor):a.gridColor):null,this._gridLineWidth=("gridLineWidth" in a)?a.gridLineWidth:0.5;this._axisLabelsPlacement=("axisLabelsPlacement" in a)?a.axisLabelsPlacement:"right";this._gridSpacing=("gridSpacing" in a)?a.gridStep:50;this._gridType=("gridType" in a)?a.gridType:"short";this._gridShortSize=("gridShortSize" in a)?a.gridShortSize:10;this._minValue=("min" in a)?a.min:null;this._maxValue=("max" in a)?a.max:null;this._linMap={direct:function(b){return b},inverse:function(b){return b}};this._map=this._linMap;this._labels=[];this._grid=[]};Timeplot.DefaultValueGeometry.prototype={setTimeplot:function(a){this._timeplot=a;this._canvas=a.getCanvas();this.reset()},setRange:function(a){if((this._minValue==null)||((this._minValue!=null)&&(a.min<this._minValue))){this._minValue=a.min}if((this._maxValue==null)||((this._maxValue!=null)&&(a.max*1.05>this._maxValue))){this._maxValue=a.max*1.05}this._updateMappedValues();if(!(this._minValue==0&&this._maxValue==0)){this._grid=this._calculateGrid()}},reset:function(){this._clearLabels();this._updateMappedValues();this._grid=this._calculateGrid()},toScreen:function(b){if(this._canvas&&this._maxValue){var a=b-this._minValue;return this._canvas.height*(this._map.direct(a))/this._mappedRange}else{return -50}},fromScreen:function(a){if(this._canvas){return this._map.inverse(this._mappedRange*a/this._canvas.height)+this._minValue}else{return 0}},paint:function(){if(this._timeplot){var b=this._canvas.getContext("2d");b.lineJoin="miter";if(this._gridColor){var e=b.createLinearGradient(0,0,0,this._canvas.height);e.addColorStop(0,this._gridColor.toHexString());e.addColorStop(0.3,this._gridColor.toHexString());e.addColorStop(1,"rgba(255,255,255,0.5)");b.lineWidth=this._gridLineWidth;b.strokeStyle=e;for(var d=0;d<this._grid.length;d++){var c=this._grid[d];var g=Math.floor(c.y)+0.5;if(typeof c.label!="undefined"){if(this._axisLabelsPlacement=="left"){var f=this._timeplot.putText(this._id+"-"+d,c.label,"timeplot-grid-label",{left:4,bottom:g+2,color:this._gridColor.toHexString(),visibility:"hidden"})}else{if(this._axisLabelsPlacement=="right"){var f=this._timeplot.putText(this._id+"-"+d,c.label,"timeplot-grid-label",{right:4,bottom:g+2,color:this._gridColor.toHexString(),visibility:"hidden"})}}if(g+f.clientHeight<this._canvas.height+10){f.style.visibility="visible"}}b.beginPath();if(this._gridType=="long"||c.label==0){b.moveTo(0,g);b.lineTo(this._canvas.width,g)}else{if(this._gridType=="short"){if(this._axisLabelsPlacement=="left"){b.moveTo(0,g);b.lineTo(this._gridShortSize,g)}else{if(this._axisLabelsPlacement=="right"){b.moveTo(this._canvas.width,g);b.lineTo(this._canvas.width-this._gridShortSize,g)}}}}b.stroke()}}var a=b.createLinearGradient(0,0,0,this._canvas.height);a.addColorStop(0,this._axisColor.toString());a.addColorStop(0.5,this._axisColor.toString());a.addColorStop(1,"rgba(255,255,255,0.5)");b.lineWidth=1;b.strokeStyle=a;b.beginPath();b.moveTo(0,this._canvas.height);b.lineTo(0,0);b.stroke();b.beginPath();b.moveTo(this._canvas.width,0);b.lineTo(this._canvas.width,this._canvas.height);b.stroke()}},_clearLabels:function(){for(var b=0;b<this._labels.length;b++){var a=this._labels[b];var c=a.parentNode;if(c){c.removeChild(a)}}},_calculateGrid:function(){var c=[];if(!this._canvas||this._valueRange==0){return c}var d=0;if(this._valueRange>1){while(Math.pow(10,d)<this._valueRange){d++}d--}else{while(Math.pow(10,d)>this._valueRange){d--}}var e=Math.pow(10,d);var f=e;while(true){var a=this.toScreen(this._minValue+f);while(a<this._gridSpacing){f+=e;a=this.toScreen(this._minValue+f)}if(a>2*this._gridSpacing){e/=10;f=e}else{break}}var b=0;var g=this.toScreen(b);if(this._minValue>=0){while(g<this._canvas.height){if(g>0){c.push({y:g,label:b})}b+=f;g=this.toScreen(b)}}else{if(this._maxValue<=0){while(g>0){if(g<this._canvas.height){c.push({y:g,label:b})}b-=f;g=this.toScreen(b)}}else{while(g<this._canvas.height){if(g>0){c.push({y:g,label:b})}b+=f;g=this.toScreen(b)}b=-f;g=this.toScreen(b);while(g>0){if(g<this._canvas.height){c.push({y:g,label:b})}b-=f;g=this.toScreen(b)}}}return c},_updateMappedValues:function(){this._valueRange=Math.abs(this._maxValue-this._minValue);this._mappedRange=this._map.direct(this._valueRange)}};Timeplot.LogarithmicValueGeometry=function(a){Timeplot.DefaultValueGeometry.apply(this,arguments);this._logMap={direct:function(b){return Math.log(b+1)/Math.log(10)},inverse:function(b){return Math.exp(Math.log(10)*b)-1}};this._mode="log";this._map=this._logMap;this._calculateGrid=this._logarithmicCalculateGrid};Timeplot.LogarithmicValueGeometry.prototype._linearCalculateGrid=Timeplot.DefaultValueGeometry.prototype._calculateGrid;Object.extend(Timeplot.LogarithmicValueGeometry.prototype,Timeplot.DefaultValueGeometry.prototype);Timeplot.LogarithmicValueGeometry.prototype._logarithmicCalculateGrid=function(){var b=[];if(!this._canvas||this._valueRange==0){return b}var a=1;var c=this.toScreen(a);while(c<this._canvas.height||isNaN(c)){if(c>0){b.push({y:c,label:a})}a*=10;c=this.toScreen(a)}return b};Timeplot.LogarithmicValueGeometry.prototype.actLinear=function(){this._mode="lin";this._map=this._linMap;this._calculateGrid=this._linearCalculateGrid;this.reset()};Timeplot.LogarithmicValueGeometry.prototype.actLogarithmic=function(){this._mode="log";this._map=this._logMap;this._calculateGrid=this._logarithmicCalculateGrid;this.reset()};Timeplot.LogarithmicValueGeometry.prototype.toggle=function(){if(this._mode=="log"){this.actLinear()}else{this.actLogarithmic()}};Timeplot.DefaultTimeGeometry=function(b){if(!b){b={}}this._id=("id" in b)?b.id:"g"+Math.round(Math.random()*1000000);this._locale=("locale" in b)?b.locale:"en";this._timeZone=("timeZone" in b)?b.timeZone:SimileAjax.DateTime.getTimezone();this._labeller=("labeller" in b)?b.labeller:null;this._axisColor=("axisColor" in b)?((b.axisColor=="string")?new Timeplot.Color(b.axisColor):b.axisColor):new Timeplot.Color("#606060"),this._gridColor=("gridColor" in b)?((b.gridColor=="string")?new Timeplot.Color(b.gridColor):b.gridColor):null,this._gridLineWidth=("gridLineWidth" in b)?b.gridLineWidth:0.5;this._axisLabelsPlacement=("axisLabelsPlacement" in b)?b.axisLabelsPlacement:"bottom";this._gridStep=("gridStep" in b)?b.gridStep:100;this._gridStepRange=("gridStepRange" in b)?b.gridStepRange:20;this._min=("min" in b)?b.min:null;this._max=("max" in b)?b.max:null;this._timeValuePosition=("timeValuePosition" in b)?b.timeValuePosition:"bottom";this._unit=("unit" in b)?b.unit:Timeline.NativeDateUnit;this._linMap={direct:function(c){return c},inverse:function(c){return c}};this._map=this._linMap;this._labeler=this._unit.createLabeller(this._locale,this._timeZone);var a=this._unit.getParser("iso8601");if(this._min&&!this._min.getTime){this._min=a(this._min)}if(this._max&&!this._max.getTime){this._max=a(this._max)}this._grid=[]};Timeplot.DefaultTimeGeometry.prototype={setTimeplot:function(a){this._timeplot=a;this._canvas=a.getCanvas();this.reset()},setRange:function(a){if(this._min){this._earliestDate=this._min}else{if(a.earliestDate&&((this._earliestDate==null)||((this._earliestDate!=null)&&(a.earliestDate.getTime()<this._earliestDate.getTime())))){this._earliestDate=a.earliestDate}}if(this._max){this._latestDate=this._max}else{if(a.latestDate&&((this._latestDate==null)||((this._latestDate!=null)&&(a.latestDate.getTime()>this._latestDate.getTime())))){this._latestDate=a.latestDate}}if(!this._earliestDate&&!this._latestDate){this._grid=[]}else{this.reset()}},reset:function(){this._updateMappedValues();if(this._canvas){this._grid=this._calculateGrid()}},toScreen:function(b){if(this._canvas&&this._latestDate){var a=b-this._earliestDate.getTime();return this._canvas.width*this._map.direct(a)/this._mappedPeriod}else{return -50}},fromScreen:function(a){if(this._canvas){return this._map.inverse(this._mappedPeriod*a/this._canvas.width)+this._earliestDate.getTime()}else{return 0}},getPeriod:function(){return this._period},getLabeler:function(){return this._labeler},getUnit:function(){return this._unit},paint:function(){if(this._canvas){var e=this._unit;var b=this._canvas.getContext("2d");var f=b.createLinearGradient(0,0,0,this._canvas.height);b.strokeStyle=f;b.lineWidth=this._gridLineWidth;b.lineJoin="miter";if(this._gridColor){f.addColorStop(0,this._gridColor.toString());f.addColorStop(1,"rgba(255,255,255,0.9)");for(var d=0;d<this._grid.length;d++){var c=this._grid[d];var a=Math.floor(c.x)+0.5;if(this._axisLabelsPlacement=="top"){var g=this._timeplot.putText(this._id+"-"+d,c.label,"timeplot-grid-label",{left:a+4,top:2,visibility:"hidden"})}else{if(this._axisLabelsPlacement=="bottom"){var g=this._timeplot.putText(this._id+"-"+d,c.label,"timeplot-grid-label",{left:a+4,bottom:2,visibility:"hidden"})}}if(a+g.clientWidth<this._canvas.width+10){g.style.visibility="visible"}b.beginPath();b.moveTo(a,0);b.lineTo(a,this._canvas.height);b.stroke()}}f.addColorStop(0,this._axisColor.toString());f.addColorStop(1,"rgba(255,255,255,0.5)");b.lineWidth=1;f.addColorStop(0,this._axisColor.toString());b.beginPath();b.moveTo(0,0);b.lineTo(this._canvas.width,0);b.stroke()}},_calculateGrid:function(){var a=[];var d=SimileAjax.DateTime;var h=this._unit;var b=this._period;if(b==0){return a}if(b>d.gregorianUnitLengths[d.MILLENNIUM]){g=d.MILLENNIUM}else{for(var g=d.MILLENNIUM;g>0;g--){if(d.gregorianUnitLengths[g-1]<=b&&b<d.gregorianUnitLengths[g]){g--;break}}}var i=h.cloneValue(this._earliestDate);do{d.roundDownToInterval(i,g,this._timeZone,1,0);var f=this.toScreen(h.toNumber(i));switch(g){case d.SECOND:var e=i.toLocaleTimeString();break;case d.MINUTE:var c=i.getMinutes();var e=i.getHours()+":"+((c<10)?"0":"")+c;break;case d.HOUR:var e=i.getHours()+":00";break;case d.DAY:case d.WEEK:case d.MONTH:var e=i.toLocaleDateString();break;case d.YEAR:case d.DECADE:case d.CENTURY:case d.MILLENNIUM:var e=i.getUTCFullYear();break}if(f>0){a.push({x:f,label:e})}d.incrementByInterval(i,g)}while(i.getTime()<this._latestDate.getTime());return a},_updateMappedValues:function(){if(this._latestDate&&this._earliestDate){this._period=this._latestDate.getTime()-this._earliestDate.getTime();this._mappedPeriod=this._map.direct(this._period)}else{this._period=0;this._mappedPeriod=0}}};Timeplot.MagnifyingTimeGeometry=function(b){Timeplot.DefaultTimeGeometry.apply(this,arguments);var a=this;this._MagnifyingMap={direct:function(d){if(d<a._leftTimeMargin){var c=d*a._leftRate}else{if(a._leftTimeMargin<d&&d<a._rightTimeMargin){var c=d*a._expandedRate+a._expandedTimeTranslation}else{var c=d*a._rightRate+a._rightTimeTranslation}}return c},inverse:function(c){if(c<a._leftScreenMargin){var d=c/a._leftRate}else{if(a._leftScreenMargin<c&&c<a._rightScreenMargin){var d=c/a._expandedRate+a._expandedScreenTranslation}else{var d=c/a._rightRate+a._rightScreenTranslation}}return d}};this._mode="lin";this._map=this._linMap};Object.extend(Timeplot.MagnifyingTimeGeometry.prototype,Timeplot.DefaultTimeGeometry.prototype);Timeplot.MagnifyingTimeGeometry.prototype.initialize=function(f){Timeplot.DefaultTimeGeometry.prototype.initialize.apply(this,arguments);if(!this._lens){this._lens=this._timeplot.putDiv("lens","timeplot-lens")}var g=1000*60*60*24*30;var h=this;var b=function(k){var m=k.clientWidth;var l=h._timeplot.locate(k);h.setMagnifyingParams(l.x+m/2,m,g);h.actMagnifying();h._timeplot.paint()};var j=function(l,k,m){h._canvas.startCoords=SimileAjax.DOM.getEventRelativeCoordinates(k,l);h._canvas.pressed=true};var i=function(l,k,n){h._canvas.pressed=false;var m=SimileAjax.DOM.getEventRelativeCoordinates(k,l);if(Timeplot.Math.isClose(m,h._canvas.startCoords,5)){h._lens.style.display="none";h.actLinear();h._timeplot.paint()}else{h._lens.style.cursor="move";b(h._lens)}};var d=function(l,k,n){if(h._canvas.pressed){var m=SimileAjax.DOM.getEventRelativeCoordinates(k,l);if(m.x<0){m.x=0}if(m.x>h._canvas.width){m.x=h._canvas.width}h._timeplot.placeDiv(h._lens,{left:h._canvas.startCoords.x,width:m.x-h._canvas.startCoords.x,bottom:0,height:h._canvas.height,display:"block"})}};var a=function(l,k,m){h._lens.startCoords=SimileAjax.DOM.getEventRelativeCoordinates(k,l);h._lens.pressed=true};var c=function(l,k,m){h._lens.pressed=false};var e=function(m,k,p){if(h._lens.pressed){var n=SimileAjax.DOM.getEventRelativeCoordinates(k,m);var l=h._lens;var o=l.offsetLeft+n.x-l.startCoords.x;if(o<h._timeplot._paddingX){o=h._timeplot._paddingX}if(o+l.clientWidth>h._canvas.width-h._timeplot._paddingX){o=h._canvas.width-l.clientWidth+h._timeplot._paddingX}l.style.left=o;b(l)}};if(!this._canvas.instrumented){SimileAjax.DOM.registerEvent(this._canvas,"mousedown",j);SimileAjax.DOM.registerEvent(this._canvas,"mousemove",d);SimileAjax.DOM.registerEvent(this._canvas,"mouseup",i);SimileAjax.DOM.registerEvent(this._canvas,"mouseup",c);this._canvas.instrumented=true}if(!this._lens.instrumented){SimileAjax.DOM.registerEvent(this._lens,"mousedown",a);SimileAjax.DOM.registerEvent(this._lens,"mousemove",e);SimileAjax.DOM.registerEvent(this._lens,"mouseup",c);SimileAjax.DOM.registerEvent(this._lens,"mouseup",i);this._lens.instrumented=true}};Timeplot.MagnifyingTimeGeometry.prototype.setMagnifyingParams=function(j,g,e){g=g/2;e=e/2;var f=this._canvas.width;var i=this._period;if(j<0){j=0}if(j>f){j=f}if(j-g<0){g=j}if(j+g>f){g=f-j}var h=this.fromScreen(j)-this._earliestDate.getTime();if(h-e<0){e=h}if(h+e>i){e=i-h}this._centerX=j;this._centerTime=h;this._aperture=g;this._aperturePeriod=e;this._leftScreenMargin=this._centerX-this._aperture;this._rightScreenMargin=this._centerX+this._aperture;this._leftTimeMargin=this._centerTime-this._aperturePeriod;this._rightTimeMargin=this._centerTime+this._aperturePeriod;this._leftRate=(j-g)/(h-e);this._expandedRate=g/e;this._rightRate=(f-j-g)/(i-h-e);this._expandedTimeTranslation=this._centerX-this._centerTime*this._expandedRate;this._expandedScreenTranslation=this._centerTime-this._centerX/this._expandedRate;this._rightTimeTranslation=(j+g)-(h+e)*this._rightRate;this._rightScreenTranslation=(h+e)-(j+g)/this._rightRate;this._updateMappedValues()};Timeplot.MagnifyingTimeGeometry.prototype.actLinear=function(){this._mode="lin";this._map=this._linMap;this.reset()};Timeplot.MagnifyingTimeGeometry.prototype.actMagnifying=function(){this._mode="Magnifying";this._map=this._MagnifyingMap;this.reset()};Timeplot.MagnifyingTimeGeometry.prototype.toggle=function(){if(this._mode=="Magnifying"){this.actLinear()}else{this.actMagnifying()}};Timeplot.Color=function(a){this._fromHex(a)};Timeplot.Color.prototype={set:function(f,e,c,d){this.r=f;this.g=e;this.b=c;this.a=(d)?d:1;return this.check()},transparency:function(b){this.a=b;return this.check()},lighten:function(b){var a=new Timeplot.Color();return a.set(this.r+=parseInt(b,10),this.g+=parseInt(b,10),this.b+=parseInt(b,10))},darken:function(b){var a=new Timeplot.Color();return a.set(this.r-=parseInt(b,10),this.g-=parseInt(b,10),this.b-=parseInt(b,10))},check:function(){if(this.r>255){this.r=255}else{if(this.r<0){this.r=0}}if(this.g>255){this.g=255}else{if(this.g<0){this.g=0}}if(this.b>255){this.b=255}else{if(this.b<0){this.b=0}}if(this.a>1){this.a=255}else{if(this.a<0){this.a=0}}return this},toString:function(a){return"rgba("+this.r+","+this.g+","+this.b+","+((a)?a:"1.0")+")"},toHexString:function(){return"#"+this._toHex(this.r)+this._toHex(this.g)+this._toHex(this.b)},_fromHex:function(a){if(/^#?([\da-f]{3}|[\da-f]{6})$/i.test(a)){a=a.replace(/^#/,"").replace(/^([\da-f])([\da-f])([\da-f])$/i,"$1$1$2$2$3$3");this.r=parseInt(a.substr(0,2),16);this.g=parseInt(a.substr(2,2),16);this.b=parseInt(a.substr(4,2),16)}else{if(/^rgb *\( *\d{0,3} *, *\d{0,3} *, *\d{0,3} *\)$/i.test(a)){a=a.match(/^rgb *\( *(\d{0,3}) *, *(\d{0,3}) *, *(\d{0,3}) *\)$/i);this.r=parseInt(a[1],10);this.g=parseInt(a[2],10);this.b=parseInt(a[3],10)}}this.a=1;return this.check()},_toHex:function(d){var c="0123456789ABCDEF";if(d<0){return"00"}if(d>255){return"FF"}var b=Math.floor(d/16);var a=d%16;return c.charAt(b)+c.charAt(a)}};Timeplot.Math={range:function(g){var d=g.length;var c=Number.MAX_VALUE;var a=Number.MIN_VALUE;for(var b=0;b<d;b++){var e=g[b];if(e<c){c=e}if(e>a){a=e}}return{min:c,max:a}},movingAverage:function(i,c){var e=i.length;var d=new Array(e);for(var j=0;j<e;j++){var h=0;for(var a=j-c;a<j+c;a++){if(a<0){var b=i[0]}else{if(a>=e){var b=d[j-1]}else{var b=i[a]}}h+=b}d[j]=h/(2*c)}return d},integral:function(e){var d=e.length;var c=new Array(d);var b=0;for(var a=0;a<d;a++){b+=e[a];c[a]=b}return c},normalize:function(d){var c=d.length;var b=0;for(var a=0;a<c;a++){b+=d[a]}for(var a=0;a<c;a++){d[a]/=b}return d},convolution:function(k,j){var s=k.length;var q=j.length;var l=new Array(s);for(var h=0;h<s;h++){var d=0;var i=(h+q<s)?h+q:s;for(var e=h;e<i;e++){var p=k[e-q];var o=j[e-h];d+=p*o}l[h]=d}return l},heavyside:function(b){var d=new Array(b);var c=1/b;for(var a=0;a<b;a++){d[a]=c}return d},gaussian:function(size,threshold){with(Math){var radius=size/2;var variance=radius*radius/log(threshold);var g=new Array(size);for(var t=0;t<size;t++){var l=t-radius;g[t]=exp(-variance*l*l)}}return this.normalize(g)},round:function(x,n){with(Math){if(abs(x)>1){var l=floor(log(x)/log(10));var d=round(exp((l-n+1)*log(10)));var y=round(round(x/d)*d);return y}else{log("FIXME(SM): still to implement for 0 < abs(x) < 1");return x}}},tanh:function(a){if(a>5){return 1}else{if(a<5){return -1}else{var b=Math.exp(2*a);return(b-1)/(b+1)}}},isClose:function(d,c,e){return(d&&c&&Math.abs(d.x-c.x)<e&&Math.abs(d.y-c.y)<e)}};Timeplot.Operator={sum:function(a,b){return Timeplot.Math.integral(a.values)},average:function(c,d){var b=("size" in d)?d.size:30;var a=Timeplot.Math.movingAverage(c.values,b);return a}};Timeplot.Processor=function(d,a,c){this._dataSource=d;this._operator=a;this._params=c;this._data={times:new Array(),values:new Array()};this._range={earliestDate:null,latestDate:null,min:0,max:0};var b=this;this._processingListener={onAddMany:function(){b._process()},onClear:function(){b._clear()}};this.addListener(this._processingListener)};Timeplot.Processor.prototype={_clear:function(){this.removeListener(this._processingListener);this._dataSource._clear()},_process:function(){var d=this._dataSource.getData();var a=this._dataSource.getRange();var b=this._operator(d,this._params);var c=Timeplot.Math.range(b);this._data={times:d.times,values:b};this._range={earliestDate:a.earliestDate,latestDate:a.latestDate,min:c.min,max:c.max}},getRange:function(){return this._range},getData:function(){return this._data},getValue:Timeplot.DataSource.prototype.getValue,addListener:function(a){this._dataSource.addListener(a)},removeListener:function(a){this._dataSource.removeListener(a)}};