/* fckez.js

{{IS_NOTE
	Purpose:
		
	Description:
		
	History:
		Tue Dec 27 10:25:06     2005, Created by tomyeh
}}IS_NOTE

Copyright (C) 2005 Potix Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
zkFCKed = {};

function FCKeditor_OnComplete(fed) {
	fed.ResetIsDirty();
		//Bug 1876996: FCKeditor 2.5 and 2.5.1 doesn't reset it correctly

	fed.Events.AttachEvent("OnBlur", zkFCKed.onblur);
	fed.Events.AttachEvent("OnSave", zkFCKed.onsave);
	fed.Events.AttachEvent("OnSelectionChange", zkFCKed.onselect);
	if (window.FCKed_OnComplete)
		window.FCKed_OnComplete(fed);
}

/** Init */
zkFCKed.init = function (ed) {
	FCKeditorAPI = null;
		//Note: we have to clean up, because iframe (FCKeditor lives)
		//might be dropped and another instance might be created

	//Bug 1734809: we cannot switch iframe's src, since BACK will cause problem
	var instid = ed.id + '!ed';
	var html = '<input type="hidden" id="' + instid
		+ '" name="' + instid + '" value="';
	var s = getZKAttr(ed, 'val');
	if (s) html += zk.encodeXML(s);

	html += '"/><input type="hidden" id="' + instid + '___Config" value="';
	s = getZKAttr(ed, 'cfg');
	if (s) html += s;

	s = getZKAttr(ed, "tbar");
	s = '/web/js/ext/FCKeditor/editor/fckeditor.html?InstanceName='
		+ instid + (s ? '&amp;Toolbar=' + s: '');
	html += '"/>\n<iframe id="' + instid + '___Frame" src="'
		+ zk.getUpdateURI(s) +'"';
	s = getZKAttr(ed, "wd");
	if (s) html  += ' width="' + s + '"';
	s = getZKAttr(ed, "hgh");
	if (s) html  += ' height="' + s + '"';
	html += ' frameborder="0" scrolling="no">\n</iframe>';

	ed.innerHTML = html;

	//Bug 1510539: onblur is checked periodically by FCKeditor so it might be too late.
	var meta = zkau.getMeta(ed);
	if (meta) {
		zkau.removeOnSend(meta.onsend); //just in case
	} else {
		meta = {
			onsend: function (implicit) {
				//don't send back if implicit (such as onTimer)
				if (!implicit && FCKeditorAPI) {
					var fed = FCKeditorAPI.GetInstance(instid);
					if (fed && fed.EditorDocument) zkFCKed.onblur(fed, true);
						//It is possible that EditorDocument is not initialized yet
				}
			}
		};		
		zkau.setMeta(ed, meta);
	}
	zkau.addOnSend(meta.onsend);
};
zkFCKed.cleanup = function (ed) {
	var meta = zkau.getMeta(ed);
	if (meta) zkau.removeOnSend(meta.onsend);
};

/** Called by the server to set the attribute. */
zkFCKed.setAttr = function (ed, name, value) {
	var ifr = $e(ed.id + "!ed___Frame");
	var fed = FCKeditorAPI.GetInstance(ed.id + "!ed");
	if (ifr) {
		switch (name) {
		case "width":
			ifr.width = value;
			return true;
		case "height":
			ifr.height = value;
			return true;
		case "value":
			if (fed) fed.SetHTML(value);
			return true;
		}
	}
	return false;
};

/** Called by the server to remove the attribute. */
zkFCKed.rmAttr = function (ed, name) {
	var ifr = $e(ed.id + "!ed___Frame");
	var fed = FCKeditorAPI.GetInstance(ed.id + "!ed");
	if (ifr) {
		switch (name) {
		case "width":
			ifr.width = "";
			return true;
		case "height":
			ifr.height = "";
			return true;
		case "value":
			if (fed) fed.SetHTML("");
			return true;
		}
	}
	return false;
};
zkFCKed.onblur = function (fed, ahead) {
	if (fed.IsDirty()) {
		var uuid = $uuid(fed.Name);
		var comp = $e(uuid);
		var val = fed.GetXHTML();
		var evt = {uuid: uuid, cmd: "onChange", data: [val]};

		if (ahead) zkau.sendAhead(evt);
		else if (!zkFCKed._ahead(evt))
			zkau.send(evt, zkau.asapTimeout(comp, "onChange"));

		fed.ResetIsDirty();
	}
};
//Bug 1794296: we have to sendAhead if any onClick
zkFCKed._ahead = function (evt) {
	if (zkau.events) { //3.0 or later
		var es = zkau.events(evt.uuid);
		for (var j = es.length; --j >= 0;)
			if (es[j].ctl) {
				es.splice(j, 0, evt);
				return true;
			}
	}
	return false
};
zkFCKed.onSize = function (cmp) {
	cmp._hgh = null; //reset
} ;
zkFCKed.onselect = function (fed) {
	var uuid = $uuid(fed.Name),
		cmp = $e(uuid),
		inner = $e(uuid + "!ed___Frame"),
		selection = fed.EditorDocument.selection ? fed.EditorDocument.selection.createRange().text : fed.EditorWindow.getSelection().toString();
		
	// ignore wrong selection for IE
	if (zk.ie && cmp.zselection === String.fromCharCode(65279) || selection === String.fromCharCode(65279))
		return;
	fed.zselection = selection;
	if (zkau.asap(cmp, "onSelection")) {
		if (cmp.zselection || fed.zselection) {			
			if (cmp.zselection != fed.zselection) {
				cmp.zselection = fed.zselection;
				zkau.send({uuid: cmp.id, cmd: "onSelection",
						data: [0, 0, fed.zselection]},
				 	100);
			}
		}
	}
	if (getZKAttr(cmp, "autohgh") == "true") {
		var iframe = fed.EditingArea.IFrame, body = iframe.contentDocument ? iframe.contentDocument.body : iframe.contentWindow.document.body;
		if (!cmp._hgh) 
			cmp._hgh = inner.offsetHeight - iframe.offsetHeight;
		if (cmp._now && cmp._now > $now()) 
			return;
			
		cmp._now = $now() + 100;
		if (body.scrollHeight + cmp._hgh > inner.offsetHeight) {
			setTimeout(function() {
				if (body.scrollHeight + cmp._hgh > inner.offsetHeight) 
					inner.style.height = body.scrollHeight + cmp._hgh + "px";
				
			}, 100);
		} else {
			var hgh = $int(getZKAttr(cmp, "hgh")),
				offHgh = zk.ie ? body.scrollHeight : body.offsetHeight;
			
			setTimeout(function() {
				if (offHgh + cmp._hgh > hgh) 
					hgh = offHgh + cmp._hgh;
				if (inner.style.height != hgh + "px") {
					inner.style.height = hgh + "px";
				}
			}, 100);
		}
	}
};
zkFCKed.onsave = function (fed, ahead) {
	var uuid = $uuid(fed.Name);
	var comp = $e(uuid);
	var val = fed.GetXHTML();
	zkau.send({uuid: uuid, cmd: "onChange", data: [val]},
    zkau.asapTimeout(comp, "onChange"));
	zkau.send({uuid: uuid, cmd: "onSave", data: [val]},5);
};
