SELECT '001_add_brazilian_states.sql' AS Filename;
--Enable Brazil in country Table
UPDATE c_country SET hasregion = 'Y', regionname = 'Estado' WHERE c_country_id = 139;



--Add Brazilian States
INSERT INTO c_region VALUES (441, 0, 0, 'Y', '2007-04-30 16:40:42', 0, '2007-04-30 16:40:42', 0, 'AC', 'Acre', 139, 'N');
INSERT INTO c_region VALUES (442, 0, 0, 'Y', '2007-04-30 16:40:57', 0, '2007-04-30 16:40:57', 0, 'AL', 'Alagoas', 139, 'N');
INSERT INTO c_region VALUES (443, 0, 0, 'Y', '2007-04-30 16:41:06', 0, '2007-04-30 16:41:06', 0, 'AP', 'Amapá', 139, 'N');
INSERT INTO c_region VALUES (444, 0, 0, 'Y', '2007-04-30 16:41:19', 0, '2007-04-30 16:41:19', 0, 'AM', 'Amazonas', 139, 'N');
INSERT INTO c_region VALUES (445, 0, 0, 'Y', '2007-04-30 16:41:29', 0, '2007-04-30 16:41:29', 0, 'BA', 'Bahia', 139, 'N');
INSERT INTO c_region VALUES (446, 0, 0, 'Y', '2007-04-30 16:41:49', 0, '2007-04-30 16:41:49', 0, 'CE', 'Ceará°', 139, 'N');
INSERT INTO c_region VALUES (447, 0, 0, 'Y', '2007-04-30 16:42:04', 0, '2007-04-30 16:42:04', 0, 'DF', 'Distrito Federal', 139, 'N');
INSERT INTO c_region VALUES (448, 0, 0, 'Y', '2007-04-30 16:42:19', 0, '2007-04-30 16:42:19', 0, 'ES', 'Espírito Santo', 139, 'N');
INSERT INTO c_region VALUES (449, 0, 0, 'Y', '2007-04-30 16:42:34', 0, '2007-04-30 16:42:34', 0, 'GO', 'Goiás', 139, 'N');
INSERT INTO c_region VALUES (450, 0, 0, 'Y', '2007-04-30 16:42:40', 0, '2007-04-30 16:42:40', 0, 'MA', 'Maranhão', 139, 'N');
INSERT INTO c_region VALUES (451, 0, 0, 'Y', '2007-04-30 16:42:49', 0, '2007-04-30 16:42:49', 0, 'MT', 'Mato Grosso', 139, 'N');
INSERT INTO c_region VALUES (452, 0, 0, 'Y', '2007-04-30 16:43:00', 0, '2007-04-30 16:43:00', 0, 'MS', 'Mato Grosso do Sul', 139, 'N');
INSERT INTO c_region VALUES (453, 0, 0, 'Y', '2007-04-30 16:43:11', 0, '2007-04-30 16:43:11', 0, 'MG', 'Minas Gerais', 139, 'N');
INSERT INTO c_region VALUES (454, 0, 0, 'Y', '2007-04-30 16:43:21', 0, '2007-04-30 16:43:21', 0, 'PA', 'Pará', 139, 'N');
INSERT INTO c_region VALUES (455, 0, 0, 'Y', '2007-04-30 16:43:31', 0, '2007-04-30 16:43:31', 0, 'PB', 'Paraíba', 139, 'N');
INSERT INTO c_region VALUES (456, 0, 0, 'Y', '2007-04-30 16:43:40', 0, '2007-04-30 16:43:40', 0, 'PR', 'Paraná', 139, 'N');
INSERT INTO c_region VALUES (457, 0, 0, 'Y', '2007-04-30 16:43:53', 0, '2007-04-30 16:43:53', 0, 'PE', 'Pernambuco', 139, 'N');
INSERT INTO c_region VALUES (458, 0, 0, 'Y', '2007-04-30 16:44:03', 0, '2007-04-30 16:44:03', 0, 'PI', 'Piauí', 139, 'N');
INSERT INTO c_region VALUES (459, 0, 0, 'Y', '2007-04-30 16:44:30', 0, '2007-04-30 16:44:30', 0, 'RJ', 'Rio de Janeiro', 139, 'N');
INSERT INTO c_region VALUES (460, 0, 0, 'Y', '2007-04-30 16:44:43', 0, '2007-04-30 16:44:43', 0, 'RN', 'Rio Grande do Norte', 139, 'N');
INSERT INTO c_region VALUES (461, 0, 0, 'Y', '2007-04-30 16:44:59', 0, '2007-04-30 16:44:59', 0, 'RS', 'Rio Grande do Sul', 139, 'N');
INSERT INTO c_region VALUES (462, 0, 0, 'Y', '2007-04-30 16:45:07', 0, '2007-04-30 16:45:07', 0, 'RO', 'Rondônia', 139, 'N');
INSERT INTO c_region VALUES (463, 0, 0, 'Y', '2007-04-30 16:45:20', 0, '2007-04-30 16:45:20', 0, 'RR', 'Roraima', 139, 'N');
INSERT INTO c_region VALUES (464, 0, 0, 'Y', '2007-04-30 16:45:30', 0, '2007-04-30 16:45:30', 0, 'SC', 'Santa Catarina', 139, 'N');
INSERT INTO c_region VALUES (465, 0, 0, 'Y', '2007-04-30 16:45:40', 0, '2007-04-30 16:45:40', 0, 'SP', 'Sõo Paulo', 139, 'N');
INSERT INTO c_region VALUES (466, 0, 0, 'Y', '2007-04-30 16:45:53', 0, '2007-04-30 16:45:53', 0, 'SE', 'Sergipe', 139, 'N');
INSERT INTO c_region VALUES (467, 0, 0, 'Y', '2007-04-30 16:46:03', 0, '2007-04-30 16:46:03', 0, 'TO', 'Tocantins', 139, 'N');



UPDATE AD_SEQUENCE
   SET currentnextsys = (SELECT MAX (c_region_id) + 1
                           FROM C_REGION
                          WHERE c_region_id < 1000000)
 WHERE NAME = 'C_Region';



SELECT '002_add_feature_1714090.sql' AS Filename;
-- Feature Request
-- juddm - add the ability to specific a shipment date (instead of current date) to the shipment generation process
-- http://sourceforge.net/tracker/index.php?func=detail&aid=1714090&group_id=176962&atid=879335

INSERT INTO AD_PROCESS_PARA
            (ad_process_para_id, ad_client_id, ad_org_id, isactive, created,
             createdby, updated, updatedby,
             NAME, description,
             HELP,
             ad_process_id, seqno, ad_reference_id, ad_reference_value_id,
             ad_val_rule_id, columnname, iscentrallymaintained, fieldlength,
             ismandatory, isrange, ad_element_id, entitytype
            )
     VALUES (50019, 0, 0, 'Y', TO_TIMESTAMP ('2007-03-03', 'YYYY-MM-DD'),
             100, TO_TIMESTAMP ('2007-03-03', 'YYYY-MM-DD'), 100,
             'Shipment Date', 'Date printed on shipment',
             'The Shipment Date indicates the date printed on the shipment.',
             118, 15, 15, NULL,
             NULL, 'MovementDate', 'N', 0,
             'Y', 'N', 1037, 'D'
            );



UPDATE AD_SEQUENCE
   SET currentnextsys = (SELECT MAX (ad_process_para_id) + 1
                           FROM AD_PROCESS_PARA
                          WHERE ad_process_para_id < 1000000)
 WHERE NAME = 'AD_Process_Para';



SELECT '003_make_feature_1714090_optional.sql' AS Filename;
UPDATE AD_PROCESS_PARA
   SET defaultvalue = NULL,
       ismandatory = 'N',
       updated = TO_TIMESTAMP ('2007-05-07 20:55:59', 'YYYY-MM-DD HH24:MI:SS'),
       updatedby = 100
 WHERE ad_process_para_id = 50019;



SELECT '005_2pack_enhancements_message.sql' AS Filename;
ALTER TABLE AD_PACKAGE_EXP_DETAIL ADD ad_message_id NUMERIC(10,0);

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP, VERSION, entitytype, columnname,
             ad_table_id, ad_reference_id, fieldlength, iskey, isparent,
             ismandatory, isupdateable, isidentifier, seqno, istranslated,
             isencrypted, isselectioncolumn, ad_element_id, issyncdatabase,
             isalwaysupdateable
            )
     VALUES (50213, 0, 0, 'Y',
             TO_TIMESTAMP ('05/14/2007 19:48:41', 'MM/DD/YYYY HH24:MI:SS'),
             TO_TIMESTAMP ('05/14/2007 19:48:41', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Message', 'System Message',
             'Information and Error messages', 0, 'D', 'AD_Message_ID',
             50006, 19, 22, 'N', 'N',
             'N', 'Y', 'N', 0, 'N',
             'N', 'N', 1752, 'N',
             'N'
            );

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description, HELP,
             iscentrallymaintained, ad_tab_id, ad_column_id, isdisplayed,
             displaylogic, displaylength, isreadonly, seqno, issameline,
             isheading, isfieldonly, isencrypted, entitytype
            )
     VALUES (50183, 0, 0, 'Y',
             TO_TIMESTAMP ('05/14/2007 19:51:35', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_TIMESTAMP ('05/14/2007 19:52:28', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Message', 'System Message', 'Information and Error messages',
             'Y', 50006, 50213, 'Y',
             '@Type@=''MSG''', 22, 'N', 246, 'N',
             'N', 'N', 'N', 'D'
            );

INSERT INTO AD_REF_LIST
            (ad_ref_list_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             VALUE, NAME, ad_reference_id, entitytype
            )
     VALUES (50043, 0, 0, 'Y',
             TO_TIMESTAMP ('05/14/2007 19:54:20', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_TIMESTAMP ('05/14/2007 19:54:20', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'MSG', 'Message', 50004, 'D'
            );



UPDATE AD_SEQUENCE
   SET currentnextsys = (SELECT MAX (ad_column_id) + 1
                           FROM AD_COLUMN
                          WHERE ad_column_id < 1000000)
 WHERE NAME = 'AD_Column';

UPDATE AD_SEQUENCE
   SET currentnextsys = (SELECT MAX (ad_field_id) + 1
                           FROM AD_FIELD
                          WHERE ad_field_id < 1000000)
 WHERE NAME = 'AD_Field';

UPDATE AD_SEQUENCE
   SET currentnextsys = (SELECT MAX (ad_ref_list_id) + 1
                           FROM AD_REF_LIST
                          WHERE ad_ref_list_id < 1000000)
 WHERE NAME = 'AD_Ref_List';



SELECT '007_add_StoreArchiveOnFilesystem.sql' AS Filename;
INSERT INTO ad_element
            (ad_element_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             columnname, entitytype, NAME,
             printname
            )
     VALUES (50071, 0, 0, 'Y',
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'StoreArchiveOnFileSystem', 'D', 'Store Archive On File System',
             'Store Archive On File System'
            );


INSERT INTO ad_column
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description, VERSION,
             entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, seqno, istranslated, isencrypted,
             isselectioncolumn, ad_element_id, callout, issyncdatabase,
             isalwaysupdateable
            )
     VALUES (50214, 0, 0, 'Y',
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Store Archive On File System', 'Store Archive On File System', 1,
             'D', 'StoreArchiveOnFileSystem', 112, 20,
             1, 'N', 'N', 'Y', 'Y',
             'N', 0, 'N', 'N',
             'N', 50071, 'org.compiere.model.CalloutClient.storeArchiveOnFileSystem', 'N',
             'N'
            );

INSERT INTO ad_field
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description, iscentrallymaintained, seqno, ad_tab_id,
             ad_column_id, isdisplayed, displaylength, isreadonly,
             issameline, isheading, isfieldonly, isencrypted, entitytype
            )
     VALUES (50184, 0, 0, 'Y',
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Store Archive On File System', 'Store Archive On File System', 'Y', 250, 145,
             50214, 'Y', 1, 'N',
             'N', 'N', 'N', 'N', 'D'
            );
            
            
            
INSERT INTO ad_element
            (ad_element_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             columnname, entitytype, NAME,
             printname
            )
     VALUES (50072, 0, 0, 'Y',
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'WindowsArchivePath', 'D', 'Windows Archive Path',
             'Windows Archive Path'
            );


INSERT INTO ad_column
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description, 
             help, VERSION,
             entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, seqno, istranslated, isencrypted,
             isselectioncolumn, ad_element_id,  issyncdatabase,
             isalwaysupdateable
            )
     VALUES (50215, 0, 0, 'Y',
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Windows Archive Path', 'Windows Archive Path - If you change this value make sure to copy the archive entries to the new path!', 
             'Path of the adempiere archive entries in the file system. If you change this value make sure to copy the archive entries to the new path!', 1,
             'D', 'WindowsArchivePath', 112, 10,
             255, 'N', 'N', 'N', 'Y',
             'N', 0, 'N', 'N',
             'N', 50072, 'N',
             'N'
            );

INSERT INTO ad_field
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description, 
             help,
             iscentrallymaintained, seqno, ad_tab_id,
             ad_column_id, isdisplayed, displaylength, isreadonly,
             issameline, isheading, isfieldonly, isencrypted, entitytype, displaylogic
            )
     VALUES (50185, 0, 0, 'Y',
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Windows Archive Path', 'Windows Archive Path',
             'If you change this value make sure to copy the archive entries to the new path!',
             'Y', 260, 145,
             50215, 'Y', 1, 'N',
             'N', 'N', 'N', 'N', 'D','@StoreArchiveOnFileSystem@=''Y'''
            );
            
            
INSERT INTO ad_element
            (ad_element_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             columnname, entitytype, NAME,
             printname
            )
     VALUES (50073, 0, 0, 'Y',
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'UnixArchivePath', 'D', 'Unix Archive Path',
             'Unix Archive Path'
            );


INSERT INTO ad_column
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description, 
             help, VERSION,
             entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, seqno, istranslated, isencrypted,
             isselectioncolumn, ad_element_id,  issyncdatabase,
             isalwaysupdateable
            )
     VALUES (50216, 0, 0, 'Y',
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Unix Archive Path', 'Unix Archive Path - If you change this value make sure to copy the archive entries to the new path!', 
             'Path of the adempiere archive entries in the file system. If you change this value make sure to copy the archive entries to the new path!', 1,
             'D', 'UnixArchivePath', 112, 10,
             255, 'N', 'N', 'N', 'Y',
             'N', 0, 'N', 'N',
             'N', 50073, 'N',
             'N'
            );

INSERT INTO ad_field
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description, 
             help,
             iscentrallymaintained, seqno, ad_tab_id,
             ad_column_id, isdisplayed, displaylength, isreadonly,
             issameline, isheading, isfieldonly, isencrypted, entitytype, displaylogic
            )
     VALUES (50186, 0, 0, 'Y',
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Unix Archive Path', 'Unix Archive Path',
             'If you change this value make sure to copy the archive entries to the new path!',
             'Y', 270 ,145,
             50216, 'Y', 1, 'N',
             'Y', 'N', 'N', 'N', 'D','@StoreArchiveOnFileSystem@=''Y'''
            );            
            
INSERT INTO ad_message
	(ad_message_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             value, msgtext, msgtype
            )
     VALUES (50015, 0, 0, 'Y',
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'StoreArchiveWarning',
             'If you change the archive storage method, the old archive entries are no longer available to your client.','I'
            );   
            
INSERT INTO ad_message
	(ad_message_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             value, msgtext, msgtype
            )
     VALUES (50016, 0, 0, 'Y',
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'ArchivePathWarning','Make sure to copy the archive entries to the new path!','I'
            );     
            
INSERT INTO ad_message_trl
            (ad_message_id, ad_language, ad_client_id, ad_org_id, isactive,
             created, createdby, updated, updatedby, msgtext, msgtip,
             istranslated)
   SELECT m.ad_message_id, lang.ad_language, m.ad_client_id, m.ad_org_id, 'Y',
          m.created, m.createdby, m.updated, m.updatedby, m.msgtext, m.msgtip,
          'N'
     FROM ad_message m, ad_language lang
    WHERE m.ad_message_id in (50015, 50016)
      AND lang.issystemlanguage = 'Y'
      AND lang.isbaselanguage = 'N'
      AND NOT EXISTS (
             SELECT *
               FROM ad_message_trl m2
              WHERE m2.ad_message_id = m.ad_message_id
                AND m2.ad_language = lang.ad_language);

            

UPDATE ad_sequence
   SET currentnextsys = (SELECT MAX (ad_element_id) + 1
                           FROM ad_element
                          WHERE ad_element_id < 1000000)
 WHERE NAME = 'AD_Element';

UPDATE ad_sequence
   SET currentnextsys = (SELECT MAX (ad_column_id) + 1
                           FROM ad_column
                          WHERE ad_column_id < 1000000)
 WHERE NAME = 'AD_Column';

UPDATE ad_sequence
   SET currentnextsys = (SELECT MAX (ad_field_id) + 1
                           FROM ad_field
                          WHERE ad_field_id < 1000000)
 WHERE NAME = 'AD_Field';
 
 UPDATE ad_sequence
    SET currentnextsys = (SELECT MAX (ad_message_id) + 1
                            FROM ad_message
                           WHERE ad_message_id < 1000000)
 WHERE NAME = 'AD_Message';


ALTER TABLE ad_client ADD StoreArchiveOnFilesystem CHAR(1) DEFAULT 'N' NOT NULL;
ALTER TABLE ad_client ADD WindowsArchivePath VARCHAR(255);
ALTER TABLE ad_client ADD UnixArchivePath VARCHAR(255);



SELECT '008_2pack_enhancements_printformat.sql' AS Filename;
ALTER TABLE AD_PACKAGE_EXP_DETAIL ADD ad_printformat_id NUMERIC(10,0);

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP, VERSION, entitytype, columnname,
             ad_table_id, ad_reference_id, fieldlength, iskey, isparent,
             ismandatory, isupdateable, isidentifier, seqno, istranslated,
             isencrypted, isselectioncolumn, ad_element_id, issyncdatabase,
             isalwaysupdateable
            )
     VALUES (50217, 0, 0, 'Y',
             TO_TIMESTAMP ('05/25/2007 19:48:41', 'MM/DD/YYYY HH24:MI:SS'),
             TO_TIMESTAMP ('05/25/2007 19:48:41', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Print Format', 'Data Print Format',
             'The print format determines how data is rendered for print.', 0, 'D', 'AD_PrintFormat_ID',
             50006, 19, 22, 'N', 'N',
             'N', 'Y', 'N', 0, 'N',
             'N', 'N', 1790, 'N',
             'N'
            );

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description, HELP,
             iscentrallymaintained, ad_tab_id, ad_column_id, isdisplayed,
             displaylogic, displaylength, isreadonly, seqno, issameline,
             isheading, isfieldonly, isencrypted, entitytype
            )
     VALUES (50187, 0, 0, 'Y',
             TO_TIMESTAMP ('05/25/2007 19:51:35', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_TIMESTAMP ('05/25/2007 19:52:28', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'PrintFormat', 'Print Format', 'Print Format',
             'Y', 50006, 50217, 'Y',
             '@Type@=''PFT''', 22, 'N', 246, 'N',
             'N', 'N', 'N', 'D'
            );

INSERT INTO AD_REF_LIST
            (ad_ref_list_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             VALUE, NAME, ad_reference_id, entitytype
            )
     VALUES (50044, 0, 0, 'Y',
             TO_TIMESTAMP ('05/14/2007 19:54:20', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_TIMESTAMP ('05/14/2007 19:54:20', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'PFT', 'PrintFormat', 50004, 'D'
            );



UPDATE AD_SEQUENCE
   SET currentnextsys = (SELECT MAX (ad_column_id) + 1
                           FROM AD_COLUMN
                          WHERE ad_column_id < 1000000)
 WHERE NAME = 'AD_Column';

UPDATE AD_SEQUENCE
   SET currentnextsys = (SELECT MAX (ad_field_id) + 1
                           FROM AD_FIELD
                          WHERE ad_field_id < 1000000)
 WHERE NAME = 'AD_Field';

UPDATE AD_SEQUENCE
   SET currentnextsys = (SELECT MAX (ad_ref_list_id) + 1
                           FROM AD_REF_LIST
                          WHERE ad_ref_list_id < 1000000)
 WHERE NAME = 'AD_Ref_List';



SELECT '009_add_MandatoryLogic.sql' AS Filename;
INSERT INTO ad_element
            (ad_element_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             columnname, entitytype, NAME,
             printname
            )
     VALUES (50074, 0, 0, 'Y',
             TO_TIMESTAMP ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_TIMESTAMP ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'MandatoryLogic', 'D', 'Mandatory Logic',
             'Mandatory Logic'
            );


INSERT INTO ad_column
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description, 
             help, VERSION,
             entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, seqno, istranslated, isencrypted,
             isselectioncolumn, ad_element_id,  issyncdatabase,
             isalwaysupdateable
            )
     VALUES (50218, 0, 0, 'Y',
             TO_TIMESTAMP ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'),
             TO_TIMESTAMP ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Mandatory Logic', 'Logic to determine if field is mandatory (applies only when field is not mandatory in general)', 
             'Logic to determine if field is mandatory (applies only when field is not mandatory in general). 
             format := {expression} [{logic} {expression}]<br> 
	expression := @{context}@{operand}{value} or @{context}@{operand}{value}<br> 
	logic := {|}|{&}<br>
	context := any global or window context <br>
	value := strings or numbers<br>
	logic operators	:= AND or OR with the previous result from left to right <br>
	operand := eq{=}, gt{&gt;}, le{&lt;}, not{~^!} <br>
	Examples: <br>
	@AD_Table_ID@=14 | @Language@!GERGER <br>
	@PriceLimit@>10 | @PriceList@>@PriceActual@<br>
	@Name@>J<br>
	Strings may be in single quotes (optional)', 1,
             'D', 'MandatoryLogic', 101, 14,
             2000, 'N', 'N', 'N', 'Y',
             'N', 0, 'N', 'N',
             'N', 50074, 'N',
             'N'
            );

INSERT INTO ad_field
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description, 
             help,
             iscentrallymaintained, seqno, ad_tab_id,
             ad_column_id, isdisplayed, displaylength, isreadonly,
             issameline, isheading, isfieldonly, isencrypted, entitytype
            )
     VALUES (50188, 0, 0, 'Y',
             TO_TIMESTAMP ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_TIMESTAMP ('02/26/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Mandatory Logic', 'Logic to determine if field is mandatory (applies only when field is not mandatory in general)', 
             'Logic to determine if field is mandatory (applies only when field is not mandatory in general). 
             format := {expression} [{logic} {expression}]<br> 
	expression := @{context}@{operand}{value} or @{context}@{operand}{value}<br> 
	logic := {|}|{&}<br>
	context := any global or window context <br>
	value := strings or numbers<br>
	logic operators	:= AND or OR with the previous result from left to right <br>
	operand := eq{=}, gt{&gt;}, le{&lt;}, not{~^!} <br>
	Examples: <br>
	@AD_Table_ID@=14 | @Language@!GERGER <br>
	@PriceLimit@>10 | @PriceList@>@PriceActual@<br>
	@Name@>J<br>
	Strings may be in single quotes (optional)',
             'Y', 275 ,101,
             50218, 'Y', 60, 'N',
             'N', 'N', 'N', 'N', 'D'
            );            
            
         

UPDATE ad_sequence
   SET currentnextsys = (SELECT MAX (ad_element_id) + 1
                           FROM ad_element
                          WHERE ad_element_id < 1000000)
 WHERE NAME = 'AD_Element';

UPDATE ad_sequence
   SET currentnextsys = (SELECT MAX (ad_column_id) + 1
                           FROM ad_column
                          WHERE ad_column_id < 1000000)
 WHERE NAME = 'AD_Column';

UPDATE ad_sequence
   SET currentnextsys = (SELECT MAX (ad_field_id) + 1
                           FROM ad_field
                          WHERE ad_field_id < 1000000)
 WHERE NAME = 'AD_Field';
 


ALTER TABLE ad_column ADD MandatoryLogic character varying(2000);



DROP VIEW IF EXISTS AD_FIELD_V;
  CREATE OR REPLACE VIEW AD_FIELD_V  AS 
  SELECT t.AD_Window_ID, f.AD_Tab_ID, f.AD_Field_ID, tbl.AD_Table_ID, f.AD_Column_ID, 
	f.Name, f.Description, f.Help, f.IsDisplayed, f.DisplayLogic, f.DisplayLength, 
	f.SeqNo, f.SortNo, f.IsSameLine, f.IsHeading, f.IsFieldOnly, f.IsReadOnly, 
	f.IsEncrypted AS IsEncryptedField, f.ObscureType,
	c.ColumnName, c.ColumnSQL, c.FieldLength, c.VFormat, c.DefaultValue, c.IsKey, c.IsParent, 
	COALESCE(f.IsMandatory, c.IsMandatory) AS IsMandatory, 
    c.IsIdentifier, c.IsTranslated, c.AD_Reference_Value_ID, 
	c.Callout, COALESCE(f.AD_Reference_ID, c.AD_Reference_ID) AS AD_Reference_ID, 
    c.AD_Val_Rule_ID, c.AD_Process_ID, c.IsAlwaysUpdateable,
	c.ReadOnlyLogic, c.MandatoryLogic, c.IsUpdateable, c.IsEncrypted AS IsEncryptedColumn, 
    c.IsSelectionColumn,
	tbl.TableName, c.ValueMin, c.ValueMax, 
	fg.Name AS FieldGroup, vr.Code AS ValidationCode
FROM AD_Field f 
  INNER JOIN AD_Tab t ON (f.AD_Tab_ID = t.AD_Tab_ID)
  LEFT OUTER JOIN AD_FieldGroup fg ON (f.AD_FieldGroup_ID = fg.AD_FieldGroup_ID) 
  LEFT OUTER JOIN AD_Column c ON (f.AD_Column_ID = c.AD_Column_ID)
	INNER JOIN AD_Table tbl ON (c.AD_Table_ID = tbl.AD_Table_ID)
	INNER JOIN AD_Reference r ON (c.AD_Reference_ID = r.AD_Reference_ID)
	LEFT OUTER JOIN AD_Val_Rule vr ON (c.AD_Val_Rule_ID=vr.AD_Val_Rule_ID)
WHERE f.IsActive = 'Y' 
  AND c.IsActive = 'Y';
  
     DROP VIEW IF EXISTS AD_FIELD_VT;
     CREATE OR REPLACE VIEW AD_FIELD_VT  AS 
     SELECT trl.AD_Language, t.AD_Window_ID, f.AD_Tab_ID, f.AD_Field_ID, tbl.AD_Table_ID, f.AD_Column_ID, 
   	trl.Name, trl.Description, trl.Help, f.IsDisplayed, f.DisplayLogic, f.DisplayLength, 
   	f.SeqNo, f.SortNo, f.IsSameLine, f.IsHeading, f.IsFieldOnly, f.IsReadOnly, 
   	f.IsEncrypted AS IsEncryptedField, f.ObscureType,
   	c.ColumnName, c.ColumnSQL, c.FieldLength, c.VFormat, c.DefaultValue, c.IsKey, c.IsParent, 
   	COALESCE(f.IsMandatory, c.IsMandatory) AS IsMandatory, 
       c.IsIdentifier, c.IsTranslated, c.AD_Reference_Value_ID, 
   	c.Callout, COALESCE(f.AD_Reference_ID, c.AD_Reference_ID) AS AD_Reference_ID, 
       c.AD_Val_Rule_ID, c.AD_Process_ID, c.IsAlwaysUpdateable,
   	c.ReadOnlyLogic, c.MandatoryLogic, c.IsUpdateable, c.IsEncrypted AS IsEncryptedColumn, c.IsSelectionColumn,
   	tbl.TableName, c.ValueMin, c.ValueMax, 
   	fgt.Name AS FieldGroup, vr.Code AS ValidationCode
   FROM AD_Field f 
   	INNER JOIN AD_Field_Trl trl ON (f.AD_Field_ID = trl.AD_Field_ID)
     INNER JOIN AD_Tab t ON (f.AD_Tab_ID = t.AD_Tab_ID)
     LEFT OUTER JOIN AD_FieldGroup_Trl fgt ON 
   	(f.AD_FieldGroup_ID = fgt.AD_FieldGroup_ID AND trl.AD_Language=fgt.AD_Language)
     LEFT OUTER JOIN AD_Column c ON (f.AD_Column_ID = c.AD_Column_ID)
   	INNER JOIN AD_Table tbl ON (c.AD_Table_ID = tbl.AD_Table_ID)
   	INNER JOIN AD_Reference r ON (c.AD_Reference_ID = r.AD_Reference_ID)
   	LEFT OUTER JOIN AD_Val_Rule vr ON (c.AD_Val_Rule_ID=vr.AD_Val_Rule_ID)
   WHERE f.IsActive = 'Y' 
   AND c.IsActive = 'Y';
  



SELECT '010_add_printpreview_button.sql' AS Filename;
INSERT INTO ad_message
	(ad_message_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             value, msgtext, msgtype
            )
     VALUES (50017, 0, 0, 'Y',
             TO_TIMESTAMP ('06/12/2007 18:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_TIMESTAMP ('06/12/2007 18:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'PrintPreview','Print preview','I'
            );     

            
 
 UPDATE ad_sequence
    SET currentnextsys = (SELECT MAX (ad_message_id) + 1
                            FROM ad_message
                           WHERE ad_message_id < 1000000)
 WHERE NAME = 'AD_Message';



SELECT '013_fix_istranslated.sql' AS Filename;
UPDATE AD_COLUMN
   SET istranslated = 'N'
 WHERE ad_column_id = 7604;
 
UPDATE AD_COLUMN
   SET istranslated = 'Y'
 WHERE ad_column_id = 6256;
 
 

SELECT '014_postcode_lookup.sql' AS Filename;
---
-- Feature 1741222 - Add Post code lookup infrastructure
-- http://sourceforge.net/tracker/index.php?func=detail&aid=1741222&group_id=176962&atid=879335
--

--- Modify C_COUNTRY Table
ALTER TABLE C_COUNTRY ADD 
   IsPostcodeLookup CHAR(1)  DEFAULT 'N' NOT NULL;
ALTER TABLE C_COUNTRY ADD 
   LookupClassname VARCHAR(255)  DEFAULT NULL  NULL;
ALTER TABLE C_COUNTRY ADD 
   LookupClientID VARCHAR(50)  DEFAULT NULL  NULL;
ALTER TABLE C_COUNTRY ADD 
   LookupPassword VARCHAR(50)  DEFAULT NULL  NULL;
ALTER TABLE C_COUNTRY ADD 
   LookupUrl VARCHAR(100) DEFAULT NULL  NULL;

-- Add Postcode Constraint
ALTER TABLE C_COUNTRY ADD CHECK (IsPostcodeLookup IN ('Y','N'));

-- Insert Element Definitions

INSERT INTO ad_element VALUES (51000, 0, 0, 'Y', '2007-06-19 22:43:07', 100, '2007-06-19 23:09:22', 100, 'IsPostcodeLookup', 'D', 'IsPostcodeLookup', 'IsPostcodeLookup', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO ad_element VALUES (51001, 0, 0, 'Y', '2007-06-19 22:43:07', 100, '2007-06-19 23:09:54', 100, 'LookupClassName', 'D', 'LookupClassName', 'LookupClassName', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO ad_element VALUES (51002, 0, 0, 'Y', '2007-06-19 22:43:07', 100, '2007-06-19 23:10:06', 100, 'LookupClientID', 'D', 'LookupClientID', 'LookupClientID', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO ad_element VALUES (51003, 0, 0, 'Y', '2007-06-19 22:43:07', 100, '2007-06-19 23:10:19', 100, 'LookupUrl', 'D', 'LookupUrl', 'LookupUrl', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO ad_element VALUES (51004, 0, 0, 'Y', '2007-06-22 02:03:37', 100, '2007-06-22 02:04:31', 100, 'LookupPassword', 'D', 'LookupPassword', 'LookupPassword', NULL, NULL, NULL, NULL, NULL, NULL);

-- Insert Column Definitions
INSERT INTO ad_column VALUES (51000, 0, 0, 'Y', '2007-06-19 22:43:07', '2007-06-19 23:14:47', 100, 100, 'IsPostcodeLookup', NULL, NULL, 0, 'D', 'IsPostcodeLookup', 170, 20, NULL, NULL, 1, 'N', 'N', 'N', 'N', 'Y', NULL, 'N', NULL, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 51000, NULL, 'N', 'N', NULL, NULL);
INSERT INTO ad_column VALUES (51001, 0, 0, 'Y', '2007-06-19 22:43:07', '2007-06-19 23:04:48', 100, 100, 'LookupClassName', NULL, NULL, 0, 'D', 'LookupClassName', 170, 10, NULL, NULL, 255, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', NULL, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 51001, NULL, 'N', 'N', NULL, NULL);
INSERT INTO ad_column VALUES (51002, 0, 0, 'Y', '2007-06-19 22:43:07', '2007-06-19 23:04:48', 100, 100, 'LookupClientID', NULL, NULL, 0, 'D', 'LookupClientID', 170, 10, NULL, NULL, 50, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', NULL, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 51002, NULL, 'N', 'N', NULL, NULL);
INSERT INTO ad_column VALUES (51003, 0, 0, 'Y', '2007-06-19 22:43:07', '2007-06-19 23:04:48', 100, 100, 'LookupUrl', NULL, NULL, 0, 'D', 'LookupUrl', 170, 10, NULL, NULL, 100, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', NULL, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 51003, NULL, 'N', 'N', NULL, NULL);
INSERT INTO ad_column VALUES (51004, 0, 0, 'Y', '2007-06-22 02:03:37', '2007-06-22 02:05:17', 100, 100, 'LookupPassword', NULL, NULL, 0, 'D', 'LookupPassword', 170, 10, NULL, NULL, 50, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', NULL, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 51004, NULL, 'N', 'N', NULL, NULL);

-- Insert Field Definitions
INSERT INTO ad_field VALUES (51000, 0, 0, 'Y', '2007-06-19 23:17:05', 100, '2007-06-19 23:17:05', 100, 'IsPostcodeLookup', NULL, NULL, 'Y', 135, 51000, NULL, 'Y', NULL, 1, 'N', 220, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO ad_field VALUES (51001, 0, 0, 'Y', '2007-06-19 23:17:06', 100, '2007-06-20 09:10:31', 100, 'LookupClassName', NULL, NULL, 'Y', 135, 51001, NULL, 'Y', '@IsPostcodeLookup@ = ''Y''', 255, 'N', 260, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO ad_field VALUES (51002, 0, 0, 'Y', '2007-06-19 23:17:06', 100, '2007-06-20 09:10:17', 100, 'LookupClientID', NULL, NULL, 'Y', 135, 51002, NULL, 'Y', '@IsPostcodeLookup@ = ''Y''', 50, 'N', 240, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO ad_field VALUES (51003, 0, 0, 'Y', '2007-06-19 23:17:06', 100, '2007-06-20 09:10:12', 100, 'LookupUrl', NULL, NULL, 'Y', 135, 51003, NULL, 'Y', '@IsPostcodeLookup@ = ''Y''', 100, 'N', 230, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO ad_field VALUES (51004, 0, 0, 'Y', '2007-06-19 23:17:06', 100, '2007-06-22 02:07:11', 100, 'LookupPassword', NULL, NULL, 'Y', 135, 51004, NULL, 'Y', '@IsPostcodeLookup@ = ''Y''', 50, 'N', 250, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);

-- Update Sequences
UPDATE ad_sequence
   SET currentnextsys = (SELECT MAX (ad_element_id) + 1
                           FROM ad_element
                          WHERE ad_element_id < 1000000)
 WHERE NAME = 'AD_Element';

UPDATE ad_sequence
   SET currentnextsys = (SELECT MAX (ad_column_id) + 1
                           FROM ad_column
                          WHERE ad_column_id < 1000000)
 WHERE NAME = 'AD_Column';

UPDATE ad_sequence
   SET currentnextsys = (SELECT MAX (ad_field_id) + 1
                           FROM ad_field
                          WHERE ad_field_id < 1000000)
 WHERE NAME = 'AD_Field';
 

SELECT '015_postcode_lookup2.sql' AS Filename;

---
-- FEATURE: 1741222 - Add Post code lookup infrastructure
-- http://sourceforge.net/tracker/index.php?func=detail&aid=1741222&group_id=176962&atid=879335
-- Update additional fields per Carlos request

-- Update Element Definitions
UPDATE ad_element SET description = 'Does this country have a post code web service', help = 'Enable the IsPostcodeLookup if you wish to configure a post code lookup web service' WHERE ad_element_id = 51000;
UPDATE ad_element SET description = 'The class name of the postcode lookup plugin', help = 'Enter the class name of the post code lookup plugin for your postcode web service provider' WHERE ad_element_id = 51001;
UPDATE ad_element SET description = 'The ClientID or Login submitted to the Lookup URL', help ='Enter the ClientID or Login for your account provided by the post code web service provider' WHERE ad_element_id = 51002;
UPDATE ad_element SET description = 'The password submitted to the Lookup URL', help = 'Enter the password for your account provided by the post code web service provider' WHERE ad_element_id = 51004;
UPDATE ad_element SET description = 'The URL of the web service that the plugin connects to in order to retrieve postcode data', help = 'Enter the URL of the web service that the plugin connects to in order to retrieve postcode data' WHERE ad_element_id = 51003;

-- Update Column Definitions
UPDATE ad_column SET description = 'Does this country have a post code web service', help = 'Enable the IsPostcodeLookup if you wish to configure a post code lookup web service' WHERE ad_column_id = 51000;
UPDATE ad_column SET description = 'The class name of the postcode lookup plugin', help = 'Enter the class name of the post code lookup plugin for your postcode web service provider' WHERE ad_column_id = 51001;
UPDATE ad_column SET description = 'The ClientID or Login submitted to the Lookup URL', help = 'Enter the ClientID or Login for your account provided by the post code web service provider' WHERE ad_column_id = 51002; 
UPDATE ad_column SET description = 'The password submitted to the Lookup URL', help = 'Enter the password for your account provided by the post code web service provider' WHERE ad_column_id = 51004;
UPDATE ad_column SET description = 'The URL of the web service that the plugin connects to in order to retrieve postcode data', help = 'Enter the URL of the web service that the plugin connects to in order to retrieve postcode data' WHERE ad_column_id = 51003;  

-- Update Field Definitions
UPDATE ad_field SET seqno = 225 WHERE ad_field_id = 51000;



SELECT '016_new_dashboard.sql' AS Filename;
-- create new table

CREATE TABLE PA_DASHBOARDCONTENT
(
  pa_dashboardcontent_id  NUMERIC(10)            NOT NULL,
  ad_client_id            NUMERIC(10)            NOT NULL,
  ad_org_id               NUMERIC(10)            NOT NULL,
  created                 TIMESTAMP                  NOT NULL,
  createdby               NUMERIC(10)            NOT NULL,
  updated                 TIMESTAMP                  NOT NULL,
  updatedby               NUMERIC(10)            NOT NULL,
  isactive                CHAR(1)          NOT NULL,
  NAME                    VARCHAR(120)        NOT NULL,
  ad_window_id            NUMERIC(10),
  description             VARCHAR(255),
  html                    TEXT,
  line                    NUMERIC,
  pa_goal_id              NUMERIC(10),
  CHECK (isactive IN ('Y','N')),
  CONSTRAINT pa_dashboardcontent_key
 PRIMARY KEY
 (pa_dashboardcontent_id)
);

-- dictionary additions

-- new table

INSERT INTO AD_TABLE
            (ad_table_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, tablename, isview, accesslevel, entitytype,
             issecurityenabled, isdeleteable, ishighvolume, importtable,
             ischangelog, replicationtype
            )
     VALUES (50010, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:22:49', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:22:49', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Dashboard Content', 'PA_DashboardContent', 'N', '1', 'D',
             'N', 'Y', 'N', 'N',
             'N', 'L'
            );

-- new sequence

INSERT INTO AD_SEQUENCE
            (ad_sequence_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description, isautosequence, incrementno,
             startno, currentnext, currentnextsys, isaudited, istableid,
             startnewyear
            )
     VALUES (50015, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:22:49', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:22:49', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'PA_DashboardContent', 'Table PA_DashboardContent', 'Y', 1,
             1000000, 1000000, 50000, 'N', 'Y',
             'N'
            );

-- new elements

INSERT INTO AD_ELEMENT
            (ad_element_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             columnname, entitytype, NAME, printname
            )
     VALUES (51005, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:01', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:01', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'HTML', 'D', 'HTML', 'HTML'
            );

INSERT INTO AD_ELEMENT
            (ad_element_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             columnname, entitytype, NAME,
             printname
            )
     VALUES (51006, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:07', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:07', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'PA_DashboardContent_ID', 'D', 'PA_DashboardContent_ID',
             'PA_DashboardContent_ID'
            );

-- new columns

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP,
             VERSION, entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, seqno, istranslated, isencrypted,
             isselectioncolumn, ad_element_id, issyncdatabase,
             isalwaysupdateable
            )
     VALUES (51005, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:22:51', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/09/2007 14:22:51', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Name', 'Alphanumeric identifier of the entity',
             'The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.',
             0, 'D', 'Name', 50010, 10,
             120, 'N', 'N', 'Y', 'Y',
             'Y', 1, 'N', 'N',
             'N', 469, 'Y',
             'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP,
             VERSION, entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, istranslated, isencrypted, isselectioncolumn,
             ad_element_id, issyncdatabase, isalwaysupdateable
            )
     VALUES (51006, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:22:53', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/09/2007 14:22:53', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Organization', 'Organizational entity within client',
             'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.',
             0, 'D', 'AD_Org_ID', 50010, 19,
             10, 'N', 'N', 'Y', 'N',
             'N', 'N', 'N', 'N',
             113, 'Y', 'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP, VERSION,
             entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, istranslated, isencrypted, isselectioncolumn,
             ad_element_id, issyncdatabase, isalwaysupdateable
            )
     VALUES (51007, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:22:54', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/09/2007 14:22:54', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Window', 'Data entry or display window',
             'The Window field identifies a unique Window in the system.', 0,
             'D', 'AD_Window_ID', 50010, 19,
             22, 'N', 'N', 'N', 'Y',
             'N', 'N', 'N', 'N',
             143, 'Y', 'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP,
             VERSION, entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, istranslated, isencrypted, isselectioncolumn,
             ad_element_id, issyncdatabase, isalwaysupdateable
            )
     VALUES (51008, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:22:55', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/09/2007 14:22:55', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Created', 'Date this record was created',
             'The Created field indicates the date that this record was created.',
             0, 'D', 'Created', 50010, 16,
             7, 'N', 'N', 'Y', 'N',
             'N', 'N', 'N', 'N',
             245, 'Y', 'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP,
             VERSION, entitytype, columnname, ad_table_id, ad_reference_id,
             ad_reference_value_id, fieldlength, iskey, isparent,
             ismandatory, isupdateable, isidentifier, istranslated,
             isencrypted, isselectioncolumn, ad_element_id, issyncdatabase,
             isalwaysupdateable
            )
     VALUES (51009, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:22:57', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/09/2007 14:22:57', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Created By', 'User who created this records',
             'The Created By field indicates the user who created this record.',
             0, 'D', 'CreatedBy', 50010, 18,
             110, 10, 'N', 'N',
             'Y', 'N', 'N', 'N',
             'N', 'N', 246, 'Y',
             'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP, VERSION, entitytype,
             columnname, ad_table_id, ad_reference_id, fieldlength, iskey,
             isparent, ismandatory, isupdateable, isidentifier, istranslated,
             isencrypted, isselectioncolumn, ad_element_id, issyncdatabase,
             isalwaysupdateable
            )
     VALUES (51010, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:22:59', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/09/2007 14:22:59', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Description', 'Optional short description of the record',
             'A description is limited to 255 characters.', 0, 'D',
             'Description', 50010, 10, 255, 'N',
             'N', 'N', 'Y', 'N', 'N',
             'N', 'N', 275, 'Y',
             'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP,
             VERSION, entitytype, columnname, ad_table_id, ad_reference_id,
             ad_reference_value_id, fieldlength, iskey, isparent,
             ismandatory, isupdateable, isidentifier, istranslated,
             isencrypted, isselectioncolumn, ad_element_id, issyncdatabase,
             isalwaysupdateable
            )
     VALUES (51011, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:00', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/09/2007 14:23:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Updated By', 'User who updated this records',
             'The Updated By field indicates the user who updated this record.',
             0, 'D', 'UpdatedBy', 50010, 18,
             110, 10, 'N', 'N',
             'Y', 'N', 'N', 'N',
             'N', 'N', 608, 'Y',
             'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, VERSION, entitytype, columnname, ad_table_id,
             ad_reference_id, iskey, isparent, ismandatory, isupdateable,
             isidentifier, istranslated, isencrypted, isselectioncolumn,
             ad_element_id, issyncdatabase, isalwaysupdateable
            )
     VALUES (51012, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:01', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/09/2007 14:23:01', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'HTML', 0, 'D', 'HTML', 50010,
             36, 'N', 'N', 'N', 'Y',
             'N', 'N', 'N', 'N',
             51005, 'Y', 'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP,
             VERSION, entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, istranslated, isencrypted, isselectioncolumn,
             ad_element_id, issyncdatabase, isalwaysupdateable
            )
     VALUES (51013, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:03', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/09/2007 14:23:03', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Active', 'The record is active in the system',
             'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.',
             0, 'D', 'IsActive', 50010, 20,
             1, 'N', 'N', 'Y', 'Y',
             'N', 'N', 'N', 'N',
             348, 'Y', 'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP,
             VERSION, entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, istranslated, isencrypted, isselectioncolumn,
             ad_element_id, issyncdatabase, isalwaysupdateable
            )
     VALUES (51014, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:04', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/09/2007 14:23:04', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Line No', 'Unique line for this document',
             'Indicates the unique line for a document.  It will also control the display order of the lines within a document.',
             0, 'D', 'Line', 50010, 22,
             22, 'N', 'N', 'N', 'Y',
             'N', 'N', 'N', 'N',
             439, 'Y', 'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP,
             VERSION, entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, istranslated, isencrypted, isselectioncolumn,
             ad_element_id, issyncdatabase, isalwaysupdateable
            )
     VALUES (51015, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:05', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/09/2007 14:23:05', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Goal', 'Performance Goal',
             'The Performance Goal indicates what this users performance will be measured against.',
             0, 'D', 'PA_Goal_ID', 50010, 19,
             22, 'N', 'N', 'N', 'Y',
             'N', 'N', 'N', 'N',
             1594, 'Y', 'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP,
             VERSION, entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, istranslated, isencrypted, isselectioncolumn,
             ad_element_id, issyncdatabase, isalwaysupdateable
            )
     VALUES (51016, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:06', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/09/2007 14:23:06', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Updated', 'Date this record was updated',
             'The Updated field indicates the date that this record was updated.',
             0, 'D', 'Updated', 50010, 16,
             7, 'N', 'N', 'Y', 'N',
             'N', 'N', 'N', 'N',
             607, 'Y', 'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP,
             VERSION, entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, istranslated, isencrypted, isselectioncolumn,
             ad_element_id, issyncdatabase, isalwaysupdateable
            )
     VALUES (51017, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:07', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/09/2007 14:23:07', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Client', 'Client/Tenant for this installation.',
             'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.',
             0, 'D', 'AD_Client_ID', 50010, 19,
             10, 'N', 'N', 'Y', 'N',
             'N', 'N', 'N', 'N',
             102, 'Y', 'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, VERSION, entitytype, columnname,
             ad_table_id, ad_reference_id, fieldlength, iskey, isparent,
             ismandatory, isupdateable, isidentifier, istranslated,
             isencrypted, isselectioncolumn, ad_element_id, issyncdatabase,
             isalwaysupdateable
            )
     VALUES (51018, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:07', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/09/2007 14:23:07', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'PA_DashboardContent_ID', 0, 'D', 'PA_DashboardContent_ID',
             50010, 13, 10, 'Y', 'N',
             'Y', 'N', 'N', 'N',
             'N', 'N', 51006, 'Y',
             'N'
            );

-- new window			

INSERT INTO AD_WINDOW
            (ad_window_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, windowtype, issotrx, entitytype, processing, isdefault,
             isbetafunctionality
            )
     VALUES (50007, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:08', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:12', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Dashboard Content Edit', 'M', 'Y', 'D', 'N', 'N',
             'N'
            );

-- new menu

INSERT INTO AD_MENU
            (ad_menu_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated,
             NAME, updatedby, issummary, issotrx, isreadonly, action,
             ad_window_id, entitytype
            )
     VALUES (50010, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:30', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:30', 'MM/DD/YYYY HH24:MI:SS'),
             'Dashboard Content Edit', 100, 'N', 'N', 'N', 'W',
             50007, 'D'
            );

-- new menu in tree

INSERT INTO AD_TREENODEMM
            (ad_tree_id, node_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             parent_id, seqno
            )
     VALUES (10, 50010, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:35', 'MM/DD/YYYY HH24:MI:SS'), 0,
             TO_DATE ('07/09/2007 14:23:35', 'MM/DD/YYYY HH24:MI:SS'), 0,
             175, 0
            );

-- access to new window

INSERT INTO AD_WINDOW_ACCESS
            (ad_window_id, ad_role_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             isreadwrite
            )
     VALUES (50007, 0, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:08', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:08', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Y'
            );

INSERT INTO AD_WINDOW_ACCESS
            (ad_window_id, ad_role_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             isreadwrite
            )
     VALUES (50007, 102, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:08', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:08', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Y'
            );

INSERT INTO AD_WINDOW_ACCESS
            (ad_window_id, ad_role_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             isreadwrite
            )
     VALUES (50007, 103, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:08', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:08', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Y'
            );

INSERT INTO AD_WINDOW_ACCESS
            (ad_window_id, ad_role_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             isreadwrite
            )
     VALUES (50007, 50001, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:08', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:08', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Y'
            );

-- new tab

INSERT INTO AD_TAB
            (ad_tab_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, ad_table_id, ad_window_id, seqno, tablevel, issinglerow,
             isinfotab, istranslationtab, isreadonly, hastree, processing,
             issorttab, entitytype, isinsertrecord, isadvancedtab
            )
     VALUES (50010, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:08', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:15', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Edit', 50010, 50007, 10, 0, 'Y',
             'N', 'N', 'N', 'N', 'N',
             'N', 'D', 'Y', 'N'
            );

-- new fields

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description,
             HELP,
             iscentrallymaintained, ad_tab_id, ad_column_id, isdisplayed,
             displaylength, isreadonly, seqno, sortno, issameline, isheading,
             isfieldonly, isencrypted, entitytype
            )
     VALUES (51005, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:09', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:17', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Client', 'Client/Tenant for this installation.',
             'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.',
             'Y', 50010, 51017, 'Y',
             10, 'N', 10, 0, 'N', 'N',
             'N', 'N', 'D'
            );

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description,
             HELP,
             iscentrallymaintained, ad_tab_id, ad_column_id, isdisplayed,
             displaylength, isreadonly, seqno, sortno, issameline, isheading,
             isfieldonly, isencrypted, entitytype
            )
     VALUES (51006, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:10', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:18', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Organization', 'Organizational entity within client',
             'An organization is a unit of your client or legal entity - examples are store department. You can share data between organizations.',
             'Y', 50010, 51006, 'Y',
             10, 'N', 20, 0, 'Y', 'N',
             'N', 'N', 'D'
            );

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description,
             HELP,
             iscentrallymaintained, ad_tab_id, ad_column_id, isdisplayed,
             displaylength, isreadonly, seqno, sortno, issameline, isheading,
             isfieldonly, isencrypted, entitytype
            )
     VALUES (51007, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:10', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:20', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Name', 'Alphanumeric identifier of the entity',
             'The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.',
             'Y', 50010, 51005, 'Y',
             120, 'N', 30, 0, 'N', 'N',
             'N', 'N', 'D'
            );

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description,
             HELP,
             iscentrallymaintained, ad_tab_id, ad_column_id, isdisplayed,
             displaylength, isreadonly, seqno, sortno, issameline, isheading,
             isfieldonly, isencrypted, entitytype
            )
     VALUES (51008, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:10', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:22', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Active', 'The record is active in the system',
             'There are two methods of making records unavailable in the system: One is to delete the record the other is to de-activate the record. A de-activated record is not available for selection but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g. you cannot DELETE a Business Partner IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.',
             'Y', 50010, 51013, 'Y',
             1, 'N', 40, 0, 'N', 'N',
             'N', 'N', 'D'
            );

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description,
             HELP,
             iscentrallymaintained, ad_tab_id, ad_column_id, isdisplayed,
             displaylength, isreadonly, seqno, sortno, issameline, isheading,
             isfieldonly, isencrypted, entitytype
            )
     VALUES (51009, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:10', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:23', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Line No', 'Unique line for this document',
             'Indicates the unique line for a document.  It will also control the display order of the lines within a document.',
             'Y', 50010, 51014, 'Y',
             22, 'N', 50, 0, 'Y', 'N',
             'N', 'N', 'D'
            );

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description,
             HELP, iscentrallymaintained, ad_tab_id,
             ad_column_id, isdisplayed, displaylength, isreadonly, seqno,
             sortno, issameline, isheading, isfieldonly, isencrypted,
             entitytype
            )
     VALUES (51010, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:11', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:24', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Description', 'Optional short description of the record',
             'A description is limited to 255 characters.', 'Y', 50010,
             51010, 'Y', 255, 'N', 60,
             0, 'N', 'N', 'N', 'N',
             'D'
            );

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, iscentrallymaintained, ad_tab_id, ad_column_id,
             isdisplayed, displaylength, isreadonly, seqno, sortno,
             issameline, isheading, isfieldonly, isencrypted, entitytype
            )
     VALUES (51011, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:11', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:26', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'HTML', 'Y', 50010, 51012,
             'Y', 0, 'N', 70, 0,
             'N', 'N', 'N', 'N', 'D'
            );

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description,
             HELP,
             iscentrallymaintained, ad_tab_id, ad_column_id, isdisplayed,
             displaylength, isreadonly, seqno, sortno, issameline, isheading,
             isfieldonly, isencrypted, entitytype
            )
     VALUES (51012, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:11', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:27', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Goal', 'Performance Goal',
             'The Performance Goal indicates what this users performance will be measured against.',
             'Y', 50010, 51015, 'Y',
             22, 'N', 80, 0, 'N', 'N',
             'N', 'N', 'D'
            );

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description,
             HELP,
             iscentrallymaintained, ad_tab_id, ad_column_id, isdisplayed,
             displaylength, isreadonly, seqno, sortno, issameline, isheading,
             isfieldonly, isencrypted, entitytype
            )
     VALUES (51013, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:11', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:29', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Window', 'Data entry or display window',
             'The Window field identifies a unique Window in the system.',
             'Y', 50010, 51007, 'Y',
             22, 'N', 90, 0, 'Y', 'N',
             'N', 'N', 'D'
            );

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, iscentrallymaintained, ad_tab_id, ad_column_id,
             isdisplayed, displaylength, isreadonly, seqno, sortno,
             issameline, isheading, isfieldonly, isencrypted, entitytype
            )
     VALUES (51014, 0, 0, 'Y',
             TO_DATE ('07/09/2007 14:23:11', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/09/2007 14:23:30', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Dashboard Content', 'Y', 50010, 51018,
             'N', 10, 'N', 0, 0,
             'N', 'N', 'N', 'N', 'D'
            );

-- assign window to new table

UPDATE AD_TABLE
   SET ad_window_id = 50007
 WHERE ad_table_id = 50010;


-- NOTE: Don't forget to run the three processes:
-- 1 - Add missing translations
-- 2 - Synchronize terminology
-- 3 - Check sequences


SELECT '017_update_non_encrypted.sql' AS Filename;
-- Please review before apply
-- if you have any of this columns REALLY encrypted you must not apply this patch:
-- AD_USER.EMailUserPW
-- AD_USER.Password
-- C_PAYMENTPROCESSOR.Password
-- C_PAYMENTPROCESSOR.ProxyPassword

-- defining columns non encrypted by default as discussed here
-- [ 1722235 ] ENCRYPTION FOR PASSWORD wrongly MANAGED
-- https://sourceforge.net/tracker/?func=detail&atid=879332&aid=1722235&group_id=176962

UPDATE AD_COLUMN
   SET isencrypted = 'N',
   updated = TO_DATE ('07/10/2007 00:00:01', 'MM/DD/YYYY HH24:MI:SS')
 WHERE ad_column_id IN (417, 5059, 5065, 7794);


SELECT '018_version330.sql' AS Filename;
UPDATE AD_SYSTEM
   SET releaseno = '330',
       VERSION = '2007-07-13'
 WHERE ad_system_id = 0 AND ad_client_id = 0;



SELECT '019_RMA_dml.sql' AS Filename;
-- Element change

INSERT INTO AD_ELEMENT
    (AD_ELEMENT_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY,COLUMNNAME, ENTITYTYPE, NAME, PRINTNAME, DESCRIPTION, HELP, PO_NAME, PO_PRINTNAME, PO_DESCRIPTION, PO_HELP)
VALUES
    (52000,0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'InOut_ID', 'D', 'Shipment/Receipt', 'Shipment/Receipt', 'MaterialShipment Document', 'The Material Shipment / Receipt ', 'Receipt', 'Receipt', 'Material Receipt Document', 'The Material Shipment / Receipt ');


-- Rule

INSERT INTO AD_VAL_RULE
    (AD_VAL_RULE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, TYPE, CODE, ENTITYTYPE)
VALUES
    (52000, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'M_InOutShipment/Receipt', NULL, 'S', 'M_InOut.MovementType IN (''C-'', ''V+'') AND M_InOut.DocStatus IN (''CO'', ''CL'')', 'D');

INSERT INTO AD_VAL_RULE
    (AD_VAL_RULE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, TYPE, CODE, ENTITYTYPE)
VALUES
    (52001, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'M_InOutShipment/Receipt (RMA)', NULL, 'S', 'M_InOutLine.M_InOut_ID=@InOut_ID@', 'D');


-- Processes

INSERT INTO AD_PROCESS
     (AD_PROCESS_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, HELP, ACCESSLEVEL, ENTITYTYPE, PROCEDURENAME, ISREPORT, ISDIRECTPRINT, AD_REPORTVIEW_ID, CLASSNAME, STATISTIC_COUNT,STATISTIC_SECONDS, AD_PRINTFORMAT_ID, WORKFLOWVALUE, AD_WORKFLOW_ID, ISBETAFUNCTIONALITY, ISSERVERPROCESS, SHOWHELP, JASPERREPORT)
VALUES
    (52000, 0,0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'M_RMA_CreateOrder', 'Create Order From RMA', 'Creates an order based on this RMA Document. The RMA should be correct and completed.', 'Generate Order from RMA will create an order based on this RMA document.', '3', 'D', NULL, 'N', 'N', NULL, 'org.adempiere.process.RMACreateOrder', 0, 0, NULL, NULL, NULL, 'N', 'N', 'Y', NULL);

INSERT INTO AD_PROCESS_ACCESS
    (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
VALUES
    (52000, 0, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Y');

INSERT INTO AD_PROCESS_ACCESS
    (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
VALUES
    (52000, 102, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Y');

INSERT INTO AD_PROCESS_ACCESS
    (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
VALUES
    (52000, 103, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Y');

INSERT INTO AD_PROCESS
     (AD_PROCESS_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, HELP, ACCESSLEVEL, ENTITYTYPE, PROCEDURENAME, ISREPORT, ISDIRECTPRINT, AD_REPORTVIEW_ID, CLASSNAME, STATISTIC_COUNT,STATISTIC_SECONDS, AD_PRINTFORMAT_ID, WORKFLOWVALUE, AD_WORKFLOW_ID, ISBETAFUNCTIONALITY, ISSERVERPROCESS, SHOWHELP, JASPERREPORT)
VALUES
    (52001, 0,0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'M_InOut_GenerateRMA (Manual)', 'Generate Shipments for Vendor RMA', 'Generate Shipments from open vendor RMA based on selection.', NULL, '3', 'D', NULL, 'N', 'N', NULL, 'org.adempiere.process.InOutGenerateRMA', 0, 0, NULL, NULL, NULL, 'N', 'N', 'Y', NULL);

INSERT INTO AD_PROCESS_ACCESS
    (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
VALUES
    (52001, 0, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Y');

INSERT INTO AD_PROCESS_ACCESS
    (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
VALUES
    (52001, 102, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Y');

INSERT INTO AD_PROCESS_ACCESS
    (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
VALUES
    (52001, 103, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Y');


INSERT INTO AD_PROCESS
     (AD_PROCESS_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, VALUE, NAME, DESCRIPTION, HELP, ACCESSLEVEL, ENTITYTYPE, PROCEDURENAME, ISREPORT, ISDIRECTPRINT, AD_REPORTVIEW_ID, CLASSNAME, STATISTIC_COUNT,STATISTIC_SECONDS, AD_PRINTFORMAT_ID, WORKFLOWVALUE, AD_WORKFLOW_ID, ISBETAFUNCTIONALITY, ISSERVERPROCESS, SHOWHELP, JASPERREPORT)
VALUES
    (52002, 0,0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'C_Invoice_GenerateRMA (Manual)', 'Generate Invoices for Vendor RMA', 'Generate Invoices from open vendor RMA based on selection.', NULL, '3', 'D', NULL, 'N', 'N', NULL, 'org.adempiere.process.InvoiceGenerateRMA', 0, 0, NULL, NULL, NULL, 'N', 'N', 'Y', NULL);

INSERT INTO AD_PROCESS_ACCESS
    (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
VALUES
    (52002, 0, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Y');

INSERT INTO AD_PROCESS_ACCESS
    (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
VALUES
    (52002, 102, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Y');

INSERT INTO AD_PROCESS_ACCESS
    (AD_PROCESS_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
VALUES
    (52002, 103, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Y');


-- Column Addition

INSERT INTO AD_COLUMN
    (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, AD_VAL_RULE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, CALLOUT, VFORMAT, VALUEMIN, VALUEMAX, ISSELECTIONCOLUMN, AD_ELEMENT_ID, AD_PROCESS_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE, COLUMNSQL)
VALUES
    (52000, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 100, 'Sales Transaction', 'This is a Sales Transaction', 'The Sales Transaction checkbox indicates if this item is a Sales Transaction.', 1, 'D', 'IsSOTrx', 661, 20, NULL, NULL, 1, '@IsSOTrx@', 'N', 'N', 'Y', 'Y', NULL, 'N', 0, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 1106, NULL, 'N', 'N', NULL);

INSERT INTO AD_COLUMN
    (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, AD_VAL_RULE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, CALLOUT, VFORMAT, VALUEMIN, VALUEMAX, ISSELECTIONCOLUMN, AD_ELEMENT_ID, AD_PROCESS_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE, COLUMNSQL)
VALUES
    (52001, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 100, 'Amount', 'Amount', 'Amount', 1, 'D', 'Amt', 660, 12, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'Y', '@M_InOutLine_ID@!0', 'N', 0, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 160, NULL, 'N', 'N', NULL);


INSERT INTO AD_COLUMN
    (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, AD_VAL_RULE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, CALLOUT, VFORMAT, VALUEMIN, VALUEMAX, ISSELECTIONCOLUMN, AD_ELEMENT_ID, AD_PROCESS_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE, COLUMNSQL)
VALUES
    (52002, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 100, 'Charge', 'Additional document charges', 'The Charge indicates a type of Charge (Handling, Shipping, Restocking)', 1, 'D', 'C_Charge_ID', 660, 19, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 0, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 968, NULL, 'N', 'N', NULL);

INSERT INTO AD_COLUMN
    (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, AD_VAL_RULE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, CALLOUT, VFORMAT, VALUEMIN, VALUEMAX, ISSELECTIONCOLUMN, AD_ELEMENT_ID, AD_PROCESS_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE, COLUMNSQL)
VALUES
    (52003, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 100, 'Line Amount', 'Line Extended Amount (Quantity * Actual Price) without Freight and Charges','Indicates the extended line amount based on the quantity and the actual price. Any additional charges or freight are not included.  The Amount may or may not include tax.  If the price list is inclusive tax, the line amount is the same as the line total.', 1, 'D', 'LineNetAmt', 660, 12, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 0, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 441, NULL, 'N', 'N', NULL);

INSERT INTO AD_COLUMN
    (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, AD_VAL_RULE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, CALLOUT, VFORMAT, VALUEMIN, VALUEMAX, ISSELECTIONCOLUMN, AD_ELEMENT_ID, AD_PROCESS_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE, COLUMNSQL)
VALUES
    (52004, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 100, 'Line No', 'Unique line for this document', 'Indicates the unique line for a document.  It will also control the display order of the lines within a document.', 1, 'D', 'Line', 660, 11, NULL, NULL, 22, '@SQL=SELECT NVL(MAX(Line),0)+10 AS DefaultValue FROM M_RMALine WHERE M_RMA_ID=@M_RMA_ID@', 'N', 'N', 'N', 'Y', NULL, 'N', 0, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 439, NULL, 'N', 'N', NULL);

INSERT INTO AD_COLUMN
    (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, AD_VAL_RULE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, CALLOUT, VFORMAT, VALUEMIN, VALUEMAX, ISSELECTIONCOLUMN, AD_ELEMENT_ID, AD_PROCESS_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE, COLUMNSQL)
VALUES
    (52005, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 100, 'Delivered Quantity', 'Delivered Quantity', 'The Delivered Quantity indicates the quantity of a product that has been delivered.', 1, 'D', 'QtyDelivered', 660, 29, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 0, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 528, NULL, 'N', 'N', NULL);

INSERT INTO AD_COLUMN
    (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, AD_VAL_RULE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, CALLOUT, VFORMAT, VALUEMIN, VALUEMAX, ISSELECTIONCOLUMN, AD_ELEMENT_ID, AD_PROCESS_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE, COLUMNSQL)
VALUES
    (52006, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 100, 'Generate To', 'Generate To', NULL, 0, 'D', 'GenerateTo', 661, 28, NULL, NULL, 1, NULL, 'N','N', 'N', 'Y', NULL, 'N', 0, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 1491, 52000, 'N', 'N', NULL);

INSERT INTO AD_COLUMN
    (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, AD_VAL_RULE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, CALLOUT, VFORMAT, VALUEMIN, VALUEMAX, ISSELECTIONCOLUMN, AD_ELEMENT_ID, AD_PROCESS_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE, COLUMNSQL)
VALUES
    (52007, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 100, 'RMA', 'Return Material Authorization', 'A Return Material Authorization may be required to accept returns and to create Credit Memos', 1, 'D', 'M_RMA_ID', 318, 19, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 0, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 2412, NULL, 'N', 'N', NULL);

INSERT INTO AD_COLUMN
    (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, AD_VAL_RULE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, CALLOUT, VFORMAT, VALUEMIN, VALUEMAX, ISSELECTIONCOLUMN, AD_ELEMENT_ID, AD_PROCESS_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE, COLUMNSQL)
VALUES
    (52008, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 100, 'RMA Line', 'Return Material Authorization Line', 'Detail information about the returned goods', 1, 'D', 'M_RMALine_ID', 333, 19, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 0, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 2413, NULL, 'N', 'N', NULL);

INSERT INTO AD_COLUMN
    (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, AD_VAL_RULE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, CALLOUT, VFORMAT, VALUEMIN, VALUEMAX, ISSELECTIONCOLUMN, AD_ELEMENT_ID, AD_PROCESS_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE, COLUMNSQL)
VALUES
    (52009, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 100, 'RMA', 'Return Material Authorization', 'A Return Material Authorization may be required to accept returns and to create Credit Memos', 1, 'D', 'M_RMA_ID', 319, 19, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 0, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 2412, NULL, 'N', 'N', NULL);

INSERT INTO AD_COLUMN
    (AD_COLUMN_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, UPDATED, CREATEDBY, UPDATEDBY, NAME, DESCRIPTION, HELP, VERSION, ENTITYTYPE, COLUMNNAME, AD_TABLE_ID, AD_REFERENCE_ID, AD_REFERENCE_VALUE_ID, AD_VAL_RULE_ID, FIELDLENGTH, DEFAULTVALUE, ISKEY, ISPARENT, ISMANDATORY, ISUPDATEABLE, READONLYLOGIC, ISIDENTIFIER, SEQNO, ISTRANSLATED, ISENCRYPTED, CALLOUT, VFORMAT, VALUEMIN, VALUEMAX, ISSELECTIONCOLUMN, AD_ELEMENT_ID, AD_PROCESS_ID, ISSYNCDATABASE, ISALWAYSUPDATEABLE, COLUMNSQL)
VALUES
    (52010, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 100, 'RMA Line', 'Return Material Authorization Line', 'Detail information about the returned goods', 0, 'D', 'M_RMALine_ID', 320, 19, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 0, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 2413, NULL, 'N', 'N', NULL);


-- Field addition

INSERT INTO AD_FIELD
    (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
VALUES
    (52000, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Create Order From RMA', 'Creates an order based on the RMA document', NULL, 'Y', 628, 52006, NULL, 'Y', '@Processed@=''Y'' & @C_Order_ID@=0 & @DocStatus@=''CO''', 1, 'N', 160, NULL, 'Y', 'N', 'N', 'N', 'D', NULL, NULL, NULL);

INSERT INTO AD_FIELD
    (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
VALUES
    (52001, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Amount', 'Amount', 'Amount', 'Y', 629, 52001, NULL, 'Y', NULL, 22, 'N', 100, NULL, 'Y', 'N', 'N', 'N', 'D', NULL, NULL, NULL);

INSERT INTO AD_FIELD
    (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
VALUES
    (52002, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Charge', 'Additional document charges', 'The Charge indicates a type of Charge (Handling, Shipping, Restocking)', 'Y', 629, 52002, NULL, 'Y', NULL, 22, 'N', 80, NULL, 'Y', 'N', 'N', 'N', 'D', NULL, NULL, NULL);

INSERT INTO AD_FIELD
    (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
VALUES
    (52003, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Delivered Quantity', 'Delivered Quantity', 'The Delivered Quantity indicates the quantity of a product that has been delivered.', 'Y', 629, 52005, NULL, 'N', NULL, 22, 'N', 0, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);

INSERT INTO AD_FIELD
    (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
VALUES
    (52004, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Line Amount', 'Line Extended Amount (Quantity * Actual Price) without Freight and Charges', 'Indicates the extended line amount based on the quantity and the actual price.  Any additional charges or freight are not included.  The Amount may or may not include tax.  If the price list is inclusive tax, the line amount is the same as the line total.', 'Y', 629, 52003, NULL, 'Y', NULL, 22, 'Y', 110, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);

INSERT INTO AD_FIELD
    (AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
VALUES
    (52005, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Line No', 'Unique line for this document', 'Indicates the unique line for a document.  It will also control the display order of the lines within a document.', 'Y', 629, 52004, NULL, 'Y', NULL, 22, 'N', 40, NULL, 'Y', 'N', 'N', 'N', 'D', NULL, NULL, NULL);

INSERT INTO AD_FIELD(ad_field_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, description, help, iscentrallymaintained, ad_tab_id, ad_column_id, ad_fieldgroup_id, isdisplayed, displaylogic, displaylength, isreadonly, seqno, sortno, issameline, isheading, isfieldonly, isencrypted, entitytype, obscuretype, ad_reference_id, ismandatory)
  VALUES(52007, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Sales Transaction', 'This is a Sales Transaction', 'The Sales Transaction checkbox indicates if this item is a Sales Transaction.', 'Y', 628, 52000, NULL, 'N', NULL, 1, 'N', NULL, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);

-- Update Field

UPDATE AD_FIELD SET SeqNo=(SeqNo + 10) WHERE AD_Tab_ID=296 AND SeqNo > 40;

INSERT INTO AD_FIELD
(ad_field_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, description, help, iscentrallymaintained, ad_tab_id, ad_column_id, ad_fieldgroup_id, isdisplayed, displaylogic, displaylength, isreadonly, seqno, sortno, issameline, isheading, isfieldonly, isencrypted, entitytype, obscuretype, ad_reference_id, ismandatory)
  VALUES(52006, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'RMA', 'Return Material Authorization', 'A Return Material Authorization may be required to accept returns and to create Credit Memos', 'Y', 296, 52009, NULL, 'Y', '@M_RMA_ID@!0', 26, 'Y', 50, 0, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);


-- Garden World RMA Fix

INSERT INTO AD_SEQUENCE(ad_sequence_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, description, vformat, isautosequence, incrementno, startno, currentnext, currentnextsys, isaudited, istableid, prefix, suffix, startnewyear)
  VALUES(52000, 11, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 0, 'Vendor Return Material', NULL, NULL, 'Y', 1, 990000, 990000, 900, 'N', 'N', NULL, NULL, 'N');

INSERT INTO AD_SEQUENCE(ad_sequence_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, description, vformat, isautosequence, incrementno, startno, currentnext, currentnextsys, isaudited, istableid, prefix, suffix, startnewyear)
  VALUES(52001, 11, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 0, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 0, 'MM Vendor Return', 'MM Vendor Return', NULL, 'Y', 1, 590000, 590000, 59000, 'N', 'N', NULL, NULL, 'N');

INSERT INTO C_DOCTYPE(c_doctype_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, printname, description, docbasetype, issotrx, docsubtypeso, hasproforma, c_doctypeproforma_id, c_doctypeshipment_id, c_doctypeinvoice_id, isdocnocontrolled, docnosequence_id, gl_category_id, hascharges, documentnote, isdefault, documentcopies, ad_printformat_id, isdefaultcounterdoc, isshipconfirm, ispickqaconfirm, isintransit, issplitwhendifference, c_doctypedifference_id, iscreatecounter, isindexed)
  VALUES(151, 11, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'MM Vendor Return', 'Vendor Return Material', NULL, 'MMS', 'Y', NULL, 'N', NULL, NULL, NULL, 'Y', 52001, 111, 'N', NULL, 'Y', 1, NULL, 'N', 'N', 'N', 'N', 'N', NULL, 'Y', 'Y');

INSERT INTO C_DOCTYPE(c_doctype_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, printname, description, docbasetype, issotrx, docsubtypeso, hasproforma, c_doctypeproforma_id, c_doctypeshipment_id, c_doctypeinvoice_id, isdocnocontrolled, docnosequence_id, gl_category_id, hascharges, documentnote, isdefault, documentcopies, ad_printformat_id, isdefaultcounterdoc, isshipconfirm, ispickqaconfirm, isintransit, issplitwhendifference, c_doctypedifference_id, iscreatecounter, isindexed)
  VALUES(150, 11, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'Vendor Return Material', 'Vendor Return Material Authorization', NULL, 'POO', 'N', 'RM', 'N', NULL, 151, 124, 'Y', 52000, 111, 'N', NULL, 'N', 1, NULL, 'N', 'N', 'N', 'N', 'N', NULL, 'Y', 'Y');

-- Message Addition

INSERT INTO AD_MESSAGE
(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52000, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'OrderOrRMA', 'Either Order or RMA can be process on this document.', NULL, 'E', 'D');

INSERT INTO AD_MESSAGE
(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52001, 0, 0, 'Y', TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, TO_DATE('07/05/2007 17:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100, 'VendorRMA', 'Vendor RMA', NULL, 'I', 'D');

-- Misc AD Updates

UPDATE AD_COLUMN SET ColumnName='InOut_ID' WHERE AD_Column_ID=10842;

UPDATE AD_COLUMN SET AD_Element_ID=52000 WHERE AD_Column_ID=10842;

UPDATE AD_COLUMN SET AD_Reference_Value_ID=337 WHERE AD_Column_ID=10842;

UPDATE AD_COLUMN SET AD_Val_Rule_ID=52000 WHERE AD_Column_ID=10842;

UPDATE AD_TAB SET WhereClause='MovementType IN (''C+'', ''V+'')' WHERE AD_Tab_ID=296;

UPDATE AD_TAB SET WhereClause='MovementType IN (''C-'', ''V-'')' WHERE AD_Tab_ID=257;

UPDATE AD_COLUMN SET IsMandatory='N' WHERE AD_Column_ID=10829;

UPDATE AD_COLUMN SET AD_Val_Rule_ID=52001 WHERE AD_Column_ID=10829;

UPDATE AD_FIELD SET SeqNo=60, IsSameLine='N' WHERE AD_Field_ID=9310;

UPDATE AD_FIELD SET SeqNo=20, IsSameLine='Y' WHERE AD_Field_ID=9311;

UPDATE AD_FIELD SET SeqNo=70, IsSameLine='N' WHERE AD_Field_ID=9312;

UPDATE AD_FIELD SET SeqNo=0, IsSameLine='N' WHERE AD_Field_ID=9313;

UPDATE AD_FIELD SET SeqNo=30, IsSameLine='N' WHERE AD_Field_ID=9314;

UPDATE AD_FIELD SET SeqNo=50, IsSameLine='N' WHERE AD_Field_ID=9315;

UPDATE AD_FIELD SET SeqNo=90, IsSameLine='N' WHERE AD_Field_ID=9316;

UPDATE AD_FIELD SET SeqNo=10, IsSameLine='N' WHERE AD_Field_ID=9317;

UPDATE AD_FIELD SET SeqNo=0, IsSameLine='N' WHERE AD_Field_ID=10401;

UPDATE AD_FIELD SET SeqNo=100, IsSameLine='Y' WHERE AD_Field_ID=52001;

UPDATE AD_FIELD SET SeqNo=80, IsSameLine='Y' WHERE AD_Field_ID=52002;

UPDATE AD_FIELD SET SeqNo=0, IsSameLine='N' WHERE AD_Field_ID=52003;

UPDATE AD_FIELD SET SeqNo=110, IsSameLine='N' WHERE AD_Field_ID=52004;

UPDATE AD_FIELD SET SeqNo=40, IsSameLine='Y' WHERE AD_Field_ID=52005;

UPDATE AD_TAB SET IsSingleRow='Y' WHERE AD_Tab_ID=628;

UPDATE AD_TAB SET IsSingleRow='Y' WHERE AD_Tab_ID=629;

UPDATE C_DOCTYPE SET IsActive='Y' WHERE C_DocType_ID=149;


UPDATE AD_COLUMN SET Callout='org.adempiere.model.CalloutRMA.docType' WHERE AD_Column_ID=12118;

UPDATE AD_COLUMN SET ReadOnlyLogic='@IsSOTrx@=''N''' WHERE AD_Column_ID=52006;

UPDATE AD_FIELD SET DisplayLogic='@Processed@=''Y'' & @C_Order_ID@=0 & @DocStatus@=''CO'' & @IsSOTrx@=''Y''' 
WHERE AD_Field_ID=52000;

UPDATE AD_REF_TABLE SET WhereClause='C_DocType.DocBaseType IN (''SOO'', ''POO'') AND C_DocType.DocSubTypeSO=''RM'' AND C_DocType.AD_Client_ID=@#AD_Client_ID@' 
WHERE AD_Reference_ID=321;

UPDATE AD_VAL_RULE SET Code='M_InOutLine.M_InOut_ID=@InOut_ID@ AND NOT EXISTS (SELECT * FROM M_RMALine rl WHERE rl.M_InOutLine_ID=M_InOutLine.M_InOutLine_ID AND rl.M_RMA_ID=@M_RMA_ID@)' 
WHERE AD_Val_Rule_ID=52001;

UPDATE C_DOCTYPE SET NAME='MM Returns', IsSOTrx='N' WHERE C_DocType_ID=149;




-- NOTE: Don't forget to run the three processes:
-- 1 - Add missing translations
-- 2 - Synchronize terminology
-- 3 - Check sequences

SELECT '020_RMA_Postgresql_ddl.sql' AS Filename;
-- POSTGRESQL Changes

ALTER TABLE C_Invoice ADD M_RMA_ID NUMERIC(10) DEFAULT NULL;

ALTER TABLE C_InvoiceLine ADD M_RMALine_ID NUMERIC(10,0) DEFAULT NULL;

ALTER TABLE M_InOut ADD M_RMA_ID NUMERIC(10,0) DEFAULT NULL;

ALTER TABLE M_InOutLine ADD M_RMALine_ID NUMERIC(10,0) DEFAULT NULL;

ALTER TABLE M_RMA ADD IsSOTrx CHAR(1) DEFAULT 'Y' CHECK (IsSOTrx IN ('Y', 'N')) NOT NULL;

ALTER TABLE M_RMA RENAME M_InOut_ID TO InOut_ID;

ALTER TABLE M_RMA ADD GenerateTo CHAR(1) DEFAULT NULL;

ALTER TABLE M_RMALine ADD Amt NUMERIC;

ALTER TABLE M_RMALine ADD C_Charge_ID NUMERIC(10,0);

ALTER TABLE M_RMALine ADD Line NUMERIC(10,0) DEFAULT 0 NOT NULL;

ALTER TABLE M_RMALine ADD LineNetAmt NUMERIC;

ALTER TABLE M_RMALine ADD QtyDelivered NUMERIC;

ALTER TABLE M_RMALine ALTER COLUMN M_InOutLine_ID DROP DEFAULT;

ALTER TABLE M_RMALine ALTER COLUMN M_InOutLine_ID DROP NOT NULL;


-- Constraints

ALTER TABLE C_Invoice ADD CONSTRAINT mrma_cinvoice FOREIGN KEY (M_RMA_ID) REFERENCES M_RMA (M_RMA_ID);

ALTER TABLE C_InvoiceLine ADD CONSTRAINT mrmaline_cinvoiceline FOREIGN KEY (M_RMALine_ID) REFERENCES M_RMALine (M_RMALine_ID);

ALTER TABLE M_InOut ADD CONSTRAINT mrma_minout FOREIGN KEY (M_RMA_ID) REFERENCES M_RMA (M_RMA_ID);

ALTER TABLE M_InOutLine ADD CONSTRAINT mrmaline_minoutline FOREIGN KEY (M_RMALine_ID) REFERENCES M_RMALine (M_RMALine_ID);

SELECT '021_BF_1754751.sql' AS Filename;
UPDATE AD_WINDOW
   SET windowtype = 'M'
 WHERE ad_window_id = 319 AND windowtype = 'T';


SELECT '022_BF_1746900.sql' AS Filename;
-- Update help for "C_AcctSchema_Default_Copy" process
 UPDATE AD_PROCESS 
   SET classname = 'org.compiere.process.AcctSchemaDefaultCopy',
   help = 'Either add missing accounts - or copy and overwrite all default accounts.  If you copy and overwrite the current default values, you may have to repeat previous updates (e.g. set the bank account asset accounts, ...).  If no Accounting Schema is selected all Accounting Schemas will be updated / inserted.'
 WHERE AD_Process_ID=108;

-- Update Accounting Schema parameter for "C_AcctSchema_Default_Copy" process
UPDATE AD_PROCESS_PARA 
   SET ismandatory = 'Y'
 WHERE ad_process_para_id= 669;

-- Update help for "M_Product_Category_Acct_Copy" process
UPDATE AD_PROCESS 
   SET classname = 'org.compiere.process.ProductCategoryAcctCopy', 
   help = 'If you copy and overwrite the current default values, you may have to repeat previous updates (e.g. set the revenue account, ...). If no Accounting Schema is selected all Accounting Schemas will be updated / inserted for products of this category.'
 WHERE AD_Process_ID=140;

-- Update help for "M_Product_Category_Acct_Copy" process (SPANISH translation)
UPDATE AD_PROCESS_TRL
   SET help ='El proceso de copiar cuentas tomará las cuentas definidas para una categoría de producto y las copiará a cualquier producto que que haga referencia a esta categoría. Si una cuenta existe a nivel de producto sera sobreescrita. Si no selecciona un Esquema Contable serán actualizados para todos los que estén definidos.'
 WHERE AD_Process_ID=140
   AND AD_LANGUAGE LIKE 'es_%';

-- Update Accounting Schema parameter for "M_Product_Category_Acct_Copy" process.
UPDATE AD_PROCESS_PARA 
   SET ismandatory = 'Y'
 WHERE AD_Process_Para_ID=668;

 UPDATE AD_PROCESS 
   SET classname = 'org.compiere.process.BPGroupAcctCopy'
 WHERE AD_Process_ID=112;


SELECT '023_Reverse_BF_1740254.sql' AS Filename;
--
-- [ 1740254 ] PriceList Version is empty in Product-Price tab
-- http://sourceforge.net/tracker/index.php?func=detail&aid=1740254&group_id=176962&atid=879332
--
-- Column M_ProductPrice.M_PriceList_Version_ID:

-- Original File 012_BF_1740254.sql was deleted - the original file put the IsParent='N'
-- restoring past value from IsParent because somebody could apply this patch into their system

UPDATE AD_COLUMN SET IsParent='Y' WHERE AD_Column_ID=2760;



SELECT '024_BF_1564496.sql' AS Filename;
UPDATE AD_COLUMN
   SET callout = 'org.compiere.model.CalloutMovement.qty'
 WHERE ad_column_id = 3594;


SELECT '025_Reverse_BF_1739541.sql' AS Filename;
--
-- [ 1739541 ] Organization in Window "Role" problem
-- http://sourceforge.net/tracker/index.php?func=detail&aid=1739541&group_id=176962&atid=879332
--
-- Original File 011_BF_1739541.sql was deleted - the original file put the IsParent='N'
-- restoring past value from IsParent because somebody could apply this patch into their system
-- 
-- Column AD_Role_OrgAccess.AD_Org_ID:
UPDATE AD_Column SET IsParent='Y' WHERE AD_Column_ID=5508 AND IsParent='N';
--


SELECT '026_BF_1759181.sql' AS Filename;
/*
   Fix bug in Application Dictionary 
   [ 1759181 ] AD_Color.ColorType is defined as Color and must be List
*/

UPDATE AD_COLUMN
   SET ad_reference_id = 17
 WHERE ad_column_id = 6232 AND ad_reference_id = 27;


SELECT '001_BF_1760922.sql' AS Filename;
UPDATE AD_ELEMENT
SET Name = 'Package Version',
PrintName = 'Package Version'
wHERE AD_Element_ID = '50003';

UPDATE AD_COLUMN
SET Name = 'Package Version'
WHERE AD_Column_ID IN (50008, 50047, 50094);

UPDATE AD_FIELD
SET Name = 'Package Version'
WHERE AD_Column_ID IN (50008, 50047, 50094);

UPDATE AD_ELEMENT
SET Name = 'Update System Maintained Application Dictionary'
WHERE AD_Element_ID = 50032;

UPDATE AD_COLUMN
SET Name = 'Update System Maintained Application Dictionary',
DefaultValue = 'Y'
WHERE AD_Column_ID = 50169;

UPDATE AD_FIELD
SET Name = 'Update System Maintained Application Dictionary'
WHERE AD_Column_ID = 50169;

UPDATE AD_ELEMENT
SET Name = 'Package Directory',
Description = 'Package directory, default to AdempiereHome/packages'
WHERE AD_Element_ID = 50033;

UPDATE AD_COLUMN
SET Name = 'Package Directory',
Description = 'Package directory, default to AdempiereHome/packages'
WHERE AD_Column_ID = 50170;

UPDATE AD_FIELD
SET Name = 'Package Directory',
Description = 'Package directory, default to AdempiereHome/packages'
WHERE AD_Column_ID = 50170;

UPDATE AD_ELEMENT
SET Name = 'Package Source',
PrintName = 'Package Source',
Description = 'Fully qualified package source file name'
WHERE AD_Element_ID = 50035;

UPDATE AD_Column
SET Name = 'Package Source',
IsMandatory = 'Y',
AD_Reference_ID = 39,
Description = 'Fully qualified package source file name'
WHERE AD_Column_ID = 50172;

UPDATE AD_Field
SET Name = 'Package Source',
Description = 'Fully qualified package source file name'
WHERE AD_Column_ID = 50172;

UPDATE AD_Element
SET Name = 'Package Source Type',
Description = 'Type of package source - file, ftp, webservice etc'
WHERE AD_Element_ID = 50036;

UPDATE AD_Column
SET Name = 'Package Source Type',
Description = 'Type of package source - file, ftp, webservice etc'
WHERE AD_Column_ID = 50173;

UPDATE AD_Field
SET Name = 'Package Source Type',
Description = 'Type of package source - file, ftp, webservice etc'
WHERE AD_Column_ID = 50173;



SELECT '002_FR_1757535.sql' AS Filename;
--
-- [ 1757535 ] "Item is already on Bar" should be translated
-- http://sourceforge.net/tracker/index.php?func=detail&aid=1757535&group_id=176962&atid=879335
--
INSERT INTO AD_Message (
	AD_MESSAGE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,
	VALUE,MSGTEXT,MSGTIP,
	MSGTYPE,ENTITYTYPE
)
values (
	53002,0,0,'Y',to_date('2007-07-13 17:33:55', 'yyyy-mm-dd hh24.mi.ss'),0,to_date('2007-07-13 17:36:55', 'yyyy-mm-dd hh24.mi.ss'),0,
	'BookmarkExist','This Bookmark already exist','Selected Menu Item is already registered on Bookmarks Bar',
	'E','A'
);

-- 
-- NOTE: Don't forget to run: check sequence, add missing translations !!!
--


SELECT '003_BF_1763523.sql' AS Filename;
--
-- BF [ 1763523 ] Translate errors from Cash Line
-- http://sourceforge.net/tracker/index.php?func=detail&aid=1763523&group_id=176962&atid=879332
--
insert into AD_Message (
	AD_MESSAGE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,
	VALUE,MSGTEXT,MSGTIP,MSGTYPE,ENTITYTYPE)
values (
	53003,0,0,'Y',to_date('30-07-2007','DD-MM-RRRR'),0,to_date('30-07-2007','DD-MM-RRRR'),0,
	'CannotDeleteCashGenInvoice','Cannot delete line with generated Invoice',null,'E','D'
);
--
insert into AD_Message (
	AD_MESSAGE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,
	VALUE,MSGTEXT,MSGTIP,MSGTYPE,ENTITYTYPE)
values (
	53004,0,0,'Y',to_date('30-07-2007','DD-MM-RRRR'),0,to_date('30-07-2007','DD-MM-RRRR'),0,
	'CannotChangeCashGenInvoice','Cannot change line with generated Invoice',null,'E','D'
);
--

--
-- NOTE: don't forget to run add missing translations and sequence check

SELECT '004_BF_1746366.sql' AS Filename;
DELETE FROM AD_Ref_List
 WHERE AD_Ref_List_ID=638;

UPDATE AD_Ref_List
   SET IsActive='N'
 WHERE AD_Ref_List_ID IN (634,611);


SELECT '005_FR_1754879.sql' AS Filename;
INSERT INTO AD_MESSAGE
            (ad_message_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             VALUE, msgtext, msgtype, entitytype
            )
     VALUES (50018, 0, 0, 'Y',
             TO_TIMESTAMP ('08/02/2007 00:15:12', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_TIMESTAMP ('08/02/2007 00:15:12', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'CC', 'CC', 'M', 'D'
            );



SELECT '007_BF_1774758.sql' AS Filename;
--
-- BF [ 1774758 ] No default Sales Representant in request window
--

UPDATE AD_COLUMN
	SET DefaultValue = '@#AD_User_ID@'
	WHERE DefaultValue = '@AD_User_ID@' AND AD_Column_ID = 5432;



SELECT '008_BF_1672847.sql' AS Filename;
update AD_Column 
set isparent = 'N'
where AD_Column_ID in (13467, 13468);

update ad_tab
set ad_column_id = null
where AD_Tab_ID=701;
SELECT '009_FR_1788114.sql' AS Filename;
UPDATE AD_VAL_RULE
   SET code =
          '(C_Order.DocStatus=''WP'' OR (C_Order.DocStatus=''CO'' AND EXISTS (SELECT * FROM C_DocType dt WHERE C_Order.C_DocType_ID=dt.C_DocType_ID AND (dt.DocSubTypeSO=''SO'' OR dt.DocBaseType=''POO'')) AND EXISTS (SELECT * FROM C_OrderLine ol WHERE C_Order.C_Order_ID=ol.C_Order_ID AND ol.QtyInvoiced<>ol.QtyOrdered)))'
 WHERE ad_val_rule_id = 218;
 

SELECT '010_BF1788185.sql' AS Filename;
ALTER TABLE i_invoice ALTER COLUMN taxindicator TYPE varchar(10);

ALTER TABLE i_order ALTER COLUMN taxindicator TYPE varchar(10);

UPDATE AD_COLUMN
   SET fieldlength = 10
 WHERE ad_column_id IN (8991, 9186);


SELECT '011_FR_1789836.sql' AS Filename;
-- [ 1789836 ] Add fields to Import Invoice - allow import charges
-- http://sourceforge.net/tracker/index.php?func=detail&aid=1789836&group_id=176962&atid=879335

ALTER TABLE I_INVOICE ADD COLUMN projectvalue VARCHAR(40) NULL;

ALTER TABLE I_INVOICE ADD COLUMN activityvalue VARCHAR(40) NULL;

ALTER TABLE I_INVOICE ADD COLUMN chargename VARCHAR(60) NULL;

ALTER TABLE I_INVOICE ADD COLUMN c_charge_id NUMERIC(10,0) NULL;

INSERT INTO AD_ELEMENT
            (ad_element_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             columnname, entitytype, NAME, printname
            )
     VALUES (53222, 0, 0, 'Y',
             TO_TIMESTAMP ('09/04/2007 22:54:47', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_TIMESTAMP ('09/04/2007 22:54:47', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'ActivityValue', 'U', 'ActivityValue', 'ActivityValue'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description, VERSION, entitytype,
             columnname, ad_table_id, ad_reference_id, fieldlength, iskey,
             isparent, ismandatory, isupdateable, isidentifier, istranslated,
             isencrypted, isselectioncolumn, ad_element_id, issyncdatabase,
             isalwaysupdateable
            )
     VALUES (53241, 0, 0, 'Y',
             TO_TIMESTAMP ('09/04/2007 22:54:47', 'MM/DD/YYYY HH24:MI:SS'),
             TO_TIMESTAMP ('09/04/2007 22:54:47', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Project Key', 'Key of the Project', 0, 'U',
             'ProjectValue', 598, 10, 40, 'N',
             'N', 'N', 'Y', 'N', 'N',
             'N', 'N', 2118, 'Y',
             'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP,
             VERSION, entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, istranslated, isencrypted, isselectioncolumn,
             ad_element_id, issyncdatabase, isalwaysupdateable
            )
     VALUES (53242, 0, 0, 'Y',
             TO_TIMESTAMP ('09/04/2007 22:54:47', 'MM/DD/YYYY HH24:MI:SS'),
             TO_TIMESTAMP ('09/04/2007 22:54:47', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Charge', 'Additional document charges',
             'The Charge indicates a type of Charge (Handling, Shipping, Restocking)',
             0, 'U', 'C_Charge_ID', 598, 19,
             10, 'N', 'N', 'N', 'Y',
             'N', 'N', 'N', 'N',
             968, 'Y', 'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, VERSION, entitytype, columnname, ad_table_id,
             ad_reference_id, fieldlength, iskey, isparent, ismandatory,
             isupdateable, isidentifier, istranslated, isencrypted,
             isselectioncolumn, ad_element_id, issyncdatabase,
             isalwaysupdateable
            )
     VALUES (53243, 0, 0, 'Y',
             TO_TIMESTAMP ('09/04/2007 22:54:47', 'MM/DD/YYYY HH24:MI:SS'),
             TO_TIMESTAMP ('09/04/2007 22:54:47', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'ActivityValue', 0, 'U', 'ActivityValue', 598,
             10, 40, 'N', 'N', 'N',
             'Y', 'N', 'N', 'N',
             'N', 53222, 'Y',
             'N'
            );

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description, VERSION, entitytype, columnname,
             ad_table_id, ad_reference_id, fieldlength, iskey, isparent,
             ismandatory, isupdateable, isidentifier, istranslated,
             isencrypted, isselectioncolumn, ad_element_id, issyncdatabase,
             isalwaysupdateable
            )
     VALUES (53244, 0, 0, 'Y',
             TO_TIMESTAMP ('09/04/2007 22:54:46', 'MM/DD/YYYY HH24:MI:SS'),
             TO_TIMESTAMP ('09/04/2007 22:54:46', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Charge Name', 'Name of the Charge', 0, 'U', 'ChargeName',
             598, 10, 60, 'N', 'N',
             'N', 'Y', 'N', 'N',
             'N', 'N', 2096, 'Y',
             'N'
            );

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, iscentrallymaintained, ad_tab_id, ad_column_id,
             isdisplayed, displaylength, isreadonly, seqno, sortno,
             issameline, isheading, isfieldonly, isencrypted, entitytype
            )
     VALUES (53251, 0, 0, 'Y',
             TO_TIMESTAMP ('09/04/2007 22:54:47', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_TIMESTAMP ('09/04/2007 22:54:47', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'ActivityValue', 'Y', 510, 53243,
             'Y', 40, 'N', 498, 0,
             'N', 'N', 'N', 'N', 'U'
            );

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description, iscentrallymaintained, ad_tab_id,
             ad_column_id, ad_fieldgroup_id, isdisplayed, displaylength,
             isreadonly, seqno, sortno, issameline, isheading, isfieldonly,
             isencrypted, entitytype
            )
     VALUES (53252, 0, 0, 'Y',
             TO_TIMESTAMP ('09/04/2007 22:54:47', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_TIMESTAMP ('09/04/2007 22:54:47', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Project Key', 'Key of the Project', 'Y', 510,
             53241, 104, 'Y', 40,
             'N', 478, 0, 'N', 'N', 'N',
             'N', 'U'
            );

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description,
             HELP,
             iscentrallymaintained, ad_tab_id, ad_column_id, isdisplayed,
             displaylength, isreadonly, seqno, sortno, issameline, isheading,
             isfieldonly, isencrypted, entitytype
            )
     VALUES (53253, 0, 0, 'Y',
             TO_TIMESTAMP ('09/04/2007 22:54:47', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_TIMESTAMP ('09/04/2007 22:54:47', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Charge', 'Additional document charges',
             'The Charge indicates a type of Charge (Handling, Shipping, Restocking)',
             'Y', 510, 53242, 'Y',
             10, 'N', 392, 0, 'N', 'N',
             'N', 'N', 'U'
            );

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description, iscentrallymaintained, ad_tab_id,
             ad_column_id, isdisplayed, displaylength, isreadonly, seqno,
             sortno, issameline, isheading, isfieldonly, isencrypted,
             entitytype
            )
     VALUES (53254, 0, 0, 'Y',
             TO_TIMESTAMP ('09/04/2007 22:54:47', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_TIMESTAMP ('09/04/2007 22:57:16', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Charge Name', 'Name of the Charge', 'Y', 510,
             53244, 'Y', 40, 'N', 394,
             0, 'Y', 'N', 'N', 'N',
             'U'
            );


SELECT '012_BR_1794352.sql' AS Filename;
UPDATE AD_COLUMN
   SET ad_val_rule_id = 220
 WHERE ad_column_id = 5354;
 

SELECT '013_DocumentNo.sql' AS Filename;
CREATE FUNCTION documentNo(p_MPC_MRP_ID numeric) RETURNS character varying

    AS $$org.compiere.sqlj.Manufacturing.documentNo(int)$$
    LANGUAGE java;


ALTER FUNCTION adempiere.documentNo(p_MPC_MRP_ID numeric) OWNER TO postgres;

SELECT '013_PosteritaDLL_PG.sql' AS Filename;
-- Posterita SQL Scripts for PostgreSQL
---------------------------
--   SCRIPT STARTS HERE!
---------------------------

--- Table: U_WEB_PROPERTIES -------------------------------------------------------
CREATE TABLE U_WEB_PROPERTIES
  (
    U_Web_Properties_ID  NUMERIC(10,0)   NOT NULL  ,
    AD_Client_ID         NUMERIC(10,0)   NOT NULL  ,
    AD_Org_ID            NUMERIC(10,0)   NOT NULL  ,
    IsActive             CHAR(1)        DEFAULT 'Y' NOT NULL ,
    Created              TIMESTAMP           DEFAULT NOW() NOT NULL ,
    CreatedBy            INTEGER        NOT NULL ,
    Updated              TIMESTAMP           DEFAULT NOW() NOT NULL ,
    UpdatedBy            INTEGER        NOT NULL ,
    U_Key                VARCHAR(240)     NOT NULL ,
    U_Value              VARCHAR(240)     NOT NULL ,
    primary key(U_Web_Properties_ID),
    CHECK(IsActive IN ('Y', 'N'))
  );

--- Table: U_RoleMenu -------------------------------------------------------
CREATE TABLE U_RoleMenu
  (
    U_RoleMenu_ID  NUMERIC(10,0)   NOT NULL  ,
    AD_Client_ID   NUMERIC(10,0)   NOT NULL  ,
    AD_Org_ID      NUMERIC(10,0)   NOT NULL  ,
    IsActive       CHAR(1)        DEFAULT 'Y' NOT NULL,
    Created        TIMESTAMP           DEFAULT NOW() NOT NULL,
    CreatedBy      INTEGER        NOT NULL,
    Updated        TIMESTAMP           DEFAULT NOW() NOT NULL,
    UpdatedBy      INTEGER        NOT NULL,
    AD_Role_ID     NUMERIC(10,0)   NOT NULL,
    U_WebMenu_ID      NUMERIC(10,0)   NOT NULL,
    primary key(U_RoleMenu_ID),
    CHECK(IsActive IN ('Y', 'N'))
  );

--- Table: U_WebMenu -------------------------------------------------------
CREATE TABLE U_WebMenu
  (
    U_WebMenu_ID      NUMERIC(10,0)      NOT NULL  ,
    AD_Client_ID   NUMERIC(10,0)      NOT NULL  ,
    AD_Org_ID      NUMERIC(10,0)      NOT NULL  ,
    IsActive       CHAR(1)           DEFAULT 'Y' NOT NULL  ,
    Created        TIMESTAMP              DEFAULT NOW() NOT NULL,
    CreatedBy      NUMERIC(10,0)      NOT NULL ,
    Updated        TIMESTAMP              DEFAULT NOW() NOT NULL ,
    UpdatedBy      NUMERIC(10,0)      NOT NULL  ,
    Name           VARCHAR(120)        NOT NULL  ,
    MenuLink       VARCHAR(510)        NOT NULL  ,
    Module         VARCHAR(120)        NOT NULL  ,
    ParentMenu_ID  NUMERIC(10,0)       ,
    HasSubMenu     CHAR(1)           DEFAULT 'N' NOT NULL,
    Description    VARCHAR(200)         ,
    ImageLink      VARCHAR(510)         ,
    Position       VARCHAR(10)        ,
    Help           VARCHAR(2000)    ,
    primary key(U_WebMenu_ID),
    CHECK(IsActive IN ('Y', 'N')),
    CHECK(HasSubMenu IN ('Y', 'N'))
  );

--- Table: U_BlackListCheque -------------------------------------------------------
CREATE TABLE U_BlackListCheque
  (
    U_BlackListCheque_ID  NUMERIC(10,0)     NOT NULL ,
    AD_Client_ID          NUMERIC(10,0)     NOT NULL  ,
    AD_Org_ID             NUMERIC(10,0)     NOT NULL  ,
    IsActive              CHAR(1)          DEFAULT 'Y' NOT NULL,
    Created               TIMESTAMP             DEFAULT NOW() NOT NULL  ,
    CreatedBy             NUMERIC(10,0)     NOT NULL  ,
    Updated               TIMESTAMP             DEFAULT NOW() NOT NULL ,
    UpdatedBy             NUMERIC(10,0)     NOT NULL  ,
    BankName              VARCHAR(120)   NOT NULL  ,
    ChequeNo              VARCHAR(120)   NOT NULL  ,
    primary key(U_BlackListCheque_ID),
    CHECK(IsActive IN ('Y', 'N'))
  );


--- Table: AD_PrintFormat -------------------------------------------------------------

ALTER TABLE AD_PrintFormat ADD COLUMN ClassName VARCHAR(240);

ALTER TABLE AD_PrintFormat ADD COLUMN Args VARCHAR(510);

----------------------------------------------------------------------------

--- Table: AD_User -------------------------------------------------------------

ALTER TABLE AD_User ADD COLUMN UserPIN VARCHAR(20);

ALTER TABLE AD_User ALTER COLUMN UserPIN TYPE VARCHAR(20);

----------------------------------------------------------------------------

--- Table: AD_Role -------------------------------------------------------------

ALTER TABLE AD_Role ADD COLUMN UserDiscount NUMERIC(22,2);

ALTER TABLE AD_Role ALTER COLUMN UserDiscount TYPE numeric(22,2);


----------------------------------------------------------------------------

--- Table: C_Order -------------------------------------------------------------

ALTER TABLE C_Order ADD COLUMN OrderType VARCHAR(510);

ALTER TABLE C_Order ADD COLUMN C_POS_ID NUMERIC(10,0);

ALTER TABLE C_Order ADD COLUMN AmountTendered NUMERIC(22,2);

ALTER TABLE C_Order ADD COLUMN AmountRefunded NUMERIC(22,2);



----------------------------------------------------------------------------

--- Table: M_Product -----------------------------------------------------------

ALTER TABLE M_Product ADD COLUMN Group1 VARCHAR(255);

ALTER TABLE M_Product ALTER COLUMN Group1 TYPE VARCHAR(255);

ALTER TABLE M_Product ADD COLUMN Group2 VARCHAR(255);

ALTER TABLE M_Product ALTER COLUMN Group2 TYPE VARCHAR(255);

----------------------------------------------------------------------------

--- Table: U_WebMenu -------------------------------------------------------
ALTER TABLE U_WebMenu ADD COLUMN Category VARCHAR(120);

ALTER TABLE U_WebMenu ALTER COLUMN Category TYPE VARCHAR(120);

ALTER TABLE U_WebMenu ADD COLUMN Sequence NUMERIC(10,0);

ALTER TABLE U_WebMenu ALTER Sequence TYPE NUMERIC(10,0);

----------------------------------------------------------------------------


--- Table: C_POS ---------------------------------------------------------------

ALTER TABLE C_POS ADD COLUMN CashDrawer VARCHAR(120);

ALTER TABLE C_POS ALTER COLUMN CashDrawer TYPE VARCHAR(120);


----------------------------------------------------------------------------



SELECT '014_PosteritaDML_PG.sql' AS Filename;
-- Sequence Changes --
INSERT INTO AD_SEQUENCE(ad_sequence_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, description, vformat, isautosequence, incrementno, startno, currentnext, currentnextsys, isaudited, istableid, prefix, suffix, startnewyear)
  VALUES(52002, 0, 0, 'Y', now(), 0, now(), 0, 'U_BlackListCheque', 'Table U_BlackListCheque', NULL, 'Y', 1, 1000000, 1000000, 100, 'N', 'Y', NULL, NULL, 'N');
INSERT INTO AD_SEQUENCE(ad_sequence_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, description, vformat, isautosequence, incrementno, startno, currentnext, currentnextsys, isaudited, istableid, prefix, suffix, startnewyear)
  VALUES(52003, 0, 0, 'Y', now(), 0, now(), 0, 'U_Web_Properties', 'Table U_Web_Properties', NULL, 'Y', 1, 1000000, 1000000, 100, 'N', 'Y', NULL, NULL, 'N');
INSERT INTO AD_SEQUENCE(ad_sequence_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, description, vformat, isautosequence, incrementno, startno, currentnext, currentnextsys, isaudited, istableid, prefix, suffix, startnewyear)
  VALUES(52004, 0, 0, 'Y', now(), 0, now(), 0, 'U_RoleMenu', 'Table U_RoleMenu', NULL, 'Y', 1, 1000000, 1000000, 100, 'N', 'Y', NULL, NULL, 'N');
INSERT INTO AD_SEQUENCE(ad_sequence_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, description, vformat, isautosequence, incrementno, startno, currentnext, currentnextsys, isaudited, istableid, prefix, suffix, startnewyear)
  VALUES(52005, 0, 0, 'Y', now(), 0, now(), 0, 'U_WebMenu', 'Table U_WebMenu', NULL, 'Y', 1, 1000000, 1000000, 100, 'N', 'Y', NULL, NULL, 'N');

-- Element Changes --
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52001, 0, 0, 'Y', now(), 0, now(), 0, 'U_BlackListCheque_ID', 'D', 'U_BlackListCheque_ID', 'U_BlackListCheque_ID', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52002, 0, 0, 'Y', now(), 0, now(), 0, 'BankName', 'D', 'BankName', 'BankName', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52003, 0, 0, 'Y', now(), 0, now(), 0, 'ChequeNo', 'D', 'ChequeNo', 'ChequeNo', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52004, 0, 0, 'Y', now(), 0, now(), 0, 'U_Web_Properties_ID', 'D', 'U_Web_Properties_ID', 'U_Web_Properties_ID', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52005, 0, 0, 'Y', now(), 0, now(), 0, 'U_Key', 'D', 'U_Key', 'U_Key', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52006, 0, 0, 'Y', now(), 0, now(), 0, 'U_Value', 'D', 'U_Value', 'U_Value', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52007, 0, 0, 'Y', now(), 0, now(), 0, 'U_RoleMenu_ID', 'D', 'U_RoleMenu_ID', 'U_RoleMenu_ID', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52008, 0, 0, 'Y', now(), 0, now(), 0, 'U_WebMenu_ID', 'D', 'U_WebMenu_ID', 'U_WebMenu_ID', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52009, 0, 0, 'Y', now(), 0, now(), 0, 'MenuLink', 'D', 'MenuLink', 'MenuLink', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52010, 0, 0, 'Y', now(), 0, now(), 0, 'Module', 'D', 'Module', 'Module', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52011, 0, 0, 'Y', now(), 0, now(), 0, 'ParentMenu_ID', 'D', 'ParentMenu_ID', 'ParentMenu_ID', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52012, 0, 0, 'Y', now(), 0, now(), 0, 'HasSubMenu', 'D', 'HasSubMenu', 'HasSubMenu', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52013, 0, 0, 'Y', now(), 0, now(), 0, 'ImageLink', 'D', 'ImageLink', 'ImageLink', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52014, 0, 0, 'Y', now(), 0, now(), 0, 'Position', 'D', 'Position', 'Position', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52015, 0, 0, 'Y', now(), 0, now(), 0, 'CashDrawer', 'D', 'CashDrawer', 'CashDrawer', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52016, 0, 0, 'Y', now(), 0, now(), 0, 'Sequence', 'D', 'Sequence', 'Sequence', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52017, 0, 0, 'Y', now(), 0, now(), 0, 'Category', 'D', 'Category', 'Category', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52018, 0, 0, 'Y', now(), 0, now(), 0, 'Group1', 'D', 'Group1', 'Group1', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52019, 0, 0, 'Y', now(), 0, now(), 0, 'Group2', 'D', 'Group2', 'Group2', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52020, 0, 0, 'Y', now(), 0, now(), 0, 'OrderType', 'D', 'OrderType', 'OrderType', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52021, 0, 0, 'Y', now(), 0, now(), 0, 'AmountTendered', 'D', 'AmountTendered', 'AmountTendered', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52022, 0, 0, 'Y', now(), 0, now(), 0, 'AmountRefunded', 'D', 'AmountRefunded', 'AmountRefunded', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52023, 0, 0, 'Y', now(), 0, now(), 0, 'UserPIN', 'D', 'UserPIN', 'UserPIN', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52024, 0, 0, 'Y', now(), 0, now(), 0, 'UserDiscount', 'D', 'UserDiscount', 'UserDiscount', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52025, 0, 0, 'Y', now(), 0, now(), 0, 'ClassName', 'D', 'ClassName', 'ClassName', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO AD_ELEMENT(ad_element_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, columnname, entitytype, NAME, printname, description, help, po_name, po_printname, po_description, po_help)
  VALUES(52026, 0, 0, 'Y', now(), 0, now(), 0, 'Args', 'D', 'Args', 'Args', NULL, NULL, NULL, NULL, NULL, NULL);

-- Table Changes --
INSERT INTO AD_TABLE(ad_table_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, description, help, tablename, isview, accesslevel, entitytype, ad_window_id, ad_val_rule_id, loadseq, issecurityenabled, isdeleteable, ishighvolume, importtable, ischangelog, replicationtype, po_window_id, copycolumnsfromtable)
  VALUES(52000, 0, 0, 'Y', now(), 0, now(), 0, 'U_BlackListCheque', NULL, NULL, 'U_BlackListCheque', 'N', '3', 'D', NULL, NULL, NULL, 'N', 'Y', 'N', NULL, 'N', 'L', NULL, NULL);
INSERT INTO AD_TABLE(ad_table_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, description, help, tablename, isview, accesslevel, entitytype, ad_window_id, ad_val_rule_id, loadseq, issecurityenabled, isdeleteable, ishighvolume, importtable, ischangelog, replicationtype, po_window_id, copycolumnsfromtable)
  VALUES(52001, 0, 0, 'Y', now(), 0, now(), 0, 'U_Web_Properties', NULL, NULL, 'U_Web_Properties', 'N', '3', 'D', NULL, NULL, NULL, 'N', 'Y', 'N', NULL, 'N', 'L', NULL, NULL);
INSERT INTO AD_TABLE(ad_table_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, description, help, tablename, isview, accesslevel, entitytype, ad_window_id, ad_val_rule_id, loadseq, issecurityenabled, isdeleteable, ishighvolume, importtable, ischangelog, replicationtype, po_window_id, copycolumnsfromtable)
  VALUES(52002, 0, 0, 'Y', now(), 0, now(), 0, 'U_RoleMenu', NULL, NULL, 'U_RoleMenu', 'N', '3', 'D', NULL, NULL, NULL, 'N', 'Y', 'N', NULL, 'N', 'L', NULL, NULL);
INSERT INTO AD_TABLE(ad_table_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, description, help, tablename, isview, accesslevel, entitytype, ad_window_id, ad_val_rule_id, loadseq, issecurityenabled, isdeleteable, ishighvolume, importtable, ischangelog, replicationtype, po_window_id, copycolumnsfromtable)
  VALUES(52003, 0, 0, 'Y', now(), 0, now(), 0, 'U_WebMenu', NULL, NULL, 'U_WebMenu', 'N', '4', 'D', NULL, NULL, NULL, 'N', 'Y', 'N', NULL, 'N', 'L', NULL, NULL);

-- Reference changes --
INSERT INTO AD_REFERENCE(AD_REFERENCE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, VALIDATIONTYPE, VFORMAT, ENTITYTYPE)
  VALUES(52000, 0, 0, 'Y', now(), 100, now(), 100, 'U_WebMenu_ID', NULL, NULL, 'T', NULL, 'D');

-- Column Changes --
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52011, 0, 0, 'Y', now(), now(), 0, 0, 'U_BlackListCheque_ID', NULL, NULL, 0, 'D', 'U_BlackListCheque_ID', 52000, 13, NULL, NULL, 22, NULL, 'Y', 'N', 'Y', 'N', NULL, 'N', 10, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52001, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52012, 0, 0, 'Y', now(), now(), 0, 0, 'AD_Client_ID', NULL, NULL, 0, 'D', 'AD_Client_ID', 52000, 19, NULL, 129, 22, '@AD_Client_ID@', 'N', 'N', 'Y', 'N', NULL, 'N', 20, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 102, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52013, 0, 0, 'Y', now(), now(), 0, 0, 'AD_Org_ID', NULL, NULL, 0, 'D', 'AD_Org_ID', 52000, 19, NULL, 104, 22, '@AD_Org_ID@', 'N', 'N', 'Y', 'N', NULL, 'N', 30, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 113, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52014, 0, 0, 'Y', now(), now(), 0, 0, 'IsActive', NULL, NULL, 0, 'D', 'IsActive', 52000, 20, NULL, NULL, 1, '''Y'' ', 'N', 'N', 'Y', 'Y', NULL, 'N', 40, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 348, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52015, 0, 0, 'Y', now(), now(), 0, 0, 'Created', NULL, NULL, 0, 'D', 'Created', 52000, 16, NULL, NULL, 7, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 50, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 245, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52016, 0, 0, 'Y', now(), now(), 0, 0, 'CreatedBy', NULL, NULL, 0, 'D', 'CreatedBy', 52000, 18, 110, NULL, 10, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 60, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 246, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52017, 0, 0, 'Y', now(), now(), 0, 0, 'Updated', NULL, NULL, 0, 'D', 'Updated', 52000, 16, NULL, NULL, 7, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 70, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 607, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52018, 0, 0, 'Y', now(), now(), 0, 0, 'UpdatedBy', NULL, NULL, 0, 'D', 'UpdatedBy', 52000, 18, 110, NULL, 10, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 80, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 608, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52019, 0, 0, 'Y', now(), now(), 0, 0, 'BankName', NULL, NULL, 0, 'D', 'BankName', 52000, 10, NULL, NULL, 120, NULL, 'N', 'N', 'Y', 'Y', NULL, 'N', 90, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52002, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52020, 0, 0, 'Y', now(), now(), 0, 0, 'ChequeNo', NULL, NULL, 0, 'D', 'ChequeNo', 52000, 10, NULL, NULL, 120, NULL, 'N', 'N', 'Y', 'Y', NULL, 'N', 100, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52003, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52021, 0, 0, 'Y', now(), now(), 0, 0, 'U_Web_Properties_ID', NULL, NULL, 0, 'D', 'U_Web_Properties_ID', 52001, 13, NULL, NULL, 22, NULL, 'Y', 'N', 'Y', 'N', NULL, 'N', 10, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52004, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52022, 0, 0, 'Y', now(), now(), 0, 0, 'AD_Client_ID', NULL, NULL, 0, 'D', 'AD_Client_ID', 52001, 19, NULL, 129, 22, '@AD_Client_ID@', 'N', 'N', 'Y', 'N', NULL, 'N', 20, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 102, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52023, 0, 0, 'Y', now(), now(), 0, 0, 'AD_Org_ID', NULL, NULL, 0, 'D', 'AD_Org_ID', 52001, 19, NULL, 104, 22, '@AD_Org_ID@', 'N', 'N', 'Y', 'N', NULL, 'N', 30, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 113, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52024, 0, 0, 'Y', now(), now(), 0, 0, 'IsActive', NULL, NULL, 0, 'D', 'IsActive', 52001, 20, NULL, NULL, 1, '''Y'' ', 'N', 'N', 'Y', 'Y', NULL, 'N', 40, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 348, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52025, 0, 0, 'Y', now(), now(), 0, 0, 'Created', NULL, NULL, 0, 'D', 'Created', 52001, 16, NULL, NULL, 7, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 50, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 245, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52026, 0, 0, 'Y', now(), now(), 0, 0, 'CreatedBy', NULL, NULL, 0, 'D', 'CreatedBy', 52001, 18, 110, NULL, NULL, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 60, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 246, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52027, 0, 0, 'Y', now(), now(), 0, 0, 'Updated', NULL, NULL, 0, 'D', 'Updated', 52001, 16, NULL, NULL, 7, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 70, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 607, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52028, 0, 0, 'Y', now(), now(), 0, 0, 'UpdatedBy', NULL, NULL, 0, 'D', 'UpdatedBy', 52001, 18, 110, NULL, NULL, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 80, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 608, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52029, 0, 0, 'Y', now(), now(), 0, 0, 'U_Key', NULL, NULL, 0, 'D', 'U_Key', 52001, 10, NULL, NULL, 240, NULL, 'N', 'N', 'Y', 'Y', NULL, 'N', 90, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52005, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52030, 0, 0, 'Y', now(), now(), 0, 0, 'U_Value', NULL, NULL, 0, 'D', 'U_Value', 52001, 10, NULL, NULL, 240, NULL, 'N', 'N', 'Y', 'Y', NULL, 'N', 100, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52006, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52031, 0, 0, 'Y', now(), now(), 0, 0, 'U_RoleMenu_ID', NULL, NULL, 0, 'D', 'U_RoleMenu_ID', 52002, 13, NULL, NULL, 22, NULL, 'Y', 'N', 'Y', 'N', NULL, 'N', 10, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52007, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52032, 0, 0, 'Y', now(), now(), 0, 0, 'AD_Client_ID', NULL, NULL, 0, 'D', 'AD_Client_ID', 52002, 19, NULL, 129, 22, '@AD_Client_ID@', 'N', 'N', 'Y', 'N', NULL, 'N', 20, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 102, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52033, 0, 0, 'Y', now(), now(), 0, 0, 'AD_Org_ID', NULL, NULL, 0, 'D', 'AD_Org_ID', 52002, 19, NULL, 104, 22, '@AD_Org_ID@', 'N', 'N', 'Y', 'N', NULL, 'N', 30, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 113, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52034, 0, 0, 'Y', now(), now(), 0, 0, 'IsActive', NULL, NULL, 0, 'D', 'IsActive', 52002, 20, NULL, NULL, 1, '''Y'' ', 'N', 'N', 'Y', 'Y', NULL, 'N', 40, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 348, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52035, 0, 0, 'Y', now(), now(), 0, 0, 'Created', NULL, NULL, 0, 'D', 'Created', 52002, 16, NULL, NULL, 7, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 50, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 245, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52036, 0, 0, 'Y', now(), now(), 0, 0, 'CreatedBy', NULL, NULL, 0, 'D', 'CreatedBy', 52002, 18, 110, NULL, NULL, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 60, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 246, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52037, 0, 0, 'Y', now(), now(), 0, 0, 'Updated', NULL, NULL, 0, 'D', 'Updated', 52002, 16, NULL, NULL, 7, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 70, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 607, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52038, 0, 0, 'Y', now(), now(), 0, 0, 'UpdatedBy', NULL, NULL, 0, 'D', 'UpdatedBy', 52002, 18, 110, NULL, NULL, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 80, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 608, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52039, 0, 0, 'Y', now(), now(), 0, 0, 'AD_Role_ID', NULL, NULL, 0, 'D', 'AD_Role_ID', 52002, 19, NULL, NULL, 10, NULL, 'N', 'N', 'Y', 'Y', NULL, 'N', 90, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 123, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52040, 0, 0, 'Y', now(), now(), 0, 0, 'U_WebMenu_ID', NULL, NULL, 0, 'D', 'U_WebMenu_ID', 52002, 19, NULL, NULL, 10, NULL, 'N', 'N', 'Y', 'Y', NULL, 'N', 100, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52008, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52041, 0, 0, 'Y', now(), now(), 0, 0, 'U_WebMenu_ID', NULL, NULL, 0, 'D', 'U_WebMenu_ID', 52003, 13, NULL, NULL, 22, NULL, 'Y', 'N', 'Y', 'N', NULL, 'N', 10, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52008, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52042, 0, 0, 'Y', now(), now(), 0, 0, 'AD_Client_ID', NULL, NULL, 0, 'D', 'AD_Client_ID', 52003, 19, NULL, 129, 22, '@AD_Client_ID@', 'N', 'N', 'Y', 'N', NULL, 'N', 20, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 102, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52043, 0, 0, 'Y', now(), now(), 0, 0, 'AD_Org_ID', NULL, NULL, 0, 'D', 'AD_Org_ID', 52003, 19, NULL, 104, 22, '@AD_Org_ID@', 'N', 'N', 'Y', 'N', NULL, 'N', 30, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 113, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52044, 0, 0, 'Y', now(), now(), 0, 0, 'IsActive', NULL, NULL, 0, 'D', 'IsActive', 52003, 20, NULL, NULL, 1, '''Y'' ', 'N', 'N', 'Y', 'Y', NULL, 'N', 40, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 348, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52045, 0, 0, 'Y', now(), now(), 0, 0, 'Created', NULL, NULL, 0, 'D', 'Created', 52003, 16, NULL, NULL, 7, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 50, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 245, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52046, 0, 0, 'Y', now(), now(), 0, 0, 'CreatedBy', NULL, NULL, 0, 'D', 'CreatedBy', 52003, 18, 110, NULL, 10, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 60, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 246, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52047, 0, 0, 'Y', now(), now(), 0, 0, 'Updated', NULL, NULL, 0, 'D', 'Updated', 52003, 16, NULL, NULL, 7, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 70, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 607, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52048, 0, 0, 'Y', now(), now(), 0, 0, 'UpdatedBy', NULL, NULL, 0, 'D', 'UpdatedBy', 52003, 18, 110, NULL, 10, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', 80, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 608, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52049, 0, 0, 'Y', now(), now(), 0, 0, 'Name', NULL, NULL, 0, 'D', 'Name', 52003, 10, NULL, NULL, 120, NULL, 'N', 'N', 'Y', 'Y', NULL, 'Y', 90, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 469, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52050, 0, 0, 'Y', now(), now(), 0, 0, 'MenuLink', NULL, NULL, 0, 'D', 'MenuLink', 52003, 10, NULL, NULL, 510, NULL, 'N', 'N', 'Y', 'Y', NULL, 'N', 100, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52009, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52051, 0, 0, 'Y', now(), now(), 0, 0, 'Module', NULL, NULL, 0, 'D', 'Module', 52003, 10, NULL, NULL, 120, NULL, 'N', 'N', 'Y', 'Y', NULL, 'N', 110, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52010, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52052, 0, 0, 'Y', now(), now(), 0, 0, 'ParentMenu_ID', NULL, NULL, 0, 'D', 'ParentMenu_ID', 52003, 18, 52000, NULL, 10, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 120, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52011, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52053, 0, 0, 'Y', now(), now(), 0, 0, 'HasSubMenu', NULL, NULL, 0, 'D', 'HasSubMenu', 52003, 20, NULL, NULL, 1, '''N''', 'N', 'N', 'Y', 'Y', NULL, 'N', 130, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52012, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52054, 0, 0, 'Y', now(), now(), 0, 0, 'Description', NULL, NULL, 0, 'D', 'Description', 52003, 10, NULL, NULL, 200, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 140, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 275, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52055, 0, 0, 'Y', now(), now(), 0, 0, 'ImageLink', NULL, NULL, 0, 'D', 'ImageLink', 52003, 10, NULL, NULL, 510, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 150, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52013, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52056, 0, 0, 'Y', now(), now(), 0, 0, 'Position', NULL, NULL, 0, 'D', 'Position', 52003, 10, NULL, NULL, 10, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 160, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52014, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52057, 0, 0, 'Y', now(), now(), 0, 0, 'Help', NULL, NULL, 0, 'D', 'Help', 52003, 10, NULL, NULL, 2000, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 170, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 326, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52058, 0, 0, 'Y', now(), now(), 0, 0, 'CashDrawer', NULL, NULL, 0, 'D', 'CashDrawer', 748, 10, NULL, NULL, 120, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 10, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52015, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52059, 0, 0, 'Y', now(), now(), 0, 0, 'Sequence', NULL, NULL, 0, 'D', 'Sequence', 52003, 22, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 10, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52016, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52060, 0, 0, 'Y', now(), now(), 0, 0, 'Category', NULL, NULL, 0, 'D', 'Category', 52003, 10, NULL, NULL, 120, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 20, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52017, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52061, 0, 0, 'Y', now(), now(), 0, 0, 'Group1', NULL, NULL, 0, 'D', 'Group1', 208, 10, NULL, NULL, 255, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 50, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52018, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52062, 0, 0, 'Y', now(), now(), 0, 0, 'Group2', NULL, NULL, 0, 'D', 'Group2', 208, 10, NULL, NULL, 255, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 60, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52019, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52063, 0, 0, 'Y', now(), now(), 0, 0, 'OrderType', NULL, NULL, 0, 'D', 'OrderType', 259, 10, NULL, NULL, 510, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 10, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52020, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52064, 0, 0, 'Y', now(), now(), 0, 0, 'AmountTendered', NULL, NULL, 0, 'D', 'AmountTendered', 259, 22, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 30, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52021, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52065, 0, 0, 'Y', now(), now(), 0, 0, 'AmountRefunded', NULL, NULL, 0, 'D', 'AmountRefunded', 259, 22, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 40, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52022, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52066, 0, 0, 'Y', now(), now(), 0, 0, 'UserPIN', NULL, NULL, 0, 'D', 'UserPIN', 114, 10, NULL, NULL, 20, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 10, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52023, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52067, 0, 0, 'Y', now(), now(), 0, 0, 'UserDiscount', NULL, NULL, 0, 'D', 'UserDiscount', 156, 22, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 20, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52024, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52068, 0, 0, 'Y', now(), now(), 0, 0, 'ClassName', NULL, NULL, 0, 'D', 'ClassName', 493, 10, NULL, NULL, 240, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 10, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52025, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52069, 0, 0, 'Y', now(), now(), 0, 0, 'Args', NULL, NULL, 0, 'D', 'Args', 493, 10, NULL, NULL, 510, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 20, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 52026, NULL, 'N', 'N', NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql)
  VALUES(52070, 0, 0, 'Y', now(), now(), 0, 0, 'C_POS_ID', NULL, NULL, 0, 'D', 'C_POS_ID', 259, 19, NULL, NULL, 10, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 20, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 2581, NULL, 'N', 'N', NULL);

-- AD_Ref_table Changes --

INSERT INTO AD_REF_TABLE(AD_REFERENCE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, AD_TABLE_ID, AD_KEY, AD_DISPLAY, ISVALUEDISPLAYED, WHERECLAUSE, ORDERBYCLAUSE, ENTITYTYPE)
  VALUES(52000, 0, 0, 'Y', now(), 100, now(), 100, 52003, 52041, 52049, 'N', NULL, NULL, 'D');

-- Process Changes --
INSERT INTO AD_PROCESS(ad_process_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, NAME, description, help, accesslevel, entitytype, procedurename, isreport, isdirectprint, ad_reportview_id, classname, statistic_count, statistic_seconds, ad_printformat_id, workflowvalue, ad_workflow_id, isbetafunctionality, isserverprocess, showhelp, jasperreport)
  VALUES(52003, 0, 0, 'Y', now(), 100, now(), 100, 'U_RoleMenu_Update', 'Update Role Menu', NULL, NULL, '3', 'D', NULL, 'N', 'N', NULL, 'org.adempiere.process.UpdateRoleMenu', 0, 0, NULL, NULL, NULL, 'N', 'N', 'Y', NULL);

INSERT INTO AD_PROCESS_PARA(ad_process_para_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, description, help, ad_process_id, seqno, ad_reference_id, ad_reference_value_id, ad_val_rule_id, columnname, iscentrallymaintained, fieldlength, ismandatory, isrange, defaultvalue, defaultvalue2, vformat, valuemin, valuemax, ad_element_id, entitytype)
  VALUES(52000, 0, 0, 'Y', now(), 100, now(), 100, 'Role', NULL, NULL, 52003, 10, 30, NULL, NULL, 'AD_Role_ID', 'Y', 0, 'Y', 'N', NULL, NULL, NULL, NULL, NULL, 123, 'D');

-- Process Access --
INSERT INTO AD_PROCESS_ACCESS(ad_process_id, ad_role_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, isreadwrite)
  VALUES(52003, 0, 0, 0, 'Y', now(), 100, now(), 100, 'Y');
INSERT INTO AD_PROCESS_ACCESS(ad_process_id, ad_role_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, isreadwrite)
  VALUES(52003, 102, 0, 0, 'Y', now(), 100, now(), 100, 'Y');
INSERT INTO AD_PROCESS_ACCESS(ad_process_id, ad_role_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, isreadwrite)
  VALUES(52003, 103, 0, 0, 'Y',now(), 100, now(), 100, 'Y');

-- Menu Changes --
INSERT INTO AD_MENU(ad_menu_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, NAME, updatedby, description, issummary, issotrx, isreadonly, action, ad_window_id, ad_workflow_id, ad_task_id, ad_process_id, ad_form_id, ad_workbench_id, entitytype)
  VALUES(52000, 0, 0, 'Y', now(), 100, now(), 'Update Role Menu', 100, NULL, 'N', 'N', 'N', 'P', NULL, NULL, NULL, 52003, NULL, NULL, 'D');
INSERT INTO AD_MENU(ad_menu_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, NAME, updatedby, description, issummary, issotrx, isreadonly, action, ad_window_id, ad_workflow_id, ad_task_id, ad_process_id, ad_form_id, ad_workbench_id, entitytype)
  VALUES(52001, 0, 0, 'Y', now(), 100, now(), 'Posterita', 100, NULL, 'Y', 'N', 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'D');
INSERT INTO AD_TREENODEMM(ad_tree_id, node_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, parent_id, seqno)
  VALUES(10, 52000, 0, 0, 'Y', now(), 0, now(), 0, 52001, 0);
INSERT INTO AD_TREENODEMM(ad_tree_id, node_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, parent_id, seqno)
  VALUES(10, 52001, 0, 0, 'Y', now(), 0, now(), 0, 0, 10);




-- Message Changes --
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52003, 0, 0, 'Y', now(), 100, now(), 100, '1000_rupees', '1000 Rupees', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52004, 0, 0, 'Y', now(), 100, now(), 100, '100_dollars', '100 dollars', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52005, 0, 0, 'Y', now(), 100, now(), 100, '100_rupees', '100 Rupees', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52006, 0, 0, 'Y', now(), 100, now(), 100, '10_dollars', '10 dollars', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52007, 0, 0, 'Y', now(), 100, now(), 100, '10_rupees', '10 Rupees', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52008, 0, 0, 'Y', now(), 100, now(), 100, '1_cent', '1 cent', '1 cent', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52009, 0, 0, 'Y', now(), 100, now(), 100, '1_dollar', '1 dollar', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(520010, 0, 0, 'Y', now(), 100, now(), 100, '1_rupee', '1 Rupee', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52011, 0, 0, 'Y', now(), 100, now(), 100, '2000_rupees', '2000 Rupees', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52012, 0, 0, 'Y', now(), 100, now(), 100, '200_rupees', '200 Rupees', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52013, 0, 0, 'Y', now(), 100, now(), 100, '20_cents', '20 cents', '20 cents', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52014, 0, 0, 'Y', now(), 100, now(), 100, '20_dollars', '20 dollars', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52015, 0, 0, 'Y', now(), 100, now(), 100, '25_rupees', '25 Rupees', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52016, 0, 0, 'Y', now(), 100, now(), 100, '500_rupees', '500 Rupees', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52017, 0, 0, 'Y', now(), 100, now(), 100, '50_cents', '50 cents', '50 cents', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52018, 0, 0, 'Y', now(), 100, now(), 100, '50_dollars', '50 dollars', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52019, 0, 0, 'Y', now(), 100, now(), 100, '50_rupees', '50 Rupees', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52020, 0, 0, 'Y', now(), 100, now(), 100, '5_cents', '5 cents', '5 cents', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52021, 0, 0, 'Y', now(), 100, now(), 100, '5_dollars', '5 dollars', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52022, 0, 0, 'Y', now(), 100, now(), 100, '5_rupees', '5 Rupees', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52023, 0, 0, 'Y', now(), 100, now(), 100, 'Due0', 'Due 0', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52024, 0, 0, 'Y', now(), 100, now(), 100, 'Due0_30', 'Due 0-30', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52025, 0, 0, 'Y', now(), 100, now(), 100, 'account.type', 'Account Type', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52026, 0, 0, 'Y', now(), 100, now(), 100, 'accounts.receivable', 'Accounts Receivable-Trade', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52027, 0, 0, 'Y', now(), 100, now(), 100, 'activate', 'Activate', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52028, 0, 0, 'Y', now(), 100, now(), 100, 'activate.vendor', 'Activate Vendor', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52029, 0, 0, 'Y', now(), 100, now(), 100, 'actual.price', 'Actual Price', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52030, 0, 0, 'Y', now(), 100, now(), 100, 'add', 'Add', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52031, 0, 0, 'Y', now(), 100, now(), 100, 'add.black.listed.cheque', 'Add Black Listed Cheque', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52032, 0, 0, 'Y', now(), 100, now(), 100, 'add.customer.fidelity.card', 'Add Customer for fidelity card', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52033, 0, 0, 'Y', now(), 100, now(), 100, 'add.customer.for.fidelity.card', 'Add Customer for fidelity card', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52034, 0, 0, 'Y', now(), 100, now(), 100, 'add.record', 'Add Record', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52035, 0, 0, 'Y', now(), 100, now(), 100, 'add.to.cart', 'Add To Cart', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52036, 0, 0, 'Y', now(), 100, now(), 100, 'address', 'Address', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52037, 0, 0, 'Y', now(), 100, now(), 100, 'adjust.cash.book', 'Adjust Cash Book', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52038, 0, 0, 'Y', now(), 100, now(), 100, 'advanced', 'Advanced', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52039, 0, 0, 'Y', now(), 100, now(), 100, 'aging', 'Aging', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52040, 0, 0, 'Y', now(), 100, now(), 100, 'ajax.error', 'Some error occured while communicating with the server. Please try again.', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52041, 0, 0, 'Y', now(), 100, now(), 100, 'all', 'All', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52042, 0, 0, 'Y', now(), 100, now(), 100, 'all.products', 'All products', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52043, 0, 0, 'Y', now(), 100, now(), 100, 'amount.difference', 'Difference', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52044, 0, 0, 'Y', now(), 100, now(), 100, 'amount.expense', 'Expense', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52045, 0, 0, 'Y', now(), 100, now(), 100, 'amount.receipt', 'Receipt', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52046, 0, 0, 'Y', now(), 100, now(), 100, 'amount.refunded', 'Amount refunded', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52047, 0, 0, 'Y', now(), 100, now(), 100, 'amount.tendered', 'Amount Tendered', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52048, 0, 0, 'Y', now(), 100, now(), 100, 'amount.transfer', 'Transfer', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52049, 0, 0, 'Y', now(), 100, now(), 100, 'application.name', 'Application Name', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52050, 0, 0, 'Y', now(), 100, now(), 100, 'application.version', 'Application Version', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52051, 0, 0, 'Y', now(), 100, now(), 100, 'asset', 'Assets', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52052, 0, 0, 'Y', now(), 100, now(), 100, 'at.least.one', 'At least one', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52053, 0, 0, 'Y', now(), 100, now(), 100, 'attach.image', 'Attach Image', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52054, 0, 0, 'Y', now(), 100, now(), 100, 'attribute', 'Attribute', 'Attribute', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52055, 0, 0, 'Y', now(), 100, now(), 100, 'attribute.set', 'Attribute Set', 'Attribute Set', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52056, 0, 0, 'Y', now(), 100, now(), 100, 'available.menu', 'Available Menus', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52057, 0, 0, 'Y', now(), 100, now(), 100, 'back', 'Back', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52058, 0, 0, 'Y', now(), 100, now(), 100, 'barcode', 'Barcode', 'Barcode', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52059, 0, 0, 'Y', now(), 100, now(), 100, 'barcode.already.exists', 'Barcode already exists!', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52060, 0, 0, 'Y', now(), 100, now(), 100, 'black.listed.cheques', 'Black Listed Cheques', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52061, 0, 0, 'Y', now(), 100, now(), 100, 'bpartner.info', 'Business Partner Info', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52062, 0, 0, 'Y', now(), 100, now(), 100, 'bpartner.trx.details', 'Business Partner Trx Details', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52063, 0, 0, 'Y', now(), 100, now(), 100, 'brand', 'Brand', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52064, 0, 0, 'Y', now(), 100, now(), 100, 'cal.period.curr', 'Calculation Period And Curr.', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52065, 0, 0, 'Y', now(), 100, now(), 100, 'card', 'Card', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52066, 0, 0, 'Y', now(), 100, now(), 100, 'card.amount', 'Card Amount', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52067, 0, 0, 'Y', now(), 100, now(), 100, 'card.amt.entered', 'Card Amount Entered', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52068, 0, 0, 'Y', now(), 100, now(), 100, 'card.amt.tendered', 'Card amount tendered', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52069, 0, 0, 'Y', now(), 100, now(), 100, 'card.amt.total', 'Card Amount Total', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52070, 0, 0, 'Y', now(), 100, now(), 100, 'card.is.empty', 'The Cart is Empty !', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52071, 0, 0, 'Y', now(), 100, now(), 100, 'card.no', 'Card No', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52072, 0, 0, 'Y', now(), 100, now(), 100, 'card.total', 'Card Total', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52073, 0, 0, 'Y', now(), 100, now(), 100, 'cart.addmore', 'Add More', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52074, 0, 0, 'Y', now(), 100, now(), 100, 'cart.empty', 'Cart is empty!', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52075, 0, 0, 'Y', now(), 100, now(), 100, 'cart.has', 'Cart has', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52076, 0, 0, 'Y', now(), 100, now(), 100, 'cart.items', ' items', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52077, 0, 0, 'Y', now(), 100, now(), 100, 'cart.remove', 'Remove', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52078, 0, 0, 'Y', now(), 100, now(), 100, 'cash', 'Cash', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52079, 0, 0, 'Y', now(), 100, now(), 100, 'cash.amount', 'Cash Amount', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52080, 0, 0, 'Y', now(), 100, now(), 100, 'cash.book', 'Cash Book', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52081, 0, 0, 'Y', now(), 100, now(), 100, 'cash.book.adjust', 'The Cash Book has been adjusted.', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52082, 0, 0, 'Y', now(), 100, now(), 100, 'cash.book.adjusted', 'The Cash Book has been adjusted', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52083, 0, 0, 'Y', now(), 100, now(), 100, 'cash.book.history', 'Cash Book History', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52084, 0, 0, 'Y', now(), 100, now(), 100, 'cash.line.detail', 'Cash Line Details', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52085, 0, 0, 'Y', now(), 100, now(), 100, 'cash.payment', 'Cash Payment', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52086, 0, 0, 'Y', now(), 100, now(), 100, 'cash.receipt', 'Cash Receipt', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52087, 0, 0, 'Y', now(), 100, now(), 100, 'cash.refunded', 'Cash refunded', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52088, 0, 0, 'Y', now(), 100, now(), 100, 'cash.tendered', 'Cash tendered', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52089, 0, 0, 'Y', now(), 100, now(), 100, 'cash.to.transfer', 'Cash to transfer', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52090, 0, 0, 'Y', now(), 100, now(), 100, 'cash.total', 'Cash Total', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52091, 0, 0, 'Y', now(), 100, now(), 100, 'cellphone', 'Cellphone', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52092, 0, 0, 'Y', now(), 100, now(), 100, 'checkout', 'Checkout', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52093, 0, 0, 'Y', now(), 100, now(), 100, 'cheque', 'Cheque', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52094, 0, 0, 'Y', now(), 100, now(), 100, 'cheque.amount', 'Cheque Amount', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52095, 0, 0, 'Y', now(), 100, now(), 100, 'cheque.amt.entered', 'Cheque Amount Entered', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52096, 0, 0, 'Y', now(), 100, now(), 100, 'cheque.amt.tendered', 'Cheque amount tendered', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52097, 0, 0, 'Y', now(), 100, now(), 100, 'cheque.amt.total', 'Cheque Amount Total', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52098, 0, 0, 'Y', now(), 100, now(), 100, 'cheque.no', 'Cheque No', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52099, 0, 0, 'Y', now(), 100, now(), 100, 'cheque.total', 'Cheque Total', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52100, 0, 0, 'Y', now(), 100, now(), 100, 'choose.attribute', 'Choose Attribute', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52101, 0, 0, 'Y', now(), 100, now(), 100, 'choose.your.till', 'Please choose your till number', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52102, 0, 0, 'Y', now(), 100, now(), 100, 'clear', 'Clear', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52103, 0, 0, 'Y', now(), 100, now(), 100, 'close', 'Close', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52104, 0, 0, 'Y', now(), 100, now(), 100, 'close.till', 'Close Till', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52105, 0, 0, 'Y', now(), 100, now(), 100, 'closed', 'Closed', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52106, 0, 0, 'Y', now(), 100, now(), 100, 'closing.balance', 'Closing Balance', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52107, 0, 0, 'Y', now(), 100, now(), 100, 'cogs', 'CoGS', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52108, 0, 0, 'Y', now(), 100, now(), 100, 'colour', 'Colour', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52109, 0, 0, 'Y', now(), 100, now(), 100, 'commission.details', 'Commission Details', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52110, 0, 0, 'Y', now(), 100, now(), 100, 'completed', 'Completed', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52111, 0, 0, 'Y', now(), 100, now(), 100, 'continue', 'Continue', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52112, 0, 0, 'Y', now(), 100, now(), 100, 'create.bpartner', 'Create Business Partner', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52113, 0, 0, 'Y', now(), 100, now(), 100, 'create.garment', 'Create Garment', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52114, 0, 0, 'Y', now(), 100, now(), 100, 'create.payment', 'Create Payment', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52115, 0, 0, 'Y', now(), 100, now(), 100, 'credit.check', 'Credit Check', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52116, 0, 0, 'Y', now(), 100, now(), 100, 'credit.details', 'Credit Details', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52117, 0, 0, 'Y', now(), 100, now(), 100, 'credit.hold', 'Credit Hold', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52118, 0, 0, 'Y', now(), 100, now(), 100, 'credit.memo', 'Credit Memo', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52119, 0, 0, 'Y', now(), 100, now(), 100, 'credit.ok', 'Credit OK', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52120, 0, 0, 'Y', now(), 100, now(), 100, 'credit.order', 'Credit Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52121, 0, 0, 'Y', now(), 100, now(), 100, 'credit.order.discount', 'Credit Order Discount', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52122, 0, 0, 'Y', now(), 100, now(), 100, 'credit.stop', 'Credit Stop', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52123, 0, 0, 'Y', now(), 100, now(), 100, 'credit.watch', 'Credit Watch', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52124, 0, 0, 'Y', now(), 100, now(), 100, 'current.month', 'Current Month', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52125, 0, 0, 'Y', now(), 100, now(), 100, 'current.till.amount', 'Current Till Amount', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52126, 0, 0, 'Y', now(), 100, now(), 100, 'current.week', 'Current Week', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52127, 0, 0, 'Y', now(), 100, now(), 100, 'current.year', 'Current Year', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52128, 0, 0, 'Y', now(), 100, now(), 100, 'custom', 'Custom', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52129, 0, 0, 'Y', now(), 100, now(), 100, 'custom.sales.reports', 'Custom Sales Report', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52130, 0, 0, 'Y', now(), 100, now(), 100, 'customer', 'Customer', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52131, 0, 0, 'Y', now(), 100, now(), 100, 'customer.id', 'Customer ID', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52132, 0, 0, 'Y', now(), 100, now(), 100, 'customer.info', 'Customer Info', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52133, 0, 0, 'Y', now(), 100, now(), 100, 'customer.returned.order', 'Customer Returned Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52134, 0, 0, 'Y', now(), 100, now(), 100, 'customervendor', 'Customer/Vendor', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52135, 0, 0, 'Y', now(), 100, now(), 100, 'date.created', 'Date Created', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52136, 0, 0, 'Y', now(), 100, now(), 100, 'date.from', 'From', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52137, 0, 0, 'Y', now(), 100, now(), 100, 'date.ordered', 'Date Ordered', 'Date Ordered', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52138, 0, 0, 'Y', now(), 100, now(), 100, 'date.range', 'Date Range', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52139, 0, 0, 'Y', now(), 100, now(), 100, 'date.to', 'to', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52140, 0, 0, 'Y', now(), 100, now(), 100, 'deactivate', 'De-activate', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52141, 0, 0, 'Y', now(), 100, now(), 100, 'deactivate.vendor', 'Deactivate Vendor', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52142, 0, 0, 'Y', now(), 100, now(), 100, 'dealer.name', 'Dealer Name', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52143, 0, 0, 'Y', now(), 100, now(), 100, 'default', 'Default', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52144, 0, 0, 'Y', now(), 100, now(), 100, 'delete', 'Delete', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52145, 0, 0, 'Y', now(), 100, now(), 100, 'delete.selected', 'Delete Selected', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52146, 0, 0, 'Y', now(), 100, now(), 100, 'design', 'Design', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52147, 0, 0, 'Y', now(), 100, now(), 100, 'discount.amt', 'Discount', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52148, 0, 0, 'Y', now(), 100, now(), 100, 'discounted.price', 'Discounted Price', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52149, 0, 0, 'Y', now(), 100, now(), 100, 'display', 'Display', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52150, 0, 0, 'Y', now(), 100, now(), 100, 'display.all.records', 'Do you want to display all records?', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52151, 0, 0, 'Y', now(), 100, now(), 100, 'doc.basis.type', 'Doc Basis Type', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52152, 0, 0, 'Y', now(), 100, now(), 100, 'download.csv', 'Download CSV', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52153, 0, 0, 'Y', now(), 100, now(), 100, 'drafted', 'Drafted', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52154, 0, 0, 'Y', now(), 100, now(), 100, 'dunning.letters.printed.successfully', 'Dunning letters have been printed successfully', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52155, 0, 0, 'Y', now(), 100, now(), 100, 'edit', 'Edit', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52156, 0, 0, 'Y', now(), 100, now(), 100, 'edit.attribute', 'Edit Attribute', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52157, 0, 0, 'Y', now(), 100, now(), 100, 'edit.black.listed.cheque', 'Edit Black Listed Cheque', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52158, 0, 0, 'Y', now(), 100, now(), 100, 'edit.customer', 'Edit Customer', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52159, 0, 0, 'Y', now(), 100, now(), 100, 'edit.price', 'Edit Price', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52160, 0, 0, 'Y', now(), 100, now(), 100, 'edit.price.list', 'Edit Price List', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52161, 0, 0, 'Y', now(), 100, now(), 100, 'edit.product', 'Edit Product', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52162, 0, 0, 'Y', now(), 100, now(), 100, 'edit.related.products', 'Edit related products details', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52163, 0, 0, 'Y', now(), 100, now(), 100, 'edit.role', 'Edit Role', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52164, 0, 0, 'Y', now(), 100, now(), 100, 'edit.user', 'Edit User', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52165, 0, 0, 'Y', now(), 100, now(), 100, 'edit.vendor', 'Edit Vendor', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52166, 0, 0, 'Y', now(), 100, now(), 100, 'enable.printing', 'Enable printing', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52167, 0, 0, 'Y', now(), 100, now(), 100, 'enter', 'ENTER', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52168, 0, 0, 'Y', now(), 100, now(), 100, 'excl.vat', '(excl. VAT)', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52169, 0, 0, 'Y', now(), 100, now(), 100, 'fast.moving.item', 'Fast Moving Items Report', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52170, 0, 0, 'Y', now(), 100, now(), 100, 'fast.moving.item.current.month', 'Fast Moving Items Report (Current Month)', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52171, 0, 0, 'Y', now(), 100, now(), 100, 'fast.moving.item.today', 'Fast Moving Items Report (Today)', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52172, 0, 0, 'Y', now(), 100, now(), 100, 'filter.by', 'Filter By', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52173, 0, 0, 'Y', now(), 100, now(), 100, 'filter.type', 'Choose the type of filter', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52174, 0, 0, 'Y', now(), 100, now(), 100, 'first', 'First', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52175, 0, 0, 'Y', now(), 100, now(), 100, 'fixed', 'Fixed', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52176, 0, 0, 'Y', now(), 100, now(), 100, 'float.amt.change', 'This is the float amount for today. Please Enter float amount for the next day if needs to be changed.', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52177, 0, 0, 'Y', now(), 100, now(), 100, 'footer.copyright', 'All Contents ©', '2006 Tamak ICT', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52178, 0, 0, 'Y', now(), 100, now(), 100, 'found.none', 'Found None', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52179, 0, 0, 'Y', now(), 100, now(), 100, 'from', 'From', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52180, 0, 0, 'Y', now(), 100, now(), 100, 'garment.template', 'Garment Template', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52181, 0, 0, 'Y', now(), 100, now(), 100, 'generate.commission', 'Generate Commission', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52182, 0, 0, 'Y', now(), 100, now(), 100, 'goods.received.note', 'Goods Received Note', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52183, 0, 0, 'Y', now(), 100, now(), 100, 'goods.returned.note', 'Goods Returned Note', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52184, 0, 0, 'Y', now(), 100, now(), 100, 'hide.details', 'Hide Details', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52185, 0, 0, 'Y', now(), 100, now(), 100, 'import.black.listed', 'Import Black Listed Cheques', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52186, 0, 0, 'Y', now(), 100, now(), 100, 'import.blacklisted.message1', 'This utility is to import the a list of Black Listed Cheques from a csv file into the system,<br>The csv file should look like the one shown below including the header:', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52187, 0, 0, 'Y', now(), 100, now(), 100, 'import.list', 'Import List', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52188, 0, 0, 'Y', now(), 100, now(), 100, 'import.product.message', 'This utility is to import the products and Stock in Hand from a csv file into the system,<br> For importing the garment products, the CSV file name should containg the word ''Garment'' <br>The csv file should look like the one shown below including the header', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52189, 0, 0, 'Y', now(), 100, now(), 100, 'incl.vat', '(incl. VAT)', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52190, 0, 0, 'Y', now(), 100, now(), 100, 'inprogress', 'InProgress', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52191, 0, 0, 'Y', now(), 100, now(), 100, 'invalid', 'Invalid', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52192, 0, 0, 'Y', now(), 100, now(), 100, 'invoice.no', 'Invoice No', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52193, 0, 0, 'Y', now(), 100, now(), 100, 'invoke', 'Invoke', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52194, 0, 0, 'Y', now(), 100, now(), 100, 'invoke.customer.returned.order', 'Invoke', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52195, 0, 0, 'Y', now(), 100, now(), 100, 'invoke.partial', 'Invoke Partial POS Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52196, 0, 0, 'Y', now(), 100, now(), 100, 'items', 'Items', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52197, 0, 0, 'Y', now(), 100, now(), 100, 'last', 'Last', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52198, 0, 0, 'Y', now(), 100, now(), 100, 'last.2.months', 'Last 2 Months', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52199, 0, 0, 'Y', now(), 100, now(), 100, 'last.2.weeks', 'Last 2 Weeks', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52200, 0, 0, 'Y', now(), 100, now(), 100, 'last.3.months', 'Last 3 Months', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52201, 0, 0, 'Y', now(), 100, now(), 100, 'last.3.weeks', 'Last 3 Weeks', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52202, 0, 0, 'Y', now(), 100, now(), 100, 'last.6.month', 'Last 6 Months', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52203, 0, 0, 'Y', now(), 100, now(), 100, 'license.name', 'License Name', 'License Name', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52204, 0, 0, 'Y', now(), 100, now(), 100, 'license.valid', 'License Valid', 'License Valid', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52205, 0, 0, 'Y', now(), 100, now(), 100, 'licensed.distribution', 'Licensed Distribution', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52206, 0, 0, 'Y', now(), 100, now(), 100, 'licensed.module', 'Licensed Modules', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52207, 0, 0, 'Y', now(), 100, now(), 100, 'licensing.info', 'Licensing Information', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52208, 0, 0, 'Y', now(), 100, now(), 100, 'list', 'List', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52209, 0, 0, 'Y', now(), 100, now(), 100, 'login.home.all.contents', 'All content', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52210, 0, 0, 'Y', now(), 100, now(), 100, 'login.home.loginForgot', 'Forgot password?', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52211, 0, 0, 'Y', now(), 100, now(), 100, 'login.home.message1', 'Please enter your username and password', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52212, 0, 0, 'Y', now(), 100, now(), 100, 'login.home.message2', 'Please enter PIN', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52213, 0, 0, 'Y', now(), 100, now(), 100, 'login.home.password', 'Password', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52214, 0, 0, 'Y', now(), 100, now(), 100, 'login.home.username', 'Username', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52215, 0, 0, 'Y', now(), 100, now(), 100, 'login.password.backToLogin', ' ', ' Click Here to go back to the Login Screen', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52216, 0, 0, 'Y', now(), 100, now(), 100, 'login.password.passwordSent', 'Your password has been sent you should receive it in a few minutes', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52217, 0, 0, 'Y', now(), 100, now(), 100, 'marked.price', 'Marked Price', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52218, 0, 0, 'Y', now(), 100, now(), 100, 'max.active.users', 'Max Active Users', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52219, 0, 0, 'Y', now(), 100, now(), 100, 'max.sold.item', 'Max sold Item', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52220, 0, 0, 'Y', now(), 100, now(), 100, 'menus', 'Menus', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52221, 0, 0, 'Y', now(), 100, now(), 100, 'min.item.sold', 'Min Item Sold', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52222, 0, 0, 'Y', now(), 100, now(), 100, 'mixed', 'Mixed', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52223, 0, 0, 'Y', now(), 100, now(), 100, 'mobile', 'Moblie No', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52224, 0, 0, 'Y', now(), 100, now(), 100, 'model', 'Model', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52225, 0, 0, 'Y', now(), 100, now(), 100, 'month', 'Month', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52226, 0, 0, 'Y', now(), 100, now(), 100, 'net.amt', 'Net Amount', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52227, 0, 0, 'Y', now(), 100, now(), 100, 'net.cash.trx', 'Net Cash Trx', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52228, 0, 0, 'Y', now(), 100, now(), 100, 'net.transaction', 'Net Transaction', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52229, 0, 0, 'Y', now(), 100, now(), 100, 'new.attribute.value', 'New Attribute Value', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52230, 0, 0, 'Y', now(), 100, now(), 100, 'new.credit.order', 'New Credit Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52231, 0, 0, 'Y', now(), 100, now(), 100, 'new.customer', 'New Customer', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52232, 0, 0, 'Y', now(), 100, now(), 100, 'new.customer.return.order', 'New Customer Return Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52233, 0, 0, 'Y', now(), 100, now(), 100, 'new.goods.received.note', 'New Goods Receive Note', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52234, 0, 0, 'Y', now(), 100, now(), 100, 'new.goods.returned.note', 'New Goods Returned Note', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52235, 0, 0, 'Y', now(), 100, now(), 100, 'new.order', 'New Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52236, 0, 0, 'Y', now(), 100, now(), 100, 'new.price', 'New Price', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52237, 0, 0, 'Y', now(), 100, now(), 100, 'no', 'No', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52238, 0, 0, 'Y', now(), 100, now(), 100, 'no.customer.was.found.for', 'No customer was found for', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52239, 0, 0, 'Y', now(), 100, now(), 100, 'no.shipment', 'No Shipment', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52240, 0, 0, 'Y', now(), 100, now(), 100, 'no.vendor.was.found.for', 'No vendor was found for', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52241, 0, 0, 'Y', now(), 100, now(), 100, 'normal.template', 'Normal Template', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52242, 0, 0, 'Y', now(), 100, now(), 100, 'not.authorised.to.give.discount', 'It seems that you are not authorised to give discounts', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52243, 0, 0, 'Y', now(), 100, now(), 100, 'not.found', 'Not Found', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52244, 0, 0, 'Y', now(), 100, now(), 100, 'notes', 'Notes', 'Notes', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52245, 0, 0, 'Y', now(), 100, now(), 100, 'num.active.users', 'No of Active Users', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52246, 0, 0, 'Y', now(), 100, now(), 100, 'num.operations', 'Number of Operations', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52247, 0, 0, 'Y', now(), 100, now(), 100, 'old.attribute.value', 'Old Attribute Value', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52248, 0, 0, 'Y', now(), 100, now(), 100, 'open.invoices', 'Open Invoices', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52249, 0, 0, 'Y', now(), 100, now(), 100, 'opening.balance', 'Opening Balance', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52250, 0, 0, 'Y', now(), 100, now(), 100, 'order.no', 'Order No', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52251, 0, 0, 'Y', now(), 100, now(), 100, 'order.type', 'Order Type', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52252, 0, 0, 'Y', now(), 100, now(), 100, 'organisation.name', 'Organisations', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52253, 0, 0, 'Y', now(), 100, now(), 100, 'partial.pos.order', 'Partial POS Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52254, 0, 0, 'Y', now(), 100, now(), 100, 'partial.pos.order.history', 'Partial POS Order History', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52255, 0, 0, 'Y', now(), 100, now(), 100, 'payment.allocation', 'Payment Allocation', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52256, 0, 0, 'Y', now(), 100, now(), 100, 'payment.by', 'Payment By', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52257, 0, 0, 'Y', now(), 100, now(), 100, 'payment.details', 'Payment Details', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52258, 0, 0, 'Y', now(), 100, now(), 100, 'payment.num', 'Payment No', 'Payment No', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52259, 0, 0, 'Y', now(), 100, now(), 100, 'payment.status', 'Payment Status', 'Payment Status', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52260, 0, 0, 'Y', now(), 100, now(), 100, 'payment.terms', 'Payment Terms', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52261, 0, 0, 'Y', now(), 100, now(), 100, 'payment.type', 'Payment Type', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52262, 0, 0, 'Y', now(), 100, now(), 100, 'periodic.cash.details', 'Periodic Cash Book Details', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52263, 0, 0, 'Y', now(), 100, now(), 100, 'please.enter.pin', 'Please enter PIN', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52264, 0, 0, 'Y', now(), 100, now(), 100, 'pmenu.administration', 'Administration', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52265, 0, 0, 'Y', now(), 100, now(), 100, 'pmenu.cash.sales', 'Cash Sales', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52266, 0, 0, 'Y', now(), 100, now(), 100, 'pmenu.credit.sales', 'Credit Sales', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52267, 0, 0, 'Y', now(), 100, now(), 100, 'pmenu.performance.analysis', 'Performance Analysis', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52268, 0, 0, 'Y', now(), 100, now(), 100, 'pmenu.purchases', 'Purchases', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52269, 0, 0, 'Y', now(), 100, now(), 100, 'pmenu.stock', 'Stock', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52270, 0, 0, 'Y', now(), 100, now(), 100, 'pos.info', 'POS Info', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52271, 0, 0, 'Y', now(), 100, now(), 100, 'pos.info.current.month', 'POS Info  (Current Month)', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52272, 0, 0, 'Y', now(), 100, now(), 100, 'pos.info.custom', 'POS Info  (Custom)', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52273, 0, 0, 'Y', now(), 100, now(), 100, 'pos.info.today', 'POS Info (Today)', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52274, 0, 0, 'Y', now(), 100, now(), 100, 'pos.name', 'POS Name', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52275, 0, 0, 'Y', now(), 100, now(), 100, 'pos.order', 'POS Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52276, 0, 0, 'Y', now(), 100, now(), 100, 'pos.order.history', 'POS Order History', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52277, 0, 0, 'Y', now(), 100, now(), 100, 'posPassowrd.welcome', 'Welcome to Posterita POS', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52278, 0, 0, 'Y', now(), 100, now(), 100, 'postalAddr', 'Postal Address', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52279, 0, 0, 'Y', now(), 100, now(), 100, 'preference.themes', 'Themes', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52280, 0, 0, 'Y', now(), 100, now(), 100, 'preferences', 'Preferences', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52281, 0, 0, 'Y', now(), 100, now(), 100, 'prepared.order', 'Prepared Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52282, 0, 0, 'Y', now(), 100, now(), 100, 'prev', 'Prev', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52283, 0, 0, 'Y', now(), 100, now(), 100, 'print.barcode', 'Print Barcode', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52284, 0, 0, 'Y', now(), 100, now(), 100, 'print.dunning.letters', 'Print Dunning Letters', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52285, 0, 0, 'Y', now(), 100, now(), 100, 'print.fidelity.card', 'Print Fidelity Card', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52286, 0, 0, 'Y', now(), 100, now(), 100, 'print.order', 'Print Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52287, 0, 0, 'Y', now(), 100, now(), 100, 'print.pdf', 'Print PDF', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52288, 0, 0, 'Y', now(), 100, now(), 100, 'printer.enabled', 'Printer enabled', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52289, 0, 0, 'Y', now(), 100, now(), 100, 'printer.name', 'Printer name', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52290, 0, 0, 'Y', now(), 100, now(), 100, 'product.already.exists', 'Product name already exists!', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52291, 0, 0, 'Y', now(), 100, now(), 100, 'product.id', 'Product ID', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52292, 0, 0, 'Y', now(), 100, now(), 100, 'product.info', 'Product Info', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52293, 0, 0, 'Y', now(), 100, now(), 100, 'product.type.item', 'Item', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52294, 0, 0, 'Y', now(), 100, now(), 100, 'product.type.services', 'Services', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52295, 0, 0, 'Y', now(), 100, now(), 100, 'product.updated', 'The Products have been updated', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52296, 0, 0, 'Y', now(), 100, now(), 100, 'profit.margin', 'Profit Margin', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52297, 0, 0, 'Y', now(), 100, now(), 100, 'purchase.price', 'Purchase Price', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52298, 0, 0, 'Y', now(), 100, now(), 100, 'qty.received', 'Qty Received', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52299, 0, 0, 'Y', now(), 100, now(), 100, 'qty.returned.by.customer', 'Qty Returned By Customer', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52300, 0, 0, 'Y', now(), 100, now(), 100, 'qty.returned.to.supplier', 'Qty Returned to Supplier', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52301, 0, 0, 'Y', now(), 100, now(), 100, 'qty.sold', 'Qty Sold', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52302, 0, 0, 'Y', now(), 100, now(), 100, 'reason.message', 'Reason', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52303, 0, 0, 'Y', now(), 100, now(), 100, 'record.found', 'Records found', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52304, 0, 0, 'Y', now(), 100, now(), 100, 'records.per.page', 'records per page', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52305, 0, 0, 'Y', now(), 100, now(), 100, 'remote.printing', 'Remote printing', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52306, 0, 0, 'Y', now(), 100, now(), 100, 'remove.customer.fidelity.card', 'Remove Customer for fidelity card', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52307, 0, 0, 'Y', now(), 100, now(), 100, 'report.filter.settings', 'Report Filter Settings', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52308, 0, 0, 'Y', now(), 100, now(), 100, 'reprint', 'Reprint', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52309, 0, 0, 'Y', now(), 100, now(), 100, 'returned.order', 'Returned Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52310, 0, 0, 'Y', now(), 100, now(), 100, 'revenue', 'Revenue', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52311, 0, 0, 'Y', now(), 100, now(), 100, 'sales.details', 'Sales Details', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52312, 0, 0, 'Y', now(), 100, now(), 100, 'sales.order', 'Sales Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52313, 0, 0, 'Y', now(), 100, now(), 100, 'sales.price', 'Sales Price', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52314, 0, 0, 'Y', now(), 100, now(), 100, 'sales.reports', 'Sales Reports', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52315, 0, 0, 'Y', now(), 100, now(), 100, 'save', 'Save', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52316, 0, 0, 'Y', now(), 100, now(), 100, 'save.as.csv', 'Save as CSV', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52317, 0, 0, 'Y', now(), 100, now(), 100, 'search', 'Search', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52318, 0, 0, 'Y', now(), 100, now(), 100, 'search.customer', 'Search Customer', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52319, 0, 0, 'Y', now(), 100, now(), 100, 'search.customer.notfound', 'No customers were found for', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52320, 0, 0, 'Y', now(), 100, now(), 100, 'search.product', 'Search Product', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52321, 0, 0, 'Y', now(), 100, now(), 100, 'search.product.notfound', 'No products were found for:', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52322, 0, 0, 'Y', now(), 100, now(), 100, 'search.result.displaying', 'Displaying', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52323, 0, 0, 'Y', now(), 100, now(), 100, 'search.result.of', 'of', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52324, 0, 0, 'Y', now(), 100, now(), 100, 'search.result.to', 'to', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52325, 0, 0, 'Y', now(), 100, now(), 100, 'search.results', 'Search Results', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52326, 0, 0, 'Y', now(), 100, now(), 100, 'select', 'Select', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52327, 0, 0, 'Y', now(), 100, now(), 100, 'select.all', 'Select All', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52328, 0, 0, 'Y', now(), 100, now(), 100, 'select.bpartner.type', 'Select partner type', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52329, 0, 0, 'Y', now(), 100, now(), 100, 'select.range', 'Select Range', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52330, 0, 0, 'Y', now(), 100, now(), 100, 'selected.customers', 'Selected Customers', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52331, 0, 0, 'Y', now(), 100, now(), 100, 'settle.payment', 'Settle Payment', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52332, 0, 0, 'Y', now(), 100, now(), 100, 'settle.payment.message', 'NOTE:-The Cash Payments would have effect only when the cash book is closed', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52333, 0, 0, 'Y', now(), 100, now(), 100, 'shipment.no', 'Shipment No', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52334, 0, 0, 'Y', now(), 100, now(), 100, 'shipment.required', 'Shipment Required', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52335, 0, 0, 'Y', now(), 100, now(), 100, 'shipment.status', 'Shipment Status', 'Shipment Status', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52336, 0, 0, 'Y', now(), 100, now(), 100, 'show.details', 'Show Details', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52337, 0, 0, 'Y', now(), 100, now(), 100, 'size', 'Size', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52338, 0, 0, 'Y', now(), 100, now(), 100, 'slow.moving.item', 'Slow Moving Items', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52339, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.adjust.cashbook', 'Adjust Cash Book', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52340, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.adjust.inventory.id', 'Adjust Inventory', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52341, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.adjust.stock.id', 'Stock Adjustment', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52342, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.bpartner.sales.details', 'Business Partner Sales Details', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52343, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.bpartners', 'Business Partners', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52344, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.cash.sales', 'Cash Sales', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52345, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.cash.sales.customer.complusory', 'Cash Sales (Customer Compulsory)', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52346, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.cash.sales.history', 'Cash Sales History', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52347, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.cash.sales.multiple.payments', 'Cash Sales (Discount/Multiple Payments)', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52348, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.cashbook.history', 'Cash Book History', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52349, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.cashbook.report', 'Cash Book Report', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52350, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.check.repair.database.integrity', 'Check/Repair Database Integrity', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52351, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.close.till', 'Close Till', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52352, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.complete.prepared.order', 'Complete Prepared Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52353, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.create.unallocated.payment.id', 'Create General Payments', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52354, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.credit.memo.history.id', 'Credit Memo History', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52355, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.credit.sales', 'Credit Sales', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52356, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.credit.sales.history', 'Credit Sales History', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52357, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.creditmemo.from.creditorder.id', 'Invoke Credit Memo', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52358, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.current.money.in.terminal', 'Current Money in Terminal', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52359, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.customer.return.history.id', 'Customer Return History', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52360, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.customer.returned.order', 'Customer Returned Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52361, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.customers', 'Customers', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52362, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.document.history', 'Document History', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52363, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.dunning.letters', 'Dunning Letters', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52364, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.edit.product.attribute.value', 'Edit Product Attribute Value', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52365, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.fast.moving.items', 'Fast Moving Items', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52366, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.generate.commission', 'Generate Commission', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52367, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.goods.received.note', 'Goods Received Note', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52368, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.goods.received.note.history', 'Goods Received Note History', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52369, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.goods.returned.note', 'Goods Returned Note', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52370, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.goods.returned.note.history', 'Goods Returned Note History', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52371, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.inventory.history.id', 'Inventory History', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52372, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.invoke.customer.returned.order', 'Invoke Customer Returned Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52373, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.logout', 'Logout', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52374, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.open.cashdrawer', 'Open Cash Drawer', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52375, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.order.history', 'Order History', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52376, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.payment.allocation.history', 'Payment Allocations History', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52377, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.payment.term', 'Payment Term', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52378, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.performance.analysis.report', 'Performance Analysis Report', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52379, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.preferences', 'Preferences', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52380, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.prepare.order', 'Prepare Order', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52381, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.prepared.order.history', 'Prepared Order History', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52382, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.products', 'Products', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52383, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.quick.cash.sales', 'Quick Cash Sales', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52384, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.role', 'Role', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52385, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.sales.report.per.terminal', 'Sales Report per Terminal', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52386, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.settle.payment.credit.sales', 'Settle Payment on a Credit Sales', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(523847, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.slow.moving.items', 'Slow Moving Items', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52388, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.stock', 'Stock', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52389, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.stock.movement', 'Stock Movement', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52390, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.tax', 'Tax', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52391, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.users', 'Users', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52392, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.vendors', 'Vendors', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52393, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.view.last.generated.commission', 'Last Generated Commission', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52394, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.view.licensing', 'Licensing', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52395, 0, 0, 'Y', now(), 100, now(), 100, 'status', 'Status', 'Status', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52396, 0, 0, 'Y', now(), 100, now(), 100, 'stock.in.hand', 'Stock in Hand', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52397, 0, 0, 'Y', now(), 100, now(), 100, 'stock.inquiry', 'Stock Inquiry', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52398, 0, 0, 'Y', now(), 100, now(), 100, 'stock.movement', 'Stock Movement', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52399, 0, 0, 'Y', now(), 100, now(), 100, 'stock.movement.report', 'Stock Movement Report', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52400, 0, 0, 'Y', now(), 100, now(), 100, 'submit', 'Submit', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52401, 0, 0, 'Y', now(), 100, now(), 100, 'summary.by.periods', 'Summary By Period', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52402, 0, 0, 'Y', now(), 100, now(), 100, 'switch.to.paging', 'Switch to Paging', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52403, 0, 0, 'Y', now(), 100, now(), 100, 'tamak.pos', 'Posterita POS', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52404, 0, 0, 'Y', now(), 100, now(), 100, 'tax.credit', 'Tax Credit', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52405, 0, 0, 'Y', now(), 100, now(), 100, 'tax.due', 'Tax Due', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52406, 0, 0, 'Y', now(), 100, now(), 100, 'texttile.products.only', 'Textile Products Only', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52407, 0, 0, 'Y', now(), 100, now(), 100, 'the.cart.has', 'The Cart has', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52408, 0, 0, 'Y', now(), 100, now(), 100, 'till.balance.entered', 'Till Balance Entered', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52409, 0, 0, 'Y', now(), 100, now(), 100, 'till.management', 'Till Mgt', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52410, 0, 0, 'Y', now(), 100, now(), 100, 'till.no', 'Till No', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52411, 0, 0, 'Y', now(), 100, now(), 100, 'time.hour', 'h', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52412, 0, 0, 'Y', now(), 100, now(), 100, 'time.minute', 'm', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52413, 0, 0, 'Y', now(), 100, now(), 100, 'to', 'To', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52414, 0, 0, 'Y', now(), 100, now(), 100, 'today', 'Today', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52415, 0, 0, 'Y', now(), 100, now(), 100, 'total', 'Total', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52416, 0, 0, 'Y', now(), 100, now(), 100, 'total.price', 'Total Price', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52417, 0, 0, 'Y', now(), 100, now(), 100, 'trade.revenue', 'Trade Revenue', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52418, 0, 0, 'Y', now(), 100, now(), 100, 'unallocated.payments', 'Unallocated Payments', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52419, 0, 0, 'Y', now(), 100, now(), 100, 'update.details', 'Update Details', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52420, 0, 0, 'Y', now(), 100, now(), 100, 'user', 'User', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52421, 0, 0, 'Y', now(), 100, now(), 100, 'user.details', 'User''s Details', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52422, 0, 0, 'Y', now(), 100, now(), 100, 'user.info', 'Information', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52423, 0, 0, 'Y', now(), 100, now(), 100, 'vat', 'VAT', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52424, 0, 0, 'Y', now(), 100, now(), 100, 'vendor.details', 'Vendor Details', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52425, 0, 0, 'Y', now(), 100, now(), 100, 'vendor.ref', 'Vendor Ref', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52426, 0, 0, 'Y', now(), 100, now(), 100, 'vendors', 'Vendors', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52427, 0, 0, 'Y', now(), 100, now(), 100, 'view', 'View', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52428, 0, 0, 'Y', now(), 100, now(), 100, 'view.attributes', 'View Attributes', 'View Attributes', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52429, 0, 0, 'Y', now(), 100, now(), 100, 'view.by', 'View By', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52430, 0, 0, 'Y', now(), 100, now(), 100, 'view.info', 'View Info', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52431, 0, 0, 'Y', now(), 100, now(), 100, 'view.product.cart', 'View Product Cart', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52432, 0, 0, 'Y', now(), 100, now(), 100, 'view.report', 'View Report', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52433, 0, 0, 'Y', now(), 100, now(), 100, 'view.role', 'View Role', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52434, 0, 0, 'Y', now(), 100, now(), 100, 'view.vendor', 'View Vendor', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52435, 0, 0, 'Y', now(), 100, now(), 100, 'year', 'Year', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52436, 0, 0, 'Y', now(), 100, now(), 100, 'yes', 'Yes', ' ', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52437, 0, 0, 'Y', now(), 100, now(), 100, 'price.x', 'Price(excl. VAT)', 'Prix(excl. TVA)', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52438, 0, 0, 'Y', now(), 100, now(), 100, 'LogOut', 'Log Out', 'Sortir', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52439, 0, 0, 'Y', now(), 100, now(), 100, 'smenu.price.check', 'Price Check', 'Verifier Prix', 'I', 'D');
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(52440, 0, 0, 'Y', now(), 100, now(), 100, 'next', 'Next', 'Suivant', 'I', 'D');


SELECT '015_PosteritaDML2_PG.sql' AS Filename;
-- ad_Window Changes --

INSERT INTO AD_WINDOW(AD_WINDOW_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, WINDOWTYPE, ISSOTRX, ENTITYTYPE, PROCESSING, AD_IMAGE_ID, AD_COLOR_ID, ISDEFAULT, WINHEIGHT, WINWIDTH, ISBETAFUNCTIONALITY)
  VALUES(52000, 0, 0, 'Y', now(), 100, now(), 100, 'Posterita Web Menu', 'To dynamically generate the menu links in posterita', NULL, 'M', 'Y', 'D', 'N', NULL, NULL, 'N', 0, 0, 'N');
INSERT INTO AD_WINDOW(AD_WINDOW_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, WINDOWTYPE, ISSOTRX, ENTITYTYPE, PROCESSING, AD_IMAGE_ID, AD_COLOR_ID, ISDEFAULT, WINHEIGHT, WINWIDTH, ISBETAFUNCTIONALITY)
  VALUES(52001, 0, 0, 'Y', now(), 100, now(), 100, 'Posterita Role Menu', 'Depending on Which Role, Different set of Menus are generated and made available.', NULL, 'M', 'Y', 'D', 'N', NULL, NULL, 'N', 0, 0, 'N');
INSERT INTO AD_WINDOW(AD_WINDOW_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, WINDOWTYPE, ISSOTRX, ENTITYTYPE, PROCESSING, AD_IMAGE_ID, AD_COLOR_ID, ISDEFAULT, WINHEIGHT, WINWIDTH, ISBETAFUNCTIONALITY)
  VALUES(52002, 0, 0, 'Y', now(), 100, now(), 100, 'Posterita Web Properties', 'Stores the message tags to be picked up from AD_MESSAGE ', NULL, 'M', 'Y', 'D', 'N', NULL, NULL, 'N', 0, 0, 'N');
INSERT INTO AD_WINDOW(AD_WINDOW_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, WINDOWTYPE, ISSOTRX, ENTITYTYPE, PROCESSING, AD_IMAGE_ID, AD_COLOR_ID, ISDEFAULT, WINHEIGHT, WINWIDTH, ISBETAFUNCTIONALITY)
  VALUES(52003, 0, 0, 'Y', now(), 100, now(), 100, 'Posterita BlackListCheque', 'Black Listed Cheque', NULL, 'M', 'Y', 'D', 'N', NULL, NULL, 'N', 0, 0, 'N');
--- ad_Tab Changes ---
INSERT INTO AD_TAB(AD_TAB_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, AD_TABLE_ID, AD_WINDOW_ID, SEQNO, TABLEVEL, ISSINGLEROW, ISINFOTAB, ISTRANSLATIONTAB, ISREADONLY, AD_COLUMN_ID, HASTREE, WHERECLAUSE, ORDERBYCLAUSE, COMMITWARNING, AD_PROCESS_ID, PROCESSING, AD_IMAGE_ID, IMPORTFIELDS, AD_COLUMNSORTORDER_ID, AD_COLUMNSORTYESNO_ID, ISSORTTAB, ENTITYTYPE, INCLUDED_TAB_ID, READONLYLOGIC, DISPLAYLOGIC, ISINSERTRECORD, ISADVANCEDTAB)
  VALUES(52000, 0, 0, 'Y', now(), 100, now(), 100, 'Web Menu', 'To dynamically generate the menu links in posterita', NULL, 52003, 52000, 10, 0, 'N', 'N', 'N', 'N', NULL, 'N', NULL, NULL, NULL, NULL, 'N', NULL, 'N', NULL, NULL, 'N', 'D', NULL, NULL, NULL, 'Y', 'N');
INSERT INTO AD_TAB(AD_TAB_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, AD_TABLE_ID, AD_WINDOW_ID, SEQNO, TABLEVEL, ISSINGLEROW, ISINFOTAB, ISTRANSLATIONTAB, ISREADONLY, AD_COLUMN_ID, HASTREE, WHERECLAUSE, ORDERBYCLAUSE, COMMITWARNING, AD_PROCESS_ID, PROCESSING, AD_IMAGE_ID, IMPORTFIELDS, AD_COLUMNSORTORDER_ID, AD_COLUMNSORTYESNO_ID, ISSORTTAB, ENTITYTYPE, INCLUDED_TAB_ID, READONLYLOGIC, DISPLAYLOGIC, ISINSERTRECORD, ISADVANCEDTAB)
  VALUES(52001, 0, 0, 'Y', now(), 100, now(), 100, 'Role Menu', 'Depending on Which Role, Different set of Menus are generated and made available.', NULL, 52002, 52001, 10, 0, 'N', 'N', 'N', 'N', NULL, 'N', NULL, NULL, NULL, NULL, 'N', NULL, 'N', NULL, NULL, 'N', 'D', NULL, NULL, NULL, 'Y', 'N');
INSERT INTO AD_TAB(AD_TAB_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, AD_TABLE_ID, AD_WINDOW_ID, SEQNO, TABLEVEL, ISSINGLEROW, ISINFOTAB, ISTRANSLATIONTAB, ISREADONLY, AD_COLUMN_ID, HASTREE, WHERECLAUSE, ORDERBYCLAUSE, COMMITWARNING, AD_PROCESS_ID, PROCESSING, AD_IMAGE_ID, IMPORTFIELDS, AD_COLUMNSORTORDER_ID, AD_COLUMNSORTYESNO_ID, ISSORTTAB, ENTITYTYPE, INCLUDED_TAB_ID, READONLYLOGIC, DISPLAYLOGIC, ISINSERTRECORD, ISADVANCEDTAB)
  VALUES(52002, 0, 0, 'Y', now(), 100, now(), 100, 'Web Properties', 'Stores the message tags to be picked up from AD_MESSAGE ', NULL, 52001, 52002, 10, 0, 'N', 'N', 'N', 'Y', NULL, 'N', NULL, NULL, NULL, NULL, 'N', NULL, 'N', NULL, NULL, 'N', 'D', NULL, NULL, NULL, 'N', 'N');
INSERT INTO AD_TAB(AD_TAB_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, AD_TABLE_ID, AD_WINDOW_ID, SEQNO, TABLEVEL, ISSINGLEROW, ISINFOTAB, ISTRANSLATIONTAB, ISREADONLY, AD_COLUMN_ID, HASTREE, WHERECLAUSE, ORDERBYCLAUSE, COMMITWARNING, AD_PROCESS_ID, PROCESSING, AD_IMAGE_ID, IMPORTFIELDS, AD_COLUMNSORTORDER_ID, AD_COLUMNSORTYESNO_ID, ISSORTTAB, ENTITYTYPE, INCLUDED_TAB_ID, READONLYLOGIC, DISPLAYLOGIC, ISINSERTRECORD, ISADVANCEDTAB)
  VALUES(52003, 0, 0, 'Y', now(), 100, now(), 100, 'BlackListCheque', 'Black Listed Cheque', NULL, 52000, 52003, 10, 0, 'N', 'N', 'N', 'N', NULL, 'N', NULL, NULL, NULL, NULL, 'N', NULL, 'N', NULL, NULL, 'N', 'D', NULL, NULL, NULL, 'Y', 'N');

-- AD_Field Changes --

INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52008, 0, 0, 'Y', now(), 100, now(), 100, 'Args', NULL, NULL, 'Y', 425, 52069, NULL, 'Y', NULL, 60, 'N', 210, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52009, 0, 0, 'Y', now(), 100, now(), 100, 'ClassName', NULL, NULL, 'Y', 425, 52068, NULL, 'Y', NULL, 60, 'N', 200, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52010, 0, 0, 'Y', now(), 100, now(), 100, 'UserPIN', NULL, NULL, 'Y', 118, 52066, NULL, 'Y', NULL, 20, 'N', 120, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52011, 0, 0, 'Y', now(), 100, now(), 100, 'AmountRefunded', NULL, NULL, 'Y', 186, 52065, NULL, 'N', NULL, 22, 'N', NULL, NULL, 'Y', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52012, 0, 0, 'Y', now(), 100, now(), 100, 'AmountTendered', NULL, NULL, 'Y', 186, 52064, NULL, 'N', NULL, 22, 'N', NULL, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52013, 0, 0, 'Y', now(), 100, now(), 100, 'Terminal', NULL, NULL, 'Y', 186, 52070, NULL, 'N', NULL, 10, 'N', NULL, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52014, 0, 0, 'Y', now(), 100, now(), 100, 'OrderType', NULL, NULL, 'Y', 186, 52063, NULL, 'Y', NULL, 510, 'N', NULL, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52015, 0, 0, 'Y', now(), 100, now(), 100, 'Group1', NULL, NULL, 'Y', 180, 52061, NULL, 'Y', NULL, 50, 'N', NULL, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52016, 0, 0, 'Y', now(), 100, now(), 100, 'Group2', NULL, NULL, 'Y', 180, 52062, NULL, 'Y', NULL, 50, 'N', NULL, NULL, 'Y', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52017, 0, 0, 'Y', now(), 100, now(), 100, 'CashDrawer', NULL, NULL, 'Y', 676, 52058, NULL, 'Y', NULL, 20, 'N', NULL, NULL, 'Y', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52018, 0, 0, 'Y', now(), 100, now(), 100, 'UserDiscount', NULL, NULL, 'Y', 119, 52067, NULL, 'Y', NULL, 22, 'N', 100, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52019, 0, 0, 'Y', now(), 100, now(), 100, 'Client', 'Client/Tenant for this installation.', 'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.', 'Y', 52000, 52042, NULL, 'Y', NULL, 22, 'N', 10, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52020, 0, 0, 'Y', now(), 100, now(), 100, 'Organization', 'Organizational entity within client', 'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.', 'Y', 52000, 52043, NULL, 'Y', NULL, 22, 'N', 20, NULL, 'Y', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52021, 0, 0, 'Y', now(), 100, now(), 100, 'Category', NULL, NULL, 'Y', 52000, 52060, NULL, 'Y', NULL, 120, 'N', 60, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52022, 0, 0, 'Y', now(), 100, now(), 100, 'Description', 'Optional short description of the record', 'A description is limited to 255 characters.', 'Y', 52000, 52054, NULL, 'Y', NULL, 200, 'N', 40, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52023, 0, 0, 'Y', now(), 100, now(), 100, 'HasSubMenu', NULL, NULL, 'Y', 52000, 52053, NULL, 'Y', NULL, 1, 'N', 70, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52024, 0, 0, 'Y', now(), 100, now(), 100, 'Comment/Help', 'Comment or Hint', 'The Help field contains a hint, comment or help about the use of this item.', 'Y', 52000, 52057, NULL, 'Y', NULL, 2000, 'N', 50, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52025, 0, 0, 'Y', now(), 100, now(), 100, 'ImageLink', NULL, NULL, 'Y', 52000, 52055, NULL, 'Y', NULL, 510, 'N', 90, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52026, 0, 0, 'Y', now(), 100, now(), 100, 'Active', 'The record is active in the system', 'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons for de-activating and not deleting records:
(1) The system requires the record for audit purposes.
(2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.', 'Y', 52000, 52044, NULL, 'Y', NULL, 1, 'N', 80, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52027, 0, 0, 'Y', now(), 100, now(), 100, 'MenuLink', NULL, NULL, 'Y', 52000, 52050, NULL, 'Y', NULL, 510, 'N', 100, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52028, 0, 0, 'Y', now(), 100, now(), 100, 'Module', NULL, NULL, 'Y', 52000, 52051, NULL, 'Y', NULL, 120, 'N', 110, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52029, 0, 0, 'Y', now(), 100, now(), 100, 'Name', 'Alphanumeric identifier of the entity', 'The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.', 'Y', 52000, 52049, NULL, 'Y', NULL, 120, 'N', 30, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52030, 0, 0, 'Y', now(), 100, now(), 100, 'ParentMenu_ID', NULL, NULL, 'Y', 52000, 52052, NULL, 'Y', NULL, 10, 'N', 120, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52031, 0, 0, 'Y', now(), 100, now(), 100, 'Position', NULL, NULL, 'Y', 52000, 52056, NULL, 'Y', NULL, 10, 'N', 130, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52032, 0, 0, 'Y', now(), 100, now(), 100, 'Sequence', NULL, NULL, 'Y', 52000, 52059, NULL, 'Y', NULL, 22, 'N', 140, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52033, 0, 0, 'Y', now(), 100, now(), 100, 'U_WebMenu_ID', NULL, NULL, 'Y', 52000, 52041, NULL, 'N', NULL, 22, 'N', NULL, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52034, 0, 0, 'Y', now(), 100, now(), 100, 'Client', 'Client/Tenant for this installation.', 'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.', 'Y', 52001, 52032, NULL, 'Y', NULL, 22, 'N', 10, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52035, 0, 0, 'Y', now(), 100, now(), 100, 'Organization', 'Organizational entity within client', 'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.', 'Y', 52001, 52033, NULL, 'Y', NULL, 22, 'N', 20, NULL, 'Y', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52036, 0, 0, 'Y', now(), 100, now(), 100, 'Role', 'Responsibility Role', 'The Role determines security and access a user who has this Role will have in the System.', 'Y', 52001, 52039, NULL, 'Y', NULL, 10, 'N', 40, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52037, 0, 0, 'Y', now(), 100, now(), 100, 'Active', 'The record is active in the system', 'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons for de-activating and not deleting records:
(1) The system requires the record for audit purposes.
(2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.', 'Y', 52001, 52034, NULL, 'Y', NULL, 1, 'N', 50, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52038, 0, 0, 'Y', now(), 100, now(), 100, 'U_RoleMenu_ID', NULL, NULL, 'Y', 52001, 52031, NULL, 'N', NULL, 22, 'N', NULL, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52039, 0, 0, 'Y', now(), 100, now(), 100, 'U_WebMenu_ID', NULL, NULL, 'Y', 52001, 52040, NULL, 'Y', NULL, 10, 'N', 30, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52040, 0, 0, 'Y', now(), 100, now(), 100, 'Client', 'Client/Tenant for this installation.', 'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.', 'Y', 52002, 52022, NULL, 'Y', NULL, 22, 'N', 30, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52041, 0, 0, 'Y', now(), 100, now(), 100, 'Organization', 'Organizational entity within client', 'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.', 'Y', 52002, 52023, NULL, 'Y', NULL, 22, 'N', 20, NULL, 'Y', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52042, 0, 0, 'Y', now(), 100, now(), 100, 'Active', 'The record is active in the system', 'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons for de-activating and not deleting records:
(1) The system requires the record for audit purposes.
(2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.', 'Y', 52002, 52024, NULL, 'Y', NULL, 1, 'N', 10, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52043, 0, 0, 'Y', now(), 100, now(), 100, 'U_Key', NULL, NULL, 'Y', 52002, 52029, NULL, 'Y', NULL, 240, 'N', 40, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52044, 0, 0, 'Y', now(), 100, now(), 100, 'U_Value', NULL, NULL, 'Y', 52002, 52030, NULL, 'Y', NULL, 240, 'N', 50, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52045, 0, 0, 'Y', now(), 100, now(), 100, 'U_Web_Properties_ID', NULL, NULL, 'Y', 52002, 52021, NULL, 'N', NULL, 22, 'N', NULL, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52046, 0, 0, 'Y', now(), 100, now(), 100, 'Client', 'Client/Tenant for this installation.', 'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.', 'Y', 52003, 52012, NULL, 'Y', NULL, 22, 'N', 10, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52047, 0, 0, 'Y', now(), 100, now(), 100, 'Organization', 'Organizational entity within client', 'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.', 'Y', 52003, 52013, NULL, 'Y', NULL, 22, 'N', 20, NULL, 'Y', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52048, 0, 0, 'Y', now(), 100, now(), 100, 'BankName', NULL, NULL, 'Y', 52003, 52019, NULL, 'Y', NULL, 120, 'N', 30, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52049, 0, 0, 'Y', now(), 100, now(), 100, 'ChequeNo', NULL, NULL, 'Y', 52003, 52020, NULL, 'Y', NULL, 120, 'N', 40, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52050, 0, 0, 'Y', now(), 100, now(), 100, 'Active', 'The record is active in the system', 'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons for de-activating and not deleting records:
(1) The system requires the record for audit purposes.
(2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.', 'Y', 52003, 52014, NULL, 'Y', NULL, 1, 'N', 50, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);
INSERT INTO AD_FIELD(AD_FIELD_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, NAME, DESCRIPTION, HELP, ISCENTRALLYMAINTAINED, AD_TAB_ID, AD_COLUMN_ID, AD_FIELDGROUP_ID, ISDISPLAYED, DISPLAYLOGIC, DISPLAYLENGTH, ISREADONLY, SEQNO, SORTNO, ISSAMELINE, ISHEADING, ISFIELDONLY, ISENCRYPTED, ENTITYTYPE, OBSCURETYPE, AD_REFERENCE_ID, ISMANDATORY)
  VALUES(52051, 0, 0, 'Y', now(), 100, now(), 100, 'U_BlackListCheque_ID', NULL, NULL, 'Y', 52003, 52011, NULL, 'N', NULL, 22, 'N', NULL, NULL, 'N', 'N', 'N', 'N', 'D', NULL, NULL, NULL);

-- AD_WindowAccess Changes --
INSERT INTO AD_WINDOW_ACCESS(AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
  VALUES(52000, 0, 0, 0, 'Y', now(), 0, now(), 0, 'Y');
INSERT INTO AD_WINDOW_ACCESS(AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
  VALUES(52001, 50001, 0, 0, 'Y', now(), 0, now(), 0, 'Y');
INSERT INTO AD_WINDOW_ACCESS(AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
  VALUES(52001, 103, 11, 0, 'Y', now(), 100, now(), 100, 'Y');
INSERT INTO AD_WINDOW_ACCESS(AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
  VALUES(52001, 102, 11, 0, 'Y', now(), 100, now(), 100, 'Y');
INSERT INTO AD_WINDOW_ACCESS(AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
  VALUES(52002, 103, 11, 0, 'Y', now(), 100, now(), 100, 'Y');
INSERT INTO AD_WINDOW_ACCESS(AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
  VALUES(52002, 50001, 0, 0, 'Y', now(), 0, now(), 0, 'Y');
INSERT INTO AD_WINDOW_ACCESS(AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
  VALUES(52002, 102, 11, 0, 'Y', now(), 100, now(), 100, 'Y');
INSERT INTO AD_WINDOW_ACCESS(AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
  VALUES(52003, 50001, 0, 0, 'Y', now(), 0, now(), 0, 'Y');
INSERT INTO AD_WINDOW_ACCESS(AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
  VALUES(52003, 103, 11, 0, 'Y', now(), 100, now(), 100, 'Y');
INSERT INTO AD_WINDOW_ACCESS(AD_WINDOW_ID, AD_ROLE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, ISREADWRITE)
  VALUES(52003, 102, 11, 0, 'Y', now(), 100, now(), 100, 'Y');


-- AD_Menu Changes --
INSERT INTO AD_MENU(AD_MENU_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, NAME, UPDATEDBY, DESCRIPTION, ISSUMMARY, ISSOTRX, ISREADONLY, ACTION, AD_WINDOW_ID, AD_WORKFLOW_ID, AD_TASK_ID, AD_PROCESS_ID, AD_FORM_ID, AD_WORKBENCH_ID, ENTITYTYPE)
  VALUES(52002, 0, 0, 'Y', now(), 100, now(), 'Web Menu', 100, 'To dynamically generate the menu links in posterita', 'N', 'N', 'N', 'W', 52000, NULL, NULL, NULL, NULL, NULL, 'D');
INSERT INTO AD_MENU(AD_MENU_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, NAME, UPDATEDBY, DESCRIPTION, ISSUMMARY, ISSOTRX, ISREADONLY, ACTION, AD_WINDOW_ID, AD_WORKFLOW_ID, AD_TASK_ID, AD_PROCESS_ID, AD_FORM_ID, AD_WORKBENCH_ID, ENTITYTYPE)
  VALUES(52003, 0, 0, 'Y', now(), 100, now(), 'Role Menu', 100, NULL, 'N', 'N', 'N', 'W', 52001, NULL, NULL, NULL, NULL, NULL, 'D');
INSERT INTO AD_MENU(AD_MENU_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, NAME, UPDATEDBY, DESCRIPTION, ISSUMMARY, ISSOTRX, ISREADONLY, ACTION, AD_WINDOW_ID, AD_WORKFLOW_ID, AD_TASK_ID, AD_PROCESS_ID, AD_FORM_ID, AD_WORKBENCH_ID, ENTITYTYPE)
  VALUES(52004, 0, 0, 'Y', now(), 100, now(), 'Web Properties', 100, NULL, 'N', 'N', 'N', 'W', 52002, NULL, NULL, NULL, NULL, NULL, 'D');
INSERT INTO AD_MENU(AD_MENU_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, NAME, UPDATEDBY, DESCRIPTION, ISSUMMARY, ISSOTRX, ISREADONLY, ACTION, AD_WINDOW_ID, AD_WORKFLOW_ID, AD_TASK_ID, AD_PROCESS_ID, AD_FORM_ID, AD_WORKBENCH_ID, ENTITYTYPE)
  VALUES(52005, 0, 0, 'Y', now(), 100, now(), 'Black Listed Cheque', 100, NULL, 'N', 'N', 'N', 'W', 52003, NULL, NULL, NULL, NULL, NULL, 'D');

-- AD_TREENODEMM Changes --
INSERT INTO AD_TREENODEMM(AD_TREE_ID, NODE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, PARENT_ID, SEQNO)
  VALUES(10, 52002, 0, 0, 'Y', now(), 0, now(), 0, 52001, 3);
INSERT INTO AD_TREENODEMM(AD_TREE_ID, NODE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, PARENT_ID, SEQNO)
  VALUES(10, 52003, 0, 0, 'Y', now(), 0, now(), 0, 52001, 2);
INSERT INTO AD_TREENODEMM(AD_TREE_ID, NODE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, PARENT_ID, SEQNO)
  VALUES(10, 52004, 0, 0, 'Y', now(), 0, now(), 0, 52001, 1);
INSERT INTO AD_TREENODEMM(AD_TREE_ID, NODE_ID, AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY, PARENT_ID, SEQNO)
  VALUES(10, 52005, 0, 0, 'Y', now(), 0, now(), 0, 52001, 0);

SELECT '016_GridCollapseDetail.sql' AS Filename;
--@author - fer_luck @ centuryono
--Add Detail column
--The fields are already in the databse. Just needs to update them
update ad_field set seqno = seqno + 10 where ad_tab_id = 107 and seqno > 70;

update ad_field 
set ad_tab_id = 107, isdisplayed = 'Y', seqno = 80
where ad_column_id = 8547;

--It's not physically in the database, so here we create it
alter table ad_field add included_tab_id numeric(10);

--Modify the views
drop view ad_field_v;
CREATE OR REPLACE VIEW AD_FIELD_V
(AD_WINDOW_ID, AD_TAB_ID, AD_FIELD_ID, AD_TABLE_ID, AD_COLUMN_ID, 
 NAME, DESCRIPTION, HELP, ISDISPLAYED, DISPLAYLOGIC, 
 DISPLAYLENGTH, SEQNO, SORTNO, ISSAMELINE, ISHEADING, 
 ISFIELDONLY, ISREADONLY, ISENCRYPTEDFIELD, OBSCURETYPE, COLUMNNAME, 
 COLUMNSQL, FIELDLENGTH, VFORMAT, DEFAULTVALUE, ISKEY, 
 ISPARENT, ISMANDATORY, ISIDENTIFIER, ISTRANSLATED, AD_REFERENCE_VALUE_ID, 
 CALLOUT, AD_REFERENCE_ID, AD_VAL_RULE_ID, AD_PROCESS_ID, ISALWAYSUPDATEABLE, 
 READONLYLOGIC, MANDATORYLOGIC, ISUPDATEABLE, ISENCRYPTEDCOLUMN, ISSELECTIONCOLUMN, TABLENAME, 
 VALUEMIN, VALUEMAX, FIELDGROUP, VALIDATIONCODE)
AS 
SELECT t.AD_Window_ID, f.AD_Tab_ID, f.AD_Field_ID, tbl.AD_Table_ID, f.AD_Column_ID, 
	f.Name, f.Description, f.Help, f.IsDisplayed, f.DisplayLogic, f.DisplayLength, 
	f.SeqNo, f.SortNo, f.IsSameLine, f.IsHeading, f.IsFieldOnly, f.IsReadOnly, 
	f.IsEncrypted AS IsEncryptedField, f.ObscureType,
	c.ColumnName, c.ColumnSQL, c.FieldLength, c.VFormat, c.DefaultValue, c.IsKey, c.IsParent, 
	COALESCE(f.IsMandatory, c.IsMandatory) AS IsMandatory, 
    c.IsIdentifier, c.IsTranslated, c.AD_Reference_Value_ID, 
	c.Callout, COALESCE(f.AD_Reference_ID, c.AD_Reference_ID) AS AD_Reference_ID, 
    c.AD_Val_Rule_ID, c.AD_Process_ID, c.IsAlwaysUpdateable,
	c.ReadOnlyLogic, c.MandatoryLogic, c.IsUpdateable, c.IsEncrypted AS IsEncryptedColumn, 
    c.IsSelectionColumn,
	tbl.TableName, c.ValueMin, c.ValueMax, 
	fg.Name AS FieldGroup, vr.Code AS ValidationCode, f.included_tab_id
FROM AD_Field f 
  INNER JOIN AD_Tab t ON (f.AD_Tab_ID = t.AD_Tab_ID)
  LEFT OUTER JOIN AD_FieldGroup fg ON (f.AD_FieldGroup_ID = fg.AD_FieldGroup_ID) 
  LEFT OUTER JOIN AD_Column c ON (f.AD_Column_ID = c.AD_Column_ID)
	INNER JOIN AD_Table tbl ON (c.AD_Table_ID = tbl.AD_Table_ID)
	INNER JOIN AD_Reference r ON (c.AD_Reference_ID = r.AD_Reference_ID)
	LEFT OUTER JOIN AD_Val_Rule vr ON (c.AD_Val_Rule_ID=vr.AD_Val_Rule_ID)
WHERE f.IsActive = 'Y' 
  AND c.IsActive = 'Y';


drop view ad_field_vt;
CREATE OR REPLACE VIEW AD_FIELD_VT
(AD_LANGUAGE, AD_WINDOW_ID, AD_TAB_ID, AD_FIELD_ID, AD_TABLE_ID, 
 AD_COLUMN_ID, NAME, DESCRIPTION, HELP, ISDISPLAYED, 
 DISPLAYLOGIC, DISPLAYLENGTH, SEQNO, SORTNO, ISSAMELINE, 
 ISHEADING, ISFIELDONLY, ISREADONLY, ISENCRYPTEDFIELD, OBSCURETYPE, 
 COLUMNNAME, COLUMNSQL, FIELDLENGTH, VFORMAT, DEFAULTVALUE, 
 ISKEY, ISPARENT, ISMANDATORY, ISIDENTIFIER, ISTRANSLATED, 
 AD_REFERENCE_VALUE_ID, CALLOUT, AD_REFERENCE_ID, AD_VAL_RULE_ID, AD_PROCESS_ID, 
 ISALWAYSUPDATEABLE, READONLYLOGIC, MANDATORYLOGIC, ISUPDATEABLE, ISENCRYPTEDCOLUMN, ISSELECTIONCOLUMN, 
 TABLENAME, VALUEMIN, VALUEMAX, FIELDGROUP, VALIDATIONCODE)
AS 
SELECT trl.AD_Language, t.AD_Window_ID, f.AD_Tab_ID, f.AD_Field_ID, tbl.AD_Table_ID, f.AD_Column_ID, 
	trl.Name, trl.Description, trl.Help, f.IsDisplayed, f.DisplayLogic, f.DisplayLength, 
	f.SeqNo, f.SortNo, f.IsSameLine, f.IsHeading, f.IsFieldOnly, f.IsReadOnly, 
	f.IsEncrypted AS IsEncryptedField, f.ObscureType,
	c.ColumnName, c.ColumnSQL, c.FieldLength, c.VFormat, c.DefaultValue, c.IsKey, c.IsParent, 
	COALESCE(f.IsMandatory, c.IsMandatory) AS IsMandatory, 
    c.IsIdentifier, c.IsTranslated, c.AD_Reference_Value_ID, 
	c.Callout, COALESCE(f.AD_Reference_ID, c.AD_Reference_ID) AS AD_Reference_ID, 
    c.AD_Val_Rule_ID, c.AD_Process_ID, c.IsAlwaysUpdateable,
	c.ReadOnlyLogic, c.MandatoryLogic, c.IsUpdateable, c.IsEncrypted AS IsEncryptedColumn, c.IsSelectionColumn,
	tbl.TableName, c.ValueMin, c.ValueMax, 
	fgt.Name AS FieldGroup, vr.Code AS ValidationCode,  f.included_tab_id
FROM AD_Field f 
	INNER JOIN AD_Field_Trl trl ON (f.AD_Field_ID = trl.AD_Field_ID)
  INNER JOIN AD_Tab t ON (f.AD_Tab_ID = t.AD_Tab_ID)
  LEFT OUTER JOIN AD_FieldGroup_Trl fgt ON 
	(f.AD_FieldGroup_ID = fgt.AD_FieldGroup_ID AND trl.AD_Language=fgt.AD_Language)
  LEFT OUTER JOIN AD_Column c ON (f.AD_Column_ID = c.AD_Column_ID)
	INNER JOIN AD_Table tbl ON (c.AD_Table_ID = tbl.AD_Table_ID)
	INNER JOIN AD_Reference r ON (c.AD_Reference_ID = r.AD_Reference_ID)
	LEFT OUTER JOIN AD_Val_Rule vr ON (c.AD_Val_Rule_ID=vr.AD_Val_Rule_ID)
WHERE f.IsActive = 'Y' 
  AND c.IsActive = 'Y';

--Add the Grid Collapse and Tabbed item navigation
INSERT INTO AD_ELEMENT
            (ad_element_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             columnname, entitytype, NAME, printname
            )
     VALUES (53002, 0, 0, 'Y',
             TO_DATE ('07/18/2007 14:23:01', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/18/2007 14:23:01', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'FieldGroupType', 'D', 'Field Group Type', 'Field Group Type'
            );

insert into ad_reference
          (ad_reference_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby,
             name, description, help,
             validationtype, entitytype)
     VALUES (53000, 0, 0, 'Y',
             TO_DATE ('07/18/2007 14:22:51', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/18/2007 14:22:51', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'AD_FieldGroup', 'Field Group Type', '',
             'L', 'D');

insert into ad_ref_list 
          (ad_ref_list_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby,
             value, name,
             ad_reference_id, entitytype)
VALUES(53000, 0, 0, 'Y',
             TO_DATE ('07/18/2007 14:22:51', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/18/2007 14:22:51', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100,
             'T', 'Tab',
             53000, 'D');
insert into ad_ref_list 
          (ad_ref_list_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby,
             value, name,
             ad_reference_id, entitytype)
VALUES(53001, 0, 0, 'Y',
             TO_DATE ('07/18/2007 14:22:51', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/18/2007 14:22:51', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100,
             'L', 'Label',
             53000, 'D');
insert into ad_ref_list 
          (ad_ref_list_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby,
             value, name,
             ad_reference_id, entitytype)
VALUES(53002, 0, 0, 'Y',
             TO_DATE ('07/18/2007 14:22:51', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/18/2007 14:22:51', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100,
             'C', 'Collapse',
             53000, 'D');

INSERT INTO AD_COLUMN
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description,
             HELP,
             VERSION, entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, seqno, istranslated, isencrypted,
             isselectioncolumn, ad_element_id, issyncdatabase,
             isalwaysupdateable, ad_reference_value_id
            )
     VALUES (53002, 0, 0, 'Y',
             TO_DATE ('07/18/2007 14:22:51', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('07/18/2007 14:22:51', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Field Group Type', 'Field Group',
             'Field Group.',
             0, 'D', 'FieldGroupType', 414, 17,
             10, 'N', 'N', 'N', 'Y',
             'N', null, 'N', 'N',
             'N', 53002, 'Y',
             'N', 53000
            );

ALTER TABLE ad_fieldgroup ADD fieldgrouptype char(1);

INSERT INTO AD_FIELD
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description,
             HELP,
             iscentrallymaintained, ad_tab_id, ad_column_id, isdisplayed,
             displaylength, isreadonly, seqno, sortno, issameline, isheading,
             isfieldonly, isencrypted, entitytype
            )
     VALUES (53002, 0, 0, 'Y',
             TO_DATE ('07/18/2007 14:23:09', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('07/18/2007 14:23:17', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Field Group Type', 'Field Group Type',
             'The Field Group type',
             'Y', 342, 53002, 'Y',
             10, 'N', 60, 0, 'N', 'N',
             'N', 'N', 'D'
            );



-- NOTE: Don't forget to run the three processes:
-- 1 - Add missing translations in the language screen
-- 2 - Synchronize terminology
-- 3 - Check sequences

SELECT '017_SaveUserQuery.sql' AS Filename;
ALTER TABLE AD_UserQuery
ADD COLUMN AD_Tab_ID NUMERIC(10);

INSERT INTO AD_Column
(AD_Column_ID, AD_Client_ID, AD_Org_ID, IsActive,
Created,
Updated, CreatedBy,
UpdatedBy, Name, Description, VERSION,
EntityType, ColumnName, AD_Table_ID, AD_Reference_ID, 
FieldLength, IsKey, IsParent, IsMandatory, IsUpdateable,
IsIdentifier, SeqNo, IsTranslated, IsEncrypted,
isselectioncolumn, ad_element_id, callout, issyncdatabase,
isalwaysupdateable
)
VALUES (53251, 0, 0, 'Y',
TO_DATE ('10/10/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'),
TO_DATE ('10/10/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
100, 'Tab', 'Tab within a Window', 1,
'D', 'AD_Tab_ID', 814, 19,
10, 'N', 'N', 'Y', 'Y',
'N', 0, 'N', 'N',
'N', 125, null, 'N',
'N'
);

SELECT '018_SaveUserQueryMessage.sql' AS Filename;
INSERT INTO AD_Message
(AD_Message_ID, AD_Client_ID, AD_Org_ID, IsActive,
Created, CreatedBy,
Updated, UpdatedBy,
Value, MsgText, MsgType
)
VALUES (53005, 0, 0, 'Y',
TO_DATE ('10/10/2007 14:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
TO_DATE ('10/10/2007 14:00:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
'QueryName','Query Name','I'
);

UPDATE AD_Sequence
SET CurrentNextSys = (SELECT MAX (AD_Message_ID) + 1
FROM AD_Message
WHERE AD_message_ID < 1000000)
WHERE NAME = 'AD_Message';



SELECT '019_EntityTypeLength.sql' AS Filename;
ALTER TABLE PA_COLORSCHEMA ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_TABLE ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_WF_NEXTCONDITION ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_VAL_RULE ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_REPLICATIONTABLE ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_WORKFLOW ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_IMAGE ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_ENTITYTYPE ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_INFOCOLUMN ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_REFERENCE ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_REF_LIST ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_TAB ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_WF_NODENEXT ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_WORKBENCHWINDOW ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_WF_NODE_PARA ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_PROCESS ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_MENU ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_REPLICATIONSTRATEGY ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_WF_RESPONSIBLE ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_WORKBENCH ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_COLUMN ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_WF_NODE ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_TASK ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_REPORTVIEW ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_REF_TABLE ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_WINDOW ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE PA_MEASURECALC ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_FORM ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_MODIFICATION ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_INFOWINDOW ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_FIELD ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_ELEMENT ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_FIELDGROUP ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_MESSAGE ALTER COLUMN EntityType TYPE VARCHAR(40);
ALTER TABLE AD_PROCESS_PARA ALTER COLUMN EntityType TYPE VARCHAR(40);

UPDATE AD_COLUMN SET FieldLength = 40 WHERE ColumnName = 'EntityType'
   AND ad_table_id IN (
          SELECT ad_table_id
            FROM AD_TABLE
           WHERE tablename IN
                    ('AD_Ref_List',
                     'AD_WF_NextCondition',
                     'AD_Val_Rule',
                     'PA_MeasureCalc',
                     'AD_Menu',
                     'AD_InfoColumn',
                     'AD_WF_NodeNext',
                     'AD_WF_Node_Para',
                     'AD_Element',
                     'AD_Task',
                     'AD_Workbench',
                     'AD_EntityType',
                     'AD_Ref_Table',
                     'AD_Tab',
                     'AD_Field',
                     'AD_Process_Para',
                     'PA_ColorSchema',
                     'AD_Modification',
                     'AD_ReplicationStrategy',
                     'AD_ReplicationTable',
                     'AD_Image',
                     'AD_FieldGroup',
                     'AD_InfoWindow',
                     'AD_Table',
                     'AD_WF_Node',
                     'AD_WF_Responsible',
                     'AD_Form',
                     'AD_Window',
                     'AD_Column',
                     'AD_WorkbenchWindow',
                     'AD_Process',
                     'AD_ReportView',
                     'AD_Reference',
                     'AD_Message',
                     'AD_Workflow'
                    ));

UPDATE AD_FIELD SET DisplayLength = 20 WHERE AD_Column_ID IN
(SELECT AD_Column_ID FROM AD_COLUMN WHERE ColumnName = 'EntityType'
   AND ad_table_id IN (
          SELECT ad_table_id
            FROM AD_TABLE
           WHERE tablename IN
                    ('AD_Ref_List',
                     'AD_WF_NextCondition',
                     'AD_Val_Rule',
                     'PA_MeasureCalc',
                     'AD_Menu',
                     'AD_InfoColumn',
                     'AD_WF_NodeNext',
                     'AD_WF_Node_Para',
                     'AD_Element',
                     'AD_Task',
                     'AD_Workbench',
                     'AD_EntityType',
                     'AD_Ref_Table',
                     'AD_Tab',
                     'AD_Field',
                     'AD_Process_Para',
                     'PA_ColorSchema',
                     'AD_Modification',
                     'AD_ReplicationStrategy',
                     'AD_ReplicationTable',
                     'AD_Image',
                     'AD_FieldGroup',
                     'AD_InfoWindow',
                     'AD_Table',
                     'AD_WF_Node',
                     'AD_WF_Responsible',
                     'AD_Form',
                     'AD_Window',
                     'AD_Column',
                     'AD_WorkbenchWindow',
                     'AD_Process',
                     'AD_ReportView',
                     'AD_Reference',
                     'AD_Message',
                     'AD_Workflow'
                    )));

-- hide classpath field that is not implemented
UPDATE AD_FIELD
SET isdisplayed = 'N', isactive = 'N'
WHERE ad_field_id = 13498;

-- hide the register extension buttion that is not implemented
UPDATE AD_FIELD
SET isdisplayed = 'N', isactive = 'N'
WHERE ad_field_id = 13507;



SELECT '020_AD_ModelValidator.sql' AS Filename;
CREATE TABLE AD_MODELVALIDATOR 
(	AD_CLIENT_ID NUMERIC(10,0) DEFAULT 0 NOT NULL , 
	AD_MODELVALIDATOR_ID NUMERIC(10,0) NOT NULL , 
	AD_ORG_ID NUMERIC(10,0) DEFAULT 0 NOT NULL , 
	CREATED TIMESTAMP NOT NULL , 
	CREATEDBY NUMERIC(10,0) NOT NULL ,
	UPDATED DATE NOT NULL , 
	UPDATEDBY NUMERIC(10,0) NOT NULL ,
	ISACTIVE CHAR(1) NOT NULL ,
	NAME VARCHAR(60) NOT NULL , 
	DESCRIPTION VARCHAR(255),
	HELP VARCHAR(2000), 
	ENTITYTYPE VARCHAR(40) NOT NULL , 
	MODELVALIDATIONCLASS VARCHAR(255) NOT NULL , 
	CHECK (IsActive IN ('Y','N')) , 
	CONSTRAINT AD_MODELVALIDATOR_KEY PRIMARY KEY (AD_MODELVALIDATOR_ID)
);
 
INSERT INTO AD_Element
(AD_Element_ID, AD_Client_ID, AD_Org_ID, IsActive,
Created, CreatedBy,
Updated, UpdatedBy,
ColumnName, EntityType, Name,
PrintName
)
VALUES (53225, 0, 0, 'Y',
TO_DATE ('10/21/2007 18:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
TO_DATE ('10/21/2007 18:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
'AD_ModelValidator_ID', 'D', 'Model Validator',
'Model Validator'
);

INSERT INTO AD_Element
(AD_Element_ID, AD_Client_ID, AD_Org_ID, IsActive,
Created, CreatedBy,
Updated, UpdatedBy,
ColumnName, EntityType, Name,
PrintName
)
VALUES (53226, 0, 0, 'Y',
TO_DATE ('10/21/2007 18:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
TO_DATE ('10/21/2007 18:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
'ModelValidationClass', 'D', 'Model Validation Class',
'Model Validation Class'
);

-- INSERTING into AD_Table
Insert into AD_Table 
(AD_TABLE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,TABLENAME,ISVIEW,ACCESSLEVEL,ENTITYTYPE,AD_WINDOW_ID,AD_VAL_RULE_ID,LOADSEQ,ISSECURITYENABLED,ISDELETEABLE,ISHIGHVOLUME,IMPORTTABLE,ISCHANGELOG,REPLICATIONTYPE,PO_WINDOW_ID,COPYCOLUMNSFROMTABLE) 
values 
(53014,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,'Model Validator','Global Model Validator',null,'AD_ModelValidator','N','4','D',null,null,0,'N','Y','N','N','N','L',null,'N');

-- INSERTING into AD_Column
Insert into AD_Column 
(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC) 
values 
(53252,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,100,'Client','Client/Tenant for this installation.','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.',0,'D','AD_Client_ID',53014,19,null,null,10,'0','N','N','Y','N',null,'N',0,'N','N',null,null,null,null,'N',102,null,'N','N',null,null);

Insert into AD_Column 
(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC) 
values 
(53253,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,100,'Model Validator',null,null,0,'D','AD_ModelValidator_ID',53014,13,null,null,10,null,'Y','N','Y','N',null,'N',0,'N','N',null,null,null,null,'N',53225,null,'N','N',null,null);

Insert into AD_Column 
(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC) 
values 
(53254,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,100,'Organization','Organizational entity within client','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.',0,'D','AD_Org_ID',53014,19,null,null,10,'0','N','N','Y','N',null,'N',0,'N','N',null,null,null,null,'N',113,null,'N','N',null,null);

Insert into AD_Column 
(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC) 
values 
(53255,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,100,'Created','Date this record was created','The Created field indicates the date that this record was created.',0,'D','Created',53014,16,null,null,7,null,'N','N','Y','N',null,'N',0,'N','N',null,null,null,null,'N',245,null,'N','N',null,null);

Insert into AD_Column 
(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC) 
values 
(53256,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,100,'Created By','User who created this records','The Created By field indicates the user who created this record.',0,'D','CreatedBy',53014,18,110,null,10,null,'N','N','Y','N',null,'N',0,'N','N',null,null,null,null,'N',246,null,'N','N',null,null);

Insert into AD_Column 
(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC) 
values 
(53257,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,100,'Updated','Date this record was updated','The Updated field indicates the date that this record was updated.',0,'D','Updated',53014,16,null,null,7,null,'N','N','Y','N',null,'N',0,'N','N',null,null,null,null,'N',607,null,'N','N',null,null);

Insert into AD_Column 
(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC) 
values 
(53258,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,100,'Updated By','User who updated this records','The Updated By field indicates the user who updated this record.',0,'D','UpdatedBy',53014,18,110,null,10,null,'N','N','Y','N',null,'N',0,'N','N',null,null,null,null,'N',608,null,'N','N',null,null);

Insert into AD_Column 
(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC) 
values 
(53259,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,100,'Active','The record is active in the system','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. 
There are two reasons for de-activating and not deleting records:
(1) The system requires the record for audit purposes.
(2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.',0,'D','IsActive',53014,20,null,null,1,null,'N','N','Y','Y',null,'N',0,'N','N',null,null,null,null,'N',348,null,'N','N',null,null);

Insert into AD_Column 
(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC) 
values 
(53260,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,100,'Name','Alphanumeric identifier of the entity','The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.',0,'D','Name',53014,10,null,null,120,null,'N','N','Y','Y',null,'Y',1,'N','N',null,null,null,null,'N',469,null,'N','N',null,null);

Insert into AD_Column 
(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC) 
values 
(53261,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,100,'Description','Optional short description of the record','A description is limited to 255 characters.',0,'D','Description',53014,10,null,null,255,null,'N','N','N','Y',null,'N',0,'N','N',null,null,null,null,'N',275,null,'N','N',null,null);

Insert into AD_Column 
(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC) 
values 
(53262,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,100,'Comment/Help','Comment or Hint','The Help field contains a hint, comment or help about the use of this item.',0,'D','Help',53014,10,null,null,2000,null,'N','N','N','Y',null,'N',0,'N','N',null,null,null,null,'N',326,null,'N','N',null,null);

Insert into AD_Column 
(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC) 
values 
(53263,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,100,'Entity Type','Dictionary Entity Type; Determines ownership and synchronization','The Entity Types "Dictionary", "Adempiere" and "Application" might be automatically synchronized and customizations deleted or overwritten.  

For customizations, copy the entity and select "User"!',0,'D','EntityType',53014,10,null,null,40,null,'N','N','Y','N',null,'N',0,'N','N',null,null,null,null,'N',1682,null,'N','N',null,null);

Insert into AD_Column 
(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC) 
values 
(53264,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,100,'Model Validation Class',null,null,1,'D','ModelValidationClass',53014,10,null,null,255,null,'N','N','Y','Y',null,'N',0,'N','N',null,null,null,null,'N',53226,null,'N','N',null,null);

-- INSERTING into AD_Window
Insert into AD_Window 
(AD_WINDOW_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,WINDOWTYPE,ISSOTRX,ENTITYTYPE,PROCESSING,AD_IMAGE_ID,AD_COLOR_ID,ISDEFAULT,WINHEIGHT,WINWIDTH,ISBETAFUNCTIONALITY) 
values 
(53003,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,'Model Validator',null,null,'M','N','D','N',null,null,'N',0,0,'N');

-- INSERTING into AD_Tab
Insert into AD_Tab 
(AD_TAB_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,AD_TABLE_ID,AD_WINDOW_ID,SEQNO,TABLEVEL,ISSINGLEROW,ISINFOTAB,ISTRANSLATIONTAB,ISREADONLY,AD_COLUMN_ID,HASTREE,WHERECLAUSE,ORDERBYCLAUSE,COMMITWARNING,AD_PROCESS_ID,PROCESSING,AD_IMAGE_ID,IMPORTFIELDS,AD_COLUMNSORTORDER_ID,AD_COLUMNSORTYESNO_ID,ISSORTTAB,ENTITYTYPE,INCLUDED_TAB_ID,READONLYLOGIC,DISPLAYLOGIC,ISINSERTRECORD,ISADVANCEDTAB) 
values 
(53014,0,0,'Y',TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),100,'Model Validator',null,null,53014,53003,10,0,'N','N','N','N',null,'N',null,null,null,null,'N',null,'N',null,null,'N','D',null,null,null,'Y','N');

-- INSERTING into AD_Field
INSERT
INTO ad_field(ad_field_id,   ad_client_id,   ad_org_id,   isactive,   created,   createdby,   updated,   updatedby,   name,   description,   HELP,   iscentrallymaintained,   ad_tab_id,   ad_column_id,   ad_fieldgroup_id,   isdisplayed,   displaylogic,   displaylength,   isreadonly,   seqno,   sortno,   issameline,   isheading,   isfieldonly,   isencrypted,   entitytype,   obscuretype,   ad_reference_id,   ismandatory,   included_tab_id)
VALUES(53271,   0,   0,   'Y',   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   'Client',   'Client/Tenant for this installation.',   'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.',   'Y',   53014,   53252,   NULL,   'Y',   NULL,   10,   'N',   10,   NULL,   'N',   'N',   'N',   'N',   'D',   NULL,   NULL,   NULL,   NULL);

INSERT
INTO ad_field(ad_field_id,   ad_client_id,   ad_org_id,   isactive,   created,   createdby,   updated,   updatedby,   name,   description,   HELP,   iscentrallymaintained,   ad_tab_id,   ad_column_id,   ad_fieldgroup_id,   isdisplayed,   displaylogic,   displaylength,   isreadonly,   seqno,   sortno,   issameline,   isheading,   isfieldonly,   isencrypted,   entitytype,   obscuretype,   ad_reference_id,   ismandatory,   included_tab_id)
VALUES(53272,   0,   0,   'Y',   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   'Organization',   'Organizational entity within client',   'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.',   'Y',   53014,   53254,   NULL,   'Y',   NULL,   10,   'N',   20,   NULL,   'N',   'N',   'N',   'N',   'D',   NULL,   NULL,   NULL,   NULL);

INSERT
INTO ad_field(ad_field_id,   ad_client_id,   ad_org_id,   isactive,   created,   createdby,   updated,   updatedby,   name,   description,   HELP,   iscentrallymaintained,   ad_tab_id,   ad_column_id,   ad_fieldgroup_id,   isdisplayed,   displaylogic,   displaylength,   isreadonly,   seqno,   sortno,   issameline,   isheading,   isfieldonly,   isencrypted,   entitytype,   obscuretype,   ad_reference_id,   ismandatory,   included_tab_id)
VALUES(53273,   0,   0,   'Y',   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   'Entity Type',   'Dictionary Entity Type; Determines ownership and synchronization',   'The Entity Types "Dictionary", "Adempiere" and "Application" might be automatically synchronized and customizations deleted or overwritten.  

For customizations, copy the entity and select "User"!',   'Y',   53014,   53263,   NULL,   'Y',   NULL,   40,   'N',   30,   NULL,   'N',   'N',   'N',   'N',   'D',   NULL,   NULL,   NULL,   NULL);

INSERT
INTO ad_field(ad_field_id,   ad_client_id,   ad_org_id,   isactive,   created,   createdby,   updated,   updatedby,   name,   description,   HELP,   iscentrallymaintained,   ad_tab_id,   ad_column_id,   ad_fieldgroup_id,   isdisplayed,   displaylogic,   displaylength,   isreadonly,   seqno,   sortno,   issameline,   isheading,   isfieldonly,   isencrypted,   entitytype,   obscuretype,   ad_reference_id,   ismandatory,   included_tab_id)
VALUES(53274,   0,   0,   'Y',   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   'Name',   'Alphanumeric identifier of the entity',   'The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.',   'Y',   53014,   53260,   NULL,   'Y',   NULL,   120,   'N',   40,   NULL,   'N',   'N',   'N',   'N',   'D',   NULL,   NULL,   NULL,   NULL);

INSERT
INTO ad_field(ad_field_id,   ad_client_id,   ad_org_id,   isactive,   created,   createdby,   updated,   updatedby,   name,   description,   HELP,   iscentrallymaintained,   ad_tab_id,   ad_column_id,   ad_fieldgroup_id,   isdisplayed,   displaylogic,   displaylength,   isreadonly,   seqno,   sortno,   issameline,   isheading,   isfieldonly,   isencrypted,   entitytype,   obscuretype,   ad_reference_id,   ismandatory,   included_tab_id)
VALUES(53275,   0,   0,   'Y',   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   'Description',   'Optional short description of the record',   'A description is limited to 255 characters.',   'Y',   53014,   53261,   NULL,   'Y',   NULL,   255,   'N',   50,   NULL,   'N',   'N',   'N',   'N',   'D',   NULL,   NULL,   NULL,   NULL);

INSERT
INTO ad_field(ad_field_id,   ad_client_id,   ad_org_id,   isactive,   created,   createdby,   updated,   updatedby,   name,   description,   HELP,   iscentrallymaintained,   ad_tab_id,   ad_column_id,   ad_fieldgroup_id,   isdisplayed,   displaylogic,   displaylength,   isreadonly,   seqno,   sortno,   issameline,   isheading,   isfieldonly,   isencrypted,   entitytype,   obscuretype,   ad_reference_id,   ismandatory,   included_tab_id)
VALUES(53276,   0,   0,   'Y',   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   'Comment/Help',   'Comment or Hint',   'The Help field contains a hint, comment or help about the use of this item.',   'Y',   53014,   53262,   NULL,   'Y',   NULL,   2000,   'N',   60,   NULL,   'N',   'N',   'N',   'N',   'D',   NULL,   NULL,   NULL,   NULL);

INSERT
INTO ad_field(ad_field_id,   ad_client_id,   ad_org_id,   isactive,   created,   createdby,   updated,   updatedby,   name,   description,   HELP,   iscentrallymaintained,   ad_tab_id,   ad_column_id,   ad_fieldgroup_id,   isdisplayed,   displaylogic,   displaylength,   isreadonly,   seqno,   sortno,   issameline,   isheading,   isfieldonly,   isencrypted,   entitytype,   obscuretype,   ad_reference_id,   ismandatory,   included_tab_id)
VALUES(53277,   0,   0,   'Y',   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   'Active',   'The record is active in the system',   'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons for de-activating and not deleting records:
(1) The system requires the record for audit purposes.
(2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.',   'Y',   53014,   53259,   NULL,   'Y',   NULL,   1,   'N',   70,   NULL,   'N',   'N',   'N',   'N',   'D',   NULL,   NULL,   NULL,   NULL);

INSERT
INTO ad_field(ad_field_id,   ad_client_id,   ad_org_id,   isactive,   created,   createdby,   updated,   updatedby,   name,   description,   HELP,   iscentrallymaintained,   ad_tab_id,   ad_column_id,   ad_fieldgroup_id,   isdisplayed,   displaylogic,   displaylength,   isreadonly,   seqno,   sortno,   issameline,   isheading,   isfieldonly,   isencrypted,   entitytype,   obscuretype,   ad_reference_id,   ismandatory,   included_tab_id)
VALUES(53278,   0,   0,   'Y',   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   'Model Validation Class',   NULL,   NULL,   'Y',   53014,   53264,   NULL,   'Y',   NULL,   255,   'N',   80,   NULL,   'N',   'N',   'N',   'N',   'D',   NULL,   NULL,   NULL,   NULL);

INSERT
INTO ad_field(ad_field_id,   ad_client_id,   ad_org_id,   isactive,   created,   createdby,   updated,   updatedby,   name,   description,   HELP,   iscentrallymaintained,   ad_tab_id,   ad_column_id,   ad_fieldgroup_id,   isdisplayed,   displaylogic,   displaylength,   isreadonly,   seqno,   sortno,   issameline,   isheading,   isfieldonly,   isencrypted,   entitytype,   obscuretype,   ad_reference_id,   ismandatory,   included_tab_id)
VALUES(53279,   0,   0,   'Y',   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   'Model Validator',   NULL,   NULL,   'Y',   53014,   53253,   NULL,   'N',   NULL,   10,   'N',   NULL,   NULL,   'N',   'N',   'N',   'N',   'D',   NULL,   NULL,   NULL,   NULL);

-- INSERTING into AD_Menu
INSERT
INTO ad_menu(ad_menu_id,   ad_client_id,   ad_org_id,   isactive,   created,   createdby,   updated,   name,   updatedby,   description,   issummary,   issotrx,   isreadonly,   ACTION,   ad_window_id,   ad_workflow_id,   ad_task_id,   ad_process_id,   ad_form_id,   ad_workbench_id,   entitytype)
VALUES(53012,   0,   0,   'Y',   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   'Model Validator',   100,   NULL,   'N',   'N',   'N',   'W',   53003,   NULL,   NULL,   NULL,   NULL,   NULL,   'D');

-- INSERTING into AD_TreeNodeMM
INSERT
INTO ad_treenodemm(ad_tree_id,   node_id,   ad_client_id,   ad_org_id,   isactive,   created,   createdby,   updated,   updatedby,   parent_id,   seqno)
VALUES(10,   53012,   0,   0,   'Y',   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   0,   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   0,   153,   9);

-- INSERTING into AD_Sequence
INSERT
INTO ad_sequence(ad_sequence_id,   ad_client_id,   ad_org_id,   isactive,   created,   createdby,   updated,   updatedby,   name,   description,   vformat,   isautosequence,   incrementno,   startno,   currentnext,   currentnextsys,   isaudited,   istableid,   prefix,   suffix,   startnewyear)
VALUES(53012,   0,   0,   'Y',   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   TO_DATE ('10/22/2007 09:30:00', 'MM/DD/YYYY HH24:MI:SS'),   100,   'AD_ModelValidator',   'Table AD_ModelValidator',   NULL,   'Y',   1,   1000000,   1000000,   50000,   'N',   'Y',   NULL,   NULL,   'N');

SELECT '021_rejected.sql' AS Filename;
-- This is just a sequence placeholder for a rejected migration script

SELECT '022_FR_1732786.sql' AS Filename;
-- FR [ 1732786 ] DefaultValue on AD_Field
-- https://sourceforge.net/tracker/index.php?func=detail&aid=1732786&group_id=176962&atid=879335
--
--delete from AD_Column where AD_Column_ID=53265;
INSERT INTO AD_Column (AD_Org_ID,AD_Element_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,Name,SeqNo,Updated,UpdatedBy,Version,AD_Client_ID,AD_Column_ID)
VALUES (0,272,14,107,'DefaultValue',TO_TIMESTAMP('2007-10-22 14:22:58','YYYY-MM-DD HH24:MI:SS'),0,'Default value hierarchy, separated by ;','D',2000,'The defaults are evaluated in the order of definition, the first not null value becomes the default value of the column. The values are separated by comma or semicolon. a) Literals:. ''Text'' or 123 b) Variables - in format @Variable@ - Login e.g. #Date, #AD_Org_ID, #AD_Client_ID - Accounting Schema: e.g. $C_AcctSchema_ID, $C_Calendar_ID - Global defaults: e.g. DateFormat - Window values (all Picks, CheckBoxes, RadioButtons, and DateDoc/DateAcct) c) SQL code with the tag: @SQL=SELECT something AS DefaultValue FROM ... The SQL statement can contain variables.  There can be no other value other than the SQL statement. The default is only evaluated, if no user preference is defined.  Default definitions are ignored for record columns as Key, Parent, Client as well as Buttons.','Y','N','N','N','N','N','N','N','N','N','Y','Default Logic',0,TO_TIMESTAMP('2007-10-22 14:22:58','YYYY-MM-DD HH24:MI:SS'),0,0,0,53265);
--
--delete from AD_Field where AD_Field_ID=53280;
INSERT INTO AD_Field (AD_Column_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsEncrypted,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,Name,Updated,AD_Client_ID,UpdatedBy,SeqNo,AD_Field_ID)
VALUES (53265,0,107,TO_TIMESTAMP('2007-10-22 14:30:33','YYYY-MM-DD HH24:MI:SS'),0,'Default value hierarchy, separated by ;',60,'D','The defaults are evaluated in the order of definition, the first not null value becomes the default value of the column. The values are separated by comma or semicolon. a) Literals:. ''Text'' or 123 b) Variables - in format @Variable@ - Login e.g. #Date, #AD_Org_ID, #AD_Client_ID - Accounting Schema: e.g. $C_AcctSchema_ID, $C_Calendar_ID - Global defaults: e.g. DateFormat - Window values (all Picks, CheckBoxes, RadioButtons, and DateDoc/DateAcct) c) SQL code with the tag: @SQL=SELECT something AS DefaultValue FROM ... The SQL statement can contain variables.  There can be no other value other than the SQL statement. The default is only evaluated, if no user preference is defined.  Default definitions are ignored for record columns as Key, Parent, Client as well as Buttons.','Y','Y','Y','N','N','N','N','N','Default Logic',TO_TIMESTAMP('2007-10-22 14:30:33','YYYY-MM-DD HH24:MI:SS'),0,0,270,53280);
--

--
ALTER TABLE AD_Field ADD DefaultValue VARCHAR(2000);
--
CREATE OR REPLACE VIEW AD_FIELD_V
(AD_WINDOW_ID, AD_TAB_ID, AD_FIELD_ID, AD_TABLE_ID, AD_COLUMN_ID, 
 NAME, DESCRIPTION, HELP, ISDISPLAYED, DISPLAYLOGIC, 
 DISPLAYLENGTH, SEQNO, SORTNO, ISSAMELINE, ISHEADING, 
 ISFIELDONLY, ISREADONLY, ISENCRYPTEDFIELD, OBSCURETYPE, COLUMNNAME, 
 COLUMNSQL, FIELDLENGTH, VFORMAT, DEFAULTVALUE, ISKEY, 
 ISPARENT, ISMANDATORY, ISIDENTIFIER, ISTRANSLATED, AD_REFERENCE_VALUE_ID, 
 CALLOUT, AD_REFERENCE_ID, AD_VAL_RULE_ID, AD_PROCESS_ID, ISALWAYSUPDATEABLE, 
 READONLYLOGIC, MANDATORYLOGIC, ISUPDATEABLE, ISENCRYPTEDCOLUMN, ISSELECTIONCOLUMN, TABLENAME, 
 VALUEMIN, VALUEMAX, FIELDGROUP, VALIDATIONCODE, INCLUDED_TAB_ID)
AS 
SELECT t.AD_Window_ID, f.AD_Tab_ID, f.AD_Field_ID, tbl.AD_Table_ID, f.AD_Column_ID, 
	f.Name, f.Description, f.Help, f.IsDisplayed, f.DisplayLogic, f.DisplayLength, 
	f.SeqNo, f.SortNo, f.IsSameLine, f.IsHeading, f.IsFieldOnly, f.IsReadOnly, 
	f.IsEncrypted AS IsEncryptedField, f.ObscureType,
	c.ColumnName, c.ColumnSQL, c.FieldLength, c.VFormat,
	COALESCE(f.DefaultValue, c.DefaultValue) as DefaultValue,
	c.IsKey, c.IsParent, 
	COALESCE(f.IsMandatory, c.IsMandatory) AS IsMandatory, 
    c.IsIdentifier, c.IsTranslated, c.AD_Reference_Value_ID, 
	c.Callout, COALESCE(f.AD_Reference_ID, c.AD_Reference_ID) AS AD_Reference_ID, 
    c.AD_Val_Rule_ID, c.AD_Process_ID, c.IsAlwaysUpdateable,
	c.ReadOnlyLogic, c.MandatoryLogic, c.IsUpdateable, c.IsEncrypted AS IsEncryptedColumn, 
    c.IsSelectionColumn,
	tbl.TableName, c.ValueMin, c.ValueMax, 
	fg.Name AS FieldGroup, vr.Code AS ValidationCode,
	f.Included_Tab_ID
FROM AD_Field f 
  INNER JOIN AD_Tab t ON (f.AD_Tab_ID = t.AD_Tab_ID)
  LEFT OUTER JOIN AD_FieldGroup fg ON (f.AD_FieldGroup_ID = fg.AD_FieldGroup_ID) 
  LEFT OUTER JOIN AD_Column c ON (f.AD_Column_ID = c.AD_Column_ID)
	INNER JOIN AD_Table tbl ON (c.AD_Table_ID = tbl.AD_Table_ID)
	INNER JOIN AD_Reference r ON (c.AD_Reference_ID = r.AD_Reference_ID)
	LEFT OUTER JOIN AD_Val_Rule vr ON (c.AD_Val_Rule_ID=vr.AD_Val_Rule_ID)
WHERE f.IsActive = 'Y' 
  AND c.IsActive = 'Y';
--
CREATE OR REPLACE VIEW AD_FIELD_VT
(AD_LANGUAGE, AD_WINDOW_ID, AD_TAB_ID, AD_FIELD_ID, AD_TABLE_ID, 
 AD_COLUMN_ID, NAME, DESCRIPTION, HELP, ISDISPLAYED, 
 DISPLAYLOGIC, DISPLAYLENGTH, SEQNO, SORTNO, ISSAMELINE, 
 ISHEADING, ISFIELDONLY, ISREADONLY, ISENCRYPTEDFIELD, OBSCURETYPE, 
 COLUMNNAME, COLUMNSQL, FIELDLENGTH, VFORMAT, DEFAULTVALUE, 
 ISKEY, ISPARENT, ISMANDATORY, ISIDENTIFIER, ISTRANSLATED, 
 AD_REFERENCE_VALUE_ID, CALLOUT, AD_REFERENCE_ID, AD_VAL_RULE_ID, AD_PROCESS_ID, 
 ISALWAYSUPDATEABLE, READONLYLOGIC, MANDATORYLOGIC, ISUPDATEABLE, ISENCRYPTEDCOLUMN, ISSELECTIONCOLUMN, 
 TABLENAME, VALUEMIN, VALUEMAX, FIELDGROUP, VALIDATIONCODE, INCLUDED_TAB_ID)
AS 
SELECT trl.AD_Language, t.AD_Window_ID, f.AD_Tab_ID, f.AD_Field_ID, tbl.AD_Table_ID, f.AD_Column_ID, 
	trl.Name, trl.Description, trl.Help, f.IsDisplayed, f.DisplayLogic, f.DisplayLength, 
	f.SeqNo, f.SortNo, f.IsSameLine, f.IsHeading, f.IsFieldOnly, f.IsReadOnly, 
	f.IsEncrypted AS IsEncryptedField, f.ObscureType,
	c.ColumnName, c.ColumnSQL, c.FieldLength, c.VFormat,
	COALESCE(f.DefaultValue, c.DefaultValue) as DefaultValue,
	c.IsKey, c.IsParent, 
	COALESCE(f.IsMandatory, c.IsMandatory) AS IsMandatory, 
    c.IsIdentifier, c.IsTranslated, c.AD_Reference_Value_ID, 
	c.Callout, COALESCE(f.AD_Reference_ID, c.AD_Reference_ID) AS AD_Reference_ID, 
    c.AD_Val_Rule_ID, c.AD_Process_ID, c.IsAlwaysUpdateable,
	c.ReadOnlyLogic, c.MandatoryLogic, c.IsUpdateable, c.IsEncrypted AS IsEncryptedColumn, c.IsSelectionColumn,
	tbl.TableName, c.ValueMin, c.ValueMax, 
	fgt.Name AS FieldGroup, vr.Code AS ValidationCode,
	f.Included_Tab_ID
FROM AD_Field f 
	INNER JOIN AD_Field_Trl trl ON (f.AD_Field_ID = trl.AD_Field_ID)
  INNER JOIN AD_Tab t ON (f.AD_Tab_ID = t.AD_Tab_ID)
  LEFT OUTER JOIN AD_FieldGroup_Trl fgt ON 
	(f.AD_FieldGroup_ID = fgt.AD_FieldGroup_ID AND trl.AD_Language=fgt.AD_Language)
  LEFT OUTER JOIN AD_Column c ON (f.AD_Column_ID = c.AD_Column_ID)
	INNER JOIN AD_Table tbl ON (c.AD_Table_ID = tbl.AD_Table_ID)
	INNER JOIN AD_Reference r ON (c.AD_Reference_ID = r.AD_Reference_ID)
	LEFT OUTER JOIN AD_Val_Rule vr ON (c.AD_Val_Rule_ID=vr.AD_Val_Rule_ID)
WHERE f.IsActive = 'Y' 
  AND c.IsActive = 'Y';
--
-- NOTE: Don't forget to run the three processes:
-- 1 - Add missing translations in the language screen
-- 2 - Synchronize terminology
-- 3 - Check sequences

SELECT '023_BF_1812362.sql' AS Filename;
update C_Currency set CurSymbol='KR' where C_Currency_ID=285;
SELECT '024_BF_1760922.sql' AS Filename;
UPDATE ad_column
   SET defaultvalue = 'N'
 WHERE ad_column_id = 50169;

UPDATE ad_column
   SET ad_reference_id = 38
 WHERE ad_column_id = 50170;
 


SELECT '025_OverUnderAmtMessage.sql' AS Filename;
INSERT INTO AD_MESSAGE
(AD_Message_ID, AD_Client_ID, AD_Org_ID, IsActive,
Created, CreatedBy,
Updated, UpdatedBy,
VALUE, MsgText, MsgType
)
VALUES (53006, 0, 0, 'Y',
TO_TIMESTAMP ('10/26/2007 01:01:50', 'MM/DD/YYYY HH24:MI:SS'), 100,
TO_TIMESTAMP ('10/26/2007 01:01:50', 'MM/DD/YYYY HH24:MI:SS'), 100,
'OverUnderAmt','Over/Under Payment','I'
);

UPDATE AD_SEQUENCE
SET CurrentNextSys = (SELECT MAX (AD_Message_ID) + 1
FROM AD_MESSAGE
WHERE AD_message_ID < 1000000)
WHERE NAME = 'AD_Message';



SELECT '026_disable_ldap_processor.sql' AS Filename;
UPDATE AD_LDAPPROCESSOR
   SET isactive = 'N'
 WHERE ad_ldapprocessor_id = 100;
 

SELECT '027_fix_typo_es.sql' AS Filename;
UPDATE AD_WINDOW_TRL
   SET HELP =
          'La terminal de PDV define los datos por omisión y las funciones disponibles para las formas de PDV.'
 WHERE ad_window_id = 338
   AND HELP LIKE
          '%La terminal de PDV define los datos por homición y las funciones disponibles para las formas de PDV.%'
   AND AD_LANGUAGE LIKE 'es_%';



SELECT '028_FR_1799601_PG.sql' AS Filename;
INSERT INTO ad_element
            (ad_element_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             columnname, entitytype, NAME,
             printname
            )
     VALUES (53223, 0, 0, 'Y',
             TO_DATE ('09/21/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('09/21/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'DunningGrace', 'D', 'Dunning Grace',
             'Dunning Grace'
            );


INSERT INTO ad_column
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description, 
             help, VERSION,
             entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, seqno, istranslated, isencrypted,
             isselectioncolumn, ad_element_id,  issyncdatabase,
             isalwaysupdateable
            )
     VALUES (53246, 0, 0, 'Y',
             TO_DATE ('09/21/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('09/21/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Dunning Grace', 'Delay/block the dunning until this date is reached.', 
             'Delay/block the dunning until this date is reached.', 1,
             'D', 'DunningGrace', 291, 15,
             7, 'N', 'N', 'N', 'Y',
             'N', 0, 'N', 'N',
             'N', 53223, 'N',
             'N'
            );

INSERT INTO ad_field
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description, 
             help,
             iscentrallymaintained, seqno, ad_tab_id,
             ad_column_id, isdisplayed, displaylength, isreadonly,
             issameline, isheading, isfieldonly, isencrypted, entitytype,
             displaylogic
            )
     VALUES (53256, 0, 0, 'Y',
             TO_DATE ('09/21/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('09/21/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Dunning Grace', 'Delay/block the dunning until this date is reached.', 
             'Delay/block the dunning until this date is reached.',
             'Y', 260 ,223,
             53246, 'Y', 14, 'N',
             'N', 'N', 'N', 'N', 'D',
             '@IsCustomer@=Y'
            );            
            
            
INSERT INTO ad_column
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description, 
             help, VERSION,
             entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, seqno, istranslated, isencrypted,
             isselectioncolumn, ad_element_id,  issyncdatabase,
             isalwaysupdateable
            )
     VALUES (53247, 0, 0, 'Y',
             TO_DATE ('09/21/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('09/21/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Dunning Grace', 'Delay/block the dunning until this date is reached.', 
             'Delay/block the dunning until this date is reached.', 1,
             'D', 'DunningGrace', 318, 15,
             7, 'N', 'N', 'N', 'Y',
             'N', 0, 'N', 'N',
             'N', 53223, 'N',
             'Y'
            );

INSERT INTO ad_field
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description, 
             help,
             iscentrallymaintained, seqno, ad_tab_id,
             ad_column_id, isdisplayed, displaylength, isreadonly,
             issameline, isheading, isfieldonly, isencrypted, entitytype
            )
     VALUES (53257, 0, 0, 'Y',
             TO_DATE ('09/21/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             TO_DATE ('09/21/2007 12:30:00', 'MM/DD/YYYY HH24:MI:SS'), 100,
             'Dunning Grace', 'Delay/block the dunning until this date is reached.', 
             'Delay/block the dunning until this date is reached.',
             'Y', 410 ,263,
             53247, 'Y', 14, 'N',
             'N', 'N', 'N', 'N', 'D'
            );            
                        
         

UPDATE ad_sequence
   SET currentnextsys = (SELECT MAX (ad_element_id) + 1
                           FROM ad_element
                          WHERE ad_element_id < 1000000)
 WHERE NAME = 'AD_Element';

UPDATE ad_sequence
   SET currentnextsys = (SELECT MAX (ad_column_id) + 1
                           FROM ad_column
                          WHERE ad_column_id < 1000000)
 WHERE NAME = 'AD_Column';

UPDATE ad_sequence
   SET currentnextsys = (SELECT MAX (ad_field_id) + 1
                           FROM ad_field
                          WHERE ad_field_id < 1000000)
 WHERE NAME = 'AD_Field';
 


ALTER TABLE C_BPartner ADD DunningGrace date NULL;
ALTER TABLE C_Invoice ADD DunningGrace date NULL;

DROP VIEW c_invoiceline_v;
DROP VIEW rv_bpartneropen;
DROP VIEW c_invoice_v;

CREATE OR REPLACE VIEW C_INVOICE_V
AS 
SELECT i.C_Invoice_ID, i.AD_Client_ID, i.AD_Org_ID, i.IsActive, i.Created, i.CreatedBy, i.Updated, i.UpdatedBy,
    i.IsSOTrx, i.DocumentNo, i.DocStatus, i.DocAction, i.Processing, i.Processed, i.C_DocType_ID,
    i.C_DocTypeTarget_ID, i.C_Order_ID, i.Description, i.IsApproved, i.IsTransferred,
    i.SalesRep_ID, i.DateInvoiced, i.DatePrinted, i.DateAcct, i.C_BPartner_ID, i.C_BPartner_Location_ID,
    i.AD_User_ID, i.POReference, i.DateOrdered, i.C_Currency_ID, i.C_ConversionType_ID, i.PaymentRule,
    i.C_PaymentTerm_ID, i.C_Charge_ID, i.M_PriceList_ID, i.C_Campaign_ID, i.C_Project_ID,
    i.C_Activity_ID, i.IsPrinted, i.IsDiscountPrinted, i.IsPaid, i.IsInDispute,
    i.IsPayScheduleValid, cast(null as numeric) AS C_InvoicePaySchedule_ID, i.InvoiceCollectionType,i.DunningGrace,
    cast(CASE WHEN charAt(d.DocBaseType,3)='C' THEN i.ChargeAmt*-1 ELSE i.ChargeAmt END as numeric) AS ChargeAmt,
    cast(CASE WHEN charAt(d.DocBaseType,3)='C' THEN i.TotalLines*-1 ELSE i.TotalLines END as numeric) AS TotalLines,
    cast(CASE WHEN charAt(d.DocBaseType,3)='C' THEN i.GrandTotal*-1 ELSE i.GrandTotal END as numeric) AS GrandTotal,
    cast(CASE WHEN charAt(d.DocBaseType,3)='C' THEN -1 ELSE 1 END as numeric) AS Multiplier,
    cast(CASE WHEN charAt(d.DocBaseType,2)='P' THEN -1 ELSE 1 END AS numeric) as MultiplierAP,
    d.DocBaseType
FROM C_Invoice i
    INNER JOIN C_DocType d ON (i.C_DocType_ID=d.C_DocType_ID)
WHERE i.IsPayScheduleValid<>'Y'
UNION
SELECT i.C_Invoice_ID, i.AD_Client_ID, i.AD_Org_ID, i.IsActive, i.Created, i.CreatedBy, i.Updated, i.UpdatedBy,
    i.IsSOTrx, i.DocumentNo, i.DocStatus, i.DocAction, i.Processing, i.Processed, i.C_DocType_ID,
    i.C_DocTypeTarget_ID, i.C_Order_ID, i.Description, i.IsApproved, i.IsTransferred,
    i.SalesRep_ID, i.DateInvoiced, i.DatePrinted, i.DateAcct, i.C_BPartner_ID, i.C_BPartner_Location_ID,
    i.AD_User_ID, i.POReference, i.DateOrdered, i.C_Currency_ID, i.C_ConversionType_ID, i.PaymentRule,
    i.C_PaymentTerm_ID, i.C_Charge_ID, i.M_PriceList_ID, i.C_Campaign_ID, i.C_Project_ID,
    i.C_Activity_ID, i.IsPrinted, i.IsDiscountPrinted, i.IsPaid, i.IsInDispute,
    i.IsPayScheduleValid, ips.C_InvoicePaySchedule_ID, i.InvoiceCollectionType, i.DunningGrace,
    null AS ChargeAmt,
    null AS TotalLines,
    CASE WHEN charAt(d.DocBaseType,3)='C' THEN ips.DueAmt*-1 ELSE ips.DueAmt END AS GrandTotal,
    CASE WHEN charAt(d.DocBaseType,3)='C' THEN -1 ELSE 1 END AS Multiplier,
    CASE WHEN charAt(d.DocBaseType,2)='P' THEN -1 ELSE 1 END AS MultiplierAP,
    d.DocBaseType
FROM C_Invoice i
    INNER JOIN C_DocType d ON (i.C_DocType_ID=d.C_DocType_ID)
    INNER JOIN C_InvoicePaySchedule ips ON (i.C_Invoice_ID=ips.C_Invoice_ID)
WHERE i.IsPayScheduleValid='Y'
    AND ips.IsValid='Y';

CREATE OR REPLACE VIEW C_INVOICELINE_V AS
SELECT il.AD_Client_ID, il.AD_Org_ID, 
	il.C_InvoiceLine_ID, i.C_Invoice_ID, i.SalesRep_ID, 
	i.C_BPartner_ID, il.M_Product_ID,  
	i.DocumentNo, i.DateInvoiced, i.DateAcct,
	i.IsSOTrx, i.DocStatus,
	ROUND(i.Multiplier*LineNetAmt, 2) AS LineNetAmt,
	ROUND(i.Multiplier*PriceList*QtyInvoiced, 2) AS LineListAmt,
	CASE WHEN COALESCE(il.PriceLimit, 0)=0 THEN ROUND(i.Multiplier*LineNetAmt,2) ELSE ROUND(i.Multiplier*il.PriceLimit*il.QtyInvoiced,2) END AS LineLimitAmt,
	ROUND(i.Multiplier*il.PriceList*il.QtyInvoiced-il.LineNetAmt,2) AS LineDiscountAmt,
	CASE WHEN COALESCE(il.PriceLimit,0)=0 THEN 0 ELSE ROUND(i.Multiplier*il.LineNetAmt-il.PriceLimit*il.QtyInvoiced,2) END AS LineOverLimitAmt,
	il.QtyInvoiced, il.QtyEntered,
	il.Line, il.C_OrderLine_ID, il.C_UOM_ID,
    il.C_Campaign_ID, il.C_Project_ID, il.C_Activity_ID, il.C_ProjectPhase_ID, il.C_ProjectTask_ID
FROM C_Invoice_v i, C_InvoiceLine il
WHERE i.C_Invoice_ID=il.C_Invoice_ID;

--COMMENT ON TABLE C_INVOICELINE_V IS 'Invoice Line Summary for Reporting Views - Corrected for Credit Memos';


CREATE OR REPLACE VIEW RV_BPARTNEROPEN
(AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, 
 UPDATED, UPDATEDBY, C_BPARTNER_ID, C_CURRENCY_ID, AMT, 
 OPENAMT, DATEDOC, DAYSDUE, C_CAMPAIGN_ID, C_PROJECT_ID, 
 C_ACTIVITY_ID)
AS 
SELECT i.AD_Client_ID,i.AD_Org_ID, i.IsActive, i.Created,i.CreatedBy,i.Updated,i.UpdatedBy,
    i.C_BPartner_ID, i.C_Currency_ID,
    i.GrandTotal*i.MultiplierAP AS Amt,
    invoiceOpen (i.C_Invoice_ID, i.C_InvoicePaySchedule_ID)*i.MultiplierAP AS OpenAmt,
    i.DateInvoiced AS DateDoc, 
    COALESCE(daysBetween(getdate(),ips.DueDate), paymentTermDueDays(C_PaymentTerm_ID,DateInvoiced,getdate())) AS DaysDue,
    i.C_Campaign_ID, i.C_Project_ID, i.C_Activity_ID
FROM C_Invoice_v i 
  LEFT OUTER JOIN C_InvoicePaySchedule ips ON (i.C_InvoicePaySchedule_ID=ips.C_InvoicePaySchedule_ID)
WHERE i.IsPaid='N'
 AND i.DocStatus IN ('CO','CL')
UNION
SELECT p.AD_Client_ID,p.AD_Org_ID, p.IsActive, p.Created,p.CreatedBy,p.Updated,p.UpdatedBy,
    p.C_BPartner_ID, p.C_Currency_ID,
    p.PayAmt*MultiplierAP*-1 AS Amt,
    paymentAvailable(p.C_Payment_ID)*p.MultiplierAP*-1 AS OpenAmt,
    p.DateTrx AS DateDoc,
    null,
    p.C_Campaign_ID, p.C_Project_ID, p.C_Activity_ID
FROM C_Payment_v p 
WHERE p.IsAllocated='N' AND p.C_BPartner_ID IS NOT NULL;

SELECT '029_FR_1804068_PG.sql' AS Filename;
update AD_Column set IsAlwaysUpdateable='Y' where AD_Column_ID=12569;
update AD_Column set IsAlwaysUpdateable='Y' where AD_Column_ID=12566;

INSERT INTO ad_element
            (ad_element_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             columnname, entitytype, NAME,
             printname
            )
     VALUES (53224, 0, 0, 'Y',
             TO_DATE ('2007-09-28', 'YYYY-MM-DD'), 100,
             TO_DATE ('2007-09-28', 'YYYY-MM-DD'), 100,
             'PrintUnprocessedOnly', 'D', 'Print Unprocessed Entries Only',
             'Print Unprocessed Entries Only'
            );


INSERT INTO AD_Process_Para
(AD_Process_Para_ID, AD_Client_ID, AD_Org_ID, IsActive, Created,
CreatedBy, Updated, UpdatedBy, Name,
Description,
Help,
AD_Process_ID, SeqNo, AD_Reference_ID, AD_Reference_Value_ID,
AD_Val_Rule_ID, ColumnName, IsCentrallyMaintained, FieldLength,
IsMandatory, DefaultValue, IsRange, AD_Element_ID, EntityType
)
VALUES 
(53011 , 0, 0, 'Y', TO_DATE ('2007-09-28', 'YYYY-MM-DD'),
100, TO_DATE ('2007-09-28', 'YYYY-MM-DD'), 100, 'Print Unprocessed Entries Only',
'Print the unprocessed (unprinted) entries of the dunning run only.',
'Print the unprocessed (unprinted) entries of the dunning run only. This allows you to reprint only certain dunning entries.',
312, 50, 20, NULL,
NULL, 'PrintUnprocessedOnly', 'N', 1,
'Y', 'Y', 'N', 53224, 'D'
);

INSERT INTO AD_VAL_RULE(
AD_VAL_RULE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,
UPDATED,UPDATEDBY,
NAME,DESCRIPTION,
TYPE,CODE,ENTITYTYPE)
values(51003,0,0,'Y',to_date('2007-09-28','RRRR-MM-DD'),100,
to_date('2007-09-28','RRRR-MM-DD'),100,
'C_DunningRun Unprocessed','Unprocessed Dunning Runs',
'S','C_DunningRun.Processed=''N''','D');

UPDATE AD_Process_Para SET AD_Val_Rule_ID=51003 WHERE AD_Process_Para_ID=578;


INSERT INTO ad_column
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description, 
             help, VERSION,
             entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, seqno, istranslated, isencrypted,
             isselectioncolumn, ad_element_id,  issyncdatabase,
             isalwaysupdateable
            )
     VALUES (53248, 0, 0, 'Y',
             TO_DATE ('2007-09-28','RRRR-MM-DD'),
             TO_DATE ('2007-09-28','RRRR-MM-DD'), 100,
             100, 'Dunning Level', 'Dunning Level', 
             'Dunning Level', 1,
             'D', 'C_DunningLevel_ID', 318, 19,
             22, 'N', 'N', 'N', 'Y',
             'N', 0, 'N', 'N',
             'N', 1075, 'N',
             'N'
            );

INSERT INTO ad_field
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description, 
             help,
             iscentrallymaintained, seqno, ad_tab_id,
             ad_column_id, isdisplayed, displaylength, isreadonly,
             issameline, isheading, isfieldonly, isencrypted, entitytype,
             displaylogic
            )
     VALUES (53258 , 0, 0, 'Y',
             TO_DATE ('2007-09-28','RRRR-MM-DD'), 100,
             TO_DATE ('2007-09-28','RRRR-MM-DD'), 100,
             'Dunning Level', 'Dunning Level', 
             'Dunning Level',
             'Y', 420 ,263,
             53248, 'Y', 14, 'Y',
             'Y', 'N', 'N', 'N', 'D',
             '@Processed@=Y'
            );    

ALTER TABLE C_Invoice ADD C_DunningLevel_ID NUMERIC(10) NULL;

INSERT INTO ad_column
            (ad_column_id, ad_client_id, ad_org_id, isactive,
             created,
             updated, createdby,
             updatedby, NAME, description, 
             help, VERSION,
             entitytype, columnname, ad_table_id, ad_reference_id,
             fieldlength, iskey, isparent, ismandatory, isupdateable,
             isidentifier, seqno, istranslated, isencrypted,
             isselectioncolumn, ad_element_id,  issyncdatabase,
             isalwaysupdateable
            )
     VALUES (53249, 0, 0, 'Y',
             TO_DATE ('2007-09-28','RRRR-MM-DD'),
             TO_DATE ('2007-09-28','RRRR-MM-DD'), 100,
             100, 'Invoice Payment Schedule', 'Invoice Payment Schedule', 
             'Invoice Payment Schedule', 1,
             'D', 'C_InvoicePaySchedule_ID', 524, 19,
             22, 'N', 'N', 'N', 'Y',
             'N', 0, 'N', 'N',
             'N', 1995, 'N',
             'N'
            );

INSERT INTO ad_field
            (ad_field_id, ad_client_id, ad_org_id, isactive,
             created, createdby,
             updated, updatedby,
             NAME, description, 
             help,
             iscentrallymaintained, seqno, ad_tab_id,
             ad_column_id, isdisplayed, displaylength, isreadonly,
             issameline, isheading, isfieldonly, isencrypted, entitytype
            )
     VALUES (53259 , 0, 0, 'Y',
             TO_DATE ('2007-09-28','RRRR-MM-DD'), 100,
             TO_DATE ('2007-09-28','RRRR-MM-DD'), 100,
             'Invoice Payment Schedule', 'Invoice Payment Schedule', 
             'Invoice Payment Schedule',
             'Y', 65 ,635,
             53249, 'Y', 26, 'Y',
             'N', 'N', 'N', 'N', 'D'
            );    

ALTER TABLE C_DunningRunLine ADD C_InvoicePaySchedule_ID NUMERIC(10) NULL;




UPDATE AD_SEQUENCE
SET currentnextsys = (SELECT MAX (ad_process_para_id) + 1
FROM AD_Process_Para
WHERE AD_Process_Para_ID < 1000000)
WHERE NAME = 'AD_Process_Para';

UPDATE AD_SEQUENCE
SET currentnextsys = (SELECT MAX (AD_Val_Rule_id) + 1
FROM AD_Val_Rule
WHERE AD_Val_Rule_ID < 1000000)
WHERE NAME = 'AD_Val_Rule';

UPDATE ad_sequence
SET currentnextsys = (SELECT MAX (ad_element_id) + 1
FROM ad_element
WHERE ad_element_id < 1000000)
WHERE NAME = 'AD_Element';

UPDATE ad_sequence
SET currentnextsys = (SELECT MAX (ad_column_id) + 1
FROM ad_column
WHERE ad_column_id < 1000000)
WHERE NAME = 'AD_Column';

UPDATE ad_sequence
SET currentnextsys = (SELECT MAX (ad_field_id) + 1
FROM ad_field
WHERE ad_field_id < 1000000)
WHERE NAME = 'AD_Field';




SELECT '030_BF_1824260.sql' AS Filename;
-- BF [ 1824260 ] TRUNC function not working like in Oracle
-- http://sourceforge.net/tracker/?func=detail&atid=879332&aid=1824260&group_id=176962
DROP VIEW c_invoice_candidate_v;

drop function trunc(datetime TIMESTAMP WITH TIME ZONE);
CREATE OR REPLACE FUNCTION trunc(datetime TIMESTAMP WITH TIME ZONE)
RETURNS TIMESTAMP WITH TIME ZONE AS $$
BEGIN
	RETURN CAST(datetime AS DATE);
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE VIEW c_invoice_candidate_v AS 
 SELECT o.ad_client_id, o.ad_org_id, o.c_bpartner_id, o.c_order_id, o.documentno, o.dateordered, o.c_doctype_id, sum((l.qtyordered - l.qtyinvoiced) * l.priceactual) AS totallines
   FROM c_order o
   JOIN c_orderline l ON o.c_order_id = l.c_order_id
   JOIN c_bpartner bp ON o.c_bpartner_id = bp.c_bpartner_id
   LEFT JOIN c_invoiceschedule si ON bp.c_invoiceschedule_id = si.c_invoiceschedule_id
  WHERE (o.docstatus = ANY (ARRAY['CO'::bpchar, 'CL'::bpchar, 'IP'::bpchar])) AND (o.c_doctype_id IN ( SELECT c_doctype.c_doctype_id
   FROM c_doctype
  WHERE c_doctype.docbasetype = 'SOO'::bpchar AND (c_doctype.docsubtypeso <> ALL (ARRAY['ON'::bpchar, 'OB'::bpchar, 'WR'::bpchar])))) AND l.qtyordered <> l.qtyinvoiced AND (o.invoicerule = 'I'::bpchar OR o.invoicerule = 'O'::bpchar OR o.invoicerule = 'D'::bpchar AND l.qtyinvoiced <> l.qtydelivered OR o.invoicerule = 'S'::bpchar AND bp.c_invoiceschedule_id IS NULL OR o.invoicerule = 'S'::bpchar AND bp.c_invoiceschedule_id IS NOT NULL AND (si.invoicefrequency IS NULL OR si.invoicefrequency = 'D'::bpchar OR si.invoicefrequency = 'W'::bpchar OR si.invoicefrequency = 'T'::bpchar AND (trunc(o.dateordered::timestamp with time zone) <= (firstof(getdate(), 'MM'::character varying)::timestamp with time zone + si.invoicedaycutoff - 1) AND trunc(getdate()) >= (firstof(o.dateordered::timestamp with time zone, 'MM'::character varying)::timestamp with time zone + si.invoiceday - 1) OR trunc(o.dateordered::timestamp with time zone) <= (firstof(getdate(), 'MM'::character varying)::timestamp with time zone + si.invoicedaycutoff + 14) AND trunc(getdate()) >= (firstof(o.dateordered::timestamp with time zone, 'MM'::character varying)::timestamp with time zone + si.invoiceday + 14)) OR si.invoicefrequency = 'M'::bpchar AND trunc(o.dateordered::timestamp with time zone) <= (firstof(getdate(), 'MM'::character varying)::timestamp with time zone + si.invoicedaycutoff - 1) AND trunc(getdate()) >= (firstof(o.dateordered::timestamp with time zone, 'MM'::character varying)::timestamp with time zone + si.invoiceday - 1)))
  GROUP BY o.ad_client_id, o.ad_org_id, o.c_bpartner_id, o.c_order_id, o.documentno, o.dateordered, o.c_doctype_id;

ALTER TABLE c_invoice_candidate_v OWNER TO adempiere;

CREATE OR REPLACE FUNCTION trunc(datetime TIMESTAMP WITH TIME ZONE, format varchar)
RETURNS DATE AS $$
BEGIN
	IF format = 'Q' THEN
		RETURN CAST(DATE_Trunc('quarter',datetime) as DATE);
	ELSIF format = 'Y' or format = 'YEAR' THEN
		RETURN CAST(DATE_Trunc('year',datetime) as DATE);
	ELSIF format = 'MM' or format = 'MONTH' THEN
		RETURN CAST(DATE_Trunc('month',datetime) as DATE);
	ELSIF format = 'DD' THEN
		RETURN CAST(DATE_Trunc('day',datetime) as DATE);
	ELSIF format = 'DY' THEN
		RETURN CAST(DATE_Trunc('day',datetime) as DATE);
	ELSE
		RETURN CAST(datetime AS DATE);
	END IF;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION trunc(i INTERVAL)
RETURNS INTEGER AS $$
BEGIN
	RETURN EXTRACT(DAY FROM i);
END;
$$ LANGUAGE plpgsql;

SELECT '031_FR_1823186.sql' AS Filename;
--
-- ad_menu
-- 

INSERT INTO ad_process (ad_process_id, 
                                  ad_client_id, 
                                  ad_org_id, 
                                  isactive, 
                                  created, 
                                  createdby, 
                                  updated, 
                                  updatedby, 
                                  value, 
                                  name, 
                                  description, 
                                  help, 
                                  accesslevel, 
                                  entitytype, 
                                  procedurename, 
                                  isreport, 
                                  isdirectprint, 
                                  ad_reportview_id, 
                                  classname, 
                                  statistic_count, 
                                  statistic_seconds, 
                                  ad_printformat_id, 
                                  workflowvalue, 
                                  ad_workflow_id, 
                                  isbetafunctionality, 
                                  isserverprocess, 
                                  showhelp, 
                                  jasperreport)
                                  VALUES 
                                 (53002, 
                                  0, 
                                  0, 
                                  'Y', 
                                  TO_TIMESTAMP('2007-11-3 21:38:36:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                  0, 
                                  TO_TIMESTAMP('2007-11-3 21:38:36:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                  0, 
                                  'Setup Web POS', 
                                  'Setup Web POS', 
                                  NULL, 
                                  NULL, 
                                  '3', 
                                  'C', 
                                  NULL, 
                                  'N', 
                                  'N', 
                                  NULL, 
                                  'org.posterita.process.SetupWebPOS', 
                                  0, 
                                  0, 
                                  NULL, 
                                  NULL, 
                                  NULL, 
                                  'N', 
                                  'N', 
                                  'Y', 
                                  NULL);

INSERT INTO ad_menu (ad_menu_id, 
                               ad_client_id, 
                               ad_org_id, 
                               isactive, 
                               created, 
                               createdby, 
                               updated, 
                               name, 
                               updatedby, 
                               description, 
                               issummary, 
                               issotrx, 
                               isreadonly, 
                               action, 
                               ad_window_id, 
                               ad_workflow_id, 
                               ad_task_id, 
                               ad_process_id, 
                               ad_form_id, 
                               ad_workbench_id, 
                               entitytype)
                               VALUES 
                              (53013, 
                               0, 
                               0, 
                               'Y', 
                               TO_TIMESTAMP('2007-11-3 21:38:38:0','YYYY-MM-DD HH:MI:SS:MS'), 
                               0, 
                               TO_TIMESTAMP('2007-11-3 21:38:38:0','YYYY-MM-DD HH:MI:SS:MS'), 
                               'Setup Web POS', 
                               0, 
                               NULL, 
                               'N', 
                               'N', 
                               'N', 
                               'P', 
                               NULL, 
                               NULL, 
                               NULL, 
                               53002, 
                               NULL, 
                               NULL, 
                               'C');



--
-- ad_process_access
-- 

UPDATE ad_process_access SET created = TO_TIMESTAMP('2007-11-3 21:16:37:125','YYYY-MM-DD HH:MI:SS:MS'), 
                                       updated = TO_TIMESTAMP('2007-11-3 21:16:37:125','YYYY-MM-DD HH:MI:SS:MS') WHERE ad_process_id = 52003 AND ad_role_id = 0;
UPDATE ad_process_access SET created = TO_TIMESTAMP('2007-11-3 21:16:37:125','YYYY-MM-DD HH:MI:SS:MS'), 
                                       updated = TO_TIMESTAMP('2007-11-3 21:16:37:125','YYYY-MM-DD HH:MI:SS:MS') WHERE ad_process_id = 52003 AND ad_role_id = 102;
UPDATE ad_process_access SET created = TO_TIMESTAMP('2007-11-3 21:16:37:125','YYYY-MM-DD HH:MI:SS:MS'), 
                                       updated = TO_TIMESTAMP('2007-11-3 21:16:37:125','YYYY-MM-DD HH:MI:SS:MS') WHERE ad_process_id = 52003 AND ad_role_id = 103;


--
-- ad_process_para
-- 

INSERT INTO ad_process_para (ad_process_para_id, 
                                       ad_client_id, 
                                       ad_org_id, 
                                       isactive, 
                                       created, 
                                       createdby, 
                                       updated, 
                                       updatedby, 
                                       name, 
                                       description, 
                                       help, 
                                       ad_process_id, 
                                       seqno, 
                                       ad_reference_id, 
                                       ad_reference_value_id, 
                                       ad_val_rule_id, 
                                       columnname, 
                                       iscentrallymaintained, 
                                       fieldlength, 
                                       ismandatory, 
                                       isrange, 
                                       defaultvalue, 
                                       defaultvalue2, 
                                       vformat, 
                                       valuemin, 
                                       valuemax, 
                                       ad_element_id, 
                                       entitytype)
                                       VALUES 
                                      (53012, 
                                       0, 
                                       0, 
                                       'Y', 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       'Price List Version', 
                                       'Identifies a unique instance of a Price List', 
                                       'Each Price List can have multiple versions.  The most common use is to indicate the dates that a Price List is valid for.', 
                                       53002, 
                                       20, 
                                       19, 
                                       NULL, 
                                       NULL, 
                                       'M_PriceList_Version_ID', 
                                       'Y', 
                                       10, 
                                       'Y', 
                                       'N', 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       450, 
                                       'C');
INSERT INTO ad_process_para (ad_process_para_id, 
                                       ad_client_id, 
                                       ad_org_id, 
                                       isactive, 
                                       created, 
                                       createdby, 
                                       updated, 
                                       updatedby, 
                                       name, 
                                       description, 
                                       help, 
                                       ad_process_id, 
                                       seqno, 
                                       ad_reference_id, 
                                       ad_reference_value_id, 
                                       ad_val_rule_id, 
                                       columnname, 
                                       iscentrallymaintained, 
                                       fieldlength, 
                                       ismandatory, 
                                       isrange, 
                                       defaultvalue, 
                                       defaultvalue2, 
                                       vformat, 
                                       valuemin, 
                                       valuemax, 
                                       ad_element_id, 
                                       entitytype)
                                       VALUES 
                                      (53013, 
                                       0, 
                                       0, 
                                       'Y', 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       'Organization', 
                                       'Organizational entity within client', 
                                       'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.', 
                                       53002, 
                                       10, 
                                       19, 
                                       NULL, 
                                       130, 
                                       'AD_Org_ID', 
                                       'Y', 
                                       10, 
                                       'Y', 
                                       'N', 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       113, 
                                       'C');
INSERT INTO ad_process_para (ad_process_para_id, 
                                       ad_client_id, 
                                       ad_org_id, 
                                       isactive, 
                                       created, 
                                       createdby, 
                                       updated, 
                                       updatedby, 
                                       name, 
                                       description, 
                                       help, 
                                       ad_process_id, 
                                       seqno, 
                                       ad_reference_id, 
                                       ad_reference_value_id, 
                                       ad_val_rule_id, 
                                       columnname, 
                                       iscentrallymaintained, 
                                       fieldlength, 
                                       ismandatory, 
                                       isrange, 
                                       defaultvalue, 
                                       defaultvalue2, 
                                       vformat, 
                                       valuemin, 
                                       valuemax, 
                                       ad_element_id, 
                                       entitytype)
                                       VALUES 
                                      (53014, 
                                       0, 
                                       0, 
                                       'Y', 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       'Bank', 
                                       'Bank', 
                                       'The Bank is a unique identifier of a Bank for this Organization or for a Business Partner with whom this Organization transacts.', 
                                       53002, 
                                       50, 
                                       19, 
                                       NULL, 
                                       NULL, 
                                       'C_Bank_ID', 
                                       'Y', 
                                       10, 
                                       'Y', 
                                       'N', 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       835, 
                                       'C');
INSERT INTO ad_process_para (ad_process_para_id, 
                                       ad_client_id, 
                                       ad_org_id, 
                                       isactive, 
                                       created, 
                                       createdby, 
                                       updated, 
                                       updatedby, 
                                       name, 
                                       description, 
                                       help, 
                                       ad_process_id, 
                                       seqno, 
                                       ad_reference_id, 
                                       ad_reference_value_id, 
                                       ad_val_rule_id, 
                                       columnname, 
                                       iscentrallymaintained, 
                                       fieldlength, 
                                       ismandatory, 
                                       isrange, 
                                       defaultvalue, 
                                       defaultvalue2, 
                                       vformat, 
                                       valuemin, 
                                       valuemax, 
                                       ad_element_id, 
                                       entitytype)
                                       VALUES 
                                      (53015, 
                                       0, 
                                       0, 
                                       'Y', 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       'Bank Account', 
                                       'Account at the Bank', 
                                       'The Bank Account identifies an account at this Bank.', 
                                       53002, 
                                       60, 
                                       19, 
                                       NULL, 
                                       NULL, 
                                       'C_BankAccount_ID', 
                                       'Y', 
                                       10, 
                                       'Y', 
                                       'N', 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       836, 
                                       'C');
INSERT INTO ad_process_para (ad_process_para_id, 
                                       ad_client_id, 
                                       ad_org_id, 
                                       isactive, 
                                       created, 
                                       createdby, 
                                       updated, 
                                       updatedby, 
                                       name, 
                                       description, 
                                       help, 
                                       ad_process_id, 
                                       seqno, 
                                       ad_reference_id, 
                                       ad_reference_value_id, 
                                       ad_val_rule_id, 
                                       columnname, 
                                       iscentrallymaintained, 
                                       fieldlength, 
                                       ismandatory, 
                                       isrange, 
                                       defaultvalue, 
                                       defaultvalue2, 
                                       vformat, 
                                       valuemin, 
                                       valuemax, 
                                       ad_element_id, 
                                       entitytype)
                                       VALUES 
                                      (53016, 
                                       0, 
                                       0, 
                                       'Y', 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       'Tax Category', 
                                       'Tax Category', 
                                       'The Tax Category provides a method of grouping similar taxes.  For example, Sales Tax or Value Added Tax.', 
                                       53002, 
                                       70, 
                                       19, 
                                       NULL, 
                                       NULL, 
                                       'C_TaxCategory_ID', 
                                       'Y', 
                                       10, 
                                       'Y', 
                                       'N', 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       211, 
                                       'C');
INSERT INTO ad_process_para (ad_process_para_id, 
                                       ad_client_id, 
                                       ad_org_id, 
                                       isactive, 
                                       created, 
                                       createdby, 
                                       updated, 
                                       updatedby, 
                                       name, 
                                       description, 
                                       help, 
                                       ad_process_id, 
                                       seqno, 
                                       ad_reference_id, 
                                       ad_reference_value_id, 
                                       ad_val_rule_id, 
                                       columnname, 
                                       iscentrallymaintained, 
                                       fieldlength, 
                                       ismandatory, 
                                       isrange, 
                                       defaultvalue, 
                                       defaultvalue2, 
                                       vformat, 
                                       valuemin, 
                                       valuemax, 
                                       ad_element_id, 
                                       entitytype)
                                       VALUES 
                                      (53017, 
                                       0, 
                                       0, 
                                       'Y', 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       'Locator', 
                                       'Warehouse Locator', 
                                       'The Locator indicates where in a Warehouse a product is located.', 
                                       53002, 
                                       80, 
                                       19, 
                                       NULL, 
                                       NULL, 
                                       'M_Locator_ID', 
                                       'Y', 
                                       10, 
                                       'Y', 
                                       'N', 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       448, 
                                       'C');
INSERT INTO ad_process_para (ad_process_para_id, 
                                       ad_client_id, 
                                       ad_org_id, 
                                       isactive, 
                                       created, 
                                       createdby, 
                                       updated, 
                                       updatedby, 
                                       name, 
                                       description, 
                                       help, 
                                       ad_process_id, 
                                       seqno, 
                                       ad_reference_id, 
                                       ad_reference_value_id, 
                                       ad_val_rule_id, 
                                       columnname, 
                                       iscentrallymaintained, 
                                       fieldlength, 
                                       ismandatory, 
                                       isrange, 
                                       defaultvalue, 
                                       defaultvalue2, 
                                       vformat, 
                                       valuemin, 
                                       valuemax, 
                                       ad_element_id, 
                                       entitytype)
                                       VALUES 
                                      (53018, 
                                       0, 
                                       0, 
                                       'Y', 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       'Business Partner ', 
                                       'Identifies a Business Partner', 
                                       'A Business Partner is anyone with whom you transact.  This can include Vendor, Customer, Employee or Salesperson', 
                                       53002, 
                                       90, 
                                       19, 
                                       NULL, 
                                       NULL, 
                                       'C_BPartner_ID', 
                                       'Y', 
                                       10, 
                                       'Y', 
                                       'N', 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       187, 
                                       'C');
INSERT INTO ad_process_para (ad_process_para_id, 
                                       ad_client_id, 
                                       ad_org_id, 
                                       isactive, 
                                       created, 
                                       createdby, 
                                       updated, 
                                       updatedby, 
                                       name, 
                                       description, 
                                       help, 
                                       ad_process_id, 
                                       seqno, 
                                       ad_reference_id, 
                                       ad_reference_value_id, 
                                       ad_val_rule_id, 
                                       columnname, 
                                       iscentrallymaintained, 
                                       fieldlength, 
                                       ismandatory, 
                                       isrange, 
                                       defaultvalue, 
                                       defaultvalue2, 
                                       vformat, 
                                       valuemin, 
                                       valuemax, 
                                       ad_element_id, 
                                       entitytype)
                                       VALUES 
                                      (53019, 
                                       0, 
                                       0, 
                                       'Y', 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       'Sales Representative', 
                                       'Sales Representative or Company Agent', 
                                       'The Sales Representative indicates the Sales Rep for this Region.  Any Sales Rep must be a valid internal user.', 
                                       53002, 
                                       100, 
                                       18, 
                                       190, 
                                       NULL, 
                                       'SalesRep_ID', 
                                       'Y', 
                                       10, 
                                       'Y', 
                                       'N', 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       409, 
                                       'C');
INSERT INTO ad_process_para (ad_process_para_id, 
                                       ad_client_id, 
                                       ad_org_id, 
                                       isactive, 
                                       created, 
                                       createdby, 
                                       updated, 
                                       updatedby, 
                                       name, 
                                       description, 
                                       help, 
                                       ad_process_id, 
                                       seqno, 
                                       ad_reference_id, 
                                       ad_reference_value_id, 
                                       ad_val_rule_id, 
                                       columnname, 
                                       iscentrallymaintained, 
                                       fieldlength, 
                                       ismandatory, 
                                       isrange, 
                                       defaultvalue, 
                                       defaultvalue2, 
                                       vformat, 
                                       valuemin, 
                                       valuemax, 
                                       ad_element_id, 
                                       entitytype)
                                       VALUES 
                                      (53020, 
                                       0, 
                                       0, 
                                       'Y', 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       'Role', 
                                       'Responsibility Role', 
                                       'The Role determines security and access a user who has this Role will have in the System.', 
                                       53002, 
                                       110, 
                                       19, 
                                       NULL, 
                                       NULL, 
                                       'AD_Role_ID', 
                                       'Y', 
                                       10, 
                                       'Y', 
                                       'N', 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       123, 
                                       'C');
INSERT INTO ad_process_para (ad_process_para_id, 
                                       ad_client_id, 
                                       ad_org_id, 
                                       isactive, 
                                       created, 
                                       createdby, 
                                       updated, 
                                       updatedby, 
                                       name, 
                                       description, 
                                       help, 
                                       ad_process_id, 
                                       seqno, 
                                       ad_reference_id, 
                                       ad_reference_value_id, 
                                       ad_val_rule_id, 
                                       columnname, 
                                       iscentrallymaintained, 
                                       fieldlength, 
                                       ismandatory, 
                                       isrange, 
                                       defaultvalue, 
                                       defaultvalue2, 
                                       vformat, 
                                       valuemin, 
                                       valuemax, 
                                       ad_element_id, 
                                       entitytype)
                                       VALUES 
                                      (53021, 
                                       0, 
                                       0, 
                                       'Y', 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       'Cash Book', 
                                       'Cash Book for recording petty cash transactions', 
                                       'The Cash Book identifies a unique cash book.  The cash book is used to record cash transactions.', 
                                       53002, 
                                       15, 
                                       19, 
                                       NULL, 
                                       NULL, 
                                       'C_CashBook_ID', 
                                       'Y', 
                                       10, 
                                       'Y', 
                                       'N', 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       1463, 
                                       'C');
INSERT INTO ad_process_para (ad_process_para_id, 
                                       ad_client_id, 
                                       ad_org_id, 
                                       isactive, 
                                       created, 
                                       createdby, 
                                       updated, 
                                       updatedby, 
                                       name, 
                                       description, 
                                       help, 
                                       ad_process_id, 
                                       seqno, 
                                       ad_reference_id, 
                                       ad_reference_value_id, 
                                       ad_val_rule_id, 
                                       columnname, 
                                       iscentrallymaintained, 
                                       fieldlength, 
                                       ismandatory, 
                                       isrange, 
                                       defaultvalue, 
                                       defaultvalue2, 
                                       vformat, 
                                       valuemin, 
                                       valuemax, 
                                       ad_element_id, 
                                       entitytype)
                                       VALUES 
                                      (53022, 
                                       0, 
                                       0, 
                                       'Y', 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       'Name', 
                                       'Alphanumeric identifier of the entity', 
                                       'The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.', 
                                       53002, 
                                       130, 
                                       10, 
                                       NULL, 
                                       NULL, 
                                       'Name', 
                                       'Y', 
                                       60, 
                                       'Y', 
                                       'N', 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       469, 
                                       'C');
INSERT INTO ad_process_para (ad_process_para_id, 
                                       ad_client_id, 
                                       ad_org_id, 
                                       isactive, 
                                       created, 
                                       createdby, 
                                       updated, 
                                       updatedby, 
                                       name, 
                                       description, 
                                       help, 
                                       ad_process_id, 
                                       seqno, 
                                       ad_reference_id, 
                                       ad_reference_value_id, 
                                       ad_val_rule_id, 
                                       columnname, 
                                       iscentrallymaintained, 
                                       fieldlength, 
                                       ismandatory, 
                                       isrange, 
                                       defaultvalue, 
                                       defaultvalue2, 
                                       vformat, 
                                       valuemin, 
                                       valuemax, 
                                       ad_element_id, 
                                       entitytype)
                                       VALUES 
                                      (53023, 
                                       0, 
                                       0, 
                                       'Y', 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       'Host Address', 
                                       'Host Address URL or DNS', 
                                       'The Host Address identifies the URL or DNS of the target host', 
                                       53002, 
                                       140, 
                                       10, 
                                       NULL, 
                                       NULL, 
                                       'HostAddress', 
                                       'Y', 
                                       60, 
                                       'Y', 
                                       'N', 
                                       'http://', 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       1398, 
                                       'C');
INSERT INTO ad_process_para (ad_process_para_id, 
                                       ad_client_id, 
                                       ad_org_id, 
                                       isactive, 
                                       created, 
                                       createdby, 
                                       updated, 
                                       updatedby, 
                                       name, 
                                       description, 
                                       help, 
                                       ad_process_id, 
                                       seqno, 
                                       ad_reference_id, 
                                       ad_reference_value_id, 
                                       ad_val_rule_id, 
                                       columnname, 
                                       iscentrallymaintained, 
                                       fieldlength, 
                                       ismandatory, 
                                       isrange, 
                                       defaultvalue, 
                                       defaultvalue2, 
                                       vformat, 
                                       valuemin, 
                                       valuemax, 
                                       ad_element_id, 
                                       entitytype)
                                       VALUES 
                                      (53024, 
                                       0, 
                                       0, 
                                       'Y', 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       TO_TIMESTAMP('2007-11-3 21:38:37:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       'Discount Schema', 
                                       'Schema to calculate the trade discount percentage', 
                                       'After calculation of the (standard) price, the trade discount percentage is calculated and applied resulting in the final price.', 
                                       53002, 
                                       25, 
                                       19, 
                                       NULL, 
                                       NULL, 
                                       'M_DiscountSchema_ID', 
                                       'Y', 
                                       10, 
                                       'Y', 
                                       'N', 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       1714, 
                                       'C');
INSERT INTO ad_process_para (ad_process_para_id, 
                                       ad_client_id, 
                                       ad_org_id, 
                                       isactive, 
                                       created, 
                                       createdby, 
                                       updated, 
                                       updatedby, 
                                       name, 
                                       description, 
                                       help, 
                                       ad_process_id, 
                                       seqno, 
                                       ad_reference_id, 
                                       ad_reference_value_id, 
                                       ad_val_rule_id, 
                                       columnname, 
                                       iscentrallymaintained, 
                                       fieldlength, 
                                       ismandatory, 
                                       isrange, 
                                       defaultvalue, 
                                       defaultvalue2, 
                                       vformat, 
                                       valuemin, 
                                       valuemax, 
                                       ad_element_id, 
                                       entitytype)
                                       VALUES 
                                      (53025, 
                                       0, 
                                       0, 
                                       'Y', 
                                       TO_TIMESTAMP('2007-11-3 21:38:38:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       TO_TIMESTAMP('2007-11-3 21:38:38:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       'Purchase Price List Version', 
                                       NULL, 
                                       NULL, 
                                       53002, 
                                       30, 
                                       18, 
                                       188, 
                                       NULL, 
                                       'PriceList_Version_ID', 
                                       'Y', 
                                       10, 
                                       'Y', 
                                       'N', 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       450, 
                                       'C');
INSERT INTO ad_process_para (ad_process_para_id, 
                                       ad_client_id, 
                                       ad_org_id, 
                                       isactive, 
                                       created, 
                                       createdby, 
                                       updated, 
                                       updatedby, 
                                       name, 
                                       description, 
                                       help, 
                                       ad_process_id, 
                                       seqno, 
                                       ad_reference_id, 
                                       ad_reference_value_id, 
                                       ad_val_rule_id, 
                                       columnname, 
                                       iscentrallymaintained, 
                                       fieldlength, 
                                       ismandatory, 
                                       isrange, 
                                       defaultvalue, 
                                       defaultvalue2, 
                                       vformat, 
                                       valuemin, 
                                       valuemax, 
                                       ad_element_id, 
                                       entitytype)
                                       VALUES 
                                      (53026, 
                                       0, 
                                       0, 
                                       'Y', 
                                       TO_TIMESTAMP('2007-11-3 21:38:38:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       TO_TIMESTAMP('2007-11-3 21:38:38:0','YYYY-MM-DD HH:MI:SS:MS'), 
                                       0, 
                                       'UserPIN', 
                                       NULL, 
                                       NULL, 
                                       53002, 
                                       120, 
                                       10, 
                                       NULL, 
                                       NULL, 
                                       'UserPIN', 
                                       'Y', 
                                       10, 
                                       'Y', 
                                       'N', 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       NULL, 
                                       52023, 
                                       'C');


--
-- ad_treenodemm
-- 

INSERT INTO ad_treenodemm (ad_tree_id, 
                                     node_id, 
                                     ad_client_id, 
                                     ad_org_id, 
                                     isactive, 
                                     created, 
                                     createdby, 
                                     updated, 
                                     updatedby, 
                                     parent_id, 
                                     seqno)
                                     VALUES 
                                    (10, 
                                     53013, 
                                     0, 
                                     0, 
                                     'Y', 
                                     TO_TIMESTAMP('2007-11-3 21:38:36:665','YYYY-MM-DD HH:MI:SS:MS'), 
                                     0, 
                                     TO_TIMESTAMP('2007-11-3 21:38:36:665','YYYY-MM-DD HH:MI:SS:MS'), 
                                     0, 
                                     52001, 
                                     5);

INSERT INTO AD_Process_Access (AD_Client_ID,AD_Org_ID,IsReadWrite,Created,AD_Process_ID,CreatedBy,Updated,UpdatedBy,IsActive,AD_Role_ID) VALUES (11,0,'Y',TO_TIMESTAMP('2007-11-05 14:26:09','YYYY-MM-DD HH24:MI:SS'),53002,100,TO_TIMESTAMP('2007-11-05 14:26:09','YYYY-MM-DD HH24:MI:SS'),100,'Y',102);
SELECT '033_centralized_id_sysconfig.sql' AS Filename;
INSERT INTO AD_SYSCONFIG
            (ad_sysconfig_id, ad_client_id, ad_org_id,
             created,
             updated, createdby,
             updatedby, isactive, NAME,
             VALUE,
             description
            )
     VALUES (50000, 0, 0,
             TO_DATE ('10/13/2007 14:30:57', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('10/13/2007 14:32:17', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Y', 'DICTIONARY_ID_WEBSITE',
             'http://developer.adempiere.com/cgi-bin/get_ID',
             'Website where the system sequences are found (MSequence)'
            );

INSERT INTO AD_SYSCONFIG
            (ad_sysconfig_id, ad_client_id, ad_org_id,
             created,
             updated, createdby,
             updatedby, isactive, NAME, VALUE,
             description
            )
     VALUES (50001, 0, 0,
             TO_DATE ('10/13/2007 14:31:09', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('10/13/2007 14:32:45', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Y', 'DICTIONARY_ID_USER', 'globalqss',
             'User (sourceforge developer) to get the system sequences (MSequence)'
            );

INSERT INTO AD_SYSCONFIG
            (ad_sysconfig_id, ad_client_id, ad_org_id,
             created,
             updated, createdby,
             updatedby, isactive, NAME, VALUE,
             description
            )
     VALUES (50002, 0, 0,
             TO_DATE ('10/13/2007 14:31:19', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('10/13/2007 14:33:03', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Y', 'DICTIONARY_ID_PASSWORD', 'password_inseguro',
             'Password to get the system sequences (MSequence)'
            );

INSERT INTO AD_SYSCONFIG
            (ad_sysconfig_id, ad_client_id, ad_org_id,
             created,
             updated, createdby,
             updatedby, isactive, NAME,
             VALUE,
             description
            )
     VALUES (50003, 0, 0,
             TO_DATE ('10/13/2007 14:31:38', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('10/13/2007 14:33:17', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Y', 'DICTIONARY_ID_COMMENTS',
             'Default comment for updating dictionary',
             'Comment to reserve the system sequences (MSequence)'
            );

INSERT INTO AD_SYSCONFIG
            (ad_sysconfig_id, ad_client_id, ad_org_id,
             created,
             updated, createdby,
             updatedby, isactive, NAME,
             VALUE,
             description
            )
     VALUES (50004, 0, 0,
             TO_DATE ('10/13/2007 14:30:57', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('10/13/2007 14:32:17', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Y', 'PROJECT_ID_WEBSITE',
             'http://developer.adempiere.com/cgi-bin/get_ID',
             'Website where the system sequences are found (MSequence)'
            );

INSERT INTO AD_SYSCONFIG
            (ad_sysconfig_id, ad_client_id, ad_org_id,
             created,
             updated, createdby,
             updatedby, isactive, NAME, VALUE,
             description
            )
     VALUES (50005, 0, 0,
             TO_DATE ('10/13/2007 14:30:57', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('10/13/2007 14:32:17', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Y', 'PROJECT_ID_PROJECT', 'TestProject',
             'Name of the project you are working on for development'
            );

INSERT INTO AD_SYSCONFIG
            (ad_sysconfig_id, ad_client_id, ad_org_id,
             created,
             updated, createdby,
             updatedby, isactive, NAME, VALUE,
             description
            )
     VALUES (50006, 0, 0,
             TO_DATE ('10/13/2007 14:31:09', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('10/13/2007 14:32:45', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Y', 'PROJECT_ID_USER', 'globalqss',
             'User (sourceforge developer) to get the system sequences (MSequence)'
            );

INSERT INTO AD_SYSCONFIG
            (ad_sysconfig_id, ad_client_id, ad_org_id,
             created,
             updated, createdby,
             updatedby, isactive, NAME, VALUE,
             description
            )
     VALUES (50007, 0, 0,
             TO_DATE ('10/13/2007 14:31:19', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('10/13/2007 14:33:03', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Y', 'PROJECT_ID_PASSWORD', 'password_inseguro',
             'Password to get the system sequences (MSequence)'
            );

INSERT INTO AD_SYSCONFIG
            (ad_sysconfig_id, ad_client_id, ad_org_id,
             created,
             updated, createdby,
             updatedby, isactive, NAME,
             VALUE,
             description
            )
     VALUES (50008, 0, 0,
             TO_DATE ('10/13/2007 14:31:38', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('10/13/2007 14:33:17', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Y', 'PROJECT_ID_COMMENTS',
             'Default comment for updating dictionary',
             'Comment to reserve the system sequences (MSequence)'
            );

INSERT INTO AD_SYSCONFIG
            (ad_sysconfig_id, ad_client_id, ad_org_id,
             created,
             updated, createdby,
             updatedby, isactive, NAME, VALUE,
             description
            )
     VALUES (50009, 0, 0,
             TO_DATE ('10/13/2007 14:30:57', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('10/13/2007 14:32:17', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Y', 'DICTIONARY_ID_USE_CENTRALIZED_ID', 'Y',
             'Flag to indicate if we use centralized ID approach or not'
            );

INSERT INTO AD_SYSCONFIG
            (ad_sysconfig_id, ad_client_id, ad_org_id,
             created,
             updated, createdby,
             updatedby, isactive, NAME, VALUE,
             description
            )
     VALUES (50010, 0, 0,
             TO_DATE ('10/13/2007 14:30:57', 'MM/DD/YYYY HH24:MI:SS'),
             TO_DATE ('10/13/2007 14:32:17', 'MM/DD/YYYY HH24:MI:SS'), 100,
             100, 'Y', 'PROJECT_ID_USE_CENTRALIZED_ID', 'N',
             'Flag to indicate if we use centralized ID approach or not'
            );



SELECT '034_message_logmigrationscript.sql' AS Filename;
-- Nov 11, 2007 1:54:50 AM COT
-- FR 1829798 - Easy generation of migration scripts
INSERT INTO AD_MESSAGE (AD_Client_ID,AD_Message_ID,AD_Org_ID,Created,CreatedBy,EntityType,IsActive,MsgText,MsgTip,MsgType,Updated,UpdatedBy,VALUE) VALUES (0,53007,0,TO_TIMESTAMP('2007-11-11 01:54:49','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','Log Migration Script','Log Migration Script - Save migration scripts file in %TEMP%/migration_script_*.sql','I',TO_TIMESTAMP('2007-11-11 01:54:49','YYYY-MM-DD HH24:MI:SS'),100,'LogMigrationScript')
;

-- Nov 11, 2007 1:54:50 AM COT
-- FR 1829798 - Easy generation of migration scripts
INSERT INTO AD_MESSAGE_TRL (AD_LANGUAGE,AD_Message_ID, MsgText,MsgTip, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Message_ID, t.MsgText,t.MsgTip, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_MESSAGE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Message_ID=53007 AND EXISTS (SELECT * FROM AD_MESSAGE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Message_ID!=t.AD_Message_ID)
;
SELECT '035_BF_1828688.sql' AS Filename;
UPDATE AD_TAB
   SET isinfotab = 'N'
 WHERE ad_tab_id = 684  -- Invoice (Customer) -> Allocation
    OR ad_tab_id = 685  -- Invoice (Vendor) -> Allocation
    OR ad_tab_id = 755  -- Payment -> Allocate
    OR ad_tab_id = 686  -- Payment -> Allocations
;


SELECT '036_FR1675372.sql' AS Filename;
-- Nov 15, 2007 9:19:15 PM COT
-- FR 1675372 - Add supplier/vendor to productinfo
INSERT INTO AD_MESSAGE (AD_Client_ID,AD_Message_ID,AD_Org_ID,Created,CreatedBy,EntityType,IsActive,MsgText,MsgType,Updated,UpdatedBy,VALUE) VALUES (0,53008,0,TO_TIMESTAMP('2007-11-15 21:19:10','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','Vendor','I',TO_TIMESTAMP('2007-11-15 21:19:10','YYYY-MM-DD HH24:MI:SS'),100,'Vendor')
;

-- Nov 15, 2007 9:19:15 PM COT
-- FR 1675372 - Add supplier/vendor to productinfo
INSERT INTO AD_MESSAGE_TRL (AD_LANGUAGE,AD_Message_ID, MsgText,MsgTip, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Message_ID, t.MsgText,t.MsgTip, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_MESSAGE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Message_ID=53008 AND EXISTS (SELECT * FROM AD_MESSAGE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Message_ID!=t.AD_Message_ID)
;

UPDATE AD_MESSAGE_TRL
   SET msgtext = 'Proveedor'
 WHERE ad_message_id = 53008 AND AD_LANGUAGE LIKE 'es_%'
;

SELECT '037_AdditionalProductInfo.sql' AS Filename;
-- [ 1823612 ] Product Info Screen Improvements
-- Author: fer_luck
-- Dictionary Additions
-- Feature Request: http://sourceforge.net/tracker/index.php?func=detail&aid=1823612&group_id=176962&atid=879335
--******************************************************--
-- NOTE: Don't forget to run the three processes:       --
-- 1 - Add missing translations in the language screen  --
-- 2 - Synchronize terminology                          --
-- 3 - Check sequences                                  --
--******************************************************--

-- new message
INSERT INTO AD_MESSAGE(ad_message_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, VALUE, msgtext, msgtip, msgtype, entitytype)
  VALUES(53001, 0, 0, 'Y', '2007-07-18 00:00:00.0', 100, '2007-07-18 00:00:00.0', 100, 'WarehouseStock', 'Item Availability in other Warehouses', NULL, 'M', 'D');

--add view to ad_table
INSERT INTO AD_TABLE (ad_table_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, description, help, tablename, isview, accesslevel, entitytype, ad_window_id, ad_val_rule_id, loadseq, issecurityenabled, isdeleteable, ishighvolume, importtable, ischangelog, replicationtype, po_window_id, copycolumnsfromtable)
  VALUES(53011, 0, 0, 'Y', '2007-07-26 00:00:00.0', 100, '2007-07-26 00:00:00.0', 100, 'Product Stock at Warehouses', NULL, NULL, 'M_Product_Stock_V', 'Y', '1', 'D', NULL, NULL, NULL, 'N', 'Y', 'N', 'N', 'N', 'L', NULL, NULL);

--add columns to view in ad_column
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql, mandatorylogic)
  VALUES(53003, 0, 0, 'Y', '2007-07-26 01:20:59.0', '2007-07-26 01:20:59.0', 0, 0, 'Description', 'Optional short description of the record', 'A description is limited to 255 characters.', 0, 'D', 'Description', 53011, 10, NULL, NULL, 255, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', NULL, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 275, NULL, 'N', 'N', NULL, NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql, mandatorylogic)
  VALUES(53004, 0, 0, 'Y', '2007-07-26 10:52:11.0', '2007-07-26 10:52:11.0', 0, 0, 'Product', 'Product, Service, Item', 'Identifies an item which is either purchased or sold in this organization.', 0, 'U', 'M_Product_ID', 53011, 30, NULL, NULL, 10, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 0, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 454, NULL, 'N', 'N', NULL, NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql, mandatorylogic)
  VALUES(53005, 0, 0, 'Y', '2007-07-26 15:01:05.0', '2007-07-26 00:00:00.0', 0, 0, 'Name', 'Alphanumeric identifier of the entity', 'The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.', 1, 'D', 'Name', 53011, 10, NULL, NULL, 60, NULL, 'N', 'N', 'Y', 'Y', NULL, 'Y', 1, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 469, NULL, 'N', 'N', NULL, NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql, mandatorylogic)
  VALUES(53006, 0, 0, 'Y', '2007-07-26 11:29:06.0', '2007-07-26 00:00:00.0', 0, 0, 'Available Quantity', 'Available Quantity (On Hand - Reserved)', 'Quantity available to promise = On Hand minus Reserved Quantity', 1, 'D', 'QtyAvailable', 53011, 29, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'N', NULL, 'N', 0, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 2238, NULL, 'N', 'N', NULL, NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql, mandatorylogic)
  VALUES(53007, 0, 0, 'Y', '2007-07-26 00:00:00.0', '2007-07-26 00:00:00.0', 0, 0, 'On Hand Quantity', 'On Hand Quantity', 'The On Hand Quantity indicates the quantity of a product that is on hand in a warehouse.', 1, 'D', 'QtyOnHand', 53011, 29, NULL, NULL, 22, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', NULL, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 530, NULL, 'N', 'N', NULL, NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql, mandatorylogic)
  VALUES(53008, 0, 0, 'Y', '2007-07-26 18:21:48.0', '2007-07-26 00:00:00.0', 0, 0, 'Reserved Quantity', 'Reserved Quantity', 'The Reserved Quantity indicates the quantity of a product that is currently reserved.', 1, 'D', 'QtyReserved', 53011, 29, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', NULL, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 532, NULL, 'N', 'N', NULL, NULL);

--add view to ad_table
INSERT INTO AD_TABLE (ad_table_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, NAME, description, help, tablename, isview, accesslevel, entitytype, ad_window_id, ad_val_rule_id, loadseq, issecurityenabled, isdeleteable, ishighvolume, importtable, ischangelog, replicationtype, po_window_id, copycolumnsfromtable)
  VALUES(53015, 0, 0, 'Y', '2007-07-26 00:00:00.0', 100, '2007-07-26 00:00:00.0', 100, 'Product Substitute with Stock Info', NULL, NULL, 'M_Product_SubstituteRelated_V', 'Y', '1', 'D', NULL, NULL, NULL, 'N', 'Y', 'N', 'N', 'N', 'L', NULL, NULL);

--add columns to view in ad_column
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql, mandatorylogic)
  VALUES(53023, 0, 0, 'Y', '2007-07-26 01:20:59.0', '2007-07-26 01:20:59.0', 0, 0, 'Description', 'Optional short description of the record', 'A description is limited to 255 characters.', 0, 'D', 'Description', 53015, 10, NULL, NULL, 255, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', NULL, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 275, NULL, 'N', 'N', NULL, NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql, mandatorylogic)
  VALUES(53024, 0, 0, 'Y', '2007-07-26 10:52:11.0', '2007-07-26 10:52:11.0', 0, 0, 'Product', 'Product, Service, Item', 'Identifies an item which is either purchased or sold in this organization.', 0, 'U', 'M_Product_ID', 53015, 30, NULL, NULL, 10, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', 0, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 454, NULL, 'N', 'N', NULL, NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql, mandatorylogic)
  VALUES(53025, 0, 0, 'Y', '2007-07-26 15:01:05.0', '2007-07-26 00:00:00.0', 0, 0, 'Standard Price', 'Standard Price', 'The Standard Price indicates the standard or normal price for a product on this price list', 1, 'D', 'PriceStd', 53015, 37, NULL, NULL, 60, NULL, 'N', 'N', 'Y', 'Y', NULL, 'Y', 1, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 957, NULL, 'N', 'N', NULL, NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql, mandatorylogic)
  VALUES(53026, 0, 0, 'Y', '2007-07-26 11:29:06.0', '2007-07-26 00:00:00.0', 0, 0, 'Available Quantity', 'Available Quantity (On Hand - Reserved)', 'Quantity available to promise = On Hand minus Reserved Quantity', 1, 'D', 'QtyAvailable', 53015, 29, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'N', NULL, 'N', 0, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 2238, NULL, 'N', 'N', NULL, NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql, mandatorylogic)
  VALUES(53028, 0, 0, 'Y', '2007-07-26 18:21:48.0', '2007-07-26 00:00:00.0', 0, 0, 'Reserved Quantity', 'Reserved Quantity', 'The Reserved Quantity indicates the quantity of a product that is currently reserved.', 1, 'D', 'QtyReserved', 53015, 29, NULL, NULL, 22, NULL, 'N', 'N', 'N', 'Y', NULL, 'N', NULL, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 532, NULL, 'N', 'N', NULL, NULL);
INSERT INTO AD_COLUMN(ad_column_id, ad_client_id, ad_org_id, isactive, created, updated, createdby, updatedby, NAME, description, help, VERSION, entitytype, columnname, ad_table_id, ad_reference_id, ad_reference_value_id, ad_val_rule_id, fieldlength, defaultvalue, iskey, isparent, ismandatory, isupdateable, readonlylogic, isidentifier, seqno, istranslated, isencrypted, callout, vformat, valuemin, valuemax, isselectioncolumn, ad_element_id, ad_process_id, issyncdatabase, isalwaysupdateable, columnsql, mandatorylogic)
  VALUES(53027, 0, 0, 'Y', '2007-07-26 00:00:00.0', '2007-07-26 00:00:00.0', 0, 0, 'On Hand Quantity', 'On Hand Quantity', 'The On Hand Quantity indicates the quantity of a product that is on hand in a warehouse.', 1, 'D', 'QtyOnHand', 53015, 29, NULL, NULL, 22, NULL, 'N', 'N', 'Y', 'N', NULL, 'N', NULL, 'N', 'N', NULL, NULL, NULL, NULL, 'N', 530, NULL, 'N', 'N', NULL, NULL);

--create views
CREATE OR REPLACE VIEW M_PRODUCT_STOCK_V
AS
SELECT 
ms.IsActive, ms.Created, ms.CreatedBy, ms.Updated, ms.UpdatedBy,
mp.VALUE, mp.help, (ms.qtyonhand - ms.qtyreserved) AS qtyavailable, ms.qtyonhand, 
ms.qtyreserved, mp.description, mw.NAME AS warehouse, mw.m_warehouse_id, mw.ad_client_id, 
mw.ad_org_id, mp.documentnote
FROM M_STORAGE ms 
JOIN M_PRODUCT mp ON ms.m_product_id = mp.m_product_id
JOIN M_LOCATOR ml ON ms.m_locator_id = ml.m_locator_id
JOIN M_WAREHOUSE mw ON ml.m_warehouse_id = mw.m_warehouse_id 
ORDER BY mw.NAME;


CREATE OR REPLACE VIEW M_PRODUCT_SUBSTITUTERELATED_V AS
SELECT s.AD_Client_ID, s.AD_Org_ID, s.IsActive, s.Created, s.CreatedBy, s.Updated, s.UpdatedBy, s.m_product_id, s.substitute_id, s.description, 'S' AS ROWTYPE, (ms.qtyonhand - ms.qtyreserved) AS qtyavailable, ms.qtyonhand, ms.qtyreserved, mpr.pricestd, mpr.m_pricelist_version_id, mw.m_warehouse_id
FROM M_SUBSTITUTE s
JOIN M_STORAGE ms ON ms.m_product_id = s.substitute_id
JOIN M_PRODUCT mp ON ms.m_product_id = mp.m_product_id
JOIN M_LOCATOR ml ON ms.m_locator_id = ml.m_locator_id
JOIN M_WAREHOUSE mw ON ml.m_warehouse_id = mw.m_warehouse_id 
JOIN M_PRODUCTPRICE mpr ON ms.m_product_id = mpr.m_product_id
UNION
SELECT r.ad_client_id, r.ad_org_id, r.IsActive, r.Created, r.CreatedBy, r.Updated, r.UpdatedBy, r.m_product_id, r.relatedproduct_id, r.description, 'R' AS ROWTYPE, (ms.qtyonhand - ms.qtyreserved) AS qtyavailable, ms.qtyonhand, ms.qtyreserved, mpr.pricestd, mpr.m_pricelist_version_id, mw.m_warehouse_id
FROM M_RELATEDPRODUCT r
JOIN M_STORAGE ms ON ms.m_product_id = r.relatedproduct_id
JOIN M_PRODUCT mp ON ms.m_product_id = mp.m_product_id
JOIN M_LOCATOR ml ON ms.m_locator_id = ml.m_locator_id
JOIN M_WAREHOUSE mw ON ml.m_warehouse_id = mw.m_warehouse_id 
JOIN M_PRODUCTPRICE mpr ON ms.m_product_id = mpr.m_product_id;



SELECT '038_AD_ModelValidatorPatch.sql' AS Filename;
-- Fixed wrong reference id for the entitytype column in the 020 script.

UPDATE AD_Column
SET AD_Reference_ID = 18,
AD_Reference_Value_ID = 389
WHERE AD_Column_ID = 53263;




SELECT '039_FR_1782412_PG.sql' AS Filename;

CREATE TABLE AD_Document_Action_Access (

        AD_CLIENT_ID NUMERIC(10,0) NOT NULL , 
     	AD_ORG_ID NUMERIC(10,0) NOT NULL , 
     	ISACTIVE CHAR(1) DEFAULT 'Y' NOT NULL , 
     	CREATED DATE DEFAULT now() NOT NULL , 
     	CREATEDBY NUMERIC(10,0) NOT NULL , 
     	UPDATED DATE DEFAULT now() NOT NULL , 
     	UPDATEDBY NUMERIC(10,0) NOT NULL , 
     	
     	C_DocType_ID NUMERIC(10,0) NOT NULL,
   	AD_Role_ID NUMERIC(10,0) NOT NULL,
   	AD_Ref_List_ID NUMERIC(10,0) NOT NULL
  
);



INSERT INTO AD_VAL_RULE(AD_VAL_RULE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,TYPE,CODE,ENTITYTYPE)values(51002,0,0,'Y',to_date('2007-08-27','RRRR-MM-DD'),100,to_date('2007-08-27','RRRR-MM-DD'),100,'AD_Ref_List_ID (Document Actions)','all document actions','S','AD_Ref_List.AD_Reference_ID=135','D');
INSERT INTO AD_TABLE(AD_TABLE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,TABLENAME,ISVIEW,ACCESSLEVEL,ENTITYTYPE,AD_WINDOW_ID,AD_VAL_RULE_ID,LOADSEQ,ISSECURITYENABLED,ISDELETEABLE,ISHIGHVOLUME,IMPORTTABLE,ISCHANGELOG,REPLICATIONTYPE,PO_WINDOW_ID,COPYCOLUMNSFROMTABLE)values(53012,0,0,'Y',to_date('2007-08-27','RRRR-MM-DD'),100,to_date('2007-08-27','RRRR-MM-DD'),100,'Document Action Access','Define access to document type / document action / role combinations.','Define access rules (add roles with access) for client/role/doctype/document action combinations. If no rules are defined for a client/doctype/doc action combination all roles can access the document action.','AD_Document_Action_Access','N','6','D',null,null,0,'N','Y','N','N','N','L',null,'N');
INSERT INTO AD_SEQUENCE(AD_SEQUENCE_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,VFORMAT,ISAUTOSEQUENCE,INCREMENTNO,STARTNO,CURRENTNEXT,CURRENTNEXTSYS,ISAUDITED,ISTABLEID,PREFIX,SUFFIX,STARTNEWYEAR)values(53011,0,0,'Y',to_date('2007-08-27','RRRR-MM-DD'),100,to_date('2007-08-27','RRRR-MM-DD'),100,'AD_Document_Action_Access','Table AD_Document_Action_Access',null,'Y',1,1000000,1000001,50000,'N','Y',null,null,'N');

INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)values(53222,0,0,'Y',to_date('2007-08-27','RRRR-MM-DD'),to_date('2007-08-27','RRRR-MM-DD'),100,100,'Client','Client/Tenant for this installation.','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.',0,'D','AD_Client_ID',53012,19,null,null,22,'@AD_Client_ID@','N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',102,null,'N','N',null,null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)values(53223,0,0,'Y',to_date('2007-08-27','RRRR-MM-DD'),to_date('2007-08-27','RRRR-MM-DD'),100,100,'Organization','Organizational entity within client','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.',0,'D','AD_Org_ID',53012,19,null,104,22,'@AD_Org_ID@','N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',113,null,'N','N',null,null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)values(53224,0,0,'Y',to_date('2007-08-27','RRRR-MM-DD'),to_date('2007-08-27','RRRR-MM-DD'),100,100,'Active','The record is active in the system','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. There are two reasons for de-activating and not deleting records: (1) The system requires the record for audit purposes. (2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.',0,'D','IsActive',53012,20,null,null,1,null,'N','N','Y','Y',null,'N',null,'N','N',null,null,null,null,'N',348,null,'N','N',null,null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)values(53225,0,0,'Y',to_date('2007-08-27','RRRR-MM-DD'),to_date('2007-08-27','RRRR-MM-DD'),100,100,'Created','Date this record was created','The Created field indicates the date that this record was created.',0,'D','Created',53012,16,null,null,7,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',245,null,'N','N',null,null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)values(53226,0,0,'Y',to_date('2007-08-27','RRRR-MM-DD'),to_date('2007-08-27','RRRR-MM-DD'),100,100,'Created By','User who created this records','The Created By field indicates the user who created this record.',0,'D','CreatedBy',53012,18,110,null,22,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',246,null,'N','N',null,null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)values(53227,0,0,'Y',to_date('2007-08-27','RRRR-MM-DD'),to_date('2007-08-27','RRRR-MM-DD'),100,100,'Updated','Date this record was updated','The Updated field indicates the date that this record was updated.',0,'D','Updated',53012,16,null,null,7,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',607,null,'N','N',null,null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)values(53228,0,0,'Y',to_date('2007-08-27','RRRR-MM-DD'),to_date('2007-08-27','RRRR-MM-DD'),100,100,'Updated By','User who updated this records','The Updated By field indicates the user who updated this record.',0,'D','UpdatedBy',53012,18,110,null,22,null,'N','N','Y','N',null,'N',null,'N','N',null,null,null,null,'N',608,null,'N','N',null,null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)values(53229,0,0,'Y',to_date('2007-08-27','RRRR-MM-DD'),to_date('2007-08-27','RRRR-MM-DD'),100,100,'Document Type','Document type or rules','The Document Type determines document sequence and processing rules',0,'D','C_DocType_ID',53012,19,null,null,22,null,'N','Y','Y','N',null,'N',null,'N','N',null,null,null,null,'N',196,null,'N','N',null,null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)values(53230,0,0,'Y',to_date('2007-08-27','RRRR-MM-DD'),to_date('2007-08-27','RRRR-MM-DD'),100,100,'Role','Responsibility Role','The Role determines security and access a user who has this Role will have in the System.',0,'D','AD_Role_ID',53012,19,null,null,22,null,'N','Y','Y','N',null,'N',null,'N','N',null,null,null,null,'N',123,null,'N','N',null,null);
INSERT INTO AD_COLUMN(AD_COLUMN_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,UPDATED,CREATEDBY,UPDATEDBY,NAME,DESCRIPTION,HELP,VERSION,ENTITYTYPE,COLUMNNAME,AD_TABLE_ID,AD_REFERENCE_ID,AD_REFERENCE_VALUE_ID,AD_VAL_RULE_ID,FIELDLENGTH,DEFAULTVALUE,ISKEY,ISPARENT,ISMANDATORY,ISUPDATEABLE,READONLYLOGIC,ISIDENTIFIER,SEQNO,ISTRANSLATED,ISENCRYPTED,CALLOUT,VFORMAT,VALUEMIN,VALUEMAX,ISSELECTIONCOLUMN,AD_ELEMENT_ID,AD_PROCESS_ID,ISSYNCDATABASE,ISALWAYSUPDATEABLE,COLUMNSQL,MANDATORYLOGIC)values(53231,0,0,'Y',to_date('2007-08-27','RRRR-MM-DD'),to_date('2007-08-27','RRRR-MM-DD'),100,100,'Reference List','Reference List based on Table',null,0,'D','AD_Ref_List_ID',53012,19,null,51002,22,null,'N','Y','Y','N',null,'N',null,'N','N',null,null,null,null,'N',119,null,'N','N',null,null);

INSERT INTO AD_TAB(AD_TAB_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,AD_TABLE_ID,AD_WINDOW_ID,SEQNO,TABLEVEL,ISSINGLEROW,ISINFOTAB,ISTRANSLATIONTAB,ISREADONLY,AD_COLUMN_ID,HASTREE,WHERECLAUSE,ORDERBYCLAUSE,COMMITWARNING,AD_PROCESS_ID,PROCESSING,AD_IMAGE_ID,IMPORTFIELDS,AD_COLUMNSORTORDER_ID,AD_COLUMNSORTYESNO_ID,ISSORTTAB,ENTITYTYPE,INCLUDED_TAB_ID,READONLYLOGIC,DISPLAYLOGIC,ISINSERTRECORD,ISADVANCEDTAB)values(53013,0,0,'Y',to_date('2007-08-29','RRRR-MM-DD'),100,to_date('2007-08-29','RRRR-MM-DD'),100,'Document Action Access','Define access to document type / document action / role combinations.','Define access to document type / document action / role combinations.',53012,111,90,1,'N','N','N','N',53230,'N',null,null,null,null,'N',null,'N',null,null,'N','D',null,null,null,'Y','N');

INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(53241,0,0,'Y',to_date('2007-08-29','RRRR-MM-DD'),100,to_date('2007-08-29','RRRR-MM-DD'),100,'Active','The record is active in the system','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports. There are two reasons for de-activating and not deleting records: (1) The system requires the record for audit purposes. (2) The record is referenced by other records. E.g., you cannot delete a Business Partner, if there are invoices for this partner record existing. You de-activate the Business Partner and prevent that this record is used for future entries.','Y',53013,53224,null,'Y',null,1,'N',50,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(53242,0,0,'Y',to_date('2007-08-29','RRRR-MM-DD'),100,to_date('2007-08-29','RRRR-MM-DD'),100,'Client','Client/Tenant for this installation.','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y',53013,53222,null,'Y',null,22,'N',10,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(53244,0,0,'Y',to_date('2007-08-29','RRRR-MM-DD'),100,to_date('2007-08-29','RRRR-MM-DD'),100,'Document Type','Document type or rules','The Document Type determines document sequence and processing rules','Y',53013,53229,null,'Y',null,22,'N',30,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(53245,0,0,'Y',to_date('2007-08-29','RRRR-MM-DD'),100,to_date('2007-08-29','RRRR-MM-DD'),100,'Organization','Organizational entity within client','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y',53013,53223,null,'Y',null,22,'N',20,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(53246,0,0,'Y',to_date('2007-08-29','RRRR-MM-DD'),100,to_date('2007-08-29','RRRR-MM-DD'),100,'Reference List','Reference List based on Table','The Reference List field indicates a list of reference values from a database tables.  Reference lists populate drop down list boxes in data entry screens','Y',53013,53231,null,'Y',null,22,'N',40,null,'N','N','N','N','D',null,null,null);
INSERT INTO AD_FIELD(AD_FIELD_ID,AD_CLIENT_ID,AD_ORG_ID,ISACTIVE,CREATED,CREATEDBY,UPDATED,UPDATEDBY,NAME,DESCRIPTION,HELP,ISCENTRALLYMAINTAINED,AD_TAB_ID,AD_COLUMN_ID,AD_FIELDGROUP_ID,ISDISPLAYED,DISPLAYLOGIC,DISPLAYLENGTH,ISREADONLY,SEQNO,SORTNO,ISSAMELINE,ISHEADING,ISFIELDONLY,ISENCRYPTED,ENTITYTYPE,OBSCURETYPE,AD_REFERENCE_ID,ISMANDATORY)values(53247,0,0,'Y',to_date('2007-08-29','RRRR-MM-DD'),100,to_date('2007-08-29','RRRR-MM-DD'),100,'Role','Responsibility Role','The Role determines security and access a user who has this Role will have in the System.','Y',53013,53230,null,'N',null,22,'N',0,null,'N','N','N','N','D',null,null,null);





UPDATE ad_sequence
   SET currentnextsys = (SELECT MAX (ad_column_id) + 1
                           FROM ad_column
                          WHERE ad_column_id < 1000000)
 WHERE NAME = 'AD_Column';

UPDATE ad_sequence
   SET currentnextsys = (SELECT MAX (ad_field_id) + 1
                           FROM ad_field
                          WHERE ad_field_id < 1000000)
 WHERE NAME = 'AD_Field';
 
 
 UPDATE ad_sequence
    SET currentnextsys = (SELECT MAX (ad_column_id) + 1
                            FROM ad_column
                           WHERE ad_column_id < 1000000)
  WHERE NAME = 'AD_Sequence';
 
 UPDATE ad_sequence
    SET currentnextsys = (SELECT MAX (ad_field_id) + 1
                            FROM ad_field
                           WHERE ad_field_id < 1000000)
  WHERE NAME = 'AD_Tab';
  
  UPDATE ad_sequence
     SET currentnextsys = (SELECT MAX (ad_message_id) + 1
                             FROM ad_message
                            WHERE ad_message_id < 1000000)
 WHERE NAME = 'AD_Table';
 
  UPDATE ad_sequence
     SET currentnextsys = (SELECT MAX (ad_element_id) + 1
                             FROM ad_element
                            WHERE ad_element_id < 1000000)
   WHERE NAME = 'AD_Window';
  
  UPDATE ad_sequence
     SET currentnextsys = (SELECT MAX (ad_column_id) + 1
                             FROM ad_column
                            WHERE ad_column_id < 1000000)
   WHERE NAME = 'AD_Val_Rule';
  
   
 
 
delete from AD_Document_Action_Access;
  
Insert into  AD_Document_Action_Access  ( 
 AD_CLIENT_ID , 
 AD_ORG_ID , 
 ISACTIVE , 
 CREATED , 
 CREATEDBY , 
 UPDATED , 
 UPDATEDBY , 
 C_DocType_ID , 
 AD_Role_ID , 
 AD_Ref_List_ID 
 ) 
 
 (
 SELECT
 client.AD_Client_ID,
 0,
 'Y',
 now(),
 0,
 now(),
 0,
 doctype.C_DocType_ID,
 rol.AD_Role_ID,
 action.AD_Ref_List_ID
 FROM AD_Client client
 INNER JOIN C_DocType doctype ON (doctype.AD_Client_ID=client.AD_Client_ID)
 INNER JOIN AD_Ref_List action ON (action.AD_Reference_ID=135)
 INNER JOIN AD_Role rol ON (rol.AD_Client_ID=client.AD_Client_ID)
 );




SELECT '040_FR1840016.sql' AS Filename;
-- Nov 27, 2007 11:00:15 PM COT
-- FR 1840016 - Avoid usage of clearing accounts
INSERT INTO AD_Element (AD_Client_ID,AD_Element_ID,AD_Org_ID,ColumnName,Created,CreatedBy,Description,EntityType,Help,IsActive,Name,PrintName,Updated,UpdatedBy) VALUES (0,53227,0,'IsPostIfClearingEqual',TO_TIMESTAMP('2007-11-27 23:00:10','YYYY-MM-DD HH24:MI:SS'),100,'This flag controls if Adempiere must post when clearing (transit) and final accounts are the same','D',NULL,'Y','Post if Clearing Equal','Post if Clearing Equal',TO_TIMESTAMP('2007-11-27 23:00:10','YYYY-MM-DD HH24:MI:SS'),100)
;

-- Nov 27, 2007 11:00:16 PM COT
-- FR 1840016 - Avoid usage of clearing accounts
INSERT INTO AD_Element_Trl (AD_Language,AD_Element_ID, Description,Help,Name,PO_Description,PO_Help,PO_Name,PO_PrintName,PrintName, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Element_ID, t.Description,t.Help,t.Name,t.PO_Description,t.PO_Help,t.PO_Name,t.PO_PrintName,t.PrintName, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Element t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Element_ID=53227 AND EXISTS (SELECT * FROM AD_Element_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Element_ID!=t.AD_Element_ID)
;

-- Nov 27, 2007 11:00:45 PM COT
-- FR 1840016 - Avoid usage of clearing accounts
UPDATE AD_Column SET ColumnName='IsPostIfClearingEqual', Name='Post if Clearing Equal', Description='This flag controls if Adempiere must post when clearing (transit) and final accounts are the same', Help=NULL WHERE AD_Element_ID=53227
;

-- Nov 27, 2007 11:00:45 PM COT
-- FR 1840016 - Avoid usage of clearing accounts
UPDATE AD_Field SET Name='Post if Clearing Equal', Description='This flag controls if Adempiere must post when clearing (transit) and final accounts are the same', Help=NULL WHERE AD_Column_ID IN (SELECT AD_Column_ID FROM AD_Column WHERE AD_Element_ID=53227) AND IsCentrallyMaintained='Y'
;

-- Nov 27, 2007 11:00:45 PM COT
-- FR 1840016 - Avoid usage of clearing accounts
UPDATE AD_Process_Para SET ColumnName='IsPostIfClearingEqual', Name='Post if Clearing Equal', Description='This flag controls if Adempiere must post when clearing (transit) and final accounts are the same', Help=NULL, AD_Element_ID=53227 WHERE UPPER(ColumnName)='ISPOSTIFCLEARINGEQUAL' AND IsCentrallyMaintained='Y' AND AD_Element_ID IS NULL
;

-- Nov 27, 2007 11:00:45 PM COT
-- FR 1840016 - Avoid usage of clearing accounts
UPDATE AD_Process_Para SET ColumnName='IsPostIfClearingEqual', Name='Post if Clearing Equal', Description='This flag controls if Adempiere must post when clearing (transit) and final accounts are the same', Help=NULL WHERE AD_Element_ID=53227 AND IsCentrallyMaintained='Y'
;

-- Nov 27, 2007 11:00:45 PM COT
-- FR 1840016 - Avoid usage of clearing accounts
UPDATE AD_PrintFormatItem SET PrintName='Post if Clearing Equal', Name='Post if Clearing Equal' WHERE IsCentrallyMaintained='Y' AND EXISTS (SELECT * FROM AD_Column c WHERE c.AD_Column_ID=AD_PrintFormatItem.AD_Column_ID AND c.AD_Element_ID=53227)
;

-- Nov 27, 2007 11:00:46 PM COT
-- FR 1840016 - Avoid usage of clearing accounts
UPDATE AD_PrintFormatItem SET PrintName='Post if Clearing Equal', Name='Post if Clearing Equal' WHERE IsCentrallyMaintained='Y' AND EXISTS (SELECT * FROM AD_Column c WHERE c.AD_Column_ID=AD_PrintFormatItem.AD_Column_ID AND c.AD_Element_ID=53227)
;

-- Nov 27, 2007 11:01:30 PM COT
-- FR 1840016 - Avoid usage of clearing accounts
INSERT INTO AD_Column (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,Name,SeqNo,Updated,UpdatedBy,Version) VALUES (0,53266,53227,0,20,265,'IsPostIfClearingEqual',TO_TIMESTAMP('2007-11-27 23:01:29','YYYY-MM-DD HH24:MI:SS'),100,'Y','This flag controls if Adempiere must post when clearing (transit) and final accounts are the same','D',1,'Y','N','N','N','N','N','N','N','N','N','Y','Post if Clearing Equal',0,TO_TIMESTAMP('2007-11-27 23:01:29','YYYY-MM-DD HH24:MI:SS'),100,0)
;

-- Nov 27, 2007 11:01:30 PM COT
-- FR 1840016 - Avoid usage of clearing accounts
INSERT INTO AD_Column_Trl (AD_Language,AD_Column_ID, Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Column_ID, t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Column t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=53266 AND EXISTS (SELECT * FROM AD_Column_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Column_ID!=t.AD_Column_ID)
;

-- Nov 27, 2007 11:01:45 PM COT
-- FR 1840016 - Avoid usage of clearing accounts
ALTER TABLE C_AcctSchema ADD COLUMN IsPostIfClearingEqual CHAR(1) DEFAULT 'Y' CHECK (IsPostIfClearingEqual IN ('Y','N'))
;

-- Nov 27, 2007 11:07:24 PM COT
-- FR 1840016 - Avoid usage of clearing accounts
INSERT INTO AD_Field (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsEncrypted,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,Name,SeqNo,Updated,UpdatedBy) VALUES (0,53266,53281,0,199,TO_TIMESTAMP('2007-11-27 23:07:22','YYYY-MM-DD HH24:MI:SS'),100,'This flag controls if Adempiere must post when clearing (transit) and final accounts are the same',1,'D','Y','Y','Y','N','N','N','N','Y','Post if Clearing Equal',270,TO_TIMESTAMP('2007-11-27 23:07:22','YYYY-MM-DD HH24:MI:SS'),100)
;

-- Nov 27, 2007 11:07:24 PM COT
-- FR 1840016 - Avoid usage of clearing accounts
INSERT INTO AD_Field_Trl (AD_Language,AD_Field_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Field_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Field t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=53281 AND EXISTS (SELECT * FROM AD_Field_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Field_ID!=t.AD_Field_ID)
;


SELECT '041_FR1814291.sql' AS Filename;
-- Dec 1, 2007 1:51:24 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_REF_LIST SET NAME='PO Commitment & Reservation',Updated=TO_TIMESTAMP('2007-12-01 01:51:24','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Ref_List_ID=785
;

-- Dec 1, 2007 1:51:24 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_REF_LIST_TRL SET NAME = 'Compromisos Compra y Reservas', IsTranslated='Y' WHERE AD_Ref_List_ID=785 AND AD_LANGUAGE LIKE 'es_%'
;

-- Dec 1, 2007 1:52:54 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_REF_LIST SET NAME='PO Commitment only',Updated=TO_TIMESTAMP('2007-12-01 01:52:54','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Ref_List_ID=784
;

-- Dec 1, 2007 1:52:54 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_REF_LIST_TRL SET NAME = 'Solamente Compromiso Compras', IsTranslated='Y' WHERE AD_Ref_List_ID=784 AND AD_LANGUAGE LIKE 'es_%'
;

-- Dec 1, 2007 1:53:53 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO AD_REF_LIST (AD_Client_ID,AD_Org_ID,AD_Ref_List_ID,AD_Reference_ID,Created,CreatedBy,EntityType,IsActive,NAME,Updated,UpdatedBy,VALUE) VALUES (0,0,53223,359,TO_TIMESTAMP('2007-12-01 01:53:45','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','PO;SO Commitment & Reservation',TO_TIMESTAMP('2007-12-01 01:53:45','YYYY-MM-DD HH24:MI:SS'),100,'A')
;

-- Dec 1, 2007 1:53:53 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO AD_REF_LIST_TRL (AD_LANGUAGE,AD_Ref_List_ID, Description,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Ref_List_ID, t.Description,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_REF_LIST t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Ref_List_ID=53223 AND EXISTS (SELECT * FROM AD_REF_LIST_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Ref_List_ID!=t.AD_Ref_List_ID)
;

-- Dec 1, 2007 1:52:54 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_REF_LIST_TRL SET NAME = 'Compromisos (ambos) y Reservas', IsTranslated='Y' WHERE AD_Ref_List_ID=53223 AND AD_LANGUAGE LIKE 'es_%'
;

-- Dec 1, 2007 1:54:46 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO AD_REF_LIST (AD_Client_ID,AD_Org_ID,AD_Ref_List_ID,AD_Reference_ID,Created,CreatedBy,EntityType,IsActive,NAME,Updated,UpdatedBy,VALUE) VALUES (0,0,53224,359,TO_TIMESTAMP('2007-12-01 01:54:31','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','SO Commitment only',TO_TIMESTAMP('2007-12-01 01:54:31','YYYY-MM-DD HH24:MI:SS'),100,'S')
;

-- Dec 1, 2007 1:54:46 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO AD_REF_LIST_TRL (AD_LANGUAGE,AD_Ref_List_ID, Description,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Ref_List_ID, t.Description,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_REF_LIST t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Ref_List_ID=53224 AND EXISTS (SELECT * FROM AD_REF_LIST_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Ref_List_ID!=t.AD_Ref_List_ID)
;

-- Dec 1, 2007 1:52:54 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_REF_LIST_TRL SET NAME = 'Solamente Compromiso Ventas', IsTranslated='Y' WHERE AD_Ref_List_ID=53224 AND AD_LANGUAGE LIKE 'es_%'
;

-- Dec 1, 2007 1:55:44 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO AD_REF_LIST (AD_Client_ID,AD_Org_ID,AD_Ref_List_ID,AD_Reference_ID,Created,CreatedBy,EntityType,IsActive,NAME,Updated,UpdatedBy,VALUE) VALUES (0,0,53225,359,TO_TIMESTAMP('2007-12-01 01:55:35','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','PO;SO Commitment',TO_TIMESTAMP('2007-12-01 01:55:35','YYYY-MM-DD HH24:MI:SS'),100,'O')
;

-- Dec 1, 2007 1:55:44 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO AD_REF_LIST_TRL (AD_LANGUAGE,AD_Ref_List_ID, Description,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Ref_List_ID, t.Description,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_REF_LIST t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Ref_List_ID=53225 AND EXISTS (SELECT * FROM AD_REF_LIST_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Ref_List_ID!=t.AD_Ref_List_ID)
;

-- Dec 1, 2007 1:52:54 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_REF_LIST_TRL SET NAME = 'Solamente Compromisos (ambos)', IsTranslated='Y' WHERE AD_Ref_List_ID=53225 AND AD_LANGUAGE LIKE 'es_%'
;

-- Dec 1, 2007 1:58:18 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO AD_ELEMENT (AD_Client_ID,AD_Element_ID,AD_Org_ID,ColumnName,Created,CreatedBy,Description,EntityType,Help,IsActive,NAME,PrintName,Updated,UpdatedBy) VALUES (0,53228,0,'CommitmentOffsetSales_Acct',TO_TIMESTAMP('2007-12-01 01:58:04','YYYY-MM-DD HH24:MI:SS'),100,'Budgetary Commitment Offset Account for Sales','D','The Commitment Offset Account is used for posting Commitments Sales and Reservations.  It is usually an off-balance sheet and gain-and-loss account.','Y','Commitment Offset Sales','Commitment Offset Sales',TO_TIMESTAMP('2007-12-01 01:58:04','YYYY-MM-DD HH24:MI:SS'),100)
;

-- Dec 1, 2007 1:58:18 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO AD_ELEMENT_TRL (AD_LANGUAGE,AD_Element_ID, Description,Help,NAME,PO_Description,PO_Help,PO_Name,PO_PrintName,PrintName, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Element_ID, t.Description,t.Help,t.NAME,t.PO_Description,t.PO_Help,t.PO_Name,t.PO_PrintName,t.PrintName, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_ELEMENT t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Element_ID=53228 AND EXISTS (SELECT * FROM AD_ELEMENT_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Element_ID!=t.AD_Element_ID)
;

-- Dec 1, 2007 1:59:04 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,53267,53228,0,25,266,'CommitmentOffsetSales_Acct',TO_TIMESTAMP('2007-12-01 01:58:56','YYYY-MM-DD HH24:MI:SS'),100,'Budgetary Commitment Offset Account for Sales','D',10,'The Commitment Offset Account is used for posting Commitments Sales and Reservations.  It is usually an off-balance sheet and gain-and-loss account.','Y','N','N','N','N','N','N','N','N','N','Y','Commitment Offset Sales',TO_TIMESTAMP('2007-12-01 01:58:56','YYYY-MM-DD HH24:MI:SS'),100,0)
;

-- Dec 1, 2007 1:59:04 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=53267 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

-- Dec 1, 2007 1:59:26 AM COT
-- FR 1814291 - Sales Commitment Offset
ALTER TABLE C_ACCTSCHEMA_GL ADD COLUMN CommitmentOffsetSales_Acct NUMERIC(10)
;

-- FR 1814291 - Sales Commitment Offset
UPDATE C_ACCTSCHEMA_GL SET CommitmentOffsetSales_Acct = CommitmentOffset_Acct
;

-- Dec 1, 2007 2:00:20 AM COT
-- FR 1814291 - Sales Commitment Offset
ALTER TABLE C_ACCTSCHEMA_GL ALTER COLUMN CommitmentOffsetSales_Acct SET NOT NULL
;

-- Dec 1, 2007 2:00:11 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_COLUMN SET IsMandatory='Y',Updated=TO_TIMESTAMP('2007-12-01 02:00:11','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Column_ID=53267
;

-- Dec 1, 2007 2:00:11 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_FIELD SET NAME='Commitment Offset Sales', Description='Budgetary Commitment Offset Account for Sales', Help='The Commitment Offset Account is used for posting Commitments Sales and Reservations.  It is usually an off-balance sheet and gain-and-loss account.' WHERE AD_Column_ID=53267 AND IsCentrallyMaintained='Y'
;

-- Dec 1, 2007 2:02:34 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_FIELD SET IsSameLine='N', SeqNo=160,Updated=TO_TIMESTAMP('2007-12-01 02:02:34','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=12375
;

-- Dec 1, 2007 2:03:04 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsEncrypted,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,Updated,UpdatedBy) VALUES (0,53267,53282,0,200,TO_TIMESTAMP('2007-12-01 02:02:56','YYYY-MM-DD HH24:MI:SS'),100,'Budgetary Commitment Offset Account for Sales',10,'D','The Commitment Offset Account is used for posting Commitments Sales and Reservations.  It is usually an off-balance sheet and gain-and-loss account.','Y','Y','Y','N','N','N','N','Y','Commitment Offset Sales',170,TO_TIMESTAMP('2007-12-01 02:02:56','YYYY-MM-DD HH24:MI:SS'),100)
;

-- Dec 1, 2007 2:03:04 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=53282 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

-- Dec 1, 2007 2:55:04 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO C_ELEMENTVALUE (AD_Client_ID,AD_Org_ID,AccountSign,AccountType,C_ElementValue_ID,C_Element_ID,Created,CreatedBy,IsActive,IsBankAccount,IsDocControlled,IsForeignCurrency,IsSummary,NAME,PostActual,PostBudget,PostEncumbrance,PostStatistical,Updated,UpdatedBy,VALUE) VALUES (11,0,'N','M',50000,105,TO_TIMESTAMP('2007-12-01 02:55:03','YYYY-MM-DD HH24:MI:SS'),100,'Y','N','N','N','N','SO Commitment','Y','Y','Y','Y',TO_TIMESTAMP('2007-12-01 02:55:03','YYYY-MM-DD HH24:MI:SS'),100,'953')
;

-- Dec 1, 2007 2:55:04 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO C_ELEMENTVALUE_TRL (AD_LANGUAGE,C_ElementValue_ID, Description,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.C_ElementValue_ID, t.Description,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, C_ELEMENTVALUE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.C_ElementValue_ID=50000 AND EXISTS (SELECT * FROM C_ELEMENTVALUE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.C_ElementValue_ID!=t.C_ElementValue_ID)
;

-- Dec 1, 2007 2:55:04 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO AD_TREENODE (AD_Client_ID,AD_Org_ID, IsActive,Created,CreatedBy,Updated,UpdatedBy, AD_Tree_ID, Node_ID, Parent_ID, SeqNo) SELECT t.AD_Client_ID,0, 'Y', CURRENT_TIMESTAMP, 0, CURRENT_TIMESTAMP, 0,t.AD_Tree_ID, 50000, 0, 999 FROM AD_TREE t WHERE t.AD_Client_ID=11 AND t.IsActive='Y' AND EXISTS (SELECT * FROM C_ELEMENT ae WHERE ae.C_Element_ID=105 AND t.AD_Tree_ID=ae.AD_Tree_ID) AND NOT EXISTS (SELECT * FROM AD_TREENODE e WHERE e.AD_Tree_ID=t.AD_Tree_ID AND Node_ID=50000)
;

-- Dec 1, 2007 2:55:08 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=0, SeqNo=0, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=506
;

-- Dec 1, 2007 2:55:08 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=0, SeqNo=1, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=584
;

-- Dec 1, 2007 2:55:08 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=0, SeqNo=2, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=624
;

-- Dec 1, 2007 2:55:08 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=0, SeqNo=3, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=632
;

-- Dec 1, 2007 2:55:08 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=0, SeqNo=4, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=429
;

-- Dec 1, 2007 2:55:08 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=0, SeqNo=5, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=449
;

-- Dec 1, 2007 2:55:08 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=0, SeqNo=6, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=783
;

-- Dec 1, 2007 2:55:08 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=0, SeqNo=7, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=704
;

-- Dec 1, 2007 2:55:08 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=0, SeqNo=8, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=716
;

-- Dec 1, 2007 2:55:08 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=0, SeqNo=9, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=728
;

-- Dec 1, 2007 2:55:08 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=0, SeqNo=10, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=731
;

-- Dec 1, 2007 2:55:08 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=0, SeqNo=11, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=734
;

-- Dec 1, 2007 2:55:08 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=734, SeqNo=0, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=735
;

-- Dec 1, 2007 2:55:09 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=734, SeqNo=1, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=736
;

-- Dec 1, 2007 2:55:09 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=734, SeqNo=2, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=50000
;

-- Dec 1, 2007 2:55:09 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE AD_TREENODE SET Parent_ID=734, SeqNo=3, Updated=CURRENT_TIMESTAMP WHERE AD_Tree_ID=101 AND Node_ID=737
;

-- Dec 1, 2007 2:55:54 AM COT
-- FR 1814291 - Sales Commitment Offset
INSERT INTO C_VALIDCOMBINATION (AD_Client_ID,AD_Org_ID,Account_ID,C_AcctSchema_ID,C_ValidCombination_ID,Combination,Created,CreatedBy,Description,IsActive,IsFullyQualified,Updated,UpdatedBy) VALUES (11,11,50000,101,50000,'HQ-953-_-_-_-_',TO_TIMESTAMP('2007-12-01 02:55:54','YYYY-MM-DD HH24:MI:SS'),100,'HQ-SO Commitment-_-_-_-_','Y','Y',TO_TIMESTAMP('2007-12-01 02:55:54','YYYY-MM-DD HH24:MI:SS'),100)
;

-- Dec 1, 2007 2:56:01 AM COT
-- FR 1814291 - Sales Commitment Offset
UPDATE C_ACCTSCHEMA_GL SET CommitmentOffsetSales_Acct=50000,Updated=TO_TIMESTAMP('2007-12-01 02:56:01','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE C_AcctSchema_ID=101
;

SELECT '042_fix_typo_in_help.sql' AS Filename;
UPDATE AD_WINDOW
   SET HELP =
          'The User Window allows you to maintain User of the system.  Users can log into the system and have access to functionality via one or more roles.  A user can also be a business partner contact.'
 WHERE ad_window_id = 108 AND HELP LIKE '%aprtner%';

SELECT '043_version331.sql' AS Filename;
UPDATE AD_SYSTEM
   SET releaseno = '331b',
       VERSION = '2007-12-05'
 WHERE ad_system_id = 0 AND ad_client_id = 0;



SELECT '044_BF_1824260.sql' AS Filename;
CREATE OR REPLACE FUNCTION "adempiere"."subtractdays" (in inter interval, in days numeric) RETURNS integer AS
$BODY$
BEGIN
RETURN ( EXTRACT( EPOCH FROM ( inter ) ) / 86400 ) - days;
END;
$BODY$
LANGUAGE 'plpgsql';

CREATE OPERATOR - (
PROCEDURE = subtractdays,
LEFTARG = interval,
RIGHTARG = numeric,
COMMUTATOR = -
);


CREATE OR REPLACE FUNCTION "adempiere"."adddays" (in inter interval, in days numeric) RETURNS integer AS
$BODY$
BEGIN
RETURN ( EXTRACT( EPOCH FROM ( inter ) ) / 86400 ) + days;
END;
$BODY$
LANGUAGE 'plpgsql';

CREATE OPERATOR + (
PROCEDURE = adddays,
LEFTARG = interval,
RIGHTARG = numeric,
COMMUTATOR = -
);

ALTER OPERATOR adempiere.+ (interval, numeric) OWNER TO adempiere;
SELECT '045_placeholder_branch350.sql' AS Filename;

SELECT '046_FR1800371_SystemConfiguratorEnhancements.sql' AS Filename;
-- Dec 15, 2007 12:31:13 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Column (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,Name,ReadOnlyLogic,SeqNo,Updated,UpdatedBy,Version) VALUES (0,53270,1682,0,18,389,50009,'EntityType',TO_TIMESTAMP('2007-12-15 12:31:11','YYYY-MM-DD HH24:MI:SS'),100,'U','Dictionary Entity Type; Determines ownership and synchronization','D',40,'The Entity Types "Dictionary", "Adempiere" and "Application" might be automatically synchronized and customizations deleted or overwritten.  

For customizations, copy the entity and select "User"!','Y','N','N','N','N','Y','N','N','N','N','Y','Entity Type','@EntityType@=D',0,TO_TIMESTAMP('2007-12-15 12:31:11','YYYY-MM-DD HH24:MI:SS'),100,1.000000000000)
;

-- Dec 15, 2007 12:31:13 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Column_Trl (AD_Language,AD_Column_ID, Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Column_ID, t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Column t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=53270 AND EXISTS (SELECT * FROM AD_Column_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Column_ID!=t.AD_Column_ID)
;

-- Dec 15, 2007 12:31:24 PM COT
-- FR 1800371 System Configurator Enhancements
ALTER TABLE AD_SysConfig ADD COLUMN EntityType VARCHAR(40) DEFAULT 'U' NOT NULL
;

-- Dec 15, 2007 12:33:53 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Element (AD_Client_ID,AD_Element_ID,AD_Org_ID,ColumnName,Created,CreatedBy,Description,EntityType,Help,IsActive,Name,PrintName,Updated,UpdatedBy) VALUES (0,53229,0,'ConfigurationLevel',TO_TIMESTAMP('2007-12-15 12:33:52','YYYY-MM-DD HH24:MI:SS'),100,'Configuration Level for this parameter','D','Configuration Level for this parameter
S - just allowed system configuration
C - client configurable parameter
O - org configurable parameter','Y','Configuration Level','Configuration Level for this parameter',TO_TIMESTAMP('2007-12-15 12:33:52','YYYY-MM-DD HH24:MI:SS'),100)
;

-- Dec 15, 2007 12:33:53 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Element_Trl (AD_Language,AD_Element_ID, Description,Help,Name,PO_Description,PO_Help,PO_Name,PO_PrintName,PrintName, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Element_ID, t.Description,t.Help,t.Name,t.PO_Description,t.PO_Help,t.PO_Name,t.PO_PrintName,t.PrintName, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Element t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Element_ID=53229 AND EXISTS (SELECT * FROM AD_Element_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Element_ID!=t.AD_Element_ID)
;

-- Dec 15, 2007 12:34:46 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Reference (AD_Client_ID,AD_Org_ID,AD_Reference_ID,Created,CreatedBy,Description,EntityType,IsActive,Name,Updated,UpdatedBy,ValidationType) VALUES (0,0,53222,TO_TIMESTAMP('2007-12-15 12:34:44','YYYY-MM-DD HH24:MI:SS'),100,'Configuration Level','D','Y','AD_SysConfig ConfigurationLevel',TO_TIMESTAMP('2007-12-15 12:34:44','YYYY-MM-DD HH24:MI:SS'),100,'L')
;

-- Dec 15, 2007 12:34:46 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Reference_Trl (AD_Language,AD_Reference_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Reference_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Reference t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Reference_ID=53222 AND EXISTS (SELECT * FROM AD_Reference_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Reference_ID!=t.AD_Reference_ID)
;

-- Dec 15, 2007 12:35:24 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Ref_List (AD_Client_ID,AD_Org_ID,AD_Ref_List_ID,AD_Reference_ID,Created,CreatedBy,Description,EntityType,IsActive,Name,Updated,UpdatedBy,Value) VALUES (0,0,53228,53222,TO_TIMESTAMP('2007-12-15 12:35:20','YYYY-MM-DD HH24:MI:SS'),100,'Just allowed system configuration','D','Y','System',TO_TIMESTAMP('2007-12-15 12:35:20','YYYY-MM-DD HH24:MI:SS'),100,'S')
;

-- Dec 15, 2007 12:35:24 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Ref_List_Trl (AD_Language,AD_Ref_List_ID, Description,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Ref_List_ID, t.Description,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Ref_List t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Ref_List_ID=53228 AND EXISTS (SELECT * FROM AD_Ref_List_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Ref_List_ID!=t.AD_Ref_List_ID)
;

-- Dec 15, 2007 12:35:43 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Ref_List (AD_Client_ID,AD_Org_ID,AD_Ref_List_ID,AD_Reference_ID,Created,CreatedBy,Description,EntityType,IsActive,Name,Updated,UpdatedBy,Value) VALUES (0,0,53229,53222,TO_TIMESTAMP('2007-12-15 12:35:42','YYYY-MM-DD HH24:MI:SS'),100,'Allowed system and client configuration','D','Y','Client',TO_TIMESTAMP('2007-12-15 12:35:42','YYYY-MM-DD HH24:MI:SS'),100,'C')
;

-- Dec 15, 2007 12:35:43 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Ref_List_Trl (AD_Language,AD_Ref_List_ID, Description,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Ref_List_ID, t.Description,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Ref_List t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Ref_List_ID=53229 AND EXISTS (SELECT * FROM AD_Ref_List_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Ref_List_ID!=t.AD_Ref_List_ID)
;

-- Dec 15, 2007 12:36:01 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Ref_List (AD_Client_ID,AD_Org_ID,AD_Ref_List_ID,AD_Reference_ID,Created,CreatedBy,Description,EntityType,IsActive,Name,Updated,UpdatedBy,Value) VALUES (0,0,53230,53222,TO_TIMESTAMP('2007-12-15 12:36:00','YYYY-MM-DD HH24:MI:SS'),100,'Allowed system, client and organization configuration','D','Y','Organization',TO_TIMESTAMP('2007-12-15 12:36:00','YYYY-MM-DD HH24:MI:SS'),100,'O')
;

-- Dec 15, 2007 12:36:01 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Ref_List_Trl (AD_Language,AD_Ref_List_ID, Description,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Ref_List_ID, t.Description,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Ref_List t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Ref_List_ID=53230 AND EXISTS (SELECT * FROM AD_Ref_List_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Ref_List_ID!=t.AD_Ref_List_ID)
;

-- Dec 15, 2007 12:36:39 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Column (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,Name,SeqNo,Updated,UpdatedBy,Version) VALUES (0,53271,53229,0,17,53222,50009,'ConfigurationLevel',TO_TIMESTAMP('2007-12-15 12:36:38','YYYY-MM-DD HH24:MI:SS'),100,'S','Configuration Level for this parameter','D',1,'Configuration Level for this parameter
S - just allowed system configuration
C - client configurable parameter
O - org configurable parameter','Y','N','N','N','N','N','N','N','N','N','Y','Configuration Level',0,TO_TIMESTAMP('2007-12-15 12:36:38','YYYY-MM-DD HH24:MI:SS'),100,0)
;

-- Dec 15, 2007 12:36:39 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Column_Trl (AD_Language,AD_Column_ID, Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Column_ID, t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Column t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=53271 AND EXISTS (SELECT * FROM AD_Column_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Column_ID!=t.AD_Column_ID)
;

-- Dec 15, 2007 12:36:53 PM COT
-- FR 1800371 System Configurator Enhancements
ALTER TABLE AD_SysConfig ADD COLUMN ConfigurationLevel CHAR(1) DEFAULT 'S' 
;

-- Dec 15, 2007 12:41:18 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Field (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsEncrypted,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,Name,Updated,UpdatedBy) VALUES (0,53271,53285,0,50009,TO_TIMESTAMP('2007-12-15 12:41:14','YYYY-MM-DD HH24:MI:SS'),100,'Configuration Level for this parameter',1,'D','Configuration Level for this parameter
S - just allowed system configuration
C - client configurable parameter
O - org configurable parameter','Y','Y','Y','N','N','N','N','N','Configuration Level',TO_TIMESTAMP('2007-12-15 12:41:14','YYYY-MM-DD HH24:MI:SS'),100)
;

-- Dec 15, 2007 12:41:18 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Field_Trl (AD_Language,AD_Field_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Field_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Field t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=53285 AND EXISTS (SELECT * FROM AD_Field_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Field_ID!=t.AD_Field_ID)
;

-- Dec 15, 2007 12:41:25 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Field (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsEncrypted,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,Name,Updated,UpdatedBy) VALUES (0,53270,53286,0,50009,TO_TIMESTAMP('2007-12-15 12:41:18','YYYY-MM-DD HH24:MI:SS'),100,'Dictionary Entity Type; Determines ownership and synchronization',40,'D','The Entity Types "Dictionary", "Adempiere" and "Application" might be automatically synchronized and customizations deleted or overwritten.  

For customizations, copy the entity and select "User"!','Y','Y','Y','N','N','N','N','N','Entity Type',TO_TIMESTAMP('2007-12-15 12:41:18','YYYY-MM-DD HH24:MI:SS'),100)
;

-- Dec 15, 2007 12:41:26 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Field_Trl (AD_Language,AD_Field_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Field_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Field t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=53286 AND EXISTS (SELECT * FROM AD_Field_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Field_ID!=t.AD_Field_ID)
;

-- Dec 15, 2007 12:41:39 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_Field SET SeqNo=30,IsDisplayed='Y' WHERE AD_Field_ID=50164
;

-- Dec 15, 2007 12:41:39 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_Field SET SeqNo=40,IsDisplayed='Y' WHERE AD_Field_ID=50163
;

-- Dec 15, 2007 12:41:39 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_Field SET SeqNo=50,IsDisplayed='Y' WHERE AD_Field_ID=50166
;

-- Dec 15, 2007 12:41:39 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_Field SET SeqNo=60,IsDisplayed='Y' WHERE AD_Field_ID=53286
;

-- Dec 15, 2007 12:41:39 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_Field SET SeqNo=70,IsDisplayed='Y' WHERE AD_Field_ID=53285
;

-- Dec 15, 2007 12:41:39 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_Field SET SeqNo=80,IsDisplayed='Y' WHERE AD_Field_ID=50161
;

-- Dec 15, 2007 12:42:07 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_Field SET DisplayLength=20,Updated=TO_TIMESTAMP('2007-12-15 12:42:07','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=53286
;

-- Dec 15, 2007 12:42:18 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_Field SET DisplayLength=20, IsSameLine='Y',Updated=TO_TIMESTAMP('2007-12-15 12:42:18','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=53285
;

-- Dec 15, 2007 12:49:08 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_SysConfig SET EntityType='D',Updated=TO_TIMESTAMP('2007-12-15 12:49:08','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_SysConfig_ID=50000
;

-- Dec 15, 2007 12:49:17 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_SysConfig SET EntityType='D',Updated=TO_TIMESTAMP('2007-12-15 12:49:16','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_SysConfig_ID=50005
;

-- Dec 15, 2007 12:49:26 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_SysConfig SET EntityType='D',Updated=TO_TIMESTAMP('2007-12-15 12:49:25','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_SysConfig_ID=50009
;

-- Dec 15, 2007 12:49:33 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_SysConfig SET EntityType='D',Updated=TO_TIMESTAMP('2007-12-15 12:49:32','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_SysConfig_ID=50010
;

-- Dec 15, 2007 12:49:42 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_SysConfig SET EntityType='D',Updated=TO_TIMESTAMP('2007-12-15 12:49:42','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_SysConfig_ID=50004
;

-- Dec 15, 2007 12:49:49 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_SysConfig SET EntityType='D',Updated=TO_TIMESTAMP('2007-12-15 12:49:49','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_SysConfig_ID=50006
;

-- Dec 15, 2007 12:49:59 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_SysConfig SET EntityType='D',Updated=TO_TIMESTAMP('2007-12-15 12:49:58','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_SysConfig_ID=50001
;

-- Dec 15, 2007 12:50:06 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_SysConfig SET EntityType='D',Updated=TO_TIMESTAMP('2007-12-15 12:50:06','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_SysConfig_ID=50007
;

-- Dec 15, 2007 12:50:14 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_SysConfig SET EntityType='D',Updated=TO_TIMESTAMP('2007-12-15 12:50:14','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_SysConfig_ID=50002
;

-- Dec 15, 2007 12:50:29 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_SysConfig SET EntityType='D',Updated=TO_TIMESTAMP('2007-12-15 12:50:29','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_SysConfig_ID=50008
;

-- Dec 15, 2007 12:50:51 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_SysConfig SET EntityType='D',Updated=TO_TIMESTAMP('2007-12-15 12:50:51','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_SysConfig_ID=50003
;

-- Dec 15, 2007 12:51:28 PM COT
-- FR 1800371 System Configurator Enhancements
UPDATE AD_Tab SET OrderByClause='Name',Updated=TO_TIMESTAMP('2007-12-15 12:51:28','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Tab_ID=50009
;

-- Dec 15, 2007 1:24:58 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Message (AD_Client_ID,AD_Message_ID,AD_Org_ID,Created,CreatedBy,EntityType,IsActive,MsgText,MsgType,Updated,UpdatedBy,Value) VALUES (0,53009,0,TO_TIMESTAMP('2007-12-15 13:24:57','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','This is a system or client parameter, you can''t save it as organization parameter','E',TO_TIMESTAMP('2007-12-15 13:24:57','YYYY-MM-DD HH24:MI:SS'),100,'Can''t Save Org Level')
;

-- Dec 15, 2007 1:24:59 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Message_Trl (AD_Language,AD_Message_ID, MsgText,MsgTip, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Message_ID, t.MsgText,t.MsgTip, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Message t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Message_ID=53009 AND EXISTS (SELECT * FROM AD_Message_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Message_ID!=t.AD_Message_ID)
;

-- Dec 15, 2007 1:25:17 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Message (AD_Client_ID,AD_Message_ID,AD_Org_ID,Created,CreatedBy,EntityType,IsActive,MsgText,MsgType,Updated,UpdatedBy,Value) VALUES (0,53010,0,TO_TIMESTAMP('2007-12-15 13:25:16','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','This is a system parameter, you can''t save it as client parameter','E',TO_TIMESTAMP('2007-12-15 13:25:16','YYYY-MM-DD HH24:MI:SS'),100,'Can''t Save Client Level')
;

-- Dec 15, 2007 1:25:17 PM COT
-- FR 1800371 System Configurator Enhancements
INSERT INTO AD_Message_Trl (AD_Language,AD_Message_ID, MsgText,MsgTip, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Message_ID, t.MsgText,t.MsgTip, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Message t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Message_ID=53010 AND EXISTS (SELECT * FROM AD_Message_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Message_ID!=t.AD_Message_ID)
;
SELECT '047_placeholder_branch350.sql' AS Filename;

SELECT '048_FieldGroupType_in_AD_Field_V.sql' AS Filename;
drop view ad_field_v
;

drop view ad_field_vt
;

CREATE OR
REPLACE VIEW ad_field_v AS 
SELECT t.ad_window_id,
	f.ad_tab_id,
	f.ad_field_id,
	tbl.ad_table_id,
	f.ad_column_id,
	f.NAME,
	f.description,
	f.help,
	f.isdisplayed,
	f.displaylogic,
	f.displaylength,
	f.seqno,
	f.sortno,
	f.issameline,
	f.isheading,
	f.isfieldonly,
	f.isreadonly,
	f.isencrypted                                  AS isencryptedfield,
	f.obscuretype,
	C.columnname,
	C.columnsql,
	C.fieldlength,
	C.vformat,
	C.defaultvalue,
	C.iskey,
	C.isparent,
	COALESCE(f.ismandatory, C.ismandatory)         AS ismandatory,
	C.isidentifier,
	C.istranslated,
	C.ad_reference_value_id,
	C.callout,
	COALESCE(f.ad_reference_id, C.ad_reference_id) AS ad_reference_id,
	C.ad_val_rule_id,
	C.ad_process_id,
	C.isalwaysupdateable,
	C.readonlylogic,
	C.isupdateable,
	C.isencrypted                                  AS isencryptedcolumn,
	C.isselectioncolumn,
	tbl.tablename,
	C.valuemin,
	C.valuemax,
	fg.NAME                                        AS fieldgroup,
	vr.code                                        AS validationcode,
	f.Included_Tab_ID,
	fg.FieldGroupType 
FROM ((((((ad_field f 
		JOIN ad_tab t 
		ON ((f.ad_tab_id = t.ad_tab_id))) 
		LEFT JOIN ad_fieldgroup fg 
		ON ((f.ad_fieldgroup_id = fg.ad_fieldgroup_id))) 
		LEFT JOIN ad_column C 
		ON ((f.ad_column_id = C.ad_column_id))) 
		JOIN ad_table tbl 
		ON ((C.ad_table_id = tbl.ad_table_id))) 
		JOIN ad_reference r 
		ON ((C.ad_reference_id = r.ad_reference_id))) 
		LEFT JOIN ad_val_rule vr 
		ON ((C.ad_val_rule_id = vr.ad_val_rule_id))) 
WHERE ((f.isactive = 'Y'::bpchar) AND
	(C.isactive = 'Y'::bpchar))
;

CREATE OR
REPLACE VIEW ad_field_vt AS 
SELECT trl.ad_language,
	t.ad_window_id,
	f.ad_tab_id,
	f.ad_field_id,
	tbl.ad_table_id,
	f.ad_column_id,
	trl.NAME,
	trl.description,
	trl.help,
	f.isdisplayed,
	f.displaylogic,
	f.displaylength,
	f.seqno,
	f.sortno,
	f.issameline,
	f.isheading,
	f.isfieldonly,
	f.isreadonly,
	f.isencrypted                                  AS isencryptedfield,
	f.obscuretype,
	C.columnname,
	C.columnsql,
	C.fieldlength,
	C.vformat,
	C.defaultvalue,
	C.iskey,
	C.isparent,
	COALESCE(f.ismandatory, C.ismandatory)         AS ismandatory,
	C.isidentifier,
	C.istranslated,
	C.ad_reference_value_id,
	C.callout,
	COALESCE(f.ad_reference_id, C.ad_reference_id) AS ad_reference_id,
	C.ad_val_rule_id,
	C.ad_process_id,
	C.isalwaysupdateable,
	C.readonlylogic,
	C.isupdateable,
	C.isencrypted                                  AS isencryptedcolumn,
	C.isselectioncolumn,
	tbl.tablename,
	C.valuemin,
	C.valuemax,
	fgt.NAME                                       AS fieldgroup,
	vr.code                                        AS validationcode,
	f.Included_Tab_ID,
	fg.FieldGroupType 
FROM (((((((ad_field f 
		JOIN ad_field_trl trl 
		ON ((f.ad_field_id = trl.ad_field_id))) 
		JOIN ad_tab t 
		ON ((f.ad_tab_id = t.ad_tab_id))) 
		LEFT JOIN AD_FIELDGROUP fg 
		ON (f.AD_FieldGroup_ID = fg.AD_FieldGroup_ID) 
			LEFT JOIN ad_fieldgroup_trl fgt 
			ON (((f.ad_fieldgroup_id = fgt.ad_fieldgroup_id) AND
			((trl.ad_language)::text = (fgt.ad_language)::text)))) 
		LEFT JOIN ad_column C 
		ON ((f.ad_column_id = C.ad_column_id))) 
		JOIN ad_table tbl 
		ON ((C.ad_table_id = tbl.ad_table_id))) 
		JOIN ad_reference r 
		ON ((C.ad_reference_id = r.ad_reference_id))) 
		LEFT JOIN ad_val_rule vr 
		ON ((C.ad_val_rule_id = vr.ad_val_rule_id))) 
WHERE ((f.isactive = 'Y'::bpchar) AND
	(C.isactive = 'Y'::bpchar))
;
SELECT '049_FR1860642_C_DocType.sql' AS Filename;
-- Dec 29, 2007 5:52:00 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Element (AD_Org_ID,AD_Element_ID,ColumnName,Created,CreatedBy,EntityType,IsActive,Name,PrintName,Updated,AD_Client_ID,UpdatedBy) VALUES (0,53320,'IsOverwriteSeqOnComplete',TO_TIMESTAMP('2007-12-29 17:51:59','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','Overwrite Sequence on Complete','Overwrite Sequence on Complete',TO_TIMESTAMP('2007-12-29 17:51:59','YYYY-MM-DD HH24:MI:SS'),0,100)
;

-- Dec 29, 2007 5:52:00 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Element_Trl (AD_Language,AD_Element_ID, Description,Help,Name,PO_Description,PO_Help,PO_Name,PO_PrintName,PrintName, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Element_ID, t.Description,t.Help,t.Name,t.PO_Description,t.PO_Help,t.PO_Name,t.PO_PrintName,t.PrintName, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Element t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Element_ID=53320 AND EXISTS (SELECT * FROM AD_Element_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Element_ID!=t.AD_Element_ID)
;

UPDATE AD_Element_Trl SET istranslated='Y', name = 'Sobreescribir Secuencia al Completar', printname = 'Sobreescribir Secuencia al Completar'
WHERE AD_Element_ID=53320 and ad_language like 'es_%'
;

-- Dec 29, 2007 5:53:26 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Element (AD_Org_ID,AD_Element_ID,ColumnName,Created,CreatedBy,EntityType,IsActive,Name,PrintName,Updated,AD_Client_ID,UpdatedBy) VALUES (0,53321,'DefiniteSequence_ID',TO_TIMESTAMP('2007-12-29 17:53:26','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','Definite Sequence','Definite Sequence',TO_TIMESTAMP('2007-12-29 17:53:26','YYYY-MM-DD HH24:MI:SS'),0,100)
;

-- Dec 29, 2007 5:53:26 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Element_Trl (AD_Language,AD_Element_ID, Description,Help,Name,PO_Description,PO_Help,PO_Name,PO_PrintName,PrintName, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Element_ID, t.Description,t.Help,t.Name,t.PO_Description,t.PO_Help,t.PO_Name,t.PO_PrintName,t.PrintName, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Element t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Element_ID=53321 AND EXISTS (SELECT * FROM AD_Element_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Element_ID!=t.AD_Element_ID)
;

UPDATE AD_Element_Trl SET istranslated='Y', name = 'Secuencia Definitiva', printname = 'Secuencia Definitiva'
WHERE AD_Element_ID=53321 and ad_language like 'es_%'
;

-- Dec 29, 2007 5:54:09 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Element (AD_Org_ID,AD_Element_ID,ColumnName,Created,CreatedBy,EntityType,IsActive,Name,PrintName,Updated,AD_Client_ID,UpdatedBy) VALUES (0,53322,'IsOverwriteDateOnComplete',TO_TIMESTAMP('2007-12-29 17:54:09','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','Overwrite Date on Complete','Overwrite Date on Complete',TO_TIMESTAMP('2007-12-29 17:54:09','YYYY-MM-DD HH24:MI:SS'),0,100)
;

-- Dec 29, 2007 5:54:09 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Element_Trl (AD_Language,AD_Element_ID, Description,Help,Name,PO_Description,PO_Help,PO_Name,PO_PrintName,PrintName, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Element_ID, t.Description,t.Help,t.Name,t.PO_Description,t.PO_Help,t.PO_Name,t.PO_PrintName,t.PrintName, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Element t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Element_ID=53322 AND EXISTS (SELECT * FROM AD_Element_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Element_ID!=t.AD_Element_ID)
;

UPDATE AD_Element_Trl SET istranslated='Y', name = 'Sobreescribir Fecha al Completar', printname = 'Sobreescribir Fecha al Completar'
WHERE AD_Element_ID=53322 and ad_language like 'es_%'
;

-- Dec 29, 2007 5:55:55 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Column (AD_Org_ID,AD_Element_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,Name,SeqNo,Updated,UpdatedBy,Version,AD_Client_ID,AD_Column_ID) VALUES (0,53320,20,217,'IsOverwriteSeqOnComplete',TO_TIMESTAMP('2007-12-29 17:55:55','YYYY-MM-DD HH24:MI:SS'),100,'N','D',1,'Y','N','N','N','N','N','N','N','N','N','Y','Overwrite Sequence on Complete',0,TO_TIMESTAMP('2007-12-29 17:55:55','YYYY-MM-DD HH24:MI:SS'),100,1.00,0,54087)
;

-- Dec 29, 2007 5:55:56 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Column_Trl (AD_Language,AD_Column_ID, Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Column_ID, t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Column t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54087 AND EXISTS (SELECT * FROM AD_Column_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Column_ID!=t.AD_Column_ID)
;

-- Dec 29, 2007 5:56:02 PM COT
-- 1860642 - Enhance document numbering
ALTER TABLE C_DocType ADD COLUMN IsOverwriteSeqOnComplete CHAR(1) DEFAULT 'N' CHECK (IsOverwriteSeqOnComplete IN ('Y','N'))
;

-- Dec 29, 2007 5:57:54 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Column (AD_Org_ID,AD_Reference_Value_ID,AD_Element_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,Name,Updated,UpdatedBy,Version,AD_Client_ID,AD_Column_ID) VALUES (0,128,53321,18,217,'DefiniteSequence_ID',TO_TIMESTAMP('2007-12-29 17:57:54','YYYY-MM-DD HH24:MI:SS'),100,'D',22,'Y','N','N','N','N','N','N','N','N','N','Y','Definite Sequence',TO_TIMESTAMP('2007-12-29 17:57:54','YYYY-MM-DD HH24:MI:SS'),100,1,0,54088)
;

-- Dec 29, 2007 5:57:54 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Column_Trl (AD_Language,AD_Column_ID, Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Column_ID, t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Column t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54088 AND EXISTS (SELECT * FROM AD_Column_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Column_ID!=t.AD_Column_ID)
;

-- Dec 29, 2007 5:58:04 PM COT
-- 1860642 - Enhance document numbering
ALTER TABLE C_DocType ADD COLUMN DefiniteSequence_ID NUMERIC(10)
;

-- Dec 29, 2007 5:58:27 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Column (AD_Org_ID,AD_Element_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,Name,SeqNo,Updated,UpdatedBy,Version,AD_Client_ID,AD_Column_ID) VALUES (0,53322,20,217,'IsOverwriteDateOnComplete',TO_TIMESTAMP('2007-12-29 17:58:26','YYYY-MM-DD HH24:MI:SS'),100,'N','D',1,'Y','N','N','N','N','N','N','N','N','N','Y','Overwrite Date on Complete',0,TO_TIMESTAMP('2007-12-29 17:58:26','YYYY-MM-DD HH24:MI:SS'),100,1.00,0,54089)
;

-- Dec 29, 2007 5:58:27 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Column_Trl (AD_Language,AD_Column_ID, Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Column_ID, t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Column t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54089 AND EXISTS (SELECT * FROM AD_Column_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Column_ID!=t.AD_Column_ID)
;

-- Dec 29, 2007 5:58:37 PM COT
-- 1860642 - Enhance document numbering
ALTER TABLE C_DocType ADD COLUMN IsOverwriteDateOnComplete CHAR(1) DEFAULT 'N' CHECK (IsOverwriteDateOnComplete IN ('Y','N'))
;

-- Dec 29, 2007 6:00:14 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Field (AD_Column_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsEncrypted,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,Name,Updated,AD_Client_ID,UpdatedBy,AD_Field_ID) VALUES (54088,0,167,TO_TIMESTAMP('2007-12-29 18:00:13','YYYY-MM-DD HH24:MI:SS'),100,22,'D','Y','Y','Y','N','N','N','N','N','Definite Sequence',TO_TIMESTAMP('2007-12-29 18:00:13','YYYY-MM-DD HH24:MI:SS'),0,100,54230)
;

-- Dec 29, 2007 6:00:14 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Field_Trl (AD_Language,AD_Field_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Field_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Field t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54230 AND EXISTS (SELECT * FROM AD_Field_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Field_ID!=t.AD_Field_ID)
;

-- Dec 29, 2007 6:00:15 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Field (AD_Column_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsEncrypted,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,Name,Updated,AD_Client_ID,UpdatedBy,AD_Field_ID) VALUES (54089,0,167,TO_TIMESTAMP('2007-12-29 18:00:15','YYYY-MM-DD HH24:MI:SS'),100,1,'D','Y','Y','Y','N','N','N','N','N','Overwrite Date on Complete',TO_TIMESTAMP('2007-12-29 18:00:15','YYYY-MM-DD HH24:MI:SS'),0,100,54232)
;

-- Dec 29, 2007 6:00:15 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Field_Trl (AD_Language,AD_Field_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Field_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Field t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54232 AND EXISTS (SELECT * FROM AD_Field_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Field_ID!=t.AD_Field_ID)
;

-- Dec 29, 2007 6:00:16 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Field (AD_Column_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsEncrypted,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,Name,Updated,AD_Client_ID,UpdatedBy,AD_Field_ID) VALUES (54087,0,167,TO_TIMESTAMP('2007-12-29 18:00:15','YYYY-MM-DD HH24:MI:SS'),100,1,'D','Y','Y','Y','N','N','N','N','N','Overwrite Sequence on Complete',TO_TIMESTAMP('2007-12-29 18:00:15','YYYY-MM-DD HH24:MI:SS'),0,100,54233)
;

-- Dec 29, 2007 6:00:16 PM COT
-- 1860642 - Enhance document numbering
INSERT INTO AD_Field_Trl (AD_Language,AD_Field_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Field_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Field t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54233 AND EXISTS (SELECT * FROM AD_Field_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Field_ID!=t.AD_Field_ID)
;

-- Dec 29, 2007 6:00:52 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET SeqNo=290,Updated=TO_TIMESTAMP('2007-12-29 18:00:52','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=54233
;

-- Dec 29, 2007 6:00:57 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET IsSameLine='Y', SeqNo=300,Updated=TO_TIMESTAMP('2007-12-29 18:00:57','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=54230
;

-- Dec 29, 2007 6:01:04 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET SeqNo=310,Updated=TO_TIMESTAMP('2007-12-29 18:01:04','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=54232
;

-- Dec 29, 2007 6:01:31 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET DisplayLogic='@IsOverwriteSeqOnComplete@=''Y''',Updated=TO_TIMESTAMP('2007-12-29 18:01:31','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=54230
;

-- Dec 29, 2007 8:21:16 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET SeqNo=190,IsDisplayed='Y' WHERE AD_Field_ID=54233
;

-- Dec 29, 2007 8:21:16 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET SeqNo=200,IsDisplayed='Y' WHERE AD_Field_ID=54230
;

-- Dec 29, 2007 8:21:16 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET SeqNo=210,IsDisplayed='Y' WHERE AD_Field_ID=54232
;

-- Dec 29, 2007 8:21:16 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET SeqNo=220,IsDisplayed='Y' WHERE AD_Field_ID=10345
;

-- Dec 29, 2007 8:21:16 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET SeqNo=230,IsDisplayed='Y' WHERE AD_Field_ID=10346
;

-- Dec 29, 2007 8:21:16 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET SeqNo=240,IsDisplayed='Y' WHERE AD_Field_ID=10481
;

-- Dec 29, 2007 8:21:16 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET SeqNo=250,IsDisplayed='Y' WHERE AD_Field_ID=10480
;

-- Dec 29, 2007 8:21:16 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET SeqNo=260,IsDisplayed='Y' WHERE AD_Field_ID=10371
;

-- Dec 29, 2007 8:21:16 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET SeqNo=270,IsDisplayed='Y' WHERE AD_Field_ID=10528
;

-- Dec 29, 2007 8:21:16 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET SeqNo=280,IsDisplayed='Y' WHERE AD_Field_ID=10340
;

-- Dec 29, 2007 8:21:16 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET SeqNo=290,IsDisplayed='Y' WHERE AD_Field_ID=6567
;

-- Dec 29, 2007 8:21:16 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET SeqNo=300,IsDisplayed='Y' WHERE AD_Field_ID=3125
;

-- Dec 29, 2007 8:21:57 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET DisplayLogic='@IsDocNoControlled@=''Y''',Updated=TO_TIMESTAMP('2007-12-29 20:21:57','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=54233
;

-- Dec 29, 2007 8:22:06 PM COT
-- 1860642 - Enhance document numbering
UPDATE AD_Field SET DisplayLogic='@IsDocNoControlled@=''Y'' & @IsOverwriteSeqOnComplete@=''Y''',Updated=TO_TIMESTAMP('2007-12-29 20:22:06','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=54230
;


SELECT '050_Create_2008_Calendar_For_GardenWorld.sql' AS Filename;
-- Dec 31, 2007 4:26:33 PM COT
-- Create 2008 calendar for GardenWorld
INSERT INTO C_Year (AD_Client_ID,AD_Org_ID,C_Calendar_ID,C_Year_ID,Created,CreatedBy,FiscalYear,IsActive,Processing,Updated,UpdatedBy) VALUES (11,0,102,50001,TO_TIMESTAMP('2007-12-31 16:26:29','YYYY-MM-DD HH24:MI:SS'),100,'2008','Y','N',TO_TIMESTAMP('2007-12-31 16:26:29','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_Period (AD_Client_ID,AD_Org_ID,C_Period_ID,C_Year_ID,Created,CreatedBy,EndDate,IsActive,Name,PeriodNo,PeriodType,Processing,StartDate,Updated,UpdatedBy) VALUES (11,0,50012,50001,TO_TIMESTAMP('2007-12-31 16:26:38','YYYY-MM-DD HH24:MI:SS'),100,TO_TIMESTAMP('2008-01-31','YYYY-MM-DD'),'Y','Jan-08',1,'S','N',TO_TIMESTAMP('2008-01-01','YYYY-MM-DD'),TO_TIMESTAMP('2007-12-31 16:26:38','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50276,50012,TO_TIMESTAMP('2007-12-31 16:26:39','YYYY-MM-DD HH24:MI:SS'),100,'APC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:39','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50277,50012,TO_TIMESTAMP('2007-12-31 16:26:40','YYYY-MM-DD HH24:MI:SS'),100,'API','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:40','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50278,50012,TO_TIMESTAMP('2007-12-31 16:26:41','YYYY-MM-DD HH24:MI:SS'),100,'APP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:41','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50279,50012,TO_TIMESTAMP('2007-12-31 16:26:42','YYYY-MM-DD HH24:MI:SS'),100,'ARC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:42','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50280,50012,TO_TIMESTAMP('2007-12-31 16:26:43','YYYY-MM-DD HH24:MI:SS'),100,'ARI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:43','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50281,50012,TO_TIMESTAMP('2007-12-31 16:26:44','YYYY-MM-DD HH24:MI:SS'),100,'ARF','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:44','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50282,50012,TO_TIMESTAMP('2007-12-31 16:26:45','YYYY-MM-DD HH24:MI:SS'),100,'ARR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:45','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50283,50012,TO_TIMESTAMP('2007-12-31 16:26:46','YYYY-MM-DD HH24:MI:SS'),100,'CMB','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:46','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50284,50012,TO_TIMESTAMP('2007-12-31 16:26:46','YYYY-MM-DD HH24:MI:SS'),100,'CMC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:46','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50285,50012,TO_TIMESTAMP('2007-12-31 16:26:47','YYYY-MM-DD HH24:MI:SS'),100,'GLD','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:47','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50286,50012,TO_TIMESTAMP('2007-12-31 16:26:48','YYYY-MM-DD HH24:MI:SS'),100,'GLJ','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:48','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50287,50012,TO_TIMESTAMP('2007-12-31 16:26:49','YYYY-MM-DD HH24:MI:SS'),100,'MMR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:49','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50288,50012,TO_TIMESTAMP('2007-12-31 16:26:50','YYYY-MM-DD HH24:MI:SS'),100,'MMS','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:50','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50289,50012,TO_TIMESTAMP('2007-12-31 16:26:51','YYYY-MM-DD HH24:MI:SS'),100,'MXI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:51','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50290,50012,TO_TIMESTAMP('2007-12-31 16:26:52','YYYY-MM-DD HH24:MI:SS'),100,'MXP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:52','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50291,50012,TO_TIMESTAMP('2007-12-31 16:26:54','YYYY-MM-DD HH24:MI:SS'),100,'MMM','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:54','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50292,50012,TO_TIMESTAMP('2007-12-31 16:26:55','YYYY-MM-DD HH24:MI:SS'),100,'MMI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:55','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50293,50012,TO_TIMESTAMP('2007-12-31 16:26:57','YYYY-MM-DD HH24:MI:SS'),100,'MMP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:57','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50294,50012,TO_TIMESTAMP('2007-12-31 16:26:59','YYYY-MM-DD HH24:MI:SS'),100,'SOO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:26:59','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50295,50012,TO_TIMESTAMP('2007-12-31 16:27:01','YYYY-MM-DD HH24:MI:SS'),100,'CMA','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:01','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50296,50012,TO_TIMESTAMP('2007-12-31 16:27:02','YYYY-MM-DD HH24:MI:SS'),100,'PJI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:02','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50297,50012,TO_TIMESTAMP('2007-12-31 16:27:04','YYYY-MM-DD HH24:MI:SS'),100,'POO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:04','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50298,50012,TO_TIMESTAMP('2007-12-31 16:27:06','YYYY-MM-DD HH24:MI:SS'),100,'POR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:06','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_Period (AD_Client_ID,AD_Org_ID,C_Period_ID,C_Year_ID,Created,CreatedBy,EndDate,IsActive,Name,PeriodNo,PeriodType,Processing,StartDate,Updated,UpdatedBy) VALUES (11,0,50013,50001,TO_TIMESTAMP('2007-12-31 16:27:08','YYYY-MM-DD HH24:MI:SS'),100,TO_TIMESTAMP('2008-02-29','YYYY-MM-DD'),'Y','Feb-08',2,'S','N',TO_TIMESTAMP('2008-02-01','YYYY-MM-DD'),TO_TIMESTAMP('2007-12-31 16:27:08','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50299,50013,TO_TIMESTAMP('2007-12-31 16:27:10','YYYY-MM-DD HH24:MI:SS'),100,'APC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:10','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50300,50013,TO_TIMESTAMP('2007-12-31 16:27:11','YYYY-MM-DD HH24:MI:SS'),100,'API','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:11','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50301,50013,TO_TIMESTAMP('2007-12-31 16:27:13','YYYY-MM-DD HH24:MI:SS'),100,'APP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:13','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50302,50013,TO_TIMESTAMP('2007-12-31 16:27:19','YYYY-MM-DD HH24:MI:SS'),100,'ARC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:19','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50303,50013,TO_TIMESTAMP('2007-12-31 16:27:21','YYYY-MM-DD HH24:MI:SS'),100,'ARI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:21','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50304,50013,TO_TIMESTAMP('2007-12-31 16:27:24','YYYY-MM-DD HH24:MI:SS'),100,'ARF','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:24','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50305,50013,TO_TIMESTAMP('2007-12-31 16:27:26','YYYY-MM-DD HH24:MI:SS'),100,'ARR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:26','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50306,50013,TO_TIMESTAMP('2007-12-31 16:27:28','YYYY-MM-DD HH24:MI:SS'),100,'CMB','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:28','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50307,50013,TO_TIMESTAMP('2007-12-31 16:27:31','YYYY-MM-DD HH24:MI:SS'),100,'CMC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:31','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50308,50013,TO_TIMESTAMP('2007-12-31 16:27:33','YYYY-MM-DD HH24:MI:SS'),100,'GLD','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:33','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50309,50013,TO_TIMESTAMP('2007-12-31 16:27:35','YYYY-MM-DD HH24:MI:SS'),100,'GLJ','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:35','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50310,50013,TO_TIMESTAMP('2007-12-31 16:27:37','YYYY-MM-DD HH24:MI:SS'),100,'MMR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:37','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50311,50013,TO_TIMESTAMP('2007-12-31 16:27:40','YYYY-MM-DD HH24:MI:SS'),100,'MMS','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:40','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50312,50013,TO_TIMESTAMP('2007-12-31 16:27:42','YYYY-MM-DD HH24:MI:SS'),100,'MXI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:42','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50313,50013,TO_TIMESTAMP('2007-12-31 16:27:43','YYYY-MM-DD HH24:MI:SS'),100,'MXP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:43','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50314,50013,TO_TIMESTAMP('2007-12-31 16:27:44','YYYY-MM-DD HH24:MI:SS'),100,'MMM','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:44','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50315,50013,TO_TIMESTAMP('2007-12-31 16:27:45','YYYY-MM-DD HH24:MI:SS'),100,'MMI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:45','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50316,50013,TO_TIMESTAMP('2007-12-31 16:27:46','YYYY-MM-DD HH24:MI:SS'),100,'MMP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:46','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50317,50013,TO_TIMESTAMP('2007-12-31 16:27:48','YYYY-MM-DD HH24:MI:SS'),100,'SOO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:48','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50318,50013,TO_TIMESTAMP('2007-12-31 16:27:48','YYYY-MM-DD HH24:MI:SS'),100,'CMA','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:48','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50319,50013,TO_TIMESTAMP('2007-12-31 16:27:49','YYYY-MM-DD HH24:MI:SS'),100,'PJI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:49','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50320,50013,TO_TIMESTAMP('2007-12-31 16:27:50','YYYY-MM-DD HH24:MI:SS'),100,'POO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:50','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50321,50013,TO_TIMESTAMP('2007-12-31 16:27:51','YYYY-MM-DD HH24:MI:SS'),100,'POR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:51','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_Period (AD_Client_ID,AD_Org_ID,C_Period_ID,C_Year_ID,Created,CreatedBy,EndDate,IsActive,Name,PeriodNo,PeriodType,Processing,StartDate,Updated,UpdatedBy) VALUES (11,0,50014,50001,TO_TIMESTAMP('2007-12-31 16:27:52','YYYY-MM-DD HH24:MI:SS'),100,TO_TIMESTAMP('2008-03-31','YYYY-MM-DD'),'Y','Mar-08',3,'S','N',TO_TIMESTAMP('2008-03-01','YYYY-MM-DD'),TO_TIMESTAMP('2007-12-31 16:27:52','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50322,50014,TO_TIMESTAMP('2007-12-31 16:27:53','YYYY-MM-DD HH24:MI:SS'),100,'APC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:53','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50323,50014,TO_TIMESTAMP('2007-12-31 16:27:59','YYYY-MM-DD HH24:MI:SS'),100,'API','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:27:59','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50324,50014,TO_TIMESTAMP('2007-12-31 16:28:00','YYYY-MM-DD HH24:MI:SS'),100,'APP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:00','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50325,50014,TO_TIMESTAMP('2007-12-31 16:28:01','YYYY-MM-DD HH24:MI:SS'),100,'ARC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:01','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50326,50014,TO_TIMESTAMP('2007-12-31 16:28:01','YYYY-MM-DD HH24:MI:SS'),100,'ARI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:01','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50327,50014,TO_TIMESTAMP('2007-12-31 16:28:02','YYYY-MM-DD HH24:MI:SS'),100,'ARF','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:02','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50328,50014,TO_TIMESTAMP('2007-12-31 16:28:02','YYYY-MM-DD HH24:MI:SS'),100,'ARR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:02','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50329,50014,TO_TIMESTAMP('2007-12-31 16:28:03','YYYY-MM-DD HH24:MI:SS'),100,'CMB','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:03','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50330,50014,TO_TIMESTAMP('2007-12-31 16:28:03','YYYY-MM-DD HH24:MI:SS'),100,'CMC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:03','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50331,50014,TO_TIMESTAMP('2007-12-31 16:28:04','YYYY-MM-DD HH24:MI:SS'),100,'GLD','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:04','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50332,50014,TO_TIMESTAMP('2007-12-31 16:28:04','YYYY-MM-DD HH24:MI:SS'),100,'GLJ','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:04','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50333,50014,TO_TIMESTAMP('2007-12-31 16:28:04','YYYY-MM-DD HH24:MI:SS'),100,'MMR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:04','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50334,50014,TO_TIMESTAMP('2007-12-31 16:28:05','YYYY-MM-DD HH24:MI:SS'),100,'MMS','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:05','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50335,50014,TO_TIMESTAMP('2007-12-31 16:28:05','YYYY-MM-DD HH24:MI:SS'),100,'MXI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:05','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50336,50014,TO_TIMESTAMP('2007-12-31 16:28:06','YYYY-MM-DD HH24:MI:SS'),100,'MXP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:06','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50337,50014,TO_TIMESTAMP('2007-12-31 16:28:06','YYYY-MM-DD HH24:MI:SS'),100,'MMM','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:06','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50338,50014,TO_TIMESTAMP('2007-12-31 16:28:07','YYYY-MM-DD HH24:MI:SS'),100,'MMI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:07','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50339,50014,TO_TIMESTAMP('2007-12-31 16:28:07','YYYY-MM-DD HH24:MI:SS'),100,'MMP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:07','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50340,50014,TO_TIMESTAMP('2007-12-31 16:28:08','YYYY-MM-DD HH24:MI:SS'),100,'SOO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:08','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50341,50014,TO_TIMESTAMP('2007-12-31 16:28:08','YYYY-MM-DD HH24:MI:SS'),100,'CMA','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:08','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50342,50014,TO_TIMESTAMP('2007-12-31 16:28:09','YYYY-MM-DD HH24:MI:SS'),100,'PJI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:09','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50343,50014,TO_TIMESTAMP('2007-12-31 16:28:09','YYYY-MM-DD HH24:MI:SS'),100,'POO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:09','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50344,50014,TO_TIMESTAMP('2007-12-31 16:28:09','YYYY-MM-DD HH24:MI:SS'),100,'POR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:09','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_Period (AD_Client_ID,AD_Org_ID,C_Period_ID,C_Year_ID,Created,CreatedBy,EndDate,IsActive,Name,PeriodNo,PeriodType,Processing,StartDate,Updated,UpdatedBy) VALUES (11,0,50015,50001,TO_TIMESTAMP('2007-12-31 16:28:10','YYYY-MM-DD HH24:MI:SS'),100,TO_TIMESTAMP('2008-04-30','YYYY-MM-DD'),'Y','Apr-08',4,'S','N',TO_TIMESTAMP('2008-04-01','YYYY-MM-DD'),TO_TIMESTAMP('2007-12-31 16:28:10','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50345,50015,TO_TIMESTAMP('2007-12-31 16:28:10','YYYY-MM-DD HH24:MI:SS'),100,'APC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:10','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50346,50015,TO_TIMESTAMP('2007-12-31 16:28:11','YYYY-MM-DD HH24:MI:SS'),100,'API','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:11','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50347,50015,TO_TIMESTAMP('2007-12-31 16:28:11','YYYY-MM-DD HH24:MI:SS'),100,'APP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:11','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50348,50015,TO_TIMESTAMP('2007-12-31 16:28:12','YYYY-MM-DD HH24:MI:SS'),100,'ARC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:12','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50349,50015,TO_TIMESTAMP('2007-12-31 16:28:12','YYYY-MM-DD HH24:MI:SS'),100,'ARI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:12','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50350,50015,TO_TIMESTAMP('2007-12-31 16:28:13','YYYY-MM-DD HH24:MI:SS'),100,'ARF','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:13','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50351,50015,TO_TIMESTAMP('2007-12-31 16:28:14','YYYY-MM-DD HH24:MI:SS'),100,'ARR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:14','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50352,50015,TO_TIMESTAMP('2007-12-31 16:28:14','YYYY-MM-DD HH24:MI:SS'),100,'CMB','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:14','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50353,50015,TO_TIMESTAMP('2007-12-31 16:28:15','YYYY-MM-DD HH24:MI:SS'),100,'CMC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:15','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50354,50015,TO_TIMESTAMP('2007-12-31 16:28:15','YYYY-MM-DD HH24:MI:SS'),100,'GLD','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:15','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50355,50015,TO_TIMESTAMP('2007-12-31 16:28:16','YYYY-MM-DD HH24:MI:SS'),100,'GLJ','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:16','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50356,50015,TO_TIMESTAMP('2007-12-31 16:28:16','YYYY-MM-DD HH24:MI:SS'),100,'MMR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:16','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50357,50015,TO_TIMESTAMP('2007-12-31 16:28:17','YYYY-MM-DD HH24:MI:SS'),100,'MMS','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:17','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50358,50015,TO_TIMESTAMP('2007-12-31 16:28:17','YYYY-MM-DD HH24:MI:SS'),100,'MXI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:17','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50359,50015,TO_TIMESTAMP('2007-12-31 16:28:18','YYYY-MM-DD HH24:MI:SS'),100,'MXP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:18','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50360,50015,TO_TIMESTAMP('2007-12-31 16:28:18','YYYY-MM-DD HH24:MI:SS'),100,'MMM','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:18','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50361,50015,TO_TIMESTAMP('2007-12-31 16:28:18','YYYY-MM-DD HH24:MI:SS'),100,'MMI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:18','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50362,50015,TO_TIMESTAMP('2007-12-31 16:28:19','YYYY-MM-DD HH24:MI:SS'),100,'MMP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:19','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50363,50015,TO_TIMESTAMP('2007-12-31 16:28:19','YYYY-MM-DD HH24:MI:SS'),100,'SOO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:19','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50364,50015,TO_TIMESTAMP('2007-12-31 16:28:20','YYYY-MM-DD HH24:MI:SS'),100,'CMA','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:20','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50365,50015,TO_TIMESTAMP('2007-12-31 16:28:20','YYYY-MM-DD HH24:MI:SS'),100,'PJI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:20','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50366,50015,TO_TIMESTAMP('2007-12-31 16:28:21','YYYY-MM-DD HH24:MI:SS'),100,'POO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:21','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50367,50015,TO_TIMESTAMP('2007-12-31 16:28:21','YYYY-MM-DD HH24:MI:SS'),100,'POR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:21','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_Period (AD_Client_ID,AD_Org_ID,C_Period_ID,C_Year_ID,Created,CreatedBy,EndDate,IsActive,Name,PeriodNo,PeriodType,Processing,StartDate,Updated,UpdatedBy) VALUES (11,0,50016,50001,TO_TIMESTAMP('2007-12-31 16:28:22','YYYY-MM-DD HH24:MI:SS'),100,TO_TIMESTAMP('2008-05-31','YYYY-MM-DD'),'Y','May-08',5,'S','N',TO_TIMESTAMP('2008-05-01','YYYY-MM-DD'),TO_TIMESTAMP('2007-12-31 16:28:22','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50368,50016,TO_TIMESTAMP('2007-12-31 16:28:22','YYYY-MM-DD HH24:MI:SS'),100,'APC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:22','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50369,50016,TO_TIMESTAMP('2007-12-31 16:28:23','YYYY-MM-DD HH24:MI:SS'),100,'API','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:23','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50370,50016,TO_TIMESTAMP('2007-12-31 16:28:23','YYYY-MM-DD HH24:MI:SS'),100,'APP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:23','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50371,50016,TO_TIMESTAMP('2007-12-31 16:28:24','YYYY-MM-DD HH24:MI:SS'),100,'ARC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:24','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50372,50016,TO_TIMESTAMP('2007-12-31 16:28:24','YYYY-MM-DD HH24:MI:SS'),100,'ARI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:24','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50373,50016,TO_TIMESTAMP('2007-12-31 16:28:25','YYYY-MM-DD HH24:MI:SS'),100,'ARF','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:25','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50374,50016,TO_TIMESTAMP('2007-12-31 16:28:25','YYYY-MM-DD HH24:MI:SS'),100,'ARR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:25','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50375,50016,TO_TIMESTAMP('2007-12-31 16:28:25','YYYY-MM-DD HH24:MI:SS'),100,'CMB','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:25','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50376,50016,TO_TIMESTAMP('2007-12-31 16:28:26','YYYY-MM-DD HH24:MI:SS'),100,'CMC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:26','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50377,50016,TO_TIMESTAMP('2007-12-31 16:28:26','YYYY-MM-DD HH24:MI:SS'),100,'GLD','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:26','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50378,50016,TO_TIMESTAMP('2007-12-31 16:28:27','YYYY-MM-DD HH24:MI:SS'),100,'GLJ','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:27','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50379,50016,TO_TIMESTAMP('2007-12-31 16:28:27','YYYY-MM-DD HH24:MI:SS'),100,'MMR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:27','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50380,50016,TO_TIMESTAMP('2007-12-31 16:28:28','YYYY-MM-DD HH24:MI:SS'),100,'MMS','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:28','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50381,50016,TO_TIMESTAMP('2007-12-31 16:28:28','YYYY-MM-DD HH24:MI:SS'),100,'MXI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:28','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50382,50016,TO_TIMESTAMP('2007-12-31 16:28:29','YYYY-MM-DD HH24:MI:SS'),100,'MXP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:29','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50383,50016,TO_TIMESTAMP('2007-12-31 16:28:29','YYYY-MM-DD HH24:MI:SS'),100,'MMM','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:29','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50384,50016,TO_TIMESTAMP('2007-12-31 16:28:29','YYYY-MM-DD HH24:MI:SS'),100,'MMI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:29','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50385,50016,TO_TIMESTAMP('2007-12-31 16:28:30','YYYY-MM-DD HH24:MI:SS'),100,'MMP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:30','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50386,50016,TO_TIMESTAMP('2007-12-31 16:28:30','YYYY-MM-DD HH24:MI:SS'),100,'SOO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:30','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50387,50016,TO_TIMESTAMP('2007-12-31 16:28:31','YYYY-MM-DD HH24:MI:SS'),100,'CMA','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:31','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50388,50016,TO_TIMESTAMP('2007-12-31 16:28:31','YYYY-MM-DD HH24:MI:SS'),100,'PJI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:31','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50389,50016,TO_TIMESTAMP('2007-12-31 16:28:32','YYYY-MM-DD HH24:MI:SS'),100,'POO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:32','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50390,50016,TO_TIMESTAMP('2007-12-31 16:28:33','YYYY-MM-DD HH24:MI:SS'),100,'POR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:33','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_Period (AD_Client_ID,AD_Org_ID,C_Period_ID,C_Year_ID,Created,CreatedBy,EndDate,IsActive,Name,PeriodNo,PeriodType,Processing,StartDate,Updated,UpdatedBy) VALUES (11,0,50017,50001,TO_TIMESTAMP('2007-12-31 16:28:33','YYYY-MM-DD HH24:MI:SS'),100,TO_TIMESTAMP('2008-06-30','YYYY-MM-DD'),'Y','Jun-08',6,'S','N',TO_TIMESTAMP('2008-06-01','YYYY-MM-DD'),TO_TIMESTAMP('2007-12-31 16:28:33','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50391,50017,TO_TIMESTAMP('2007-12-31 16:28:33','YYYY-MM-DD HH24:MI:SS'),100,'APC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:33','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50392,50017,TO_TIMESTAMP('2007-12-31 16:28:34','YYYY-MM-DD HH24:MI:SS'),100,'API','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:34','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50393,50017,TO_TIMESTAMP('2007-12-31 16:28:35','YYYY-MM-DD HH24:MI:SS'),100,'APP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:35','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50394,50017,TO_TIMESTAMP('2007-12-31 16:28:35','YYYY-MM-DD HH24:MI:SS'),100,'ARC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:35','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50395,50017,TO_TIMESTAMP('2007-12-31 16:28:36','YYYY-MM-DD HH24:MI:SS'),100,'ARI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:36','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50396,50017,TO_TIMESTAMP('2007-12-31 16:28:36','YYYY-MM-DD HH24:MI:SS'),100,'ARF','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:36','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50397,50017,TO_TIMESTAMP('2007-12-31 16:28:37','YYYY-MM-DD HH24:MI:SS'),100,'ARR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:37','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50398,50017,TO_TIMESTAMP('2007-12-31 16:28:37','YYYY-MM-DD HH24:MI:SS'),100,'CMB','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:37','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50399,50017,TO_TIMESTAMP('2007-12-31 16:28:38','YYYY-MM-DD HH24:MI:SS'),100,'CMC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:38','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50400,50017,TO_TIMESTAMP('2007-12-31 16:28:38','YYYY-MM-DD HH24:MI:SS'),100,'GLD','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:38','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50401,50017,TO_TIMESTAMP('2007-12-31 16:28:39','YYYY-MM-DD HH24:MI:SS'),100,'GLJ','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:39','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50402,50017,TO_TIMESTAMP('2007-12-31 16:28:39','YYYY-MM-DD HH24:MI:SS'),100,'MMR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:39','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50403,50017,TO_TIMESTAMP('2007-12-31 16:28:40','YYYY-MM-DD HH24:MI:SS'),100,'MMS','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:40','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50404,50017,TO_TIMESTAMP('2007-12-31 16:28:41','YYYY-MM-DD HH24:MI:SS'),100,'MXI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:41','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50405,50017,TO_TIMESTAMP('2007-12-31 16:28:41','YYYY-MM-DD HH24:MI:SS'),100,'MXP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:41','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50406,50017,TO_TIMESTAMP('2007-12-31 16:28:42','YYYY-MM-DD HH24:MI:SS'),100,'MMM','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:42','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50407,50017,TO_TIMESTAMP('2007-12-31 16:28:42','YYYY-MM-DD HH24:MI:SS'),100,'MMI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:42','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50408,50017,TO_TIMESTAMP('2007-12-31 16:28:42','YYYY-MM-DD HH24:MI:SS'),100,'MMP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:42','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50409,50017,TO_TIMESTAMP('2007-12-31 16:28:43','YYYY-MM-DD HH24:MI:SS'),100,'SOO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:43','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50410,50017,TO_TIMESTAMP('2007-12-31 16:28:43','YYYY-MM-DD HH24:MI:SS'),100,'CMA','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:43','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50411,50017,TO_TIMESTAMP('2007-12-31 16:28:44','YYYY-MM-DD HH24:MI:SS'),100,'PJI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:44','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50412,50017,TO_TIMESTAMP('2007-12-31 16:28:44','YYYY-MM-DD HH24:MI:SS'),100,'POO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:44','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50413,50017,TO_TIMESTAMP('2007-12-31 16:28:45','YYYY-MM-DD HH24:MI:SS'),100,'POR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:45','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_Period (AD_Client_ID,AD_Org_ID,C_Period_ID,C_Year_ID,Created,CreatedBy,EndDate,IsActive,Name,PeriodNo,PeriodType,Processing,StartDate,Updated,UpdatedBy) VALUES (11,0,50018,50001,TO_TIMESTAMP('2007-12-31 16:28:46','YYYY-MM-DD HH24:MI:SS'),100,TO_TIMESTAMP('2008-07-31','YYYY-MM-DD'),'Y','Jul-08',7,'S','N',TO_TIMESTAMP('2008-07-01','YYYY-MM-DD'),TO_TIMESTAMP('2007-12-31 16:28:46','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50414,50018,TO_TIMESTAMP('2007-12-31 16:28:46','YYYY-MM-DD HH24:MI:SS'),100,'APC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:46','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50415,50018,TO_TIMESTAMP('2007-12-31 16:28:47','YYYY-MM-DD HH24:MI:SS'),100,'API','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:47','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50416,50018,TO_TIMESTAMP('2007-12-31 16:28:47','YYYY-MM-DD HH24:MI:SS'),100,'APP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:47','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50417,50018,TO_TIMESTAMP('2007-12-31 16:28:47','YYYY-MM-DD HH24:MI:SS'),100,'ARC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:47','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50418,50018,TO_TIMESTAMP('2007-12-31 16:28:48','YYYY-MM-DD HH24:MI:SS'),100,'ARI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:48','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50419,50018,TO_TIMESTAMP('2007-12-31 16:28:48','YYYY-MM-DD HH24:MI:SS'),100,'ARF','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:48','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50420,50018,TO_TIMESTAMP('2007-12-31 16:28:49','YYYY-MM-DD HH24:MI:SS'),100,'ARR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:49','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50421,50018,TO_TIMESTAMP('2007-12-31 16:28:49','YYYY-MM-DD HH24:MI:SS'),100,'CMB','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:49','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50422,50018,TO_TIMESTAMP('2007-12-31 16:28:50','YYYY-MM-DD HH24:MI:SS'),100,'CMC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:50','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50423,50018,TO_TIMESTAMP('2007-12-31 16:28:51','YYYY-MM-DD HH24:MI:SS'),100,'GLD','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:51','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50424,50018,TO_TIMESTAMP('2007-12-31 16:28:52','YYYY-MM-DD HH24:MI:SS'),100,'GLJ','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:52','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50425,50018,TO_TIMESTAMP('2007-12-31 16:28:52','YYYY-MM-DD HH24:MI:SS'),100,'MMR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:52','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50426,50018,TO_TIMESTAMP('2007-12-31 16:28:53','YYYY-MM-DD HH24:MI:SS'),100,'MMS','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:53','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50427,50018,TO_TIMESTAMP('2007-12-31 16:28:53','YYYY-MM-DD HH24:MI:SS'),100,'MXI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:53','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50428,50018,TO_TIMESTAMP('2007-12-31 16:28:54','YYYY-MM-DD HH24:MI:SS'),100,'MXP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:54','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50429,50018,TO_TIMESTAMP('2007-12-31 16:28:54','YYYY-MM-DD HH24:MI:SS'),100,'MMM','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:54','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50430,50018,TO_TIMESTAMP('2007-12-31 16:28:55','YYYY-MM-DD HH24:MI:SS'),100,'MMI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:55','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50431,50018,TO_TIMESTAMP('2007-12-31 16:28:55','YYYY-MM-DD HH24:MI:SS'),100,'MMP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:55','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50432,50018,TO_TIMESTAMP('2007-12-31 16:28:55','YYYY-MM-DD HH24:MI:SS'),100,'SOO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:55','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50433,50018,TO_TIMESTAMP('2007-12-31 16:28:56','YYYY-MM-DD HH24:MI:SS'),100,'CMA','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:56','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50434,50018,TO_TIMESTAMP('2007-12-31 16:28:56','YYYY-MM-DD HH24:MI:SS'),100,'PJI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:56','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50435,50018,TO_TIMESTAMP('2007-12-31 16:28:57','YYYY-MM-DD HH24:MI:SS'),100,'POO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:57','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50436,50018,TO_TIMESTAMP('2007-12-31 16:28:57','YYYY-MM-DD HH24:MI:SS'),100,'POR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:57','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_Period (AD_Client_ID,AD_Org_ID,C_Period_ID,C_Year_ID,Created,CreatedBy,EndDate,IsActive,Name,PeriodNo,PeriodType,Processing,StartDate,Updated,UpdatedBy) VALUES (11,0,50019,50001,TO_TIMESTAMP('2007-12-31 16:28:58','YYYY-MM-DD HH24:MI:SS'),100,TO_TIMESTAMP('2008-08-31','YYYY-MM-DD'),'Y','Aug-08',8,'S','N',TO_TIMESTAMP('2008-08-01','YYYY-MM-DD'),TO_TIMESTAMP('2007-12-31 16:28:58','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50437,50019,TO_TIMESTAMP('2007-12-31 16:28:58','YYYY-MM-DD HH24:MI:SS'),100,'APC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:58','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50438,50019,TO_TIMESTAMP('2007-12-31 16:28:58','YYYY-MM-DD HH24:MI:SS'),100,'API','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:58','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50439,50019,TO_TIMESTAMP('2007-12-31 16:28:59','YYYY-MM-DD HH24:MI:SS'),100,'APP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:59','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50440,50019,TO_TIMESTAMP('2007-12-31 16:28:59','YYYY-MM-DD HH24:MI:SS'),100,'ARC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:28:59','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50441,50019,TO_TIMESTAMP('2007-12-31 16:29:00','YYYY-MM-DD HH24:MI:SS'),100,'ARI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:00','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50442,50019,TO_TIMESTAMP('2007-12-31 16:29:00','YYYY-MM-DD HH24:MI:SS'),100,'ARF','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:00','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50443,50019,TO_TIMESTAMP('2007-12-31 16:29:01','YYYY-MM-DD HH24:MI:SS'),100,'ARR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:01','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50444,50019,TO_TIMESTAMP('2007-12-31 16:29:01','YYYY-MM-DD HH24:MI:SS'),100,'CMB','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:01','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50445,50019,TO_TIMESTAMP('2007-12-31 16:29:02','YYYY-MM-DD HH24:MI:SS'),100,'CMC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:02','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50446,50019,TO_TIMESTAMP('2007-12-31 16:29:02','YYYY-MM-DD HH24:MI:SS'),100,'GLD','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:02','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50447,50019,TO_TIMESTAMP('2007-12-31 16:29:03','YYYY-MM-DD HH24:MI:SS'),100,'GLJ','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:03','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50448,50019,TO_TIMESTAMP('2007-12-31 16:29:03','YYYY-MM-DD HH24:MI:SS'),100,'MMR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:03','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50449,50019,TO_TIMESTAMP('2007-12-31 16:29:03','YYYY-MM-DD HH24:MI:SS'),100,'MMS','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:03','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50450,50019,TO_TIMESTAMP('2007-12-31 16:29:04','YYYY-MM-DD HH24:MI:SS'),100,'MXI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:04','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50451,50019,TO_TIMESTAMP('2007-12-31 16:29:04','YYYY-MM-DD HH24:MI:SS'),100,'MXP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:04','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50452,50019,TO_TIMESTAMP('2007-12-31 16:29:05','YYYY-MM-DD HH24:MI:SS'),100,'MMM','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:05','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50453,50019,TO_TIMESTAMP('2007-12-31 16:29:05','YYYY-MM-DD HH24:MI:SS'),100,'MMI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:05','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50454,50019,TO_TIMESTAMP('2007-12-31 16:29:06','YYYY-MM-DD HH24:MI:SS'),100,'MMP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:06','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50455,50019,TO_TIMESTAMP('2007-12-31 16:29:09','YYYY-MM-DD HH24:MI:SS'),100,'SOO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:09','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50456,50019,TO_TIMESTAMP('2007-12-31 16:29:10','YYYY-MM-DD HH24:MI:SS'),100,'CMA','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:10','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50457,50019,TO_TIMESTAMP('2007-12-31 16:29:11','YYYY-MM-DD HH24:MI:SS'),100,'PJI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:11','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50458,50019,TO_TIMESTAMP('2007-12-31 16:29:11','YYYY-MM-DD HH24:MI:SS'),100,'POO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:11','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50459,50019,TO_TIMESTAMP('2007-12-31 16:29:12','YYYY-MM-DD HH24:MI:SS'),100,'POR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:12','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_Period (AD_Client_ID,AD_Org_ID,C_Period_ID,C_Year_ID,Created,CreatedBy,EndDate,IsActive,Name,PeriodNo,PeriodType,Processing,StartDate,Updated,UpdatedBy) VALUES (11,0,50020,50001,TO_TIMESTAMP('2007-12-31 16:29:12','YYYY-MM-DD HH24:MI:SS'),100,TO_TIMESTAMP('2008-09-30','YYYY-MM-DD'),'Y','Sep-08',9,'S','N',TO_TIMESTAMP('2008-09-01','YYYY-MM-DD'),TO_TIMESTAMP('2007-12-31 16:29:12','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50460,50020,TO_TIMESTAMP('2007-12-31 16:29:13','YYYY-MM-DD HH24:MI:SS'),100,'APC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:13','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50461,50020,TO_TIMESTAMP('2007-12-31 16:29:14','YYYY-MM-DD HH24:MI:SS'),100,'API','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:14','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50462,50020,TO_TIMESTAMP('2007-12-31 16:29:15','YYYY-MM-DD HH24:MI:SS'),100,'APP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:15','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50463,50020,TO_TIMESTAMP('2007-12-31 16:29:15','YYYY-MM-DD HH24:MI:SS'),100,'ARC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:15','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50464,50020,TO_TIMESTAMP('2007-12-31 16:29:16','YYYY-MM-DD HH24:MI:SS'),100,'ARI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:16','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50465,50020,TO_TIMESTAMP('2007-12-31 16:29:16','YYYY-MM-DD HH24:MI:SS'),100,'ARF','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:16','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50466,50020,TO_TIMESTAMP('2007-12-31 16:29:16','YYYY-MM-DD HH24:MI:SS'),100,'ARR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:16','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50467,50020,TO_TIMESTAMP('2007-12-31 16:29:17','YYYY-MM-DD HH24:MI:SS'),100,'CMB','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:17','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50468,50020,TO_TIMESTAMP('2007-12-31 16:29:17','YYYY-MM-DD HH24:MI:SS'),100,'CMC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:17','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50469,50020,TO_TIMESTAMP('2007-12-31 16:29:18','YYYY-MM-DD HH24:MI:SS'),100,'GLD','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:18','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50470,50020,TO_TIMESTAMP('2007-12-31 16:29:18','YYYY-MM-DD HH24:MI:SS'),100,'GLJ','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:18','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50471,50020,TO_TIMESTAMP('2007-12-31 16:29:19','YYYY-MM-DD HH24:MI:SS'),100,'MMR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:19','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50472,50020,TO_TIMESTAMP('2007-12-31 16:29:20','YYYY-MM-DD HH24:MI:SS'),100,'MMS','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:20','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50473,50020,TO_TIMESTAMP('2007-12-31 16:29:20','YYYY-MM-DD HH24:MI:SS'),100,'MXI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:20','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50474,50020,TO_TIMESTAMP('2007-12-31 16:29:21','YYYY-MM-DD HH24:MI:SS'),100,'MXP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:21','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50475,50020,TO_TIMESTAMP('2007-12-31 16:29:21','YYYY-MM-DD HH24:MI:SS'),100,'MMM','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:21','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50476,50020,TO_TIMESTAMP('2007-12-31 16:29:22','YYYY-MM-DD HH24:MI:SS'),100,'MMI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:22','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50477,50020,TO_TIMESTAMP('2007-12-31 16:29:22','YYYY-MM-DD HH24:MI:SS'),100,'MMP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:22','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50478,50020,TO_TIMESTAMP('2007-12-31 16:29:22','YYYY-MM-DD HH24:MI:SS'),100,'SOO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:22','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50479,50020,TO_TIMESTAMP('2007-12-31 16:29:23','YYYY-MM-DD HH24:MI:SS'),100,'CMA','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:23','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50480,50020,TO_TIMESTAMP('2007-12-31 16:29:23','YYYY-MM-DD HH24:MI:SS'),100,'PJI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:23','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50481,50020,TO_TIMESTAMP('2007-12-31 16:29:24','YYYY-MM-DD HH24:MI:SS'),100,'POO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:24','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50482,50020,TO_TIMESTAMP('2007-12-31 16:29:24','YYYY-MM-DD HH24:MI:SS'),100,'POR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:24','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_Period (AD_Client_ID,AD_Org_ID,C_Period_ID,C_Year_ID,Created,CreatedBy,EndDate,IsActive,Name,PeriodNo,PeriodType,Processing,StartDate,Updated,UpdatedBy) VALUES (11,0,50021,50001,TO_TIMESTAMP('2007-12-31 16:29:25','YYYY-MM-DD HH24:MI:SS'),100,TO_TIMESTAMP('2008-10-31','YYYY-MM-DD'),'Y','Oct-08',10,'S','N',TO_TIMESTAMP('2008-10-01','YYYY-MM-DD'),TO_TIMESTAMP('2007-12-31 16:29:25','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50483,50021,TO_TIMESTAMP('2007-12-31 16:29:25','YYYY-MM-DD HH24:MI:SS'),100,'APC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:25','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50484,50021,TO_TIMESTAMP('2007-12-31 16:29:26','YYYY-MM-DD HH24:MI:SS'),100,'API','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:26','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50485,50021,TO_TIMESTAMP('2007-12-31 16:29:26','YYYY-MM-DD HH24:MI:SS'),100,'APP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:26','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50486,50021,TO_TIMESTAMP('2007-12-31 16:29:26','YYYY-MM-DD HH24:MI:SS'),100,'ARC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:26','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50487,50021,TO_TIMESTAMP('2007-12-31 16:29:27','YYYY-MM-DD HH24:MI:SS'),100,'ARI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:27','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50488,50021,TO_TIMESTAMP('2007-12-31 16:29:27','YYYY-MM-DD HH24:MI:SS'),100,'ARF','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:27','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50489,50021,TO_TIMESTAMP('2007-12-31 16:29:28','YYYY-MM-DD HH24:MI:SS'),100,'ARR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:28','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50490,50021,TO_TIMESTAMP('2007-12-31 16:29:28','YYYY-MM-DD HH24:MI:SS'),100,'CMB','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:28','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50491,50021,TO_TIMESTAMP('2007-12-31 16:29:29','YYYY-MM-DD HH24:MI:SS'),100,'CMC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:29','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50492,50021,TO_TIMESTAMP('2007-12-31 16:29:30','YYYY-MM-DD HH24:MI:SS'),100,'GLD','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:30','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50493,50021,TO_TIMESTAMP('2007-12-31 16:29:30','YYYY-MM-DD HH24:MI:SS'),100,'GLJ','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:30','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50494,50021,TO_TIMESTAMP('2007-12-31 16:29:31','YYYY-MM-DD HH24:MI:SS'),100,'MMR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:31','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50495,50021,TO_TIMESTAMP('2007-12-31 16:29:31','YYYY-MM-DD HH24:MI:SS'),100,'MMS','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:31','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50496,50021,TO_TIMESTAMP('2007-12-31 16:29:32','YYYY-MM-DD HH24:MI:SS'),100,'MXI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:32','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50497,50021,TO_TIMESTAMP('2007-12-31 16:29:32','YYYY-MM-DD HH24:MI:SS'),100,'MXP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:32','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50498,50021,TO_TIMESTAMP('2007-12-31 16:29:33','YYYY-MM-DD HH24:MI:SS'),100,'MMM','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:33','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50499,50021,TO_TIMESTAMP('2007-12-31 16:29:33','YYYY-MM-DD HH24:MI:SS'),100,'MMI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:33','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50500,50021,TO_TIMESTAMP('2007-12-31 16:29:34','YYYY-MM-DD HH24:MI:SS'),100,'MMP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:34','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50501,50021,TO_TIMESTAMP('2007-12-31 16:29:34','YYYY-MM-DD HH24:MI:SS'),100,'SOO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:34','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50502,50021,TO_TIMESTAMP('2007-12-31 16:29:35','YYYY-MM-DD HH24:MI:SS'),100,'CMA','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:35','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50503,50021,TO_TIMESTAMP('2007-12-31 16:29:35','YYYY-MM-DD HH24:MI:SS'),100,'PJI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:35','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50504,50021,TO_TIMESTAMP('2007-12-31 16:29:36','YYYY-MM-DD HH24:MI:SS'),100,'POO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:36','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50505,50021,TO_TIMESTAMP('2007-12-31 16:29:36','YYYY-MM-DD HH24:MI:SS'),100,'POR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:36','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_Period (AD_Client_ID,AD_Org_ID,C_Period_ID,C_Year_ID,Created,CreatedBy,EndDate,IsActive,Name,PeriodNo,PeriodType,Processing,StartDate,Updated,UpdatedBy) VALUES (11,0,50022,50001,TO_TIMESTAMP('2007-12-31 16:29:37','YYYY-MM-DD HH24:MI:SS'),100,TO_TIMESTAMP('2008-11-30','YYYY-MM-DD'),'Y','Nov-08',11,'S','N',TO_TIMESTAMP('2008-11-01','YYYY-MM-DD'),TO_TIMESTAMP('2007-12-31 16:29:37','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50506,50022,TO_TIMESTAMP('2007-12-31 16:29:37','YYYY-MM-DD HH24:MI:SS'),100,'APC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:37','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50507,50022,TO_TIMESTAMP('2007-12-31 16:29:38','YYYY-MM-DD HH24:MI:SS'),100,'API','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:38','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50508,50022,TO_TIMESTAMP('2007-12-31 16:29:38','YYYY-MM-DD HH24:MI:SS'),100,'APP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:38','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50509,50022,TO_TIMESTAMP('2007-12-31 16:29:39','YYYY-MM-DD HH24:MI:SS'),100,'ARC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:39','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50510,50022,TO_TIMESTAMP('2007-12-31 16:29:39','YYYY-MM-DD HH24:MI:SS'),100,'ARI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:39','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50511,50022,TO_TIMESTAMP('2007-12-31 16:29:39','YYYY-MM-DD HH24:MI:SS'),100,'ARF','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:39','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50512,50022,TO_TIMESTAMP('2007-12-31 16:29:40','YYYY-MM-DD HH24:MI:SS'),100,'ARR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:40','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50513,50022,TO_TIMESTAMP('2007-12-31 16:29:40','YYYY-MM-DD HH24:MI:SS'),100,'CMB','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:40','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50514,50022,TO_TIMESTAMP('2007-12-31 16:29:41','YYYY-MM-DD HH24:MI:SS'),100,'CMC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:41','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50515,50022,TO_TIMESTAMP('2007-12-31 16:29:41','YYYY-MM-DD HH24:MI:SS'),100,'GLD','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:41','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50516,50022,TO_TIMESTAMP('2007-12-31 16:29:42','YYYY-MM-DD HH24:MI:SS'),100,'GLJ','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:42','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50517,50022,TO_TIMESTAMP('2007-12-31 16:29:42','YYYY-MM-DD HH24:MI:SS'),100,'MMR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:42','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50518,50022,TO_TIMESTAMP('2007-12-31 16:29:43','YYYY-MM-DD HH24:MI:SS'),100,'MMS','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:43','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50519,50022,TO_TIMESTAMP('2007-12-31 16:29:43','YYYY-MM-DD HH24:MI:SS'),100,'MXI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:43','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50520,50022,TO_TIMESTAMP('2007-12-31 16:29:44','YYYY-MM-DD HH24:MI:SS'),100,'MXP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:44','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50521,50022,TO_TIMESTAMP('2007-12-31 16:29:44','YYYY-MM-DD HH24:MI:SS'),100,'MMM','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:44','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50522,50022,TO_TIMESTAMP('2007-12-31 16:29:44','YYYY-MM-DD HH24:MI:SS'),100,'MMI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:44','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50523,50022,TO_TIMESTAMP('2007-12-31 16:29:45','YYYY-MM-DD HH24:MI:SS'),100,'MMP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:45','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50524,50022,TO_TIMESTAMP('2007-12-31 16:29:46','YYYY-MM-DD HH24:MI:SS'),100,'SOO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:46','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50525,50022,TO_TIMESTAMP('2007-12-31 16:29:47','YYYY-MM-DD HH24:MI:SS'),100,'CMA','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:47','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50526,50022,TO_TIMESTAMP('2007-12-31 16:29:48','YYYY-MM-DD HH24:MI:SS'),100,'PJI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:48','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50527,50022,TO_TIMESTAMP('2007-12-31 16:29:49','YYYY-MM-DD HH24:MI:SS'),100,'POO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:49','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50528,50022,TO_TIMESTAMP('2007-12-31 16:29:50','YYYY-MM-DD HH24:MI:SS'),100,'POR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:50','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_Period (AD_Client_ID,AD_Org_ID,C_Period_ID,C_Year_ID,Created,CreatedBy,EndDate,IsActive,Name,PeriodNo,PeriodType,Processing,StartDate,Updated,UpdatedBy) VALUES (11,0,50023,50001,TO_TIMESTAMP('2007-12-31 16:29:50','YYYY-MM-DD HH24:MI:SS'),100,TO_TIMESTAMP('2008-12-31','YYYY-MM-DD'),'Y','Dec-08',12,'S','N',TO_TIMESTAMP('2008-12-01','YYYY-MM-DD'),TO_TIMESTAMP('2007-12-31 16:29:50','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50529,50023,TO_TIMESTAMP('2007-12-31 16:29:51','YYYY-MM-DD HH24:MI:SS'),100,'APC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:51','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50530,50023,TO_TIMESTAMP('2007-12-31 16:29:53','YYYY-MM-DD HH24:MI:SS'),100,'API','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:53','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50531,50023,TO_TIMESTAMP('2007-12-31 16:29:53','YYYY-MM-DD HH24:MI:SS'),100,'APP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:53','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50532,50023,TO_TIMESTAMP('2007-12-31 16:29:54','YYYY-MM-DD HH24:MI:SS'),100,'ARC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:54','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50533,50023,TO_TIMESTAMP('2007-12-31 16:29:55','YYYY-MM-DD HH24:MI:SS'),100,'ARI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:55','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50534,50023,TO_TIMESTAMP('2007-12-31 16:29:55','YYYY-MM-DD HH24:MI:SS'),100,'ARF','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:55','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50535,50023,TO_TIMESTAMP('2007-12-31 16:29:59','YYYY-MM-DD HH24:MI:SS'),100,'ARR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:29:59','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50536,50023,TO_TIMESTAMP('2007-12-31 16:30:02','YYYY-MM-DD HH24:MI:SS'),100,'CMB','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:02','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50537,50023,TO_TIMESTAMP('2007-12-31 16:30:03','YYYY-MM-DD HH24:MI:SS'),100,'CMC','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:03','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50538,50023,TO_TIMESTAMP('2007-12-31 16:30:03','YYYY-MM-DD HH24:MI:SS'),100,'GLD','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:03','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50539,50023,TO_TIMESTAMP('2007-12-31 16:30:04','YYYY-MM-DD HH24:MI:SS'),100,'GLJ','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:04','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50540,50023,TO_TIMESTAMP('2007-12-31 16:30:04','YYYY-MM-DD HH24:MI:SS'),100,'MMR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:04','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50541,50023,TO_TIMESTAMP('2007-12-31 16:30:05','YYYY-MM-DD HH24:MI:SS'),100,'MMS','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:05','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50542,50023,TO_TIMESTAMP('2007-12-31 16:30:06','YYYY-MM-DD HH24:MI:SS'),100,'MXI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:06','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50543,50023,TO_TIMESTAMP('2007-12-31 16:30:06','YYYY-MM-DD HH24:MI:SS'),100,'MXP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:06','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50544,50023,TO_TIMESTAMP('2007-12-31 16:30:08','YYYY-MM-DD HH24:MI:SS'),100,'MMM','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:08','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50545,50023,TO_TIMESTAMP('2007-12-31 16:30:09','YYYY-MM-DD HH24:MI:SS'),100,'MMI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:09','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50546,50023,TO_TIMESTAMP('2007-12-31 16:30:09','YYYY-MM-DD HH24:MI:SS'),100,'MMP','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:09','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50547,50023,TO_TIMESTAMP('2007-12-31 16:30:10','YYYY-MM-DD HH24:MI:SS'),100,'SOO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:10','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50548,50023,TO_TIMESTAMP('2007-12-31 16:30:11','YYYY-MM-DD HH24:MI:SS'),100,'CMA','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:11','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50549,50023,TO_TIMESTAMP('2007-12-31 16:30:11','YYYY-MM-DD HH24:MI:SS'),100,'PJI','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:11','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50550,50023,TO_TIMESTAMP('2007-12-31 16:30:12','YYYY-MM-DD HH24:MI:SS'),100,'POO','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:12','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO C_PeriodControl (AD_Client_ID,AD_Org_ID,C_PeriodControl_ID,C_Period_ID,Created,CreatedBy,DocBaseType,IsActive,PeriodAction,PeriodStatus,Processing,Updated,UpdatedBy) VALUES (11,0,50551,50023,TO_TIMESTAMP('2007-12-31 16:30:12','YYYY-MM-DD HH24:MI:SS'),100,'POR','Y','N','N','N',TO_TIMESTAMP('2007-12-31 16:30:12','YYYY-MM-DD HH24:MI:SS'),100)
;

SELECT '051_placeholder_branch350.sql' AS Filename;

SELECT '052_placeholder_branch350.sql' AS Filename;

SELECT '053_placeholder_branch350.sql' AS Filename;

SELECT '054_placeholder_branch350.sql' AS Filename;

SELECT '055_Bug1863640.sql' AS Filename;
-- Jan 3, 2008 6:21:51 PM COT
-- 1863640 - Window View Allocation is showing Post button
UPDATE AD_Field SET DisplayLogic='@Processed@=Y & @#ShowAcct@=Y',Updated=TO_TIMESTAMP('2008-01-03 18:21:50','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=10430
;


SELECT '056_FR1782412_beautifywindow.sql' AS Filename;
-- Jan 3, 2008 6:15:05 PM COT
-- Beautify window [ 1782412 ] Add Document Action Access Functionality
UPDATE AD_Field SET SeqNo=30,IsDisplayed='Y' WHERE AD_Field_ID=53247
;

UPDATE AD_Field SET SeqNo=40,IsDisplayed='Y' WHERE AD_Field_ID=53244
;

UPDATE AD_Field SET SeqNo=50,IsDisplayed='Y' WHERE AD_Field_ID=53246
;

UPDATE AD_Field SET SeqNo=60,IsDisplayed='Y' WHERE AD_Field_ID=53241
;

UPDATE AD_Field SET DisplayLength=20,Updated=TO_TIMESTAMP('2008-01-03 18:15:35','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=53242
;

UPDATE AD_Field SET DisplayLength=20, IsSameLine='Y',Updated=TO_TIMESTAMP('2008-01-03 18:15:41','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=53245
;

UPDATE AD_Field SET DisplayLength=20,Updated=TO_TIMESTAMP('2008-01-03 18:16:13','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=53247
;

UPDATE AD_Field SET DisplayLength=20,Updated=TO_TIMESTAMP('2008-01-03 18:16:33','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=53244
;

UPDATE AD_Field SET DisplayLength=20,Updated=TO_TIMESTAMP('2008-01-03 18:16:38','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=53246
;


SELECT '057_BF1866222.sql' AS Filename;
-- [ 1866222 ] Wrong default dictionary entry for C_CashBook.C_Currency_ID
UPDATE AD_COLUMN SET defaultvalue = NULL
WHERE ad_column_id = 5521;
SELECT '058_placeholder_branch350.sql' AS Filename;

SELECT '059_placeholder_branch350.sql' AS Filename;

SELECT '060_FR_1866483JasperFinancialReports.sql' AS Filename;
-- Jan 7, 2008 9:37:36 PM COT
-- 1866483 - Jasper on Financial Reports
INSERT INTO AD_Column (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,Name,SeqNo,Updated,UpdatedBy,Version) VALUES (0,54091,50064,0,18,400,445,'JasperProcess_ID',TO_TIMESTAMP('2008-01-07 21:37:34','YYYY-MM-DD HH24:MI:SS'),100,'The Jasper Process used by the printengine if any process defined','D',22,'Y','N','N','N','N','N','N','N','N','N','Y','Jasper Process',0,TO_TIMESTAMP('2008-01-07 21:37:34','YYYY-MM-DD HH24:MI:SS'),100,1.000000000000)
;

INSERT INTO AD_Column_Trl (AD_Language,AD_Column_ID, Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Column_ID, t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Column t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54091 AND EXISTS (SELECT * FROM AD_Column_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Column_ID!=t.AD_Column_ID)
;

ALTER TABLE PA_Report ADD COLUMN JasperProcess_ID NUMERIC(10)
;

INSERT INTO AD_Element (AD_Client_ID,AD_Element_ID,AD_Org_ID,ColumnName,Created,CreatedBy,EntityType,IsActive,Name,PrintName,Updated,UpdatedBy) VALUES (0,53323,0,'JasperProcessing',TO_TIMESTAMP('2008-01-07 21:40:17','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','Jasper Process Now','Jasper Process Now',TO_TIMESTAMP('2008-01-07 21:40:17','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Element_Trl (AD_Language,AD_Element_ID, Description,Help,Name,PO_Description,PO_Help,PO_Name,PO_PrintName,PrintName, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Element_ID, t.Description,t.Help,t.Name,t.PO_Description,t.PO_Help,t.PO_Name,t.PO_PrintName,t.PrintName, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Element t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Element_ID=53323 AND EXISTS (SELECT * FROM AD_Element_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Element_ID!=t.AD_Element_ID)
;

INSERT INTO AD_Process (AD_Client_ID,AD_Org_ID,AD_Process_ID,AccessLevel,Classname,Created,CreatedBy,Description,EntityType,Help,IsActive,IsBetaFunctionality,IsDirectPrint,IsReport,IsServerProcess,Name,ShowHelp,Statistic_Count,Statistic_Seconds,Updated,UpdatedBy,Value) VALUES (0,0,53063,'3','org.compiere.report.FinReportJasper',TO_TIMESTAMP('2008-01-07 21:41:49','YYYY-MM-DD HH24:MI:SS'),100,'Create Financial Report  (Jasper)','D','The default period is the current period. You can optionally enter other restrictions.  You can select an alternative Reporting Hierarchy.','Y','N','N','N','N','Create Report (Jasper)','Y',0,0,TO_TIMESTAMP('2008-01-07 21:41:49','YYYY-MM-DD HH24:MI:SS'),100,'FinReportJasper')
;

INSERT INTO AD_Process_Trl (AD_Language,AD_Process_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Process_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Process t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_ID=53063 AND EXISTS (SELECT * FROM AD_Process_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Process_ID!=t.AD_Process_ID)
;

INSERT INTO AD_Process_Access (AD_Client_ID,AD_Org_ID,AD_Process_ID,AD_Role_ID,Created,CreatedBy,IsActive,Updated,UpdatedBy) VALUES (0,0,53063,0,TO_TIMESTAMP('2008-01-07 21:41:57','YYYY-MM-DD HH24:MI:SS'),100,'Y',TO_TIMESTAMP('2008-01-07 21:41:57','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Process_Access (AD_Client_ID,AD_Org_ID,AD_Process_ID,AD_Role_ID,Created,CreatedBy,IsActive,Updated,UpdatedBy) VALUES (0,0,53063,102,TO_TIMESTAMP('2008-01-07 21:41:57','YYYY-MM-DD HH24:MI:SS'),100,'Y',TO_TIMESTAMP('2008-01-07 21:41:57','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Process_Access (AD_Client_ID,AD_Org_ID,AD_Process_ID,AD_Role_ID,Created,CreatedBy,IsActive,Updated,UpdatedBy) VALUES (0,0,53063,103,TO_TIMESTAMP('2008-01-07 21:41:57','YYYY-MM-DD HH24:MI:SS'),100,'Y',TO_TIMESTAMP('2008-01-07 21:41:57','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Process_Access (AD_Client_ID,AD_Org_ID,AD_Process_ID,AD_Role_ID,Created,CreatedBy,IsActive,Updated,UpdatedBy) VALUES (0,0,53063,50001,TO_TIMESTAMP('2008-01-07 21:41:57','YYYY-MM-DD HH24:MI:SS'),100,'Y',TO_TIMESTAMP('2008-01-07 21:41:57','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Column (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Process_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,Name,SeqNo,Updated,UpdatedBy,Version) VALUES (0,54092,53323,0,53063,28,445,'JasperProcessing',TO_TIMESTAMP('2008-01-07 21:42:27','YYYY-MM-DD HH24:MI:SS'),100,'D',1,'Y','N','N','N','N','Y','N','N','N','N','Y','Jasper Process Now',0,TO_TIMESTAMP('2008-01-07 21:42:27','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_Column_Trl (AD_Language,AD_Column_ID, Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Column_ID, t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Column t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54092 AND EXISTS (SELECT * FROM AD_Column_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Column_ID!=t.AD_Column_ID)
;

UPDATE AD_Column SET IsMandatory='N',Updated=TO_TIMESTAMP('2008-01-07 21:43:19','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Column_ID=54092
;

UPDATE AD_Field SET Name='Jasper Process Now', Description=NULL, Help=NULL WHERE AD_Column_ID=54092 AND IsCentrallyMaintained='Y'
;

ALTER TABLE PA_Report ADD COLUMN JasperProcessing CHAR(1)
;

INSERT INTO AD_Process_Para (AD_Client_ID,AD_Element_ID,AD_Org_ID,AD_Process_ID,AD_Process_Para_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsCentrallyMaintained,IsMandatory,IsRange,Name,SeqNo,Updated,UpdatedBy) VALUES (0,206,0,53063,53114,18,275,217,'C_Period_ID',TO_TIMESTAMP('2008-01-07 21:44:40','YYYY-MM-DD HH24:MI:SS'),100,'Period of the Calendar','D',0,'The Period indicates an exclusive range of dates for a calendar.','Y','Y','N','N','Period',10,TO_TIMESTAMP('2008-01-07 21:44:40','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Process_Para_Trl (AD_Language,AD_Process_Para_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Process_Para_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Process_Para t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_Para_ID=53114 AND EXISTS (SELECT * FROM AD_Process_Para_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Process_Para_ID!=t.AD_Process_Para_ID)
;

INSERT INTO AD_Process_Para (AD_Client_ID,AD_Element_ID,AD_Org_ID,AD_Process_ID,AD_Process_Para_ID,AD_Reference_ID,AD_Reference_Value_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsCentrallyMaintained,IsMandatory,IsRange,Name,SeqNo,Updated,UpdatedBy) VALUES (0,479,0,53063,53115,18,322,'Org_ID',TO_TIMESTAMP('2008-01-07 21:45:09','YYYY-MM-DD HH24:MI:SS'),100,'Organizational entity within client','D',0,'An organization is a unit of your client or legal entity - examples are store, department.','Y','Y','N','N','Organization',20,TO_TIMESTAMP('2008-01-07 21:45:09','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Process_Para_Trl (AD_Language,AD_Process_Para_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Process_Para_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Process_Para t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_Para_ID=53115 AND EXISTS (SELECT * FROM AD_Process_Para_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Process_Para_ID!=t.AD_Process_Para_ID)
;

INSERT INTO AD_Process_Para (AD_Client_ID,AD_Element_ID,AD_Org_ID,AD_Process_ID,AD_Process_Para_ID,AD_Reference_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsCentrallyMaintained,IsMandatory,IsRange,Name,SeqNo,Updated,UpdatedBy) VALUES (0,187,0,53063,53116,19,'C_BPartner_ID',TO_TIMESTAMP('2008-01-07 21:45:39','YYYY-MM-DD HH24:MI:SS'),100,'Identifies a Business Partner','D',0,'A Business Partner is anyone with whom you transact.  This can include Vendor, Customer, Employee or Salesperson','Y','Y','N','N','Business Partner ',30,TO_TIMESTAMP('2008-01-07 21:45:39','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Process_Para_Trl (AD_Language,AD_Process_Para_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Process_Para_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Process_Para t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_Para_ID=53116 AND EXISTS (SELECT * FROM AD_Process_Para_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Process_Para_ID!=t.AD_Process_Para_ID)
;

INSERT INTO AD_Process_Para (AD_Client_ID,AD_Element_ID,AD_Org_ID,AD_Process_ID,AD_Process_Para_ID,AD_Reference_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsCentrallyMaintained,IsMandatory,IsRange,Name,SeqNo,Updated,UpdatedBy) VALUES (0,454,0,53063,53117,19,'M_Product_ID',TO_TIMESTAMP('2008-01-07 21:46:05','YYYY-MM-DD HH24:MI:SS'),100,'Product, Service, Item','D',0,'Identifies an item which is either purchased or sold in this organization.','Y','Y','N','N','Product',40,TO_TIMESTAMP('2008-01-07 21:46:05','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Process_Para_Trl (AD_Language,AD_Process_Para_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Process_Para_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Process_Para t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_Para_ID=53117 AND EXISTS (SELECT * FROM AD_Process_Para_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Process_Para_ID!=t.AD_Process_Para_ID)
;

INSERT INTO AD_Process_Para (AD_Client_ID,AD_Element_ID,AD_Org_ID,AD_Process_ID,AD_Process_Para_ID,AD_Reference_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsCentrallyMaintained,IsMandatory,IsRange,Name,SeqNo,Updated,UpdatedBy) VALUES (0,208,0,53063,53118,19,'C_Project_ID',TO_TIMESTAMP('2008-01-07 21:47:04','YYYY-MM-DD HH24:MI:SS'),100,'Financial Project','D',0,'A Project allows you to track and control internal or external activities.','Y','Y','N','N','Project',50,TO_TIMESTAMP('2008-01-07 21:47:04','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Process_Para_Trl (AD_Language,AD_Process_Para_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Process_Para_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Process_Para t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_Para_ID=53118 AND EXISTS (SELECT * FROM AD_Process_Para_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Process_Para_ID!=t.AD_Process_Para_ID)
;

INSERT INTO AD_Process_Para (AD_Client_ID,AD_Element_ID,AD_Org_ID,AD_Process_ID,AD_Process_Para_ID,AD_Reference_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsCentrallyMaintained,IsMandatory,IsRange,Name,SeqNo,Updated,UpdatedBy) VALUES (0,1005,0,53063,53119,19,'C_Activity_ID',TO_TIMESTAMP('2008-01-07 21:47:41','YYYY-MM-DD HH24:MI:SS'),100,'Business Activity','D',0,'Activities indicate tasks that are performed and used to utilize Activity based Costing','Y','Y','N','N','Activity',60,TO_TIMESTAMP('2008-01-07 21:47:41','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Process_Para_Trl (AD_Language,AD_Process_Para_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Process_Para_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Process_Para t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_Para_ID=53119 AND EXISTS (SELECT * FROM AD_Process_Para_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Process_Para_ID!=t.AD_Process_Para_ID)
;

INSERT INTO AD_Process_Para (AD_Client_ID,AD_Element_ID,AD_Org_ID,AD_Process_ID,AD_Process_Para_ID,AD_Reference_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsCentrallyMaintained,IsMandatory,IsRange,Name,SeqNo,Updated,UpdatedBy) VALUES (0,210,0,53063,53120,19,'C_SalesRegion_ID',TO_TIMESTAMP('2008-01-07 21:48:11','YYYY-MM-DD HH24:MI:SS'),100,'Sales coverage region','D',0,'The Sales Region indicates a specific area of sales coverage.','Y','Y','N','N','Sales Region',70,TO_TIMESTAMP('2008-01-07 21:48:11','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Process_Para_Trl (AD_Language,AD_Process_Para_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Process_Para_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Process_Para t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_Para_ID=53120 AND EXISTS (SELECT * FROM AD_Process_Para_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Process_Para_ID!=t.AD_Process_Para_ID)
;

INSERT INTO AD_Process_Para (AD_Client_ID,AD_Element_ID,AD_Org_ID,AD_Process_ID,AD_Process_Para_ID,AD_Reference_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsCentrallyMaintained,IsMandatory,IsRange,Name,SeqNo,Updated,UpdatedBy) VALUES (0,550,0,53063,53121,19,'C_Campaign_ID',TO_TIMESTAMP('2008-01-07 21:48:35','YYYY-MM-DD HH24:MI:SS'),100,'Marketing Campaign','D',0,'The Campaign defines a unique marketing program.  Projects can be associated with a pre defined Marketing Campaign.  You can then report based on a specific Campaign.','Y','Y','N','N','Campaign',80,TO_TIMESTAMP('2008-01-07 21:48:35','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Process_Para_Trl (AD_Language,AD_Process_Para_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Process_Para_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Process_Para t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_Para_ID=53121 AND EXISTS (SELECT * FROM AD_Process_Para_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Process_Para_ID!=t.AD_Process_Para_ID)
;

INSERT INTO AD_Process_Para (AD_Client_ID,AD_Org_ID,AD_Process_ID,AD_Process_Para_ID,AD_Reference_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,IsActive,IsCentrallyMaintained,IsMandatory,IsRange,Name,SeqNo,Updated,UpdatedBy) VALUES (0,0,53063,53122,20,'DetailsSourceFirst',TO_TIMESTAMP('2008-01-07 21:49:04','YYYY-MM-DD HH24:MI:SS'),100,'Details and Sources are printed before the Line','D',0,'Y','Y','N','N','Details/Source First',90,TO_TIMESTAMP('2008-01-07 21:49:04','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Process_Para_Trl (AD_Language,AD_Process_Para_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Process_Para_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Process_Para t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_Para_ID=53122 AND EXISTS (SELECT * FROM AD_Process_Para_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Process_Para_ID!=t.AD_Process_Para_ID)
;

INSERT INTO AD_Process_Para (AD_Client_ID,AD_Element_ID,AD_Org_ID,AD_Process_ID,AD_Process_Para_ID,AD_Reference_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,IsActive,IsCentrallyMaintained,IsMandatory,IsRange,Name,SeqNo,Updated,UpdatedBy) VALUES (0,2344,0,53063,53123,20,'UpdateBalances',TO_TIMESTAMP('2008-01-07 21:49:52','YYYY-MM-DD HH24:MI:SS'),100,'Y','Update Accounting Balances first (not required for subsequent runs)','D',0,'Y','Y','Y','N','Update Balances',100,TO_TIMESTAMP('2008-01-07 21:49:52','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Process_Para_Trl (AD_Language,AD_Process_Para_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Process_Para_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Process_Para t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_Para_ID=53123 AND EXISTS (SELECT * FROM AD_Process_Para_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Process_Para_ID!=t.AD_Process_Para_ID)
;

INSERT INTO AD_Process_Para (AD_Client_ID,AD_Element_ID,AD_Org_ID,AD_Process_ID,AD_Process_Para_ID,AD_Reference_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsCentrallyMaintained,IsMandatory,IsRange,Name,SeqNo,Updated,UpdatedBy) VALUES (0,2868,0,53063,53124,19,'PA_Hierarchy_ID',TO_TIMESTAMP('2008-01-07 21:50:22','YYYY-MM-DD HH24:MI:SS'),100,'Optional Reporting Hierarchy - If not selected the default hierarchy trees are used.','D',0,'Reporting Hierarchy allows you to select different Hierarchies/Trees for the report.
Accounting Segments like Organization, Account, Product may have several hierarchies to accomodate different views on the business.','Y','Y','N','N','Reporting Hierarchy',110,TO_TIMESTAMP('2008-01-07 21:50:22','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Process_Para_Trl (AD_Language,AD_Process_Para_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Process_Para_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Process_Para t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_Para_ID=53124 AND EXISTS (SELECT * FROM AD_Process_Para_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Process_Para_ID!=t.AD_Process_Para_ID)
;

INSERT INTO AD_Field (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsEncrypted,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,Name,Updated,UpdatedBy) VALUES (0,54091,54234,0,372,TO_TIMESTAMP('2008-01-07 21:51:00','YYYY-MM-DD HH24:MI:SS'),100,'The Jasper Process used by the printengine if any process defined',22,'D','Y','Y','Y','N','N','N','N','N','Jasper Process',TO_TIMESTAMP('2008-01-07 21:51:00','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Field_Trl (AD_Language,AD_Field_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Field_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Field t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54234 AND EXISTS (SELECT * FROM AD_Field_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_Field (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsEncrypted,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,Name,Updated,UpdatedBy) VALUES (0,54092,54235,0,372,TO_TIMESTAMP('2008-01-07 21:51:02','YYYY-MM-DD HH24:MI:SS'),100,1,'D','Y','Y','Y','N','N','N','N','N','Jasper Process Now',TO_TIMESTAMP('2008-01-07 21:51:02','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Field_Trl (AD_Language,AD_Field_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Field_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Field t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54235 AND EXISTS (SELECT * FROM AD_Field_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Field_ID!=t.AD_Field_ID)
;

UPDATE AD_Field SET SeqNo=0,IsDisplayed='N' WHERE AD_Field_ID=4731
;

UPDATE AD_Field SET SeqNo=10,IsDisplayed='Y' WHERE AD_Field_ID=4732
;

UPDATE AD_Field SET SeqNo=20,IsDisplayed='Y' WHERE AD_Field_ID=4733
;

UPDATE AD_Field SET SeqNo=30,IsDisplayed='Y' WHERE AD_Field_ID=6263
;

UPDATE AD_Field SET SeqNo=40,IsDisplayed='Y' WHERE AD_Field_ID=6264
;

UPDATE AD_Field SET SeqNo=50,IsDisplayed='Y' WHERE AD_Field_ID=4739
;

UPDATE AD_Field SET SeqNo=60,IsDisplayed='Y' WHERE AD_Field_ID=4734
;

UPDATE AD_Field SET SeqNo=70,IsDisplayed='Y' WHERE AD_Field_ID=4738
;

UPDATE AD_Field SET SeqNo=80,IsDisplayed='Y' WHERE AD_Field_ID=4735
;

UPDATE AD_Field SET SeqNo=90,IsDisplayed='Y' WHERE AD_Field_ID=4736
;

UPDATE AD_Field SET SeqNo=100,IsDisplayed='Y' WHERE AD_Field_ID=54234
;

UPDATE AD_Field SET SeqNo=140,IsDisplayed='Y' WHERE AD_Field_ID=54235
;

UPDATE AD_Field SET SeqNo=150,IsDisplayed='Y' WHERE AD_Field_ID=6265
;

UPDATE AD_Field SET DisplayLogic='@JasperProcess_ID@=0',Updated=TO_TIMESTAMP('2008-01-07 21:52:25','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=4737
;

UPDATE AD_Field SET DisplayLogic='@JasperProcess_ID@>0',Updated=TO_TIMESTAMP('2008-01-07 21:53:49','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=54235
;

UPDATE AD_Field SET DisplayLength=23,Updated=TO_TIMESTAMP('2008-01-07 21:55:11','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=54235
;

UPDATE AD_Field SET Name='Create Report (Jasper)',Updated=TO_TIMESTAMP('2008-01-07 21:55:28','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=54235
;

UPDATE AD_Field_Trl SET IsTranslated='N' WHERE AD_Field_ID=54235
;

UPDATE AD_Field SET Description='Create Financial Report (Jasper)',Updated=TO_TIMESTAMP('2008-01-07 21:55:35','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=54235
;

UPDATE AD_Field_Trl SET IsTranslated='N' WHERE AD_Field_ID=54235
;

UPDATE AD_Field SET Help='The default period is the current period. You can optionally enter other restrictions.  You can select an alternative Reporting Hierarchy.',Updated=TO_TIMESTAMP('2008-01-07 21:55:40','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=54235
;

UPDATE AD_Field_Trl SET IsTranslated='N' WHERE AD_Field_ID=54235
;

UPDATE AD_Field SET AD_FieldGroup_ID=114,Updated=TO_TIMESTAMP('2008-01-07 21:55:50','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=54235
;


SELECT '061_BF1851188.sql' AS Filename;
-- Jan 8, 2008 7:04:17 PM COT
-- [ 1851188 ] Missing ModelValidator must fail client to start
INSERT INTO AD_Element (AD_Client_ID,AD_Element_ID,AD_Org_ID,ColumnName,Created,CreatedBy,Description,EntityType,Help,IsActive,Name,PrintName,Updated,UpdatedBy) VALUES (0,53324,0,'IsFailOnMissingModelValidator',TO_TIMESTAMP('2008-01-08 19:04:14','YYYY-MM-DD HH24:MI:SS'),0,NULL,'D',NULL,'Y','Fail on Missing Model Validator','Fail on Missing Model Validator',TO_TIMESTAMP('2008-01-08 19:04:14','YYYY-MM-DD HH24:MI:SS'),0)
;

INSERT INTO AD_Element_Trl (AD_Language,AD_Element_ID, Description,Help,Name,PO_Description,PO_Help,PO_Name,PO_PrintName,PrintName, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Element_ID, t.Description,t.Help,t.Name,t.PO_Description,t.PO_Help,t.PO_Name,t.PO_PrintName,t.PrintName, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Element t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Element_ID=53324 AND EXISTS (SELECT * FROM AD_Element_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Element_ID!=t.AD_Element_ID)
;

INSERT INTO AD_Column (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,Name,SeqNo,Updated,UpdatedBy,Version) VALUES (0,54093,53324,0,20,531,'IsFailOnMissingModelValidator',TO_TIMESTAMP('2008-01-08 19:04:46','YYYY-MM-DD HH24:MI:SS'),0,'Y','D',1,'Y','N','N','N','N','Y','N','N','N','N','Y','Fail on Missing Model Validator',0,TO_TIMESTAMP('2008-01-08 19:04:46','YYYY-MM-DD HH24:MI:SS'),0,1.000000000000)
;

INSERT INTO AD_Column_Trl (AD_Language,AD_Column_ID, Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Column_ID, t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Column t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54093 AND EXISTS (SELECT * FROM AD_Column_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Column_ID!=t.AD_Column_ID)
;

ALTER TABLE AD_System ADD COLUMN IsFailOnMissingModelValidator CHAR(1) DEFAULT 'Y' CHECK (IsFailOnMissingModelValidator IN ('Y','N')) NOT NULL
;

INSERT INTO AD_Field (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsEncrypted,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,Name,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54093,54236,0,440,TO_TIMESTAMP('2008-01-08 19:08:25','YYYY-MM-DD HH24:MI:SS'),0,1,'D','Y','Y','Y','N','N','N','N','N','Fail on Missing Model Validator',235,0,TO_TIMESTAMP('2008-01-08 19:08:25','YYYY-MM-DD HH24:MI:SS'),0)
;

INSERT INTO AD_Field_Trl (AD_Language,AD_Field_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Field_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Field t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54236 AND EXISTS (SELECT * FROM AD_Field_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Field_ID!=t.AD_Field_ID)
;


SELECT '062_FR1853645.sql' AS Filename;
-- Jan 8, 2008 8:30:01 PM COT
-- 1853645 - Priority for model validator
INSERT INTO AD_Column (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,Name,SeqNo,Updated,UpdatedBy,Version) VALUES (0,54094,566,0,11,53014,'SeqNo',TO_TIMESTAMP('2008-01-08 20:29:58','YYYY-MM-DD HH24:MI:SS'),100,'Method of ordering records; lowest number comes first','D',22,'The Sequence indicates the order of records','Y','N','N','N','N','N','N','N','N','N','Y','Sequence',0,TO_TIMESTAMP('2008-01-08 20:29:58','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_Column_Trl (AD_Language,AD_Column_ID, Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Column_ID, t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Column t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54094 AND EXISTS (SELECT * FROM AD_Column_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Column_ID!=t.AD_Column_ID)
;

ALTER TABLE AD_ModelValidator ADD COLUMN SeqNo NUMERIC(10)
;

INSERT INTO AD_Field (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsEncrypted,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,Name,Updated,UpdatedBy) VALUES (0,54094,54237,0,53014,TO_TIMESTAMP('2008-01-08 20:30:35','YYYY-MM-DD HH24:MI:SS'),100,'Method of ordering records; lowest number comes first',22,'D','The Sequence indicates the order of records','Y','Y','Y','N','N','N','N','N','Sequence',TO_TIMESTAMP('2008-01-08 20:30:35','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_Field_Trl (AD_Language,AD_Field_ID, Description,Help,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_Language,t.AD_Field_ID, t.Description,t.Help,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_Language l, AD_Field t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54237 AND EXISTS (SELECT * FROM AD_Field_Trl tt WHERE tt.AD_Language!=l.AD_Language OR tt.AD_Field_ID!=t.AD_Field_ID)
;

UPDATE AD_Field SET SeqNo=70,IsDisplayed='Y' WHERE AD_Field_ID=53278
;

UPDATE AD_Field SET SeqNo=80,IsDisplayed='Y' WHERE AD_Field_ID=54237
;

UPDATE AD_Field SET SeqNo=90,IsDisplayed='Y' WHERE AD_Field_ID=53277
;

UPDATE AD_Field SET IsSameLine='Y',Updated=TO_TIMESTAMP('2008-01-08 20:31:04','YYYY-MM-DD HH24:MI:SS'),UpdatedBy=100 WHERE AD_Field_ID=53272
;


SELECT '063_FR1851188_ASP.sql' AS Filename;
-- Jan 9, 2008 11:29:56 PM COT
-- 1846929 - SaaS (ASP) (On-Demand) configurator
INSERT INTO AD_ELEMENT (AD_Client_ID,AD_Element_ID,AD_Org_ID,ColumnName,Created,CreatedBy,EntityType,IsActive,NAME,PrintName,Updated,UpdatedBy) VALUES (0,53325,0,'IsUseASP',TO_TIMESTAMP('2008-01-09 23:29:56','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','IsUseASP','IsUseASP',TO_TIMESTAMP('2008-01-09 23:29:56','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_ELEMENT_TRL (AD_LANGUAGE,AD_Element_ID, Description,Help,NAME,PO_Description,PO_Help,PO_Name,PO_PrintName,PrintName, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Element_ID, t.Description,t.Help,t.NAME,t.PO_Description,t.PO_Help,t.PO_Name,t.PO_PrintName,t.PrintName, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_ELEMENT t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Element_ID=53325 AND EXISTS (SELECT * FROM AD_ELEMENT_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Element_ID!=t.AD_Element_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54095,53325,0,20,112,'IsUseASP',TO_TIMESTAMP('2008-01-09 23:29:56','YYYY-MM-DD HH24:MI:SS'),100,'N','D',1,'Y','N','N','N','N','Y','N','N','Y','N','Y','IsUseASP',TO_TIMESTAMP('2008-01-09 23:29:56','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54095 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

ALTER TABLE AD_CLIENT ADD COLUMN IsUseASP CHAR(1) DEFAULT 'N' CHECK (IsUseASP IN ('Y','N')) NOT NULL
;


INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,DisplayLogic,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54095,54238,0,145,TO_TIMESTAMP('2008-01-09 23:30:04','YYYY-MM-DD HH24:MI:SS'),100,1,'@AD_Client_ID@>0','D','Y','Y','Y','N','N','N','N','IsUseASP',280,0,TO_TIMESTAMP('2008-01-09 23:30:04','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54238 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_WINDOW (AD_Client_ID,AD_Org_ID,AD_Window_ID,Created,CreatedBy,EntityType,IsActive,IsBetaFunctionality,IsDefault,IsSOTrx,NAME,Processing,Updated,UpdatedBy,WindowType) VALUES (0,0,53015,TO_TIMESTAMP('2008-01-09 23:30:05','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','Y','N','Y','ASP Modules','N',TO_TIMESTAMP('2008-01-09 23:30:05','YYYY-MM-DD HH24:MI:SS'),100,'M')
;

INSERT INTO AD_WINDOW_TRL (AD_LANGUAGE,AD_Window_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Window_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_WINDOW t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Window_ID=53015 AND EXISTS (SELECT * FROM AD_WINDOW_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Window_ID!=t.AD_Window_ID)
;

INSERT INTO AD_WINDOW_ACCESS (AD_Client_ID,AD_Org_ID,AD_Role_ID,AD_Window_ID,Created,CreatedBy,IsActive,Updated,UpdatedBy) VALUES (0,0,0,53015,TO_TIMESTAMP('2008-01-09 23:30:06','YYYY-MM-DD HH24:MI:SS'),100,'Y',TO_TIMESTAMP('2008-01-09 23:30:06','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_WINDOW_ACCESS (AD_Client_ID,AD_Org_ID,AD_Role_ID,AD_Window_ID,Created,CreatedBy,IsActive,Updated,UpdatedBy) VALUES (0,0,102,53015,TO_TIMESTAMP('2008-01-09 23:30:06','YYYY-MM-DD HH24:MI:SS'),100,'Y',TO_TIMESTAMP('2008-01-09 23:30:06','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_WINDOW_ACCESS (AD_Client_ID,AD_Org_ID,AD_Role_ID,AD_Window_ID,Created,CreatedBy,IsActive,Updated,UpdatedBy) VALUES (0,0,103,53015,TO_TIMESTAMP('2008-01-09 23:30:06','YYYY-MM-DD HH24:MI:SS'),100,'Y',TO_TIMESTAMP('2008-01-09 23:30:06','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_WINDOW_ACCESS (AD_Client_ID,AD_Org_ID,AD_Role_ID,AD_Window_ID,Created,CreatedBy,IsActive,Updated,UpdatedBy) VALUES (0,0,50001,53015,TO_TIMESTAMP('2008-01-09 23:30:06','YYYY-MM-DD HH24:MI:SS'),100,'Y',TO_TIMESTAMP('2008-01-09 23:30:06','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TABLE (AD_Client_ID,AD_Org_ID,AD_Table_ID,AccessLevel,Created,CreatedBy,EntityType,ImportTable,IsActive,IsChangeLog,IsDeleteable,IsHighVolume,IsSecurityEnabled,IsView,NAME,ReplicationType,TableName,Updated,UpdatedBy) VALUES (0,0,53046,'4',TO_TIMESTAMP('2008-01-09 23:30:06','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','Y','N','N','N','ASP Window','L','ASP_Window',TO_TIMESTAMP('2008-01-09 23:30:06','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TABLE_TRL (AD_LANGUAGE,AD_Table_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Table_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TABLE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Table_ID=53046 AND EXISTS (SELECT * FROM AD_TABLE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Table_ID!=t.AD_Table_ID)
;

INSERT INTO AD_SEQUENCE (AD_Client_ID,AD_Org_ID,AD_Sequence_ID,Created,CreatedBy,CurrentNext,CurrentNextSys,Description,IncrementNo,IsActive,IsAudited,IsAutoSequence,IsTableID,NAME,StartNewYear,StartNo,Updated,UpdatedBy) VALUES (0,0,53063,TO_TIMESTAMP('2008-01-09 23:30:07','YYYY-MM-DD HH24:MI:SS'),100,1000000,50000,'Table ASP_Window',1,'Y','N','Y','Y','ASP_Window','N',1000000,TO_TIMESTAMP('2008-01-09 23:30:07','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54096,102,0,19,53046,'AD_Client_ID',TO_TIMESTAMP('2008-01-09 23:30:17','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Client_ID@','Client/Tenant for this installation.','D',22,'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','N','N','N','N','Y','N','N','N','N','N','Client',TO_TIMESTAMP('2008-01-09 23:30:17','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54096 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54097,113,0,19,53046,104,'AD_Org_ID',TO_TIMESTAMP('2008-01-09 23:30:21','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Org_ID@','Organizational entity within client','D',22,'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','N','N','N','N','Y','N','N','N','N','N','Organization',TO_TIMESTAMP('2008-01-09 23:30:21','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54097 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54098,143,0,19,53046,'AD_Window_ID',TO_TIMESTAMP('2008-01-09 23:30:22','YYYY-MM-DD HH24:MI:SS'),100,'Data entry or display window','D',22,'The Window field identifies a unique Window in the system.','Y','N','N','N','N','Y','Y','N','N','N','N','Window',TO_TIMESTAMP('2008-01-09 23:30:22','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54098 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_ELEMENT (AD_Client_ID,AD_Element_ID,AD_Org_ID,ColumnName,Created,CreatedBy,EntityType,IsActive,NAME,PrintName,Updated,UpdatedBy) VALUES (0,53326,0,'ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:30:22','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','ASP_Level_ID','ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:30:22','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_ELEMENT_TRL (AD_LANGUAGE,AD_Element_ID, Description,Help,NAME,PO_Description,PO_Help,PO_Name,PO_PrintName,PrintName, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Element_ID, t.Description,t.Help,t.NAME,t.PO_Description,t.PO_Help,t.PO_Name,t.PO_PrintName,t.PrintName, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_ELEMENT t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Element_ID=53326 AND EXISTS (SELECT * FROM AD_ELEMENT_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Element_ID!=t.AD_Element_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54099,53326,0,19,53046,'ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:30:22','YYYY-MM-DD HH24:MI:SS'),100,'D',22,'Y','N','N','N','N','Y','Y','N','N','N','N','ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:30:22','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54099 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54100,608,0,18,110,53046,'UpdatedBy',TO_TIMESTAMP('2008-01-09 23:30:25','YYYY-MM-DD HH24:MI:SS'),100,'User who updated this records','D',22,'The Updated By field indicates the user who updated this record.','Y','N','N','N','N','Y','N','N','N','N','N','Updated By',TO_TIMESTAMP('2008-01-09 23:30:25','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54100 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54101,245,0,16,53046,'Created',TO_TIMESTAMP('2008-01-09 23:30:28','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was created','D',7,'The Created field indicates the date that this record was created.','Y','N','N','N','N','Y','N','N','N','N','N','Created',TO_TIMESTAMP('2008-01-09 23:30:28','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54101 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54102,246,0,18,110,53046,'CreatedBy',TO_TIMESTAMP('2008-01-09 23:30:29','YYYY-MM-DD HH24:MI:SS'),100,'User who created this records','D',22,'The Created By field indicates the user who created this record.','Y','N','N','N','N','Y','N','N','N','N','N','Created By',TO_TIMESTAMP('2008-01-09 23:30:29','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54102 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54103,348,0,20,53046,'IsActive',TO_TIMESTAMP('2008-01-09 23:30:33','YYYY-MM-DD HH24:MI:SS'),100,'Y','The record is active in the system','D',1,'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','N','N','N','N','Y','N','N','N','N','Y','Active',TO_TIMESTAMP('2008-01-09 23:30:33','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54103 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54104,607,0,16,53046,'Updated',TO_TIMESTAMP('2008-01-09 23:30:35','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was updated','D',7,'The Updated field indicates the date that this record was updated.','Y','N','N','N','N','Y','N','N','N','N','N','Updated',TO_TIMESTAMP('2008-01-09 23:30:35','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54104 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_REFERENCE (AD_Client_ID,AD_Org_ID,AD_Reference_ID,Created,CreatedBy,EntityType,IsActive,NAME,Updated,UpdatedBy,ValidationType) VALUES (0,0,53234,TO_TIMESTAMP('2008-01-09 23:30:36','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','ASP_Status',TO_TIMESTAMP('2008-01-09 23:30:36','YYYY-MM-DD HH24:MI:SS'),100,'L')
;

INSERT INTO AD_REFERENCE_TRL (AD_LANGUAGE,AD_Reference_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Reference_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_REFERENCE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Reference_ID=53234 AND EXISTS (SELECT * FROM AD_REFERENCE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Reference_ID!=t.AD_Reference_ID)
;

INSERT INTO AD_REF_LIST (AD_Client_ID,AD_Org_ID,AD_Ref_List_ID,AD_Reference_ID,Created,CreatedBy,EntityType,IsActive,NAME,Updated,UpdatedBy,VALUE) VALUES (0,0,53284,53234,TO_TIMESTAMP('2008-01-09 23:30:37','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','Hide',TO_TIMESTAMP('2008-01-09 23:30:37','YYYY-MM-DD HH24:MI:SS'),100,'H')
;

INSERT INTO AD_REF_LIST_TRL (AD_LANGUAGE,AD_Ref_List_ID, Description,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Ref_List_ID, t.Description,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_REF_LIST t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Ref_List_ID=53284 AND EXISTS (SELECT * FROM AD_REF_LIST_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Ref_List_ID!=t.AD_Ref_List_ID)
;

INSERT INTO AD_REF_LIST (AD_Client_ID,AD_Org_ID,AD_Ref_List_ID,AD_Reference_ID,Created,CreatedBy,EntityType,IsActive,NAME,Updated,UpdatedBy,VALUE) VALUES (0,0,53285,53234,TO_TIMESTAMP('2008-01-09 23:30:38','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','Show',TO_TIMESTAMP('2008-01-09 23:30:38','YYYY-MM-DD HH24:MI:SS'),100,'S')
;

INSERT INTO AD_REF_LIST_TRL (AD_LANGUAGE,AD_Ref_List_ID, Description,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Ref_List_ID, t.Description,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_REF_LIST t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Ref_List_ID=53285 AND EXISTS (SELECT * FROM AD_REF_LIST_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Ref_List_ID!=t.AD_Ref_List_ID)
;

INSERT INTO AD_REF_LIST (AD_Client_ID,AD_Org_ID,AD_Ref_List_ID,AD_Reference_ID,Created,CreatedBy,EntityType,IsActive,NAME,Updated,UpdatedBy,VALUE) VALUES (0,0,53286,53234,TO_TIMESTAMP('2008-01-09 23:30:39','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','Undefined',TO_TIMESTAMP('2008-01-09 23:30:39','YYYY-MM-DD HH24:MI:SS'),100,'U')
;

INSERT INTO AD_REF_LIST_TRL (AD_LANGUAGE,AD_Ref_List_ID, Description,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Ref_List_ID, t.Description,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_REF_LIST t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Ref_List_ID=53286 AND EXISTS (SELECT * FROM AD_REF_LIST_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Ref_List_ID!=t.AD_Ref_List_ID)
;

INSERT INTO AD_ELEMENT (AD_Client_ID,AD_Element_ID,AD_Org_ID,ColumnName,Created,CreatedBy,EntityType,IsActive,NAME,PrintName,Updated,UpdatedBy) VALUES (0,53327,0,'ASP_Status',TO_TIMESTAMP('2008-01-09 23:30:42','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','ASP_Status','ASP_Status',TO_TIMESTAMP('2008-01-09 23:30:42','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_ELEMENT_TRL (AD_LANGUAGE,AD_Element_ID, Description,Help,NAME,PO_Description,PO_Help,PO_Name,PO_PrintName,PrintName, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Element_ID, t.Description,t.Help,t.NAME,t.PO_Description,t.PO_Help,t.PO_Name,t.PO_PrintName,t.PrintName, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_ELEMENT t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Element_ID=53327 AND EXISTS (SELECT * FROM AD_ELEMENT_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Element_ID!=t.AD_Element_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54105,53327,0,17,53234,53046,'ASP_Status',TO_TIMESTAMP('2008-01-09 23:30:42','YYYY-MM-DD HH24:MI:SS'),100,'U','D',1,'Y','N','N','N','N','Y','N','N','N','N','Y','ASP_Status',TO_TIMESTAMP('2008-01-09 23:30:42','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54105 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_TAB (AD_Client_ID,AD_Org_ID,AD_Tab_ID,AD_Table_ID,AD_Window_ID,CommitWarning,Created,CreatedBy,EntityType,HasTree,IsActive,IsAdvancedTab,IsInfoTab,IsInsertRecord,IsReadOnly,IsSingleRow,IsSortTab,IsTranslationTab,NAME,Processing,SeqNo,TabLevel,Updated,UpdatedBy) VALUES (0,0,53056,53046,53015,NULL,TO_TIMESTAMP('2008-01-09 23:30:46','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','N','Y','N','N','N','N','Window','N',40,2,TO_TIMESTAMP('2008-01-09 23:30:46','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TAB_TRL (AD_LANGUAGE,AD_Tab_ID, CommitWarning,Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Tab_ID, t.CommitWarning,t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TAB t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Tab_ID=53056 AND EXISTS (SELECT * FROM AD_TAB_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Tab_ID!=t.AD_Tab_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54096,54239,0,53056,TO_TIMESTAMP('2008-01-09 23:30:50','YYYY-MM-DD HH24:MI:SS'),100,'Client/Tenant for this installation.',22,'D','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','Y','Y','N','N','N','N','Client',10,0,TO_TIMESTAMP('2008-01-09 23:30:50','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54239 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54097,54240,0,53056,TO_TIMESTAMP('2008-01-09 23:30:54','YYYY-MM-DD HH24:MI:SS'),100,'Organizational entity within client',22,'D','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','Y','Y','N','N','N','Y','Organization',20,0,TO_TIMESTAMP('2008-01-09 23:30:54','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54240 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54099,54241,0,53056,TO_TIMESTAMP('2008-01-09 23:30:56','YYYY-MM-DD HH24:MI:SS'),100,22,'D','Y','Y','Y','N','N','N','N','ASP_Level_ID',30,0,TO_TIMESTAMP('2008-01-09 23:30:56','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54241 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54098,54242,0,53056,TO_TIMESTAMP('2008-01-09 23:30:56','YYYY-MM-DD HH24:MI:SS'),100,'Data entry or display window',22,'D','The Window field identifies a unique Window in the system.','Y','Y','Y','N','N','N','N','Window',40,0,TO_TIMESTAMP('2008-01-09 23:30:56','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54242 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54105,54243,0,53056,TO_TIMESTAMP('2008-01-09 23:31:00','YYYY-MM-DD HH24:MI:SS'),100,1,'D','Y','Y','Y','N','N','N','N','ASP_Status',50,0,TO_TIMESTAMP('2008-01-09 23:31:00','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54243 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54103,54244,0,53056,TO_TIMESTAMP('2008-01-09 23:31:01','YYYY-MM-DD HH24:MI:SS'),100,'The record is active in the system',1,'D','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','Y','Y','N','N','N','N','Active',60,0,TO_TIMESTAMP('2008-01-09 23:31:01','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54244 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_TABLE (AD_Client_ID,AD_Org_ID,AD_Table_ID,AccessLevel,Created,CreatedBy,EntityType,ImportTable,IsActive,IsChangeLog,IsDeleteable,IsHighVolume,IsSecurityEnabled,IsView,NAME,ReplicationType,TableName,Updated,UpdatedBy) VALUES (0,0,53047,'4',TO_TIMESTAMP('2008-01-09 23:31:05','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','Y','N','N','N','ASP Tab','L','ASP_Tab',TO_TIMESTAMP('2008-01-09 23:31:05','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TABLE_TRL (AD_LANGUAGE,AD_Table_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Table_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TABLE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Table_ID=53047 AND EXISTS (SELECT * FROM AD_TABLE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Table_ID!=t.AD_Table_ID)
;

INSERT INTO AD_SEQUENCE (AD_Client_ID,AD_Org_ID,AD_Sequence_ID,Created,CreatedBy,CurrentNext,CurrentNextSys,Description,IncrementNo,IsActive,IsAudited,IsAutoSequence,IsTableID,NAME,StartNewYear,StartNo,Updated,UpdatedBy) VALUES (0,0,53064,TO_TIMESTAMP('2008-01-09 23:31:06','YYYY-MM-DD HH24:MI:SS'),100,1000000,50000,'Table ASP_Tab',1,'Y','N','Y','Y','ASP_Tab','N',1000000,TO_TIMESTAMP('2008-01-09 23:31:06','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54106,102,0,19,53047,'AD_Client_ID',TO_TIMESTAMP('2008-01-09 23:31:07','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Client_ID@','Client/Tenant for this installation.','D',22,'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','N','N','N','N','Y','N','N','N','N','N','Client',TO_TIMESTAMP('2008-01-09 23:31:07','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54106 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54107,113,0,19,53047,104,'AD_Org_ID',TO_TIMESTAMP('2008-01-09 23:31:11','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Org_ID@','Organizational entity within client','D',22,'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','N','N','N','N','Y','N','N','N','N','N','Organization',TO_TIMESTAMP('2008-01-09 23:31:11','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54107 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54108,125,0,19,53047,163,'AD_Tab_ID',TO_TIMESTAMP('2008-01-09 23:31:12','YYYY-MM-DD HH24:MI:SS'),100,'Tab within a Window','D',22,'The Tab indicates a tab that displays within a window.','Y','N','N','N','N','Y','Y','N','N','N','N','Tab',TO_TIMESTAMP('2008-01-09 23:31:12','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54108 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54109,143,0,19,53047,'AD_Window_ID',TO_TIMESTAMP('2008-01-09 23:31:13','YYYY-MM-DD HH24:MI:SS'),100,'Data entry or display window','D',22,'The Window field identifies a unique Window in the system.','Y','N','N','N','N','Y','Y','N','N','N','N','Window',TO_TIMESTAMP('2008-01-09 23:31:13','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54109 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54110,53326,0,19,53047,'ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:31:14','YYYY-MM-DD HH24:MI:SS'),100,'D',22,'Y','N','N','N','N','Y','Y','N','N','N','N','ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:31:14','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54110 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54111,53327,0,17,53234,53047,'ASP_Status',TO_TIMESTAMP('2008-01-09 23:31:16','YYYY-MM-DD HH24:MI:SS'),100,'U','D',1,'Y','N','N','N','N','Y','N','N','N','N','Y','ASP_Status',TO_TIMESTAMP('2008-01-09 23:31:16','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54111 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54112,608,0,18,110,53047,'UpdatedBy',TO_TIMESTAMP('2008-01-09 23:31:20','YYYY-MM-DD HH24:MI:SS'),100,'User who updated this records','D',22,'The Updated By field indicates the user who updated this record.','Y','N','N','N','N','Y','N','N','N','N','N','Updated By',TO_TIMESTAMP('2008-01-09 23:31:20','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54112 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54113,245,0,16,53047,'Created',TO_TIMESTAMP('2008-01-09 23:31:21','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was created','D',7,'The Created field indicates the date that this record was created.','Y','N','N','N','N','Y','N','N','N','N','N','Created',TO_TIMESTAMP('2008-01-09 23:31:21','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54113 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54114,246,0,18,110,53047,'CreatedBy',TO_TIMESTAMP('2008-01-09 23:31:25','YYYY-MM-DD HH24:MI:SS'),100,'User who created this records','D',22,'The Created By field indicates the user who created this record.','Y','N','N','N','N','Y','N','N','N','N','N','Created By',TO_TIMESTAMP('2008-01-09 23:31:25','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54114 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54115,348,0,20,53047,'IsActive',TO_TIMESTAMP('2008-01-09 23:31:26','YYYY-MM-DD HH24:MI:SS'),100,'Y','The record is active in the system','D',1,'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','N','N','N','N','Y','N','N','N','N','Y','Active',TO_TIMESTAMP('2008-01-09 23:31:26','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54115 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_PROCESS (AD_Client_ID,AD_Org_ID,AD_Process_ID,AccessLevel,Classname,Created,CreatedBy,EntityType,IsActive,IsBetaFunctionality,IsDirectPrint,IsReport,NAME,ShowHelp,Statistic_Count,Statistic_Seconds,Updated,UpdatedBy,VALUE,WorkflowValue) VALUES (0,0,53065,'4','org.adempiere.process.ASPGenerateFields',TO_TIMESTAMP('2008-01-09 23:31:27','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','N','N','N','ASP Generate Fields','Y',0,0,TO_TIMESTAMP('2008-01-09 23:31:27','YYYY-MM-DD HH24:MI:SS'),100,'ASP Generate Fields',NULL)
;

INSERT INTO AD_PROCESS_TRL (AD_LANGUAGE,AD_Process_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Process_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_PROCESS t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_ID=53065 AND EXISTS (SELECT * FROM AD_PROCESS_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Process_ID!=t.AD_Process_ID)
;

INSERT INTO AD_PROCESS_PARA (AD_Client_ID,AD_Element_ID,AD_Org_ID,AD_Process_ID,AD_Process_Para_ID,AD_Reference_ID,AD_Reference_Value_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsCentrallyMaintained,IsMandatory,IsRange,NAME,SeqNo,Updated,UpdatedBy) VALUES (0,53327,0,53065,53125,17,53234,'ASP_Status',TO_TIMESTAMP('2008-01-09 23:31:32','YYYY-MM-DD HH24:MI:SS'),100,'U','D',0,'Y','Y','Y','N','ASP Status',10,TO_TIMESTAMP('2008-01-09 23:31:32','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_PROCESS_PARA_TRL (AD_LANGUAGE,AD_Process_Para_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Process_Para_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_PROCESS_PARA t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_Para_ID=53125 AND EXISTS (SELECT * FROM AD_PROCESS_PARA_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Process_Para_ID!=t.AD_Process_Para_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Process_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54116,524,0,53065,28,53047,'Processing',TO_TIMESTAMP('2008-01-09 23:31:33','YYYY-MM-DD HH24:MI:SS'),100,'D',1,'Y','N','N','N','N','N','N','N','N','N','Y','Process Now',TO_TIMESTAMP('2008-01-09 23:31:33','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54116 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54117,607,0,16,53047,'Updated',TO_TIMESTAMP('2008-01-09 23:31:33','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was updated','D',7,'The Updated field indicates the date that this record was updated.','Y','N','N','N','N','Y','N','N','N','N','N','Updated',TO_TIMESTAMP('2008-01-09 23:31:33','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54117 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_ELEMENT (AD_Client_ID,AD_Element_ID,AD_Org_ID,ColumnName,Created,CreatedBy,EntityType,IsActive,NAME,PrintName,Updated,UpdatedBy) VALUES (0,53328,0,'AllFields',TO_TIMESTAMP('2008-01-09 23:31:34','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','AllFields','AllFields',TO_TIMESTAMP('2008-01-09 23:31:34','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_ELEMENT_TRL (AD_LANGUAGE,AD_Element_ID, Description,Help,NAME,PO_Description,PO_Help,PO_Name,PO_PrintName,PrintName, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Element_ID, t.Description,t.Help,t.NAME,t.PO_Description,t.PO_Help,t.PO_Name,t.PO_PrintName,t.PrintName, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_ELEMENT t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Element_ID=53328 AND EXISTS (SELECT * FROM AD_ELEMENT_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Element_ID!=t.AD_Element_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54118,53328,0,20,53047,'AllFields',TO_TIMESTAMP('2008-01-09 23:31:34','YYYY-MM-DD HH24:MI:SS'),100,'Y','D',1,'Y','N','N','N','N','N','N','N','N','N','Y','AllFields',TO_TIMESTAMP('2008-01-09 23:31:34','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54118 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_TAB (AD_Client_ID,AD_Org_ID,AD_Tab_ID,AD_Table_ID,AD_Window_ID,CommitWarning,Created,CreatedBy,EntityType,HasTree,IsActive,IsAdvancedTab,IsInfoTab,IsInsertRecord,IsReadOnly,IsSingleRow,IsSortTab,IsTranslationTab,NAME,Processing,SeqNo,TabLevel,Updated,UpdatedBy) VALUES (0,0,53057,53047,53015,NULL,TO_TIMESTAMP('2008-01-09 23:31:39','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','N','Y','N','N','N','N','Tab','N',50,3,TO_TIMESTAMP('2008-01-09 23:31:39','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TAB_TRL (AD_LANGUAGE,AD_Tab_ID, CommitWarning,Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Tab_ID, t.CommitWarning,t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TAB t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Tab_ID=53057 AND EXISTS (SELECT * FROM AD_TAB_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Tab_ID!=t.AD_Tab_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54106,54245,0,53057,TO_TIMESTAMP('2008-01-09 23:31:40','YYYY-MM-DD HH24:MI:SS'),100,'Client/Tenant for this installation.',22,'D','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','Y','Y','N','N','N','N','Client',10,0,TO_TIMESTAMP('2008-01-09 23:31:40','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54245 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54107,54246,0,53057,TO_TIMESTAMP('2008-01-09 23:31:40','YYYY-MM-DD HH24:MI:SS'),100,'Organizational entity within client',22,'D','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','Y','Y','N','N','N','Y','Organization',20,0,TO_TIMESTAMP('2008-01-09 23:31:40','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54246 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54110,54247,0,53057,TO_TIMESTAMP('2008-01-09 23:31:41','YYYY-MM-DD HH24:MI:SS'),100,22,'D','Y','Y','Y','N','N','Y','N','ASP_Level_ID',30,0,TO_TIMESTAMP('2008-01-09 23:31:41','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54247 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54109,54248,0,53057,TO_TIMESTAMP('2008-01-09 23:31:42','YYYY-MM-DD HH24:MI:SS'),100,'Data entry or display window',22,'D','The Window field identifies a unique Window in the system.','Y','Y','Y','N','N','Y','N','Window',40,0,TO_TIMESTAMP('2008-01-09 23:31:42','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54248 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54108,54249,0,53057,TO_TIMESTAMP('2008-01-09 23:31:43','YYYY-MM-DD HH24:MI:SS'),100,'Tab within a Window',22,'D','The Tab indicates a tab that displays within a window.','Y','Y','Y','N','N','N','N','Tab',50,0,TO_TIMESTAMP('2008-01-09 23:31:43','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54249 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54111,54250,0,53057,TO_TIMESTAMP('2008-01-09 23:31:44','YYYY-MM-DD HH24:MI:SS'),100,1,'D','Y','Y','Y','N','N','N','N','ASP_Status',60,0,TO_TIMESTAMP('2008-01-09 23:31:44','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54250 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54118,54251,0,53057,TO_TIMESTAMP('2008-01-09 23:31:45','YYYY-MM-DD HH24:MI:SS'),100,1,'D','Y','Y','Y','N','N','N','N','AllFields',70,0,TO_TIMESTAMP('2008-01-09 23:31:45','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54251 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,DisplayLogic,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54116,54252,0,53057,TO_TIMESTAMP('2008-01-09 23:31:46','YYYY-MM-DD HH24:MI:SS'),100,1,'@AllFields@=N','D','Y','Y','Y','N','N','N','N','Process Now',80,0,TO_TIMESTAMP('2008-01-09 23:31:46','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54252 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54115,54253,0,53057,TO_TIMESTAMP('2008-01-09 23:31:46','YYYY-MM-DD HH24:MI:SS'),100,'The record is active in the system',1,'D','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','Y','Y','N','N','N','N','Active',90,0,TO_TIMESTAMP('2008-01-09 23:31:46','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54253 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_TABLE (AD_Client_ID,AD_Org_ID,AD_Table_ID,AccessLevel,Created,CreatedBy,EntityType,ImportTable,IsActive,IsChangeLog,IsDeleteable,IsHighVolume,IsSecurityEnabled,IsView,NAME,ReplicationType,TableName,Updated,UpdatedBy) VALUES (0,0,53048,'4',TO_TIMESTAMP('2008-01-09 23:31:48','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','Y','N','N','N','ASP Field','L','ASP_Field',TO_TIMESTAMP('2008-01-09 23:31:48','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TABLE_TRL (AD_LANGUAGE,AD_Table_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Table_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TABLE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Table_ID=53048 AND EXISTS (SELECT * FROM AD_TABLE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Table_ID!=t.AD_Table_ID)
;

INSERT INTO AD_SEQUENCE (AD_Client_ID,AD_Org_ID,AD_Sequence_ID,Created,CreatedBy,CurrentNext,CurrentNextSys,Description,IncrementNo,IsActive,IsAudited,IsAutoSequence,IsTableID,NAME,StartNewYear,StartNo,Updated,UpdatedBy) VALUES (0,0,53065,TO_TIMESTAMP('2008-01-09 23:31:48','YYYY-MM-DD HH24:MI:SS'),100,1000000,50000,'Table ASP_Field',1,'Y','N','Y','Y','ASP_Field','N',1000000,TO_TIMESTAMP('2008-01-09 23:31:48','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54119,102,0,19,53048,'AD_Client_ID',TO_TIMESTAMP('2008-01-09 23:31:50','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Client_ID@','Client/Tenant for this installation.','D',22,'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','N','N','N','N','Y','N','N','N','N','N','Client',TO_TIMESTAMP('2008-01-09 23:31:50','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54119 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_VAL_RULE (AD_Client_ID,AD_Org_ID,AD_Val_Rule_ID,Code,Created,CreatedBy,EntityType,IsActive,NAME,TYPE,Updated,UpdatedBy) VALUES (0,0,52005,'AD_Field.AD_Tab_ID=@AD_Tab_ID@',TO_TIMESTAMP('2008-01-09 23:31:50','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','AD_Field in Tab','S',TO_TIMESTAMP('2008-01-09 23:31:50','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54120,107,0,19,53048,52005,'AD_Field_ID',TO_TIMESTAMP('2008-01-09 23:31:51','YYYY-MM-DD HH24:MI:SS'),100,'Field on a database table','D',22,'The Field identifies a field on a database table.','Y','N','N','N','N','N','Y','N','N','N','N','Field',TO_TIMESTAMP('2008-01-09 23:31:51','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54120 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54121,113,0,19,53048,104,'AD_Org_ID',TO_TIMESTAMP('2008-01-09 23:31:52','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Org_ID@','Organizational entity within client','D',22,'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','N','N','N','N','Y','N','N','N','N','N','Organization',TO_TIMESTAMP('2008-01-09 23:31:52','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54121 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54122,125,0,19,53048,163,'AD_Tab_ID',TO_TIMESTAMP('2008-01-09 23:31:53','YYYY-MM-DD HH24:MI:SS'),100,'Tab within a Window','D',22,'The Tab indicates a tab that displays within a window.','Y','N','N','N','N','Y','Y','N','N','N','N','Tab',TO_TIMESTAMP('2008-01-09 23:31:53','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54122 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54123,53326,0,19,53048,'ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:31:54','YYYY-MM-DD HH24:MI:SS'),100,'D',22,'Y','N','N','N','N','Y','Y','N','N','N','N','ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:31:54','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54123 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54124,608,0,18,110,53048,'UpdatedBy',TO_TIMESTAMP('2008-01-09 23:31:55','YYYY-MM-DD HH24:MI:SS'),100,'User who updated this records','D',22,'The Updated By field indicates the user who updated this record.','Y','N','N','N','N','Y','N','N','N','N','N','Updated By',TO_TIMESTAMP('2008-01-09 23:31:55','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54124 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54125,245,0,16,53048,'Created',TO_TIMESTAMP('2008-01-09 23:32:00','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was created','D',7,'The Created field indicates the date that this record was created.','Y','N','N','N','N','Y','N','N','N','N','N','Created',TO_TIMESTAMP('2008-01-09 23:32:00','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54125 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54126,246,0,18,110,53048,'CreatedBy',TO_TIMESTAMP('2008-01-09 23:32:00','YYYY-MM-DD HH24:MI:SS'),100,'User who created this records','D',22,'The Created By field indicates the user who created this record.','Y','N','N','N','N','Y','N','N','N','N','N','Created By',TO_TIMESTAMP('2008-01-09 23:32:00','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54126 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54127,348,0,20,53048,'IsActive',TO_TIMESTAMP('2008-01-09 23:32:01','YYYY-MM-DD HH24:MI:SS'),100,'Y','The record is active in the system','D',1,'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','N','N','N','N','Y','N','N','N','N','Y','Active',TO_TIMESTAMP('2008-01-09 23:32:01','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54127 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54128,607,0,16,53048,'Updated',TO_TIMESTAMP('2008-01-09 23:32:02','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was updated','D',7,'The Updated field indicates the date that this record was updated.','Y','N','N','N','N','Y','N','N','N','N','N','Updated',TO_TIMESTAMP('2008-01-09 23:32:02','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54128 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54129,53327,0,17,53234,53048,'ASP_Status',TO_TIMESTAMP('2008-01-09 23:32:03','YYYY-MM-DD HH24:MI:SS'),100,'U','D',1,'Y','N','N','N','N','Y','N','N','N','N','Y','ASP_Status',TO_TIMESTAMP('2008-01-09 23:32:03','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54129 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_TAB (AD_Client_ID,AD_Org_ID,AD_Tab_ID,AD_Table_ID,AD_Window_ID,CommitWarning,Created,CreatedBy,DisplayLogic,EntityType,HasTree,IsActive,IsAdvancedTab,IsInfoTab,IsInsertRecord,IsReadOnly,IsSingleRow,IsSortTab,IsTranslationTab,NAME,Processing,SeqNo,TabLevel,Updated,UpdatedBy) VALUES (0,0,53058,53048,53015,NULL,TO_TIMESTAMP('2008-01-09 23:32:03','YYYY-MM-DD HH24:MI:SS'),100,'@AllFields@=N','D','N','Y','N','N','Y','N','N','N','N','Field','N',60,4,TO_TIMESTAMP('2008-01-09 23:32:03','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TAB_TRL (AD_LANGUAGE,AD_Tab_ID, CommitWarning,Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Tab_ID, t.CommitWarning,t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TAB t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Tab_ID=53058 AND EXISTS (SELECT * FROM AD_TAB_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Tab_ID!=t.AD_Tab_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54119,54254,0,53058,TO_TIMESTAMP('2008-01-09 23:32:10','YYYY-MM-DD HH24:MI:SS'),100,'Client/Tenant for this installation.',22,'D','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','Y','Y','N','N','N','N','Client',10,0,TO_TIMESTAMP('2008-01-09 23:32:10','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54254 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54121,54255,0,53058,TO_TIMESTAMP('2008-01-09 23:32:11','YYYY-MM-DD HH24:MI:SS'),100,'Organizational entity within client',22,'D','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','Y','Y','N','N','N','Y','Organization',20,0,TO_TIMESTAMP('2008-01-09 23:32:11','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54255 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54123,54256,0,53058,TO_TIMESTAMP('2008-01-09 23:32:12','YYYY-MM-DD HH24:MI:SS'),100,22,'D','Y','Y','Y','N','N','N','N','ASP_Level_ID',30,0,TO_TIMESTAMP('2008-01-09 23:32:12','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54256 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54122,54257,0,53058,TO_TIMESTAMP('2008-01-09 23:32:16','YYYY-MM-DD HH24:MI:SS'),100,'Tab within a Window',22,'D','The Tab indicates a tab that displays within a window.','Y','Y','Y','N','N','N','N','Tab',40,0,TO_TIMESTAMP('2008-01-09 23:32:16','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54257 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54120,54258,0,53058,TO_TIMESTAMP('2008-01-09 23:32:17','YYYY-MM-DD HH24:MI:SS'),100,'Field on a database table',22,'D','The Field identifies a field on a database table.','Y','Y','Y','N','N','N','N','Field',50,0,TO_TIMESTAMP('2008-01-09 23:32:17','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54258 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54129,54259,0,53058,TO_TIMESTAMP('2008-01-09 23:32:18','YYYY-MM-DD HH24:MI:SS'),100,1,'D','Y','Y','Y','N','N','N','N','ASP_Status',60,0,TO_TIMESTAMP('2008-01-09 23:32:18','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54259 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54127,54260,0,53058,TO_TIMESTAMP('2008-01-09 23:32:18','YYYY-MM-DD HH24:MI:SS'),100,'The record is active in the system',1,'D','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','Y','Y','N','N','N','N','Active',70,0,TO_TIMESTAMP('2008-01-09 23:32:18','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54260 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_TABLE (AD_Client_ID,AD_Org_ID,AD_Table_ID,AccessLevel,Created,CreatedBy,EntityType,ImportTable,IsActive,IsChangeLog,IsDeleteable,IsHighVolume,IsSecurityEnabled,IsView,NAME,ReplicationType,TableName,Updated,UpdatedBy) VALUES (0,0,53049,'4',TO_TIMESTAMP('2008-01-09 23:32:22','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','Y','N','N','N','ASP Process','L','ASP_Process',TO_TIMESTAMP('2008-01-09 23:32:22','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TABLE_TRL (AD_LANGUAGE,AD_Table_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Table_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TABLE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Table_ID=53049 AND EXISTS (SELECT * FROM AD_TABLE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Table_ID!=t.AD_Table_ID)
;

INSERT INTO AD_SEQUENCE (AD_Client_ID,AD_Org_ID,AD_Sequence_ID,Created,CreatedBy,CurrentNext,CurrentNextSys,Description,IncrementNo,IsActive,IsAudited,IsAutoSequence,IsTableID,NAME,StartNewYear,StartNo,Updated,UpdatedBy) VALUES (0,0,53066,TO_TIMESTAMP('2008-01-09 23:32:23','YYYY-MM-DD HH24:MI:SS'),100,1000000,50000,'Table ASP_Process',1,'Y','N','Y','Y','ASP_Process','N',1000000,TO_TIMESTAMP('2008-01-09 23:32:23','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54130,102,0,19,53049,'AD_Client_ID',TO_TIMESTAMP('2008-01-09 23:32:24','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Client_ID@','Client/Tenant for this installation.','D',22,'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','N','N','N','N','Y','N','N','N','N','N','Client',TO_TIMESTAMP('2008-01-09 23:32:24','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54130 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54131,113,0,19,53049,104,'AD_Org_ID',TO_TIMESTAMP('2008-01-09 23:32:28','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Org_ID@','Organizational entity within client','D',22,'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','N','N','N','N','Y','N','N','N','N','N','Organization',TO_TIMESTAMP('2008-01-09 23:32:28','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54131 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54132,117,0,19,53049,'AD_Process_ID',TO_TIMESTAMP('2008-01-09 23:32:32','YYYY-MM-DD HH24:MI:SS'),100,'Process or Report','D',22,'The Process field identifies a unique Process or Report in the system.','Y','N','N','N','N','Y','Y','N','N','N','N','Process',TO_TIMESTAMP('2008-01-09 23:32:32','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54132 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54133,53326,0,19,53049,'ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:32:32','YYYY-MM-DD HH24:MI:SS'),100,'D',22,'Y','N','N','N','N','Y','Y','N','N','N','N','ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:32:32','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54133 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54134,608,0,18,110,53049,'UpdatedBy',TO_TIMESTAMP('2008-01-09 23:32:33','YYYY-MM-DD HH24:MI:SS'),100,'User who updated this records','D',22,'The Updated By field indicates the user who updated this record.','Y','N','N','N','N','Y','N','N','N','N','N','Updated By',TO_TIMESTAMP('2008-01-09 23:32:33','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54134 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54135,245,0,16,53049,'Created',TO_TIMESTAMP('2008-01-09 23:32:34','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was created','D',7,'The Created field indicates the date that this record was created.','Y','N','N','N','N','Y','N','N','N','N','N','Created',TO_TIMESTAMP('2008-01-09 23:32:34','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54135 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54136,246,0,18,110,53049,'CreatedBy',TO_TIMESTAMP('2008-01-09 23:32:35','YYYY-MM-DD HH24:MI:SS'),100,'User who created this records','D',22,'The Created By field indicates the user who created this record.','Y','N','N','N','N','Y','N','N','N','N','N','Created By',TO_TIMESTAMP('2008-01-09 23:32:35','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54136 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54137,348,0,20,53049,'IsActive',TO_TIMESTAMP('2008-01-09 23:32:36','YYYY-MM-DD HH24:MI:SS'),100,'Y','The record is active in the system','D',1,'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','N','N','N','N','Y','N','N','N','N','Y','Active',TO_TIMESTAMP('2008-01-09 23:32:36','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54137 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54138,607,0,16,53049,'Updated',TO_TIMESTAMP('2008-01-09 23:32:37','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was updated','D',7,'The Updated field indicates the date that this record was updated.','Y','N','N','N','N','Y','N','N','N','N','N','Updated',TO_TIMESTAMP('2008-01-09 23:32:37','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54138 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54139,53327,0,17,53234,53049,'ASP_Status',TO_TIMESTAMP('2008-01-09 23:32:38','YYYY-MM-DD HH24:MI:SS'),100,'U','D',1,'Y','N','N','N','N','Y','N','N','N','N','Y','ASP_Status',TO_TIMESTAMP('2008-01-09 23:32:38','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54139 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_TAB (AD_Client_ID,AD_Org_ID,AD_Tab_ID,AD_Table_ID,AD_Window_ID,CommitWarning,Created,CreatedBy,EntityType,HasTree,IsActive,IsAdvancedTab,IsInfoTab,IsInsertRecord,IsReadOnly,IsSingleRow,IsSortTab,IsTranslationTab,NAME,Processing,SeqNo,TabLevel,Updated,UpdatedBy) VALUES (0,0,53059,53049,53015,NULL,TO_TIMESTAMP('2008-01-09 23:32:45','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','N','Y','N','N','N','N','Process','N',70,2,TO_TIMESTAMP('2008-01-09 23:32:45','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TAB_TRL (AD_LANGUAGE,AD_Tab_ID, CommitWarning,Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Tab_ID, t.CommitWarning,t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TAB t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Tab_ID=53059 AND EXISTS (SELECT * FROM AD_TAB_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Tab_ID!=t.AD_Tab_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54130,54261,0,53059,TO_TIMESTAMP('2008-01-09 23:32:46','YYYY-MM-DD HH24:MI:SS'),100,'Client/Tenant for this installation.',22,'D','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','Y','Y','N','N','N','N','Client',10,0,TO_TIMESTAMP('2008-01-09 23:32:46','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54261 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54131,54262,0,53059,TO_TIMESTAMP('2008-01-09 23:32:49','YYYY-MM-DD HH24:MI:SS'),100,'Organizational entity within client',22,'D','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','Y','Y','N','N','N','Y','Organization',20,0,TO_TIMESTAMP('2008-01-09 23:32:49','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54262 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54133,54263,0,53059,TO_TIMESTAMP('2008-01-09 23:32:51','YYYY-MM-DD HH24:MI:SS'),100,22,'D','Y','Y','Y','N','N','N','N','ASP_Level_ID',30,0,TO_TIMESTAMP('2008-01-09 23:32:51','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54263 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54132,54264,0,53059,TO_TIMESTAMP('2008-01-09 23:32:51','YYYY-MM-DD HH24:MI:SS'),100,'Process or Report',22,'D','The Process field identifies a unique Process or Report in the system.','Y','Y','Y','N','N','N','N','Process',40,0,TO_TIMESTAMP('2008-01-09 23:32:51','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54264 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54139,54265,0,53059,TO_TIMESTAMP('2008-01-09 23:32:55','YYYY-MM-DD HH24:MI:SS'),100,1,'D','Y','Y','Y','N','N','N','N','ASP_Status',50,0,TO_TIMESTAMP('2008-01-09 23:32:55','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54265 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54137,54266,0,53059,TO_TIMESTAMP('2008-01-09 23:32:56','YYYY-MM-DD HH24:MI:SS'),100,'The record is active in the system',1,'D','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','Y','Y','N','N','N','N','Active',60,0,TO_TIMESTAMP('2008-01-09 23:32:56','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54266 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_TABLE (AD_Client_ID,AD_Org_ID,AD_Table_ID,AccessLevel,Created,CreatedBy,EntityType,ImportTable,IsActive,IsChangeLog,IsDeleteable,IsHighVolume,IsSecurityEnabled,IsView,NAME,ReplicationType,TableName,Updated,UpdatedBy) VALUES (0,0,53050,'4',TO_TIMESTAMP('2008-01-09 23:32:57','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','Y','N','N','N','ASP Process Parameter','L','ASP_Process_Para',TO_TIMESTAMP('2008-01-09 23:32:57','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TABLE_TRL (AD_LANGUAGE,AD_Table_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Table_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TABLE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Table_ID=53050 AND EXISTS (SELECT * FROM AD_TABLE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Table_ID!=t.AD_Table_ID)
;

INSERT INTO AD_SEQUENCE (AD_Client_ID,AD_Org_ID,AD_Sequence_ID,Created,CreatedBy,CurrentNext,CurrentNextSys,Description,IncrementNo,IsActive,IsAudited,IsAutoSequence,IsTableID,NAME,StartNewYear,StartNo,Updated,UpdatedBy) VALUES (0,0,53067,TO_TIMESTAMP('2008-01-09 23:32:59','YYYY-MM-DD HH24:MI:SS'),100,1000000,50000,'Table ASP_Process_Para',1,'Y','N','Y','Y','ASP_Process_Para','N',1000000,TO_TIMESTAMP('2008-01-09 23:32:59','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54140,102,0,19,53050,'AD_Client_ID',TO_TIMESTAMP('2008-01-09 23:32:59','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Client_ID@','Client/Tenant for this installation.','D',22,'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','N','N','N','N','Y','N','N','N','N','N','Client',TO_TIMESTAMP('2008-01-09 23:32:59','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54140 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54141,113,0,19,53050,104,'AD_Org_ID',TO_TIMESTAMP('2008-01-09 23:33:00','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Org_ID@','Organizational entity within client','D',22,'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','N','N','N','N','Y','N','N','N','N','N','Organization',TO_TIMESTAMP('2008-01-09 23:33:00','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54141 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54142,117,0,19,53050,163,'AD_Process_ID',TO_TIMESTAMP('2008-01-09 23:33:01','YYYY-MM-DD HH24:MI:SS'),100,'Process or Report','D',22,'The Process field identifies a unique Process or Report in the system.','Y','N','N','N','N','Y','Y','N','N','N','N','Process',TO_TIMESTAMP('2008-01-09 23:33:01','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54142 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54143,118,0,19,53050,186,'AD_Process_Para_ID',TO_TIMESTAMP('2008-01-09 23:33:05','YYYY-MM-DD HH24:MI:SS'),100,'D',22,'Y','N','N','N','N','N','Y','N','N','N','N','Process Parameter',TO_TIMESTAMP('2008-01-09 23:33:05','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54143 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54144,53326,0,19,53050,'ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:33:06','YYYY-MM-DD HH24:MI:SS'),100,'D',22,'Y','N','N','N','N','Y','Y','N','N','N','N','ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:33:06','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54144 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54145,608,0,18,110,53050,'UpdatedBy',TO_TIMESTAMP('2008-01-09 23:33:06','YYYY-MM-DD HH24:MI:SS'),100,'User who updated this records','D',22,'The Updated By field indicates the user who updated this record.','Y','N','N','N','N','Y','N','N','N','N','N','Updated By',TO_TIMESTAMP('2008-01-09 23:33:06','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54145 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54146,245,0,16,53050,'Created',TO_TIMESTAMP('2008-01-09 23:33:07','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was created','D',7,'The Created field indicates the date that this record was created.','Y','N','N','N','N','Y','N','N','N','N','N','Created',TO_TIMESTAMP('2008-01-09 23:33:07','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54146 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54147,246,0,18,110,53050,'CreatedBy',TO_TIMESTAMP('2008-01-09 23:33:09','YYYY-MM-DD HH24:MI:SS'),100,'User who created this records','D',22,'The Created By field indicates the user who created this record.','Y','N','N','N','N','Y','N','N','N','N','N','Created By',TO_TIMESTAMP('2008-01-09 23:33:09','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54147 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54148,348,0,20,53050,'IsActive',TO_TIMESTAMP('2008-01-09 23:33:10','YYYY-MM-DD HH24:MI:SS'),100,'Y','The record is active in the system','D',1,'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','N','N','N','N','Y','N','N','N','N','Y','Active',TO_TIMESTAMP('2008-01-09 23:33:10','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54148 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54149,607,0,16,53050,'Updated',TO_TIMESTAMP('2008-01-09 23:33:10','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was updated','D',7,'The Updated field indicates the date that this record was updated.','Y','N','N','N','N','Y','N','N','N','N','N','Updated',TO_TIMESTAMP('2008-01-09 23:33:10','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54149 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54150,53327,0,17,53234,53050,'ASP_Status',TO_TIMESTAMP('2008-01-09 23:33:11','YYYY-MM-DD HH24:MI:SS'),100,'U','D',1,'Y','N','N','N','N','Y','N','N','N','N','Y','ASP_Status',TO_TIMESTAMP('2008-01-09 23:33:11','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54150 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_TAB (AD_Client_ID,AD_Org_ID,AD_Tab_ID,AD_Table_ID,AD_Window_ID,CommitWarning,Created,CreatedBy,EntityType,HasTree,IsActive,IsAdvancedTab,IsInfoTab,IsInsertRecord,IsReadOnly,IsSingleRow,IsSortTab,IsTranslationTab,NAME,Processing,SeqNo,TabLevel,Updated,UpdatedBy) VALUES (0,0,53060,53050,53015,NULL,TO_TIMESTAMP('2008-01-09 23:33:15','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','N','Y','N','N','N','N','Process Parameter','N',80,3,TO_TIMESTAMP('2008-01-09 23:33:15','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TAB_TRL (AD_LANGUAGE,AD_Tab_ID, CommitWarning,Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Tab_ID, t.CommitWarning,t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TAB t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Tab_ID=53060 AND EXISTS (SELECT * FROM AD_TAB_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Tab_ID!=t.AD_Tab_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54140,54267,0,53060,TO_TIMESTAMP('2008-01-09 23:33:16','YYYY-MM-DD HH24:MI:SS'),100,'Client/Tenant for this installation.',22,'D','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','Y','Y','N','N','N','N','Client',10,0,TO_TIMESTAMP('2008-01-09 23:33:16','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54267 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54141,54268,0,53060,TO_TIMESTAMP('2008-01-09 23:33:17','YYYY-MM-DD HH24:MI:SS'),100,'Organizational entity within client',22,'D','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','Y','Y','N','N','N','Y','Organization',20,0,TO_TIMESTAMP('2008-01-09 23:33:17','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54268 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54144,54269,0,53060,TO_TIMESTAMP('2008-01-09 23:33:17','YYYY-MM-DD HH24:MI:SS'),100,22,'D','Y','Y','Y','N','N','Y','N','ASP_Level_ID',30,0,TO_TIMESTAMP('2008-01-09 23:33:17','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54269 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54142,54270,0,53060,TO_TIMESTAMP('2008-01-09 23:33:18','YYYY-MM-DD HH24:MI:SS'),100,'Process or Report',22,'D','The Process field identifies a unique Process or Report in the system.','Y','Y','Y','N','N','N','N','Process',40,0,TO_TIMESTAMP('2008-01-09 23:33:18','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54270 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54143,54271,0,53060,TO_TIMESTAMP('2008-01-09 23:33:21','YYYY-MM-DD HH24:MI:SS'),100,22,'D','Y','Y','Y','N','N','N','N','Process Parameter',50,0,TO_TIMESTAMP('2008-01-09 23:33:21','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54271 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54150,54272,0,53060,TO_TIMESTAMP('2008-01-09 23:33:22','YYYY-MM-DD HH24:MI:SS'),100,1,'D','Y','Y','Y','N','N','N','N','ASP_Status',60,0,TO_TIMESTAMP('2008-01-09 23:33:22','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54272 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54148,54273,0,53060,TO_TIMESTAMP('2008-01-09 23:33:22','YYYY-MM-DD HH24:MI:SS'),100,'The record is active in the system',1,'D','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','Y','Y','N','N','N','N','Active',70,0,TO_TIMESTAMP('2008-01-09 23:33:22','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54273 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_TABLE (AD_Client_ID,AD_Org_ID,AD_Table_ID,AccessLevel,Created,CreatedBy,EntityType,ImportTable,IsActive,IsChangeLog,IsDeleteable,IsHighVolume,IsSecurityEnabled,IsView,NAME,ReplicationType,TableName,Updated,UpdatedBy) VALUES (0,0,53051,'4',TO_TIMESTAMP('2008-01-09 23:33:23','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','Y','N','N','N','ASP Form','L','ASP_Form',TO_TIMESTAMP('2008-01-09 23:33:23','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TABLE_TRL (AD_LANGUAGE,AD_Table_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Table_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TABLE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Table_ID=53051 AND EXISTS (SELECT * FROM AD_TABLE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Table_ID!=t.AD_Table_ID)
;

INSERT INTO AD_SEQUENCE (AD_Client_ID,AD_Org_ID,AD_Sequence_ID,Created,CreatedBy,CurrentNext,CurrentNextSys,Description,IncrementNo,IsActive,IsAudited,IsAutoSequence,IsTableID,NAME,StartNewYear,StartNo,Updated,UpdatedBy) VALUES (0,0,53068,TO_TIMESTAMP('2008-01-09 23:33:24','YYYY-MM-DD HH24:MI:SS'),100,1000000,50000,'Table ASP_Form',1,'Y','N','Y','Y','ASP_Form','N',1000000,TO_TIMESTAMP('2008-01-09 23:33:24','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54151,102,0,19,53051,'AD_Client_ID',TO_TIMESTAMP('2008-01-09 23:33:25','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Client_ID@','Client/Tenant for this installation.','D',22,'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','N','N','N','N','Y','N','N','N','N','N','Client',TO_TIMESTAMP('2008-01-09 23:33:25','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54151 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54152,1298,0,19,53051,'AD_Form_ID',TO_TIMESTAMP('2008-01-09 23:33:26','YYYY-MM-DD HH24:MI:SS'),100,'Special Form','D',22,'The Special Form field identifies a unique Special Form in the system.','Y','N','N','N','N','Y','Y','N','N','N','N','Special Form',TO_TIMESTAMP('2008-01-09 23:33:26','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54152 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54153,113,0,19,53051,104,'AD_Org_ID',TO_TIMESTAMP('2008-01-09 23:33:26','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Org_ID@','Organizational entity within client','D',22,'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','N','N','N','N','Y','N','N','N','N','N','Organization',TO_TIMESTAMP('2008-01-09 23:33:26','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54153 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54154,53326,0,19,53051,'ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:33:28','YYYY-MM-DD HH24:MI:SS'),100,'D',22,'Y','N','N','N','N','Y','Y','N','N','N','N','ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:33:28','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54154 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54155,608,0,18,110,53051,'UpdatedBy',TO_TIMESTAMP('2008-01-09 23:33:28','YYYY-MM-DD HH24:MI:SS'),100,'User who updated this records','D',22,'The Updated By field indicates the user who updated this record.','Y','N','N','N','N','Y','N','N','N','N','N','Updated By',TO_TIMESTAMP('2008-01-09 23:33:28','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54155 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54156,245,0,16,53051,'Created',TO_TIMESTAMP('2008-01-09 23:33:29','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was created','D',7,'The Created field indicates the date that this record was created.','Y','N','N','N','N','Y','N','N','N','N','N','Created',TO_TIMESTAMP('2008-01-09 23:33:29','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54156 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54157,246,0,18,110,53051,'CreatedBy',TO_TIMESTAMP('2008-01-09 23:33:30','YYYY-MM-DD HH24:MI:SS'),100,'User who created this records','D',22,'The Created By field indicates the user who created this record.','Y','N','N','N','N','Y','N','N','N','N','N','Created By',TO_TIMESTAMP('2008-01-09 23:33:30','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54157 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54158,348,0,20,53051,'IsActive',TO_TIMESTAMP('2008-01-09 23:33:31','YYYY-MM-DD HH24:MI:SS'),100,'Y','The record is active in the system','D',1,'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','N','N','N','N','Y','N','N','N','N','Y','Active',TO_TIMESTAMP('2008-01-09 23:33:31','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54158 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54159,607,0,16,53051,'Updated',TO_TIMESTAMP('2008-01-09 23:33:32','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was updated','D',7,'The Updated field indicates the date that this record was updated.','Y','N','N','N','N','Y','N','N','N','N','N','Updated',TO_TIMESTAMP('2008-01-09 23:33:32','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54159 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54160,53327,0,17,53234,53051,'ASP_Status',TO_TIMESTAMP('2008-01-09 23:33:33','YYYY-MM-DD HH24:MI:SS'),100,'U','D',1,'Y','N','N','N','N','Y','N','N','N','N','Y','ASP_Status',TO_TIMESTAMP('2008-01-09 23:33:33','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54160 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_TAB (AD_Client_ID,AD_Org_ID,AD_Tab_ID,AD_Table_ID,AD_Window_ID,CommitWarning,Created,CreatedBy,EntityType,HasTree,IsActive,IsAdvancedTab,IsInfoTab,IsInsertRecord,IsReadOnly,IsSingleRow,IsSortTab,IsTranslationTab,NAME,Processing,SeqNo,TabLevel,Updated,UpdatedBy) VALUES (0,0,53061,53051,53015,NULL,TO_TIMESTAMP('2008-01-09 23:33:34','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','N','Y','N','N','N','N','Form','N',90,2,TO_TIMESTAMP('2008-01-09 23:33:34','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TAB_TRL (AD_LANGUAGE,AD_Tab_ID, CommitWarning,Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Tab_ID, t.CommitWarning,t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TAB t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Tab_ID=53061 AND EXISTS (SELECT * FROM AD_TAB_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Tab_ID!=t.AD_Tab_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54151,54274,0,53061,TO_TIMESTAMP('2008-01-09 23:33:35','YYYY-MM-DD HH24:MI:SS'),100,'Client/Tenant for this installation.',22,'D','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','Y','Y','N','N','N','N','Client',10,0,TO_TIMESTAMP('2008-01-09 23:33:35','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54274 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54153,54275,0,53061,TO_TIMESTAMP('2008-01-09 23:33:36','YYYY-MM-DD HH24:MI:SS'),100,'Organizational entity within client',22,'D','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','Y','Y','N','N','N','Y','Organization',20,0,TO_TIMESTAMP('2008-01-09 23:33:36','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54275 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54154,54276,0,53061,TO_TIMESTAMP('2008-01-09 23:33:36','YYYY-MM-DD HH24:MI:SS'),100,22,'D','Y','Y','Y','N','N','N','N','ASP_Level_ID',30,0,TO_TIMESTAMP('2008-01-09 23:33:36','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54276 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54152,54277,0,53061,TO_TIMESTAMP('2008-01-09 23:33:37','YYYY-MM-DD HH24:MI:SS'),100,'Special Form',22,'D','The Special Form field identifies a unique Special Form in the system.','Y','Y','Y','N','N','N','N','Special Form',40,0,TO_TIMESTAMP('2008-01-09 23:33:37','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54277 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54160,54278,0,53061,TO_TIMESTAMP('2008-01-09 23:33:38','YYYY-MM-DD HH24:MI:SS'),100,1,'D','Y','Y','Y','N','N','N','N','ASP_Status',50,0,TO_TIMESTAMP('2008-01-09 23:33:38','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54278 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54158,54279,0,53061,TO_TIMESTAMP('2008-01-09 23:33:40','YYYY-MM-DD HH24:MI:SS'),100,'The record is active in the system',1,'D','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','Y','Y','N','N','N','N','Active',60,0,TO_TIMESTAMP('2008-01-09 23:33:40','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54279 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_TABLE (AD_Client_ID,AD_Org_ID,AD_Table_ID,AccessLevel,Created,CreatedBy,EntityType,ImportTable,IsActive,IsChangeLog,IsDeleteable,IsHighVolume,IsSecurityEnabled,IsView,NAME,ReplicationType,TableName,Updated,UpdatedBy) VALUES (0,0,53052,'4',TO_TIMESTAMP('2008-01-09 23:33:44','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','Y','N','N','N','ASP Task','L','ASP_Task',TO_TIMESTAMP('2008-01-09 23:33:44','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TABLE_TRL (AD_LANGUAGE,AD_Table_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Table_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TABLE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Table_ID=53052 AND EXISTS (SELECT * FROM AD_TABLE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Table_ID!=t.AD_Table_ID)
;

INSERT INTO AD_SEQUENCE (AD_Client_ID,AD_Org_ID,AD_Sequence_ID,Created,CreatedBy,CurrentNext,CurrentNextSys,Description,IncrementNo,IsActive,IsAudited,IsAutoSequence,IsTableID,NAME,StartNewYear,StartNo,Updated,UpdatedBy) VALUES (0,0,53069,TO_TIMESTAMP('2008-01-09 23:33:45','YYYY-MM-DD HH24:MI:SS'),100,1000000,50000,'Table ASP_Task',1,'Y','N','Y','Y','ASP_Task','N',1000000,TO_TIMESTAMP('2008-01-09 23:33:45','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54161,102,0,19,53052,'AD_Client_ID',TO_TIMESTAMP('2008-01-09 23:33:46','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Client_ID@','Client/Tenant for this installation.','D',22,'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','N','N','N','N','Y','N','N','N','N','N','Client',TO_TIMESTAMP('2008-01-09 23:33:46','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54161 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54162,113,0,19,53052,104,'AD_Org_ID',TO_TIMESTAMP('2008-01-09 23:33:47','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Org_ID@','Organizational entity within client','D',22,'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','N','N','N','N','Y','N','N','N','N','N','Organization',TO_TIMESTAMP('2008-01-09 23:33:47','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54162 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54163,128,0,19,53052,'AD_Task_ID',TO_TIMESTAMP('2008-01-09 23:33:49','YYYY-MM-DD HH24:MI:SS'),100,'Operation System Task','D',22,'The Task field identifies a Operation System Task in the system.','Y','N','N','N','N','Y','Y','N','N','N','N','OS Task',TO_TIMESTAMP('2008-01-09 23:33:49','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54163 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54164,53326,0,19,53052,'ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:33:50','YYYY-MM-DD HH24:MI:SS'),100,'D',22,'Y','N','N','N','N','Y','Y','N','N','N','N','ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:33:50','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54164 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54165,608,0,18,110,53052,'UpdatedBy',TO_TIMESTAMP('2008-01-09 23:33:51','YYYY-MM-DD HH24:MI:SS'),100,'User who updated this records','D',22,'The Updated By field indicates the user who updated this record.','Y','N','N','N','N','Y','N','N','N','N','N','Updated By',TO_TIMESTAMP('2008-01-09 23:33:51','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54165 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54166,245,0,16,53052,'Created',TO_TIMESTAMP('2008-01-09 23:33:52','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was created','D',7,'The Created field indicates the date that this record was created.','Y','N','N','N','N','Y','N','N','N','N','N','Created',TO_TIMESTAMP('2008-01-09 23:33:52','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54166 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54167,246,0,18,110,53052,'CreatedBy',TO_TIMESTAMP('2008-01-09 23:33:56','YYYY-MM-DD HH24:MI:SS'),100,'User who created this records','D',22,'The Created By field indicates the user who created this record.','Y','N','N','N','N','Y','N','N','N','N','N','Created By',TO_TIMESTAMP('2008-01-09 23:33:56','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54167 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54168,348,0,20,53052,'IsActive',TO_TIMESTAMP('2008-01-09 23:34:00','YYYY-MM-DD HH24:MI:SS'),100,'Y','The record is active in the system','D',1,'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','N','N','N','N','Y','N','N','N','N','Y','Active',TO_TIMESTAMP('2008-01-09 23:34:00','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54168 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54169,607,0,16,53052,'Updated',TO_TIMESTAMP('2008-01-09 23:34:01','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was updated','D',7,'The Updated field indicates the date that this record was updated.','Y','N','N','N','N','Y','N','N','N','N','N','Updated',TO_TIMESTAMP('2008-01-09 23:34:01','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54169 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54170,53327,0,17,53234,53052,'ASP_Status',TO_TIMESTAMP('2008-01-09 23:34:05','YYYY-MM-DD HH24:MI:SS'),100,'U','D',1,'Y','N','N','N','N','Y','N','N','N','N','Y','ASP_Status',TO_TIMESTAMP('2008-01-09 23:34:05','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54170 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_TAB (AD_Client_ID,AD_Org_ID,AD_Tab_ID,AD_Table_ID,AD_Window_ID,CommitWarning,Created,CreatedBy,EntityType,HasTree,IsActive,IsAdvancedTab,IsInfoTab,IsInsertRecord,IsReadOnly,IsSingleRow,IsSortTab,IsTranslationTab,NAME,Processing,SeqNo,TabLevel,Updated,UpdatedBy) VALUES (0,0,53062,53052,53015,NULL,TO_TIMESTAMP('2008-01-09 23:34:06','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','N','Y','N','N','N','N','Task','N',100,2,TO_TIMESTAMP('2008-01-09 23:34:06','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TAB_TRL (AD_LANGUAGE,AD_Tab_ID, CommitWarning,Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Tab_ID, t.CommitWarning,t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TAB t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Tab_ID=53062 AND EXISTS (SELECT * FROM AD_TAB_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Tab_ID!=t.AD_Tab_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54161,54280,0,53062,TO_TIMESTAMP('2008-01-09 23:34:08','YYYY-MM-DD HH24:MI:SS'),100,'Client/Tenant for this installation.',22,'D','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','Y','Y','N','N','N','N','Client',10,0,TO_TIMESTAMP('2008-01-09 23:34:08','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54280 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54162,54281,0,53062,TO_TIMESTAMP('2008-01-09 23:34:11','YYYY-MM-DD HH24:MI:SS'),100,'Organizational entity within client',22,'D','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','Y','Y','N','N','N','Y','Organization',20,0,TO_TIMESTAMP('2008-01-09 23:34:11','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54281 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54164,54282,0,53062,TO_TIMESTAMP('2008-01-09 23:34:15','YYYY-MM-DD HH24:MI:SS'),100,22,'D','Y','Y','Y','N','N','N','N','ASP_Level_ID',30,0,TO_TIMESTAMP('2008-01-09 23:34:15','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54282 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54163,54283,0,53062,TO_TIMESTAMP('2008-01-09 23:34:16','YYYY-MM-DD HH24:MI:SS'),100,'Operation System Task',22,'D','The Task field identifies a Operation System Task in the system.','Y','Y','Y','N','N','N','N','OS Task',40,0,TO_TIMESTAMP('2008-01-09 23:34:16','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54283 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54170,54284,0,53062,TO_TIMESTAMP('2008-01-09 23:34:17','YYYY-MM-DD HH24:MI:SS'),100,1,'D','Y','Y','Y','N','N','N','N','ASP_Status',50,0,TO_TIMESTAMP('2008-01-09 23:34:17','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54284 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54168,54285,0,53062,TO_TIMESTAMP('2008-01-09 23:34:18','YYYY-MM-DD HH24:MI:SS'),100,'The record is active in the system',1,'D','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','Y','Y','N','N','N','N','Active',60,0,TO_TIMESTAMP('2008-01-09 23:34:18','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54285 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_TABLE (AD_Client_ID,AD_Org_ID,AD_Table_ID,AccessLevel,Created,CreatedBy,EntityType,ImportTable,IsActive,IsChangeLog,IsDeleteable,IsHighVolume,IsSecurityEnabled,IsView,NAME,ReplicationType,TableName,Updated,UpdatedBy) VALUES (0,0,53053,'4',TO_TIMESTAMP('2008-01-09 23:34:22','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','Y','N','N','N','ASP Workflow','L','ASP_Workflow',TO_TIMESTAMP('2008-01-09 23:34:22','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TABLE_TRL (AD_LANGUAGE,AD_Table_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Table_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TABLE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Table_ID=53053 AND EXISTS (SELECT * FROM AD_TABLE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Table_ID!=t.AD_Table_ID)
;

INSERT INTO AD_SEQUENCE (AD_Client_ID,AD_Org_ID,AD_Sequence_ID,Created,CreatedBy,CurrentNext,CurrentNextSys,Description,IncrementNo,IsActive,IsAudited,IsAutoSequence,IsTableID,NAME,StartNewYear,StartNo,Updated,UpdatedBy) VALUES (0,0,53070,TO_TIMESTAMP('2008-01-09 23:34:26','YYYY-MM-DD HH24:MI:SS'),100,1000000,50000,'Table ASP_Workflow',1,'Y','N','Y','Y','ASP_Workflow','N',1000000,TO_TIMESTAMP('2008-01-09 23:34:26','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54171,102,0,19,53053,'AD_Client_ID',TO_TIMESTAMP('2008-01-09 23:34:27','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Client_ID@','Client/Tenant for this installation.','D',22,'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','N','N','N','N','Y','N','N','N','N','N','Client',TO_TIMESTAMP('2008-01-09 23:34:27','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54171 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54172,113,0,19,53053,104,'AD_Org_ID',TO_TIMESTAMP('2008-01-09 23:34:28','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Org_ID@','Organizational entity within client','D',22,'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','N','N','N','N','Y','N','N','N','N','N','Organization',TO_TIMESTAMP('2008-01-09 23:34:28','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54172 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_VAL_RULE (AD_Client_ID,AD_Org_ID,AD_Val_Rule_ID,Code,Created,CreatedBy,EntityType,IsActive,NAME,TYPE,Updated,UpdatedBy) VALUES (0,0,52006,'AD_Workflow.WorkflowType = ''G''',TO_TIMESTAMP('2008-01-09 23:34:28','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','General Workflows','S',TO_TIMESTAMP('2008-01-09 23:34:28','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54173,144,0,19,53053,52006,'AD_Workflow_ID',TO_TIMESTAMP('2008-01-09 23:34:34','YYYY-MM-DD HH24:MI:SS'),100,'Workflow or combination of tasks','D',22,'The Workflow field identifies a unique Workflow in the system.','Y','N','N','N','N','Y','Y','N','N','N','N','Workflow',TO_TIMESTAMP('2008-01-09 23:34:34','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54173 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54174,53326,0,19,53053,'ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:34:34','YYYY-MM-DD HH24:MI:SS'),100,'D',22,'Y','N','N','N','N','Y','Y','N','N','N','N','ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:34:34','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54174 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54175,608,0,18,110,53053,'UpdatedBy',TO_TIMESTAMP('2008-01-09 23:34:36','YYYY-MM-DD HH24:MI:SS'),100,'User who updated this records','D',22,'The Updated By field indicates the user who updated this record.','Y','N','N','N','N','Y','N','N','N','N','N','Updated By',TO_TIMESTAMP('2008-01-09 23:34:36','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54175 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54176,245,0,16,53053,'Created',TO_TIMESTAMP('2008-01-09 23:34:37','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was created','D',7,'The Created field indicates the date that this record was created.','Y','N','N','N','N','Y','N','N','N','N','N','Created',TO_TIMESTAMP('2008-01-09 23:34:37','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54176 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54177,246,0,18,110,53053,'CreatedBy',TO_TIMESTAMP('2008-01-09 23:34:38','YYYY-MM-DD HH24:MI:SS'),100,'User who created this records','D',22,'The Created By field indicates the user who created this record.','Y','N','N','N','N','Y','N','N','N','N','N','Created By',TO_TIMESTAMP('2008-01-09 23:34:38','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54177 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54178,348,0,20,53053,'IsActive',TO_TIMESTAMP('2008-01-09 23:34:38','YYYY-MM-DD HH24:MI:SS'),100,'Y','The record is active in the system','D',1,'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','N','N','N','N','Y','N','N','N','N','Y','Active',TO_TIMESTAMP('2008-01-09 23:34:38','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54178 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54179,607,0,16,53053,'Updated',TO_TIMESTAMP('2008-01-09 23:34:39','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was updated','D',7,'The Updated field indicates the date that this record was updated.','Y','N','N','N','N','Y','N','N','N','N','N','Updated',TO_TIMESTAMP('2008-01-09 23:34:39','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54179 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54180,53327,0,17,53234,53053,'ASP_Status',TO_TIMESTAMP('2008-01-09 23:34:40','YYYY-MM-DD HH24:MI:SS'),100,'U','D',1,'Y','N','N','N','N','Y','N','N','N','N','Y','ASP_Status',TO_TIMESTAMP('2008-01-09 23:34:40','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54180 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_TAB (AD_Client_ID,AD_Org_ID,AD_Tab_ID,AD_Table_ID,AD_Window_ID,CommitWarning,Created,CreatedBy,EntityType,HasTree,IsActive,IsAdvancedTab,IsInfoTab,IsInsertRecord,IsReadOnly,IsSingleRow,IsSortTab,IsTranslationTab,NAME,Processing,SeqNo,TabLevel,Updated,UpdatedBy) VALUES (0,0,53063,53053,53015,NULL,TO_TIMESTAMP('2008-01-09 23:34:41','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','N','Y','N','N','N','N','Workflow','N',110,2,TO_TIMESTAMP('2008-01-09 23:34:41','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TAB_TRL (AD_LANGUAGE,AD_Tab_ID, CommitWarning,Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Tab_ID, t.CommitWarning,t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TAB t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Tab_ID=53063 AND EXISTS (SELECT * FROM AD_TAB_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Tab_ID!=t.AD_Tab_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54171,54286,0,53063,TO_TIMESTAMP('2008-01-09 23:34:41','YYYY-MM-DD HH24:MI:SS'),100,'Client/Tenant for this installation.',22,'D','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','Y','Y','N','N','N','N','Client',10,0,TO_TIMESTAMP('2008-01-09 23:34:41','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54286 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54172,54287,0,53063,TO_TIMESTAMP('2008-01-09 23:34:43','YYYY-MM-DD HH24:MI:SS'),100,'Organizational entity within client',22,'D','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','Y','Y','N','N','N','Y','Organization',20,0,TO_TIMESTAMP('2008-01-09 23:34:43','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54287 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54174,54288,0,53063,TO_TIMESTAMP('2008-01-09 23:34:46','YYYY-MM-DD HH24:MI:SS'),100,22,'D','Y','Y','Y','N','N','N','N','ASP_Level_ID',30,0,TO_TIMESTAMP('2008-01-09 23:34:46','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54288 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54173,54289,0,53063,TO_TIMESTAMP('2008-01-09 23:34:47','YYYY-MM-DD HH24:MI:SS'),100,'Workflow or combination of tasks',22,'D','The Workflow field identifies a unique Workflow in the system.','Y','Y','Y','N','N','N','N','Workflow',40,0,TO_TIMESTAMP('2008-01-09 23:34:47','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54289 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54180,54290,0,53063,TO_TIMESTAMP('2008-01-09 23:34:48','YYYY-MM-DD HH24:MI:SS'),100,1,'D','Y','Y','Y','N','N','N','N','ASP_Status',50,0,TO_TIMESTAMP('2008-01-09 23:34:48','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54290 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54178,54291,0,53063,TO_TIMESTAMP('2008-01-09 23:34:49','YYYY-MM-DD HH24:MI:SS'),100,'The record is active in the system',1,'D','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','Y','Y','N','N','N','N','Active',60,0,TO_TIMESTAMP('2008-01-09 23:34:49','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54291 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_TABLE (AD_Client_ID,AD_Org_ID,AD_Table_ID,AccessLevel,Created,CreatedBy,EntityType,ImportTable,IsActive,IsChangeLog,IsDeleteable,IsHighVolume,IsSecurityEnabled,IsView,NAME,ReplicationType,TableName,Updated,UpdatedBy) VALUES (0,0,53054,'4',TO_TIMESTAMP('2008-01-09 23:34:49','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','Y','N','N','N','ASP Module','L','ASP_Module',TO_TIMESTAMP('2008-01-09 23:34:49','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TABLE_TRL (AD_LANGUAGE,AD_Table_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Table_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TABLE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Table_ID=53054 AND EXISTS (SELECT * FROM AD_TABLE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Table_ID!=t.AD_Table_ID)
;

INSERT INTO AD_SEQUENCE (AD_Client_ID,AD_Org_ID,AD_Sequence_ID,Created,CreatedBy,CurrentNext,CurrentNextSys,Description,IncrementNo,IsActive,IsAudited,IsAutoSequence,IsTableID,NAME,StartNewYear,StartNo,Updated,UpdatedBy) VALUES (0,0,53071,TO_TIMESTAMP('2008-01-09 23:34:56','YYYY-MM-DD HH24:MI:SS'),100,1000000,50000,'Table ASP_Module',1,'Y','N','Y','Y','ASP_Module','N',1000000,TO_TIMESTAMP('2008-01-09 23:34:56','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,SeqNo,Updated,UpdatedBy,VERSION) VALUES (0,54181,469,0,10,53054,'Name',TO_TIMESTAMP('2008-01-09 23:34:58','YYYY-MM-DD HH24:MI:SS'),100,'Alphanumeric identifier of the entity','D',60,'The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.','Y','N','N','Y','N','Y','N','N','N','N','Y','Name',1,TO_TIMESTAMP('2008-01-09 23:34:58','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54181 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54182,113,0,19,53054,104,'AD_Org_ID',TO_TIMESTAMP('2008-01-09 23:34:59','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Org_ID@','Organizational entity within client','D',22,'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','N','N','N','N','Y','N','N','N','N','N','Organization',TO_TIMESTAMP('2008-01-09 23:34:59','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54182 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_ELEMENT (AD_Client_ID,AD_Element_ID,AD_Org_ID,ColumnName,Created,CreatedBy,EntityType,IsActive,NAME,PrintName,Updated,UpdatedBy) VALUES (0,53329,0,'ASP_Module_ID',TO_TIMESTAMP('2008-01-09 23:34:59','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','ASP_Module_ID','ASP_Module_ID',TO_TIMESTAMP('2008-01-09 23:34:59','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_ELEMENT_TRL (AD_LANGUAGE,AD_Element_ID, Description,Help,NAME,PO_Description,PO_Help,PO_Name,PO_PrintName,PrintName, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Element_ID, t.Description,t.Help,t.NAME,t.PO_Description,t.PO_Help,t.PO_Name,t.PO_PrintName,t.PrintName, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_ELEMENT t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Element_ID=53329 AND EXISTS (SELECT * FROM AD_ELEMENT_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Element_ID!=t.AD_Element_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54183,53329,0,13,53054,'ASP_Module_ID',TO_TIMESTAMP('2008-01-09 23:34:59','YYYY-MM-DD HH24:MI:SS'),100,'D',22,'Y','N','N','N','Y','Y','N','N','N','N','N','ASP_Module_ID',TO_TIMESTAMP('2008-01-09 23:34:59','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54183 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54184,245,0,16,53054,'Created',TO_TIMESTAMP('2008-01-09 23:35:01','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was created','D',7,'The Created field indicates the date that this record was created.','Y','N','N','N','N','Y','N','N','N','N','N','Created',TO_TIMESTAMP('2008-01-09 23:35:01','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54184 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54185,246,0,18,110,53054,'CreatedBy',TO_TIMESTAMP('2008-01-09 23:35:02','YYYY-MM-DD HH24:MI:SS'),100,'User who created this records','D',22,'The Created By field indicates the user who created this record.','Y','N','N','N','N','Y','N','N','N','N','N','Created By',TO_TIMESTAMP('2008-01-09 23:35:02','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54185 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54186,620,0,10,53054,'Value',TO_TIMESTAMP('2008-01-09 23:35:05','YYYY-MM-DD HH24:MI:SS'),100,'Search key for the record in the format required - must be unique','D',40,'A search key allows you a fast method of finding a particular record.
IF you leave THE search KEY empty, THE SYSTEM automatically creates a NUMERIC NUMBER.  THE document SEQUENCE used FOR this fallback NUMBER IS DEFINED IN THE "Maintain Sequence" window WITH THE NAME "DocumentNo_<TableName>", WHERE TableName IS THE actual NAME OF THE TABLE (e.g. C_ORDER).','Y','N','N','N','N','Y','N','N','N','N','Y','Search KEY',TO_TIMESTAMP('2008-01-09 23:35:05','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54186 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54187,326,0,14,53054,'Help',TO_TIMESTAMP('2008-01-09 23:35:06','YYYY-MM-DD HH24:MI:SS'),100,'Comment or Hint','D',2000,'The Help field contains a hint, comment or help about the use of this item.','Y','N','N','N','N','N','N','N','N','N','Y','Comment/Help',TO_TIMESTAMP('2008-01-09 23:35:06','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54187 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54188,348,0,20,53054,'IsActive',TO_TIMESTAMP('2008-01-09 23:35:07','YYYY-MM-DD HH24:MI:SS'),100,'Y','The record is active in the system','D',1,'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','N','N','N','N','Y','N','N','N','N','Y','Active',TO_TIMESTAMP('2008-01-09 23:35:07','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54188 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54189,607,0,16,53054,'Updated',TO_TIMESTAMP('2008-01-09 23:35:08','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was updated','D',7,'The Updated field indicates the date that this record was updated.','Y','N','N','N','N','Y','N','N','N','N','N','Updated',TO_TIMESTAMP('2008-01-09 23:35:08','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54189 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54190,608,0,18,110,53054,'UpdatedBy',TO_TIMESTAMP('2008-01-09 23:35:08','YYYY-MM-DD HH24:MI:SS'),100,'User who updated this records','D',22,'The Updated By field indicates the user who updated this record.','Y','N','N','N','N','Y','N','N','N','N','N','Updated By',TO_TIMESTAMP('2008-01-09 23:35:08','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54190 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54191,102,0,19,53054,'AD_Client_ID',TO_TIMESTAMP('2008-01-09 23:35:09','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Client_ID@','Client/Tenant for this installation.','D',22,'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','N','N','N','N','Y','N','N','N','N','N','Client',TO_TIMESTAMP('2008-01-09 23:35:09','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54191 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54192,275,0,10,53054,'Description',TO_TIMESTAMP('2008-01-09 23:35:13','YYYY-MM-DD HH24:MI:SS'),100,'Optional short description of the record','D',255,'A description is limited to 255 characters.','Y','N','N','N','N','N','N','N','N','N','Y','Description',TO_TIMESTAMP('2008-01-09 23:35:13','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54192 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_TAB (AD_Client_ID,AD_Org_ID,AD_Tab_ID,AD_Table_ID,AD_Window_ID,CommitWarning,Created,CreatedBy,EntityType,HasTree,IsActive,IsAdvancedTab,IsInfoTab,IsInsertRecord,IsReadOnly,IsSingleRow,IsSortTab,IsTranslationTab,NAME,Processing,SeqNo,TabLevel,Updated,UpdatedBy) VALUES (0,0,53064,53054,53015,NULL,TO_TIMESTAMP('2008-01-09 23:35:16','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','N','Y','N','Y','N','N','Module','N',10,0,TO_TIMESTAMP('2008-01-09 23:35:16','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TAB_TRL (AD_LANGUAGE,AD_Tab_ID, CommitWarning,Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Tab_ID, t.CommitWarning,t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TAB t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Tab_ID=53064 AND EXISTS (SELECT * FROM AD_TAB_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Tab_ID!=t.AD_Tab_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54183,54292,0,53064,TO_TIMESTAMP('2008-01-09 23:35:16','YYYY-MM-DD HH24:MI:SS'),100,22,'D','Y','Y','N','N','N','N','N','ASP_Module_ID',0,0,TO_TIMESTAMP('2008-01-09 23:35:16','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54292 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54191,54293,0,53064,TO_TIMESTAMP('2008-01-09 23:35:17','YYYY-MM-DD HH24:MI:SS'),100,'Client/Tenant for this installation.',20,'D','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','Y','Y','N','N','N','N','Client',10,0,TO_TIMESTAMP('2008-01-09 23:35:17','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54293 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54182,54294,0,53064,TO_TIMESTAMP('2008-01-09 23:35:21','YYYY-MM-DD HH24:MI:SS'),100,'Organizational entity within client',20,'D','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','Y','Y','N','N','N','Y','Organization',20,0,TO_TIMESTAMP('2008-01-09 23:35:21','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54294 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54186,54295,0,53064,TO_TIMESTAMP('2008-01-09 23:35:22','YYYY-MM-DD HH24:MI:SS'),100,'Search key for the record in the format required - must be unique',20,'D','A search key allows you a fast method of finding a particular record.
IF you leave THE search KEY empty, THE SYSTEM automatically creates a NUMERIC NUMBER.  THE document SEQUENCE used FOR this fallback NUMBER IS DEFINED IN THE "Maintain Sequence" window WITH THE NAME "DocumentNo_<TableName>", WHERE TableName IS THE actual NAME OF THE TABLE (e.g. C_ORDER).','Y','Y','Y','N','N','N','N','Search KEY',30,0,TO_TIMESTAMP('2008-01-09 23:35:22','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54295 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54181,54296,0,53064,TO_TIMESTAMP('2008-01-09 23:35:23','YYYY-MM-DD HH24:MI:SS'),100,'Alphanumeric identifier of the entity',40,'D','The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.','Y','Y','Y','N','N','N','N','Name',40,0,TO_TIMESTAMP('2008-01-09 23:35:23','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54296 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54192,54297,0,53064,TO_TIMESTAMP('2008-01-09 23:35:24','YYYY-MM-DD HH24:MI:SS'),100,'Optional short description of the record',40,'D','A description is limited to 255 characters.','Y','Y','Y','N','N','N','N','Description',50,0,TO_TIMESTAMP('2008-01-09 23:35:24','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54297 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54187,54298,0,53064,TO_TIMESTAMP('2008-01-09 23:35:25','YYYY-MM-DD HH24:MI:SS'),100,'Comment or Hint',40,'D','The Help field contains a hint, comment or help about the use of this item.','Y','Y','Y','N','N','N','N','Comment/Help',60,0,TO_TIMESTAMP('2008-01-09 23:35:25','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54298 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54188,54299,0,53064,TO_TIMESTAMP('2008-01-09 23:35:25','YYYY-MM-DD HH24:MI:SS'),100,'The record is active in the system',1,'D','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','Y','Y','N','N','N','N','Active',70,0,TO_TIMESTAMP('2008-01-09 23:35:25','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54299 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_TABLE (AD_Client_ID,AD_Org_ID,AD_Table_ID,AccessLevel,Created,CreatedBy,EntityType,ImportTable,IsActive,IsChangeLog,IsDeleteable,IsHighVolume,IsSecurityEnabled,IsView,NAME,ReplicationType,TableName,Updated,UpdatedBy) VALUES (0,0,53055,'4',TO_TIMESTAMP('2008-01-09 23:35:27','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','Y','N','N','N','ASP Level','L','ASP_Level',TO_TIMESTAMP('2008-01-09 23:35:27','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TABLE_TRL (AD_LANGUAGE,AD_Table_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Table_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TABLE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Table_ID=53055 AND EXISTS (SELECT * FROM AD_TABLE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Table_ID!=t.AD_Table_ID)
;

INSERT INTO AD_SEQUENCE (AD_Client_ID,AD_Org_ID,AD_Sequence_ID,Created,CreatedBy,CurrentNext,CurrentNextSys,Description,IncrementNo,IsActive,IsAudited,IsAutoSequence,IsTableID,NAME,StartNewYear,StartNo,Updated,UpdatedBy) VALUES (0,0,53072,TO_TIMESTAMP('2008-01-09 23:35:28','YYYY-MM-DD HH24:MI:SS'),100,1000000,50000,'Table ASP_Level',1,'Y','N','Y','Y','ASP_Level','N',1000000,TO_TIMESTAMP('2008-01-09 23:35:28','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_PROCESS (AD_Client_ID,AD_Org_ID,AD_Process_ID,AccessLevel,Classname,Created,CreatedBy,EntityType,IsActive,IsBetaFunctionality,IsDirectPrint,IsReport,NAME,ShowHelp,Statistic_Count,Statistic_Seconds,Updated,UpdatedBy,VALUE,WorkflowValue) VALUES (0,0,53067,'4','org.adempiere.process.ASPGenerateLevel',TO_TIMESTAMP('2008-01-09 23:35:29','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','N','N','N','ASP Generate Level','Y',0,0,TO_TIMESTAMP('2008-01-09 23:35:29','YYYY-MM-DD HH24:MI:SS'),100,'ASP Generate Level',NULL)
;

INSERT INTO AD_PROCESS_TRL (AD_LANGUAGE,AD_Process_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Process_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_PROCESS t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_ID=53067 AND EXISTS (SELECT * FROM AD_PROCESS_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Process_ID!=t.AD_Process_ID)
;

INSERT INTO AD_PROCESS_PARA (AD_Client_ID,AD_Element_ID,AD_Org_ID,AD_Process_ID,AD_Process_Para_ID,AD_Reference_ID,AD_Reference_Value_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsCentrallyMaintained,IsMandatory,IsRange,NAME,SeqNo,Updated,UpdatedBy) VALUES (0,53327,0,53067,53126,17,53234,'ASP_Status',TO_TIMESTAMP('2008-01-09 23:35:33','YYYY-MM-DD HH24:MI:SS'),100,'U','D',0,'Y','Y','Y','N','ASP Status',10,TO_TIMESTAMP('2008-01-09 23:35:33','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_PROCESS_PARA_TRL (AD_LANGUAGE,AD_Process_Para_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Process_Para_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_PROCESS_PARA t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_Para_ID=53126 AND EXISTS (SELECT * FROM AD_PROCESS_PARA_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Process_Para_ID!=t.AD_Process_Para_ID)
;

INSERT INTO AD_PROCESS_PARA (AD_Client_ID,AD_Org_ID,AD_Process_ID,AD_Process_Para_ID,AD_Reference_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsCentrallyMaintained,IsMandatory,IsRange,NAME,SeqNo,Updated,UpdatedBy) VALUES (0,0,53067,53127,20,'IsGenerateFields',TO_TIMESTAMP('2008-01-09 23:35:35','YYYY-MM-DD HH24:MI:SS'),100,'N','D',0,'Y','Y','Y','N','Generate Fields',30,TO_TIMESTAMP('2008-01-09 23:35:35','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_PROCESS_PARA_TRL (AD_LANGUAGE,AD_Process_Para_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Process_Para_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_PROCESS_PARA t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Process_Para_ID=53127 AND EXISTS (SELECT * FROM AD_PROCESS_PARA_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Process_Para_ID!=t.AD_Process_Para_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Process_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54193,524,0,53067,28,53055,'Processing',TO_TIMESTAMP('2008-01-09 23:35:36','YYYY-MM-DD HH24:MI:SS'),100,'D',1,'Y','N','N','N','N','N','N','N','N','N','Y','Process Now',TO_TIMESTAMP('2008-01-09 23:35:36','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54193 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,SeqNo,Updated,UpdatedBy,VERSION) VALUES (0,54194,469,0,10,53055,'Name',TO_TIMESTAMP('2008-01-09 23:35:37','YYYY-MM-DD HH24:MI:SS'),100,'Alphanumeric identifier of the entity','D',60,'The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.','Y','N','N','Y','N','Y','N','N','N','N','Y','Name',1,TO_TIMESTAMP('2008-01-09 23:35:37','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54194 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54195,53326,0,13,53055,'ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:35:38','YYYY-MM-DD HH24:MI:SS'),100,'D',22,'Y','N','N','N','Y','Y','N','N','N','N','N','ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:35:38','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54195 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54196,53329,0,19,53055,'ASP_Module_ID',TO_TIMESTAMP('2008-01-09 23:35:39','YYYY-MM-DD HH24:MI:SS'),100,'D',1,'Y','N','N','N','N','Y','Y','N','N','N','N','ASP_Module_ID',TO_TIMESTAMP('2008-01-09 23:35:39','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54196 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54197,245,0,16,53055,'Created',TO_TIMESTAMP('2008-01-09 23:35:43','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was created','D',7,'The Created field indicates the date that this record was created.','Y','N','N','N','N','Y','N','N','N','N','N','Created',TO_TIMESTAMP('2008-01-09 23:35:43','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54197 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54198,246,0,18,110,53055,'CreatedBy',TO_TIMESTAMP('2008-01-09 23:35:47','YYYY-MM-DD HH24:MI:SS'),100,'User who created this records','D',22,'The Created By field indicates the user who created this record.','Y','N','N','N','N','Y','N','N','N','N','N','Created By',TO_TIMESTAMP('2008-01-09 23:35:47','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54198 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54199,620,0,10,53055,'Value',TO_TIMESTAMP('2008-01-09 23:35:48','YYYY-MM-DD HH24:MI:SS'),100,'Search key for the record in the format required - must be unique','D',40,'A search key allows you a fast method of finding a particular record.
IF you leave THE search KEY empty, THE SYSTEM automatically creates a NUMERIC NUMBER.  THE document SEQUENCE used FOR this fallback NUMBER IS DEFINED IN THE "Maintain Sequence" window WITH THE NAME "DocumentNo_<TableName>", WHERE TableName IS THE actual NAME OF THE TABLE (e.g. C_ORDER).','Y','N','N','N','N','Y','N','N','N','N','Y','Search KEY',TO_TIMESTAMP('2008-01-09 23:35:48','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54199 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54200,326,0,14,53055,'Help',TO_TIMESTAMP('2008-01-09 23:35:49','YYYY-MM-DD HH24:MI:SS'),100,'Comment or Hint','D',2000,'The Help field contains a hint, comment or help about the use of this item.','Y','N','N','N','N','N','N','N','N','N','Y','Comment/Help',TO_TIMESTAMP('2008-01-09 23:35:49','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54200 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54201,348,0,20,53055,'IsActive',TO_TIMESTAMP('2008-01-09 23:35:53','YYYY-MM-DD HH24:MI:SS'),100,'Y','The record is active in the system','D',1,'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','N','N','N','N','Y','N','N','N','N','Y','Active',TO_TIMESTAMP('2008-01-09 23:35:53','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54201 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54202,607,0,16,53055,'Updated',TO_TIMESTAMP('2008-01-09 23:35:54','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was updated','D',7,'The Updated field indicates the date that this record was updated.','Y','N','N','N','N','Y','N','N','N','N','N','Updated',TO_TIMESTAMP('2008-01-09 23:35:54','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54202 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54203,608,0,18,110,53055,'UpdatedBy',TO_TIMESTAMP('2008-01-09 23:35:57','YYYY-MM-DD HH24:MI:SS'),100,'User who updated this records','D',22,'The Updated By field indicates the user who updated this record.','Y','N','N','N','N','Y','N','N','N','N','N','Updated By',TO_TIMESTAMP('2008-01-09 23:35:57','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54203 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54204,113,0,19,53055,104,'AD_Org_ID',TO_TIMESTAMP('2008-01-09 23:35:58','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Org_ID@','Organizational entity within client','D',22,'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','N','N','N','N','Y','N','N','N','N','N','Organization',TO_TIMESTAMP('2008-01-09 23:35:58','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54204 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54205,102,0,19,53055,'AD_Client_ID',TO_TIMESTAMP('2008-01-09 23:35:59','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Client_ID@','Client/Tenant for this installation.','D',22,'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','N','N','N','N','Y','N','N','N','N','N','Client',TO_TIMESTAMP('2008-01-09 23:35:59','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54205 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54206,275,0,10,53055,'Description',TO_TIMESTAMP('2008-01-09 23:36:00','YYYY-MM-DD HH24:MI:SS'),100,'Optional short description of the record','D',255,'A description is limited to 255 characters.','Y','N','N','N','N','N','N','N','N','N','Y','Description',TO_TIMESTAMP('2008-01-09 23:36:00','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54206 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_TAB (AD_Client_ID,AD_Org_ID,AD_Tab_ID,AD_Table_ID,AD_Window_ID,CommitWarning,Created,CreatedBy,EntityType,HasTree,IsActive,IsAdvancedTab,IsInfoTab,IsInsertRecord,IsReadOnly,IsSingleRow,IsSortTab,IsTranslationTab,NAME,Processing,SeqNo,TabLevel,Updated,UpdatedBy) VALUES (0,0,53065,53055,53015,NULL,TO_TIMESTAMP('2008-01-09 23:36:01','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','N','Y','N','Y','N','N','Level','N',20,1,TO_TIMESTAMP('2008-01-09 23:36:01','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TAB_TRL (AD_LANGUAGE,AD_Tab_ID, CommitWarning,Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Tab_ID, t.CommitWarning,t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TAB t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Tab_ID=53065 AND EXISTS (SELECT * FROM AD_TAB_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Tab_ID!=t.AD_Tab_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54195,54300,0,53065,TO_TIMESTAMP('2008-01-09 23:36:02','YYYY-MM-DD HH24:MI:SS'),100,22,'D','Y','Y','N','N','N','N','N','ASP_Level_ID',0,0,TO_TIMESTAMP('2008-01-09 23:36:02','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54300 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54205,54301,0,53065,TO_TIMESTAMP('2008-01-09 23:36:03','YYYY-MM-DD HH24:MI:SS'),100,'Client/Tenant for this installation.',20,'D','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','Y','Y','N','N','N','N','Client',10,0,TO_TIMESTAMP('2008-01-09 23:36:03','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54301 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54204,54302,0,53065,TO_TIMESTAMP('2008-01-09 23:36:04','YYYY-MM-DD HH24:MI:SS'),100,'Organizational entity within client',20,'D','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','Y','Y','N','N','N','Y','Organization',20,0,TO_TIMESTAMP('2008-01-09 23:36:04','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54302 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54196,54303,0,53065,TO_TIMESTAMP('2008-01-09 23:36:05','YYYY-MM-DD HH24:MI:SS'),100,20,'D','Y','Y','Y','N','N','N','N','ASP_Module_ID',30,0,TO_TIMESTAMP('2008-01-09 23:36:05','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54303 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54199,54304,0,53065,TO_TIMESTAMP('2008-01-09 23:36:06','YYYY-MM-DD HH24:MI:SS'),100,'Search key for the record in the format required - must be unique',40,'D','A search key allows you a fast method of finding a particular record.
IF you leave THE search KEY empty, THE SYSTEM automatically creates a NUMERIC NUMBER.  THE document SEQUENCE used FOR this fallback NUMBER IS DEFINED IN THE "Maintain Sequence" window WITH THE NAME "DocumentNo_<TableName>", WHERE TableName IS THE actual NAME OF THE TABLE (e.g. C_ORDER).','Y','Y','Y','N','N','N','N','Search KEY',40,0,TO_TIMESTAMP('2008-01-09 23:36:06','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54304 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54194,54305,0,53065,TO_TIMESTAMP('2008-01-09 23:36:07','YYYY-MM-DD HH24:MI:SS'),100,'Alphanumeric identifier of the entity',40,'D','The name of an entity (record) is used as an default search option in addition to the search key. The name is up to 60 characters in length.','Y','Y','Y','N','N','N','N','Name',50,0,TO_TIMESTAMP('2008-01-09 23:36:07','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54305 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54206,54306,0,53065,TO_TIMESTAMP('2008-01-09 23:36:11','YYYY-MM-DD HH24:MI:SS'),100,'Optional short description of the record',40,'D','A description is limited to 255 characters.','Y','Y','Y','N','N','N','N','Description',60,0,TO_TIMESTAMP('2008-01-09 23:36:11','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54306 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54200,54307,0,53065,TO_TIMESTAMP('2008-01-09 23:36:11','YYYY-MM-DD HH24:MI:SS'),100,'Comment or Hint',40,'D','The Help field contains a hint, comment or help about the use of this item.','Y','Y','Y','N','N','N','N','Comment/Help',70,0,TO_TIMESTAMP('2008-01-09 23:36:11','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54307 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54193,54308,0,53065,TO_TIMESTAMP('2008-01-09 23:36:12','YYYY-MM-DD HH24:MI:SS'),100,1,'D','Y','Y','Y','N','N','N','N','Process Now',80,0,TO_TIMESTAMP('2008-01-09 23:36:12','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54308 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54201,54309,0,53065,TO_TIMESTAMP('2008-01-09 23:36:13','YYYY-MM-DD HH24:MI:SS'),100,'The record is active in the system',1,'D','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','Y','Y','N','N','N','N','Active',90,0,TO_TIMESTAMP('2008-01-09 23:36:13','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54309 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_WINDOW (AD_Client_ID,AD_Org_ID,AD_Window_ID,Created,CreatedBy,EntityType,IsActive,IsBetaFunctionality,IsDefault,IsSOTrx,NAME,Processing,Updated,UpdatedBy,WindowType) VALUES (0,0,53016,TO_TIMESTAMP('2008-01-09 23:36:14','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','Y','N','Y','ASP Subscribed Modules','N',TO_TIMESTAMP('2008-01-09 23:36:14','YYYY-MM-DD HH24:MI:SS'),100,'M')
;

INSERT INTO AD_WINDOW_TRL (AD_LANGUAGE,AD_Window_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Window_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_WINDOW t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Window_ID=53016 AND EXISTS (SELECT * FROM AD_WINDOW_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Window_ID!=t.AD_Window_ID)
;

INSERT INTO AD_WINDOW_ACCESS (AD_Client_ID,AD_Org_ID,AD_Role_ID,AD_Window_ID,Created,CreatedBy,IsActive,Updated,UpdatedBy) VALUES (0,0,0,53016,TO_TIMESTAMP('2008-01-09 23:36:15','YYYY-MM-DD HH24:MI:SS'),100,'Y',TO_TIMESTAMP('2008-01-09 23:36:15','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_WINDOW_ACCESS (AD_Client_ID,AD_Org_ID,AD_Role_ID,AD_Window_ID,Created,CreatedBy,IsActive,Updated,UpdatedBy) VALUES (0,0,102,53016,TO_TIMESTAMP('2008-01-09 23:36:15','YYYY-MM-DD HH24:MI:SS'),100,'Y',TO_TIMESTAMP('2008-01-09 23:36:15','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_WINDOW_ACCESS (AD_Client_ID,AD_Org_ID,AD_Role_ID,AD_Window_ID,Created,CreatedBy,IsActive,Updated,UpdatedBy) VALUES (0,0,103,53016,TO_TIMESTAMP('2008-01-09 23:36:15','YYYY-MM-DD HH24:MI:SS'),100,'Y',TO_TIMESTAMP('2008-01-09 23:36:15','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_WINDOW_ACCESS (AD_Client_ID,AD_Org_ID,AD_Role_ID,AD_Window_ID,Created,CreatedBy,IsActive,Updated,UpdatedBy) VALUES (0,0,50001,53016,TO_TIMESTAMP('2008-01-09 23:36:15','YYYY-MM-DD HH24:MI:SS'),100,'Y',TO_TIMESTAMP('2008-01-09 23:36:15','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TABLE (AD_Client_ID,AD_Org_ID,AD_Table_ID,AccessLevel,Created,CreatedBy,EntityType,ImportTable,IsActive,IsChangeLog,IsDeleteable,IsHighVolume,IsSecurityEnabled,IsView,NAME,ReplicationType,TableName,Updated,UpdatedBy) VALUES (0,0,53056,'2',TO_TIMESTAMP('2008-01-09 23:36:15','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','Y','N','N','N','ASP Client Level','L','ASP_ClientLevel',TO_TIMESTAMP('2008-01-09 23:36:15','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TABLE_TRL (AD_LANGUAGE,AD_Table_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Table_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TABLE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Table_ID=53056 AND EXISTS (SELECT * FROM AD_TABLE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Table_ID!=t.AD_Table_ID)
;

INSERT INTO AD_SEQUENCE (AD_Client_ID,AD_Org_ID,AD_Sequence_ID,Created,CreatedBy,CurrentNext,CurrentNextSys,Description,IncrementNo,IsActive,IsAudited,IsAutoSequence,IsTableID,NAME,StartNewYear,StartNo,Updated,UpdatedBy) VALUES (0,0,53073,TO_TIMESTAMP('2008-01-09 23:36:16','YYYY-MM-DD HH24:MI:SS'),100,1000000,50000,'Table ASP_ClientLevel',1,'Y','N','Y','Y','ASP_ClientLevel','N',1000000,TO_TIMESTAMP('2008-01-09 23:36:16','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54207,102,0,19,53056,'AD_Client_ID',TO_TIMESTAMP('2008-01-09 23:36:20','YYYY-MM-DD HH24:MI:SS'),100,'@#AD_Client_ID@','Client/Tenant for this installation.','D',22,'A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','N','N','N','N','Y','N','N','N','N','N','Client',TO_TIMESTAMP('2008-01-09 23:36:20','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54207 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54208,113,0,19,53056,104,'AD_Org_ID',TO_TIMESTAMP('2008-01-09 23:36:20','YYYY-MM-DD HH24:MI:SS'),100,'0','Organizational entity within client','D',22,'An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','N','N','N','N','Y','N','N','N','N','N','Organization',TO_TIMESTAMP('2008-01-09 23:36:20','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54208 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_ELEMENT (AD_Client_ID,AD_Element_ID,AD_Org_ID,ColumnName,Created,CreatedBy,EntityType,IsActive,NAME,PrintName,Updated,UpdatedBy) VALUES (0,53330,0,'ASP_ClientLevel_ID',TO_TIMESTAMP('2008-01-09 23:36:22','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','ASP_ClientLevel_ID','ASP_ClientLevel_ID',TO_TIMESTAMP('2008-01-09 23:36:22','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_ELEMENT_TRL (AD_LANGUAGE,AD_Element_ID, Description,Help,NAME,PO_Description,PO_Help,PO_Name,PO_PrintName,PrintName, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Element_ID, t.Description,t.Help,t.NAME,t.PO_Description,t.PO_Help,t.PO_Name,t.PO_PrintName,t.PrintName, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_ELEMENT t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Element_ID=53330 AND EXISTS (SELECT * FROM AD_ELEMENT_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Element_ID!=t.AD_Element_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54209,53330,0,13,53056,'ASP_ClientLevel_ID',TO_TIMESTAMP('2008-01-09 23:36:22','YYYY-MM-DD HH24:MI:SS'),100,'D',22,'Y','N','N','N','Y','Y','N','N','N','N','N','ASP_ClientLevel_ID',TO_TIMESTAMP('2008-01-09 23:36:22','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54209 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_VAL_RULE (AD_Client_ID,AD_Org_ID,AD_Val_Rule_ID,Code,Created,CreatedBy,EntityType,IsActive,NAME,TYPE,Updated,UpdatedBy) VALUES (0,0,52007,'ASP_Module_ID=@ASP_Module_ID@',TO_TIMESTAMP('2008-01-09 23:36:26','YYYY-MM-DD HH24:MI:SS'),100,'D','Y','ASP_SameModule','S',TO_TIMESTAMP('2008-01-09 23:36:26','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54210,53326,0,19,53056,52007,'ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:36:27','YYYY-MM-DD HH24:MI:SS'),100,'D',10,'Y','N','N','N','N','Y','N','N','N','N','Y','ASP_Level_ID',TO_TIMESTAMP('2008-01-09 23:36:27','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54210 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54211,53329,0,19,53056,'ASP_Module_ID',TO_TIMESTAMP('2008-01-09 23:36:28','YYYY-MM-DD HH24:MI:SS'),100,'D',10,'Y','N','N','N','N','Y','N','N','N','N','Y','ASP_Module_ID',TO_TIMESTAMP('2008-01-09 23:36:28','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54211 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54212,608,0,18,110,53056,'UpdatedBy',TO_TIMESTAMP('2008-01-09 23:36:29','YYYY-MM-DD HH24:MI:SS'),100,'User who updated this records','D',22,'The Updated By field indicates the user who updated this record.','Y','N','N','N','N','Y','N','N','N','N','N','Updated By',TO_TIMESTAMP('2008-01-09 23:36:29','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54212 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54213,246,0,18,110,53056,'CreatedBy',TO_TIMESTAMP('2008-01-09 23:36:30','YYYY-MM-DD HH24:MI:SS'),100,'User who created this records','D',22,'The Created By field indicates the user who created this record.','Y','N','N','N','N','Y','N','N','N','N','N','Created By',TO_TIMESTAMP('2008-01-09 23:36:30','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54213 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54214,326,0,14,53056,'Help',TO_TIMESTAMP('2008-01-09 23:36:31','YYYY-MM-DD HH24:MI:SS'),100,'Comment or Hint','D',2000,'The Help field contains a hint, comment or help about the use of this item.','Y','N','N','N','N','N','N','N','N','N','Y','Comment/Help',TO_TIMESTAMP('2008-01-09 23:36:31','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54214 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54215,348,0,20,53056,'IsActive',TO_TIMESTAMP('2008-01-09 23:36:32','YYYY-MM-DD HH24:MI:SS'),100,'Y','The record is active in the system','D',1,'There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','N','N','N','N','Y','N','N','N','N','Y','Active',TO_TIMESTAMP('2008-01-09 23:36:32','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54215 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54216,607,0,16,53056,'Updated',TO_TIMESTAMP('2008-01-09 23:36:33','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was updated','D',7,'The Updated field indicates the date that this record was updated.','Y','N','N','N','N','Y','N','N','N','N','N','Updated',TO_TIMESTAMP('2008-01-09 23:36:33','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54216 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54217,245,0,16,53056,'Created',TO_TIMESTAMP('2008-01-09 23:36:33','YYYY-MM-DD HH24:MI:SS'),100,'Date this record was created','D',7,'The Created field indicates the date that this record was created.','Y','N','N','N','N','Y','N','N','N','N','N','Created',TO_TIMESTAMP('2008-01-09 23:36:33','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54217 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_TAB (AD_Client_ID,AD_Org_ID,AD_Tab_ID,AD_Table_ID,AD_Window_ID,CommitWarning,Created,CreatedBy,EntityType,HasTree,IsActive,IsAdvancedTab,IsInfoTab,IsInsertRecord,IsReadOnly,IsSingleRow,IsSortTab,IsTranslationTab,NAME,Processing,SeqNo,TabLevel,Updated,UpdatedBy) VALUES (0,0,53066,53056,53016,NULL,TO_TIMESTAMP('2008-01-09 23:36:37','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','N','Y','N','Y','N','N','Client Level','N',10,0,TO_TIMESTAMP('2008-01-09 23:36:37','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TAB_TRL (AD_LANGUAGE,AD_Tab_ID, CommitWarning,Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Tab_ID, t.CommitWarning,t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TAB t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Tab_ID=53066 AND EXISTS (SELECT * FROM AD_TAB_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Tab_ID!=t.AD_Tab_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54209,54310,0,53066,TO_TIMESTAMP('2008-01-09 23:36:39','YYYY-MM-DD HH24:MI:SS'),100,22,'D','Y','Y','N','N','N','N','N','ASP_ClientLevel_ID',0,0,TO_TIMESTAMP('2008-01-09 23:36:39','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54310 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54207,54311,0,53066,TO_TIMESTAMP('2008-01-09 23:36:39','YYYY-MM-DD HH24:MI:SS'),100,'Client/Tenant for this installation.',20,'D','A Client is a company or a legal entity. You cannot share data between Clients. Tenant is a synonym for Client.','Y','Y','Y','N','N','N','N','Client',10,0,TO_TIMESTAMP('2008-01-09 23:36:39','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54311 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54208,54312,0,53066,TO_TIMESTAMP('2008-01-09 23:36:40','YYYY-MM-DD HH24:MI:SS'),100,'Organizational entity within client',20,'D','An organization is a unit of your client or legal entity - examples are store, department. You can share data between organizations.','Y','Y','Y','N','N','N','Y','Organization',20,0,TO_TIMESTAMP('2008-01-09 23:36:40','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54312 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54211,54313,0,53066,TO_TIMESTAMP('2008-01-09 23:36:42','YYYY-MM-DD HH24:MI:SS'),100,20,'D','Y','Y','Y','N','N','N','N','ASP_Module_ID',30,0,TO_TIMESTAMP('2008-01-09 23:36:42','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54313 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,DisplayLength,EntityType,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54210,54314,0,53066,TO_TIMESTAMP('2008-01-09 23:36:43','YYYY-MM-DD HH24:MI:SS'),100,20,'D','Y','Y','Y','N','N','N','N','ASP_Level_ID',40,0,TO_TIMESTAMP('2008-01-09 23:36:43','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54314 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54214,54315,0,53066,TO_TIMESTAMP('2008-01-09 23:36:43','YYYY-MM-DD HH24:MI:SS'),100,'Comment or Hint',40,'D','The Help field contains a hint, comment or help about the use of this item.','Y','Y','Y','N','N','N','N','Comment/Help',50,0,TO_TIMESTAMP('2008-01-09 23:36:43','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54315 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_FIELD (AD_Client_ID,AD_Column_ID,AD_Field_ID,AD_Org_ID,AD_Tab_ID,Created,CreatedBy,Description,DisplayLength,EntityType,Help,IsActive,IsCentrallyMaintained,IsDisplayed,IsFieldOnly,IsHeading,IsReadOnly,IsSameLine,NAME,SeqNo,SortNo,Updated,UpdatedBy) VALUES (0,54215,54316,0,53066,TO_TIMESTAMP('2008-01-09 23:36:44','YYYY-MM-DD HH24:MI:SS'),100,'The record is active in the system',1,'D','There are two methods of making records unavailable in the system: One is to delete the record, the other is to de-activate the record. A de-activated record is not available for selection, but available for reports.
There are two reasons FOR de-activating AND NOT DELETING records:
(1) THE SYSTEM requires THE RECORD FOR AUDIT purposes.
(2) THE RECORD IS referenced BY other records. E.g., you cannot DELETE a Business Partner, IF there are invoices FOR this partner RECORD existing. You de-ACTIVATE THE Business Partner AND prevent that this RECORD IS used FOR future entries.','Y','Y','Y','N','N','N','N','Active',60,0,TO_TIMESTAMP('2008-01-09 23:36:44','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_FIELD_TRL (AD_LANGUAGE,AD_Field_ID, Description,Help,NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Field_ID, t.Description,t.Help,t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_FIELD t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Field_ID=54316 AND EXISTS (SELECT * FROM AD_FIELD_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Field_ID!=t.AD_Field_ID)
;

INSERT INTO AD_TABLE (AD_Client_ID,AD_Org_ID,AD_Table_ID,AccessLevel,Created,CreatedBy,EntityType,ImportTable,IsActive,IsChangeLog,IsDeleteable,IsHighVolume,IsSecurityEnabled,IsView,NAME,ReplicationType,TableName,Updated,UpdatedBy) VALUES (0,0,53057,'2',TO_TIMESTAMP('2008-01-09 23:36:45','YYYY-MM-DD HH24:MI:SS'),100,'D','N','Y','N','Y','N','N','N','ASP Client Exception','L','ASP_ClientException',TO_TIMESTAMP('2008-01-09 23:36:45','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_TABLE_TRL (AD_LANGUAGE,AD_Table_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Table_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_TABLE t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Table_ID=53057 AND EXISTS (SELECT * FROM AD_TABLE_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Table_ID!=t.AD_Table_ID)
;

INSERT INTO AD_SEQUENCE (AD_Client_ID,AD_Org_ID,AD_Sequence_ID,Created,CreatedBy,CurrentNext,CurrentNextSys,Description,IncrementNo,IsActive,IsAudited,IsAutoSequence,IsTableID,NAME,StartNewYear,StartNo,Updated,UpdatedBy) VALUES (0,0,53074,TO_TIMESTAMP('2008-01-09 23:36:46','YYYY-MM-DD HH24:MI:SS'),100,1000000,50000,'Table ASP_ClientException',1,'Y','N','Y','Y','ASP_ClientException','N',1000000,TO_TIMESTAMP('2008-01-09 23:36:46','YYYY-MM-DD HH24:MI:SS'),100)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,ReadOnlyLogic,Updated,UpdatedBy,VERSION) VALUES (0,54218,144,0,19,53057,52006,'AD_Workflow_ID',TO_TIMESTAMP('2008-01-09 23:36:51','YYYY-MM-DD HH24:MI:SS'),100,'Workflow or combination of tasks','D',22,'The Workflow field identifies a unique Workflow in the system.','Y','N','N','N','N','N','N','N','N','N','Y','Workflow','@AD_Window_ID@>0 | @AD_Process_ID@>0 | @AD_Form_ID@>0 | @AD_Task_ID@>0',TO_TIMESTAMP('2008-01-09 23:36:51','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54218 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,ReadOnlyLogic,Updated,UpdatedBy,VERSION) VALUES (0,54219,1298,0,19,53057,'AD_Form_ID',TO_TIMESTAMP('2008-01-09 23:36:55','YYYY-MM-DD HH24:MI:SS'),100,'Special Form','D',22,'The Special Form field identifies a unique Special Form in the system.','Y','N','N','N','N','N','N','N','N','N','Y','Special Form','@AD_Process_ID@>0 | @AD_Window_ID@>0 | @AD_Task_ID@>0 | @AD_Workflow_ID@>0',TO_TIMESTAMP('2008-01-09 23:36:55','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54219 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,AD_Val_Rule_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,ReadOnlyLogic,Updated,UpdatedBy,VERSION) VALUES (0,54220,142,0,19,53057,140,'AD_WF_Node_ID',TO_TIMESTAMP('2008-01-09 23:36:56','YYYY-MM-DD HH24:MI:SS'),100,'Workflow Node (activity), step or process','D',22,'The Workflow Node indicates a unique step or process in a Workflow.','Y','N','N','N','N','N','N','N','N','N','Y','Node','@AD_Window_ID@>0 | @AD_Process_ID@>0 | @AD_Form_ID@>0 | @AD_Task_ID@>0',TO_TIMESTAMP('2008-01-09 23:36:56','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54220 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,ReadOnlyLogic,Updated,UpdatedBy,VERSION) VALUES (0,54221,128,0,19,53057,'AD_Task_ID',TO_TIMESTAMP('2008-01-09 23:36:58','YYYY-MM-DD HH24:MI:SS'),100,'Operation System Task','D',22,'The Task field identifies a Operation System Task in the system.','Y','N','N','N','N','N','N','N','N','N','Y','OS Task','@AD_Process_ID@>0 | @AD_Form_ID@>0 | @AD_Window_ID@>0 | @AD_Workflow_ID@>0',TO_TIMESTAMP('2008-01-09 23:36:58','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54221 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Reference_Value_ID,AD_Table_ID,ColumnName,Created,CreatedBy,DefaultValue,EntityType,FieldLength,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,Updated,UpdatedBy,VERSION) VALUES (0,54222,53327,0,17,53234,53057,'ASP_Status',TO_TIMESTAMP('2008-01-09 23:36:58','YYYY-MM-DD HH24:MI:SS'),100,'U','D',1,'Y','N','N','N','N','Y','N','N','N','N','Y','ASP_Status',TO_TIMESTAMP('2008-01-09 23:36:58','YYYY-MM-DD HH24:MI:SS'),100,0)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUAGE,t.AD_Column_ID, t.NAME, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy FROM AD_LANGUAGE l, AD_COLUMN t WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.AD_Column_ID=54222 AND EXISTS (SELECT * FROM AD_COLUMN_TRL tt WHERE tt.AD_LANGUAGE!=l.AD_LANGUAGE OR tt.AD_Column_ID!=t.AD_Column_ID)
;

INSERT INTO AD_COLUMN (AD_Client_ID,AD_Column_ID,AD_Element_ID,AD_Org_ID,AD_Reference_ID,AD_Table_ID,ColumnName,Created,CreatedBy,Description,EntityType,FieldLength,Help,IsActive,IsAlwaysUpdateable,IsEncrypted,IsIdentifier,IsKey,IsMandatory,IsParent,IsSelectionColumn,IsSyncDatabase,IsTranslated,IsUpdateable,NAME,ReadOnlyLogic,Updated,UpdatedBy,VERSION) VALUES (0,54223,117,0,19,53057,'AD_Process_ID',TO_TIMESTAMP('2008-01-09 23:36:59','YYYY-MM-DD HH24:MI:SS'),100,'Process or Report','D',22,'The Process field identifies a unique Process or Report in the system.','Y','N','N','N','N','N','N','N','N','N','Y','Process','@AD_Window_ID@>0 | @AD_Form_ID@>0 | @AD_Task_ID@>0 | @AD_Workflow_ID@>0',TO_TIMESTAMP('2008-01-09 23:36:59','YYYY-MM-DD HH24:MI:SS'),100,1)
;

INSERT INTO AD_COLUMN_TRL (AD_LANGUAGE,AD_Column_ID, NAME, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) SELECT l.AD_LANGUA