package org.zkforge.timeline;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import org.zkforge.timeline.event.BandScrollEvent;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.Command;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Events;

/** The band-scroll command.
 *
 * @author WeiXing Gu, China
 */
class BandScrollCommand extends Command {

	protected BandScrollCommand(String arg0, int arg1) {
		super(arg0, arg1);
		// TODO Auto-generated constructor stub
	}

//	@Override
	protected void process(AuRequest request) {
		// TODO Auto-generated method stub
		final Component comp = request.getComponent();
		if (comp == null)
			throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, this);
		if (!(comp instanceof Bandinfo))
			throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, this);
		final String[] data = request.getData();
		if (data == null || data.length < 2)
			throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[] {
					Objects.toString(data), this });

		SimpleDateFormat sdf = new SimpleDateFormat(
				"EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
		Date min = null;
		try {
			min = sdf.parse(data[0]);
		} catch (ParseException e) {
		}
		Date max = null;
		try {
			max = sdf.parse(data[1]);
		} catch (ParseException e) {
		}
		Date center = null;
		try {
			center = sdf.parse(data[2]);
		} catch (ParseException e) {
		}
		Events.postEvent(new BandScrollEvent(getId(), comp, min, max, center));
	}

}
