/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPLTZ;

public class TIMESTAMP
extends Datum {
    private static int CENTURY_DEFAULT = 119;
    private static int DECADE_DEFAULT = 100;
    private static int MONTH_DEFAULT = 1;
    private static int DAY_DEFAULT = 1;
    private static int DECADE_INIT = 170;
    private static int JAVA_YEAR = 1970;
    private static int JAVA_MONTH = 0;
    private static int JAVA_DATE = 1;
    private static int SIZE_TIMESTAMP = 11;
    private static int SIZE_TIMESTAMP_NOFRAC = 7;
    private static int SIZE_DATE = 7;

    public TIMESTAMP() {
        super(TIMESTAMP.initTimestamp());
    }

    public TIMESTAMP(String string) {
        super(TIMESTAMP.toBytes(string));
    }

    public TIMESTAMP(Date date) {
        super(TIMESTAMP.toBytes(date));
    }

    public TIMESTAMP(Time time) {
        super(TIMESTAMP.toBytes(time));
    }

    public TIMESTAMP(Timestamp timestamp) {
        super(TIMESTAMP.toBytes(timestamp));
    }

    public TIMESTAMP(DATE dATE) {
        super(TIMESTAMP.toBytes(dATE));
    }

    public TIMESTAMP(byte[] byArray) {
        super(byArray);
    }

    public static TIMESTAMP TimeZoneConvert(Connection connection, TIMESTAMP tIMESTAMP, TimeZone timeZone, TimeZone timeZone2) throws SQLException {
        byte[] byArray = tIMESTAMP.getBytes();
        int n = byArray.length;
        int[] nArray = n == SIZE_TIMESTAMP ? new int[SIZE_TIMESTAMP] : new int[SIZE_TIMESTAMP_NOFRAC];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = byArray[n2] & 0xFF;
            ++n2;
        }
        TimeZone timeZone3 = TimeZone.getDefault();
        int n3 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
        Calendar calendar = Calendar.getInstance(timeZone);
        Calendar calendar2 = Calendar.getInstance(timeZone2);
        TimeZone.setDefault(calendar.getTimeZone());
        calendar.set(1, n3);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar, calendar2);
        long l = calendar2.getTime().getTime();
        TimeZone.setDefault(timeZone3);
        Timestamp timestamp = new Timestamp(l);
        int n4 = 0;
        if (n == SIZE_TIMESTAMP) {
            n4 = nArray[7] << 24;
            n4 |= nArray[8] << 16;
            n4 |= nArray[9] << 8;
            timestamp.setNanos(n4 |= nArray[10] & 0xFF);
        } else {
            timestamp.setNanos(0);
        }
        return new TIMESTAMP(timestamp);
    }

    private static byte[] initTimestamp() {
        byte[] byArray = new byte[SIZE_TIMESTAMP];
        byArray[0] = (byte)CENTURY_DEFAULT;
        byArray[1] = (byte)DECADE_INIT;
        byArray[2] = (byte)MONTH_DEFAULT;
        byArray[3] = (byte)DAY_DEFAULT;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        return byArray;
    }

    public boolean isConvertibleTo(Class clazz) {
        return clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0;
    }

    public Object makeJdbcArray(int n) {
        Timestamp[] timestampArray = new Timestamp[n];
        return timestampArray;
    }

    public String stringValue() {
        return TIMESTAMP.toString(this.getBytes());
    }

    public Timestamp timestampValue() throws SQLException {
        return TIMESTAMP.toTimestamp(this.getBytes());
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(String string) {
        return TIMESTAMP.toBytes(Timestamp.valueOf(string));
    }

    public static byte[] toBytes(Date date) {
        if (date == null) {
            return null;
        }
        byte[] byArray = new byte[SIZE_TIMESTAMP_NOFRAC];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        byArray[0] = (byte)(calendar.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        return byArray;
    }

    public static byte[] toBytes(Time time) {
        if (time == null) {
            return null;
        }
        byte[] byArray = new byte[SIZE_TIMESTAMP_NOFRAC];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        byArray[0] = (byte)CENTURY_DEFAULT;
        byArray[1] = (byte)DECADE_DEFAULT;
        byArray[2] = (byte)MONTH_DEFAULT;
        byArray[3] = (byte)DAY_DEFAULT;
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        return byArray;
    }

    public static byte[] toBytes(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        int n = timestamp.getNanos();
        byte[] byArray = n == 0 ? new byte[SIZE_TIMESTAMP_NOFRAC] : new byte[SIZE_TIMESTAMP];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        byArray[0] = (byte)(calendar.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        if (n != 0) {
            byArray[7] = (byte)(n >> 24);
            byArray[8] = (byte)(n >> 16 & 0xFF);
            byArray[9] = (byte)(n >> 8 & 0xFF);
            byArray[10] = (byte)(n & 0xFF);
        }
        return byArray;
    }

    public static byte[] toBytes(DATE dATE) {
        if (dATE == null) {
            return null;
        }
        byte[] byArray = new byte[SIZE_TIMESTAMP_NOFRAC];
        System.arraycopy(dATE.getBytes(), 0, byArray, 0, 7);
        return byArray;
    }

    public static DATE toDATE(byte[] byArray) throws SQLException {
        byte[] byArray2 = new byte[SIZE_DATE];
        System.arraycopy(byArray, 0, byArray2, 0, SIZE_DATE);
        return new DATE(byArray2);
    }

    public static Date toDate(byte[] byArray) throws SQLException {
        int n = byArray.length;
        int[] nArray = n == SIZE_TIMESTAMP ? new int[SIZE_TIMESTAMP] : new int[SIZE_TIMESTAMP_NOFRAC];
        int n2 = 0;
        while (n2 < byArray.length) {
            nArray[n2] = byArray[n2] & 0xFF;
            ++n2;
        }
        int n3 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n3);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        long l = calendar.getTime().getTime();
        return new Date(l);
    }

    public Object toJdbc() throws SQLException {
        return this.timestampValue();
    }

    public static String toString(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        int[] nArray = n2 == SIZE_TIMESTAMP ? new int[SIZE_TIMESTAMP] : new int[SIZE_TIMESTAMP_NOFRAC];
        int n3 = 0;
        while (n3 < byArray.length) {
            nArray[n3] = byArray[n3] < 0 ? byArray[n3] + 256 : byArray[n3];
            ++n3;
        }
        nArray[4] = nArray[4] - 1;
        nArray[5] = nArray[5] - 1;
        nArray[6] = nArray[6] - 1;
        int n4 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
        if (n2 == SIZE_TIMESTAMP) {
            n = (nArray[7] & 0xFF) << 24;
            n |= (nArray[8] & 0xFF) << 16;
            n |= (nArray[9] & 0xFF) << 8;
            n |= nArray[10] & 0xFF & 0xFF;
        }
        return String.valueOf(n4) + "-" + nArray[2] + "-" + nArray[3] + " " + nArray[4] + "." + nArray[5] + "." + nArray[6] + "." + n;
    }

    public static Time toTime(byte[] byArray) throws SQLException {
        int n = byArray[4] & 0xFF;
        int n2 = byArray[5] & 0xFF;
        int n3 = byArray[6] & 0xFF;
        return new Time(n - 1, n2 - 1, n3 - 1);
    }

    public static Timestamp toTimestamp(byte[] byArray) throws SQLException {
        int n = byArray.length;
        int[] nArray = n == SIZE_TIMESTAMP ? new int[SIZE_TIMESTAMP] : new int[SIZE_TIMESTAMP_NOFRAC];
        int n2 = 0;
        while (n2 < byArray.length) {
            nArray[n2] = byArray[n2] & 0xFF;
            ++n2;
        }
        int n3 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n3);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        long l = calendar.getTime().getTime();
        Timestamp timestamp = new Timestamp(l);
        if (n == SIZE_TIMESTAMP) {
            int n4 = nArray[7] << 24;
            n4 |= nArray[8] << 16;
            n4 |= nArray[9] << 8;
            timestamp.setNanos(n4 |= nArray[10] & 0xFF);
        } else {
            timestamp.setNanos(0);
        }
        return timestamp;
    }
}

