/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JTextField;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.acroforms.FormObject;
import org.jpedal.objects.acroforms.FormStream;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class AnnotStream
extends FormStream {
    private int pageHeight;
    private int insetH;

    protected AnnotStream() {
    }

    public AnnotStream(PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
        this.type = 1;
        this.init();
    }

    public void setPageHeightAndInset(int n, int n2) {
        this.pageHeight = n;
        this.insetH = n2;
    }

    protected void parseStream(FormObject formObject) {
        block69: {
            Object object;
            block75: {
                block74: {
                    block73: {
                        block72: {
                            block71: {
                                block70: {
                                    block68: {
                                        formObject.setBorder(null);
                                        this.currentField.remove("P");
                                        boolean bl = false;
                                        object = this.currentPdfFile.resolveToMapOrString("Subtype", this.currentField.get("Subtype"));
                                        if (object == null) {
                                            return;
                                        }
                                        if (!((String)object).startsWith("/")) {
                                            object = "/" + object;
                                        }
                                        if (!object.equals("/Text")) break block68;
                                        formObject.setCharacteristic(4);
                                        formObject.setCharacteristic(5);
                                        formObject.setType(11);
                                        this.createOrderedCommandArray();
                                        for (int i = 0; i < this.commands.length; ++i) {
                                            boolean bl2;
                                            String string = this.commands[i];
                                            Object object2 = this.currentPdfFile.resolveToMapOrString(string, this.currentField.get(string));
                                            if (string.equals("Type")) {
                                                if (!object2.equals("/Annot")) continue;
                                                continue;
                                            }
                                            if (string.equals("Subtype")) continue;
                                            if (string.equals("Rect")) {
                                                this.createBoundsRectangle((String)object2, formObject);
                                                continue;
                                            }
                                            if (string.equals("AP")) {
                                                bl2 = this.commandAP((Map)object2, formObject);
                                                if (bl2) continue;
                                            }
                                            if (string.equals("C")) {
                                                bl2 = this.commandC(formObject, object2);
                                                if (bl2) continue;
                                            }
                                            if (string.equals("Contents")) {
                                                bl2 = this.commandContents(formObject, object2);
                                                if (bl2) continue;
                                            }
                                            if (string.equals("Popup")) {
                                                this.commandPopup(object2, formObject);
                                                continue;
                                            }
                                            if (string.equals("Open")) {
                                                formObject.setOpenState(Boolean.valueOf((String)object2));
                                                continue;
                                            }
                                            if (string.equals("Name") || string.equals("M") || string.equals("CreationDate")) continue;
                                            if (string.equals("RC")) {
                                                this.commandRC(object2, formObject);
                                                continue;
                                            }
                                            if (string.equals("F")) {
                                                this.workOutCharachteristic((String)object2, formObject);
                                                continue;
                                            }
                                            if (string.equals("T")) {
                                                formObject.setPopupTitle((String)object2);
                                                continue;
                                            }
                                            if (string.equals("NM")) {
                                                this.commandNM(formObject, object2);
                                                continue;
                                            }
                                            if (string.equals("Subj")) continue;
                                            if (string.equals("PageNumber")) {
                                                formObject.setPageNumber(object2);
                                                continue;
                                            }
                                            if (!string.equals("BS")) continue;
                                            formObject.setBorder(object2);
                                        }
                                        break block69;
                                    }
                                    if (object.equals("/Popup")) break block69;
                                    if (!object.equals("/Ink")) break block70;
                                    formObject.setType(13);
                                    this.createOrderedCommandArray();
                                    for (int i = 0; i < this.commands.length; ++i) {
                                        boolean bl;
                                        String string = this.commands[i];
                                        Object object3 = this.currentPdfFile.resolveToMapOrString(string, this.currentField.get(string));
                                        if (string.equals("Type")) {
                                            if (!object3.equals("/Annot")) continue;
                                            continue;
                                        }
                                        if (string.equals("Subtype")) continue;
                                        if (string.equals("Rect")) {
                                            this.createBoundsRectangle((String)object3, formObject);
                                            continue;
                                        }
                                        if (string.equals("AP")) {
                                            if (!formObject.hasNormalOff() && (bl = this.commandAP((Map)object3, formObject))) continue;
                                        }
                                        if (string.equals("C")) {
                                            bl = this.commandC(formObject, object3);
                                            if (bl) continue;
                                        }
                                        if (string.equals("F")) {
                                            this.workOutCharachteristic((String)object3, formObject);
                                            continue;
                                        }
                                        if (string.equals("T")) {
                                            formObject.setPopupTitle((String)object3);
                                            continue;
                                        }
                                        if (string.equals("M") || string.equals("CreationDate")) continue;
                                        if (string.equals("NM")) {
                                            this.commandNM(formObject, object3);
                                            continue;
                                        }
                                        if (string.equals("Subj")) continue;
                                        if (string.equals("PageNumber")) {
                                            formObject.setPageNumber(object3);
                                            continue;
                                        }
                                        if (string.equals("InkList")) {
                                            if (this.currentField.containsKey("AP")) {
                                                this.commandAP((Map)this.currentPdfFile.resolveToMapOrString("AP", this.currentField.get("AP")), formObject);
                                            }
                                            if (formObject.hasNormalOff()) continue;
                                            this.commandInkList(object3, formObject);
                                            continue;
                                        }
                                        if (!string.equals("Popup")) continue;
                                        this.commandPopup(object3, formObject);
                                    }
                                    break block69;
                                }
                                if (!object.equals("/Square")) break block71;
                                formObject.setType(12);
                                this.createOrderedCommandArray();
                                for (int i = 0; i < this.commands.length; ++i) {
                                    boolean bl;
                                    String string = this.commands[i];
                                    Object object4 = this.currentPdfFile.resolveToMapOrString(string, this.currentField.get(string));
                                    if (string.equals("Type")) {
                                        if (!object4.equals("/Annot")) continue;
                                        continue;
                                    }
                                    if (string.equals("Subtype")) continue;
                                    if (string.equals("Rect")) {
                                        this.createBoundsRectangle((String)object4, formObject);
                                        continue;
                                    }
                                    if (string.equals("AP")) {
                                        bl = this.commandAP((Map)object4, formObject);
                                        if (bl) continue;
                                    }
                                    if (string.equals("C")) {
                                        bl = this.commandC(formObject, object4);
                                        if (bl) continue;
                                    }
                                    if (string.equals("F")) {
                                        this.workOutCharachteristic((String)object4, formObject);
                                        continue;
                                    }
                                    if (string.equals("T")) {
                                        formObject.setPopupTitle((String)object4);
                                        continue;
                                    }
                                    if (string.equals("M") || string.equals("CreationDate")) continue;
                                    if (string.equals("NM")) {
                                        this.commandNM(formObject, object4);
                                        continue;
                                    }
                                    if (string.equals("Subj")) continue;
                                    if (string.equals("PageNumber")) {
                                        formObject.setPageNumber(object4);
                                        continue;
                                    }
                                    if (string.equals("Popup")) {
                                        this.commandPopup(object4, formObject);
                                        continue;
                                    }
                                    if (!string.equals("RD")) continue;
                                    this.commandRD(object4, formObject);
                                }
                                break block69;
                            }
                            if (!object.equals("/FreeText")) break block72;
                            formObject.setType(14);
                            this.createOrderedCommandArray();
                            for (int i = 0; i < this.commands.length; ++i) {
                                String string = this.commands[i];
                                Object object5 = this.currentPdfFile.resolveToMapOrString(string, this.currentField.get(string));
                                if (string.equals("Type")) {
                                    if (!object5.equals("/Annot")) continue;
                                    continue;
                                }
                                if (string.equals("Subtype")) continue;
                                if (string.equals("Rect")) {
                                    this.createBoundsRectangle((String)object5, formObject);
                                    continue;
                                }
                                if (string.equals("AP")) {
                                    boolean bl = this.commandAP((Map)object5, formObject);
                                    if (bl) continue;
                                }
                                if (string.equals("C")) {
                                    boolean bl = this.commandC(formObject, object5);
                                    if (bl) continue;
                                }
                                if (string.equals("F")) {
                                    this.workOutCharachteristic((String)object5, formObject);
                                    continue;
                                }
                                if (string.equals("T")) {
                                    formObject.setPopupTitle((String)object5);
                                    continue;
                                }
                                if (string.equals("M") || string.equals("CreationDate")) continue;
                                if (string.equals("NM")) {
                                    this.commandNM(formObject, object5);
                                    continue;
                                }
                                if (string.equals("Subj")) continue;
                                if (string.equals("PageNumber")) {
                                    formObject.setPageNumber(object5);
                                    continue;
                                }
                                if (string.equals("DS")) continue;
                                if (string.equals("Contents")) {
                                    boolean bl = this.commandContents(formObject, object5);
                                    if (bl) continue;
                                }
                                if (string.equals("RC")) {
                                    this.commandRC(object5, formObject);
                                    continue;
                                }
                                if (string.equals("DA")) {
                                    formObject.setDefaultValue((String)object5);
                                    continue;
                                }
                                if (string.equals("Open")) {
                                    formObject.setOpenState(Boolean.valueOf((String)object5));
                                    continue;
                                }
                                if (string.equals("BS")) {
                                    formObject.setBorder(object5);
                                    continue;
                                }
                                if (string.equals("IT") || !string.equals("RD")) continue;
                                StringTokenizer stringTokenizer = new StringTokenizer((String)object5, "[ ]");
                                int n = new Double(stringTokenizer.nextToken()).intValue();
                                int n2 = new Double(stringTokenizer.nextToken()).intValue();
                                int n3 = new Double(stringTokenizer.nextToken()).intValue();
                                int n4 = new Double(stringTokenizer.nextToken()).intValue();
                                Rectangle rectangle = formObject.Rect;
                                rectangle.x += n;
                                rectangle.y += n2;
                                rectangle.width += n + n3;
                                rectangle.height += n2 + n4;
                                formObject.setBoundingRectangle(rectangle);
                            }
                            break block69;
                        }
                        if (!object.equals("/Link")) break block73;
                        formObject.setType(15);
                        this.createOrderedCommandArray();
                        for (int i = 0; i < this.commands.length; ++i) {
                            String string = this.commands[i];
                            Object object6 = this.currentPdfFile.resolveToMapOrString(string, this.currentField.get(string));
                            if (string.equals("Type")) {
                                if (object6.equals("/Annot") || !object6.equals("/Action")) continue;
                                continue;
                            }
                            if (string.equals("Subtype")) continue;
                            if (string.equals("Rect")) {
                                this.createBoundsRectangle((String)object6, formObject);
                                continue;
                            }
                            if (string.equals("PageNumber")) {
                                formObject.setPageNumber(object6);
                                continue;
                            }
                            if (string.equals("StructParent")) continue;
                            if (string.equals("A")) {
                                this.commandA(object6, formObject);
                                continue;
                            }
                            if (string.equals("H")) {
                                this.commandH(object6, formObject);
                                continue;
                            }
                            if (string.equals("Border")) {
                                this.commandBorder(object6);
                                continue;
                            }
                            if (string.equals("BS")) {
                                formObject.setBorder(object6);
                                continue;
                            }
                            if (string.equals("C")) {
                                this.commandC(formObject, object6);
                                continue;
                            }
                            if (string.equals("Dest")) {
                                LogWriter.writeFormLog("{AnnotStream.parseStream} Dest command in Link NOTIMPLEMENTED", false);
                                continue;
                            }
                            if (!string.equals("M")) continue;
                        }
                        break block69;
                    }
                    if (!object.equals("/Widget")) break block74;
                    super.parseStream(formObject);
                    super.decodeStream(formObject);
                    break block69;
                }
                if (!object.equals("/Highlight")) break block75;
                LogWriter.writeFormLog("{AnnotStream.parseStream} Highlight command NOT IMPLEMENTED", false);
                break block69;
            }
            if (!object.equals("/Stamp")) break block69;
            formObject.setType(16);
            this.createOrderedCommandArray();
            for (int i = 0; i < this.commands.length; ++i) {
                String string = this.commands[i];
                Object object7 = this.currentPdfFile.resolveToMapOrString(string, this.currentField.get(string));
                if (string.equals("Type")) {
                    if (!object7.equals("/Annot")) continue;
                    continue;
                }
                if (string.equals("Subtype")) continue;
                if (string.equals("Rect")) {
                    this.createBoundsRectangle((String)object7, formObject);
                    continue;
                }
                if (string.equals("Popup")) {
                    this.createPopupComponent((Map)object7, formObject, this.pageHeight, this.insetH);
                    continue;
                }
                if (string.equals("C")) {
                    this.commandC(formObject, object7);
                    continue;
                }
                if (string.equals("M")) continue;
                if (string.equals("F")) {
                    this.workOutCharachteristic((String)object7, formObject);
                    continue;
                }
                if (string.equals("T")) {
                    formObject.setPopupTitle((String)object7);
                    continue;
                }
                if (string.equals("Subj") || string.equals("Name")) continue;
                if (string.equals("NM")) {
                    this.commandNM(formObject, object7);
                    continue;
                }
                if (string.equals("CreationDate") || !string.equals("AP")) continue;
                this.commandAP((Map)object7, formObject);
            }
        }
    }

    private void commandBorder(Object object) {
        if (this.currentField.containsKey("BS")) {
            return;
        }
        object = Strip.removeArrayDeleminators((String)object);
        StringTokenizer stringTokenizer = new StringTokenizer((String)object);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        try {
            f = Float.parseFloat(stringTokenizer.nextToken());
            f2 = Float.parseFloat(stringTokenizer.nextToken());
            f3 = Float.parseFloat(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            LogWriter.writeFormLog("Border in annot.parsestream Link NOT numbers", false);
            return;
        }
        if (f3 == 0.0f) {
            return;
        }
        if (f == 0.0f && f2 == 0.0f) {
            LogWriter.writeFormLog("{AnnotStream.commandBorder} squared border NOT IMPLEMENTED", false);
        } else {
            LogWriter.writeFormLog("{AnnotStream.commandBorder} create rounded rectangle border NOT IMPLEMENTED", false);
        }
        if (stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().startsWith("[")) {
            LogWriter.writeFormLog("{AnnotStream.commandBorder} dash array NOT IMPLEMENTED", false);
        }
    }

    private void createOrderedCommandArray() {
        Iterator iterator = this.currentField.keySet().iterator();
        this.keySize = this.currentField.keySet().size();
        this.commands = new String[this.keySize];
        int n = this.keySize - 1;
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("AP")) {
                this.commands[n] = string;
                --n;
                continue;
            }
            this.commands[n2] = string;
            ++n2;
        }
    }

    private void commandRC(Object object, FormObject formObject) {
    }

    private void commandPopup(Object object, FormObject formObject) {
        HashMap<String, Component> hashMap = new HashMap<String, Component>();
        Component component = this.createPopupComponent((Map)object, formObject, this.pageHeight, this.insetH);
        if (component != null) {
            hashMap.put("Popup", component);
            formObject.setActivateAction(hashMap);
        }
    }

    private boolean commandC(FormObject formObject, Object object) {
        Color color = this.generateColorFromString((String)object);
        if (color != null) {
            formObject.setCColor(color);
            return true;
        }
        return false;
    }

    private boolean commandContents(FormObject formObject, Object object) {
        if (object instanceof String) {
            formObject.setContents((String)object);
            return true;
        }
        LogWriter.writeFormLog("{stream} Contents command is NON String field=" + object, false);
        return false;
    }

    private Component createPopupComponent(Map map, FormObject formObject, int n, int n2) {
        JTextField jTextField = null;
        String string = formObject.popupTitle == null ? "TEST popupTitle not set in formobject" : formObject.popupTitle;
        jTextField = new JTextField(string);
        Rectangle rectangle = this.createBoundsRectangle((String)this.currentPdfFile.resolveToMapOrString("Rect", map.get("Rect")), null);
        rectangle.y = n - rectangle.y - rectangle.height + n2;
        jTextField.setBounds(rectangle);
        ((Component)jTextField).setVisible(Boolean.valueOf((String)this.currentPdfFile.resolveToMapOrString("Open", map.get("Open"))));
        return jTextField;
    }

    protected void decodeStream(FormObject formObject) {
        for (int i = 0; i < this.keySize; ++i) {
            String string = this.commands[i];
            Object object = this.currentPdfFile.resolveToMapOrString(string, this.currentField.get(string));
            boolean bl = this.decodeFormCommand(string, object, formObject);
            if (!bl) continue;
            this.decodeAnnotCommand(string, object, formObject);
        }
    }

    protected boolean decodeAnnotCommand(String string, Object object, FormObject formObject) {
        boolean bl = false;
        if (string.equals("InkList")) {
            PdfShape pdfShape = new PdfShape();
            String string2 = Strip.removeArrayDeleminators((String)object);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "[] ", true);
            boolean bl2 = false;
            String string3 = null;
            String string4 = null;
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                if (string5.equals("[")) {
                    bl2 = true;
                    continue;
                }
                if (string5.equals("]") || string5.equals(" ")) continue;
                if (string3 == null) {
                    string3 = string5;
                    continue;
                }
                string4 = string5;
                if (bl2) {
                    pdfShape.moveTo(Float.parseFloat(string3) - (float)formObject.Rect.x, Float.parseFloat(string4) - (float)formObject.Rect.y);
                    bl2 = false;
                } else {
                    pdfShape.lineTo(Float.parseFloat(string3) - (float)formObject.Rect.x, Float.parseFloat(string4) - (float)formObject.Rect.y);
                }
                string3 = null;
            }
            GraphicsState graphicsState = formObject.getGraphicsState();
            Shape shape = pdfShape.generateShapeFromPath(null, graphicsState.CTM, false, null, false, null, graphicsState.getLineWidth(), 0.0f);
            Stroke stroke = graphicsState.getStroke();
            BufferedImage bufferedImage = new BufferedImage(formObject.Rect.width, formObject.Rect.height, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setStroke(stroke);
            graphics2D.setColor(Color.red);
            graphics2D.scale(1.0, -1.0);
            graphics2D.translate(0, -bufferedImage.getHeight());
            graphics2D.draw(shape);
            graphics2D.dispose();
            formObject.setNormalAppOff(bufferedImage, null);
        } else if (string.equals("RD")) {
            StringTokenizer stringTokenizer = new StringTokenizer(Strip.removeArrayDeleminators((String)object));
            float f = Float.parseFloat(stringTokenizer.nextToken());
            float f2 = Float.parseFloat(stringTokenizer.nextToken());
            float f3 = Float.parseFloat(stringTokenizer.nextToken());
            float f4 = Float.parseFloat(stringTokenizer.nextToken());
            formObject.setInternalBounds(f, f2, f3, f4);
        } else {
            bl = true;
        }
        return bl;
    }

    private void commandRD(Object object, FormObject formObject) {
        StringTokenizer stringTokenizer = new StringTokenizer(Strip.removeArrayDeleminators((String)object));
        float f = Float.parseFloat(stringTokenizer.nextToken());
        float f2 = Float.parseFloat(stringTokenizer.nextToken());
        float f3 = Float.parseFloat(stringTokenizer.nextToken());
        float f4 = Float.parseFloat(stringTokenizer.nextToken());
        formObject.setInternalBounds(f, f2, f3, f4);
    }

    private void commandInkList(Object object, FormObject formObject) {
        PdfShape pdfShape = new PdfShape();
        String string = Strip.removeArrayDeleminators((String)object);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ", true);
        int n = 0;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("[")) {
                ++n;
                bl = true;
                continue;
            }
            if (string4.equals("]")) {
                --n;
                continue;
            }
            if (string4.equals(" ")) continue;
            if (string2 == null) {
                string2 = string4;
                continue;
            }
            string3 = string4;
            if (bl) {
                pdfShape.moveTo(Float.parseFloat(string2) - (float)formObject.Rect.x, Float.parseFloat(string3) - (float)formObject.Rect.y);
                bl = false;
            } else {
                pdfShape.lineTo(Float.parseFloat(string2) - (float)formObject.Rect.x, Float.parseFloat(string3) - (float)formObject.Rect.y);
            }
            string2 = null;
        }
        GraphicsState graphicsState = formObject.getGraphicsState();
        Shape shape = pdfShape.generateShapeFromPath(null, graphicsState.CTM, false, null, false, null, graphicsState.getLineWidth(), 0.0f);
        Stroke stroke = graphicsState.getStroke();
        BufferedImage bufferedImage = new BufferedImage(formObject.Rect.width, formObject.Rect.height, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setStroke(stroke);
        graphics2D.setColor(Color.red);
        graphics2D.scale(1.0, -1.0);
        graphics2D.translate(0, -bufferedImage.getHeight());
        graphics2D.draw(shape);
        graphics2D.dispose();
        formObject.setNormalAppOff(bufferedImage, null);
    }
}

