/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;

public class MergeMap
implements Map {
    private Stack order = new Stack();
    private Map id2map = new HashMap();
    private static final String BASE = "__BASE";

    public MergeMap(String currID) {
        this.push(currID);
    }

    public MergeMap(String currId, Map everpresent) {
        this.order.push(BASE);
        this.id2map.put(BASE, everpresent);
        this.push(currId);
    }

    public Map push(String id) {
        if (this.order.contains(id)) {
            throw new RuntimeException(id + " already present");
        }
        if (!this.order.isEmpty() && id.equals(this.order.peek())) {
            return (Map)this.id2map.get(id);
        }
        HashMap result = (HashMap)this.id2map.get(id);
        if (result == null) {
            result = new HashMap();
            this.id2map.put(id, result);
        }
        this.order.push(id);
        return result;
    }

    public String currID() {
        return (String)this.order.peek();
    }

    public String popAndCalve() {
        if (this.order.size() == 1) {
            throw new NoSuchElementException("Cannot back out past first entry");
        }
        String result = (String)this.order.peek();
        Map curr = (Map)this.id2map.get(result);
        this.order.pop();
        Set keysForCurr = curr.keySet();
        Iterator i = this.orderIterator();
        while (i.hasNext()) {
            Map other = (Map)this.id2map.get(i.next());
            Iterator j = curr.keySet().iterator();
            while (j.hasNext()) {
                Object key = j.next();
                if (!other.containsKey(key)) continue;
                other.put(key, curr.get(key));
            }
        }
        return result;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object obj) {
        Iterator i = this.orderIterator();
        while (i.hasNext()) {
            Map curr = (Map)this.id2map.get(i.next());
            if (!curr.containsKey(obj)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object obj) {
        Iterator i = this.orderIterator();
        while (i.hasNext()) {
            Map curr = (Map)this.id2map.get(i.next());
            if (!curr.containsValue(obj)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        HashSet result = new HashSet();
        Iterator i = this.orderIterator();
        while (i.hasNext()) {
            Map curr = (Map)this.id2map.get(i.next());
            result.addAll(curr.entrySet());
        }
        return result;
    }

    public Object get(Object obj) {
        Iterator i = this.orderIterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            Map curr = (Map)this.id2map.get(id);
            Object result = curr.get(obj);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        HashSet result = new HashSet();
        Iterator i = this.orderIterator();
        while (i.hasNext()) {
            Map curr = (Map)this.id2map.get(i.next());
            result.addAll(curr.keySet());
        }
        return result;
    }

    public Object put(Object obj, Object obj1) {
        Map curr = (Map)this.id2map.get(this.order.peek());
        return curr.put(obj, obj1);
    }

    public void putAll(Map map) {
        Map curr = (Map)this.id2map.get(this.order.peek());
        curr.putAll(map);
    }

    private Object doRemove(Object obj) {
        Object result;
        block1: {
            Map curr = (Map)this.id2map.get(this.order.peek());
            result = curr.remove(obj);
            if (result != null) break block1;
            Iterator i = this.orderIterator();
            while (i.hasNext() && (result = (curr = (Map)this.id2map.get(i.next())).remove(obj)) == null) {
            }
        }
        return result;
    }

    public Object remove(Object obj) {
        Object result = this.get(obj);
        while (this.get(obj) != null) {
            this.doRemove(obj);
        }
        return result;
    }

    public int size() {
        return this.keySet().size();
    }

    public Collection values() {
        HashSet<Object> result = new HashSet<Object>();
        Set keys = this.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            result.add(this.get(i.next()));
        }
        return result;
    }

    private Iterator orderIterator() {
        return new ReverseIterator(this.order);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            sb.append('[');
            sb.append(key);
            sb.append('=');
            sb.append(this.get(key));
            sb.append(']');
            if (!i.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private static final class ReverseIterator
    implements Iterator {
        private int pos;
        private List l;

        public ReverseIterator(Stack s) {
            this.pos = s.size() - 1;
            this.l = new ArrayList(s);
        }

        public boolean hasNext() {
            return this.pos != -1;
        }

        public Object next() {
            if (this.pos < 0) {
                throw new NoSuchElementException();
            }
            Object result = this.l.get(this.pos);
            --this.pos;
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

