/*
 * Decompiled with CFR 0.152.
 */
package org.posterita.core;

import java.applet.Applet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jpedal.PdfDecoder;

public class PrintOrderApplet
extends Applet
implements Runnable,
ItemListener {
    private static final long serialVersionUID = 1L;
    private String printerName = null;
    private byte[] _printData = null;
    private String _dataURL = null;
    private String _dataContentType = null;
    private JComboBox cmbPrintServices;
    private PrintService[] pServices;
    private JTextField txtUrl;

    public void init() {
        this.pServices = this.getPrintServices();
        this.cmbPrintServices = new JComboBox();
        this.cmbPrintServices.setSize(100, 20);
        this.cmbPrintServices.addItemListener(this);
        for (int i = 0; i < this.pServices.length; ++i) {
            this.cmbPrintServices.addItem(this.pServices[i].getName());
        }
        this.add(this.cmbPrintServices);
        if ((long)this.pServices.length == 0L) {
            this.cmbPrintServices.addItem("No Printers found on the system");
        }
        JLabel lbl = new JLabel();
        this.add(lbl);
        this.txtUrl = new JTextField(40);
        this.add(this.txtUrl);
        JButton btn = new JButton("Print");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String url = PrintOrderApplet.this.txtUrl.getText();
                PrintOrderApplet.this.printURL(url);
            }
        });
        this.add(btn);
    }

    public void itemStateChanged(ItemEvent e) {
        String pName = (String)e.getItem();
        if (e.getStateChange() == 1) {
            this.printerName = pName;
        }
    }

    public void run() {
        PrintService printService = this.getPrintService(this.printerName);
        if (printService == null) {
            System.out.println("Could not get printer with name: " + this.printerName);
            System.out.println("Taking default print service");
            printService = this.getDefaultPrintService();
        }
        if (printService == null) {
            System.out.println("No printers found");
            return;
        }
        boolean isDataReady = this.loadPrintData();
        if (isDataReady) {
            this.printData(printService);
        } else {
            System.out.println("Unable to print data.");
        }
    }

    private String getValidatedPrinterName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.startsWith("IPP") || name.startsWith("Win32")) {
            int index = name.indexOf(":");
            name = name.substring(index + 1, name.length());
            name = name.trim();
        }
        return name;
    }

    private PrintService getPrintService(String name) {
        PrintService pService = null;
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        name = this.getValidatedPrinterName(name);
        PrintService[] pServices = this.getPrintServices();
        for (int i = 0; i < pServices.length; ++i) {
            String pServiceName = pServices[i].getName();
            if (!name.equalsIgnoreCase(pServiceName = this.getValidatedPrinterName(pServiceName))) continue;
            pService = pServices[i];
            break;
        }
        return pService;
    }

    private PrintService getDefaultPrintService() {
        return PrintServiceLookup.lookupDefaultPrintService();
    }

    private PrintService[] getPrintServices() {
        if (this.pServices != null && this.pServices.length > 0) {
            return this.pServices;
        }
        return PrintServiceLookup.lookupPrintServices(null, null);
    }

    private boolean loadPrintData() {
        try {
            int len;
            URL url = new URL(this._dataURL);
            System.out.println("Connecting to :" + this._dataURL);
            URLConnection conn = url.openConnection();
            this._dataContentType = conn.getContentType();
            BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            System.out.println("Reading ......");
            byte[] buf = new byte[1024];
            while ((len = bis.read(buf)) > 0) {
                bos.write(buf, 0, len);
            }
            bis.close();
            bos.flush();
            bos.close();
            System.out.println("Reading completed successfully");
            this._printData = bos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean printData(PrintService printService) {
        try {
            SimpleDoc doc;
            System.out.println("Printing data as:" + this._dataContentType);
            if (this._dataContentType.equalsIgnoreCase("application/pdf")) {
                PdfDecoder decodePDF = new PdfDecoder(true);
                decodePDF.openPdfArray(this._printData);
                decodePDF.setPagePrintRange(1, decodePDF.getPageCount());
                decodePDF.setUsePDFPaperSize(true);
                doc = new SimpleDoc(decodePDF, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
            } else {
                doc = new SimpleDoc(this._printData, DocFlavor.BYTE_ARRAY.AUTOSENSE, null);
            }
            DocPrintJob job = printService.createPrintJob();
            job.print(doc, new HashPrintRequestAttributeSet());
            System.out.println("Job sent to printer succesfully");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void printURL(String url) {
        this._dataURL = url;
        System.out.println("Printing URL: " + url);
        Thread thread = new Thread(this);
        thread.start();
    }

    public String getPrintersForJS() {
        if (this.pServices == null || this.pServices.length == 0) {
            return "No printers found, check settings";
        }
        String printers = "";
        for (int i = 0; i < this.pServices.length - 1; ++i) {
            printers = printers + this.pServices[i].getName() + "###";
        }
        printers = printers + this.pServices[this.pServices.length - 1];
        return printers;
    }

    public String getPrinterName() {
        return this.printerName;
    }

    public void setPrinterName(String printerName) {
        this.printerName = printerName;
    }
}

