/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.jpedal.color.PdfTexturePaint;
import org.jpedal.fonts.glyph.T1Glyph;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.repositories.Vector_Path;

public class Vector_Object
implements Serializable {
    int increment_size = 1000;
    protected int current_item = 0;
    int max_size = 250;
    private static final Integer GENERIC = new Integer(1);
    private static final Integer BASICSTROKE = new Integer(2);
    private static final Integer BUFFERED_IMAGE = new Integer(3);
    private static final Integer GENERAL_PATH = new Integer(4);
    private static final Integer T1GLYPH = new Integer(5);
    private static final Integer TTGLYPH = new Integer(6);
    private static final Integer AREA = new Integer(7);
    private static final Integer RECT = new Integer(8);
    private static final Integer T3GLYPH = new Integer(9);
    private static final Integer TEXTUREDPAINT = new Integer(10);
    private Object[] items = new Object[this.max_size];
    private int checkPoint = -1;

    public Vector_Object() {
    }

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1) {
            this.current_item = this.checkPoint = this.current_item;
        }
    }

    protected int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 16000 ? (increment_size *= 2) : (increment_size += 2000));
        return increment_size;
    }

    public Vector_Object(int number) {
        this.max_size = number;
        this.items = new Object[this.max_size];
    }

    public final Object[] get() {
        return this.items;
    }

    public final Object pull() {
        if (this.current_item > 0) {
            --this.current_item;
        }
        return this.items[this.current_item];
    }

    public final void push(Object value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final boolean contains(Object value) {
        boolean flag = false;
        int i = 0;
        while (i < this.current_item) {
            if (this.items[i].equals(value)) {
                i = this.current_item + 1;
                flag = true;
            }
            ++i;
        }
        return flag;
    }

    public final void addElement(Object value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final void setElementAt(Object new_name, int id) {
        if (id >= this.max_size) {
            this.checkSize(id);
        }
        this.items[id] = new_name;
    }

    public final Object elementAt(int id) {
        if (id >= this.max_size) {
            return null;
        }
        return this.items[id];
    }

    public final void set(Object[] new_items) {
        this.items = new_items;
    }

    public final void clear() {
        this.checkPoint = -1;
        if (this.current_item > 0) {
            int i = 0;
            while (i < this.current_item) {
                this.items[i] = null;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.max_size) {
                this.items[i] = null;
                ++i;
            }
        }
        this.current_item = 0;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void removeElementAt(int id) {
        if (id >= 0) {
            System.arraycopy(this.items, id + 1, this.items, id, this.current_item - 1 - id);
            this.items[this.current_item - 1] = null;
        } else {
            this.items[0] = null;
        }
        --this.current_item;
    }

    private void checkSize(int i) {
        if (i >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i) {
                this.max_size = i + this.increment_size + 2;
            }
            Object[] temp = this.items;
            this.items = new Object[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = this.incrementSize(this.increment_size);
        }
    }

    public void writeToStream(ByteArrayOutputStream bos) throws IOException {
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(new Integer(this.max_size));
        int basicStrokes = 0;
        int bufferedImages = 0;
        int paints = 0;
        int generalPaths = 0;
        int t3glyphs = 0;
        int t1glyphs = 0;
        int ttglyphs = 0;
        int areas = 0;
        int generics = 0;
        int nullGenerics = 0;
        int totalGeneric = 0;
        int i = 0;
        while (i < this.max_size) {
            Object nextObj = this.items[i];
            if (nextObj instanceof BasicStroke) {
                ++basicStrokes;
                os.writeObject(BASICSTROKE);
                BasicStroke stroke = (BasicStroke)this.items[i];
                os.writeFloat(stroke.getLineWidth());
                os.writeInt(stroke.getEndCap());
                os.writeInt(stroke.getLineJoin());
                os.writeFloat(stroke.getMiterLimit());
                os.writeObject(stroke.getDashArray());
                os.writeFloat(stroke.getDashPhase());
            } else if (nextObj instanceof Rectangle2D) {
                ++basicStrokes;
                os.writeObject(RECT);
                Rectangle2D rect = (Rectangle2D)this.items[i];
                os.writeDouble(rect.getBounds2D().getX());
                os.writeDouble(rect.getBounds2D().getY());
                os.writeDouble(rect.getBounds2D().getWidth());
                os.writeDouble(rect.getBounds2D().getHeight());
            } else if (nextObj instanceof BufferedImage) {
                ++bufferedImages;
                os.writeObject(BUFFERED_IMAGE);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((BufferedImage)nextObj), "png", baos);
                os.writeObject(baos.toByteArray());
            } else if (nextObj instanceof GeneralPath) {
                ++generalPaths;
                os.writeObject(GENERAL_PATH);
                PathSerializer.serializePath(os, ((GeneralPath)this.items[i]).getPathIterator(new AffineTransform()));
            } else if (nextObj instanceof T1Glyph) {
                ++t1glyphs;
                os.writeObject(T1GLYPH);
                ((T1Glyph)nextObj).flushArea();
                os.writeObject(nextObj);
                ((T1Glyph)nextObj).writePathsToStream(os);
            } else if (nextObj instanceof TTGlyph) {
                ++ttglyphs;
                os.writeObject(TTGLYPH);
                ((TTGlyph)nextObj).flushArea();
                os.writeObject(nextObj);
                ((TTGlyph)nextObj).writePathsToStream(os);
            } else if (nextObj instanceof T3Glyph) {
                ++t3glyphs;
                os.writeObject(T3GLYPH);
                ((T3Glyph)nextObj).writePathsToStream(os);
            } else if (nextObj instanceof PdfTexturePaint) {
                ++paints;
                os.writeObject(TEXTUREDPAINT);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((PdfTexturePaint)nextObj).getImage(), "png", baos);
                os.writeObject(baos.toByteArray());
                Rectangle2D rect = ((PdfTexturePaint)nextObj).getAnchorRect();
                os.writeDouble(rect.getBounds2D().getX());
                os.writeDouble(rect.getBounds2D().getY());
                os.writeDouble(rect.getBounds2D().getWidth());
                os.writeDouble(rect.getBounds2D().getHeight());
            } else if (nextObj instanceof Area) {
                ++areas;
                os.writeObject(AREA);
                Area area = (Area)this.items[i];
                PathIterator pathIterator = area.getPathIterator(new AffineTransform());
                PathSerializer.serializePath(os, pathIterator);
            } else {
                if (nextObj == null) {
                    ++nullGenerics;
                } else {
                    ++generics;
                }
                try {
                    int start = bos.size();
                    os.writeObject(GENERIC);
                    os.writeObject(nextObj);
                    int end = bos.size();
                    totalGeneric += end - start;
                }
                catch (Exception e) {
                    System.err.println("nextObj = " + nextObj);
                    e.printStackTrace();
                }
            }
            ++i;
        }
        os.close();
    }

    public void restoreFromStream(ByteArrayInputStream bis) throws IOException, ClassNotFoundException {
        int size;
        ObjectInputStream os = new ObjectInputStream(bis);
        this.max_size = size = ((Integer)os.readObject()).intValue();
        this.items = new Object[size];
        Object nextObject = null;
        Integer type = null;
        int i = 0;
        while (i < size) {
            type = (Integer)os.readObject();
            if (type.compareTo(BASICSTROKE) == 0) {
                float w = os.readFloat();
                int current_line_cap_style = os.readInt();
                int current_line_join_style = os.readInt();
                float mitre_limit = os.readFloat();
                float[] current_line_dash_array = (float[])os.readObject();
                float current_line_dash_phase = os.readFloat();
                nextObject = new BasicStroke(w, current_line_cap_style, current_line_join_style, mitre_limit, current_line_dash_array, current_line_dash_phase);
            } else if (type.compareTo(RECT) == 0) {
                double x = os.readDouble();
                double y = os.readDouble();
                double w = os.readDouble();
                double h = os.readDouble();
                nextObject = new Rectangle2D.Double(x, y, w, h);
            } else if (type.compareTo(BUFFERED_IMAGE) == 0) {
                byte[] bytes = (byte[])os.readObject();
                nextObject = ImageIO.read(new ByteArrayInputStream(bytes));
            } else if (type.compareTo(GENERAL_PATH) == 0) {
                nextObject = PathSerializer.deserializePath(os);
            } else if (type.compareTo(T1GLYPH) == 0) {
                T1Glyph glyph = (T1Glyph)os.readObject();
                int count = (Integer)os.readObject();
                GeneralPath[] paths = new GeneralPath[count];
                int j = 0;
                while (j < count) {
                    paths[j] = PathSerializer.deserializePath(os);
                    ++j;
                }
                Vector_Path vp = new Vector_Path();
                vp.set(paths);
                vp.setCurrent_item(paths.length);
                glyph.setPaths(vp);
                nextObject = glyph;
            } else if (type.compareTo(TTGLYPH) == 0) {
                TTGlyph glyph = (TTGlyph)os.readObject();
                int count = (Integer)os.readObject();
                GeneralPath[] paths = new GeneralPath[count];
                int j = 0;
                while (j < count) {
                    paths[j] = PathSerializer.deserializePath(os);
                    ++j;
                }
                Vector_Path vp = new Vector_Path();
                vp.set(paths);
                vp.setCurrent_item(paths.length);
                glyph.setPaths(vp);
                nextObject = glyph;
            } else if (type.compareTo(T3GLYPH) == 0) {
                nextObject = new T3Glyph(os);
            } else if (type.compareTo(TEXTUREDPAINT) == 0) {
                byte[] bytes = (byte[])os.readObject();
                BufferedImage img = ImageIO.read(new ByteArrayInputStream(bytes));
                double x = os.readDouble();
                double y = os.readDouble();
                double w = os.readDouble();
                double h = os.readDouble();
                Rectangle2D.Double anchor = new Rectangle2D.Double(x, y, w, h);
                nextObject = new PdfTexturePaint(img, anchor);
            } else if (type.compareTo(AREA) == 0) {
                GeneralPath path = PathSerializer.deserializePath(os);
                nextObject = new Area(path);
            } else {
                nextObject = os.readObject();
            }
            this.items[i] = nextObject;
            ++i;
        }
    }

    public void trim() {
        Object[] newItems = new Object[this.current_item];
        System.arraycopy(this.items, 0, newItems, 0, this.current_item);
        this.items = newItems;
        this.max_size = this.current_item;
    }

    public void setSize(int currentItem) {
        this.current_item = currentItem;
    }
}

