/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;

public class Vector_Double
implements Serializable {
    int increment_size = 1000;
    protected int current_item = 0;
    int max_size = 250;
    private double[] items = new double[this.max_size];
    private int checkPoint = -1;

    public Vector_Double() {
    }

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1) {
            this.current_item = this.checkPoint = this.current_item;
        }
    }

    protected int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 16000 ? (increment_size *= 2) : (increment_size += 2000));
        return increment_size;
    }

    public Vector_Double(int number) {
        this.max_size = number;
        this.items = new double[this.max_size];
    }

    public final double[] get() {
        return this.items;
    }

    public final void removeElementAt(int id) {
        if (id >= 0) {
            System.arraycopy(this.items, id + 1, this.items, id, this.current_item - 1 - id);
            this.items[this.current_item - 1] = 0.0;
        } else {
            this.items[0] = 0.0;
        }
        --this.current_item;
    }

    public final boolean contains(int value) {
        boolean flag = false;
        int i = 0;
        while (i < this.current_item) {
            if (this.items[i] == (double)value) {
                i = this.current_item + 1;
                flag = true;
            }
            ++i;
        }
        return flag;
    }

    public final void addElement(double value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final void set(double[] new_items) {
        this.items = new_items;
    }

    public final double elementAt(int id) {
        if (id >= this.max_size) {
            return 0.0;
        }
        return this.items[id];
    }

    public final void clear() {
        this.checkPoint = -1;
        if (this.current_item > 0) {
            int i = 0;
            while (i < this.current_item) {
                this.items[i] = 0.0;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.max_size) {
                this.items[i] = 0.0;
                ++i;
            }
        }
        this.current_item = 0;
    }

    public final double pull() {
        if (this.current_item > 0) {
            --this.current_item;
        }
        return this.items[this.current_item];
    }

    public final void push(double value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void setElementAt(double new_name, int id) {
        if (id >= this.max_size) {
            this.checkSize(id);
        }
        this.items[id] = new_name;
    }

    private final void checkSize(int i) {
        if (i >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i) {
                this.max_size = i + this.increment_size + 2;
            }
            double[] temp = this.items;
            this.items = new double[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = this.incrementSize(this.increment_size);
        }
    }

    public void trim() {
        double[] newItems = new double[this.current_item];
        System.arraycopy(this.items, 0, newItems, 0, this.current_item);
        this.items = newItems;
        this.max_size = this.current_item;
    }

    public void setSize(int currentItem) {
        this.current_item = currentItem;
    }
}

