/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.util.StringTokenizer;
import org.jpedal.PdfDecoder;

public class Strip {
    private static final String strip_start_token_deliminator = "<&";
    private static final String strip_end_token_deliminator = ">;";

    public static StringBuffer stripXML(String raw_data) {
        if (raw_data == null) {
            return null;
        }
        return Strip.stripXML(new StringBuffer(raw_data));
    }

    public static StringBuffer stripXML(StringBuffer all_tags) {
        StringBuffer general_buffer = new StringBuffer();
        StringBuffer tag = new StringBuffer();
        if (all_tags == null) {
            return general_buffer;
        }
        if (PdfDecoder.isXMLExtraction()) {
            char next_token = 'x';
            char start = ' ';
            boolean inToken = false;
            int length = all_tags.length();
            boolean match = false;
            int i = 0;
            while (i < length) {
                next_token = all_tags.charAt(i);
                match = false;
                if (inToken && start == '&' && (next_token == '<' || next_token == '&')) {
                    general_buffer.append(tag);
                    tag = new StringBuffer();
                }
                if (strip_start_token_deliminator.indexOf(next_token) != -1) {
                    inToken = true;
                    start = next_token;
                    match = true;
                }
                if (inToken && start == '&' && next_token == ' ') {
                    inToken = false;
                    general_buffer.append('&');
                    tag = new StringBuffer();
                }
                if (!inToken) {
                    general_buffer.append(next_token);
                } else {
                    tag.append(next_token);
                }
                if (!match) {
                    int endPointer = strip_end_token_deliminator.indexOf(next_token);
                    if (endPointer == 1 & start == '&') {
                        if (tag.toString().equals("&lt;")) {
                            general_buffer.append('<');
                        } else if (tag.toString().equals("&gt;")) {
                            general_buffer.append('>');
                        }
                        inToken = false;
                        tag = new StringBuffer();
                    } else if (endPointer == 0 & start == '<') {
                        inToken = false;
                        tag = new StringBuffer();
                    } else if (next_token == '&') {
                        System.out.println(String.valueOf(next_token) + " " + start + ' ' + endPointer);
                        general_buffer.append('&');
                    }
                }
                ++i;
            }
        } else {
            general_buffer = all_tags;
        }
        general_buffer = Strip.trim(general_buffer);
        return general_buffer;
    }

    public static StringBuffer stripXMLArrows(StringBuffer all_tags) {
        StringBuffer general_buffer = new StringBuffer();
        StringBuffer tag = new StringBuffer();
        if (all_tags == null) {
            return general_buffer;
        }
        if (PdfDecoder.isXMLExtraction()) {
            char next_token = 'x';
            char start = ' ';
            boolean inToken = false;
            int length = all_tags.length();
            int i = 0;
            while (i < length) {
                next_token = all_tags.charAt(i);
                if (strip_start_token_deliminator.indexOf(next_token) != -1) {
                    inToken = true;
                    start = next_token;
                }
                if (!inToken) {
                    general_buffer.append(next_token);
                } else {
                    tag.append(next_token);
                }
                int endPointer = strip_end_token_deliminator.indexOf(next_token);
                if (endPointer == 1 & start == '&') {
                    if (!tag.toString().equals("&lt;") && !tag.toString().equals("&gt;")) {
                        general_buffer.append(tag);
                    }
                    inToken = false;
                    tag = new StringBuffer();
                } else if (endPointer == 0 & start == '<') {
                    inToken = false;
                    tag = new StringBuffer();
                }
                ++i;
            }
        } else {
            general_buffer = all_tags;
        }
        general_buffer = Strip.trim(general_buffer);
        return general_buffer;
    }

    public static final String removeArrayDeleminators(String value) {
        int c = 32;
        StringBuffer content_buffer = new StringBuffer(value);
        int length = content_buffer.length();
        int i = 0;
        while (i < length) {
            c = content_buffer.charAt(i);
            if (c == 91) {
                content_buffer.deleteCharAt(i);
                i = length;
            }
            ++i;
        }
        length = content_buffer.length();
        i = length - 1;
        while (i > -1) {
            c = content_buffer.charAt(i);
            if (c == 93) {
                content_buffer.deleteCharAt(i);
                i = -1;
            }
            --i;
        }
        return content_buffer.toString().trim();
    }

    public static final StringBuffer trim(StringBuffer content_buffer) {
        int c = 32;
        int length = content_buffer.length();
        int i = 0;
        while (i < length) {
            c = content_buffer.charAt(i);
            if (c == 32) {
                content_buffer.deleteCharAt(i);
                --i;
                if (--length == 0) {
                    break;
                }
            } else {
                i = length;
            }
            ++i;
        }
        String aa = content_buffer.toString();
        int i2 = 0;
        try {
            i2 = length - 1;
            while (i2 > -1) {
                c = content_buffer.charAt(i2);
                if (c == 32) {
                    content_buffer.deleteCharAt(i2);
                } else {
                    i2 = -1;
                }
                --i2;
            }
        }
        catch (Exception e) {
            System.out.println(String.valueOf(aa) + "<>" + content_buffer + "<>" + i2);
        }
        return content_buffer;
    }

    public static final String removeMultipleSpacesAndReturns(String data) {
        StringBuffer all_data = new StringBuffer(data);
        int i = 1;
        while (i < all_data.length()) {
            if (all_data.charAt(i) == ' ' & all_data.charAt(i - 1) == ' ' | all_data.charAt(i) == '\r' & all_data.charAt(i - 1) == '\r') {
                all_data.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        return all_data.toString();
    }

    public static final String stripSpaces(String data) {
        StringBuffer text = new StringBuffer(data);
        block0: while (text.length() > 0) {
            if (text.charAt(0) != ' ') break;
            text.deleteCharAt(0);
            int pointer2 = text.length() - 1;
            while (pointer2 > 0) {
                if (text.charAt(pointer2) != ' ') continue block0;
                text.deleteCharAt(pointer2);
                if (--pointer2 < 0) continue block0;
            }
        }
        return text.toString();
    }

    public static final String stripAllSpaces(String data) {
        StringBuffer text = new StringBuffer(data);
        int pointer2 = text.length() - 1;
        while (pointer2 > 0) {
            if (text.charAt(pointer2) == ' ') {
                text.deleteCharAt(pointer2);
            }
            if (--pointer2 < 0) break;
        }
        return text.toString();
    }

    public static final StringBuffer stripArrows(StringBuffer text) {
        int pointer2 = text.length() - 1;
        if (pointer2 >= 0) {
            do {
                if (text.charAt(pointer2) != '<' && text.charAt(pointer2) != '>') continue;
                text.deleteCharAt(pointer2);
            } while (--pointer2 >= 0);
        }
        return text;
    }

    public static final StringBuffer stripAllSpaces(StringBuffer text) {
        int pointer2 = text.length() - 1;
        while (pointer2 > 0) {
            if (text.charAt(pointer2) == ' ') {
                text.deleteCharAt(pointer2);
            }
            if (--pointer2 < 0) break;
        }
        return text;
    }

    public static final String convertToText(String input) {
        StringBuffer output_data = new StringBuffer();
        if (PdfDecoder.isXMLExtraction()) {
            String current_token = "";
            StringTokenizer data_As_tokens = new StringTokenizer(input, "<>", true);
            while (data_As_tokens.hasMoreTokens()) {
                String next_item = data_As_tokens.nextToken();
                if (next_item.equals("<") & data_As_tokens.hasMoreTokens()) {
                    current_token = String.valueOf(next_item) + data_As_tokens.nextToken() + data_As_tokens.nextToken();
                    if (!current_token.equals("<Space")) continue;
                    output_data.append('\t');
                    continue;
                }
                output_data.append(next_item);
            }
        } else {
            output_data = new StringBuffer(input);
        }
        return output_data.toString();
    }

    public static final String stripComment(String value) {
        if (value != null) {
            int pointer = value.indexOf("**");
            if (pointer > 0) {
                value = value.substring(0, pointer - 1).trim();
            }
            if (pointer == 0) {
                value = "";
            }
        }
        return value;
    }

    public static final String checkRemoveLeadingSlach(String command) {
        if (command != null && command.length() > 0 && command.charAt(0) == '/') {
            return command.substring(1);
        }
        return command;
    }

    public static StringBuffer stripAmpHash(StringBuffer current_text) {
        StringBuffer sb = new StringBuffer();
        boolean inEscape = false;
        int i = 0;
        while (i < current_text.length()) {
            char nextChar = current_text.charAt(i);
            if (inEscape) {
                if (nextChar == ';') {
                    inEscape = false;
                }
            } else if (nextChar == '&') {
                inEscape = true;
            } else {
                sb.append(nextChar);
            }
            ++i;
        }
        return sb;
    }

    public static boolean isEmptyLine(String line) {
        boolean isEmpty = true;
        int count = line.length();
        int i = 0;
        while (i < count) {
            if (line.charAt(i) != ' ') {
                isEmpty = false;
                i = count;
            }
            ++i;
        }
        return isEmpty;
    }
}

