/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.jpedal.utils.LogWriter;

public class Messages {
    private static Map messages = null;
    private static Map reportedValueMissing = new HashMap();
    protected static ResourceBundle bundle;
    private static boolean isInitialised;

    static {
        isInitialised = false;
    }

    public static void setBundle(ResourceBundle newBundle) {
        bundle = newBundle;
        if (!isInitialised) {
            Messages.init();
        }
    }

    public static String getMessage(String key) {
        String message = null;
        try {
            message = (String)messages.get(key);
            if (message == null) {
                message = bundle.getString(key);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (message == null) {
            try {
                message = (String)messages.get(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (message == null) {
            message = key;
        }
        if (message.length() == 0) {
            message = String.valueOf(key) + "<<";
        }
        return message;
    }

    private static void init() {
        isInitialised = true;
        String line = null;
        BufferedReader input_stream = null;
        ClassLoader loader = Messages.class.getClassLoader();
        String enc = "Cp1252";
        try {
            messages = new HashMap();
            String targetFile = "messages.properties";
            String ID = bundle.getLocale().toString();
            targetFile = ID.startsWith("en") ? "messages.properties" : "messages_" + ID + ".properties";
            input_stream = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/international/" + targetFile), enc));
            if (input_stream == null) {
                LogWriter.writeLog("Unable to open messages.properties from jar");
            }
            while ((line = input_stream.readLine()) != null) {
                int equalsIndex = line.indexOf(61);
                if (equalsIndex == -1) continue;
                String message = line.substring(equalsIndex + 1);
                StringBuffer newMessage = new StringBuffer();
                StringTokenizer t = new StringTokenizer(message, "\\&;", true);
                String nextValue = "";
                boolean isAmpersand = false;
                while (t.hasMoreTokens()) {
                    String ascii;
                    if (isAmpersand) {
                        nextValue = "&";
                        isAmpersand = false;
                    } else {
                        nextValue = t.nextToken();
                    }
                    if (nextValue.equals("\\")) {
                        ascii = t.nextToken();
                        char c = ascii.charAt(0);
                        if (c == 'n') {
                            newMessage.append('\n');
                        } else if (c == ' ') {
                            newMessage.append(' ');
                        } else {
                            System.out.println("no value for " + c);
                            System.exit(1);
                        }
                        newMessage.append(ascii.substring(1));
                        continue;
                    }
                    if (nextValue.equals("&")) {
                        ascii = t.nextToken();
                        if (t.hasMoreTokens()) {
                            String end = t.nextToken();
                            if (end.equals("&")) {
                                newMessage.append('&');
                                newMessage.append(ascii);
                                isAmpersand = true;
                                continue;
                            }
                            if (end.equals(";")) {
                                if (ascii.startsWith("#")) {
                                    ascii = ascii.substring(1);
                                }
                                char c = (char)Integer.parseInt(ascii);
                                newMessage.append(c);
                                continue;
                            }
                            if (t.hasMoreTokens()) {
                                newMessage.append('&');
                            }
                            newMessage.append(ascii);
                            continue;
                        }
                        newMessage.append('&');
                        newMessage.append(ascii);
                        continue;
                    }
                    newMessage.append(nextValue);
                }
                messages.put(line.substring(0, equalsIndex), newMessage.toString());
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " reading message Bundle");
            e.printStackTrace();
        }
        if (input_stream != null) {
            try {
                input_stream.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading lookup table for pdf  for abobe map");
            }
        }
    }
}

