/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import javax.media.jai.ImageLayout;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.JAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.operator.AbsoluteDescriptor;
import org.jpedal.color.ColorSpaces;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.utils.LogWriter;

public class FastPlot {
    public static void fastPlot(BufferedImage image, Graphics2D g2, int optionsApplied, AffineTransform upside_down, double[] values, String currentImageFile, boolean isPrinting, ObjectStore objectStoreRef) {
        double dy = 0.0;
        double dx = 0.0;
        if (optionsApplied != 0) {
            double tmp3;
            double tmp1;
            if ((optionsApplied & 2) == 2) {
                if (values[0] > 0.0 && values[3] < 0.0 && (optionsApplied & 1) == 1) {
                    double newWidth = values[0] * (double)image.getWidth();
                    double newHeight = -(values[3] * (double)image.getHeight());
                    dy = values[5] - newHeight;
                    values[5] = newHeight;
                    if (newWidth - (double)((int)newWidth) > 0.5) {
                        dx -= 1.0;
                    }
                } else if (values[0] < 0.0 && values[3] > 0.0) {
                    tmp1 = values[0];
                    tmp3 = values[2];
                    values[0] = values[3];
                    values[3] = tmp1;
                    values[4] = 0.0;
                    values[5] = (int)(values[4] * (double)image.getHeight() / (double)image.getWidth());
                }
            } else if (values[0] > 0.0 && values[3] > 0.0 && (optionsApplied & 1) == 1) {
                dy = values[5];
                tmp1 = values[0];
                tmp3 = values[2];
                values[0] = values[3];
                values[3] = tmp1;
                values[4] = 0.0;
                values[5] = (int)(values[4] * (double)image.getHeight() / (double)image.getWidth());
            }
            upside_down = new AffineTransform(values);
        }
        boolean imageProcessed = false;
        if (JAIHelper.isJAIused()) {
            try {
                image = JAI.create((String)"affine", (RenderedImage)image, (Object)upside_down, (Object)new InterpolationBicubic(1)).getAsBufferedImage();
                imageProcessed = false;
            }
            catch (Exception ee) {
                imageProcessed = false;
                ee.printStackTrace();
            }
            catch (Error err) {
                imageProcessed = false;
            }
            if (!imageProcessed && currentImageFile != null) {
                imageProcessed = true;
                try {
                    Dimension tileSize = new Dimension(512, 512);
                    FileSeekableStream s = new FileSeekableStream(new File(objectStoreRef.getFileForCachedImage(currentImageFile)));
                    ImageDecodeParam param = null;
                    ImageDecoder dec = ImageCodec.createImageDecoder((String)"tiff", (SeekableStream)s, param);
                    int imageToLoad = 0;
                    NullOpImage ri = new NullOpImage(dec.decodeAsRenderedImage(imageToLoad), null, 2, null);
                    ColorModel cm = ri.getColorModel();
                    ColorSpace cs = cm.getColorSpace();
                    RenderingHints hints = null;
                    if (ri.getTileWidth() * ri.getTileHeight() > tileSize.width * tileSize.height) {
                        cm = ri.getColorModel();
                        SampleModel sm = ri.getSampleModel().createCompatibleSampleModel(tileSize.width, tileSize.height);
                        ImageLayout layout = new ImageLayout(0, 0, tileSize.width, tileSize.height, sm, cm);
                        hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
                        ri = AbsoluteDescriptor.create((RenderedImage)ri, (RenderingHints)hints);
                    }
                    image = JAI.create((String)"affine", (RenderedImage)ri, (Object)upside_down, (Object)new InterpolationBicubic(1)).getAsBufferedImage();
                    ri = null;
                    dec = null;
                }
                catch (Exception ee) {
                    imageProcessed = false;
                    ee.printStackTrace();
                }
                catch (Error err) {
                    imageProcessed = false;
                }
                currentImageFile = null;
            }
            if (!imageProcessed) {
                LogWriter.writeLog("Unable to use JAI for image inversion");
            }
        } else {
            imageProcessed = true;
        }
        if (!imageProcessed) {
            imageProcessed = true;
            try {
                AffineTransformOp invert = new AffineTransformOp(upside_down, ColorSpaces.hints);
                image = invert.filter(image, null);
            }
            catch (Exception ee) {
                imageProcessed = false;
                ee.printStackTrace();
            }
            catch (Error err) {
                imageProcessed = false;
            }
        }
        if (imageProcessed) {
            Shape rawClip = null;
            if (isPrinting && dy == 0.0) {
                double[] affValues = new double[6];
                g2.getTransform().getMatrix(affValues);
                dx = affValues[4] / affValues[0];
                if (dx > 0.0) {
                    dx = -dx;
                }
                if ((dy = affValues[5] / affValues[3]) > 0.0) {
                    dy = -dy;
                }
                dy = -(dy + (double)image.getHeight());
            }
            if (dy != 0.0) {
                rawClip = g2.getClip();
                int xDiff = 1;
                double xScale = g2.getTransform().getScaleX();
                xDiff = xScale < 1.0 ? (int)(1.0 / xScale) : (int)(xScale + 0.5);
                int yDiff = 1;
                double yScale = g2.getTransform().getScaleY();
                yDiff = yScale < 1.0 ? (int)(1.0 / yScale) : (int)(yScale + 0.5);
                g2.clipRect((int)dx, (int)(dy + 1.5), image.getWidth() - xDiff, image.getHeight() - yDiff);
            }
            g2.drawImage((Image)image, (int)dx, (int)dy, null);
            if (rawClip != null) {
                g2.setClip(rawClip);
            }
        } else {
            g2.drawImage(image, upside_down, null);
        }
    }
}

