/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.structuredtext;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.io.PdfObjectReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class StructuredContentHandler {
    private boolean addCoordinates = true;
    private Map markedContentProperties;
    private int markedContentLevel = 0;
    private StringBuffer markedContentSequence;
    private static final boolean debug = false;
    private boolean contentExtracted = false;
    private boolean mapTags = true;
    private String currentKey;
    private Map keys;
    private Map values;
    private Map dictionaries;
    private StringBuffer finalXML;
    private Map lookupStructParents;
    PdfObjectReader currentPdfFile;
    private String imageName;
    boolean buildDirectly = false;
    Document doc;
    Element root;
    private float x1;
    private float y1;
    private float x2;
    private float y2;

    public StructuredContentHandler(Object markedContent) {
        if (markedContent instanceof Map) {
            this.buildDirectly = false;
            this.values = (Map)markedContent;
        } else {
            this.buildDirectly = true;
            this.doc = (Document)markedContent;
            this.root = this.doc.createElement("TaggedPDF-doc");
            this.doc.appendChild(this.root);
        }
        this.markedContentProperties = new HashMap();
        this.markedContentLevel = 0;
        this.markedContentSequence = new StringBuffer();
        this.currentKey = "";
        this.finalXML = new StringBuffer();
        this.keys = new HashMap();
        this.dictionaries = new HashMap();
        this.lookupStructParents = new HashMap();
    }

    public void MP() {
    }

    public void DP(Map dictionary) {
    }

    public void BDC(Map dictionary) {
        String MCID;
        if (this.markedContentLevel == 0) {
            this.markedContentSequence = new StringBuffer();
        }
        ++this.markedContentLevel;
        Iterator allKeys = dictionary.keySet().iterator();
        String mainKey = allKeys.next().toString();
        Map dict = (Map)dictionary.get(mainKey);
        if (this.buildDirectly) {
            dict.remove("MCID");
        }
        if ((MCID = (String)dict.get("MCID")) != null) {
            this.keys.put(new Integer(this.markedContentLevel), MCID);
            this.dictionaries.put(String.valueOf(this.markedContentLevel), dict);
        } else {
            this.dictionaries.put(String.valueOf(this.markedContentLevel), dictionary);
        }
    }

    public void BMC(String op) {
        if (op.startsWith("/")) {
            op = op.substring(1);
        }
        if (this.markedContentLevel == 0) {
            this.markedContentSequence = new StringBuffer();
        }
        this.markedContentProperties.put(new Integer(this.markedContentLevel), op);
        ++this.markedContentLevel;
        this.keys.put(new Integer(this.markedContentLevel), op);
        if (this.buildDirectly) {
            boolean isBMC;
            Map dict = (Map)this.dictionaries.get(this.currentKey);
            boolean bl = isBMC = dict == null;
            if (op != null) {
                Element newRoot = (Element)this.root.getElementsByTagName(op).item(0);
                if (newRoot == null) {
                    newRoot = this.doc.createElement(op);
                    this.root.appendChild(newRoot);
                }
                this.root = newRoot;
            }
        }
    }

    public void EMC() {
        this.contentExtracted = true;
        this.currentKey = (String)this.keys.get(new Integer(this.markedContentLevel));
        if (this.currentKey == null) {
            this.currentKey = String.valueOf(this.markedContentLevel);
        }
        if (this.buildDirectly) {
            Map dict = (Map)this.dictionaries.get(this.currentKey);
            boolean isBMC = dict == null;
            System.out.println(String.valueOf(isBMC) + " " + this.currentKey + ' ' + dict + " markedContentSequence=" + this.markedContentSequence);
            if (isBMC) {
                if (this.currentKey != null) {
                    Text child = this.doc.createTextNode(this.stripEscapeChars(this.markedContentSequence.toString()));
                    this.root.appendChild(child);
                    if (this.addCoordinates) {
                        this.root.setAttribute("x1", String.valueOf((int)this.x1));
                        this.root.setAttribute("y1", String.valueOf((int)this.y1));
                        this.root.setAttribute("x2", String.valueOf((int)this.x2));
                        this.root.setAttribute("y2", String.valueOf((int)this.y2));
                    }
                    Node oldRoot = this.root.getParentNode();
                    this.root = (Element)oldRoot;
                }
            } else {
                Iterator keys = dict.keySet().iterator();
                String S = (String)keys.next();
                Element tag = this.doc.createElement(S);
                this.root.appendChild(tag);
                Map atts = (Map)dict.get(S);
                for (String nextAtt : atts.keySet()) {
                    tag.setAttribute(nextAtt, this.stripEscapeChars(atts.get(nextAtt)));
                }
                if (this.addCoordinates) {
                    tag.setAttribute("x1", String.valueOf((int)this.x1));
                    tag.setAttribute("y1", String.valueOf((int)this.y1));
                    tag.setAttribute("x2", String.valueOf((int)this.x2));
                    tag.setAttribute("y2", String.valueOf((int)this.y2));
                }
                Text child = this.doc.createTextNode(this.markedContentSequence.toString());
                tag.appendChild(child);
            }
            this.markedContentSequence = new StringBuffer();
        } else {
            String ContentSequence = this.markedContentSequence.toString();
            Map dict = (Map)this.dictionaries.get(String.valueOf(this.markedContentLevel));
            if (dict != null && dict.containsKey("MCID")) {
                this.values.put(this.currentKey, ContentSequence);
                this.markedContentSequence = new StringBuffer();
            }
            this.dictionaries.remove(String.valueOf(this.markedContentLevel));
        }
        if (this.markedContentLevel > 0) {
            --this.markedContentLevel;
        }
    }

    public void setText(StringBuffer current_value, float x1, float y1, float x2, float y2) {
        this.markedContentSequence.append(current_value);
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public void setImageName(String name) {
        this.imageName = name;
    }

    private String stripEscapeChars(Object dict) {
        int lastC = 32;
        StringBuffer str = new StringBuffer((String)dict);
        int length = str.length();
        int ii = 0;
        while (ii < length) {
            char c = str.charAt(ii);
            if (c == '\\' && lastC != 92) {
                str.deleteCharAt(ii);
                --length;
            }
            lastC = c;
            ++ii;
        }
        return str.toString();
    }

    public boolean hasContent() {
        return this.contentExtracted;
    }
}

