/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.utils;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;

public class FormUtils {
    public static AbstractButton[] sortGroupSmallestFirst(ButtonGroup bg) {
        int items = bg.getButtonCount();
        Component[] buttons = new AbstractButton[items];
        Enumeration<AbstractButton> butGrp = bg.getElements();
        int i = 0;
        while (i < items) {
            if (butGrp.hasMoreElements()) {
                buttons[i] = butGrp.nextElement();
            }
            ++i;
        }
        return (AbstractButton[])FormUtils.sortCompsAscending(buttons);
    }

    private static Component[] sortCompsAscending(Component[] primary) {
        int items = primary.length;
        int left = items / 2;
        int right = items - 1;
        while (left > 0) {
            FormUtils.siftCompsAscending(primary, --left, right);
        }
        while (right > 0) {
            Component tempA = primary[0];
            primary[0] = primary[right];
            primary[right] = tempA;
            FormUtils.siftCompsAscending(primary, left, --right);
        }
        return primary;
    }

    private static void siftCompsAscending(Component[] primary, int left, int right) {
        int currentLeft = left;
        Component primaryTMP = primary[currentLeft];
        int childL = 2 * left + 1;
        if (childL < right && FormUtils.shouldSwapControl(primary[childL], primary[childL + 1])) {
            ++childL;
        }
        while (childL <= right && FormUtils.shouldSwapControl(primaryTMP, primary[childL])) {
            primary[currentLeft] = primary[childL];
            currentLeft = childL;
            if ((childL = 2 * childL + 1) >= right || !FormUtils.shouldSwapControl(primary[childL], primary[childL + 1])) continue;
            ++childL;
        }
        primary[currentLeft] = primaryTMP;
    }

    private static boolean shouldSwapControl(Component arg1, Component arg2) {
        Rectangle first = arg1.getBounds();
        Rectangle second = arg2.getBounds();
        return first.width * first.height < second.width * second.height;
    }

    public static String removeStateToCheck(String curCompName, boolean returnState) {
        int ptr;
        if (curCompName != null && (ptr = curCompName.indexOf("-(")) != -1) {
            curCompName = returnState ? curCompName.substring(ptr + 2, curCompName.length() - 1) : curCompName.substring(0, ptr);
        }
        return curCompName;
    }
}

