/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.utils;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import org.jpedal.io.PdfObjectReader;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ConvertToString {
    public static final String convertMapToString(NamedNodeMap currentMap) {
        if (currentMap == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < currentMap.getLength()) {
            Node node = currentMap.item(i);
            buf.append('\t');
            buf.append(node.getNodeName());
            buf.append('=');
            buf.append(node.getNodeValue());
            buf.append('\n');
            ++i;
        }
        return buf.toString();
    }

    public static final String convertMapToString(Map currentField, PdfObjectReader currentPdfFile) {
        return ConvertToString.convertMapToString(currentField, 1, currentPdfFile);
    }

    private static final String convertMapToString(Map currentField, int indent, PdfObjectReader currentPdfFile) {
        StringBuffer ret = new StringBuffer();
        for (String key : currentField.keySet()) {
            Object next = currentField.get(key);
            if (next instanceof Map) {
                ret.append('\n');
                int i = 0;
                while (i < indent) {
                    ret.append(' ');
                    ++i;
                }
                ret.append(key).append('=').append(ConvertToString.convertMapToString((Map)next, indent + 1, currentPdfFile));
                continue;
            }
            ret.append('\n');
            int i = 0;
            while (i < indent) {
                ret.append(' ');
                ++i;
            }
            if (currentPdfFile != null && !key.equals("Parent") && !key.equals("obj") && (next instanceof String && ((String)next).indexOf("0 R") != -1 || key.equals("T") || key.equals("V") || key.equals("DA") || key.equals("TU") || key.equals("CA"))) {
                ret.append(key).append('=').append(currentPdfFile.resolveToMapOrString(key, next));
                continue;
            }
            if (currentPdfFile != null) {
                if (next instanceof String && ((String)next).indexOf("0 R") != 0 || key.equals("T") || key.equals("V") || key.equals("DA") || key.equals("TU") || key.equals("CA") || key.equals("D")) {
                    Object obj = currentPdfFile.resolveToMapOrString(key, next);
                    if (obj instanceof Map) {
                        ret.append(key).append('=').append(ConvertToString.convertMapToString((Map)obj, indent + 1, currentPdfFile));
                        continue;
                    }
                    ret.append(key).append('=').append(obj);
                    continue;
                }
                ret.append(key).append('=').append(next);
                continue;
            }
            ret.append(key).append('=').append(next);
        }
        return ret.toString();
    }

    public static final String convertArrayToString(String[] items) {
        if (items != null) {
            StringBuffer ret = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(items[i]);
                ++i;
            }
            return ret.toString();
        }
        return null;
    }

    public static String convertArrayToString(boolean[] flags) {
        if (flags != null) {
            StringBuffer ret = new StringBuffer();
            int i = 0;
            while (i < flags.length) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(i);
                ret.append('=');
                ret.append(flags[i]);
                ++i;
            }
            return ret.toString();
        }
        return null;
    }

    public static String convertArrayToString(float[] values) {
        if (values != null) {
            StringBuffer ret = new StringBuffer();
            int i = 0;
            while (i < values.length) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(values[i]);
                ++i;
            }
            return ret.toString();
        }
        return null;
    }

    public static String convertArrayToString(int[] items) {
        if (items != null) {
            StringBuffer ret = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(items[i]);
                ++i;
            }
            return ret.toString();
        }
        return null;
    }

    public static String convertArrayToString(Rectangle[] boxes) {
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < boxes.length) {
            if (i > 0) {
                ret.append(",\n ");
            }
            ret.append(boxes[i].x);
            ret.append(' ');
            ret.append(boxes[i].y);
            ret.append(' ');
            ret.append(boxes[i].width);
            ret.append(' ');
            ret.append(boxes[i].height);
            ++i;
        }
        return ret.toString();
    }

    public static String convertArrayToString(Object[] components) {
        StringBuffer ret = new StringBuffer();
        ret.append("count=");
        ret.append(components.length);
        int i = 0;
        while (i < components.length) {
            ret.append('\n');
            ret.append(components[i]);
            ++i;
        }
        return ret.toString();
    }

    public static String convertArrayToString(List data) {
        if (data == null) {
            return "null";
        }
        StringBuffer ret = new StringBuffer();
        ret.append("count=");
        ret.append(data.size());
        int i = 0;
        while (i < data.size()) {
            ret.append('\n');
            ret.append(data.get(i));
            ++i;
        }
        return ret.toString();
    }

    public static String convertArrayToString(Boolean[] flags) {
        if (flags != null) {
            StringBuffer ret = new StringBuffer();
            int i = 0;
            while (i < flags.length) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(i);
                ret.append('=');
                ret.append(flags[i]);
                ++i;
            }
            return ret.toString();
        }
        return null;
    }

    public static String convertButtonGroupToString(ButtonGroup bg) {
        if (bg == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(bg.getButtonCount());
        buf.append('\n');
        Enumeration<AbstractButton> list = bg.getElements();
        while (list.hasMoreElements()) {
            buf.append(list.nextElement());
            buf.append('\n');
        }
        return buf.toString();
    }

    public static void printStackTrace(int level) {
        ConvertToString.printStackTrace(2, level + 1, false);
    }

    public static void printStackTrace(int startLevel, int endLevel, boolean err) {
        Throwable stackgetter = new Throwable();
        StackTraceElement[] elems = stackgetter.getStackTrace();
        if (endLevel == -1) {
            endLevel = elems.length - 1;
        }
        int i = startLevel;
        while (i <= endLevel) {
            if (err) {
                System.err.println(elems[i]);
            } else {
                System.out.println(elems[i]);
            }
            ++i;
        }
    }

    public static String convertDocumentToString(Node formData) {
        return ConvertToString.convertDocumentToString(formData, 0);
    }

    private static String convertDocumentToString(Node formData, int level) {
        if (formData == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        Node nextNode = formData;
        buf.append(nextNode.getNodeName());
        buf.append(" = ");
        buf.append(nextNode.getNodeValue());
        buf.append(" type=");
        buf.append(nextNode.getNodeType());
        NamedNodeMap att = nextNode.getAttributes();
        if (att != null) {
            buf.append(" attributes=");
            buf.append(att.toString());
        }
        buf.append('\n');
        int i = 0;
        while (i < level) {
            buf.append('.');
            ++i;
        }
        NodeList nodes = nextNode.getChildNodes();
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            buf.append(ConvertToString.convertDocumentToString(nodes.item(i2), ++level));
            ++i2;
        }
        return buf.toString();
    }

    public static String convertArrayToString(Node formData, int depth) {
        StringBuffer buff = new StringBuffer();
        buff.append("nodename=");
        buff.append(formData.getNodeName());
        buff.append(" nodetype=");
        buff.append(formData.getNodeType());
        buff.append(" nodevalue=");
        buff.append(formData.getNodeValue());
        buff.append(" parent=");
        buff.append(formData.getParentNode());
        buff.append(" Children - \n");
        ++depth;
        int i = 0;
        while (i < depth) {
            buff.append(' ');
            ++i;
        }
        NodeList nodes = formData.getChildNodes();
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            buff.append(ConvertToString.convertArrayToString(nodes.item(i2), depth));
            ++i2;
        }
        return buff.toString();
    }
}

