/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.decoding.images;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class FormXObject {
    private static final boolean debug = false;
    private static final boolean showImage = false;
    private int width = 20;
    private int height = 20;
    private String whenToScale = null;
    private Map formFieldValues = null;
    private PdfObjectReader currentPdfFile;
    private Map fonts = new HashMap();

    public Map getFontMap() {
        return this.fonts;
    }

    public FormXObject(PdfObjectReader currentPdfFile) {
        this.currentPdfFile = currentPdfFile;
    }

    private FormXObject() {
    }

    public BufferedImage decode(Map currentValues, String scale, Map formValues) {
        this.formFieldValues = formValues;
        this.whenToScale = scale;
        return this.decode(currentValues);
    }

    public BufferedImage decode(Map currentValues) {
        float rectY1;
        float rectX1;
        T3Glyph form;
        block26: {
            boolean breaksButton = false;
            try {
                PdfStreamDecoder glyphDecoder = new PdfStreamDecoder();
                ObjectStore localStore = new ObjectStore();
                glyphDecoder.setStore(localStore);
                DynamicVectorRenderer glyphDisplay = new DynamicVectorRenderer(0, false, 20, localStore);
                try {
                    glyphDecoder.init(false, true, 15, 0, new PdfPageData(), 0, glyphDisplay, this.currentPdfFile, new HashMap(), new HashMap());
                }
                catch (Exception e) {
                    LogWriter.writeLog("Font exception " + e);
                }
                try {
                    Map resValue = (Map)this.currentPdfFile.resolveToMapOrString("Resources", currentValues.get("Resources"));
                    if (resValue != null) {
                        for (String nextKey : resValue.keySet()) {
                            String ref;
                            Object fontValue;
                            if (nextKey.equals("ExtGState") || (fontValue = resValue.get(nextKey)) == null || !(fontValue instanceof String) || !(ref = (String)fontValue).endsWith(" R")) continue;
                            Map value = this.currentPdfFile.readObject(ref, false, null);
                            resValue.put(nextKey, value);
                        }
                    }
                    if (resValue != null) {
                        glyphDecoder.readResourcesForForm(resValue);
                    }
                    Map newFonts = glyphDecoder.getFontMap();
                    for (Object fontKey : newFonts.keySet()) {
                        this.fonts.put(fontKey, newFonts.get(fontKey));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Exception " + e + " reading resources in XForm");
                }
                byte[] commands = (byte[])this.currentPdfFile.resolveToMapOrString("DecodedStream", currentValues.get("DecodedStream"));
                if (commands != null) {
                    glyphDecoder.decodeStreamIntoObjects(commands);
                }
                boolean ignoreColors = glyphDecoder.ignoreColors;
                glyphDecoder = null;
                localStore.flush();
                form = new T3Glyph(glyphDisplay, 0, 0, ignoreColors, "");
                String rect = (String)this.currentPdfFile.resolveToMapOrString("BBox", currentValues.get("BBox"));
                rectX1 = 0.0f;
                rectY1 = 0.0f;
                if (rect != null) {
                    rect = Strip.removeArrayDeleminators(rect);
                    StringTokenizer tok = new StringTokenizer(rect);
                    float x1 = Float.parseFloat(tok.nextToken());
                    float y1 = Float.parseFloat(tok.nextToken());
                    float x2 = Float.parseFloat(tok.nextToken());
                    float y2 = Float.parseFloat(tok.nextToken());
                    rectX1 = x1;
                    rectY1 = y1;
                    this.width = (int)(x2 - x1);
                    this.height = (int)(y2 - y1);
                    if (this.formFieldValues != null) {
                        if (this.whenToScale == null || this.whenToScale.equals("A")) {
                            Rectangle formRect = (Rectangle)this.formFieldValues.get("rect");
                            if (formRect.width != this.width || formRect.height != this.height) {
                                LogWriter.writeFormLog("{stream} XObject MK IF A command, the icon should be scaled to fit the BBox", false);
                            }
                        } else if (!this.whenToScale.equals("N")) {
                            LogWriter.writeFormLog("{XObject} XObject MK IF Unimplemented command=" + this.whenToScale, false);
                        }
                    }
                }
                if (this.width < 0) {
                    this.width = -this.width;
                }
                if (this.height < 0) {
                    this.height = -this.height;
                }
                if (this.width != 0 && this.height != 0) break block26;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        BufferedImage aa = null;
        Graphics2D g2 = null;
        String matrix = (String)this.currentPdfFile.resolveToMapOrString("Matrix", currentValues.get("Matrix"));
        if (matrix != null) {
            int offset;
            StringTokenizer tok = new StringTokenizer(Strip.removeArrayDeleminators(matrix));
            float a = Float.parseFloat(tok.nextToken());
            float b = Float.parseFloat(tok.nextToken());
            float c = Float.parseFloat(tok.nextToken());
            float d = Float.parseFloat(tok.nextToken());
            float e = Float.parseFloat(tok.nextToken());
            float f = Float.parseFloat(tok.nextToken());
            if (c < 0.0f) {
                aa = new BufferedImage(this.height, this.width, 2);
                offset = this.width;
            } else {
                aa = new BufferedImage(this.width, this.height, 2);
                offset = this.height;
                if (e != 0.0f) {
                    e = -rectX1;
                }
                if (f != 0.0f) {
                    f = -rectY1;
                }
            }
            g2 = (Graphics2D)aa.getGraphics();
            AffineTransform flip = new AffineTransform();
            flip.translate(0.0, offset);
            flip.scale(1.0, -1.0);
            g2.setTransform(flip);
            AffineTransform affineTransform = new AffineTransform(a, b, c, d, e, f);
            g2.transform(affineTransform);
        } else {
            aa = new BufferedImage(this.width, this.height, 2);
            g2 = (Graphics2D)aa.getGraphics();
            AffineTransform flip = new AffineTransform();
            flip.translate(0.0, this.height);
            flip.scale(1.0, -1.0);
            g2.setTransform(flip);
        }
        form.render(0, g2, false, 1.0f);
        g2.dispose();
        return aa;
    }
}

