/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.decoding;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.fonts.PdfFont;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.decoding.FormDecoder;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.utils.ConvertToString;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class OverStream
implements FormDecoder {
    public static final boolean debugUnimplemented = false;
    public static final boolean debug = false;
    public static final boolean exitOnError = false;
    protected static boolean showIconsOnCreate = false;
    protected int type;
    public static final int READONLY = 1;
    public static final int REQUIRED = 2;
    public static final int NOEXPORT = 4;
    public static final int MULTILINE = 4096;
    public static final int PASSWORD = 8192;
    public static final int NOTOGGLETOOFF = 16384;
    public static final int RADIO = 32768;
    public static final int PUSHBUTTON = 65536;
    public static final int COMBO = 131072;
    public static final int EDIT = 262144;
    public static final int SORT = 524288;
    public static final int FILESELECT = 0x100000;
    public static final int MULTISELECT = 0x200000;
    public static final int DONOTSPELLCHECK = 0x400000;
    public static final int DONOTSCROLL = 0x800000;
    public static final int COMB = 0x1000000;
    public static final int RADIOINUNISON = 0x2000000;
    public static final int RICHTEXT = 0x2000000;
    public static final int COMMITONSELCHANGE = 0x4000000;
    protected static final BufferedImage OpaqueImage = new BufferedImage(20, 20, 2);
    protected PdfObjectReader currentPdfFile;
    private static Map currentItems = new HashMap();

    protected OverStream() {
    }

    public OverStream(PdfObjectReader inCurrentPdfFile) {
        this.currentPdfFile = inCurrentPdfFile;
    }

    public boolean doesItemExist(Object toCheck) {
        if (toCheck == null) {
            return false;
        }
        return currentItems.containsKey(toCheck);
    }

    public boolean addItem(Object toAdd) {
        if (toAdd == null) {
            return false;
        }
        if (!this.doesItemExist(toAdd = Strip.removeArrayDeleminators(toAdd.toString()))) {
            currentItems.put(toAdd, "x");
            return true;
        }
        return false;
    }

    public void resetItems() {
        currentItems = new HashMap();
    }

    protected Rectangle createBoundsRectangle(String rect, FormObject formObject) {
        double tmp;
        rect = Strip.removeArrayDeleminators(rect);
        StringTokenizer tok = new StringTokenizer(rect);
        double x1 = Float.parseFloat(tok.nextToken());
        double y1 = Float.parseFloat(tok.nextToken());
        double x2 = Float.parseFloat(tok.nextToken());
        double y2 = Float.parseFloat(tok.nextToken());
        if (x1 > x2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y1 > y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        Rectangle bBox = new Rectangle((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
        if (formObject == null) {
            return bBox;
        }
        formObject.setBoundingRectangle(bBox);
        return null;
    }

    protected Color generateColorFromString(String colorString) {
        colorString = Strip.removeArrayDeleminators(colorString);
        StringTokenizer tokens = new StringTokenizer(colorString, "() ,");
        String[] toks = new String[4];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String tok;
            toks[i] = tok = tokens.nextToken();
            ++i;
        }
        Color newColor = null;
        if (i == 0) {
            LogWriter.writeFormLog("{stream} CHECK transparent color", false);
            newColor = new Color(0, 0, 0, 0);
        } else if (i == 1) {
            float tok0 = Float.parseFloat(toks[0]);
            newColor = tok0 <= 1.0f ? new Color(tok0, tok0, tok0) : new Color((int)tok0, (int)tok0, (int)tok0);
        } else if (i == 3) {
            float tok0 = Float.parseFloat(toks[0]);
            float tok1 = Float.parseFloat(toks[1]);
            float tok2 = Float.parseFloat(toks[2]);
            newColor = tok0 <= 1.0f && tok1 <= 1.0f && tok2 <= 1.0f ? new Color(tok0, tok1, tok2) : new Color((int)tok0, (int)tok1, (int)tok2);
        } else if (i == 4) {
            LogWriter.writeFormLog("{stream} CHECK cmyk color=" + toks[0] + ' ' + toks[1] + ' ' + toks[2] + ' ' + toks[3], false);
            DeviceCMYKColorSpace cs = new DeviceCMYKColorSpace();
            cs.setColor(toks, 3);
            newColor = (Color)((Object)cs.getColor());
        } else {
            LogWriter.writeFormLog("{stream} ERROR i=" + i + " toks=" + ConvertToString.convertArrayToString(toks), false);
        }
        return newColor;
    }

    public void workOutCharachteristic(String annotationFlags, FormObject formObject) {
        if (annotationFlags != null) {
            int flagValue = Integer.parseInt(annotationFlags);
            if ((flagValue & 1) == 1) {
                formObject.setCharacteristic(1);
            }
            if ((flagValue & 2) == 2) {
                formObject.setCharacteristic(2);
            }
            if ((flagValue & 4) == 4) {
                formObject.setCharacteristic(3);
            }
            if ((flagValue & 8) == 8) {
                formObject.setCharacteristic(4);
            }
            if ((flagValue & 0x10) == 16) {
                formObject.setCharacteristic(5);
            }
            if ((flagValue & 0x20) == 32) {
                formObject.setCharacteristic(6);
            }
            if ((flagValue & 0x40) == 64) {
                formObject.setCharacteristic(7);
            }
            if ((flagValue & 0x80) == 128) {
                formObject.setCharacteristic(8);
            }
            if ((flagValue & 0x100) == 256) {
                formObject.setCharacteristic(9);
            }
        }
    }

    public void decodeFontCommandObj(String fontStream, FormObject formObject) {
        StringTokenizer tokens = new StringTokenizer(fontStream, "() ");
        int tokenCount = tokens.countTokens();
        String[] tokenValues = new String[tokenCount];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            tokenValues[i] = tokens.nextToken();
            ++i;
        }
        i = tokenCount - 1;
        while (i > -1) {
            if (tokenValues[i].equals("g")) {
                --i;
                float col = 0.0f;
                try {
                    col = Float.parseFloat(tokenValues[i]);
                }
                catch (Exception e) {
                    LogWriter.writeLog("Error in generating g value " + tokenValues[i]);
                }
                formObject.setTextColor(new Color(col, col, col));
            } else if (tokenValues[i].equals("Tf")) {
                --i;
                int textSize = 8;
                try {
                    textSize = (int)Float.parseFloat(tokenValues[i]);
                }
                catch (Exception e) {
                    LogWriter.writeLog("Error in generating Tf size " + tokenValues[i]);
                }
                --i;
                String font = null;
                try {
                    font = tokenValues[i];
                    if (font.startsWith("/")) {
                        font = font.substring(1);
                    }
                }
                catch (Exception e) {
                    LogWriter.writeLog("Error in generating Tf font " + tokenValues[i]);
                }
                PdfFont currentFont = new PdfFont();
                formObject.setTextFont(currentFont.setFont(font, textSize));
                formObject.setTextSize(textSize);
            } else if (tokenValues[i].equals("rg")) {
                float b = Float.parseFloat(tokenValues[--i]);
                float g = Float.parseFloat(tokenValues[--i]);
                float r = Float.parseFloat(tokenValues[--i]);
                formObject.setTextColor(new Color(r, g, b));
            } else if (tokenValues[i].equals("Sig")) {
                LogWriter.writeFormLog("Sig-  UNIMPLEMENTED=" + fontStream + "< " + i, false);
            } else if (!tokenValues[i].equals("\\n")) {
                LogWriter.writeFormLog("{stream} Unknown FONT command " + tokenValues[i] + ' ' + i + " string=" + fontStream, false);
            }
            --i;
        }
    }

    public FormObject createAppearanceString(Map currentField, PdfObjectReader currentPdfFile, int formPage) {
        return null;
    }
}

