/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.decoding;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.decoding.OverStream;
import org.jpedal.objects.acroforms.decoding.images.FormXObject;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.utils.ConvertToString;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class FormStream
extends OverStream {
    private static boolean CHECKVITALVALUES = true;
    private FormXObject appearanceObject = null;
    protected Map currentField;
    protected int formPage = -1;
    protected int keySize;
    protected String[] commands;
    private static boolean messageShown = false;
    Map actions = new HashMap();
    private static final int FTint = 0;
    private static final int Ffint = 1;
    private String[] commandStrings = new String[]{"FT", "Ff"};

    protected FormStream() {
    }

    public FormStream(PdfObjectReader inCurrentPdfFile) {
        this.type = 2;
        this.currentPdfFile = inCurrentPdfFile;
        this.init();
    }

    protected void init() {
        String[] values = new String[]{"E", "X", "D", "U", "Fo", "BI", "PO", "PC", "PV", "PI", "O", "C1", "K", "F", "V", "C2", "DC", "WS", "DS", "WP", "DP"};
        int[] id = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22};
        int itemCount = id.length;
        int i = 0;
        while (i < itemCount) {
            this.actions.put(values[i], new Integer(id[i]));
            ++i;
        }
    }

    private FormObject createAppearanceString(FormObject parentForm, Map formField) {
        this.currentField = formField;
        Object rectTocheck = this.currentPdfFile.resolveToMapOrString("Rect", this.currentField.get("Rect"));
        if (rectTocheck != null && !this.addItem(String.valueOf(this.formPage) + " " + rectTocheck)) {
            return null;
        }
        this.parseStream(parentForm);
        if (this.type != 1) {
            this.decodeStream(parentForm);
        }
        return parentForm;
    }

    public FormObject createAppearanceString(Map formField, PdfObjectReader inCurrentPdfFile, int page) {
        FormObject formObject = new FormObject();
        this.currentPdfFile = inCurrentPdfFile;
        this.currentField = formField;
        this.formPage = page;
        Object rectTocheck = this.currentPdfFile.resolveToMapOrString("Rect", this.currentField.get("Rect"));
        if (rectTocheck != null && !this.addItem(String.valueOf(this.formPage) + " " + rectTocheck)) {
            return null;
        }
        this.parseStream(formObject);
        if (this.type != 1) {
            this.decodeStream(formObject);
        }
        return formObject;
    }

    protected void parseStream(FormObject formObject) {
        formObject.setBorder(null);
        this.currentField.remove("P");
        String obj = (String)this.currentField.get("obj");
        formObject.setPDFRef(obj);
        if (CHECKVITALVALUES) {
            Object kidsField;
            Object parentField = this.currentPdfFile.resolveToMapOrString("Parent", this.currentField.get("Parent"));
            Map parentMap = parentField instanceof Map ? (Map)parentField : (parentField == null ? null : null);
            Map kidsMap = null;
            if (this.currentField.containsKey("Kids") && (kidsField = this.currentPdfFile.resolveToMapOrString("Kids", this.currentField.get("Kids"))) instanceof Map) {
                kidsMap = (Map)kidsField;
            }
            this.navigateToFindCommand(0, formObject, parentMap, kidsMap);
            this.navigateToFindCommand(1, formObject, parentMap, kidsMap);
            if (parentMap != null) {
                for (Object next : parentMap.keySet()) {
                    if (next.equals("Kids") || this.currentField.containsKey(next)) continue;
                    this.currentField.put(next, parentMap.get(next));
                }
            }
            this.createOrderedCommandArray();
            int i = 0;
            while (i < this.commands.length) {
                String command = this.commands[i];
                Object field = this.currentPdfFile.resolveToMapOrString(command, this.currentField.get(command));
                this.parseCommand(command, field, formObject);
                ++i;
            }
        } else {
            Object parent;
            this.createOrderedCommandArray();
            int i = 0;
            while (i < this.commands.length) {
                String command = this.commands[i];
                Object field = this.currentPdfFile.resolveToMapOrString(command, this.currentField.get(command));
                this.parseCommand(command, field, formObject);
                ++i;
            }
            if (formObject.getFieldName() == null && (parent = this.currentPdfFile.resolveToMapOrString("Parent", this.currentField.get("Parent"))) instanceof Map) {
                String fieldName = (String)this.currentPdfFile.resolveToMapOrString("T", ((Map)parent).get("T"));
                formObject.setFieldName(fieldName);
            }
        }
    }

    private void navigateToFindCommand(int searchOption, FormObject formObject, Map parentMap, Map kidsMap) {
        if (this.currentField.containsKey(this.commandStrings[searchOption])) {
            if (searchOption == 1) {
                this.commandFf(formObject, this.currentPdfFile.resolveToMapOrString(this.commandStrings[searchOption], this.currentField.get(this.commandStrings[searchOption])));
            } else if (searchOption == 0) {
                this.resolveFTcommand(this.currentPdfFile.resolveToMapOrString("FT", this.currentField.get("FT")), formObject);
            }
        } else if (parentMap != null) {
            if (parentMap.containsKey(this.commandStrings[searchOption])) {
                Object parentFld = parentMap.get(this.commandStrings[searchOption]);
                if (searchOption == 1) {
                    this.commandFf(formObject, this.currentPdfFile.resolveToMapOrString(this.commandStrings[searchOption], parentFld));
                } else if (searchOption == 0) {
                    this.resolveFTcommand(this.currentPdfFile.resolveToMapOrString("FT", parentFld), formObject);
                }
                this.currentField.put(this.commandStrings[searchOption], parentFld);
                parentMap.remove(this.commandStrings[searchOption]);
            }
        } else if (kidsMap != null) {
            kidsMap.containsKey(this.commandStrings[searchOption]);
        }
    }

    private void createOrderedCommandArray() {
        Iterator iter = this.currentField.keySet().iterator();
        this.keySize = this.currentField.keySet().size();
        this.commands = new String[this.keySize];
        int endnum = this.keySize - 1;
        int num = 0;
        while (iter.hasNext()) {
            String command = (String)iter.next();
            if (command.equals("AP")) {
                this.commands[endnum] = command;
                --endnum;
                continue;
            }
            if (command.equals("Kids")) {
                this.commands[endnum] = command;
                --endnum;
                continue;
            }
            if (command.equals("H")) {
                this.commands[endnum] = command;
                --endnum;
                continue;
            }
            if (command.equals("I")) {
                this.commands[endnum] = command;
                --endnum;
                continue;
            }
            if (command.equals("AA")) {
                this.commands[endnum] = command;
                --endnum;
                continue;
            }
            this.commands[num] = command;
            ++num;
        }
    }

    protected boolean parseCommand(String command, Object field, FormObject formObject) {
        boolean notFound = false;
        if (command.equals("Parent")) {
            Map parentMap;
            if (field instanceof Map && (parentMap = (Map)field).containsKey("V")) {
                this.commandV(field, formObject);
            }
        } else if (command.equals("V")) {
            this.commandV(field, formObject);
        } else if (command.equals("Q")) {
            formObject.setHorizontalAlign(field);
        } else if (!command.equals("AP") && !command.equals("DA")) {
            if (command.equals("TU")) {
                formObject.setUserName((String)field);
                LogWriter.writeFormLog("{stream} userName NOT IMPLEMENTED=" + field, false);
            } else if (command.equals("T")) {
                if (this.currentField.containsKey("Parent")) {
                    String fullFieldName = this.searchAndAdd("Parent", this.currentField, "T");
                    formObject.setFieldName(fullFieldName);
                } else {
                    formObject.setFieldName((String)field);
                }
            } else if (command.equals("TM")) {
                formObject.setMapName((String)field);
                LogWriter.writeFormLog("{stream} mapName NOT IMPLEMENTED=" + field, false);
            } else if (command.equals("AS")) {
                String state = null;
                if (field instanceof Map) {
                    Map mapField = (Map)field;
                    mapField.remove("PageNumber");
                    if (mapField.containsKey("rawValue")) {
                        state = (String)this.currentPdfFile.resolveToMapOrString("rawValue", mapField.get("rawValue"));
                        if (mapField.size() > 1) {
                            LogWriter.writeFormLog("{stream} AS IS MAP UNKNOWN field=" + field, false);
                        }
                    } else {
                        LogWriter.writeFormLog("{stream} AS IS MAP field=" + field, false);
                    }
                } else {
                    state = (String)field;
                }
                state = Strip.checkRemoveLeadingSlach(state);
                formObject.setDefaultState(state);
            } else if (command.equals("F")) {
                this.workOutCharachteristic((String)field, formObject);
            } else if (!command.equals("Kids")) {
                if (command.equals("Opt")) {
                    HashMap valuesMap = new HashMap();
                    String[] items = field instanceof String ? this.populateItemsArrayWithValues((String)field, valuesMap) : this.populateItemsArrayWithValues((String)this.currentPdfFile.resolveToMapOrString("rawValue", ((Map)field).get("rawValue")), valuesMap);
                    if (valuesMap.size() < 1) {
                        formObject.setValuesMap(null);
                    } else {
                        formObject.setValuesMap(valuesMap);
                    }
                    formObject.setlistOfItems(items);
                } else if (command.equals("BS")) {
                    formObject.setBorder(field);
                } else if (command.equals("Ti")) {
                    formObject.setTopIndex(new int[]{Integer.parseInt((String)field)});
                } else if (command.equals("MaxLen")) {
                    formObject.setMaxTextLength(Integer.parseInt((String)field));
                } else if (command.equals("Rect")) {
                    this.createBoundsRectangle((String)this.currentPdfFile.resolveToMapOrString("Rect", this.currentField.get("Rect")), formObject);
                } else if (command.equals("FT")) {
                    String type = null;
                    if (field instanceof Map) {
                        Map mapField = (Map)field;
                        mapField.remove("PageNumber");
                        if (mapField.containsKey("rawValue")) {
                            type = Strip.checkRemoveLeadingSlach((String)this.currentPdfFile.resolveToMapOrString("rawValue", mapField.get("rawValue")));
                            if (mapField.size() > 1) {
                                LogWriter.writeFormLog("{stream} type IS MAP UNKNOWN field=" + field, false);
                            }
                        } else {
                            LogWriter.writeFormLog("{stream} type IS MAP field=" + field, false);
                        }
                    } else {
                        type = Strip.checkRemoveLeadingSlach((String)field);
                    }
                    if (type != null) {
                        if (type.equals("Btn")) {
                            formObject.setType(0);
                        } else if (type.equals("Tx")) {
                            formObject.setType(2);
                        } else if (type.equals("Ch")) {
                            formObject.setType(1);
                        } else if (type.equals("Sig")) {
                            formObject.setType(3);
                        }
                    }
                } else if (command.equals("MK")) {
                    this.commandMK((Map)field, formObject);
                } else if (command.equals("Ff")) {
                    this.commandFf(formObject, field);
                } else if (command.equals("AA")) {
                    this.resolveAdditionalAction(field, formObject);
                } else if (!command.equals("Type")) {
                    if (command.equals("Subtype")) {
                        if (!field.equals("/Widget")) {
                            notFound = true;
                        }
                    } else if (command.equals("PageNumber")) {
                        formObject.setPageNumber(field);
                    } else if (command.equals("StructParent")) {
                        LogWriter.writeFormLog("{stream} CHECK 'StructParent' NOT Implemented", false);
                    } else if (command.equals("A")) {
                        this.commandA(field, formObject);
                    } else if (command.equals("DV")) {
                        if (field instanceof String) {
                            formObject.setDefaultValue((String)field);
                        } else if (field instanceof Map) {
                            Map dvMap = (Map)field;
                            if (dvMap.containsKey("rawValue")) {
                                formObject.setDefaultValue((String)this.currentPdfFile.resolveToMapOrString("rawValue", dvMap.get("rawValue")));
                            } else if (!dvMap.containsKey("PageNumber")) {
                                LogWriter.writeFormLog("{stream} unknown entry as Map DV command NOT IMPLEMENTED field=" + dvMap, false);
                            }
                        } else {
                            LogWriter.writeFormLog("{stream} unknown DV command NOT IMPLEMENTED field=" + field, false);
                        }
                    } else if (!command.equals("I") && !command.equals("H")) {
                        if (command.equals("DR")) {
                            if (field instanceof Map) {
                                LogWriter.writeFormLog("{stream} DR command this Must have a Font entry used for the default font with text map UNIMPLEMENTED field", false);
                            } else {
                                LogWriter.writeFormLog("{stream} DR command this Must have a Font entry used for the default font with text non map UNIMPLEMENTED field", false);
                            }
                        } else if (command.equals("Lock")) {
                            LogWriter.writeFormLog("{stream} Lock command UNIMPLEMENTED only needed for signiture fields, field=" + field, false);
                        } else if (!command.equals("NeedAppearances")) {
                            if (command.equals("NM")) {
                                this.commandNM(formObject, field);
                            } else if (!command.equals("obj")) {
                                LogWriter.writeFormLog("{stream} UNIMPLEMENTED command - " + command + " in form Stream=\n\t" + field, false);
                                notFound = true;
                            }
                        }
                    }
                }
            }
        }
        return notFound;
    }

    private String searchAndAdd(String objectNames, Map currentField, String searchString) {
        Object mapObj = this.currentPdfFile.resolveToMapOrString(objectNames, currentField.get(objectNames));
        String returnVal = null;
        if (mapObj instanceof Map) {
            Object obj;
            Map map = (Map)mapObj;
            if (map.containsKey(objectNames)) {
                returnVal = this.searchAndAdd(objectNames, map, searchString);
            }
            if (map.containsKey(searchString) && (obj = this.currentPdfFile.resolveToMapOrString(searchString, map.get(searchString))) instanceof String) {
                returnVal = returnVal == null ? (String)obj : String.valueOf(returnVal) + "." + obj;
            }
        }
        return returnVal;
    }

    private void resolveFTcommand(Object field, FormObject formObject) {
        String type1 = null;
        if (field instanceof Map) {
            Map mapField = (Map)field;
            mapField.remove("PageNumber");
            if (mapField.containsKey("rawValue")) {
                type1 = Strip.checkRemoveLeadingSlach((String)this.currentPdfFile.resolveToMapOrString("rawValue", mapField.get("rawValue")));
                if (mapField.size() > 1) {
                    LogWriter.writeFormLog("{stream} type IS MAP UNKNOWN field=" + field, false);
                }
            } else {
                LogWriter.writeFormLog("{stream} type IS MAP field=" + field, false);
            }
        } else {
            type1 = Strip.checkRemoveLeadingSlach((String)field);
        }
        if (type1 != null) {
            if (type1.equals("Btn")) {
                formObject.setType(0);
            } else if (type1.equals("Tx")) {
                formObject.setType(2);
            } else if (type1.equals("Ch")) {
                formObject.setType(1);
            } else if (type1.equals("Sig")) {
                formObject.setType(3);
            }
        }
    }

    protected void commandA(Object field, FormObject formObject) {
        HashMap<String, Object> mapA = new HashMap<String, Object>();
        mapA.put("A", field);
        this.resolveAdditionalAction(mapA, formObject);
    }

    private void commandFf(FormObject formObject, Object field) {
        String flag = (String)field;
        if (flag != null) {
            int flagValue = Integer.parseInt(flag);
            boolean[] flags = new boolean[32];
            flags[1] = (flagValue & 1) == 1;
            flags[2] = (flagValue & 2) == 2;
            flags[3] = (flagValue & 4) == 4;
            flags[12] = (flagValue & 0x1000) == 4096;
            flags[13] = (flagValue & 0x2000) == 8192;
            flags[14] = (flagValue & 0x4000) == 16384;
            flags[15] = (flagValue & 0x8000) == 32768;
            flags[16] = (flagValue & 0x10000) == 65536;
            flags[17] = (flagValue & 0x20000) == 131072;
            flags[18] = (flagValue & 0x40000) == 262144;
            flags[19] = (flagValue & 0x80000) == 524288;
            flags[20] = (flagValue & 0x100000) == 0x100000;
            flags[21] = (flagValue & 0x200000) == 0x200000;
            flags[22] = (flagValue & 0x400000) == 0x400000;
            flags[23] = (flagValue & 0x800000) == 0x800000;
            flags[24] = (flagValue & 0x1000000) == 0x1000000;
            flags[25] = (flagValue & 0x2000000) == 0x2000000;
            flags[25] = (flagValue & 0x2000000) == 0x2000000;
            flags[26] = (flagValue & 0x4000000) == 0x4000000;
            formObject.setFlags(flags);
            if (flags[3] || flags[22] || flags[24] || flags[26]) {
                LogWriter.writeFormLog("{stream} new flags (3 22 24 26) UNIMPLEMENTED flags - 3=" + flags[3] + " 22=" + flags[22] + " 24=" + flags[24] + " 26= " + flags[26], false);
            }
        }
    }

    protected void commandNM(FormObject formObject, Object curField) {
        formObject.setFieldName((String)curField);
    }

    private void commandV(Object field, FormObject formObject) {
        String curValue = null;
        if (field instanceof Map) {
            Map curMap = (Map)field;
            if (curMap.containsKey("rawValue")) {
                curValue = (String)this.currentPdfFile.resolveToMapOrString("rawValue", curMap.get("rawValue"));
            } else if (!curMap.containsKey("Type") || !Strip.checkRemoveLeadingSlach((String)this.currentPdfFile.resolveToMapOrString("Type", curMap.get("Type"))).equals("Sig")) {
                LogWriter.writeFormLog("{stream} V Map UNKNOWN=" + field, false);
            }
        } else {
            curValue = (String)field;
        }
        if (curValue != null) {
            String typeField = Strip.checkRemoveLeadingSlach((String)this.currentPdfFile.resolveToMapOrString("FT", this.currentField.get("FT")));
            if (typeField.equals("Btn")) {
                String flag = (String)this.currentPdfFile.resolveToMapOrString("Ff", this.currentField.get("Ff"));
                if (flag != null) {
                    int flagValue = Integer.parseInt(flag);
                    if ((flagValue & 0x8000) == 32768) {
                        formObject.setChildOnState(curValue);
                    } else if ((flagValue & 0x10000) != 65536) {
                        formObject.setCurrentState(curValue);
                    }
                } else {
                    formObject.setCurrentState(curValue);
                }
            } else if (typeField.equals("Tx")) {
                int count = curValue.length();
                StringBuffer scannedText = new StringBuffer();
                int i = 0;
                while (i < count) {
                    char c = curValue.charAt(i);
                    if (c == '\\') {
                        if ((c = curValue.charAt(++i)) == 't') {
                            scannedText.append('\t');
                        } else if (c == 'n') {
                            scannedText.append('\n');
                        } else if (c == 'r') {
                            scannedText.append('\r');
                        } else {
                            scannedText.append(c);
                        }
                    } else {
                        scannedText.append(c);
                    }
                    ++i;
                }
                formObject.setTextValue(scannedText.toString());
            } else if (typeField.equals("Ch")) {
                String selectedItem = (String)this.currentPdfFile.resolveToMapOrString("V", curValue);
                formObject.setSelectedItem(selectedItem);
            } else if (typeField.equals("Sig")) {
                LogWriter.writeFormLog("{stream} value - signiture value NOT IMPLEMENTED field=" + curValue, false);
            } else {
                LogWriter.writeFormLog("{stream} NOT IMPLEMENTED command=V field=" + curValue + " currentField=" + ConvertToString.convertMapToString(this.currentField, this.currentPdfFile), false);
            }
        }
    }

    private void resolveAdditionalAction(Object field, FormObject formObject) {
        if (field instanceof Map) {
            Map fieldMap = (Map)field;
            for (String iD : fieldMap.keySet()) {
                Object data;
                Object idValue = this.actions.get(iD);
                if (idValue != null) {
                    int key = (Integer)idValue;
                    data = this.currentPdfFile.resolveToMapOrString(iD, fieldMap.get(iD));
                    continue;
                }
                if (iD.equals("A")) {
                    Object Aobj = fieldMap.get("A");
                    if (Aobj instanceof String) {
                        Aobj = this.currentPdfFile.readObject((String)Aobj, false, null);
                    }
                    if ((data = this.currentPdfFile.resolveToMapOrString("A", Aobj)) instanceof Map) {
                        data = this.resolveCompleteMap((Map)data, this.currentPdfFile);
                    }
                    formObject.setAaction(data);
                    continue;
                }
                if (iD.equals("C")) {
                    Object data2 = this.currentPdfFile.resolveToMapOrString("C", fieldMap.get("C"));
                    continue;
                }
                if (iD.equals("PageNumber")) continue;
                LogWriter.writeFormLog("{stream} " + iD + " NOT IMPLEMENTED in FormStream.resolveAdditionalAction field=" + this.currentPdfFile.resolveToMapOrString(iD, fieldMap.get(iD)), false);
            }
        } else {
            LogWriter.writeFormLog("{stream} AdditionAction is String UNIMPLEMENTED", false);
        }
    }

    private Map resolveCompleteMap(Map map, PdfObjectReader currentPdfFile) {
        for (String key : map.keySet()) {
            Object obj;
            Object data = currentPdfFile.resolveToMapOrString(key, obj = map.get(key));
            if (data instanceof Map) {
                data = this.resolveCompleteMap((Map)data, currentPdfFile);
            }
            map.put(key, data);
        }
        return map;
    }

    private void trickleThroughMaps(Map downField, String commandName, boolean debug, boolean debugUnimplemented, FormObject formObject) {
        if (commandName.equals("N")) {
            this.N(downField, debug, debugUnimplemented, formObject);
        } else if (commandName.equals("D")) {
            this.D(downField, debug, debugUnimplemented, formObject);
        } else if (commandName.equals("R")) {
            this.R(downField, debug, debugUnimplemented, formObject);
        } else {
            LogWriter.writeFormLog("{stream} NOT SINGLED in Trickle " + commandName + '=', debugUnimplemented);
            for (String newCommand : downField.keySet()) {
                Object newField = this.currentPdfFile.resolveToMapOrString(newCommand, downField.get(newCommand));
                if (newField instanceof Map) {
                    Map newFieldMap = (Map)newField;
                    this.trickleThroughMaps(newFieldMap, newCommand, debug, debugUnimplemented, formObject);
                    continue;
                }
                if (newCommand.equals("SW")) {
                    String actiontype = Strip.checkRemoveLeadingSlach((String)newField);
                    if (actiontype.equals("N")) continue;
                    LogWriter.writeFormLog("{stream} UNIMPLEMENTED SW field=" + newField, debugUnimplemented);
                    continue;
                }
                if (newCommand.equals("PageNumber")) continue;
                LogWriter.writeFormLog("{stream} NON SINGLED command=" + newCommand + " field=" + newField, debugUnimplemented);
            }
        }
    }

    protected boolean commandAP(Map downField, FormObject formObject) {
        boolean apSet = false;
        for (String downFieldCommand : downField.keySet()) {
            Object downFieldWithinField = this.currentPdfFile.resolveToMapOrString(downFieldCommand, downField.get(downFieldCommand));
            if (!(downFieldWithinField instanceof Map)) continue;
            this.trickleThroughMaps((Map)downFieldWithinField, downFieldCommand, false, false, formObject);
        }
        apSet = true;
        return apSet;
    }

    private void resolveKidsArray(Object rawDownField, boolean debug, boolean debugUnimplemented, FormObject formObject) {
        boolean isString = false;
        StringTokenizer objectRefs = null;
        Map kidsMap = null;
        Iterator kidsMapIter = null;
        HashMap<String, FormObject> kidData = new HashMap<String, FormObject>();
        if (rawDownField instanceof String) {
            isString = true;
        }
        if (!isString) {
            kidsMap = (Map)rawDownField;
            kidsMapIter = kidsMap.keySet().iterator();
        } else {
            objectRefs = new StringTokenizer(Strip.removeArrayDeleminators((String)rawDownField), "R");
        }
        while (!isString && kidsMapIter.hasNext() || isString && objectRefs.hasMoreTokens()) {
            Object field;
            String command;
            if (!isString) {
                command = (String)kidsMapIter.next();
                field = this.currentPdfFile.resolveToMapOrString(command, kidsMap.get(command));
            } else {
                command = String.valueOf(objectRefs.nextToken().trim()) + " R";
                field = this.currentPdfFile.readObject(command, false, null);
            }
            if (!(field instanceof Map)) continue;
            FormObject parentForm = formObject.duplicate();
            kidData.put(command, this.createAppearanceString(parentForm, (Map)field));
        }
        formObject.setKidData(kidData);
    }

    private BufferedImage rotate(BufferedImage src, double angle) {
        if (src == null) {
            return null;
        }
        int w = src.getWidth();
        int h = src.getHeight();
        int newW = (int)Math.round((double)h * Math.abs(Math.sin(angle)) + (double)w * Math.abs(Math.cos(angle)));
        int newH = (int)Math.round((double)h * Math.abs(Math.cos(angle)) + (double)w * Math.abs(Math.sin(angle)));
        AffineTransform at = AffineTransform.getTranslateInstance((newW - w) / 2, (newH - h) / 2);
        at.rotate(angle, w / 2, h / 2);
        BufferedImage dst = new BufferedImage(newW, newH, 2);
        Graphics2D g = dst.createGraphics();
        g.drawRenderedImage(src, at);
        g.dispose();
        return dst;
    }

    private void N(Map downField, boolean debug, boolean debugUnimplemented, FormObject formObject) {
        block13: {
            block12: {
                if (downField.containsKey("MK")) {
                    Map map = (Map)this.currentPdfFile.resolveToMapOrString("MK", downField.get("MK"));
                    this.commandMK(map, formObject);
                }
                if (downField.containsKey("CachedStream")) {
                    this.currentPdfFile.readStreamIntoMemory(downField);
                }
                if (!downField.containsKey("DecodedStream")) break block12;
                if (formObject.hasNormalOff()) break block13;
                if (this.appearanceObject == null) {
                    this.appearanceObject = new FormXObject(this.currentPdfFile);
                }
                formObject.setNormalAppOff(this.rotate(this.appearanceObject.decode(downField), (double)formObject.getRotation() * Math.PI / 180.0), null);
                if (!showIconsOnCreate) break block13;
                ShowGUIMessage.showGUIMessage("N normalAppImage", formObject.getNormalOffImage(), "normalAppImage");
                break block13;
            }
            for (String stateTocheck : downField.keySet()) {
                if (stateTocheck.equals("Off")) {
                    Map offApp = (Map)this.currentPdfFile.resolveToMapOrString(stateTocheck, downField.get(stateTocheck));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setNormalAppOff(this.rotate(this.appearanceObject.decode(offApp), (double)formObject.getRotation() * Math.PI / 180.0), stateTocheck);
                    if (!showIconsOnCreate) continue;
                    ShowGUIMessage.showGUIMessage("N normalAppOff", formObject.getNormalOffImage(), "normalAppOff");
                    continue;
                }
                if (stateTocheck.equals("On")) {
                    Map onApp = (Map)this.currentPdfFile.resolveToMapOrString(stateTocheck, downField.get(stateTocheck));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setNormalAppOn(this.rotate(this.appearanceObject.decode(onApp), (double)formObject.getRotation() * Math.PI / 180.0), stateTocheck);
                    if (showIconsOnCreate) {
                        ShowGUIMessage.showGUIMessage("normalAppOn", formObject.getNormalOnImage(), "normalAppOn");
                    }
                    if (formObject.hasNormalOff()) continue;
                    formObject.setNormalAppOff(OpaqueImage, null);
                    continue;
                }
                if (stateTocheck.equals("PageNumber")) continue;
                formObject.setStateToCheck(stateTocheck);
                Object paramField = this.currentPdfFile.resolveToMapOrString(stateTocheck, downField.get(stateTocheck));
                if (paramField instanceof Map) {
                    Map onApp = (Map)paramField;
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setNormalAppOn(this.rotate(this.appearanceObject.decode(onApp), (double)formObject.getRotation() * Math.PI / 180.0), stateTocheck);
                    if (showIconsOnCreate) {
                        ShowGUIMessage.showGUIMessage("N normalAppOn", formObject.getNormalOnImage(), "normalAppOn");
                    }
                    if (formObject.hasNormalOff()) continue;
                    formObject.setNormalAppOff(OpaqueImage, null);
                    continue;
                }
                LogWriter.writeFormLog("{stream} String NOT IMPLEMENTED in FormStream.N stateTocheck=" + stateTocheck + " field=" + paramField, debugUnimplemented);
            }
        }
    }

    private void R(Map downField, boolean debug, boolean debugUnimplemented, FormObject formObject) {
        if (downField.containsKey("MK")) {
            LogWriter.writeFormLog("{stream} MK command in Rollover appearance field=" + this.currentPdfFile.resolveToMapOrString("MK", downField.get("MK")), debugUnimplemented);
        }
        if (downField.containsKey("CachedStream")) {
            this.currentPdfFile.readStreamIntoMemory(downField);
        }
        if (downField.containsKey("DecodedStream")) {
            if (this.appearanceObject == null) {
                this.appearanceObject = new FormXObject(this.currentPdfFile);
            }
            formObject.setRolloverAppOff(this.rotate(this.appearanceObject.decode(downField), (double)formObject.getRotation() * Math.PI / 180.0));
        } else {
            for (String stateTocheck : downField.keySet()) {
                if (stateTocheck.equals("Off")) {
                    Map offApp = (Map)this.currentPdfFile.resolveToMapOrString(stateTocheck, downField.get(stateTocheck));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setRolloverAppOff(this.rotate(this.appearanceObject.decode(offApp), (double)formObject.getRotation() * Math.PI / 180.0));
                    continue;
                }
                if (stateTocheck.equals("On")) {
                    Map onApp = (Map)this.currentPdfFile.resolveToMapOrString(stateTocheck, downField.get(stateTocheck));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setRolloverAppOn(this.rotate(this.appearanceObject.decode(onApp), (double)formObject.getRotation() * Math.PI / 180.0));
                    if (formObject.hasRolloverOff()) continue;
                    formObject.setRolloverAppOff(OpaqueImage);
                    continue;
                }
                if (stateTocheck.equals("PageNumber")) continue;
                Object paramField = this.currentPdfFile.resolveToMapOrString(stateTocheck, downField.get(stateTocheck));
                if (paramField instanceof Map) {
                    Map onApp = (Map)paramField;
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setRolloverAppOn(this.rotate(this.appearanceObject.decode(onApp), (double)formObject.getRotation() * Math.PI / 180.0));
                    if (formObject.hasRolloverOff()) continue;
                    formObject.setRolloverAppOff(OpaqueImage);
                    continue;
                }
                LogWriter.writeFormLog("{stream} String NOT IMPLEMENTED in FormStream.R stateTocheck=" + stateTocheck + " field=" + paramField, debugUnimplemented);
            }
        }
    }

    private void D(Map downField, boolean debug, boolean debugUnimplemented, FormObject formObject) {
        if (downField.containsKey("MK")) {
            LogWriter.writeFormLog("{stream} MK command in Down appearance field=" + this.currentPdfFile.resolveToMapOrString("MK", downField.get("MK")), debugUnimplemented);
        }
        if (downField.containsKey("CachedStream")) {
            this.currentPdfFile.readStreamIntoMemory(downField);
        }
        if (downField.containsKey("DecodedStream")) {
            if (this.appearanceObject == null) {
                this.appearanceObject = new FormXObject(this.currentPdfFile);
            }
            formObject.setDownAppOff(this.rotate(this.appearanceObject.decode(downField), (double)formObject.getRotation() * Math.PI / 180.0));
        } else {
            for (String stateTocheck : downField.keySet()) {
                if (stateTocheck.equals("Off")) {
                    Map offApp = (Map)this.currentPdfFile.resolveToMapOrString(stateTocheck, downField.get(stateTocheck));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setDownAppOff(this.rotate(this.appearanceObject.decode(offApp), (double)formObject.getRotation() * Math.PI / 180.0));
                    continue;
                }
                if (stateTocheck.equals("On")) {
                    Map onApp = (Map)this.currentPdfFile.resolveToMapOrString(stateTocheck, downField.get(stateTocheck));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setDownAppOn(this.rotate(this.appearanceObject.decode(onApp), (double)formObject.getRotation() * Math.PI / 180.0));
                    if (formObject.hasDownOff()) continue;
                    formObject.setDownAppOff(OpaqueImage);
                    continue;
                }
                if (stateTocheck.equals("PageNumber")) continue;
                Object paramField = this.currentPdfFile.resolveToMapOrString(stateTocheck, downField.get(stateTocheck));
                if (paramField instanceof Map) {
                    Map onApp = (Map)paramField;
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setDownAppOn(this.rotate(this.appearanceObject.decode(onApp), (double)formObject.getRotation() * Math.PI / 180.0));
                    if (formObject.hasDownOff()) continue;
                    formObject.setDownAppOff(OpaqueImage);
                    continue;
                }
                LogWriter.writeFormLog("{stream} String NOT IMPLEMENTED in FormStream.D stateTocheck=" + stateTocheck + " field=" + paramField, debugUnimplemented);
            }
        }
    }

    protected void commandMK(Map data, FormObject formObject) {
        for (String nextCommand : data.keySet()) {
            Object nextField = this.currentPdfFile.resolveToMapOrString(nextCommand, data.get(nextCommand));
            if (nextCommand.equals("CA")) {
                formObject.setNormalCaption((String)nextField);
                continue;
            }
            if (nextCommand.equals("BC")) {
                Color borderColor = this.generateColorFromString((String)nextField);
                formObject.setBorderColor(borderColor);
                continue;
            }
            if (nextCommand.equals("BG")) {
                Color backgroundColor = this.generateColorFromString((String)nextField);
                formObject.setBackgroundColor(backgroundColor);
                continue;
            }
            if (nextCommand.equals("R")) {
                formObject.setRotation(Integer.parseInt((String)nextField));
                continue;
            }
            if (nextCommand.equals("RC")) {
                formObject.setRolloverCaption((String)nextField);
                continue;
            }
            if (nextCommand.equals("AC")) {
                formObject.setDownCaption((String)nextField);
                continue;
            }
            if (nextCommand.equals("I")) {
                if (nextField instanceof Map) {
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setNormalAppOff(this.rotate(this.appearanceObject.decode((Map)nextField), (double)formObject.getRotation() * Math.PI / 180.0), null);
                    if (!showIconsOnCreate) continue;
                    ShowGUIMessage.showGUIMessage("MKI normalAppImage", formObject.getNormalOffImage(), "normalAppImage");
                    continue;
                }
                LogWriter.writeFormLog("{stream} MK I NOT implemented field=" + nextField, false);
                continue;
            }
            if (nextCommand.equals("RI")) {
                LogWriter.writeFormLog("{stream} MK RI NOT implemented field=" + nextField, false);
                continue;
            }
            if (nextCommand.equals("IX")) {
                LogWriter.writeFormLog("{stream} MK IX NOT implemented field=" + nextField, false);
                continue;
            }
            if (nextCommand.equals("IF")) {
                if (nextField instanceof Map) {
                    Map mapField = (Map)nextField;
                    if (mapField.containsKey("SW")) {
                        String whenToScale = Strip.checkRemoveLeadingSlach((String)this.currentPdfFile.resolveToMapOrString("SW", mapField.get("SW")));
                        if (whenToScale.equals("A")) {
                            formObject.setWhenToScaleIcon("A");
                            continue;
                        }
                        if (whenToScale.equals("N")) {
                            formObject.setWhenToScaleIcon("N");
                            continue;
                        }
                        LogWriter.writeFormLog("{stream} MK IF Map Unimplemented command=" + whenToScale + " field=" + nextField, false);
                        continue;
                    }
                    if (mapField.size() < 1) continue;
                    LogWriter.writeFormLog("{stream} MK IF unknown command type field=" + mapField, false);
                    continue;
                }
                LogWriter.writeFormLog("{stream} MK IF String NOT implemented field=" + nextField, false);
                continue;
            }
            if (nextCommand.equals("TP")) {
                formObject.setTextPosition(Integer.parseInt((String)nextField));
                continue;
            }
            if (nextCommand.equals("PageNumber")) continue;
            LogWriter.writeFormLog("{stream} MK command NOT IMPLEMENTED command=" + nextCommand, false);
        }
    }

    private String[] populateItemsArrayWithValues(String object, Map valuesMap) {
        boolean inString = false;
        StringTokenizer token = new StringTokenizer(object, "[]()\\", true);
        String[] items = new String[token.countTokens()];
        int i = 0;
        int brackets = 0;
        int sqBrk = 0;
        StringBuffer valueToAdd = null;
        String val = null;
        String[] mapItems = new String[2];
        int m = 0;
        boolean escape = false;
        while (token.hasMoreTokens()) {
            val = token.nextToken();
            if (val.equals("\\") && !escape) {
                escape = true;
                continue;
            }
            escape = false;
            if (val.equals("(")) {
                if (++brackets == 1) {
                    inString = true;
                    valueToAdd = new StringBuffer();
                    continue;
                }
                valueToAdd.append(val);
                continue;
            }
            if (val.equals(")")) {
                if (--brackets == 0) {
                    inString = false;
                    if (sqBrk < 2) {
                        items[i++] = valueToAdd.toString();
                        continue;
                    }
                    if (m >= 2) continue;
                    mapItems[m++] = valueToAdd.toString();
                    continue;
                }
                valueToAdd.append(val);
                continue;
            }
            if (!inString && val.equals("[")) {
                ++sqBrk;
                continue;
            }
            if (sqBrk > 1 && val.equals("]")) {
                if (--sqBrk != 1) continue;
                if (m == 2) {
                    valuesMap.put(mapItems[0], mapItems[1]);
                    m = 0;
                }
                items[i++] = valueToAdd.toString();
                continue;
            }
            if (!inString) continue;
            valueToAdd.append(val);
        }
        if (brackets != 0) {
            items[i++] = valueToAdd.toString();
        }
        String[] valuesArray = new String[i];
        i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                valuesArray[i] = items[i].trim();
            }
            ++i;
        }
        items = valuesArray;
        return items;
    }

    protected void decodeStream(FormObject formObject) {
        int j = 0;
        while (j < this.keySize) {
            String command = this.commands[j];
            Object field = this.currentPdfFile.resolveToMapOrString(command, this.currentField.get(command));
            this.decodeFormCommand(command, field, formObject);
            ++j;
        }
    }

    protected boolean decodeFormCommand(String command, Object field, FormObject formObject) {
        if (field == null) {
            return false;
        }
        boolean notFound = false;
        if (command.equals("AP")) {
            boolean apSet = this.commandAP((Map)field, formObject);
        } else if (command.equals("I")) {
            String defaultSelection = Strip.removeArrayDeleminators((String)field);
            StringTokenizer tok = new StringTokenizer(defaultSelection, " ");
            int[] index = new int[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                index[i++] = Integer.parseInt(tok.nextToken());
            }
            formObject.setTopIndex(index);
        } else if (command.equals("H")) {
            this.commandH(field, formObject);
        } else if (command.equals("Kids")) {
            this.resolveKidsArray(field, false, false, formObject);
        } else if (command.equals("DA")) {
            String textString;
            byte[] stream = new byte[]{};
            if (field instanceof Map) {
                Map mapField = (Map)field;
                mapField.remove("PageNumber");
                if (mapField.containsKey("rawValue")) {
                    Object test = this.currentPdfFile.resolveToMapOrString("rawValue", mapField.get("rawValue"));
                    stream = test instanceof byte[] ? (byte[])test : ((String)test).getBytes();
                    this.decodeFontCommandObj((String)this.currentPdfFile.resolveToMapOrString("rawValue", mapField.get("rawValue")), formObject);
                    if (mapField.size() > 1) {
                        LogWriter.writeFormLog("{stream} type IS MAP UNKNOWN field=" + field, false);
                    }
                } else {
                    LogWriter.writeFormLog("{stream} DA IS MAP field=" + field, false);
                }
            } else if (field instanceof byte[]) {
                stream = (byte[])field;
            } else {
                stream = ((String)field).getBytes();
                this.decodeFontCommandObj((String)field, formObject);
            }
            if ((textString = formObject.getContents()) != null) {
                byte[] textbytes = textString.getBytes();
                int streamLength = stream.length;
                byte[] newbytes = new byte[streamLength + textbytes.length];
                int i = 0;
                while (i < newbytes.length) {
                    newbytes[i] = i < streamLength ? stream[i] : textbytes[i - streamLength];
                    ++i;
                }
                PdfStreamDecoder textDecoder = new PdfStreamDecoder();
                textDecoder.decodeStreamIntoObjects(newbytes);
                StringBuffer textData = textDecoder.getlastTextStreamDecoded();
                if (textData != null) {
                    formObject.setTextValue(textData.toString());
                }
            }
        } else {
            notFound = true;
        }
        return notFound;
    }

    protected void commandH(Object field, FormObject formObject) {
        String key = Strip.checkRemoveLeadingSlach((String)field);
        if (key.equals("T") || key.equals("P")) {
            if (!formObject.hasDownImage()) {
                formObject.setOffsetDownApp();
            }
        } else if (key.equals("N")) {
            formObject.setNoDownIcon();
        } else if (key.equals("I")) {
            formObject.setInvertForDownIcon();
        } else if (!key.equals("O")) {
            LogWriter.writeFormLog("{FormStream.commandH} H command NOT IMPLEMENTED field=" + field, false);
        }
    }
}

