/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.decoding;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.acroforms.decoding.FormStream;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class AnnotStream
extends FormStream {
    protected AnnotStream() {
    }

    public AnnotStream(PdfObjectReader inCurrentPdfFile) {
        this.currentPdfFile = inCurrentPdfFile;
        this.type = 1;
        this.init();
    }

    protected void parseStream(FormObject formObject) {
        block165: {
            Object subtype;
            block171: {
                block170: {
                    block169: {
                        block168: {
                            block167: {
                                block166: {
                                    block164: {
                                        formObject.setBorder(null);
                                        this.currentField.remove("P");
                                        subtype = this.currentPdfFile.resolveToMapOrString("Subtype", this.currentField.get("Subtype"));
                                        if (subtype == null) {
                                            return;
                                        }
                                        if (!((String)subtype).startsWith("/")) {
                                            subtype = "/" + subtype;
                                        }
                                        if (!subtype.equals("/Text")) break block164;
                                        formObject.setCharacteristic(4);
                                        formObject.setCharacteristic(5);
                                        formObject.setType(11);
                                        this.createOrderedCommandArray();
                                        int i = 0;
                                        while (i < this.commands.length) {
                                            String curCommand = this.commands[i];
                                            Object curField = this.currentPdfFile.resolveToMapOrString(curCommand, this.currentField.get(curCommand));
                                            if (curCommand.equals("Type")) {
                                                curField.equals("/Annot");
                                            } else if (!curCommand.equals("Subtype")) {
                                                if (curCommand.equals("Rect")) {
                                                    this.createBoundsRectangle((String)curField, formObject);
                                                } else if (curCommand.equals("AP")) {
                                                    boolean apSet = this.commandAP((Map)curField, formObject);
                                                } else if (curCommand.equals("C")) {
                                                    boolean cSet = this.commandC(formObject, curField);
                                                } else if (curCommand.equals("Contents")) {
                                                    boolean contentsSet = this.commandContents(formObject, curField);
                                                } else if (curCommand.equals("Popup")) {
                                                    formObject.setActionFlag(1);
                                                    formObject.setPopupObj(curField);
                                                } else if (curCommand.equals("Open")) {
                                                    formObject.setOpenState(Boolean.valueOf((String)curField));
                                                } else if (!(curCommand.equals("Name") || curCommand.equals("M") || curCommand.equals("CreationDate"))) {
                                                    if (curCommand.equals("RC")) {
                                                        this.commandRC(curField, formObject);
                                                    } else if (curCommand.equals("F")) {
                                                        this.workOutCharachteristic((String)curField, formObject);
                                                    } else if (curCommand.equals("T")) {
                                                        formObject.setPopupTitle((String)curField);
                                                    } else if (curCommand.equals("NM")) {
                                                        this.commandNM(formObject, curField);
                                                    } else if (!curCommand.equals("Subj")) {
                                                        if (curCommand.equals("PageNumber")) {
                                                            formObject.setPageNumber(curField);
                                                        } else if (curCommand.equals("BS")) {
                                                            formObject.setBorder(curField);
                                                        }
                                                    }
                                                }
                                            }
                                            ++i;
                                        }
                                        break block165;
                                    }
                                    if (subtype.equals("/Popup")) break block165;
                                    if (!subtype.equals("/Ink")) break block166;
                                    formObject.setType(13);
                                    this.createOrderedCommandArray();
                                    int i = 0;
                                    while (i < this.commands.length) {
                                        String curCommand = this.commands[i];
                                        Object curField = this.currentPdfFile.resolveToMapOrString(curCommand, this.currentField.get(curCommand));
                                        if (curCommand.equals("Type")) {
                                            curField.equals("/Annot");
                                        } else if (!curCommand.equals("Subtype")) {
                                            if (curCommand.equals("Rect")) {
                                                this.createBoundsRectangle((String)curField, formObject);
                                            } else if (curCommand.equals("AP")) {
                                                if (!formObject.hasNormalOff()) {
                                                    boolean contentsSet = this.commandAP((Map)curField, formObject);
                                                }
                                            } else if (curCommand.equals("C")) {
                                                boolean cSet = this.commandC(formObject, curField);
                                            } else if (curCommand.equals("F")) {
                                                this.workOutCharachteristic((String)curField, formObject);
                                            } else if (curCommand.equals("T")) {
                                                formObject.setPopupTitle((String)curField);
                                            } else if (!curCommand.equals("M") && !curCommand.equals("CreationDate")) {
                                                if (curCommand.equals("NM")) {
                                                    this.commandNM(formObject, curField);
                                                } else if (!curCommand.equals("Subj")) {
                                                    if (curCommand.equals("PageNumber")) {
                                                        formObject.setPageNumber(curField);
                                                    } else if (curCommand.equals("InkList")) {
                                                        if (this.currentField.containsKey("AP")) {
                                                            this.commandAP((Map)this.currentPdfFile.resolveToMapOrString("AP", this.currentField.get("AP")), formObject);
                                                        }
                                                        if (!formObject.hasNormalOff()) {
                                                            this.commandInkList(curField, formObject);
                                                        }
                                                    } else if (curCommand.equals("Popup")) {
                                                        formObject.setActionFlag(1);
                                                        formObject.setPopupObj(curField);
                                                    }
                                                }
                                            }
                                        }
                                        ++i;
                                    }
                                    break block165;
                                }
                                if (!subtype.equals("/Square")) break block167;
                                formObject.setType(12);
                                this.createOrderedCommandArray();
                                int i = 0;
                                while (i < this.commands.length) {
                                    String curCommand = this.commands[i];
                                    Object curField = this.currentPdfFile.resolveToMapOrString(curCommand, this.currentField.get(curCommand));
                                    if (curCommand.equals("Type")) {
                                        curField.equals("/Annot");
                                    } else if (!curCommand.equals("Subtype")) {
                                        if (curCommand.equals("Rect")) {
                                            this.createBoundsRectangle((String)curField, formObject);
                                        } else if (curCommand.equals("AP")) {
                                            boolean apSet = this.commandAP((Map)curField, formObject);
                                        } else if (curCommand.equals("C")) {
                                            boolean cSet = this.commandC(formObject, curField);
                                        } else if (curCommand.equals("F")) {
                                            this.workOutCharachteristic((String)curField, formObject);
                                        } else if (curCommand.equals("T")) {
                                            formObject.setPopupTitle((String)curField);
                                        } else if (!curCommand.equals("M") && !curCommand.equals("CreationDate")) {
                                            if (curCommand.equals("NM")) {
                                                this.commandNM(formObject, curField);
                                            } else if (!curCommand.equals("Subj")) {
                                                if (curCommand.equals("PageNumber")) {
                                                    formObject.setPageNumber(curField);
                                                } else if (curCommand.equals("Popup")) {
                                                    formObject.setActionFlag(1);
                                                    formObject.setPopupObj(curField);
                                                } else if (curCommand.equals("RD")) {
                                                    this.commandRD(curField, formObject);
                                                }
                                            }
                                        }
                                    }
                                    ++i;
                                }
                                break block165;
                            }
                            if (!subtype.equals("/FreeText")) break block168;
                            formObject.setType(14);
                            this.createOrderedCommandArray();
                            int i = 0;
                            while (i < this.commands.length) {
                                String curCommand = this.commands[i];
                                Object curField = this.currentPdfFile.resolveToMapOrString(curCommand, this.currentField.get(curCommand));
                                if (curCommand.equals("Type")) {
                                    curField.equals("/Annot");
                                } else if (!curCommand.equals("Subtype")) {
                                    if (curCommand.equals("Rect")) {
                                        this.createBoundsRectangle((String)curField, formObject);
                                    } else if (curCommand.equals("AP")) {
                                        boolean apSet = this.commandAP((Map)curField, formObject);
                                    } else if (curCommand.equals("C")) {
                                        boolean cSet = this.commandC(formObject, curField);
                                    } else if (curCommand.equals("F")) {
                                        this.workOutCharachteristic((String)curField, formObject);
                                    } else if (curCommand.equals("T")) {
                                        formObject.setPopupTitle((String)curField);
                                    } else if (!curCommand.equals("M") && !curCommand.equals("CreationDate")) {
                                        if (curCommand.equals("NM")) {
                                            this.commandNM(formObject, curField);
                                        } else if (!curCommand.equals("Subj")) {
                                            if (curCommand.equals("PageNumber")) {
                                                formObject.setPageNumber(curField);
                                            } else if (!curCommand.equals("DS")) {
                                                if (curCommand.equals("Contents")) {
                                                    boolean contentsSet = this.commandContents(formObject, curField);
                                                } else if (curCommand.equals("RC")) {
                                                    this.commandRC(curField, formObject);
                                                } else if (curCommand.equals("DA")) {
                                                    formObject.setDefaultValue((String)curField);
                                                } else if (curCommand.equals("Open")) {
                                                    formObject.setOpenState(Boolean.valueOf((String)curField));
                                                } else if (curCommand.equals("BS")) {
                                                    formObject.setBorder(curField);
                                                } else if (!curCommand.equals("IT") && curCommand.equals("RD")) {
                                                    StringTokenizer tok = new StringTokenizer((String)curField, "[ ]");
                                                    int left = new Double(tok.nextToken()).intValue();
                                                    int top = new Double(tok.nextToken()).intValue();
                                                    int right = new Double(tok.nextToken()).intValue();
                                                    int bottom = new Double(tok.nextToken()).intValue();
                                                    Rectangle rect = formObject.getBoundingRectangle();
                                                    rect.x += left;
                                                    rect.y += top;
                                                    rect.width += left + right;
                                                    rect.height += top + bottom;
                                                    formObject.setBoundingRectangle(rect);
                                                }
                                            }
                                        }
                                    }
                                }
                                ++i;
                            }
                            break block165;
                        }
                        if (!subtype.equals("/Link")) break block169;
                        formObject.setType(15);
                        this.createOrderedCommandArray();
                        int i = 0;
                        while (i < this.commands.length) {
                            String curCommand = this.commands[i];
                            Object curField = this.currentPdfFile.resolveToMapOrString(curCommand, this.currentField.get(curCommand));
                            if (curCommand.equals("Type")) {
                                if (!curField.equals("/Annot")) {
                                    curField.equals("/Action");
                                }
                            } else if (!curCommand.equals("Subtype")) {
                                if (curCommand.equals("Rect")) {
                                    this.createBoundsRectangle((String)curField, formObject);
                                } else if (curCommand.equals("PageNumber")) {
                                    formObject.setPageNumber(curField);
                                } else if (!curCommand.equals("StructParent")) {
                                    if (curCommand.equals("A")) {
                                        this.commandA(curField, formObject);
                                    } else if (curCommand.equals("H")) {
                                        this.commandH(curField, formObject);
                                    } else if (curCommand.equals("Border")) {
                                        this.commandBorder(curField);
                                    } else if (curCommand.equals("BS")) {
                                        formObject.setBorder(curField);
                                    } else if (curCommand.equals("C")) {
                                        this.commandC(formObject, curField);
                                    } else if (curCommand.equals("Dest") && curField != null) {
                                        HashMap activateAction = new HashMap();
                                        HashMap<String, Object> destMap = new HashMap<String, Object>();
                                        if (curField instanceof Map) {
                                            curField = ((Map)curField).get("D");
                                        }
                                        StringTokenizer tok = new StringTokenizer((String)curField, "[ ]", true);
                                        StringBuffer ref = new StringBuffer(5);
                                        Rectangle position = null;
                                        int count = 0;
                                        while (tok.hasMoreTokens()) {
                                            String token = tok.nextToken();
                                            if (token.equals("[") || token.equals("]")) continue;
                                            if (token.equals(" ")) {
                                                if (++count >= 3) continue;
                                                ref.append(token);
                                                continue;
                                            }
                                            if (count < 3) {
                                                ref.append(token);
                                                continue;
                                            }
                                            if (!token.equals("/XYZ")) continue;
                                            float realX = 0.0f;
                                            float realY = 0.0f;
                                            String x = " ";
                                            String y = " ";
                                            while (x.equals(" ")) {
                                                x = tok.nextToken();
                                            }
                                            while (y.equals(" ")) {
                                                y = tok.nextToken();
                                            }
                                            if (!x.equals("null")) {
                                                realX = Float.parseFloat(x);
                                            }
                                            if (!y.equals("null")) {
                                                realY = Float.parseFloat(y);
                                            }
                                            position = new Rectangle((int)realX, (int)realY, 10, 10);
                                        }
                                        String reference = ref.toString();
                                        destMap.put("Page", reference);
                                        destMap.put("Position", position);
                                        activateAction.put("Dest", destMap);
                                        formObject.setAaction(activateAction);
                                    } else {
                                        curCommand.equals("M");
                                    }
                                }
                            }
                            ++i;
                        }
                        break block165;
                    }
                    if (!subtype.equals("/Widget")) break block170;
                    super.parseStream(formObject);
                    super.decodeStream(formObject);
                    break block165;
                }
                if (!subtype.equals("/Highlight")) break block171;
                LogWriter.writeFormLog("{AnnotStream.parseStream} Highlight command NOT IMPLEMENTED", false);
                break block165;
            }
            if (!subtype.equals("/Stamp")) break block165;
            formObject.setType(16);
            this.createOrderedCommandArray();
            int i = 0;
            while (i < this.commands.length) {
                String curCommand = this.commands[i];
                Object curField = this.currentPdfFile.resolveToMapOrString(curCommand, this.currentField.get(curCommand));
                if (curCommand.equals("Type")) {
                    curField.equals("/Annot");
                } else if (!curCommand.equals("Subtype")) {
                    if (curCommand.equals("Rect")) {
                        this.createBoundsRectangle((String)curField, formObject);
                    } else if (curCommand.equals("Popup")) {
                        formObject.setActionFlag(1);
                        formObject.setPopupObj(curField);
                    } else if (curCommand.equals("C")) {
                        this.commandC(formObject, curField);
                    } else if (!curCommand.equals("M")) {
                        if (curCommand.equals("F")) {
                            this.workOutCharachteristic((String)curField, formObject);
                        } else if (curCommand.equals("T")) {
                            formObject.setPopupTitle((String)curField);
                        } else if (!curCommand.equals("Subj") && !curCommand.equals("Name")) {
                            if (curCommand.equals("NM")) {
                                this.commandNM(formObject, curField);
                            } else if (!curCommand.equals("CreationDate")) {
                                if (curCommand.equals("AP")) {
                                    this.commandAP((Map)curField, formObject);
                                } else if (!curCommand.equals("Rotate") && curCommand.equals("BS")) {
                                    formObject.setBorder(curField);
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void commandBorder(Object curField) {
        if (this.currentField.containsKey("BS")) {
            return;
        }
        curField = Strip.removeArrayDeleminators((String)curField);
        StringTokenizer tok = new StringTokenizer((String)curField);
        float horizRad = 0.0f;
        float verticRad = 0.0f;
        float width = 0.0f;
        try {
            horizRad = Float.parseFloat(tok.nextToken());
            verticRad = Float.parseFloat(tok.nextToken());
            width = Float.parseFloat(tok.nextToken());
        }
        catch (NumberFormatException e) {
            LogWriter.writeFormLog("Border in annot.parsestream Link NOT numbers", false);
            return;
        }
        if (width == 0.0f) {
            return;
        }
        if (horizRad == 0.0f && verticRad == 0.0f) {
            LogWriter.writeFormLog("{AnnotStream.commandBorder} squared border NOT IMPLEMENTED", false);
        } else {
            LogWriter.writeFormLog("{AnnotStream.commandBorder} create rounded rectangle border NOT IMPLEMENTED", false);
        }
        if (tok.hasMoreTokens() && tok.nextToken().startsWith("[")) {
            LogWriter.writeFormLog("{AnnotStream.commandBorder} dash array NOT IMPLEMENTED", false);
        }
    }

    private void createOrderedCommandArray() {
        Iterator iter = this.currentField.keySet().iterator();
        this.keySize = this.currentField.keySet().size();
        this.commands = new String[this.keySize];
        int endnum = this.keySize - 1;
        int num = 0;
        while (iter.hasNext()) {
            String command = (String)iter.next();
            if (command.equals("AP")) {
                this.commands[endnum] = command;
                --endnum;
                continue;
            }
            this.commands[num] = command;
            ++num;
        }
    }

    private void commandRC(Object curField, FormObject formObject) {
    }

    private boolean commandC(FormObject formObject, Object curField) {
        Color cColor = this.generateColorFromString((String)curField);
        if (cColor != null) {
            formObject.setCColor(cColor);
            return true;
        }
        return false;
    }

    private boolean commandContents(FormObject formObject, Object curField) {
        if (curField instanceof String) {
            formObject.setContents((String)curField);
            return true;
        }
        LogWriter.writeFormLog("{stream} Contents command is NON String field=" + curField, false);
        return false;
    }

    protected void decodeStream(FormObject formObject) {
        int j = 0;
        while (j < this.keySize) {
            String command = this.commands[j];
            Object field = this.currentPdfFile.resolveToMapOrString(command, this.currentField.get(command));
            boolean notFound = this.decodeFormCommand(command, field, formObject);
            if (notFound) {
                this.decodeAnnotCommand(command, field, formObject);
            }
            ++j;
        }
    }

    protected boolean decodeAnnotCommand(String command, Object field, FormObject formObject) {
        boolean notFound = false;
        if (command.equals("InkList")) {
            PdfShape currentDrawShape = new PdfShape();
            Rectangle rect = formObject.getBoundingRectangle();
            String paths = Strip.removeArrayDeleminators((String)field);
            StringTokenizer tok = new StringTokenizer(paths, "[] ", true);
            boolean isFirstPoint = false;
            String first = null;
            String second = null;
            while (tok.hasMoreTokens()) {
                String next = tok.nextToken();
                if (next.equals("[")) {
                    isFirstPoint = true;
                    continue;
                }
                if (next.equals("]") || next.equals(" ")) continue;
                if (first == null) {
                    first = next;
                    continue;
                }
                second = next;
                if (isFirstPoint) {
                    currentDrawShape.moveTo(Float.parseFloat(first) - (float)rect.x, Float.parseFloat(second) - (float)rect.y);
                    isFirstPoint = false;
                } else {
                    currentDrawShape.lineTo(Float.parseFloat(first) - (float)rect.x, Float.parseFloat(second) - (float)rect.y);
                }
                first = null;
            }
            GraphicsState currentGraphicsState = formObject.getGraphicsState();
            Shape currentShape = currentDrawShape.generateShapeFromPath(null, currentGraphicsState.CTM, false, null, false, null, currentGraphicsState.getLineWidth(), 0.0f);
            Stroke inkStroke = currentGraphicsState.getStroke();
            BufferedImage image = new BufferedImage(rect.width, rect.height, 2);
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            g2.setStroke(inkStroke);
            g2.setColor(Color.red);
            g2.scale(1.0, -1.0);
            g2.translate(0, -image.getHeight());
            g2.draw(currentShape);
            g2.dispose();
            formObject.setNormalAppOff(image, null);
        } else if (command.equals("RD")) {
            StringTokenizer tok = new StringTokenizer(Strip.removeArrayDeleminators((String)field));
            float left = Float.parseFloat(tok.nextToken());
            float top = Float.parseFloat(tok.nextToken());
            float right = Float.parseFloat(tok.nextToken());
            float bottom = Float.parseFloat(tok.nextToken());
            formObject.setInternalBounds(left, top, right, bottom);
        } else {
            notFound = true;
        }
        return notFound;
    }

    private void commandRD(Object field, FormObject formObject) {
        StringTokenizer tok = new StringTokenizer(Strip.removeArrayDeleminators((String)field));
        float left = Float.parseFloat(tok.nextToken());
        float top = Float.parseFloat(tok.nextToken());
        float right = Float.parseFloat(tok.nextToken());
        float bottom = Float.parseFloat(tok.nextToken());
        formObject.setInternalBounds(left, top, right, bottom);
    }

    private void commandInkList(Object field, FormObject formObject) {
        PdfShape currentDrawShape = new PdfShape();
        Rectangle rect = formObject.getBoundingRectangle();
        String paths = Strip.removeArrayDeleminators((String)field);
        StringTokenizer tok = new StringTokenizer(paths, "[] ", true);
        int countArrays = 0;
        boolean isFirstPoint = false;
        String first = null;
        String second = null;
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            if (next.equals("[")) {
                ++countArrays;
                isFirstPoint = true;
                continue;
            }
            if (next.equals("]")) {
                --countArrays;
                continue;
            }
            if (next.equals(" ")) continue;
            if (first == null) {
                first = next;
                continue;
            }
            second = next;
            if (isFirstPoint) {
                currentDrawShape.moveTo(Float.parseFloat(first) - (float)rect.x, Float.parseFloat(second) - (float)rect.y);
                isFirstPoint = false;
            } else {
                currentDrawShape.lineTo(Float.parseFloat(first) - (float)rect.x, Float.parseFloat(second) - (float)rect.y);
            }
            first = null;
        }
        GraphicsState currentGraphicsState = formObject.getGraphicsState();
        Shape currentShape = currentDrawShape.generateShapeFromPath(null, currentGraphicsState.CTM, false, null, false, null, currentGraphicsState.getLineWidth(), 0.0f);
        Stroke inkStroke = currentGraphicsState.getStroke();
        BufferedImage image = new BufferedImage(rect.width, rect.height, 2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setStroke(inkStroke);
        g2.setColor(Color.red);
        g2.scale(1.0, -1.0);
        g2.translate(0, -image.getHeight());
        g2.draw(currentShape);
        g2.dispose();
        formObject.setNormalAppOff(image, null);
    }
}

