/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions;

import java.awt.Rectangle;
import java.util.StringTokenizer;
import javax.swing.JTextField;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.utils.Strip;

public class PdfPopup
extends JTextField {
    public PdfPopup(FormObject formObject, int pageHeight, int insetH, String rectShape, boolean isVisible) {
        String popupTitle = formObject.getPopupTitle() == null ? "TEST popupTitle not set in formobject" : formObject.getPopupTitle();
        this.setText(popupTitle);
        Rectangle rect = this.createBoundsRectangle(rectShape, null);
        rect.y = pageHeight - rect.y - rect.height + insetH;
        this.setBounds(rect);
        this.setVisible(isVisible);
    }

    private Rectangle createBoundsRectangle(String rect, FormObject formObject) {
        double tmp;
        rect = Strip.removeArrayDeleminators(rect);
        StringTokenizer tok = new StringTokenizer(rect);
        double x1 = Float.parseFloat(tok.nextToken());
        double y1 = Float.parseFloat(tok.nextToken());
        double x2 = Float.parseFloat(tok.nextToken());
        double y2 = Float.parseFloat(tok.nextToken());
        if (x1 > x2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y1 > y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        Rectangle bBox = new Rectangle((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
        if (formObject == null) {
            return bBox;
        }
        formObject.setBoundingRectangle(bBox);
        return null;
    }
}

