/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Event;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.gui.Summary;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.acroforms.specificImplementations.CustomActionListener;
import org.jpedal.objects.acroforms.specificImplementations.CustomMouseListener;
import org.jpedal.objects.acroforms.utils.ConvertToString;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;

public class DefaultActionHandler
implements ActionHandler {
    private PdfObjectReader currentPdfFile;
    private Javascript javascript;
    private AcroRenderer acrorend;
    private PdfDecoder decode_pdf;
    private int pageHeight;
    private int insetH;

    public void init(PdfDecoder decode_pdf, PdfObjectReader pdfFile, Javascript javascript, AcroRenderer acrorend) {
        this.currentPdfFile = pdfFile;
        this.javascript = javascript;
        this.acrorend = acrorend;
        this.decode_pdf = decode_pdf;
    }

    public void setPageAccess(int pageHeight, int insetH) {
        this.pageHeight = pageHeight;
        this.insetH = insetH;
    }

    public ActionListener setupChangingDownIcon(BufferedImage downOff, BufferedImage downOn) {
        return new CustomActionListener(downOff, downOn);
    }

    public MouseListener setupChangingCaption(String normalCaption, String rolloverCaption, String downCaption) {
        return new CustomMouseListener(normalCaption, rolloverCaption, downCaption);
    }

    public MouseListener setComboClickOnEntry(String ref) {
        return new CustomMouseListener(ref, "comboEntry", null);
    }

    public MouseListener setHoverCursor() {
        return new MouseListener(){

            public void mouseEntered(MouseEvent e) {
                DefaultActionHandler.this.decode_pdf.setCursor(new Cursor(12));
            }

            public void mouseExited(MouseEvent e) {
                DefaultActionHandler.this.decode_pdf.setCursor(new Cursor(0));
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        };
    }

    public void A(MouseEvent e, FormObject formObj, int eventType) {
        int popupFlag = formObj.getActionFlag();
        Object data = formObj.getAobj();
        int typeFlag = formObj.getType();
        if (typeFlag == 3) {
            this.additionalAction_Signature(formObj, eventType);
        } else if (popupFlag > 0 || data instanceof Map) {
            Map aDataMap = new HashMap();
            if (data != null) {
                aDataMap = (Map)data;
            }
            if (aDataMap.containsKey("S")) {
                String command = (String)aDataMap.get("S");
                if ((command = Strip.checkRemoveLeadingSlach(command)).equals("Named")) {
                    if (aDataMap.containsKey("N")) {
                        String nameCmd = (String)aDataMap.get("N");
                        if ((nameCmd = Strip.checkRemoveLeadingSlach(nameCmd)).equals("Print")) {
                            this.additionalAction_Print(eventType);
                        } else if (nameCmd.equals("SaveAs")) {
                            LogWriter.writeFormLog("Named Action=SaveAs pagenumber=" + aDataMap.get("PageNumber"), false);
                        } else if (!nameCmd.startsWith("AcroForm:")) {
                            if (nameCmd.startsWith("NextPage")) {
                                LogWriter.writeFormLog("Named action NextPage NOT implemented" + nameCmd, false);
                            } else if (!nameCmd.startsWith("ZoomTo")) {
                                if (nameCmd.startsWith("FullScreen")) {
                                    LogWriter.writeFormLog("Named action FullScreen NOT implemented" + nameCmd, false);
                                } else {
                                    LogWriter.writeFormLog("{stream} Named Action NOT IMPLEMENTED command=" + nameCmd + " field=" + ConvertToString.convertMapToString(aDataMap, null), false);
                                }
                            }
                        }
                    }
                } else if (command.equals("GoTo") && aDataMap.containsKey("D")) {
                    this.addtionalAction_Goto(formObj, eventType);
                } else if (command.equals("ResetForm")) {
                    this.additionalAction_ResetForm(eventType);
                } else if (command.equals("SubmitForm")) {
                    this.additionalAction_SubmitForm(eventType, aDataMap);
                } else if (command.equals("JavaScript")) {
                    LogWriter.writeFormLog("{stream} JavaScript field=" + ConvertToString.convertMapToString(aDataMap, null), false);
                } else if (command.equals("Hide")) {
                    this.additionalAction_Hide(eventType, aDataMap);
                } else if (command.equals("URI")) {
                    this.additionalAction_URI(eventType, aDataMap);
                } else if (command.equals("Launch")) {
                    LogWriter.writeFormLog("{stream} launch activate action NOT IMPLEMENTED", false);
                } else if (command.equals("GoTo")) {
                    LogWriter.writeFormLog("{FormStream.resolveAdditionalAction} /GoTo action NOT IMPLEMENTED", false);
                } else if (command.equals("GoToR")) {
                    this.addAdditionalAction_GotoR(eventType, aDataMap);
                } else {
                    LogWriter.writeFormLog("{stream} UNKNOWN command for Activate Action command=" + command + " field=" + ConvertToString.convertMapToString(aDataMap, null), false);
                }
            } else if (aDataMap.containsKey("Dest")) {
                if (eventType == 3) {
                    Map destMap = (Map)((Map)formObj.getAobj()).get("Dest");
                    int pageNumber = this.decode_pdf.getPageFromObjectRef((String)destMap.get("Page"));
                    Rectangle location = (Rectangle)destMap.get("Position");
                    this.changeTo(null, pageNumber, location);
                } else if (eventType == 4) {
                    this.decode_pdf.setCursor(new Cursor(12));
                } else if (eventType == 5) {
                    this.decode_pdf.setCursor(new Cursor(0));
                }
            } else if (formObj.getActionFlag() == 1) {
                e.getClickCount();
            } else {
                LogWriter.writeFormLog("{stream} Activate Action UNKNOWN command NOT IMPLEMENTED field=" + ConvertToString.convertMapToString(aDataMap, null), false);
            }
        } else if (data != null) {
            LogWriter.writeFormLog("{stream} A additionalAction NON Map UNIMPLEMENTED", false);
        }
    }

    private void addAdditionalAction_GotoR(int eventType, Map aDataMap) {
        if (eventType == 3) {
            int page;
            int index;
            String stpage = (String)aDataMap.get("D");
            Map dataMap = (Map)aDataMap.get("F");
            String type = (String)dataMap.get("Type");
            String file = (String)dataMap.get("F");
            if (file.startsWith("(")) {
                file = file.substring(1, file.length() - 1);
            }
            if (stpage.startsWith("(")) {
                stpage = stpage.substring(1, stpage.length() - 1);
            }
            if ((index = stpage.indexOf("P.")) != -1) {
                stpage = stpage.substring(index + 2, stpage.length());
                page = Integer.parseInt(stpage);
            } else {
                page = stpage.equals("F") ? 1 : 1;
            }
            if (type.equals("/Filespec")) {
                if (file.startsWith("./")) {
                    file = new File(file.substring(2, file.length())).getAbsolutePath();
                }
                if (file.startsWith("../")) {
                    String tmp = new File("").getAbsolutePath();
                    file = String.valueOf(tmp.substring(0, tmp.lastIndexOf(92) + 1)) + file.substring(3, file.length());
                }
                if (new File(file).exists()) {
                    this.changeTo(file, page, null);
                    LogWriter.writeFormLog("{DefaultActionHamdler.A} Form has GoToR command, needs methods for opening new file on page specified", false);
                } else {
                    JOptionPane.showMessageDialog(this.decode_pdf, "The file specified " + file + " Does Not Exist!");
                }
            } else {
                LogWriter.writeFormLog("{CustomMouseListener.mouseClicked} GoToRemote NON Filespec NOT IMPLEMENTED", false);
            }
        } else if (eventType == 4) {
            this.decode_pdf.setCursor(new Cursor(12));
        } else if (eventType == 5) {
            this.decode_pdf.setCursor(new Cursor(0));
        }
    }

    private void additionalAction_URI(int eventType, Map aDataMap) {
        String url = this.removeBrackets((String)aDataMap.get("URI"));
        if (eventType == 3) {
            try {
                BrowserLauncher.openURL(url);
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(null, Messages.getMessage("PdfViewer.ErrorWebsite"));
            }
        } else if (eventType == 4) {
            this.decode_pdf.setCursor(new Cursor(12));
        } else if (eventType == 5) {
            this.decode_pdf.setCursor(new Cursor(0));
        }
    }

    private void additionalAction_Hide(int eventType, Map aDataMap) {
        if (eventType == 1) {
            HashMap hideMap = new HashMap();
            this.getHideMap(aDataMap, hideMap);
            String[] fieldsToHide = (String[])hideMap.get("fields");
            Boolean[] whetherToHide = (Boolean[])hideMap.get("hide");
            if (fieldsToHide.length != whetherToHide.length) {
                LogWriter.writeFormLog("{custommouselistener} number of fields and nuber of hides or not the same", false);
                return;
            }
            int i = 0;
            while (i < fieldsToHide.length) {
                Component[] checkObj = (Component[])this.acrorend.getComponentsByName(fieldsToHide[i]);
                if (checkObj != null) {
                    int j = 0;
                    while (j < checkObj.length) {
                        checkObj[j].setVisible(whetherToHide[i] == false);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private void additionalAction_SubmitForm(int eventType, Map aDataMap) {
        if (eventType == 3) {
            String submitURL;
            Object fObj;
            if (aDataMap.containsKey("Fields")) {
                StringTokenizer fieldsTok = new StringTokenizer((String)aDataMap.get("Fields"), "[]()");
                String preName = null;
                StringBuffer names = new StringBuffer();
                while (fieldsTok.hasMoreTokens()) {
                    String tok = fieldsTok.nextToken();
                    if (tok.indexOf(".x") != -1) {
                        preName = tok.substring(tok.indexOf(46) + 1, tok.indexOf(".x") + 1);
                    }
                    if (tok.indexOf(" R") == -1) continue;
                    tok = (String)this.currentPdfFile.readObject(tok.trim(), false, null).get("T");
                    if (preName != null) {
                        names.append(preName);
                    }
                    names.append(tok.substring(1, tok.length() - 1));
                    names.append(',');
                }
                aDataMap.put("Fields", names.toString());
            }
            if ((fObj = aDataMap.get("F")) instanceof Map) {
                submitURL = (String)((Map)fObj).get("F");
                if (submitURL.startsWith("(")) {
                    submitURL = submitURL.substring(1, submitURL.length() - 1);
                }
            } else {
                submitURL = (String)fObj;
                if (submitURL.startsWith("(")) {
                    submitURL = submitURL.substring(1, submitURL.length() - 1);
                }
            }
            if (submitURL != null) {
                Component[] compsToSubmit = new Component[]{};
                if (aDataMap.containsKey("Fields")) {
                    StringTokenizer fieldsTok = new StringTokenizer((String)aDataMap.get("Fields"), ",");
                    String[] includeNameList = new String[]{};
                    String[] listOfNames = new String[fieldsTok.countTokens()];
                    int i = 0;
                    while (fieldsTok.hasMoreTokens()) {
                        listOfNames[i++] = fieldsTok.nextToken();
                    }
                    Object obj = aDataMap.get("Flags");
                    int value = 0;
                    if (obj instanceof String) {
                        value = Integer.parseInt((String)obj);
                    } else if (obj instanceof Integer) {
                        value = (Integer)obj;
                    } else {
                        LogWriter.writeFormLog("(internal only) flags NON Sting = " + obj.getClass() + ' ' + obj, false);
                    }
                    if ((value & 1) == 1) {
                        try {
                            List tmplist = this.acrorend.getComponentNameList();
                            if (tmplist != null) {
                                i = 0;
                                while (i < listOfNames.length) {
                                    tmplist.remove(listOfNames[i]);
                                    ++i;
                                }
                            }
                        }
                        catch (PdfException e1) {
                            LogWriter.writeFormLog("DefaultFormFactory.setupMouseListener() get component name list exception", false);
                        }
                    } else {
                        includeNameList = listOfNames;
                    }
                    i = 0;
                    while (i < includeNameList.length) {
                        Component[] compsToAdd = (Component[])this.acrorend.getComponentsByName(includeNameList[i]);
                        Component[] tmp = new Component[compsToSubmit.length + compsToAdd.length];
                        if (compsToAdd.length > 1) {
                            LogWriter.writeFormLog("(internal only) SubmitForm multipul components with same name", false);
                        }
                        i = 0;
                        while (i < tmp.length) {
                            if (i < compsToSubmit.length) {
                                tmp[i] = compsToSubmit[i];
                            } else if (i - compsToSubmit.length < compsToAdd.length) {
                                tmp[i] = compsToAdd[i - compsToSubmit.length];
                            }
                            ++i;
                        }
                        compsToSubmit = tmp;
                        ++i;
                    }
                } else {
                    compsToSubmit = (Component[])this.acrorend.getComponentsByName(null);
                }
                String text = "";
                int i = 0;
                while (i < compsToSubmit.length) {
                    if (compsToSubmit[i] instanceof JTextComponent) {
                        text = String.valueOf(text) + ((JTextComponent)compsToSubmit[i]).getText();
                    } else if (compsToSubmit[i] instanceof AbstractButton) {
                        text = String.valueOf(text) + ((AbstractButton)compsToSubmit[i]).getText();
                    } else {
                        LogWriter.writeFormLog("(internal only) SubmitForm field form type not accounted for", false);
                    }
                    ++i;
                }
                try {
                    BrowserLauncher.openURL(String.valueOf(submitURL) + "?en&q=" + text);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(null, Messages.getMessage("PdfViewer.ErrorWebsite"));
                    e1.printStackTrace();
                }
            }
        }
    }

    private void additionalAction_ResetForm(int eventType) {
        if (eventType == 1) {
            String[] defaultValues = this.acrorend.getCompData().getDefaultValues();
            Component[] allFields = (Component[])this.acrorend.getComponentsByName(null);
            int i = 0;
            while (i < allFields.length) {
                if (allFields[i] != null) {
                    if (allFields[i] instanceof AbstractButton) {
                        int ptr;
                        String fieldState;
                        if (allFields[i] instanceof JCheckBox) {
                            if (defaultValues[i] == null) {
                                ((JCheckBox)allFields[i]).setSelected(false);
                            } else {
                                fieldState = allFields[i].getName();
                                ptr = fieldState.indexOf("-(");
                                if (ptr != -1) {
                                    fieldState = fieldState.substring(ptr + 2, fieldState.length() - 1);
                                }
                                if (fieldState.equals(defaultValues[i])) {
                                    ((JCheckBox)allFields[i]).setSelected(true);
                                } else {
                                    ((JCheckBox)allFields[i]).setSelected(false);
                                }
                                LogWriter.writeFormLog("{renderer} resetform on mouse press " + allFields[i].getClass() + " - " + defaultValues[i] + " current=" + ((JCheckBox)allFields[i]).isSelected() + ' ' + ((JCheckBox)allFields[i]).getText(), false);
                            }
                        } else if (allFields[i] instanceof JButton) {
                            LogWriter.writeFormLog("{renderer{ resetform on mouse press " + allFields[i].getClass() + " - " + defaultValues[i] + " current=" + ((JButton)allFields[i]).isSelected() + ' ' + ((JButton)allFields[i]).getText(), false);
                        } else if (allFields[i] instanceof JRadioButton) {
                            if (defaultValues[i] == null) {
                                ((JRadioButton)allFields[i]).setSelected(false);
                            } else {
                                fieldState = allFields[i].getName();
                                ptr = fieldState.indexOf("-(");
                                if (ptr != -1) {
                                    fieldState = fieldState.substring(ptr + 2, fieldState.length() - 1);
                                }
                                if (fieldState.equals(defaultValues[i])) {
                                    ((JRadioButton)allFields[i]).setSelected(true);
                                } else {
                                    ((JRadioButton)allFields[i]).setSelected(false);
                                }
                            }
                        }
                    } else if (allFields[i] instanceof JTextComponent) {
                        String fieldName = allFields[i].getName();
                        this.acrorend.getCompData().setValue(fieldName, defaultValues[i], true, true);
                    } else if (allFields[i] instanceof JComboBox) {
                        ((JComboBox)allFields[i]).setSelectedItem(defaultValues[i]);
                    } else if (allFields[i] instanceof JList) {
                        ((JList)allFields[i]).setSelectedValue(defaultValues[i], true);
                    }
                    allFields[i].repaint();
                }
                ++i;
            }
        }
    }

    private void addtionalAction_Goto(FormObject formObj, int eventType) {
        if (eventType == 3) {
            String ref = (String)((Map)formObj.getAobj()).get("D");
            String pageRef = ref.substring(1, ref.indexOf(47) - 1);
            int pageNumber = this.decode_pdf.getPageFromObjectRef(pageRef);
            this.changeTo(null, pageNumber, new Rectangle(0, 0, 0, 0));
        } else if (eventType == 4) {
            this.decode_pdf.setCursor(new Cursor(12));
        } else if (eventType == 5) {
            this.decode_pdf.setCursor(new Cursor(0));
        }
    }

    private void additionalAction_Print(int eventType) {
        if (eventType == 2 && JOptionPane.showConfirmDialog(null, Messages.getMessage("PdfViewerPrinting.ConfirmPrint"), Messages.getMessage("PdfViewerPrint.Printing"), 0) == 0) {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            PageFormat pf = printJob.defaultPage();
            int orientation = this.decode_pdf.getPDFWidth() < this.decode_pdf.getPDFHeight() ? 1 : 0;
            pf.setOrientation(orientation);
            Paper paper = new Paper();
            paper.setSize(595.0, 842.0);
            paper.setImageableArea(43.0, 43.0, 509.0, 756.0);
            pf.setPaper(paper);
            printJob.setPrintable(this.decode_pdf, pf);
            try {
                printJob.print();
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }
    }

    private void additionalAction_Signature(FormObject formObj, int eventType) {
        if (eventType == 3) {
            Map sigObject = this.decode_pdf.getCurrentFormRenderer().getSignatureObject(formObj.getPDFRef());
            if (sigObject == null) {
                return;
            }
            JDialog frame = new JDialog(null, "Signature Properties", true);
            Summary summary = new Summary(frame, sigObject);
            summary.setValues((String)sigObject.get("Name"), (String)sigObject.get("Reason"), (String)sigObject.get("M"), (String)sigObject.get("Location"));
            frame.getContentPane().add(summary);
            frame.setSize(550, 220);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        } else if (eventType == 4) {
            this.decode_pdf.setCursor(new Cursor(12));
        } else if (eventType == 5) {
            this.decode_pdf.setCursor(new Cursor(0));
        }
    }

    public void changeTo(String file, int page, Rectangle location) {
        if (file != null) {
            try {
                this.decode_pdf.openPdfFile(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (page != -1 && page > 0 && page < this.decode_pdf.getPageCount()) {
            try {
                this.decode_pdf.decodePage(page);
                this.decode_pdf.updatePageNumberDisplayed(page);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.decode_pdf.setPageParameters(-1.0f, page);
        }
        if (location != null) {
            this.decode_pdf.scrollRectToVisible(location);
        }
        this.decode_pdf.invalidate();
        this.decode_pdf.updateUI();
    }

    public void E(MouseEvent e, FormObject formObj) {
    }

    public void X(MouseEvent e, FormObject formObj) {
    }

    public void D(MouseEvent e, FormObject formObj) {
    }

    public void U(MouseEvent e, FormObject formObj) {
    }

    public void Fo(FocusEvent e, FormObject formObj) {
    }

    public void Bl(FocusEvent e, FormObject formObj) {
    }

    public void O(int pageNumber) {
        Object Oaction = null;
    }

    public void PO(int pageNumber) {
        Object POaction = null;
    }

    public void PC(int pageNumber) {
    }

    public void PV(int pageNumber) {
    }

    public void PI(int pageNumber) {
    }

    public int K(ComponentEvent ex, FormObject formObj, int actionID) {
        int val = 0;
        return val;
    }

    private char getKeyPressed(ComponentEvent ex) {
        if (ex instanceof KeyEvent) {
            return ((KeyEvent)ex).getKeyChar();
        }
        return ' ';
    }

    public void F(Event e, FormObject formObj) {
    }

    public void V(ComponentEvent ex, FormObject formObj, int actionID) {
    }

    public void C(Event e, FormObject formObj) {
    }

    private String removeBrackets(String text) {
        if (text.startsWith("(") || text.startsWith("[") || text.startsWith("{")) {
            if (text.endsWith(")")) {
                return text.substring(1, text.length() - 1);
            }
            return text.substring(1, text.length() - 2);
        }
        return text;
    }

    private void getHideMap(Map aDataMap, Map hideMap) {
        Boolean[] hideFlags;
        String[] fields;
        if (!Strip.checkRemoveLeadingSlach((String)aDataMap.get("S")).equals("Hide")) {
            LogWriter.writeFormLog("{stream} getHideMap has a NON Hide value field=" + aDataMap, false);
        }
        if (hideMap.containsKey("fields")) {
            String[] mapToAdd = (String[])hideMap.get("fields");
            fields = new String[mapToAdd.length + 1];
            System.arraycopy(mapToAdd, 0, fields, 0, mapToAdd.length);
            fields[fields.length - 1] = (String)aDataMap.get("T");
        } else {
            fields = new String[]{(String)aDataMap.get("T")};
        }
        hideMap.put("fields", fields);
        Boolean hideFlag = Boolean.TRUE;
        if (aDataMap.containsKey("H")) {
            hideFlag = Boolean.valueOf((String)aDataMap.get("H"));
        }
        if (hideMap.containsKey("hide")) {
            Boolean[] mapToAdd = (Boolean[])hideMap.get("hide");
            hideFlags = new Boolean[mapToAdd.length + 1];
            System.arraycopy(mapToAdd, 0, hideFlags, 0, mapToAdd.length);
            hideFlags[hideFlags.length - 1] = hideFlag;
        } else {
            hideFlags = new Boolean[]{hideFlag};
        }
        hideMap.put("hide", hideFlags);
        if (aDataMap.containsKey("Next")) {
            this.getHideMap((Map)aDataMap.get("Next"), hideMap);
        }
    }
}

