/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_String;

public class PdfPageData
implements Serializable {
    private static final String SEPARATOR = "|";
    private static final String ROTATION_SEPARATOR = "/";
    private static final boolean debug = false;
    private boolean valuesSet = false;
    private boolean useCustomRounding = true;
    private Vector_Int rotationXX;
    private Vector_String mediaString;
    private Vector_String cropString;
    private Vector_Float mediaBoxWidths;
    private Vector_Float mediaBoxHeights;
    private Vector_Float mediaBoxXs;
    private Vector_Float mediaBoxYs;
    private Vector_Float cropBoxWidths;
    private Vector_Float cropBoxHeights;
    private Vector_Float cropBoxXs;
    private Vector_Float cropBoxYs;
    private int lastPage = -1;
    private int raw_rotation = 0;
    private int pagesRead = -1;
    private String defaultMediaValue = null;
    private int rotation = 0;
    private Vector_String rawValues = new Vector_String(500);
    private float cropBoxX = -99999.0f;
    private float cropBoxY = -1.0f;
    private float cropBoxW = -1.0f;
    private float cropBoxH = -1.0f;
    private float mediaBoxX = -1.0f;
    private float mediaBoxY;
    private float mediaBoxW;
    private float mediaBoxH;
    private String cropValue = "";
    private float scalingValue = 1.0f;
    private String mediaValue = "";
    private int defaultrotation;
    private float defaultcropBoxX;
    private float defaultcropBoxY;
    private float defaultcropBoxW;
    private float defaultcropBoxH;
    private float defaultmediaBoxX;
    private float defaultmediaBoxY;
    private float defaultmediaBoxW;
    private float defaultmediaBoxH;

    public PdfPageData(float scaling) {
        this.scalingValue = scaling;
    }

    public PdfPageData() {
    }

    public void checkSizeSet(int pageNumber) {
        if (this.mediaValue == null) {
            this.mediaValue = this.defaultMediaValue;
        }
        if (this.raw_rotation != 0) {
            StringBuffer newValue = new StringBuffer(String.valueOf(this.raw_rotation));
            newValue.append(ROTATION_SEPARATOR);
            int previousValue = this.mediaValue.lastIndexOf(ROTATION_SEPARATOR);
            if (previousValue == -1) {
                newValue.append(this.mediaValue);
            } else {
                newValue.append(this.mediaValue.substring(previousValue + 1));
            }
            this.mediaValue = newValue.toString();
        }
        if (this.cropValue != null && !this.mediaValue.equals(this.cropValue)) {
            StringBuffer combinedValue = new StringBuffer(this.mediaValue);
            combinedValue.append(SEPARATOR);
            combinedValue.append(this.cropValue);
            this.rawValues.setElementAt(combinedValue.toString(), pageNumber);
        } else if (this.mediaValue != null && this.mediaValue.equals(this.defaultMediaValue)) {
            this.rawValues.setElementAt(null, pageNumber);
        } else {
            this.rawValues.setElementAt(this.mediaValue, pageNumber);
        }
        if (this.pagesRead < pageNumber) {
            this.pagesRead = pageNumber;
        }
        this.mediaValue = null;
        this.cropValue = null;
    }

    public final int getMediaBoxHeight(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.mediaBoxH;
    }

    public final int getMediaBoxY(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.mediaBoxY;
    }

    public final int getMediaBoxX(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.mediaBoxX;
    }

    public void setMediaBox(String value) {
        this.mediaValue = Strip.removeArrayDeleminators(value);
        this.cropValue = null;
        if (this.defaultMediaValue == null) {
            this.defaultMediaValue = this.mediaValue;
        }
    }

    public void setCropBox(String value) {
        this.cropValue = Strip.removeArrayDeleminators(value);
    }

    public int setPageRotation(String value, int pageNumber) {
        this.raw_rotation = Integer.parseInt(value);
        if (this.raw_rotation < 0) {
            this.raw_rotation += 360;
        }
        return this.raw_rotation;
    }

    public final int getMediaBoxWidth(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.mediaBoxW;
    }

    public String getMediaValue(int currentPage) {
        int separator;
        int rotPrefix;
        String raw = this.rawValues.elementAt(currentPage);
        if (raw.length() == 0) {
            raw = this.defaultMediaValue;
        }
        if ((rotPrefix = raw.indexOf(ROTATION_SEPARATOR)) != -1) {
            raw = raw.substring(rotPrefix + 1);
        }
        if ((separator = raw.indexOf(SEPARATOR)) == -1) {
            return raw;
        }
        return raw.substring(0, separator);
    }

    public String getCropValue(int currentPage) {
        int separator;
        int rotPrefix;
        String raw = this.rawValues.elementAt(currentPage);
        if (raw.length() == 0) {
            raw = this.defaultMediaValue;
        }
        if ((rotPrefix = raw.indexOf(ROTATION_SEPARATOR)) != -1) {
            raw = raw.substring(rotPrefix + 1);
        }
        if ((separator = raw.indexOf(SEPARATOR)) == -1) {
            return raw;
        }
        return raw.substring(separator + 1);
    }

    public int getScaledCropBoxX(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return this.roundFloat(this.cropBoxX * this.scalingValue);
    }

    public int getScaledCropBoxWidth(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return this.roundFloat(this.cropBoxW * this.scalingValue);
    }

    public int getScaledCropBoxY(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return this.roundFloat(this.cropBoxY * this.scalingValue);
    }

    public int getScaledCropBoxHeight(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return this.roundFloat(this.cropBoxH * this.scalingValue);
    }

    public int getCropBoxX(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.cropBoxX;
    }

    public int getCropBoxWidth(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.cropBoxW;
    }

    public int getCropBoxY(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.cropBoxY;
    }

    public int getCropBoxHeight(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return (int)this.cropBoxH;
    }

    private void setSizeForPage(int pageNumber) {
        if (pageNumber > this.pagesRead) {
            this.mediaBoxX = 0.0f;
            this.mediaBoxY = 0.0f;
            this.mediaBoxW = 0.0f;
            this.mediaBoxH = 0.0f;
            this.cropBoxX = 0.0f;
            this.cropBoxY = 0.0f;
            this.cropBoxW = 0.0f;
            this.cropBoxH = 0.0f;
        } else if (pageNumber > 0 && this.lastPage != pageNumber) {
            this.lastPage = pageNumber;
            this.rotation = 0;
            boolean usingDefault = false;
            String raw = this.rawValues.elementAt(pageNumber);
            if (raw.length() == 0 && this.defaultMediaValue != null) {
                raw = this.defaultMediaValue;
                usingDefault = true;
            }
            if (this.valuesSet && usingDefault) {
                this.rotation = this.defaultrotation;
                this.cropBoxX = this.defaultcropBoxX;
                this.mediaBoxX = this.defaultmediaBoxX;
                this.cropBoxY = this.defaultcropBoxY;
                this.mediaBoxY = this.defaultmediaBoxY;
                this.cropBoxW = this.defaultcropBoxW;
                this.mediaBoxW = this.defaultmediaBoxW;
                this.cropBoxH = this.defaultcropBoxH;
                this.mediaBoxH = this.defaultmediaBoxH;
            } else {
                int separator;
                int rotPrefix = raw.indexOf(ROTATION_SEPARATOR);
                if (rotPrefix != -1) {
                    String rotValue = raw.substring(0, rotPrefix);
                    this.rotation = Integer.parseInt(rotValue);
                    raw = raw.substring(rotPrefix + 1);
                }
                StringTokenizer media_values = (separator = raw.indexOf(SEPARATOR)) == -1 ? new StringTokenizer(raw, " ") : new StringTokenizer(raw.substring(0, separator), " ");
                this.mediaBoxX = 0.0f;
                this.mediaBoxY = 0.0f;
                this.mediaBoxW = 800.0f;
                this.mediaBoxH = 800.0f;
                if (media_values.countTokens() == 4) {
                    this.mediaBoxX = Float.parseFloat(media_values.nextToken());
                    this.mediaBoxY = Float.parseFloat(media_values.nextToken());
                    this.mediaBoxW = Float.parseFloat(media_values.nextToken()) - this.mediaBoxX;
                    this.mediaBoxH = Float.parseFloat(media_values.nextToken()) - this.mediaBoxY;
                }
                if (separator != -1) {
                    float temp;
                    media_values = new StringTokenizer(raw.substring(separator + 1), " ");
                    this.cropBoxX = Float.parseFloat(media_values.nextToken());
                    this.cropBoxY = Float.parseFloat(media_values.nextToken());
                    this.cropBoxW = Float.parseFloat(media_values.nextToken());
                    this.cropBoxH = Float.parseFloat(media_values.nextToken());
                    if (this.cropBoxX > this.cropBoxW) {
                        temp = this.cropBoxX;
                        this.cropBoxX = this.cropBoxW;
                        this.cropBoxW = temp;
                    }
                    if (this.cropBoxY > this.cropBoxH) {
                        temp = this.cropBoxY;
                        this.cropBoxY = this.cropBoxH;
                        this.cropBoxH = temp;
                    }
                    this.cropBoxW -= this.cropBoxX;
                    this.cropBoxH -= this.cropBoxY;
                } else {
                    this.cropBoxX = this.mediaBoxX;
                    this.cropBoxY = this.mediaBoxY;
                    this.cropBoxW = this.mediaBoxW;
                    this.cropBoxH = this.mediaBoxH;
                }
            }
            if (usingDefault && !this.valuesSet) {
                this.defaultrotation = this.rotation;
                this.defaultcropBoxX = this.cropBoxX;
                this.defaultmediaBoxX = this.mediaBoxX;
                this.defaultcropBoxY = this.cropBoxY;
                this.defaultmediaBoxY = this.mediaBoxY;
                this.defaultcropBoxW = this.cropBoxW;
                this.defaultmediaBoxW = this.mediaBoxW;
                this.defaultcropBoxH = this.cropBoxH;
                this.defaultmediaBoxH = this.mediaBoxH;
                this.valuesSet = true;
            }
        }
    }

    public float getScalingValue() {
        return this.scalingValue;
    }

    public void setScalingValue(float scalingValue) {
        this.scalingValue = scalingValue;
    }

    private int roundFloat(float origValue) {
        float frac;
        int roundedValue = (int)origValue;
        if (this.useCustomRounding && (double)(frac = origValue - (float)roundedValue) > 0.3) {
            ++roundedValue;
        }
        return roundedValue;
    }

    public final int getRotation(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return this.rotation;
    }

    public final int getScaledMediaBoxHeight(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return this.roundFloat(this.mediaBoxH * this.scalingValue);
    }

    public final int getScaledMediaBoxWidth(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return this.roundFloat(this.mediaBoxW * this.scalingValue);
    }

    public final int getScaledMediaBoxX(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return this.roundFloat(this.mediaBoxX * this.scalingValue);
    }

    public final int getScaledMediaBoxY(int pageNumber) {
        this.setSizeForPage(pageNumber);
        return this.roundFloat(this.mediaBoxY * this.scalingValue);
    }
}

