/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_String;

public class PdfImageData {
    private Vector_Int object_page_id = new Vector_Int(100);
    private Vector_Float x = new Vector_Float(100);
    private Vector_Float y = new Vector_Float(100);
    private Vector_Float w = new Vector_Float(100);
    private Vector_Float h = new Vector_Float(100);
    private Vector_String object_image_name = new Vector_String(100);
    private Map xformName = new HashMap();
    private Map xformData = new HashMap();
    private int current_item = 0;

    public final void setImageInfo(String image_name, int current_page_id, float x1, float y1, float w1, float h1, String xform) {
        this.object_page_id.addElement(current_page_id);
        this.object_image_name.addElement(image_name);
        this.x.addElement(x1);
        this.y.addElement(y1);
        this.h.addElement(h1);
        this.w.addElement(w1);
        if (xform != null) {
            this.xformName.put(image_name, xform);
        }
        ++this.current_item;
    }

    public final float getImageYCoord(int i) {
        return this.y.elementAt(i);
    }

    public final float getImageWidth(int i) {
        return this.w.elementAt(i);
    }

    public final float getImageHeight(int i) {
        return this.h.elementAt(i);
    }

    public final int getImagePageID(int i) {
        return this.object_page_id.elementAt(i);
    }

    public final String getImageName(int i) {
        return this.object_image_name.elementAt(i);
    }

    public final void clearImageData() {
        this.object_image_name.clear();
        this.xformName.clear();
        this.xformData.clear();
        this.object_page_id.clear();
        this.x.clear();
        this.y.clear();
        this.w.clear();
        this.h.clear();
        this.current_item = 0;
    }

    public final float getImageXCoord(int i) {
        return this.x.elementAt(i);
    }

    public final int getImageCount() {
        return this.current_item;
    }

    public String getParentXForm(String image_name) {
        return (String)this.xformName.get(image_name);
    }

    public void setXformData(String lastFormID, Map formData) {
        this.xformData.put(lastFormID, formData);
    }

    public Map getXFormData(String parentXform) {
        if (parentXform == null) {
            return null;
        }
        return (Map)this.xformData.get(parentXform);
    }
}

