/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jpedal.PdfDecoder;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.StoryData;
import org.jpedal.objects.TextState;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LineBreaker;
import org.jpedal.utils.repositories.Vector_Int;

public class PdfData
extends StoryData {
    private static final long serialVersionUID = 8229354993149694377L;
    Vector_Int itemsOnEachPage = new Vector_Int(5);
    Vector_Int displacementForEachPage = new Vector_Int(5);
    public static final int TEXT = 0;
    public static final int IMAGE = 1;
    public static final int HORIZONTAL_LEFT_TO_RIGHT = 0;
    public static final int HORIZONTAL_RIGHT_TO_LEFT = 1;
    public static final int VERTICAL_TOP_TO_BOTTOM = 2;
    public static final int VERTICAL_BOTTOM_TO_TOP = 3;
    private List text_objects;
    Map extractedTextFields = new HashMap();
    Map extractedXMLFields = new HashMap();
    private int pointer = 0;
    private int additionalPageCount = 0;
    private int originalSize = -1;
    public String[] fragments = new String[this.max];
    public int[] parent = new int[this.max];
    public int[] childrenParent = new int[this.max];
    private boolean widthIsEmbedded = false;
    public float maxY = 0.0f;
    public float maxX = 0.0f;
    public int[] fontSize;
    public int[] rotation = new int[this.max];
    private Map globalValues = new HashMap();
    private Map globalSettings = new HashMap();

    public PdfData() {
        this.text_objects = new Vector();
        int i = 0;
        while (i < this.max) {
            this.parent[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.max) {
            this.childrenParent[i] = -1;
            ++i;
        }
    }

    public final Map getTextElementAt(int i) {
        return (Map)this.text_objects.get(i);
    }

    public final int getRawTextElementCount() {
        return this.pointer;
    }

    public final void resetTextList(List new_text_objects) {
        this.text_objects = new_text_objects;
    }

    public final void flushTextList(boolean reinit) {
        this.text_objects = new Vector();
        if (!reinit) {
            this.pointer = 0;
            this.max = 2000;
            this.contents = new String[this.max];
            this.f_writingMode = new int[this.max];
            this.f_font_used = new String[this.max];
            this.font_data = new String[this.max];
            this.text_length = new int[this.max];
            this.lineCount = new int[this.max];
            this.move_command = new int[this.max];
            this.f_character_spacing = new float[this.max];
            this.token_counter = new int[this.max];
            this.rotation = new int[this.max];
            this.f_end_font_size = new int[this.max];
            this.space_width = new float[this.max];
            this.f_x1 = new float[this.max];
            this.f_x2 = new float[this.max];
            this.f_y1 = new float[this.max];
            this.f_y2 = new float[this.max];
            this.colorTag = new String[this.max];
        }
        this.itemsOnEachPage.clear();
        this.displacementForEachPage.clear();
        this.additionalPageCount = 0;
    }

    public final int getTextElementCount() {
        return this.text_objects.size();
    }

    public final void addImageElement(float x1, float y1, float width, float height, String imageName) {
        this.f_x1[this.pointer] = x1;
        this.objectType[this.pointer] = 1;
        this.f_x2[this.pointer] = x1 + width;
        this.f_y1[this.pointer] = y1 + height;
        this.f_y2[this.pointer] = y1;
        this.fragments[this.pointer] = String.valueOf(this.pointer);
        this.contents[this.pointer] = imageName;
        this.unformattedContent[this.pointer] = imageName;
        ++this.pointer;
        if (this.pointer == this.max) {
            this.resizeArrays(0);
        }
    }

    public final void breakLineInHalf(int original, float x1, float y1, float x2, float y2, boolean debugFlag) {
        if (debugFlag) {
            System.out.println("id=" + original + " x1,y1=" + x1 + ' ' + y1 + " x2,y2=" + x2 + ' ' + y2 + '\n' + this.contents[original]);
        }
        this.f_writingMode[this.pointer] = this.f_writingMode[original];
        this.font_data[this.pointer] = this.font_data[original];
        this.move_command[this.pointer] = this.move_command[original];
        this.f_character_spacing[this.pointer] = this.f_character_spacing[original];
        this.colorTag[this.pointer] = this.colorTag[original];
        this.objectType[this.pointer] = 0;
        this.token_counter[this.pointer] = this.token_counter[original];
        this.rotation[this.pointer] = this.rotation[original];
        this.f_end_font_size[this.pointer] = this.f_end_font_size[original];
        this.f_font_used[this.pointer] = this.f_font_used[original];
        this.space_width[this.pointer] = this.space_width[original];
        LineBreaker breaker = new LineBreaker();
        breaker.breakLine(this.contents[original], x1, y1, x2, y2, debugFlag);
        this.f_x1[this.pointer] = breaker.endX;
        this.f_x2[this.pointer] = this.f_x2[original];
        this.f_x1[original] = this.f_x1[original];
        this.f_x2[original] = breaker.startX;
        this.f_y1[this.pointer] = this.f_y1[original];
        this.f_y2[this.pointer] = this.f_y2[original];
        this.text_length[this.pointer] = breaker.charsCounted;
        this.text_length[original] = this.text_length[original] - breaker.charsCounted;
        StringBuffer truncated = new StringBuffer();
        truncated.append(this.contents[original].substring(0, breaker.brk).trim());
        StringBuffer removedString = new StringBuffer();
        removedString.append(this.contents[original].substring(breaker.brk, this.contents[original].length()).trim());
        if (PdfDecoder.isXMLExtraction()) {
            removedString.insert(0, this.font_data[this.pointer]);
            truncated.append(Fonts.fe);
        }
        if (this.isColorExtracted()) {
            removedString.insert(0, this.colorTag[this.pointer]);
            truncated.append("</color>");
        }
        this.contents[original] = truncated.toString();
        this.contents[this.pointer] = removedString.toString();
        this.lineCount[this.pointer] = this.lineCount[original];
        if (debugFlag) {
            System.out.println("orig=" + PdfGroupingAlgorithms.removeHiddenMarkers(truncated.toString()) + '<');
            System.out.println("original at " + this.f_x1[original] + ' ' + this.f_y1[original] + ' ' + this.f_x2[original] + ' ' + this.f_y2[original]);
            System.out.println("removed=" + PdfGroupingAlgorithms.removeHiddenMarkers(removedString.toString()) + '<');
            System.out.println("removed at " + this.f_x1[this.pointer] + ' ' + this.f_y1[this.pointer] + ' ' + this.f_x2[this.pointer] + ' ' + this.f_y2[this.pointer]);
        }
        ++this.pointer;
        if (this.pointer == this.max) {
            this.resizeArrays(0);
        }
    }

    public final void addRawTextElement(float character_spacing, int writingMode, String font_as_string, float current_space, TextState current_text_state, float x1, float y1, float x2, float y2, int move_type, StringBuffer processed_line, int token_number, int current_text_length, String currentColorTag, int rotation) {
        if (processed_line.length() > 0) {
            int font_size;
            if (PdfDecoder.isXMLExtraction()) {
                processed_line.insert(0, font_as_string);
                processed_line.append(Fonts.fe);
            }
            if (this.isColorExtracted()) {
                processed_line.insert(0, currentColorTag);
                processed_line.append("</color>");
            }
            this.f_writingMode[this.pointer] = writingMode;
            this.font_data[this.pointer] = font_as_string;
            this.text_length[this.pointer] = current_text_length;
            this.move_command[this.pointer] = move_type;
            this.f_character_spacing[this.pointer] = character_spacing;
            this.f_x1[this.pointer] = x1;
            this.colorTag[this.pointer] = currentColorTag;
            this.f_x2[this.pointer] = x2;
            this.f_y1[this.pointer] = y1;
            this.f_y2[this.pointer] = y2;
            this.objectType[this.pointer] = 0;
            this.lineCount[this.pointer] = 1;
            this.contents[this.pointer] = processed_line.toString();
            this.token_counter[this.pointer] = token_number;
            this.f_end_font_size[this.pointer] = font_size = current_text_state.getCurrentFontSize();
            this.f_font_used[this.pointer] = current_text_state.getFontName();
            this.space_width[this.pointer] = current_space * 1000.0f;
            this.rotation[this.pointer] = rotation;
            ++this.pointer;
            if (this.pointer == this.max) {
                this.resizeArrays(0);
            }
        }
    }

    public final void addRawBrokenFragment(int j, StringBuffer text, float x1, float x2, float y1, float y2, String plotString, String currentColorTag) {
        if (x1 > 0.0f & y1 > 0.0f & x2 > 0.0f & y2 > 0.0f) {
            if (PdfDecoder.isXMLExtraction() && !text.toString().endsWith(Fonts.fe) && !text.toString().endsWith("</color>")) {
                text.append(Fonts.fe);
            }
            this.f_writingMode[this.pointer] = this.f_writingMode[j];
            this.font_data[this.pointer] = this.font_data[j];
            this.text_length[this.pointer] = this.text_length[j];
            this.lineCount[this.pointer] = this.lineCount[j];
            this.move_command[this.pointer] = this.move_command[j];
            this.f_character_spacing[this.pointer] = this.f_character_spacing[j];
            this.f_x1[this.pointer] = x1;
            this.f_x2[this.pointer] = x2;
            this.f_y1[this.pointer] = y1;
            this.f_y2[this.pointer] = y2;
            this.colorTag[this.pointer] = currentColorTag;
            this.contents[this.pointer] = text.toString();
            this.token_counter[this.pointer] = this.token_counter[j];
            this.rotation[this.pointer] = this.rotation[j];
            this.f_end_font_size[this.pointer] = this.f_end_font_size[j];
            this.f_font_used[this.pointer] = this.f_font_used[j];
            this.space_width[this.pointer] = this.space_width[j];
            ++this.pointer;
            if (this.pointer == this.max) {
                this.resizeArrays(0);
            }
        }
    }

    public PdfData cloneData() {
        int length = this.contents.length;
        boolean start = false;
        PdfData newData = new PdfData();
        newData.resizeArrays(-length);
        System.arraycopy(this.contents, 0, newData.contents, 0, length);
        System.arraycopy(this.rawData, 0, newData.rawData, 0, length);
        System.arraycopy(this.unformattedContent, 0, newData.unformattedContent, 0, length);
        System.arraycopy(this.f_writingMode, 0, newData.f_writingMode, 0, length);
        System.arraycopy(this.f_font_used, 0, newData.f_font_used, 0, length);
        System.arraycopy(this.colorTag, 0, newData.colorTag, 0, length);
        System.arraycopy(this.font_data, 0, newData.font_data, 0, length);
        System.arraycopy(this.fragments, 0, newData.fragments, 0, length);
        System.arraycopy(this.rotation, 0, newData.rotation, 0, length);
        System.arraycopy(this.text_length, 0, newData.text_length, 0, length);
        System.arraycopy(this.lineCount, 0, newData.lineCount, 0, length);
        System.arraycopy(this.move_command, 0, newData.move_command, 0, length);
        System.arraycopy(this.f_character_spacing, 0, newData.f_character_spacing, 0, length);
        System.arraycopy(this.parent, 0, newData.parent, 0, length);
        System.arraycopy(this.childrenParent, 0, newData.childrenParent, 0, length);
        System.arraycopy(this.prefix, 0, newData.prefix, 0, length);
        System.arraycopy(this.token_counter, 0, newData.token_counter, 0, length);
        System.arraycopy(this.rotation, 0, newData.rotation, 0, length);
        System.arraycopy(this.links, 0, newData.links, 0, length);
        System.arraycopy(this.children, 0, newData.children, 0, length);
        System.arraycopy(this.category, 0, newData.category, 0, length);
        System.arraycopy(this.objectType, 0, newData.objectType, 0, length);
        System.arraycopy(this.f_end_font_size, 0, newData.f_end_font_size, 0, length);
        System.arraycopy(this.space_width, 0, newData.space_width, 0, length);
        System.arraycopy(this.f_x1, 0, newData.f_x1, 0, length);
        System.arraycopy(this.f_x2, 0, newData.f_x2, 0, length);
        System.arraycopy(this.f_y1, 0, newData.f_y1, 0, length);
        System.arraycopy(this.f_y2, 0, newData.f_y2, 0, length);
        newData.pointer = this.pointer;
        newData.additionalPageCount = this.additionalPageCount;
        newData.originalSize = this.originalSize;
        newData.widthIsEmbedded = this.widthIsEmbedded;
        newData.maxY = this.maxY;
        newData.maxX = this.maxX;
        newData.max = this.max;
        return newData;
    }

    public void merge(PdfData pdf_data, int xDisplacement, int rawCount, boolean trackOffset) {
        int[] current;
        int max;
        int newItems;
        int existItems;
        boolean debug = false;
        ++this.additionalPageCount;
        if (this.originalSize == -1) {
            this.originalSize = this.f_x1.length;
        }
        if ((existItems = this.pointer) > this.f_x1.length) {
            existItems = this.f_x1.length;
        }
        if ((newItems = pdf_data.pointer) > pdf_data.f_x1.length) {
            newItems = pdf_data.f_x1.length;
        }
        this.pointer = max = existItems + newItems + 1;
        int i = 0;
        while (i < newItems) {
            pdf_data.f_x1[i] = (float)xDisplacement + pdf_data.f_x1[i];
            pdf_data.f_x2[i] = (float)xDisplacement + pdf_data.f_x2[i];
            ++i;
        }
        if (trackOffset) {
            this.itemsOnEachPage.addElement(existItems);
            this.displacementForEachPage.addElement(xDisplacement);
        }
        String[] temp_s = this.contents;
        this.contents = new String[max];
        System.arraycopy(temp_s, 0, this.contents, 0, existItems);
        System.arraycopy(pdf_data.contents, 0, this.contents, existItems, newItems);
        temp_s = this.rawData;
        this.rawData = new String[max];
        System.arraycopy(temp_s, 0, this.rawData, 0, existItems);
        System.arraycopy(pdf_data.rawData, 0, this.rawData, existItems, newItems);
        int jj = existItems;
        while (jj < existItems + newItems) {
            if (this.rawData[jj] != null) {
                StringTokenizer values = new StringTokenizer(this.rawData[jj], hiddenMarker);
                StringBuffer newVersion = new StringBuffer();
                while (values.hasMoreTokens()) {
                    String metaData = values.nextToken();
                    String text = values.nextToken();
                    StringTokenizer metaValues = new StringTokenizer(metaData, " ");
                    float x1 = Float.parseFloat(metaValues.nextToken()) + (float)xDisplacement;
                    float y1 = Float.parseFloat(metaValues.nextToken());
                    float x2 = Float.parseFloat(metaValues.nextToken()) + (float)xDisplacement;
                    float y2 = Float.parseFloat(metaValues.nextToken());
                    int originalID = Integer.parseInt(metaValues.nextToken()) + rawCount;
                    newVersion.append(hiddenMarker).append(x1).append(' ').append(y1).append(' ').append(x2).append(' ').append(y2).append(' ').append(originalID).append(hiddenMarker).append(text);
                }
                this.rawData[jj] = newVersion.toString();
            }
            ++jj;
        }
        temp_s = this.unformattedContent;
        this.unformattedContent = new String[max];
        System.arraycopy(temp_s, 0, this.unformattedContent, 0, existItems);
        System.arraycopy(pdf_data.unformattedContent, 0, this.unformattedContent, existItems, newItems);
        int[] temp_i = this.f_writingMode;
        this.f_writingMode = new int[max];
        this.f_writingMode = new int[max];
        System.arraycopy(temp_i, 0, this.f_writingMode, 0, existItems);
        System.arraycopy(pdf_data.f_writingMode, 0, this.f_writingMode, existItems, newItems);
        temp_s = this.f_font_used;
        this.f_font_used = new String[max];
        System.arraycopy(temp_s, 0, this.f_font_used, 0, existItems);
        System.arraycopy(pdf_data.f_font_used, 0, this.f_font_used, existItems, newItems);
        temp_s = this.colorTag;
        this.colorTag = new String[max];
        System.arraycopy(temp_s, 0, this.colorTag, 0, existItems);
        System.arraycopy(pdf_data.colorTag, 0, this.colorTag, existItems, newItems);
        temp_s = this.font_data;
        this.font_data = new String[max];
        System.arraycopy(temp_s, 0, this.font_data, 0, existItems);
        System.arraycopy(pdf_data.font_data, 0, this.font_data, existItems, newItems);
        temp_s = this.fragments;
        this.fragments = new String[max];
        System.arraycopy(temp_s, 0, this.fragments, 0, existItems);
        System.arraycopy(pdf_data.fragments, 0, this.fragments, existItems, newItems);
        temp_i = this.rotation;
        this.rotation = new int[max];
        System.arraycopy(temp_i, 0, this.rotation, 0, existItems);
        System.arraycopy(pdf_data.rotation, 0, this.rotation, existItems, newItems);
        jj = existItems;
        while (jj < existItems + newItems) {
            if (this.fragments[jj] != null) {
                StringTokenizer tokens = new StringTokenizer(this.fragments[jj]);
                StringBuffer newValue = new StringBuffer();
                int count = tokens.countTokens();
                int ii = 0;
                while (ii < count) {
                    int id = Integer.parseInt(tokens.nextToken()) + rawCount;
                    newValue.append(id);
                    newValue.append(' ');
                    ++ii;
                }
                this.fragments[jj] = newValue.toString();
            }
            ++jj;
        }
        temp_i = this.text_length;
        this.text_length = new int[max];
        System.arraycopy(temp_i, 0, this.text_length, 0, existItems);
        System.arraycopy(pdf_data.text_length, 0, this.text_length, existItems, newItems);
        temp_i = this.lineCount;
        this.lineCount = new int[max];
        System.arraycopy(temp_i, 0, this.lineCount, 0, existItems);
        System.arraycopy(pdf_data.lineCount, 0, this.lineCount, existItems, newItems);
        temp_i = this.move_command;
        this.move_command = new int[max];
        System.arraycopy(temp_i, 0, this.move_command, 0, existItems);
        System.arraycopy(pdf_data.move_command, 0, this.move_command, existItems, newItems);
        float[] temp_f = this.f_character_spacing;
        this.f_character_spacing = new float[max];
        System.arraycopy(temp_f, 0, this.f_character_spacing, 0, existItems);
        System.arraycopy(pdf_data.f_character_spacing, 0, this.f_character_spacing, existItems, newItems);
        temp_i = this.parent;
        this.parent = new int[max];
        int ii = existItems;
        while (ii < max) {
            this.parent[ii] = -1;
            ++ii;
        }
        System.arraycopy(temp_i, 0, this.parent, 0, existItems);
        System.arraycopy(pdf_data.parent, 0, this.parent, existItems, newItems);
        jj = existItems;
        while (jj < max) {
            if (this.parent[jj] != -1) {
                this.parent[jj] = this.parent[jj] + existItems;
            }
            ++jj;
        }
        temp_i = this.childrenParent;
        this.childrenParent = new int[max];
        ii = existItems;
        while (ii < max) {
            this.childrenParent[ii] = -1;
            ++ii;
        }
        System.arraycopy(temp_i, 0, this.childrenParent, 0, existItems);
        System.arraycopy(pdf_data.childrenParent, 0, this.childrenParent, existItems, newItems);
        jj = existItems;
        while (jj < max) {
            if (this.childrenParent[jj] != -1) {
                this.childrenParent[jj] = this.childrenParent[jj] + existItems;
            }
            ++jj;
        }
        temp_s = this.prefix;
        this.prefix = new String[max];
        ii = existItems;
        while (ii < max) {
            this.prefix[ii] = null;
            ++ii;
        }
        System.arraycopy(temp_s, 0, this.prefix, 0, existItems);
        System.arraycopy(pdf_data.prefix, 0, this.prefix, existItems, newItems);
        temp_i = this.rotation;
        this.rotation = new int[max];
        System.arraycopy(temp_i, 0, this.rotation, 0, existItems);
        System.arraycopy(pdf_data.rotation, 0, this.rotation, existItems, newItems);
        temp_i = this.token_counter;
        this.token_counter = new int[max];
        System.arraycopy(temp_i, 0, this.token_counter, 0, existItems);
        System.arraycopy(pdf_data.token_counter, 0, this.token_counter, existItems, newItems);
        Object[] temp_o = this.links;
        this.links = new Object[max];
        System.arraycopy(temp_o, 0, this.links, 0, existItems);
        System.arraycopy(pdf_data.links, 0, this.links, existItems, newItems);
        temp_o = this.children;
        this.children = new Object[max];
        System.arraycopy(temp_o, 0, this.children, 0, existItems);
        System.arraycopy(pdf_data.children, 0, this.children, existItems, newItems);
        int jj2 = existItems;
        while (jj2 < max) {
            if (this.links[jj2] != null) {
                current = (int[])this.links[jj2];
                int count = current.length;
                int jj22 = 0;
                while (jj22 < count) {
                    if (current[jj22] != -1) {
                        current[jj22] = current[jj22] + existItems;
                    }
                    ++jj22;
                }
                this.links[jj2] = current;
            }
            ++jj2;
        }
        jj2 = existItems;
        while (jj2 < max) {
            if (this.children[jj2] != null) {
                current = (int[])this.children[jj2];
                int count = current.length;
                int jj23 = 0;
                while (jj23 < count) {
                    if (current[jj23] != -1) {
                        current[jj23] = current[jj23] + existItems;
                    }
                    ++jj23;
                }
                this.children[jj2] = current;
            }
            ++jj2;
        }
        temp_s = this.category;
        this.category = new String[max];
        System.arraycopy(temp_s, 0, this.category, 0, existItems);
        System.arraycopy(pdf_data.category, 0, this.category, existItems, newItems);
        temp_i = this.objectType;
        this.objectType = new int[max];
        System.arraycopy(temp_i, 0, this.objectType, 0, existItems);
        System.arraycopy(pdf_data.objectType, 0, this.objectType, existItems, newItems);
        temp_i = this.f_end_font_size;
        this.f_end_font_size = new int[max];
        System.arraycopy(temp_i, 0, this.f_end_font_size, 0, existItems);
        System.arraycopy(pdf_data.f_end_font_size, 0, this.f_end_font_size, existItems, newItems);
        temp_f = this.space_width;
        this.space_width = new float[max];
        System.arraycopy(temp_f, 0, this.space_width, 0, existItems);
        System.arraycopy(pdf_data.space_width, 0, this.space_width, existItems, newItems);
        temp_f = this.f_x1;
        this.f_x1 = new float[max];
        System.arraycopy(temp_f, 0, this.f_x1, 0, existItems);
        System.arraycopy(pdf_data.f_x1, 0, this.f_x1, existItems, newItems);
        temp_f = this.f_x2;
        this.f_x2 = new float[max];
        System.arraycopy(temp_f, 0, this.f_x2, 0, existItems);
        System.arraycopy(pdf_data.f_x2, 0, this.f_x2, existItems, newItems);
        temp_f = this.f_y1;
        this.f_y1 = new float[max];
        System.arraycopy(temp_f, 0, this.f_y1, 0, existItems);
        System.arraycopy(pdf_data.f_y1, 0, this.f_y1, existItems, newItems);
        temp_f = this.f_y2;
        this.f_y2 = new float[max];
        System.arraycopy(temp_f, 0, this.f_y2, 0, existItems);
        System.arraycopy(pdf_data.f_y2, 0, this.f_y2, existItems, newItems);
        if (this.lx1 != null) {
            temp_f = this.lx1;
            this.lx1 = new float[max];
            System.arraycopy(temp_f, 0, this.lx1, 0, existItems);
            System.arraycopy(pdf_data.lx1, 0, this.lx1, existItems, newItems);
            temp_f = this.lx2;
            this.lx2 = new float[max];
            System.arraycopy(temp_f, 0, this.lx2, 0, existItems);
            System.arraycopy(pdf_data.lx2, 0, this.lx2, existItems, newItems);
            temp_f = this.ly1;
            this.ly1 = new float[max];
            System.arraycopy(temp_f, 0, this.ly1, 0, existItems);
            System.arraycopy(pdf_data.ly1, 0, this.ly1, existItems, newItems);
            temp_f = this.ly2;
            this.ly2 = new float[max];
            System.arraycopy(temp_f, 0, this.ly2, 0, existItems);
            System.arraycopy(pdf_data.ly2, 0, this.ly2, existItems, newItems);
        }
    }

    public void resizeArrays(int newItems) {
        if (newItems < 0) {
            this.pointer = this.max = -newItems;
        } else if (newItems == 0) {
            this.max = this.max < 5000 ? (this.max *= 5) : (this.max < 10000 ? (this.max *= 2) : (this.max += 1000));
        } else {
            this.max = this.contents.length + newItems - 1;
            this.pointer = this.contents.length;
        }
        String[] temp_s = this.contents;
        this.contents = new String[this.max];
        System.arraycopy(temp_s, 0, this.contents, 0, this.pointer);
        temp_s = this.rawData;
        this.rawData = new String[this.max];
        System.arraycopy(temp_s, 0, this.rawData, 0, this.pointer);
        temp_s = this.unformattedContent;
        this.unformattedContent = new String[this.max];
        System.arraycopy(temp_s, 0, this.unformattedContent, 0, this.pointer);
        int[] temp_i = this.f_writingMode;
        this.f_writingMode = new int[this.max];
        this.f_writingMode = new int[this.max];
        System.arraycopy(temp_i, 0, this.f_writingMode, 0, this.pointer);
        temp_s = this.f_font_used;
        this.f_font_used = new String[this.max];
        System.arraycopy(temp_s, 0, this.f_font_used, 0, this.pointer);
        temp_s = this.colorTag;
        this.colorTag = new String[this.max];
        System.arraycopy(temp_s, 0, this.colorTag, 0, this.pointer);
        temp_s = this.font_data;
        this.font_data = new String[this.max];
        System.arraycopy(temp_s, 0, this.font_data, 0, this.pointer);
        temp_s = this.fragments;
        this.fragments = new String[this.max];
        System.arraycopy(temp_s, 0, this.fragments, 0, this.pointer);
        temp_i = this.text_length;
        this.text_length = new int[this.max];
        System.arraycopy(temp_i, 0, this.text_length, 0, this.pointer);
        temp_i = this.rotation;
        this.rotation = new int[this.max];
        System.arraycopy(temp_i, 0, this.rotation, 0, this.pointer);
        temp_i = this.lineCount;
        this.lineCount = new int[this.max];
        System.arraycopy(temp_i, 0, this.lineCount, 0, this.pointer);
        temp_i = this.move_command;
        this.move_command = new int[this.max];
        System.arraycopy(temp_i, 0, this.move_command, 0, this.pointer);
        float[] temp_f = this.f_character_spacing;
        this.f_character_spacing = new float[this.max];
        System.arraycopy(temp_f, 0, this.f_character_spacing, 0, this.pointer);
        temp_i = this.parent;
        this.parent = new int[this.max];
        int ii = this.pointer;
        while (ii < this.max) {
            this.parent[ii] = -1;
            ++ii;
        }
        System.arraycopy(temp_i, 0, this.parent, 0, this.pointer);
        temp_i = this.childrenParent;
        this.childrenParent = new int[this.max];
        ii = this.pointer;
        while (ii < this.max) {
            this.childrenParent[ii] = -1;
            ++ii;
        }
        System.arraycopy(temp_i, 0, this.childrenParent, 0, this.pointer);
        temp_s = this.prefix;
        this.prefix = new String[this.max];
        ii = this.pointer;
        while (ii < this.max) {
            this.prefix[ii] = null;
            ++ii;
        }
        System.arraycopy(temp_s, 0, this.prefix, 0, this.pointer);
        temp_i = this.token_counter;
        this.token_counter = new int[this.max];
        System.arraycopy(temp_i, 0, this.token_counter, 0, this.pointer);
        temp_i = this.rotation;
        this.rotation = new int[this.max];
        System.arraycopy(temp_i, 0, this.rotation, 0, this.pointer);
        Object[] temp_o = this.links;
        this.links = new Object[this.max];
        System.arraycopy(temp_o, 0, this.links, 0, this.pointer);
        temp_o = this.children;
        this.children = new Object[this.max];
        System.arraycopy(temp_o, 0, this.children, 0, this.pointer);
        temp_s = this.category;
        this.category = new String[this.max];
        System.arraycopy(temp_s, 0, this.category, 0, this.pointer);
        temp_i = this.objectType;
        this.objectType = new int[this.max];
        System.arraycopy(temp_i, 0, this.objectType, 0, this.pointer);
        temp_i = this.f_end_font_size;
        this.f_end_font_size = new int[this.max];
        System.arraycopy(temp_i, 0, this.f_end_font_size, 0, this.pointer);
        temp_f = this.space_width;
        this.space_width = new float[this.max];
        System.arraycopy(temp_f, 0, this.space_width, 0, this.pointer);
        temp_f = this.f_x1;
        this.f_x1 = new float[this.max];
        System.arraycopy(temp_f, 0, this.f_x1, 0, this.pointer);
        temp_f = this.f_x2;
        this.f_x2 = new float[this.max];
        System.arraycopy(temp_f, 0, this.f_x2, 0, this.pointer);
        temp_f = this.f_y1;
        this.f_y1 = new float[this.max];
        System.arraycopy(temp_f, 0, this.f_y1, 0, this.pointer);
        temp_f = this.f_y2;
        this.f_y2 = new float[this.max];
        System.arraycopy(temp_f, 0, this.f_y2, 0, this.pointer);
    }

    public final void removeTextElementAt(int counter) {
        this.text_objects.remove(new Integer(counter));
    }

    public String getFragments(int i) {
        int maxCount = this.fragments.length;
        while (i < maxCount && this.fragments[i] == null) {
            ++i;
        }
        if (i == maxCount) {
            return null;
        }
        return this.fragments[i];
    }

    public int getParent(int item_selected) {
        return this.parent[item_selected];
    }

    public int getParentChild(int item_selected) {
        return this.childrenParent[item_selected];
    }

    public String getPrefix(int item_selected) {
        return this.prefix[item_selected];
    }

    public void setPrefix(int item, String prefixValue) {
        if (item != -1) {
            int size = this.prefix.length;
            if (item >= size) {
                this.max = this.prefix.length + 100;
                String[] temp_i = this.prefix;
                this.prefix = new String[this.max];
                System.arraycopy(temp_i, 0, this.prefix, 0, size);
                int j = size;
                while (j < this.max) {
                    this.prefix[j] = null;
                    ++j;
                }
            }
            this.prefix[item] = prefixValue;
        }
    }

    public void setParent(int item, int parentID) {
        int size = this.parent.length;
        if (item >= size) {
            this.max = this.parent.length + 100;
            int[] temp_i = this.parent;
            this.parent = new int[this.max];
            System.arraycopy(temp_i, 0, this.parent, 0, size);
            int j = size;
            while (j < this.max) {
                this.parent[j] = -1;
                ++j;
            }
        }
        this.parent[item] = parentID;
    }

    public void setParentChild(int item, int parentID) {
        int size = this.childrenParent.length;
        if (item >= size) {
            this.max = this.childrenParent.length + 100;
            int[] temp_i = this.childrenParent;
            this.childrenParent = new int[this.max];
            System.arraycopy(temp_i, 0, this.childrenParent, 0, size);
            int j = size;
            while (j < this.max) {
                this.childrenParent[j] = -1;
                ++j;
            }
        }
        this.childrenParent[item] = parentID;
    }

    public void widthIsEmbedded() {
        this.widthIsEmbedded = true;
    }

    public boolean IsEmbedded() {
        return this.widthIsEmbedded;
    }

    public int getFontSize(int currentStory) {
        return this.fontSize[currentStory];
    }

    public String getFontTag(int currentStory) {
        return this.f_font_used[currentStory];
    }

    public String getGlobalField(String globalField) {
        return (String)this.globalValues.get(globalField);
    }

    public void setGlobalField(String globalNameForCategory, String value) {
        this.globalValues.put(globalNameForCategory, value);
    }

    public void setMetaFieldUserDefinable(String globalNameForCategory) {
        this.globalSettings.put("editable-" + globalNameForCategory, "x");
    }

    public boolean isMetaFieldUserDefinable(String globalNameForCategory) {
        return this.globalSettings.get("editable-" + globalNameForCategory) != null;
    }

    public void setMetaFieldValues(String globalNameForCategory, String value) {
        this.globalSettings.put("values-" + globalNameForCategory, value);
    }

    public String getMetaFieldValues(String globalNameForCategory) {
        return (String)this.globalSettings.get("values-" + globalNameForCategory);
    }

    public Object[] getGlobalFields() {
        return this.globalValues.keySet().toArray();
    }

    public int getGlobalCategoryCount() {
        return this.globalValues.size();
    }

    public int getRegExpStatus(int i) {
        return this.regExpStatus[i];
    }

    public void setRegExpStatus(int item, int value) {
        int size = this.regExpStatus.length;
        if (item >= size) {
            this.max = this.regExpStatus.length + 100;
            if (item > this.max) {
                this.max = item + 20;
            }
            int[] temp_i = this.regExpStatus;
            this.regExpStatus = new int[this.max];
            System.arraycopy(temp_i, 0, this.regExpStatus, 0, size);
            int j = size;
            while (j < this.max) {
                this.regExpStatus[j] = -1;
                ++j;
            }
        }
        this.regExpStatus[item] = value;
    }

    public void addExtractedXMLField(String fieldName, String data, int id) {
        if (!fieldName.equals("trash")) {
            String currentValue;
            Integer key = new Integer(id);
            HashMap<String, String> currentExtractedFields = (HashMap<String, String>)this.extractedXMLFields.get(key);
            if (currentExtractedFields == null) {
                currentExtractedFields = new HashMap<String, String>();
            }
            if ((currentValue = (String)currentExtractedFields.get(fieldName)) != null) {
                data = String.valueOf(currentValue) + data;
            }
            currentExtractedFields.put(fieldName, data);
            this.extractedXMLFields.put(key, currentExtractedFields);
        }
    }

    public Map getExtractedTextFields(int id) {
        return (Map)this.extractedTextFields.get(new Integer(id));
    }

    public Map getExtractedXMLFields(int id) {
        return (Map)this.extractedXMLFields.get(new Integer(id));
    }

    public void resetExtractedTextFields(int id, Map values) {
        this.extractedTextFields.put(new Integer(id), values);
    }

    public void flushExtractedFields() {
        this.extractedTextFields.clear();
        this.extractedXMLFields.clear();
    }

    public int getPageCount() {
        return 1 + this.additionalPageCount;
    }

    public void serialiseAsObject(String fileName) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new DataOutputStream(new FileOutputStream(fileName)));
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this);
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PdfData deserialiseAsObject(String savedPage) {
        PdfData restoredObj = new PdfData();
        try {
            BufferedInputStream bos = new BufferedInputStream(new DataInputStream(new FileInputStream(savedPage)));
            ObjectInputStream in = new ObjectInputStream(bos);
            restoredObj = (PdfData)in.readObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return restoredObj;
    }

    public void serialise(String fileName) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new DataOutputStream(new FileOutputStream(fileName)));
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeInt(this.additionalPageCount);
            out.writeInt(this.originalSize);
            out.writeBoolean(this.widthIsEmbedded);
            out.writeBoolean(this.isColorExtracted);
            out.writeInt(this.pointer);
            out.writeInt(this.max);
            out.writeFloat(this.maxX);
            out.writeFloat(this.maxY);
            out.writeObject(this.f_x1);
            out.writeObject(this.f_y1);
            out.writeObject(this.f_x2);
            out.writeObject(this.f_y2);
            out.writeObject(this.lx1);
            out.writeObject(this.ly1);
            out.writeObject(this.lx2);
            out.writeObject(this.ly2);
            out.writeObject(this.contents);
            out.writeObject(this.rawData);
            out.writeObject(this.unformattedContent);
            out.writeObject(this.f_writingMode);
            out.writeObject(this.f_font_used);
            out.writeObject(this.colorTag);
            out.writeObject(this.font_data);
            out.writeObject(this.fragments);
            out.writeObject(this.text_length);
            out.writeObject(this.lineCount);
            out.writeObject(this.move_command);
            out.writeObject(this.f_character_spacing);
            out.writeObject(this.parent);
            out.writeObject(this.prefix);
            out.writeObject(this.token_counter);
            out.writeObject(this.rotation);
            out.writeObject(this.links);
            out.writeObject(this.children);
            out.writeObject(this.childrenParent);
            out.writeObject(this.category);
            out.writeObject(this.objectType);
            out.writeObject(this.f_end_font_size);
            out.writeObject(this.space_width);
            out.writeObject(this.fontSize);
            out.writeObject(this.regExpStatus);
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PdfData deserialise(String savedPage) {
        PdfData restoredObj = new PdfData();
        this.extractedTextFields.clear();
        this.extractedXMLFields.clear();
        this.text_objects.clear();
        this.globalValues.clear();
        this.globalSettings.clear();
        this.newShapes.clear();
        try {
            BufferedInputStream bos = new BufferedInputStream(new DataInputStream(new FileInputStream(savedPage)));
            ObjectInputStream in = new ObjectInputStream(bos);
            restoredObj.additionalPageCount = in.readInt();
            restoredObj.originalSize = in.readInt();
            restoredObj.widthIsEmbedded = in.readBoolean();
            restoredObj.isColorExtracted = in.readBoolean();
            restoredObj.pointer = in.readInt();
            restoredObj.max = in.readInt();
            restoredObj.maxX = in.readInt();
            restoredObj.maxY = in.readInt();
            restoredObj.f_x1 = (float[])in.readObject();
            restoredObj.f_y1 = (float[])in.readObject();
            restoredObj.f_x2 = (float[])in.readObject();
            restoredObj.f_y2 = (float[])in.readObject();
            restoredObj.lx1 = (float[])in.readObject();
            restoredObj.ly1 = (float[])in.readObject();
            restoredObj.lx2 = (float[])in.readObject();
            restoredObj.ly2 = (float[])in.readObject();
            restoredObj.contents = (String[])in.readObject();
            restoredObj.rawData = (String[])in.readObject();
            restoredObj.unformattedContent = (String[])in.readObject();
            restoredObj.f_writingMode = (int[])in.readObject();
            restoredObj.f_font_used = (String[])in.readObject();
            restoredObj.colorTag = (String[])in.readObject();
            restoredObj.font_data = (String[])in.readObject();
            restoredObj.fragments = (String[])in.readObject();
            restoredObj.text_length = (int[])in.readObject();
            restoredObj.lineCount = (int[])in.readObject();
            restoredObj.move_command = (int[])in.readObject();
            restoredObj.f_character_spacing = (float[])in.readObject();
            restoredObj.parent = (int[])in.readObject();
            restoredObj.prefix = (String[])in.readObject();
            restoredObj.token_counter = (int[])in.readObject();
            restoredObj.rotation = (int[])in.readObject();
            restoredObj.links = (Object[])in.readObject();
            restoredObj.children = (Object[])in.readObject();
            restoredObj.childrenParent = (int[])in.readObject();
            restoredObj.category = (String[])in.readObject();
            restoredObj.objectType = (int[])in.readObject();
            restoredObj.f_end_font_size = (int[])in.readObject();
            restoredObj.space_width = (float[])in.readObject();
            restoredObj.fontSize = (int[])in.readObject();
            restoredObj.regExpStatus = (int[])in.readObject();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return restoredObj;
    }

    public int getDisplacementForObject(int current_story) {
        int displacement = 0;
        int pageCount = this.itemsOnEachPage.size();
        int currentPage = 0;
        int ptReached = 0;
        if (current_story >= this.itemsOnEachPage.elementAt(0)) {
            while (currentPage < pageCount) {
                if (current_story > (ptReached += this.itemsOnEachPage.elementAt(currentPage))) break;
                ++currentPage;
            }
            displacement = this.displacementForEachPage.elementAt(currentPage);
        }
        return displacement;
    }

    public void resetTotalArea(int current_story, int head) {
        if (this.lx1 != null) {
            this.lx1[head] = this.lx1[current_story];
            this.lx2[head] = this.lx2[current_story];
            this.ly1[head] = this.ly1[current_story];
            this.ly2[head] = this.ly2[current_story];
        }
    }
}

