/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.exception.PdfException;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PageLookup;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class PdfAnnots {
    private int annotNumber = 0;
    PdfObjectReader currentPdfFile = null;
    private Hashtable fields = new Hashtable();
    private List Annots = new ArrayList();
    private Map annotArea = new Hashtable();
    private Map annotCustomIcon = new HashMap();

    public PdfAnnots(PdfObjectReader currentPdfFile, PageLookup pageLookup) {
        this.currentPdfFile = currentPdfFile;
        this.fields.put("Contents", "x");
        this.fields.put("T", "x");
        this.fields.put("Subj", "x");
        this.fields.put("V", "x");
        this.fields.put("CA", "x");
        this.fields.put("DA", "x");
        this.fields.put("DV", "x");
        this.fields.put("JS", "x");
        this.fields.put("Dest", "x");
    }

    private PdfAnnots() {
    }

    public final void readAnnots(String annots) throws PdfException {
        LogWriter.writeMethod("{pdf-readAnnots: " + annots + '}', 1);
        annots = Strip.removeArrayDeleminators(annots);
        if (annots.length() > 0) {
            try {
                if (!annots.startsWith("<<")) {
                    StringTokenizer initialValues = new StringTokenizer(annots, "R");
                    while (initialValues.hasMoreTokens()) {
                        String value = String.valueOf(initialValues.nextToken().trim()) + " R";
                        this.readAnnot(value);
                    }
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " processing annots >" + annots + '<');
                throw new PdfException("Exception");
            }
        }
    }

    public final int getAnnotCount() {
        return this.Annots.size();
    }

    public final Map getAnnotRawData(int i) {
        return (Map)this.Annots.get(i);
    }

    public final List getAnnotRawDataList() {
        return this.Annots;
    }

    public final boolean hasOwnIcon(int i) {
        return this.annotCustomIcon.get(new Integer(i)) != null;
    }

    public final String getAnnotObjectArea(int i) {
        return (String)this.annotArea.get(new Integer(i));
    }

    public final Color getAnnotColor(int i) {
        String rawCol;
        StringTokenizer colElements;
        Color annotColor = null;
        Object rawAnnot = this.Annots.get(i);
        Map annot = null;
        annot = rawAnnot instanceof String ? this.currentPdfFile.readObject((String)rawAnnot, false, null) : (Map)rawAnnot;
        String cols = (String)annot.get("C");
        if (cols != null && (colElements = new StringTokenizer(rawCol = Strip.removeArrayDeleminators(this.currentPdfFile.getValue(cols)))).countTokens() == 3) {
            float r = Float.parseFloat(colElements.nextToken());
            float g = Float.parseFloat(colElements.nextToken());
            float b = Float.parseFloat(colElements.nextToken());
            annotColor = new Color(r, g, b);
        }
        return annotColor;
    }

    public final Stroke getBorderStroke(int i) {
        int width = 0;
        Object rawAnnot = this.Annots.get(i);
        Map annot = null;
        annot = rawAnnot instanceof String ? this.currentPdfFile.readObject((String)rawAnnot, false, null) : (Map)rawAnnot;
        String cols = (String)annot.get("Border");
        if (cols != null) {
            String rawCol = Strip.removeArrayDeleminators(this.currentPdfFile.getValue(cols));
            StringTokenizer colElements = new StringTokenizer(rawCol);
            if (colElements.countTokens() == 1) {
                width = Integer.parseInt(rawCol);
            } else if (colElements.countTokens() == 3) {
                int j = 0;
                while (j < 2) {
                    colElements.nextToken();
                    ++j;
                }
                width = Integer.parseInt(colElements.nextToken());
            }
        }
        if (width == 0) {
            return null;
        }
        return new BasicStroke(width);
    }

    public final String getAnnotSubType(int i) {
        String subtype = null;
        Map currentAnnot = (Map)this.Annots.get(i);
        subtype = (String)currentAnnot.get("Subtype");
        if (subtype != null && subtype.startsWith("/")) {
            subtype = subtype.substring(1);
        }
        return subtype;
    }

    private final void readAnnot(String annot) {
        String rectString;
        LogWriter.writeMethod("{pdf-readAnnot: " + annot + '}', 1);
        Map<String, String> annotationObject = new Hashtable();
        if (annot.startsWith("<<")) {
            annotationObject = this.currentPdfFile.directValuesToMap(annot, false);
        } else {
            annotationObject = this.currentPdfFile.readObject(annot, false, this.fields);
            annotationObject.put("obj", annot);
        }
        String type = (String)annotationObject.get("Type");
        if (type == null) {
            type = "/Annot";
        }
        String subtype = (String)annotationObject.get("Subtype");
        if (annotationObject.get("AP") != null) {
            this.annotCustomIcon.put(new Integer(this.annotNumber), "x");
        }
        if ((rectString = (String)annotationObject.get("Rect")) != null) {
            String rect = Strip.removeArrayDeleminators(this.currentPdfFile.getValue(rectString));
            this.annotArea.put(new Integer(this.annotNumber), rect);
            String[] keysToSubstitute = new String[]{"A", "FS"};
            this.substituteKeyValues(this.currentPdfFile, annotationObject, keysToSubstitute);
            this.Annots.add(this.annotNumber, annotationObject);
            ++this.annotNumber;
        }
    }

    private void substituteKeyValues(PdfObjectReader currentPdfFile, Map annotationObject, String[] keysToSubstitute) {
        int count = keysToSubstitute.length;
        int j = 0;
        while (j < count) {
            try {
                Object annotObjectData = annotationObject.get(keysToSubstitute[j]);
                if (annotObjectData != null) {
                    Map actionData = null;
                    if (annotObjectData instanceof String) {
                        actionData = currentPdfFile.readObject((String)annotObjectData, false, null);
                        if (actionData.containsKey("startStreamOnDisk")) {
                            currentPdfFile.readStream((String)annotObjectData, false);
                        }
                        if (actionData.containsKey("Stream")) {
                            byte[] decompressedData = currentPdfFile.readStream(actionData, (String)annotObjectData, true, false, false, false, false);
                            actionData.put("DecodedStream", decompressedData);
                        }
                    } else {
                        actionData = (Map)annotObjectData;
                    }
                    if (actionData.containsKey("EF")) {
                        Map fileData = (Map)actionData.get("EF");
                        String[] fileSpec = new String[]{"F"};
                        this.substituteKeyValues(currentPdfFile, fileData, fileSpec);
                    }
                    annotationObject.put(keysToSubstitute[j], actionData);
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e);
            }
            ++j;
        }
    }

    public String getField(int i, String field) {
        String returnValue = null;
        Object rawAnnot = this.Annots.get(i);
        Map currentAnnot = (Map)this.currentPdfFile.resolveToMapOrString(field, rawAnnot);
        byte[] title = this.currentPdfFile.getByteTextStringValue(currentAnnot.get(field), this.fields);
        if (title != null) {
            returnValue = this.currentPdfFile.getTextString(title);
        }
        return returnValue;
    }

    public Color getBorderColor(int i) {
        String rawCol;
        StringTokenizer colElements;
        Color annotColor = Color.black;
        Object rawAnnot = this.Annots.get(i);
        Map annot = null;
        annot = rawAnnot instanceof String ? this.currentPdfFile.readObject((String)rawAnnot, false, null) : (Map)rawAnnot;
        String cols = (String)annot.get("Border");
        if (cols != null && (colElements = new StringTokenizer(rawCol = Strip.removeArrayDeleminators(this.currentPdfFile.getValue(cols)))).countTokens() == 3) {
            float r = Float.parseFloat(colElements.nextToken());
            float g = Float.parseFloat(colElements.nextToken());
            float b = Float.parseFloat(colElements.nextToken());
            annotColor = new Color(r, g, b);
        }
        return annotColor;
    }
}

