/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jpedal.color.PdfColor;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_boolean;

public class PageLines
implements Serializable {
    private int initSize = 20;
    private Vector_Int t_x1 = new Vector_Int(this.initSize);
    private Vector_Int t_x2 = new Vector_Int(this.initSize);
    private Vector_Int t_y1 = new Vector_Int(this.initSize);
    private Vector_Int t_y2 = new Vector_Int(this.initSize);
    int boxCount = 0;
    public Vector_Float box_x1 = new Vector_Float(this.initSize);
    public Vector_Float box_y1 = new Vector_Float(this.initSize);
    public Vector_Float box_x2 = new Vector_Float(this.initSize);
    public Vector_Float box_y2 = new Vector_Float(this.initSize);
    private Vector_Rectangle box_shape = new Vector_Rectangle(this.initSize);
    private Vector_Object box_col = new Vector_Object(this.initSize);
    private Vector_boolean box_isLive = new Vector_boolean(this.initSize);
    private Vector_boolean box_isComposite = new Vector_boolean(this.initSize);
    private Vector_Float v_x1 = new Vector_Float(this.initSize);
    private Vector_Float v_x2 = new Vector_Float(this.initSize);
    private Vector_Float v_y1 = new Vector_Float(this.initSize);
    private Vector_Float v_y2 = new Vector_Float(this.initSize);
    private Vector_Rectangle v_shape = new Vector_Rectangle(this.initSize);
    private Vector_Float h_x1 = new Vector_Float(this.initSize);
    private Vector_boolean h_isLive = new Vector_boolean(this.initSize);
    private Vector_Float h_x2 = new Vector_Float(this.initSize);
    private Vector_Float h_y1 = new Vector_Float(this.initSize);
    private Vector_Float h_y2 = new Vector_Float(this.initSize);
    private Vector_Float add_Hx1 = new Vector_Float(this.initSize);
    private Vector_Float add_Hx2 = new Vector_Float(this.initSize);
    private Vector_Float add_Hy1 = new Vector_Float(this.initSize);
    private Vector_Float add_Vx1 = new Vector_Float(this.initSize);
    private Vector_Float add_Vy1 = new Vector_Float(this.initSize);
    private Vector_Float add_Vy2 = new Vector_Float(this.initSize);
    private Vector_Rectangle add_box = new Vector_Rectangle(this.initSize);
    private Vector_Rectangle h_shape = new Vector_Rectangle(this.initSize);
    private float vertical_x_divide = -1.0f;
    private float vertical_y_divide = -1.0f;
    private int pageWidth;
    private int pageHeight;

    public PageLines() {
    }

    public PageLines(ObjectInputStream os) {
        try {
            this.initSize = os.readInt();
            this.vertical_x_divide = os.readFloat();
            this.vertical_y_divide = os.readFloat();
            this.pageWidth = os.readInt();
            this.pageHeight = os.readInt();
            this.boxCount = os.readInt();
            this.t_x1 = (Vector_Int)os.readObject();
            this.t_x2 = (Vector_Int)os.readObject();
            this.t_y1 = (Vector_Int)os.readObject();
            this.t_y2 = (Vector_Int)os.readObject();
            this.box_x1 = (Vector_Float)os.readObject();
            this.box_y1 = (Vector_Float)os.readObject();
            this.box_x2 = (Vector_Float)os.readObject();
            this.box_y2 = (Vector_Float)os.readObject();
            this.box_shape = (Vector_Rectangle)os.readObject();
            this.box_col = (Vector_Object)os.readObject();
            this.box_isLive = (Vector_boolean)os.readObject();
            this.box_isComposite = (Vector_boolean)os.readObject();
            this.v_x1 = (Vector_Float)os.readObject();
            this.v_x2 = (Vector_Float)os.readObject();
            this.v_y1 = (Vector_Float)os.readObject();
            this.v_y2 = (Vector_Float)os.readObject();
            this.v_shape = (Vector_Rectangle)os.readObject();
            this.h_x1 = (Vector_Float)os.readObject();
            this.h_isLive = (Vector_boolean)os.readObject();
            this.h_x2 = (Vector_Float)os.readObject();
            this.h_y1 = (Vector_Float)os.readObject();
            this.h_y2 = (Vector_Float)os.readObject();
            this.add_Hx1 = (Vector_Float)os.readObject();
            this.add_Hx2 = (Vector_Float)os.readObject();
            this.add_Hy1 = (Vector_Float)os.readObject();
            this.add_Vx1 = (Vector_Float)os.readObject();
            this.add_Vy1 = (Vector_Float)os.readObject();
            this.add_Vy2 = (Vector_Float)os.readObject();
            this.add_box = (Vector_Rectangle)os.readObject();
            this.h_shape = (Vector_Rectangle)os.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void serializeToStream(ObjectOutputStream os) {
        try {
            os.writeInt(this.initSize);
            os.writeFloat(this.vertical_x_divide);
            os.writeFloat(this.vertical_y_divide);
            os.writeInt(this.pageWidth);
            os.writeInt(this.pageHeight);
            os.writeInt(this.boxCount);
            os.writeObject(this.t_x1);
            os.writeObject(this.t_x2);
            os.writeObject(this.t_y1);
            os.writeObject(this.t_y2);
            os.writeObject(this.box_x1);
            os.writeObject(this.box_y1);
            os.writeObject(this.box_x2);
            os.writeObject(this.box_y2);
            os.writeObject(this.box_shape);
            os.writeObject(this.box_col);
            os.writeObject(this.box_isLive);
            os.writeObject(this.box_isComposite);
            os.writeObject(this.v_x1);
            os.writeObject(this.v_x2);
            os.writeObject(this.v_y1);
            os.writeObject(this.v_y2);
            os.writeObject(this.v_shape);
            os.writeObject(this.h_x1);
            os.writeObject(this.h_isLive);
            os.writeObject(this.h_x2);
            os.writeObject(this.h_y1);
            os.writeObject(this.h_y2);
            os.writeObject(this.add_Hx1);
            os.writeObject(this.add_Hx2);
            os.writeObject(this.add_Hy1);
            os.writeObject(this.add_Vx1);
            os.writeObject(this.add_Vy1);
            os.writeObject(this.add_Vy2);
            os.writeObject(this.add_box);
            os.writeObject(this.h_shape);
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final boolean testHorizontalBetween(float line_min_width, float a_x1, float a_x2, float a_y1, float a_y2, float b_x1, float b_x2, float b_y1, float b_y2) {
        float line_width_b;
        float line_width_a;
        boolean has_divide = false;
        int line_count = this.h_x1.size();
        float overlap_x1 = 0.0f;
        float overlap_x2 = 0.0f;
        float[] l_x1 = this.h_x1.get();
        float[] l_x2 = this.h_x2.get();
        float[] l_y1 = this.h_y1.get();
        float[] l_y2 = this.h_y2.get();
        boolean[] l_isLive = this.h_isLive.get();
        if (a_y2 < b_y1) {
            float temp = a_y1;
            a_y1 = b_y1;
            b_y1 = temp;
            temp = a_y2;
            a_y2 = b_y2;
            b_y2 = temp;
        }
        float line_width = (line_width_a = a_x2 - a_x1) < (line_width_b = b_x2 - b_x1) ? line_width_a : line_width_b;
        overlap_x1 = a_x1 > b_x1 ? a_x1 : b_x1;
        overlap_x2 = a_x2 < b_x2 ? a_x2 : b_x2;
        int i = 0;
        while (i < line_count) {
            if (l_isLive[i] && l_y1[i] < a_y1 | l_y2[i] > a_y2 && line_min_width == -1.0f | line_min_width > l_x2[i] - l_x1[i] && l_x2[i] - l_x1[i] > line_width && overlap_x1 >= l_x1[i] && overlap_x2 <= l_x2[i] && a_y2 > l_y1[i] && b_y1 < l_y2[i]) {
                has_divide = true;
                i = line_count;
            }
            ++i;
        }
        return has_divide;
    }

    public final boolean testLineAcrossPage(float a_x1, float a_x2, float a_y, float b_x1, float b_x2, float b_y) {
        boolean has_divide = false;
        float overlap_x1 = 0.0f;
        float overlap_x2 = 0.0f;
        float[] l_x1 = this.h_x1.get();
        float[] l_x2 = this.h_x2.get();
        float[] l_y1 = this.h_y1.get();
        float[] l_y2 = this.h_y2.get();
        boolean[] l_isLive = this.h_isLive.get();
        int line_count = l_x1.length;
        int midAx = (int)((a_x1 + a_x2) / 2.0f);
        int midBx = (int)((b_x1 + b_x2) / 2.0f);
        int i = 0;
        while (i < line_count) {
            if (l_isLive[i] && l_y1[i] < a_y && l_y2[i] > b_y && l_x2[i] - l_x1[i] >= 700.0f && l_x1[i] < (float)midAx && l_x1[i] < (float)midBx && l_x2[i] > (float)midAx && l_x2[i] > (float)midBx) {
                has_divide = true;
                i = line_count;
            }
            ++i;
        }
        return has_divide;
    }

    public final int testHorizontalBetweenLines(float a_x1, float a_x2, float a_y1, float a_y2, float b_x1, float b_x2, float b_y1, float b_y2, boolean ignoreUnderlining, float fontSize, float allowedOverlap) {
        int Ydivide = -1;
        float[] l_x1 = this.h_x1.get();
        float[] l_x2 = this.h_x2.get();
        float[] l_y1 = this.h_y1.get();
        float[] l_y2 = this.h_y2.get();
        boolean[] l_isLive = this.h_isLive.get();
        int line_count = l_x1.length;
        if (a_y2 < b_y1) {
            float temp = a_y1;
            a_y1 = b_y1;
            b_y1 = temp;
            temp = a_y2;
            a_y2 = b_y2;
            b_y2 = temp;
        }
        float topLineLength = a_x2 - a_x1;
        int midAx = (int)((a_x1 + a_x2) / 2.0f);
        int midBx = (int)((b_x1 + b_x2) / 2.0f);
        int midAY = (int)((a_y1 + a_y2) / 2.0f);
        int i = 0;
        while (i < line_count) {
            if (l_isLive[i]) {
                int lineLength = (int)(l_x2[i] - l_x1[i]);
                if (l_y1[i] < (float)midAY && l_y2[i] > b_y2 && l_x1[i] < (float)midAx && l_x1[i] < (float)midBx && l_x2[i] > (float)midAx && l_x2[i] > (float)midBx) {
                    float xDiff;
                    float lineDiff = l_x2[i] - l_x1[i] - topLineLength;
                    if (lineDiff < 0.0f) {
                        lineDiff = -lineDiff;
                    }
                    if ((xDiff = l_x1[i] - a_x1) < 0.0f) {
                        xDiff = -xDiff;
                    }
                    if (!(allowedOverlap != -1.0f && lineDiff < allowedOverlap || ignoreUnderlining && a_y1 - a_y2 > 12.0f && lineDiff < 20.0f)) {
                        Ydivide = lineLength;
                        i = line_count;
                    }
                }
            }
            ++i;
        }
        return Ydivide;
    }

    public final boolean testVerticalBetween(float a_x1, float a_x2, float a_y1, float a_y2, float b_x1, float b_x2, float b_y1, float b_y2) {
        float line_height_b;
        float line_height_a;
        this.vertical_x_divide = -1.0f;
        this.vertical_y_divide = -1.0f;
        boolean has_divide = false;
        float overlap_y1 = 0.0f;
        float[] l_x1 = this.v_x1.get();
        float[] l_x2 = this.v_x2.get();
        float[] l_y1 = this.v_y1.get();
        float[] l_y2 = this.v_y2.get();
        int line_count = l_x1.length;
        if (a_x1 > b_x1) {
            float temp = a_x1;
            a_x1 = b_x1;
            b_x1 = temp;
            temp = a_x2;
            a_x2 = b_x2;
            b_x2 = temp;
        }
        float line_height = (line_height_a = a_y1 - a_y2) < (line_height_b = b_y1 - b_y2) ? line_height_a : line_height_b;
        overlap_y1 = a_y1 > b_y1 ? b_y1 : a_y1;
        float overlap_y2 = a_y2 < b_y2 ? b_y2 : a_y2;
        int i = 0;
        while (i < line_count) {
            if (l_x1[i] < a_x1 | l_x2[i] > a_x2 && l_y1[i] - l_y2[i] > line_height && overlap_y1 < l_y1[i] && l_y2[i] < overlap_y2 && a_x2 < l_x1[i] && b_x1 > l_x2[i]) {
                has_divide = true;
                this.vertical_x_divide = l_x1[i];
                this.vertical_y_divide = l_y1[i];
                i = line_count;
            }
            ++i;
        }
        return has_divide;
    }

    public final float getVerticalLineX() {
        return this.vertical_x_divide;
    }

    public final float getVerticalLineY() {
        return this.vertical_y_divide;
    }

    public final void addVerticalLine(float x1, float y1, float x2, float y2) {
        if (y1 < y2) {
            float tmp = y1;
            y1 = y2;
            y2 = tmp;
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        this.v_x1.addElement(x1);
        this.v_x2.addElement(x2);
        this.v_y1.addElement(y1);
        this.v_y2.addElement(y2);
        this.v_shape.addElement(new Rectangle((int)x1, (int)y2, (int)(x2 - x1), (int)(y1 - y2)));
    }

    public Rectangle[] getComplexBoxes() {
        int total = 0;
        int id = 0;
        boolean[] flags = this.box_isComposite.get();
        int boxCount = flags.length;
        int count = 0;
        while (count < boxCount) {
            if (flags[count]) {
                ++total;
            }
            ++count;
        }
        Rectangle[] boxes = new Rectangle[total];
        int count2 = 0;
        while (count2 < boxCount) {
            if (flags[count2]) {
                boxes[id] = this.box_shape.elementAt(count2);
                ++id;
            }
            ++count2;
        }
        return boxes;
    }

    public final void addBox(float x1, float y1, float x2, float y2, PdfColor col) {
        float tmp;
        if (y1 < y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        if (x2 < x1) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        Rectangle rect = new Rectangle((int)x1, (int)y2, (int)(x2 - x1), (int)(y1 - y2));
        boolean used = false;
        Rectangle[] existing = this.box_shape.get();
        int ii = 0;
        while (ii < this.boxCount) {
            boolean taggedOntoBottom;
            int wDiff;
            int yDiff;
            int xDiff = existing[ii].x - rect.x;
            if (xDiff < 0) {
                xDiff = -xDiff;
            }
            if ((yDiff = existing[ii].y - rect.y) < 0) {
                yDiff = -yDiff;
            }
            if ((wDiff = existing[ii].width - rect.width) < 0) {
                wDiff = -wDiff;
            }
            boolean bl = taggedOntoBottom = yDiff < 2 && xDiff < 2 && wDiff < 2;
            if (existing[ii].contains(rect) && !taggedOntoBottom) {
                used = true;
                ii = this.boxCount;
            } else if (rect.contains(existing[ii])) {
                this.box_x1.setElementAt(x1, ii);
                this.box_x2.setElementAt(x2, ii);
                this.box_y1.setElementAt(y1, ii);
                this.box_y2.setElementAt(y2, ii);
                this.box_shape.setElementAt(rect, ii);
                this.box_isComposite.setElementAt(false, ii);
                this.box_isLive.setElementAt(true, ii);
                used = true;
                ii = this.boxCount;
            } else if (!taggedOntoBottom) {
                boolean rejectBothBigBoxes;
                int altX1 = existing[ii].getBounds().x;
                int altX2 = existing[ii].getBounds().x + existing[ii].getBounds().width;
                int altY2 = existing[ii].getBounds().y;
                int altY1 = existing[ii].getBounds().y + existing[ii].getBounds().height;
                boolean overlapsOnX = (float)altX1 <= x1 && (float)altX2 >= x1 || (float)altX1 <= x2 && (float)altX2 >= x2;
                boolean overlapsOnY = (float)altY1 >= y1 && (float)altY2 <= y1 || (float)altY1 >= y2 && (float)altY2 <= y2;
                boolean bl2 = rejectBothBigBoxes = altX2 - altX1 > 600 || x2 - x1 > 600.0f;
                if (overlapsOnX && overlapsOnY && !rejectBothBigBoxes) {
                    int xDiff1 = (int)(x1 - (float)altX1);
                    int xDiff2 = (int)(x2 - (float)altX2);
                    if (xDiff1 < 0) {
                        xDiff1 = -xDiff1;
                    }
                    if (xDiff2 < 0) {
                        xDiff2 = -xDiff2;
                    }
                    if (xDiff1 > 5 || xDiff2 > 5 || y1 - y2 > 32.0f && altY1 - altY2 > 32) {
                        this.box_isComposite.setElementAt(true, ii);
                    }
                    if (x1 > (float)altX1) {
                        x1 = altX1;
                    }
                    if (x2 < (float)altX2) {
                        x2 = altX2;
                    }
                    if (y2 > (float)altY2) {
                        y2 = altY2;
                    }
                    if (y1 < (float)altY1) {
                        y1 = altY1;
                    }
                    this.box_x1.setElementAt(x1, ii);
                    this.box_x2.setElementAt(x2, ii);
                    this.box_y1.setElementAt(y1, ii);
                    this.box_y2.setElementAt(y2, ii);
                    this.box_shape.setElementAt(new Rectangle((int)x1, (int)y2, (int)(x2 - x1), (int)(y1 - y2)), ii);
                    this.box_isLive.setElementAt(true, ii);
                    used = true;
                    ii = this.boxCount;
                }
            }
            ++ii;
        }
        if (!used) {
            this.box_x1.addElement(x1);
            this.box_x2.addElement(x2);
            this.box_y1.addElement(y1);
            this.box_y2.addElement(y2);
            this.box_shape.addElement(rect);
            this.box_col.addElement(col);
            this.box_isComposite.addElement(false);
            this.box_isLive.addElement(true);
            ++this.boxCount;
        }
    }

    private final void checkImagesBisectingBox(float[] fX1, float[] fY1, float[] fX2, float[] fY2, int[] photos) {
        int photoCount = photos.length;
        boolean[] imageUsed = new boolean[photoCount];
        int currentPhoto = 0;
        while (currentPhoto < photoCount) {
            if (!imageUsed[currentPhoto]) {
                int p = photos[currentPhoto];
                float photoX1 = fX1[p];
                float photoX2 = fX2[p];
                float photoY1 = fY1[p];
                float photoY2 = fY2[p];
                int nextPhoto = currentPhoto + 1;
                while (nextPhoto < photoCount) {
                    if (!imageUsed[nextPhoto]) {
                        int p2 = photos[nextPhoto];
                        float nphotoX1 = fX1[p2];
                        float nphotoX2 = fX2[p2];
                        float nphotoY1 = fY1[p2];
                        float nphotoY2 = fY2[p2];
                        if (nphotoX1 == photoX1 && nphotoX2 == photoX2) {
                            imageUsed[nextPhoto] = true;
                            if (nphotoY1 > photoY1) {
                                photoY1 = nphotoY1;
                            }
                            if (nphotoY2 < photoY2) {
                                photoY2 = nphotoY2;
                            }
                        } else if (nphotoY1 == photoY1 && nphotoY2 == photoY2) {
                            imageUsed[nextPhoto] = true;
                            if (nphotoX1 < photoX1) {
                                photoX1 = nphotoX1;
                            }
                            if (nphotoX2 > photoX2) {
                                photoX2 = nphotoX2;
                            }
                        }
                    }
                    ++nextPhoto;
                }
                int ii = 0;
                while (ii < this.boxCount) {
                    float dy2;
                    float dy1;
                    float dx2;
                    float oldX1 = this.box_x1.elementAt(ii);
                    float oldX2 = this.box_x2.elementAt(ii);
                    float oldY1 = this.box_y1.elementAt(ii);
                    float oldY2 = this.box_y2.elementAt(ii);
                    float dx1 = oldX1 - photoX1;
                    if (dx1 < 0.0f) {
                        dx1 = -dx1;
                    }
                    if ((dx2 = oldX2 - photoX2) < 0.0f) {
                        dx2 = -dx2;
                    }
                    if ((dy1 = oldY1 - photoY1) < 0.0f) {
                        dy1 = -dy1;
                    }
                    if ((dy2 = oldY2 - photoY2) < 0.0f) {
                        dy2 = -dy2;
                    }
                    if (dy1 < 2.0f && dy2 < 2.0f) {
                        this.box_x2.setElementAt(photoX1, ii);
                        this.box_shape.addElement(new Rectangle((int)oldX1, (int)oldY2, (int)(photoX1 - oldX1), (int)(oldY1 - oldY2)));
                        this.box_x1.addElement(photoX2);
                        this.box_x2.addElement(oldX2);
                        this.box_y1.addElement(oldY1);
                        this.box_y2.addElement(oldY2);
                        this.box_shape.addElement(new Rectangle((int)photoX2, (int)oldY2, (int)(oldX2 - photoX2), (int)(oldY1 - oldY2)));
                        this.box_col.addElement(this.box_col.elementAt(ii));
                        this.box_isLive.addElement(true);
                    }
                    ++ii;
                }
            }
            ++currentPhoto;
        }
    }

    public final void addHorizontalLine(float x1, float y1, float x2, float y2) {
        float tmp;
        if (x1 > x2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y1 < y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        this.h_x1.addElement(x1);
        this.h_x2.addElement(x2);
        this.h_y1.addElement(y1);
        this.h_y2.addElement(y2);
        this.h_shape.addElement(new Rectangle((int)x1, (int)y2, (int)(x2 - x1), (int)(y1 - y2)));
        this.h_isLive.addElement(true);
    }

    public void drawLines(Graphics2D g2) {
        try {
            Rectangle rect;
            g2.setColor(Color.red);
            int count = this.v_shape.size();
            int i = 0;
            while (i < count) {
                rect = this.v_shape.elementAt(i);
                if (rect != null) {
                    g2.draw(rect);
                }
                ++i;
            }
            count = this.h_shape.size();
            i = 0;
            while (i < count) {
                rect = this.h_shape.elementAt(i);
                if (rect != null && this.h_isLive.elementAt(i)) {
                    g2.draw(rect);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drawBoxes(Graphics2D g2) {
        try {
            Rectangle rect;
            int count = this.box_shape.size();
            int i = 0;
            while (i < count) {
                rect = this.box_shape.elementAt(i);
                if (rect != null) {
                    g2.setColor((PdfColor)this.box_col.elementAt(i));
                    g2.fill(rect);
                    g2.setColor(Color.magenta);
                    g2.draw(rect);
                    g2.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height);
                }
                ++i;
            }
            count = this.add_box.size();
            i = 0;
            while (i < count) {
                rect = this.add_box.elementAt(i);
                if (rect != null) {
                    g2.setColor(Color.lightGray);
                    g2.fill(rect);
                    g2.setColor(Color.magenta);
                    g2.draw(rect);
                    g2.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void lookForCompositeLines() {
        int[] x1 = this.t_x1.get();
        int[] y1 = this.t_y1.get();
        int[] x2 = this.t_x2.get();
        int[] y2 = this.t_y2.get();
        int count = x1.length;
        boolean debug = false;
        int current_x1 = x1[0];
        int current_y1 = y1[0];
        int current_x2 = x1[0];
        int current_y2 = y2[0];
        int matches = 3;
        int p = 1;
        while (p < count) {
            if (x1[p] != 0 || y1[p] != 0 || x2[p] != 0 || y2[p] != 0) {
                boolean onLine;
                if (debug) {
                    System.out.println(String.valueOf(p) + " Testing " + x1[p] + ' ' + y1[p] + ' ' + x2[p] + ' ' + y2[p]);
                }
                boolean bl = onLine = Math.abs(current_y1 - y1[p]) < 2;
                if (onLine && Math.abs(x1[p] - current_x2) < 10 | Math.abs(x2[p] - current_x1) < 10) {
                    if (current_x2 < x2[p]) {
                        current_x2 = x2[p];
                    } else if (current_x1 > x1[p]) {
                        current_x1 = x1[p];
                    }
                    if (debug) {
                        System.out.println("ON line");
                    }
                } else if (current_x1 != current_x2) {
                    if (current_x2 - current_x1 > 10) {
                        if (debug) {
                            System.out.println("====================Line found " + current_x1 + ' ' + current_y1 + ' ' + current_x2 + ' ' + current_y2);
                        }
                        this.addHorizontalLine(current_x1, current_y1, current_x2, current_y1);
                    } else if (debug) {
                        System.out.println("Too short " + current_x1 + ' ' + current_x2);
                    }
                    current_y1 = y1[p];
                    current_x1 = x1[p];
                    current_x2 = x1[p];
                    current_y2 = y2[p];
                } else {
                    if (debug) {
                        System.out.println("NO");
                    }
                    current_y1 = y1[p];
                    current_x1 = x1[p];
                    current_x2 = x2[p];
                    current_y2 = y2[p];
                }
            }
            ++p;
        }
        if (current_x1 != current_x2 && current_x2 - current_x1 > 50) {
            if (debug) {
                System.out.println("Line found " + current_x1 + ' ' + current_y1 + ' ' + current_x2 + ' ' + current_y2);
            }
            this.addHorizontalLine(current_x1, current_y1, current_x2, current_y1);
        }
        this.t_x1.clear();
        this.t_y1.clear();
        this.t_x2.clear();
        this.t_y2.clear();
    }

    public void addPossiblePartLine(int x1, int y1, int x2, int y2) {
        this.t_x1.addElement(x1);
        this.t_y1.addElement(y1);
        this.t_x2.addElement(x2);
        this.t_y2.addElement(y2);
    }

    public int[] getBoxIDs(float[] fX1, float[] rawfY1, float[] fX2, float[] fY2, int[] startFontSize, int[] images) {
        float fontGap;
        float boxHeight;
        int b;
        int id;
        this.checkImagesBisectingBox(fX1, rawfY1, fX2, fY2, images);
        int count = fX1.length;
        int[] boxes = new int[count];
        float[] fY1 = new float[count];
        System.arraycopy(rawfY1, 0, fY1, 0, count);
        int lastB = -1;
        float[] box_x1 = this.box_x1.get();
        float[] box_x2 = this.box_x2.get();
        float[] box_y1 = this.box_y1.get();
        float[] box_y2 = this.box_y2.get();
        boolean[] boxIsLive = this.box_isLive.get();
        int[] boxContents = new int[this.boxCount];
        int i = 0;
        while (i < count) {
            boxes[i] = -1;
            id = i;
            if (fY1[id] > (float)this.pageHeight) {
                fY1[id] = this.pageHeight;
            }
            b = 0;
            while (b < this.boxCount) {
                boxHeight = box_y1[b] - box_y2[b];
                fontGap = startFontSize[id] / 4;
                if (startFontSize[id] <= 10) {
                    fontGap = 0.0f;
                }
                if (boxIsLive[b] && fX1[id] > box_x1[b] && fX2[id] < box_x2[b] && fY1[id] - fontGap <= box_y1[b] && fY2[id] + fontGap >= box_y2[b]) {
                    int n = b;
                    boxContents[n] = boxContents[n] + 1;
                }
                ++b;
            }
            ++i;
        }
        i = 0;
        while (i < count) {
            boxes[i] = -1;
            id = i;
            b = 0;
            while (b < this.boxCount) {
                boolean isInvalid;
                boxHeight = box_y1[b] - box_y2[b];
                fontGap = startFontSize[id] / 4;
                if (startFontSize[id] <= 10) {
                    fontGap = 0.0f;
                }
                boolean fitsBox = boxIsLive[b] && fX1[id] > box_x1[b] && fX2[id] < box_x2[b] && fY1[id] - fontGap <= box_y1[b] && fY2[id] + fontGap >= box_y2[b];
                boolean singleLine = (box_y1[b] - box_y2[b]) / (float)startFontSize[id] < 2.4f;
                float x1Diff = box_x1[b] - fX1[id];
                float x2Diff = fX2[id] - box_x2[b];
                float diff = x1Diff - x2Diff;
                if (diff < 0.0f) {
                    diff = -diff;
                }
                boolean isCentred = diff < 15.0f;
                boolean bl = isInvalid = boxContents[b] < 2 || boxContents[b] == count;
                if (isInvalid && singleLine && isCentred && fitsBox && boxContents[b] == 1 && startFontSize[id] == 10) {
                    isInvalid = false;
                }
                if (!isInvalid && fitsBox) {
                    if (boxes[i] == -1) {
                        boxes[i] = b;
                        lastB = b;
                    } else {
                        float currentArea = (box_x2[lastB] - box_x1[lastB]) * (box_y1[lastB] - box_y2[lastB]);
                        float newArea = (box_x2[b] - box_x1[b]) * (box_y1[b] - box_y2[b]);
                        if (currentArea < newArea) {
                            boxes[i] = b;
                            lastB = b;
                        }
                    }
                }
                ++b;
            }
            ++i;
        }
        return boxes;
    }

    public void removeValidTextBoxes(float[] fX1, float[] fY1, float[] fX2, float[] fY2, String[] contents, int[] idx, int[] startFontSize, int defaultFontSize) {
        int count = idx.length;
        float[] box_x1 = this.box_x1.get();
        float[] box_x2 = this.box_x2.get();
        float[] box_y1 = this.box_y1.get();
        float[] box_y2 = this.box_y2.get();
        boolean[] boxIsLive = this.box_isLive.get();
        int b = 0;
        while (b < this.boxCount) {
            if (boxIsLive[b]) {
                Vector_Int stories = new Vector_Int(20);
                int boxContents = 0;
                int i = 0;
                while (i < count) {
                    int id = idx[i];
                    if (fY1[id] > (float)this.pageHeight) {
                        fY1[id] = this.pageHeight;
                    }
                    if (fX1[id] > box_x1[b] && fX2[id] < box_x2[b] && fY1[id] <= box_y1[b] && fY2[id] >= box_y2[b]) {
                        ++boxContents;
                        stories.addElement(id);
                    }
                    ++i;
                }
                if (boxContents > 2) {
                    int[] storyList = stories.get();
                    int storyCount = stories.size() - 1;
                    int matches = 0;
                    int rejections = 0;
                    int i2 = storyCount - 1;
                    while (i2 > 0) {
                        int possHead = storyList[i2];
                        int possText = storyList[i2 - 1];
                        if (startFontSize[possHead] > defaultFontSize && startFontSize[possText] < defaultFontSize && fY2[possHead] > fY1[possText] && startFontSize[possHead] > startFontSize[possText] && fY1[possHead] - fY2[possHead] < fY1[possText] - fY2[possText]) {
                            ++matches;
                            --i2;
                        } else {
                            ++rejections;
                        }
                        --i2;
                    }
                    if (matches > rejections && matches > 2 && matches > storyCount / 4) {
                        boxIsLive[b] = false;
                    }
                }
            }
            ++b;
        }
        this.box_isLive.set(boxIsLive);
    }

    public void addPossibleLineEnclosingAdvert(int x1, int x2, int y1, int y2, int w, int h) {
        int xDiff;
        int yDiff;
        int tmp;
        if (y1 < y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        if (x1 > x2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if ((yDiff = y1 - y2) < 0) {
            yDiff = -yDiff;
        }
        if ((xDiff = x1 - x2) < 0) {
            xDiff = -xDiff;
        }
        if ((float)xDiff < (float)this.pageWidth * 0.75f && (float)yDiff < (float)this.pageHeight * 0.75f && (xDiff < 4 && y2 < 1 || (x2 > this.pageWidth - 5 || x1 < 1) && yDiff < 4)) {
            if (w > h) {
                this.add_Hx1.addElement(x1);
                this.add_Hx2.addElement(x2);
                this.add_Hy1.addElement(y1);
            } else {
                this.add_Vx1.addElement(x1);
                this.add_Vy1.addElement(y1);
                this.add_Vy2.addElement(y2);
            }
        }
    }

    private void calculateAds() {
        try {
            float[] Hx1 = this.add_Hx1.get();
            float[] Hx2 = this.add_Hx2.get();
            float[] Hy1 = this.add_Hy1.get();
            float[] Vx1 = this.add_Vx1.get();
            float[] Vy2 = this.add_Vy2.get();
            float[] Vy1 = this.add_Vy1.get();
            int VLineCount = Vx1.length;
            int HLineCount = Hx1.length;
            int vLine = 0;
            while (vLine < VLineCount) {
                int HLine = 0;
                while (HLine < HLineCount) {
                    int h;
                    int w;
                    float horDiff;
                    float verticalDiff = Vx1[vLine] - Hx2[HLine];
                    if (verticalDiff < 0.0f) {
                        verticalDiff = -verticalDiff;
                    }
                    if (verticalDiff > 3.0f && (verticalDiff = Vx1[vLine] - Hx1[HLine]) < 0.0f) {
                        verticalDiff = -verticalDiff;
                    }
                    if ((horDiff = Vy1[vLine] - Hy1[HLine]) < 0.0f) {
                        horDiff = -horDiff;
                    }
                    if (verticalDiff < 3.0f && horDiff < 3.0f && (w = (int)(Hx2[HLine] - Hx1[HLine])) > 32 & (h = (int)(Vy1[vLine] - Vy2[vLine])) > 32) {
                        this.add_box.addElement(new Rectangle((int)Hx1[HLine], (int)Vy2[vLine], w, h));
                    }
                    ++HLine;
                }
                ++vLine;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Rectangle[] getAds() {
        int count = this.add_box.size() - 1;
        Rectangle[] sortedBoxes = new Rectangle[count];
        int[] size = new int[count];
        Rectangle[] rawBoxes = this.add_box.get();
        int i = 0;
        while (i < count) {
            Rectangle newRect = this.add_box.elementAt(i);
            int newSize = newRect.width * newRect.height;
            if (i == 0) {
                sortedBoxes[0] = newRect;
                size[0] = newSize;
            } else {
                int j = 0;
                while (j < count) {
                    if (size[j] < newSize) {
                        int ii = count - 1;
                        while (ii > j) {
                            sortedBoxes[ii] = sortedBoxes[ii - 1];
                            size[ii] = size[ii - 1];
                            --ii;
                        }
                        sortedBoxes[j] = newRect;
                        size[j] = newSize;
                        j = i;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return sortedBoxes;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setMaxWidth(int maxWidth, int maxHeight) {
        this.pageWidth = maxWidth;
        this.pageHeight = maxHeight;
    }

    public void calculatePageShapes() {
        this.calculateAds();
        float[] box_x1 = this.box_x1.get();
        float[] box_x2 = this.box_x2.get();
        float[] box_y1 = this.box_y1.get();
        float[] box_y2 = this.box_y2.get();
        boolean[] boxIsLive = this.box_isLive.get();
        float[] l_x1 = this.h_x1.get();
        float[] l_x2 = this.h_x2.get();
        float[] l_y1 = this.h_y1.get();
        float[] l_y2 = this.h_y2.get();
        boolean[] l_isLive = this.h_isLive.get();
        int lineCount = l_x1.length;
        int i = 0;
        while (i < this.boxCount) {
            int b = 0;
            while (b < this.boxCount) {
                if (boxIsLive[b] && i != b && box_x1[i] >= box_x1[b] && box_x2[i] <= box_x2[b] && box_y1[i] <= box_y1[b] && box_y2[i] >= box_y2[b]) {
                    boxIsLive[b] = false;
                }
                ++b;
            }
            b = 0;
            while (b < lineCount) {
                if (l_isLive[b] && l_x1[b] >= box_x1[i] && l_x2[b] <= box_x2[i] && l_y1[b] <= box_y1[i] && l_y2[b] >= box_y2[i]) {
                    l_isLive[b] = false;
                }
                ++b;
            }
            ++i;
        }
        this.box_isLive.set(boxIsLive);
        this.h_isLive.set(l_isLive);
    }
}

